/*
 * Decompiled with CFR 0.152.
 */
package GamePackage;

import GamePackage.MobileTTTCanvas;
import GamePackage.Tinee_TacToe;
import java.util.Random;

public class TicTacToe {
    int R1;
    int C1;
    boolean playerTurn;
    private String currentSymbol;
    private String[][] cell;
    private int difficulty;
    private String lastPattern;
    Random rnd = new Random(System.currentTimeMillis());
    Tinee_TacToe midlet;
    MobileTTTCanvas canvas;

    public TicTacToe() {
        this.cell = new String[3][3];
        this.setDifficulty(0);
        System.out.println("public ghfgfhfhfh tic tac toe set diff = " + this.getDifficulty());
        this.gameReset();
        this.init();
    }

    public TicTacToe(Tinee_TacToe m) {
        this.midlet = m;
        this.canvas = new MobileTTTCanvas(m);
    }

    public void init() {
        this.R1 = -1;
        this.C1 = -1;
    }

    public boolean isPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean isPlayerTurn) {
        this.playerTurn = isPlayerTurn;
    }

    public String[][] getCells() {
        return this.cell;
    }

    public String getCellSymbol(int row, int col) {
        if (row < 0 || row > 2 || col < 0 || row > 2) {
            throw new IndexOutOfBoundsException();
        }
        return this.cell[row][col];
    }

    public void setCellSymbol(int row, int col, String symbol) {
        if (row < 0 || row > 2 || col < 0 || row > 2) {
            return;
        }
        if (symbol.equals("X") || symbol.equals("O") || symbol.equals(" ")) {
            this.cell[row][col] = symbol;
        }
    }

    public String getCurrentSymbol() {
        return this.currentSymbol;
    }

    public void setCurrentSymbol(String newSymbol) {
        this.currentSymbol = newSymbol.equals("X") || newSymbol.equals("O") || newSymbol.equals(" ") ? newSymbol : " ";
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int newLevel) {
        if (newLevel < 0) {
            newLevel = 0;
        }
        this.difficulty = newLevel;
    }

    protected TicTacToe clone() {
        TicTacToe ttt = new TicTacToe();
        ttt.setPlayerTurn(this.isPlayerTurn());
        ttt.setCurrentSymbol(this.getCurrentSymbol());
        ttt.setDifficulty(this.getDifficulty());
        System.out.println("protevcted tic tac toe CLONE set diff = " + this.getDifficulty());
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                ttt.setCellSymbol(r, c, this.getCellSymbol(r, c));
            }
        }
        return ttt;
    }

    public void gameReset() {
        this.setPlayerTurn(true);
        this.setCurrentSymbol("X");
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                this.setCellSymbol(r, c, " ");
            }
        }
    }

    public boolean placeMove(int row, int col) {
        if (!this.getCellSymbol(row, col).equals(" ")) {
            return false;
        }
        this.setCellSymbol(row, col, this.getCurrentSymbol());
        this.switchSymbol();
        this.switchPlayer();
        return true;
    }

    public void switchPlayer() {
        System.out.println("player turn ========================== " + !this.isPlayerTurn());
        this.setPlayerTurn(!this.isPlayerTurn());
    }

    public void switchSymbol() {
        if (this.getCurrentSymbol().equals("X")) {
            this.setCurrentSymbol("O");
        } else {
            this.setCurrentSymbol("X");
        }
    }

    public boolean checkWin() {
        String[] symbol = new String[]{"X", "O"};
        for (int i = 0; i < 2; ++i) {
            for (int r = 0; r < 3; ++r) {
                if (!this.getCellSymbol(r, 0).equals(symbol[i]) || !this.getCellSymbol(r, 1).equals(symbol[i]) || !this.getCellSymbol(r, 2).equals(symbol[i])) continue;
                this.R1 = r;
                System.out.print(" +                      =            +      " + this.R1);
                return true;
            }
            for (int c = 0; c < 3; ++c) {
                if (!this.getCellSymbol(0, c).equals(symbol[i]) || !this.getCellSymbol(1, c).equals(symbol[i]) || !this.getCellSymbol(2, c).equals(symbol[i])) continue;
                this.C1 = c;
                System.out.print(" +      c                =            +      " + this.C1);
                return true;
            }
            if (this.getCellSymbol(0, 0).equals(symbol[i]) && this.getCellSymbol(1, 1).equals(symbol[i]) && this.getCellSymbol(2, 2).equals(symbol[i])) {
                this.R1 = 99;
                return true;
            }
            if (!this.getCellSymbol(0, 2).equals(symbol[i]) || !this.getCellSymbol(1, 1).equals(symbol[i]) || !this.getCellSymbol(2, 0).equals(symbol[i])) continue;
            this.C1 = 99;
            return true;
        }
        return false;
    }

    public boolean checkDraw() {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                if (!this.getCellSymbol(r, c).equals(" ")) continue;
                return false;
            }
        }
        return !this.checkWin();
    }

    public void computeMove() {
        int[] pos = new int[2];
        switch (this.getDifficulty()) {
            case 1: {
                pos = this.strategyNormal();
                break;
            }
            case 2: {
                pos = this.strategyPattern();
                break;
            }
            default: {
                pos = this.strategyRandom();
            }
        }
        this.placeMove(pos[0], pos[1]);
    }

    private int[] strategyRandom() {
        int r = 0;
        int c = 0;
        while (!this.getCellSymbol(r = Math.abs(this.rnd.nextInt()) % 3, c = Math.abs(this.rnd.nextInt()) % 3).equals(" ")) {
        }
        int[] randomMove = new int[]{r, c};
        return randomMove;
    }

    private int[] tryWinOrBlock() {
        TicTacToe ttt;
        int c;
        int r;
        for (r = 0; r < 3; ++r) {
            for (c = 0; c < 3; ++c) {
                if (!this.getCellSymbol(r, c).equals(" ")) continue;
                ttt = this.clone();
                ttt.placeMove(r, c);
                if (!ttt.checkWin()) continue;
                int[] pos = new int[]{r, c};
                return pos;
            }
        }
        for (r = 0; r < 3; ++r) {
            for (c = 0; c < 3; ++c) {
                if (!this.getCellSymbol(r, c).equals(" ")) continue;
                ttt = this.clone();
                ttt.switchPlayer();
                ttt.switchSymbol();
                ttt.placeMove(r, c);
                if (!ttt.checkWin()) continue;
                int[] pos = new int[]{r, c};
                return pos;
            }
        }
        return null;
    }

    private int[] getRandomCorner() {
        int[] pos = new int[2];
        int corner = Math.abs(this.rnd.nextInt()) % 4;
        switch (corner) {
            case 0: {
                pos[0] = 0;
                pos[1] = 0;
                break;
            }
            case 1: {
                pos[0] = 0;
                pos[1] = 2;
                break;
            }
            case 2: {
                pos[0] = 2;
                pos[1] = 0;
                break;
            }
            case 3: {
                pos[0] = 2;
                pos[1] = 2;
            }
        }
        return pos;
    }

    private int[] getEmptyRandomCorner() {
        if (this.getCellSymbol(0, 0).equals(" ") || this.getCellSymbol(0, 2).equals(" ") || this.getCellSymbol(2, 0).equals(" ") || this.getCellSymbol(2, 2).equals(" ")) {
            int[] pos;
            while (!this.getCellSymbol((pos = this.getRandomCorner())[0], pos[1]).equals(" ")) {
            }
            return pos;
        }
        return null;
    }

    private int[] strategyNormal() {
        int[] pos = this.tryWinOrBlock();
        if (pos != null) {
            return pos;
        }
        return this.strategyRandom();
    }

    private int getSymbolCount() {
        int count = 0;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                if (this.getCellSymbol(r, c).equals(" ")) continue;
                ++count;
            }
        }
        return count;
    }

    private String getPattern() {
        String pattern = "";
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                String symbol = this.getCellSymbol(r, c);
                pattern = symbol.equals(" ") ? pattern + "." : (symbol.equals(this.getCurrentSymbol()) ? pattern + "C" : pattern + "H");
            }
        }
        return pattern;
    }

    private int[] strategyPattern() {
        this.lastPattern = this.getPattern();
        int[] defPos = this.tryWinOrBlock();
        if (defPos != null) {
            return defPos;
        }
        int turn = this.getSymbolCount();
        switch (turn) {
            case 0: {
                return this.getRandomCorner();
            }
            case 1: {
                if (!this.getCellSymbol(1, 1).equals(" ")) {
                    return this.getRandomCorner();
                }
                int[] pos = new int[]{1, 1};
                return pos;
            }
            case 2: {
                if (this.lastPattern.equals("CH.......")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("C.H......")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("C..H.....")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C....H...")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C.....H..")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C......H.")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("C.......H")) {
                    return this.getEmptyRandomCorner();
                }
                if (this.lastPattern.equals("H.C......")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".HC......")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("..CH.....")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..C..H...")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..C...H..")) {
                    return this.getEmptyRandomCorner();
                }
                if (this.lastPattern.equals("..C....H.")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("..C.....H")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("H.....C..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".H....C..")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..H...C..")) {
                    return this.getEmptyRandomCorner();
                }
                if (this.lastPattern.equals("...H..C..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".....HC..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("......CH.")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("......C.H")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("H.......C")) {
                    return this.getEmptyRandomCorner();
                }
                if (this.lastPattern.equals(".H......C")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("..H.....C")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("...H....C")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".....H..C")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("......H.C")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".......HC")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C...H....")) {
                    int[][] pos = new int[][]{{1, 2}, {2, 1}, {2, 2}};
                    return pos[Math.abs(this.rnd.nextInt()) % 3];
                }
                if (this.lastPattern.equals("..C.H....")) {
                    int[][] pos = new int[][]{{1, 0}, {2, 0}, {2, 1}};
                    return pos[Math.abs(this.rnd.nextInt()) % 3];
                }
                if (this.lastPattern.equals("....H.C..")) {
                    int[][] pos = new int[][]{{0, 1}, {0, 2}, {1, 2}};
                    return pos[Math.abs(this.rnd.nextInt()) % 3];
                }
                if (this.lastPattern.equals("....H...C")) {
                    int[][] pos = new int[][]{{0, 0}, {0, 1}, {1, 0}};
                    return pos[Math.abs(this.rnd.nextInt()) % 3];
                }
            }
            case 3: {
                if (this.lastPattern.equals("C...H...H") || this.lastPattern.equals("H...H...C")) {
                    int[][] pos = new int[][]{{0, 2}, {2, 0}};
                    return pos[Math.abs(this.rnd.nextInt()) % 2];
                }
                if (this.lastPattern.equals("..C.H.H..") || this.lastPattern.equals("..H.H.C..")) {
                    int[][] pos = new int[][]{{0, 0}, {2, 2}};
                    return pos[Math.abs(this.rnd.nextInt()) % 2];
                }
                if (this.lastPattern.equals("H...C...H") || this.lastPattern.equals("..H.C.H..")) {
                    int[][] pos = new int[][]{{0, 1}, {1, 0}, {1, 2}, {2, 1}};
                    return pos[Math.abs(this.rnd.nextInt()) % 4];
                }
                if (this.lastPattern.equals(".H..CH...")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("....CH.H.")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".H.HC....")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("...HC..H.")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("...HCH...") || this.lastPattern.equals(".H..C..H.")) {
                    return this.getRandomCorner();
                }
                if (this.lastPattern.equals("H...C..H.")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..H.C..H.")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".H..C.H..")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".H..C...H")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("H...CH...")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("....CHH..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("..HHC....")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("...HC...H")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
            }
            case 4: {
                if (this.lastPattern.equals("CHCH.....")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("CHC..H...")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("CHC...H..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("CHC.....H")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("H.....CHC")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("..H...CHC")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("...H..CHC")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".....HCHC")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("CH.H..C..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C.HH..C..")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C..H..CH.")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("C..H..C.H")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
                if (this.lastPattern.equals("H.C..H..C")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".HC..H..C")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..C..HH.C")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("..C..H.HC")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals("CH..H..C.")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".HC.H..C.")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".C..H.CH.")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".C..H..HC")) {
                    int[] pos = new int[]{0, 2};
                    return pos;
                }
            }
            case 6: {
                if (this.lastPattern.equals("CH.HHC.C.")) {
                    int[] pos = new int[]{2, 2};
                    return pos;
                }
                if (this.lastPattern.equals(".HCCHH.C.")) {
                    int[] pos = new int[]{2, 0};
                    return pos;
                }
                if (this.lastPattern.equals(".C.CHH.HC")) {
                    int[] pos = new int[]{0, 0};
                    return pos;
                }
                if (!this.lastPattern.equals(".C.HHCCH.")) break;
                int[] pos = new int[]{0, 2};
                return pos;
            }
        }
        return this.strategyRandom();
    }
}

