/*
 * Decompiled with CFR 0.152.
 */
package digeebird;

import digeebird.BaseCanvas;
import digeebird.GameClass;
import javax.microedition.lcdui.Graphics;

public class ObjectClass {
    int P_T_M_RATIO = 1;
    double PI = 3.142857;
    int TYPE;
    int frame;
    int W;
    int H;
    int counter;
    float timeElapsed;
    float vX;
    float vY;
    float X;
    float Y;
    float pX;
    float pY;
    float lunch_x;
    float lunch_y;
    float GRAVITY;
    BaseCanvas m_pBase;
    GameClass game;
    boolean showPower;

    public ObjectClass(BaseCanvas base) {
        this.m_pBase = base;
        this.game = this.m_pBase.m_pGameClass;
    }

    public void reset(int type, int x, int y) {
        this.TYPE = type;
        x *= this.game.TW;
        y *= this.game.TH;
        this.showPower = false;
        this.counter = 0;
        switch (this.TYPE) {
            case 6: {
                if (this.game.blastAnim != null) {
                    this.W = this.game.blastAnim.getWidth() / 6;
                    this.H = this.game.blastAnim.getHeight();
                }
                this.X = x + this.game.TW / 2 - this.W / 2;
                this.Y = y + this.game.TH / 2 - this.H / 2;
                this.showPower = true;
                this.frame = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.game.tileImage != null) {
                    this.W = this.game.tileImage.getWidth() / 4;
                    this.H = this.game.tileImage.getHeight() / 4;
                }
                this.X = x + this.game.TW / 2 - this.W / 2;
                this.Y = y + this.game.TH / 2 - this.H / 2;
                this.frame = this.m_pBase.random.next(0, 3);
            }
        }
    }

    public void resetBlast(int type, int x, int y, float velocity, int theta, int direction) {
        this.TYPE = type;
        x *= this.game.TW;
        y *= this.game.TH;
        this.GRAVITY = 1.8f;
        switch (this.TYPE) {
            case 5: {
                this.GRAVITY = 0.0f;
                if (this.game.bullet != null) {
                    this.W = this.game.bullet.getWidth();
                    this.H = this.game.bullet.getHeight();
                }
                x += (this.game.TW - this.W) / 2;
                y += (this.game.TH - this.H) / 2;
                break;
            }
            default: {
                this.W = this.game.TW / 3;
                this.H = this.game.TH / 3;
            }
        }
        this.X = x;
        this.Y = y;
        this.lunch_x = x;
        this.lunch_y = y;
        this.timeElapsed = 0.0f;
        double radian = (double)theta * this.PI / 180.0;
        this.vX = (float)((double)velocity * Math.cos(radian));
        this.vY = (float)((double)velocity * Math.sin(radian));
        this.showPower = true;
    }

    void trajectory() {
        this.pX = this.X;
        this.pY = this.Y;
        this.timeElapsed += 0.4f;
        this.Y = this.lunch_y - this.vY * this.timeElapsed * (float)this.P_T_M_RATIO + this.GRAVITY * this.timeElapsed * (float)this.P_T_M_RATIO * this.timeElapsed * (float)this.P_T_M_RATIO;
        this.X = this.lunch_x + this.vX * this.timeElapsed * (float)this.P_T_M_RATIO;
        if (this.X + (float)this.game.gameX < 0.0f || this.X + (float)this.game.gameX > (float)this.m_pBase.width || this.Y + (float)this.game.gameY < 0.0f || this.Y + (float)this.game.gameY > (float)this.m_pBase.height) {
            this.showPower = false;
        }
    }

    public void paint(Graphics g) {
        try {
            switch (this.TYPE) {
                case 6: {
                    this.m_pBase.cropImage(g, this.game.blastAnim, this.W, this.H, (int)this.X + this.game.gameX, (int)this.Y + this.game.gameY, this.frame * this.W, 0);
                    break;
                }
                case 5: {
                    g.drawImage(this.game.bullet, (int)this.X + this.game.gameX, (int)this.Y + this.game.gameY, 0);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.m_pBase.cropImage(g, this.game.tileImage, this.W, this.H, (int)this.X + this.game.gameX, (int)this.Y + this.game.gameY, this.frame * this.W, (this.TYPE - 1) * this.H);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update() {
        ++this.counter;
        switch (this.TYPE) {
            case 6: {
                if (this.counter % 2 != 0) break;
                ++this.frame;
                if (this.frame <= 5) break;
                this.showPower = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.counter % 3 != 0) break;
                ++this.frame;
                if (this.frame <= 3) break;
                this.frame = 0;
            }
        }
    }
}

