/*
 * Decompiled with CFR 0.152.
 */
package digeebird;

import digeebird.BaseCanvas;
import digeebird.Level_100;
import digeebird.Level_20;
import digeebird.Level_40;
import digeebird.Level_60;
import digeebird.Level_80;
import digeebird.ObjectClass;
import digeebird.SFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameClass {
    BaseCanvas m_pBase;
    Image tileImage;
    Image bgBack;
    Image down_bar;
    Image levelComp;
    Image bullet;
    Image menuSel;
    Image menuUnSel;
    Image nextSel;
    Image nextUnSel;
    Image retrySel;
    Image retryUnSel;
    Image selection;
    Image pixel;
    Image selectionGame;
    Image scoreBack;
    Image blastAnim;
    int TW;
    int TH;
    int gameX;
    int gameY;
    int NO_OF_ROWS;
    int NO_OF_COLUMNS;
    int NO_OF_MOVES;
    int LEVEL;
    int levelCompY;
    int menuY;
    int menuW;
    int scoreX;
    int scoreY;
    int SELECT_X;
    int SELECT_Y;
    int GAME_STATE;
    int focus;
    int maxfocus;
    int LIVES;
    int SCORE;
    int STARS;
    int counter;
    int KEY_CODE;
    boolean menuPress;
    boolean nextPress;
    boolean retryPress;
    boolean hasBullet;
    boolean pressed;
    public byte[][] gameArray = null;
    Level_20 m_pLevel_20;
    Level_40 m_pLevel_40;
    Level_60 m_pLevel_60;
    Level_80 m_pLevel_80;
    Level_100 m_pLevel_100;
    Vector bulletVector;
    Vector blastVector;
    ObjectClass[][] gridArray;
    boolean hack = true;
    int li = 0;
    int pressX;
    int pressY;

    public GameClass(BaseCanvas base) {
        this.m_pBase = base;
    }

    public void initLevel(int level) {
        this.LEVEL = level;
        if (level > 80) {
            this.m_pLevel_100 = new Level_100();
        } else if (level > 60) {
            this.m_pLevel_80 = new Level_80();
        } else if (level > 40) {
            this.m_pLevel_60 = new Level_60();
        } else if (level > 20) {
            this.m_pLevel_40 = new Level_40();
        } else {
            this.m_pLevel_20 = new Level_20();
        }
        this.bulletVector = new Vector();
        this.blastVector = new Vector();
        this.hasBullet = false;
        this.LIVES = 3;
        this.loadImage();
        this.init(level);
    }

    public void init(int level) {
        System.out.println("init Start");
        this.GAME_STATE = 11;
        if (this.LIVES <= 0) {
            this.LIVES = 3;
        }
        this.SCORE = 0;
        this.STARS = 0;
        this.LEVEL = level;
        this.KEY_CODE = -11111;
        this.focus = 0;
        this.maxfocus = 2;
        this.counter = 0;
        this.SELECT_X = -1;
        this.SELECT_Y = -1;
        this.TW = 40;
        this.TH = 40;
        this.menuPress = false;
        this.nextPress = false;
        this.retryPress = false;
        this.pressed = !this.m_pBase.isTouchDevice;
        this.unloadVector();
        this.unloadGameOver();
        try {
            if (this.bgBack == null) {
                this.bgBack = Image.createImage((String)"/game_bg.jpg");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.levelCompY = 140 + this.m_pBase.DIFF_Y / 2;
        this.menuY = this.levelCompY + 70;
        this.scoreX = 58;
        this.scoreY = 15;
        this.gameX = 23;
        this.gameY = 38 + this.m_pBase.DIFF_Y / 2;
        this.loadLevel(level);
        this.GAME_STATE = 7;
        System.out.println("init End");
    }

    public void loadImage() {
        try {
            if (this.down_bar == null) {
                this.down_bar = Image.createImage((String)"/down_bar.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.tileImage == null) {
                this.tileImage = Image.createImage((String)"/maptile.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.bullet == null) {
                this.bullet = Image.createImage((String)"/ball.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.selectionGame == null) {
                this.selectionGame = Image.createImage((String)"/selection.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.scoreBack == null) {
                this.scoreBack = Image.createImage((String)"/score_bar.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.blastAnim == null) {
                this.blastAnim = Image.createImage((String)"/blast.png");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGameOver() {
        try {
            if (this.levelComp == null) {
                this.levelComp = Image.createImage((String)"/gameover.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.menuSel == null) {
                this.menuSel = Image.createImage((String)"/btn_menu_click.png");
                this.menuW = this.menuSel.getWidth();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.menuUnSel == null) {
                this.menuUnSel = Image.createImage((String)"/btn_menu_nor.png");
                this.menuW = this.menuUnSel.getWidth();
            }
        }
        catch (Exception e) {
            this.menuW = 40;
        }
        try {
            if (this.retrySel == null) {
                this.retrySel = Image.createImage((String)"/btn_reset_click.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.retryUnSel == null) {
                this.retryUnSel = Image.createImage((String)"/btn_reset_nor.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.selection == null) {
                this.selection = Image.createImage((String)"/selction.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.pixel == null) {
                this.pixel = Image.createImage((String)"/pixel.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.focus = 1;
    }

    public void loadLevelComp() {
        try {
            if (this.menuSel == null) {
                this.menuSel = Image.createImage((String)"/btn_menu_click.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.menuUnSel == null) {
                this.menuUnSel = Image.createImage((String)"/btn_menu_nor.png");
                this.menuW = this.menuUnSel.getWidth();
            }
        }
        catch (Exception e) {
            this.menuW = 40;
        }
        try {
            if (this.retrySel == null) {
                this.retrySel = Image.createImage((String)"/btn_reset_click.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.retryUnSel == null) {
                this.retryUnSel = Image.createImage((String)"/btn_reset_nor.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.selection == null) {
                this.selection = Image.createImage((String)"/selction.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.pixel == null) {
                this.pixel = Image.createImage((String)"/pixel.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.levelComp == null) {
                this.levelComp = Image.createImage((String)"/lvl_comp.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.nextSel == null) {
                this.nextSel = Image.createImage((String)"/btn_next_click.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.nextUnSel == null) {
                this.nextUnSel = Image.createImage((String)"/btn_next_nor.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_pBase.savedata.levelUnlocked < this.LEVEL) {
            this.m_pBase.savedata.levelUnlocked = this.LEVEL;
            this.m_pBase.savedata.saveParamsToDB(true);
        }
        if (this.m_pBase.savedata.bestScore[this.LEVEL - 1] < this.SCORE) {
            this.m_pBase.savedata.bestScore[this.LEVEL - 1] = this.SCORE;
            this.m_pBase.savedata.saveParamsToDB(true);
        }
        this.focus = this.LEVEL < 100 ? 2 : 1;
    }

    public void unloadGameOver() {
        this.bgBack = null;
        this.levelComp = null;
        this.menuSel = null;
        this.menuUnSel = null;
        this.retrySel = null;
        this.retryUnSel = null;
        this.selection = null;
        this.pixel = null;
        this.nextSel = null;
        this.nextUnSel = null;
        System.gc();
    }

    public void unloadImage() {
        this.unloadVector();
        this.scoreBack = null;
        this.tileImage = null;
        this.bgBack = null;
        this.bullet = null;
        this.blastAnim = null;
        this.unloadGameOver();
        this.m_pLevel_20 = null;
        this.m_pLevel_40 = null;
        this.m_pLevel_60 = null;
        this.m_pLevel_80 = null;
        this.m_pLevel_100 = null;
        this.bulletVector = null;
        this.blastVector = null;
        System.gc();
    }

    public void unloadVector() {
        ObjectClass check;
        this.gameArray = null;
        while (!this.bulletVector.isEmpty()) {
            check = (ObjectClass)this.bulletVector.lastElement();
            this.bulletVector.removeElement(check);
            check = null;
        }
        while (!this.blastVector.isEmpty()) {
            check = (ObjectClass)this.blastVector.lastElement();
            this.blastVector.removeElement(check);
            Object var1_1 = null;
        }
        System.gc();
    }

    public void loadLevel(int level) {
        int j;
        if (level > 80) {
            if (this.m_pLevel_100 == null) {
                this.m_pLevel_100 = new Level_100();
            } else {
                this.m_pLevel_20 = null;
                this.m_pLevel_40 = null;
                this.m_pLevel_60 = null;
                this.m_pLevel_80 = null;
            }
            this.gameArray = this.m_pLevel_100.getlevel(level);
        } else if (level > 60) {
            if (this.m_pLevel_80 == null) {
                this.m_pLevel_80 = new Level_80();
            } else {
                this.m_pLevel_20 = null;
                this.m_pLevel_40 = null;
                this.m_pLevel_60 = null;
                this.m_pLevel_100 = null;
            }
            this.gameArray = this.m_pLevel_80.getlevel(level);
        } else if (level > 40) {
            if (this.m_pLevel_60 == null) {
                this.m_pLevel_60 = new Level_60();
            } else {
                this.m_pLevel_20 = null;
                this.m_pLevel_40 = null;
                this.m_pLevel_80 = null;
                this.m_pLevel_100 = null;
            }
            this.gameArray = this.m_pLevel_60.getlevel(level);
        } else if (level > 20) {
            if (this.m_pLevel_40 == null) {
                this.m_pLevel_40 = new Level_40();
            } else {
                this.m_pLevel_20 = null;
                this.m_pLevel_60 = null;
                this.m_pLevel_80 = null;
                this.m_pLevel_100 = null;
            }
            this.gameArray = this.m_pLevel_40.getlevel(level);
        } else {
            if (this.m_pLevel_20 == null) {
                this.m_pLevel_20 = new Level_20();
            } else {
                this.m_pLevel_40 = null;
                this.m_pLevel_60 = null;
                this.m_pLevel_80 = null;
                this.m_pLevel_100 = null;
            }
            this.gameArray = this.m_pLevel_20.getlevel(level);
        }
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 41: 
            case 43: 
            case 69: 
            case 78: 
            case 80: 
            case 84: 
            case 90: {
                this.NO_OF_MOVES = 1;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 30: 
            case 34: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 61: 
            case 77: 
            case 81: 
            case 88: 
            case 96: {
                this.NO_OF_MOVES = 2;
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 75: 
            case 76: 
            case 79: 
            case 83: 
            case 87: 
            case 92: 
            case 98: 
            case 99: {
                this.NO_OF_MOVES = 3;
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 36: 
            case 39: 
            case 46: 
            case 59: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 82: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 97: {
                this.NO_OF_MOVES = 4;
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 47: 
            case 52: 
            case 53: 
            case 56: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 74: 
            case 94: {
                this.NO_OF_MOVES = 5;
                break;
            }
            case 21: 
            case 22: 
            case 32: 
            case 38: {
                this.NO_OF_MOVES = 6;
                break;
            }
            case 95: 
            case 100: {
                this.NO_OF_MOVES = 7;
            }
        }
        this.NO_OF_ROWS = 6;
        this.NO_OF_COLUMNS = 5;
        if (this.gridArray != null) {
            for (int i = 0; i < this.NO_OF_ROWS; ++i) {
                for (j = 0; j < this.NO_OF_COLUMNS; ++j) {
                    if (this.gridArray[i][j] == null) continue;
                    this.gridArray[i][j] = null;
                }
            }
            this.gridArray = null;
        }
        if (this.gridArray == null) {
            this.gridArray = new ObjectClass[this.NO_OF_ROWS][this.NO_OF_COLUMNS];
        }
        int y = -1;
        if (this.gameArray != null) {
            for (j = 0; j < this.NO_OF_COLUMNS; ++j) {
                block15: for (int i = 0; i < this.NO_OF_ROWS; ++i) {
                    switch (this.gameArray[i][j]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (y < i) {
                                y = i;
                            }
                            this.gridArray[i][j] = new ObjectClass(this.m_pBase);
                            this.gridArray[i][j].reset(this.gameArray[i][j], j, i);
                            if (this.SELECT_X != -1 || this.SELECT_Y != -1) continue block15;
                            this.SELECT_X = j;
                            this.SELECT_Y = i;
                        }
                    }
                }
            }
        }
        this.gameArray = null;
        System.gc();
    }

    public void paint(Graphics g) {
        try {
            this.drawImageBackground(g);
            switch (this.GAME_STATE) {
                case 7: 
                case 13: {
                    this.drawGameBoard(g);
                    this.drawBlast(g);
                    this.drawBlastAnum(g);
                    this.drawLife(g);
                    break;
                }
                case 9: {
                    this.drawGameOver(g);
                    break;
                }
                case 10: {
                    this.drawLevelComplete(g);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawLife(Graphics g) {
        g.drawImage(this.scoreBack, 0, 0, 0);
        SFont.drawString(g, "SCORE: " + this.SCORE * 75, this.scoreX, this.scoreY, 3, SFont.CFONT_HEIGHT, 3);
        SFont.drawString(g, "MOVES: " + this.NO_OF_MOVES, this.m_pBase.width - this.scoreX, this.scoreY, 3, SFont.CFONT_HEIGHT, 3);
        g.drawImage(this.down_bar, this.m_pBase.width / 2, this.m_pBase.height - this.scoreY, 3);
        SFont.drawString(g, "LEVEL: " + this.LEVEL, this.m_pBase.width / 2, this.m_pBase.height - this.scoreY, 3, SFont.CFONT_HEIGHT, 5);
    }

    public void drawGameOver(Graphics g) {
        this.maxfocus = 1;
        try {
            g.drawImage(this.levelComp, this.m_pBase.width / 2, this.levelCompY, 33);
        }
        catch (Exception e) {
            // empty catch block
        }
        SFont.drawString(g, "OUT OF MOVES", this.m_pBase.width / 2, this.levelCompY + SFont.CFONT_HEIGHT * 3 / 2, 17, SFont.CFONT_HEIGHT, 5);
        SFont.drawString(g, "OUT OF MOVES", this.m_pBase.width / 2 - 1, this.levelCompY - 1 + SFont.CFONT_HEIGHT * 3 / 2, 17, SFont.CFONT_HEIGHT, 3);
        try {
            if (this.menuPress) {
                g.drawImage(this.menuSel, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
            } else {
                g.drawImage(this.menuUnSel, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.retryPress) {
                g.drawImage(this.retrySel, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
            } else {
                g.drawImage(this.retryUnSel, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.pressed) {
                if (this.focus == 0) {
                    g.drawImage(this.selection, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
                } else if (this.focus == 1) {
                    g.drawImage(this.selection, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawLevelComplete(Graphics g) {
        try {
            g.drawImage(this.levelComp, this.m_pBase.width / 2, this.levelCompY, 33);
        }
        catch (Exception e) {
            // empty catch block
        }
        SFont.drawString(g, "BEST SCORE: " + this.m_pBase.savedata.bestScore[this.LEVEL - 1] * 75, this.m_pBase.width / 2, this.levelCompY + SFont.CFONT_HEIGHT, 17, SFont.CFONT_HEIGHT, 5);
        SFont.drawString(g, "BEST SCORE: " + this.m_pBase.savedata.bestScore[this.LEVEL - 1] * 75, this.m_pBase.width / 2 - 1, this.levelCompY - 1 + SFont.CFONT_HEIGHT, 17, SFont.CFONT_HEIGHT, 3);
        SFont.drawString(g, "SCORE: " + this.SCORE * 75, this.m_pBase.width / 2, this.levelCompY + SFont.CFONT_HEIGHT * 5 / 2, 17, SFont.CFONT_HEIGHT, 5);
        SFont.drawString(g, "SCORE: " + this.SCORE * 75, this.m_pBase.width / 2 - 1, this.levelCompY - 1 + SFont.CFONT_HEIGHT * 5 / 2, 17, SFont.CFONT_HEIGHT, 3);
        if (this.LEVEL < 100) {
            this.maxfocus = 2;
            try {
                if (this.menuPress) {
                    g.drawImage(this.menuSel, this.m_pBase.width / 2 - this.menuW * 3 / 2, this.menuY, 3);
                } else {
                    g.drawImage(this.menuUnSel, this.m_pBase.width / 2 - this.menuW * 3 / 2, this.menuY, 3);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.retryPress) {
                    g.drawImage(this.retrySel, this.m_pBase.width / 2, this.menuY, 3);
                } else {
                    g.drawImage(this.retryUnSel, this.m_pBase.width / 2, this.menuY, 3);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.nextPress) {
                    g.drawImage(this.nextSel, this.m_pBase.width / 2 + this.menuW * 3 / 2, this.menuY, 3);
                } else {
                    g.drawImage(this.nextUnSel, this.m_pBase.width / 2 + this.menuW * 3 / 2, this.menuY, 3);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.pressed) {
                    if (this.focus == 0) {
                        g.drawImage(this.selection, this.m_pBase.width / 2 - this.menuW * 3 / 2, this.menuY, 3);
                    } else if (this.focus == 1) {
                        g.drawImage(this.selection, this.m_pBase.width / 2, this.menuY, 3);
                    } else if (this.focus == 2) {
                        g.drawImage(this.selection, this.m_pBase.width / 2 + this.menuW * 3 / 2, this.menuY, 3);
                    }
                }
            }
            catch (Exception e) {}
        } else {
            this.maxfocus = 1;
            try {
                if (this.menuPress) {
                    g.drawImage(this.menuSel, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
                } else {
                    g.drawImage(this.menuUnSel, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.retryPress) {
                    g.drawImage(this.retrySel, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
                } else {
                    g.drawImage(this.retryUnSel, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.pressed) {
                    if (this.focus == 0) {
                        g.drawImage(this.selection, this.m_pBase.width / 2 - this.menuW, this.menuY, 3);
                    } else if (this.focus == 1) {
                        g.drawImage(this.selection, this.m_pBase.width / 2 + this.menuW, this.menuY, 3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.updateBlast();
        this.updateBlastAnum();
        switch (this.GAME_STATE) {
            case 7: {
                this.updateGameBoard();
                this.m_pBase.midlet.sound_play(this.GAME_STATE);
                break;
            }
            case 9: 
            case 10: {
                this.m_pBase.midlet.sound_play(this.GAME_STATE);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.pressX = x;
        this.pressY = y;
        this.pressed = false;
        this.KEY_CODE = -5;
        switch (this.GAME_STATE) {
            case 7: {
                break;
            }
            case 9: {
                if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                    this.focus = 0;
                    this.pressed = true;
                    this.keyPressed(-5);
                    break;
                }
                if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                this.focus = 1;
                this.pressed = true;
                this.keyPressed(-5);
                break;
            }
            case 10: {
                if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                if (this.LEVEL < 100) {
                    if (x >= this.m_pBase.width / 2 - this.menuW * 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW + 4) {
                        this.focus = 0;
                        this.pressed = true;
                        this.keyPressed(-5);
                        break;
                    }
                    if (x >= this.m_pBase.width / 2 - this.menuW / 2 - 4 && x <= this.m_pBase.width / 2 + this.menuW / 2 + 4) {
                        this.focus = 1;
                        this.pressed = true;
                        this.keyPressed(-5);
                        break;
                    }
                    if (x < this.m_pBase.width / 2 + this.menuW - 4 || x > this.m_pBase.width / 2 + this.menuW * 2 + 4) break;
                    this.focus = 2;
                    this.pressed = true;
                    this.keyPressed(-5);
                    break;
                }
                if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                    this.focus = 0;
                    this.pressed = true;
                    this.keyPressed(-5);
                    break;
                }
                if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                this.focus = 1;
                this.pressed = true;
                this.keyPressed(-5);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        this.menuPress = false;
        this.retryPress = false;
        this.nextPress = false;
        this.pressed = false;
        if (this.KEY_CODE == -5 && y < this.m_pBase.height - this.m_pBase.selectX * 3) {
            switch (this.GAME_STATE) {
                case 7: {
                    if (Math.abs(this.pressX - x) > Math.abs(this.pressY - y)) {
                        if (Math.abs(this.pressX - x) <= 25) break;
                        this.KEY_CODE = this.pressX <= x ? -4 : -3;
                        this.pressX = x;
                        break;
                    }
                    if (Math.abs(this.pressY - y) <= 25) break;
                    this.KEY_CODE = this.pressY <= y ? -2 : -1;
                    this.pressY = y;
                    break;
                }
                case 9: {
                    if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                    if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                        this.focus = 0;
                        this.pressed = true;
                        this.keyPressed(-5);
                        break;
                    }
                    if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                    this.focus = 1;
                    this.pressed = true;
                    this.keyPressed(-5);
                    break;
                }
                case 10: {
                    if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                    if (this.LEVEL < 100) {
                        if (x >= this.m_pBase.width / 2 - this.menuW * 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW + 4) {
                            this.focus = 0;
                            this.pressed = true;
                            this.keyPressed(-5);
                            break;
                        }
                        if (x >= this.m_pBase.width / 2 - this.menuW / 2 - 4 && x <= this.m_pBase.width / 2 + this.menuW / 2 + 4) {
                            this.focus = 1;
                            this.pressed = true;
                            this.keyPressed(-5);
                            break;
                        }
                        if (x < this.m_pBase.width / 2 + this.menuW - 4 || x > this.m_pBase.width / 2 + this.menuW * 2 + 4) break;
                        this.focus = 2;
                        this.pressed = true;
                        this.keyPressed(-5);
                        break;
                    }
                    if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                        this.focus = 0;
                        this.pressed = true;
                        this.keyPressed(-5);
                        break;
                    }
                    if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                    this.focus = 1;
                    this.pressed = true;
                    this.keyPressed(-5);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        this.menuPress = false;
        this.retryPress = false;
        this.nextPress = false;
        this.pressed = false;
        switch (this.GAME_STATE) {
            case 7: {
                int selX;
                int selY;
                if (x < this.gameX || x > this.gameX + this.NO_OF_COLUMNS * this.TW || y < this.gameY || y > this.gameY + this.NO_OF_ROWS * this.TH || this.gridArray[selY = (y - this.gameY) / this.TH][selX = (x - this.gameX) / this.TW] == null) break;
                this.SELECT_Y = selY;
                this.SELECT_X = selX;
                this.keyReleased(this.KEY_CODE);
                break;
            }
            case 9: {
                if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                    this.focus = 0;
                    this.keyReleased(-5);
                    break;
                }
                if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                this.focus = 1;
                this.keyReleased(-5);
                break;
            }
            case 10: {
                if (y < this.menuY - 4 || y > this.menuY + this.menuW + 4) break;
                if (this.LEVEL < 100) {
                    if (x >= this.m_pBase.width / 2 - this.menuW * 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW + 4) {
                        this.focus = 0;
                        this.keyReleased(-5);
                        break;
                    }
                    if (x >= this.m_pBase.width / 2 - this.menuW / 2 - 4 && x <= this.m_pBase.width / 2 + this.menuW / 2 + 4) {
                        this.focus = 1;
                        this.keyReleased(-5);
                        break;
                    }
                    if (x < this.m_pBase.width / 2 + this.menuW - 4 || x > this.m_pBase.width / 2 + this.menuW * 2 + 4) break;
                    this.focus = 2;
                    this.keyReleased(-5);
                    break;
                }
                if (x >= this.m_pBase.width / 2 - this.menuW * 3 / 2 - 4 && x <= this.m_pBase.width / 2 - this.menuW / 2 + 4) {
                    this.focus = 0;
                    this.keyReleased(-5);
                    break;
                }
                if (x < this.m_pBase.width / 2 + this.menuW / 2 - 4 || x > this.m_pBase.width / 2 + this.menuW * 3 / 2 + 4) break;
                this.focus = 1;
                this.keyReleased(-5);
            }
        }
        this.KEY_CODE = -11111;
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -5: 
            case 53: {
                block8 : switch (this.GAME_STATE) {
                    case 7: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        switch (this.focus) {
                            case 0: {
                                this.menuPress = true;
                                break block8;
                            }
                            case 1: {
                                this.retryPress = true;
                                break block8;
                            }
                            case 2: {
                                this.nextPress = true;
                            }
                        }
                    }
                }
                break;
            }
            case -6: {
                block17 : switch (this.GAME_STATE) {
                    case 7: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        switch (this.focus) {
                            case 0: {
                                this.menuPress = true;
                                break block17;
                            }
                            case 1: {
                                this.retryPress = true;
                                break block17;
                            }
                            case 2: {
                                this.nextPress = true;
                            }
                        }
                    }
                }
                break;
            }
            case -7: {
                break;
            }
            case -4: 
            case 54: {
                switch (this.GAME_STATE) {
                    case 7: {
                        this.KEY_CODE = -4;
                    }
                }
                break;
            }
            case -3: 
            case 52: {
                switch (this.GAME_STATE) {
                    case 7: {
                        this.KEY_CODE = -3;
                    }
                }
                break;
            }
            case -2: 
            case -1: 
            case 50: 
            case 56: {
                switch (this.GAME_STATE) {
                    case 7: {
                        this.KEY_CODE = -11111;
                    }
                }
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
        this.menuPress = false;
        this.retryPress = false;
        this.nextPress = false;
        this.KEY_CODE = -11111;
        switch (keyCode) {
            case -5: {
                block11 : switch (this.GAME_STATE) {
                    case 7: {
                        if (this.gridArray[this.SELECT_Y][this.SELECT_X] == null || this.gridArray[this.SELECT_Y][this.SELECT_X].TYPE != 1 || !this.bulletVector.isEmpty()) break;
                        --this.NO_OF_MOVES;
                        this.shootBall(this.SELECT_Y, this.SELECT_X);
                        break;
                    }
                    case 9: 
                    case 10: {
                        switch (this.focus) {
                            case 0: {
                                this.unloadImage();
                                this.m_pBase.loadImages();
                                this.m_pBase.m_pGridMenu.inIt();
                                if (this.GAME_STATE == 10) {
                                    this.m_pBase.m_pGridMenu.gridFocusId = this.LEVEL;
                                    if (this.m_pBase.m_pGridMenu.gridFocusId >= 100) {
                                        this.m_pBase.m_pGridMenu.gridFocusId = 99;
                                    }
                                } else {
                                    this.m_pBase.m_pGridMenu.gridFocusId = this.LEVEL - 1;
                                }
                                this.m_pBase.mState = 8;
                                break block11;
                            }
                            case 1: {
                                this.init(this.LEVEL);
                                break block11;
                            }
                            case 2: {
                                this.init(this.LEVEL + 1);
                            }
                        }
                    }
                }
                break;
            }
            case -6: {
                block20 : switch (this.GAME_STATE) {
                    case 7: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        switch (this.focus) {
                            case 0: {
                                this.unloadImage();
                                this.m_pBase.loadImages();
                                this.m_pBase.m_pGridMenu.inIt();
                                this.m_pBase.m_pGridMenu.gridFocusId = this.GAME_STATE == 10 ? this.LEVEL : this.LEVEL - 1;
                                this.m_pBase.mState = 8;
                                break block20;
                            }
                            case 1: {
                                this.init(this.LEVEL);
                                break block20;
                            }
                            case 2: {
                                this.init(this.LEVEL + 1);
                            }
                        }
                    }
                }
                break;
            }
            case -7: {
                this.unloadImage();
                this.m_pBase.loadImages();
                this.m_pBase.m_pGridMenu.inIt();
                this.m_pBase.m_pGridMenu.gridFocusId = this.LEVEL - 1;
                this.m_pBase.mState = 8;
                break;
            }
            case -4: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-4);
                        break;
                    }
                    case 9: 
                    case 10: {
                        ++this.focus;
                        if (this.focus <= this.maxfocus) break;
                        this.focus = 0;
                    }
                }
                break;
            }
            case -3: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-3);
                        break;
                    }
                    case 9: 
                    case 10: {
                        --this.focus;
                        if (this.focus >= 0) break;
                        this.focus = this.maxfocus;
                    }
                }
                break;
            }
            case 54: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-4);
                    }
                }
                break;
            }
            case 52: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-3);
                    }
                }
                break;
            }
            case -1: 
            case 50: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-1);
                    }
                }
                break;
            }
            case -2: 
            case 56: {
                switch (this.GAME_STATE) {
                    case 7: {
                        if (!this.bulletVector.isEmpty()) break;
                        this.select(-2);
                    }
                }
                break;
            }
        }
    }

    public void select(int direction) {
        block0 : switch (direction) {
            case -3: {
                int i;
                int j = this.SELECT_X - 1;
                boolean retur = false;
                for (i = this.SELECT_Y; i >= 0; --i) {
                    while (j >= 0) {
                        if (this.gridArray[i][j] != null) {
                            this.SELECT_X = j;
                            this.SELECT_Y = i;
                            retur = true;
                            break;
                        }
                        --j;
                    }
                    if (retur) break;
                    j = this.NO_OF_COLUMNS - 1;
                }
                if (retur) break;
                for (i = this.NO_OF_ROWS - 1; i >= this.SELECT_Y; --i) {
                    for (j = this.NO_OF_COLUMNS - 1; j >= 0; --j) {
                        if (this.gridArray[i][j] == null) continue;
                        this.SELECT_X = j;
                        this.SELECT_Y = i;
                        retur = true;
                        break;
                    }
                    if (retur) break block0;
                    j = this.NO_OF_COLUMNS - 1;
                }
                break;
            }
            case -4: {
                int i;
                int j = this.SELECT_X + 1;
                boolean retur = false;
                for (i = this.SELECT_Y; i < this.NO_OF_ROWS; ++i) {
                    while (j < this.NO_OF_COLUMNS) {
                        if (this.gridArray[i][j] != null) {
                            this.SELECT_X = j;
                            this.SELECT_Y = i;
                            retur = true;
                            break;
                        }
                        ++j;
                    }
                    if (retur) break;
                    j = 0;
                }
                if (retur) break;
                for (i = 0; i <= this.SELECT_Y; ++i) {
                    for (j = 0; j < this.NO_OF_COLUMNS; ++j) {
                        if (this.gridArray[i][j] == null) continue;
                        this.SELECT_X = j;
                        this.SELECT_Y = i;
                        retur = true;
                        break;
                    }
                    if (retur) break block0;
                    j = 0;
                }
                break;
            }
            case -1: {
                int j;
                int i = this.SELECT_Y - 1;
                boolean retur = false;
                for (j = this.SELECT_X; j >= 0; --j) {
                    while (i >= 0) {
                        if (this.gridArray[i][j] != null) {
                            this.SELECT_X = j;
                            this.SELECT_Y = i;
                            retur = true;
                            break;
                        }
                        --i;
                    }
                    if (retur) break;
                    i = this.NO_OF_ROWS - 1;
                }
                if (retur) break;
                for (j = this.NO_OF_COLUMNS - 1; j >= this.SELECT_X; --j) {
                    for (i = this.NO_OF_ROWS - 1; i >= 0; --i) {
                        if (this.gridArray[i][j] == null) continue;
                        this.SELECT_X = j;
                        this.SELECT_Y = i;
                        retur = true;
                        break;
                    }
                    if (retur) break block0;
                    i = this.NO_OF_ROWS - 1;
                }
                break;
            }
            case -2: {
                int j;
                int i = this.SELECT_Y + 1;
                boolean retur = false;
                for (j = this.SELECT_X; j < this.NO_OF_COLUMNS; ++j) {
                    while (i < this.NO_OF_ROWS) {
                        if (this.gridArray[i][j] != null) {
                            this.SELECT_X = j;
                            this.SELECT_Y = i;
                            retur = true;
                            break;
                        }
                        ++i;
                    }
                    if (retur) break;
                    i = 0;
                }
                if (retur) break;
                for (j = 0; j <= this.SELECT_X; ++j) {
                    for (i = 0; i < this.NO_OF_ROWS; ++i) {
                        if (this.gridArray[i][j] == null) continue;
                        this.SELECT_X = j;
                        this.SELECT_Y = i;
                        retur = true;
                        break;
                    }
                    if (retur) break block0;
                    i = 0;
                }
                break;
            }
        }
    }

    public void drawBlast(Graphics g) {
        int check = this.bulletVector.size();
        while (check > 0) {
            ObjectClass blast = (ObjectClass)this.bulletVector.elementAt(--check);
            blast.paint(g);
        }
    }

    public void drawBlastAnum(Graphics g) {
        int check = this.blastVector.size();
        while (check > 0) {
            ObjectClass blast = (ObjectClass)this.blastVector.elementAt(--check);
            blast.paint(g);
        }
    }

    public void updateBlastAnum() {
        int check = this.blastVector.size();
        while (check > 0) {
            ObjectClass blast = (ObjectClass)this.blastVector.elementAt(--check);
            if (blast.showPower) {
                blast.update();
                continue;
            }
            this.blastVector.removeElementAt(check);
            blast = null;
            break;
        }
    }

    public void updateBlast() {
        int check = this.bulletVector.size();
        while (check > 0) {
            ObjectClass blast = (ObjectClass)this.bulletVector.elementAt(--check);
            if (blast.showPower) {
                blast.trajectory();
                continue;
            }
            this.bulletVector.removeElementAt(check);
            blast = null;
            break;
        }
    }

    public void drawGameBoard(Graphics g) {
        if (this.gridArray != null) {
            for (int i = 0; i < this.NO_OF_ROWS; ++i) {
                for (int j = 0; j < this.NO_OF_COLUMNS; ++j) {
                    if (this.gridArray[i][j] == null) continue;
                    this.gridArray[i][j].paint(g);
                }
            }
            try {
                if (this.bulletVector.isEmpty() && !this.m_pBase.isTouchDevice) {
                    g.drawImage(this.selectionGame, this.gameX + this.SELECT_X * this.TW, this.gameY + this.SELECT_Y * this.TH, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateGameBoard() {
        if (this.gridArray != null) {
            int win = 0;
            for (int i = 0; i < this.NO_OF_ROWS; ++i) {
                block1: for (int j = 0; j < this.NO_OF_COLUMNS; ++j) {
                    if (this.gridArray[i][j] == null) continue;
                    this.gridArray[i][j].update();
                    ++win;
                    int check = this.bulletVector.size();
                    while (check > 0) {
                        ObjectClass power = (ObjectClass)this.bulletVector.elementAt(--check);
                        if (!this.m_pBase.rectCollide((int)this.gridArray[i][j].X + this.gridArray[i][j].W / 4, (int)this.gridArray[i][j].Y + this.gridArray[i][j].H / 4, (int)this.gridArray[i][j].X + this.gridArray[i][j].W - this.gridArray[i][j].W / 2, (int)this.gridArray[i][j].Y + this.gridArray[i][j].H - this.gridArray[i][j].H / 2, (int)power.X, (int)power.Y, (int)power.X + power.W, (int)power.Y + power.H)) continue;
                        if (this.gridArray[i][j].TYPE == 1) {
                            this.shootBall(i, j);
                        } else {
                            --this.gridArray[i][j].TYPE;
                        }
                        this.bulletVector.removeElement(power);
                        power = null;
                        continue block1;
                    }
                }
            }
            if (win == 0 && this.bulletVector.isEmpty()) {
                this.loadLevelComp();
                this.GAME_STATE = 10;
            }
            if (this.NO_OF_MOVES == 0 && this.bulletVector.isEmpty() && this.GAME_STATE != 10) {
                this.loadGameOver();
                this.GAME_STATE = 9;
            }
        }
    }

    public void drawImageBackground(Graphics g) {
        if (this.bgBack != null) {
            g.drawImage(this.bgBack, (this.m_pBase.getWidth() - this.bgBack.getWidth()) / 2, (this.m_pBase.getHeight() - this.bgBack.getHeight()) / 2, 0);
            if (this.GAME_STATE == 7) {
                g.drawImage(this.scoreBack, 0, 0, 0);
            }
        }
    }

    public void shootBall(int i, int j) {
        if (this.gridArray[i][j] != null) {
            this.gridArray[i][j] = null;
            ++this.SCORE;
            ObjectClass blastAnimat = new ObjectClass(this.m_pBase);
            blastAnimat.reset(6, j, i);
            this.blastVector.addElement(blastAnimat);
            for (int k = 0; k < 4; ++k) {
                ObjectClass blast = new ObjectClass(this.m_pBase);
                blast.resetBlast(5, j, i, this.TW / 2, k * 90, 0);
                this.bulletVector.addElement(blast);
            }
            if (i == this.SELECT_Y && j == this.SELECT_X) {
                int dir = this.m_pBase.random.next(1, 4);
                this.select(-dir);
            }
        }
    }
}

