/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class BubbleCanvas
extends Canvas
implements Runnable,
CommandListener {
    KeyCodeAdapter ka;
    int time_counter;
    boolean backClked;
    private int[][] field;
    int startX;
    int startY;
    Thread main_thread1;
    private boolean threadFlag1;
    private int fieldCol;
    private int fieldRow;
    private int cursorIndexPosX;
    private int cursorIndexPosY;
    private Vector affectedSlices = new Vector(10);
    private Vector CellSet = new Vector(20);
    private Random rand = new Random(System.currentTimeMillis());
    Image selectImg;
    Image selectclick;
    Image backImage;
    Image backClick;
    private final int RED;
    private final int GREEN;
    private final int BLUE;
    private final int PURPLE;
    private final int YELLOW;
    private final int TURQUOISE;
    private final int WHITE;
    private final int MARKED;
    public boolean initialDraw = true;
    private boolean drawWholeScreen = false;
    private boolean updateCrosshairsOnly = false;
    public boolean gameFinished = false;
    private MIDlet bubble;
    private Command backCmd;
    private Form highScoreForm;
    MiniMonsterSwipe midlet;
    GameParam param;
    int width;
    int height;
    Image board;
    Image selector;
    Image selector1;
    public Image[][] BubbleImages;
    public Image[] star;
    int scoreX = 1;
    int scoreY = 8;
    int pausey = 15;
    int selectWH = 20;
    int selectX1 = 20;
    int selectY1 = 17;
    int fontNum = 12;
    int BubbleImagesX = 12;
    int BubbleImagesY = 24;
    int cursorX = 8;
    int cursorY = 34;
    int touchMaxX = 233;
    int touchMaxY = 270;
    int watchx = 65;
    int cellWidth = 25;
    int cellHeight = 25;
    int touchMinX = 7;
    int touchMinY = 34;
    int touchMover = 10;
    int buttonHeight = 20;
    int leftButtonWidth = 90;
    int rightButtonWidth = 30;
    int bottomY = 15;
    boolean select = true;
    boolean select1;
    boolean crosshair = false;
    int starNo = -1;
    int timeCounter;
    String minuteStr;
    String Secondstr;
    int minute;
    int seconds;
    long T1;
    long T2;
    long diff;
    int LevelStartTimeSec = 300;
    boolean dis;
    private long playTime;
    int counter = 0;
    int animNum = 0;
    int starnum = 0;
    int selectedColor;
    int mark;
    int Cellcount = 0;
    int CellRemain = 0;
    int[] starX3;
    int[] starY3;
    CellBlock cell;
    boolean scoresave = false;
    int pressx;
    int pressy;
    boolean pressFlag;
    boolean dragFlag;
    int dragX;
    int dragY;
    int releasex;
    int releasey;
    public TextField textfield1;

    public BubbleCanvas(MiniMonsterSwipe pMidlet, int numOfRows, int numOfCols, GameParam gp) {
        this.RED = 0;
        this.GREEN = 1;
        this.BLUE = 2;
        this.PURPLE = 3;
        this.YELLOW = 4;
        this.TURQUOISE = 5;
        this.WHITE = 6;
        this.MARKED = 7;
        this.ka = KeyCodeAdapter.getInstance(this);
        this.midlet = pMidlet;
        this.param = gp;
        this.width = this.midlet.width;
        this.height = this.midlet.height;
        BubbleCanvas bubbleCanvas = this;
        this.main_thread1 = new Thread(this);
        this.main_thread1.start();
        this.backCmd = new Command("Back", 1, 1);
        this.setCommandListener(this);
        this.fieldRow = numOfRows;
        this.fieldCol = numOfCols;
        this.field = new int[numOfRows][numOfCols];
        this.starX3 = new int[100];
        this.starY3 = new int[100];
        this.midlet.setScreen(this);
        this.setFullScreenMode(true);
    }

    public boolean isTouchDevice() {
        return this.hasPointerEvents() && this.hasPointerMotionEvents();
    }

    void drawHeader(Graphics g) {
        String time_buff = "" + this.minuteStr + ":" + this.Secondstr;
        g.drawString("minut" + this.minuteStr, 90, 5, 0);
        g.drawString("second" + this.Secondstr, 120, 5, 0);
    }

    void show_time() {
        ++this.T2;
        if (this.LevelStartTimeSec > 0) {
            this.diff = this.T2 - this.T1;
            if (this.timeCounter == 20) {
                --this.LevelStartTimeSec;
            } else if (this.timeCounter > 20) {
                this.timeCounter = 0;
            }
            ++this.timeCounter;
            this.minute = this.LevelStartTimeSec / 60;
            this.seconds = this.LevelStartTimeSec % 60;
            this.minuteStr = this.minute > 9 ? "" + this.minute : "0" + this.minute;
            this.Secondstr = this.seconds > 9 ? "" + this.seconds : "0" + this.seconds;
            this.T1 += this.diff;
        }
    }

    protected void drawCrosshairs(Graphics g) {
        if (this.pressFlag) {
            if (this.pressx > this.cursorX && this.pressx < this.touchMaxX && this.pressy > this.cursorY && this.pressy < this.touchMaxY) {
                this.cursorIndexPosX = (this.pressx - this.touchMinX) / this.cellWidth;
                this.cursorIndexPosY = (this.pressy - this.touchMinY) / this.cellWidth;
            } else if (this.dragX > this.cursorX && this.dragX < this.touchMaxX && this.dragY > this.cursorY && this.dragY < this.touchMaxY) {
                this.cursorIndexPosX = (this.dragX - this.touchMinX) / this.cellWidth;
                this.cursorIndexPosY = (this.dragY - this.touchMinY) / this.cellWidth;
            }
            this.pressFlag = false;
        }
        int x = this.cursorIndexPosX * this.cellWidth + this.cursorX;
        int y = this.cursorIndexPosY * this.cellHeight + this.cursorY;
        if (!this.isTouchDevice()) {
            if (this.select) {
                g.drawImage(this.selector, x, y, 0);
                this.select = false;
                this.select1 = false;
            } else if (!this.select1) {
                g.drawImage(this.selector1, x, y, 0);
                this.select = true;
                this.select1 = true;
            }
        }
        if (this.mark == 7) {
            for (int i = 0; i < this.Cellcount; ++i) {
                int m = this.cellWidth * this.starX3[i] + this.cursorX;
                int n = this.cellHeight * this.starY3[i] + this.cursorY;
                g.drawImage(this.star[this.starnum], m, n, 0);
            }
            this.scoresave = true;
        }
    }

    protected void paint(Graphics g) {
        try {
            if (this.initialDraw) {
                g.drawImage(this.board, 0, 0, 0);
                for (int i = 0; i < this.fieldRow; ++i) {
                    for (int j = 0; j < this.fieldCol; ++j) {
                        this.field[i][j] = this.getRandomNumber();
                    }
                }
                this.drawWholeBoard(g);
                this.cursorIndexPosX = 0;
                this.cursorIndexPosY = 0;
                this.initialDraw = false;
            } else if (this.updateCrosshairsOnly && this.CellSet.size() > 0) {
                CellBlock crosshairCell = (CellBlock)this.CellSet.firstElement();
                this.drawField(g, crosshairCell.xval, crosshairCell.yval);
                this.CellSet.removeAllElements();
                this.updateCrosshairsOnly = false;
            } else {
                if (this.gameFinished) {
                    for (int i = 0; i < 5; ++i) {
                        if (this.param.maxscore > this.param.highscores[i]) {
                            this.dis = true;
                            break;
                        }
                        this.dis = false;
                    }
                    if (this.dis) {
                        this.playerName();
                    } else {
                        this.midlet.ShowWindow(1);
                        this.midlet.display.setCurrent((Displayable)this.midlet.mainmenu);
                    }
                    return;
                }
                if (this.drawWholeScreen) {
                    g.drawImage(this.board, 0, 0, 0);
                    this.showTime(g, this.playTime);
                    SFont.drawString(g, "Score: " + this.param.maxscore, this.scoreX, this.scoreY, 20, this.fontNum, true, false);
                    this.drawWholeBoard(g);
                } else {
                    for (int i = 0; i < this.affectedSlices.size(); ++i) {
                        for (int j = 0; j < this.fieldRow; ++j) {
                            this.drawField(g, (Integer)this.affectedSlices.elementAt(i), j);
                        }
                    }
                    this.affectedSlices.removeAllElements();
                }
            }
            if (!this.gameFinished) {
                this.drawCrosshairs(g);
            }
            if (this.backClked) {
                g.drawImage(this.backClick, this.midlet.width - this.backClick.getWidth(), this.midlet.height - this.backClick.getHeight(), 0);
            } else {
                g.drawImage(this.backImage, this.midlet.width - this.backImage.getWidth(), this.midlet.height - this.backImage.getHeight(), 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showTime(Graphics paramGraphics, long paramLong) {
        int tx = 30;
        int i = (int)paramLong;
        int j = i / 3600;
        int k = i % 3600 / 60;
        int m = i % 3600 % 60;
        int n = this.scoreY;
        int i1 = this.width - this.watchx;
        String str1 = "";
        String str2 = "";
        String str3 = "";
        String str4 = "";
        String str5 = "";
        String str6 = "";
        if (j < 10) {
            str1 = "0";
            str2 = String.valueOf(j);
        } else {
            str1 = "";
            str2 = String.valueOf(j);
        }
        if (k < 10) {
            str3 = "0";
            str4 = String.valueOf(k);
        } else {
            str3 = "";
            str4 = String.valueOf(k);
        }
        if (m < 10) {
            str5 = "0";
            str6 = String.valueOf(m);
        } else {
            str5 = "";
            str6 = String.valueOf(m);
        }
        SFont.drawString(paramGraphics, "Time:", i1 - tx, n, 20, this.fontNum, true, false);
        if (j > 9) {
            SFont.drawString(paramGraphics, " " + str2, i1, n, 20, this.fontNum, true, false);
        } else {
            SFont.drawString(paramGraphics, " " + str1, i1, n, 20, this.fontNum, true, false);
            SFont.drawString(paramGraphics, " " + str2, i1 + 8, n, 20, this.fontNum, true, false);
        }
        SFont.drawString(paramGraphics, ":", i1 + 20, n, 20, this.fontNum, true, false);
        if (k > 9) {
            SFont.drawString(paramGraphics, "" + str4, i1 + 24, n, 20, this.fontNum, true, false);
        } else {
            SFont.drawString(paramGraphics, "" + str3, i1 + 24, n, 20, this.fontNum, true, false);
            SFont.drawString(paramGraphics, "" + str4, i1 + 32, n, 20, this.fontNum, true, false);
        }
        SFont.drawString(paramGraphics, ":", i1 + 41, n, 20, this.fontNum, true, false);
        if (m > 9) {
            SFont.drawString(paramGraphics, "" + str6, i1 + 46, n, 20, this.fontNum, true, false);
        } else {
            SFont.drawString(paramGraphics, "" + str5, i1 + 46, n, 20, this.fontNum, true, false);
            SFont.drawString(paramGraphics, "" + str6, i1 + 54, n, 20, this.fontNum, true, false);
        }
    }

    private void drawWholeBoard(Graphics g) {
        for (int y = 0; y < this.fieldRow; ++y) {
            for (int x = 0; x < this.fieldCol; ++x) {
                this.drawField(g, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread cur = Thread.currentThread();
        while (cur == this.main_thread1) {
            if (this.threadFlag1) {
                ++this.time_counter;
                if (this.time_counter % 10 == 0) {
                    ++this.playTime;
                }
                ++this.counter;
                if (this.counter % 3 == 0) {
                    this.getClass();
                    if (this.mark == 7) {
                        ++this.starnum;
                        if (this.starnum > 2) {
                            int i;
                            this.starnum = 0;
                            this.updateCrosshairsOnly = true;
                            for (i = 0; i < this.Cellcount; ++i) {
                                this.field[this.starY3[i]][this.starX3[i]] = 7;
                            }
                            while (this.CellSet.size() > 0 && (this.cell = (CellBlock)this.CellSet.firstElement()) != null) {
                                int startposY;
                                this.affectedSlices.addElement(new Integer(this.cell.xval));
                                this.CellSet.removeElement(this.cell);
                                int yPosUp = startposY = this.cell.yval;
                                int yPosDown = startposY;
                                int uppermostY = startposY;
                                int lowermostY = startposY;
                                boolean sliceUpWardsInterruped = false;
                                boolean sliceDownWardsInterruped = false;
                                while (yPosDown < this.fieldRow || yPosUp >= 0) {
                                    if (--yPosUp >= 0 && this.field[yPosUp][this.cell.xval] == 7 && !sliceUpWardsInterruped) {
                                        if (this.field[yPosUp][this.cell.xval] != 7) {
                                            sliceUpWardsInterruped = true;
                                        } else {
                                            uppermostY = yPosUp;
                                            CellBlock c = new CellBlock(this.cell.xval, yPosUp);
                                            this.CellSet.removeElement(c);
                                        }
                                    } else {
                                        sliceUpWardsInterruped = true;
                                    }
                                    if (++yPosDown < this.fieldRow && this.field[yPosDown][this.cell.xval] == 7 && !sliceDownWardsInterruped) {
                                        if (this.field[yPosDown][this.cell.xval] != 7) {
                                            sliceDownWardsInterruped = true;
                                        } else {
                                            lowermostY = yPosDown;
                                            this.CellSet.removeElement(new CellBlock(this.cell.xval, yPosDown));
                                        }
                                    } else {
                                        sliceDownWardsInterruped = true;
                                    }
                                    if (!sliceUpWardsInterruped || !sliceDownWardsInterruped) continue;
                                }
                                this.multiArrayMoveSliceY(uppermostY, lowermostY, this.cell.xval);
                            }
                            this.CellSet.removeAllElements();
                            for (i = 0; i < this.fieldCol - 1; ++i) {
                                if (this.field[this.fieldCol - 1][i] != 6) continue;
                                this.moveSliceLeft(i);
                                break;
                            }
                            this.gameFinished = this.isGameFinished();
                            this.mark = 0;
                        }
                    }
                    this.animNum = 0;
                    this.getClass();
                    if (this.mark == 7) {
                        if (this.starNo > 2) {
                            this.starNo = -1;
                        }
                        ++this.starNo;
                    }
                    this.counter = 0;
                }
                try {
                    BubbleCanvas i = this;
                    synchronized (i) {
                        this.wait(100L);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.repaint();
                continue;
            }
            try {
                BubbleCanvas e = this;
                synchronized (e) {
                    this.wait();
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private void drawField(Graphics g, int ix, int iy) {
        switch (this.field[iy][ix]) {
            case 0: {
                g.setColor(255, 0, 0);
                break;
            }
            case 1: {
                g.setColor(0, 255, 0);
                break;
            }
            case 2: {
                g.setColor(0, 0, 255);
                break;
            }
            case 3: {
                g.setColor(255, 0, 255);
                break;
            }
            case 4: {
                g.setColor(255, 255, 0);
                break;
            }
            case 5: {
                g.setColor(0, 255, 255);
                break;
            }
            case 6: {
                g.setColor(255, 255, 255);
            }
        }
        int x = this.cellWidth * ix + this.cursorX;
        int y = this.cellHeight * iy + this.cursorY;
        if (this.field[iy][ix] == 6) {
            if (this.mark == 7) {
                // empty if block
            }
        } else {
            switch (this.field[iy][ix]) {
                case 0: {
                    g.drawImage(this.BubbleImages[0][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                    break;
                }
                case 1: {
                    g.drawImage(this.BubbleImages[1][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                    break;
                }
                case 2: {
                    g.drawImage(this.BubbleImages[2][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                    break;
                }
                case 3: {
                    g.drawImage(this.BubbleImages[3][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                    break;
                }
                case 4: {
                    g.drawImage(this.BubbleImages[4][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                    break;
                }
                case 5: {
                    g.drawImage(this.BubbleImages[5][this.animNum], x + this.BubbleImagesX, y + this.BubbleImagesY, 33);
                }
            }
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -7: {
                this.backClked = true;
            }
        }
    }

    public void keyReleased(int pKeyCode) {
        this.repaint();
        if (this.ka != null) {
            pKeyCode = this.ka.adoptKeyCode(pKeyCode);
        }
        try {
            if (this.gameFinished) {
                return;
            }
            if (pKeyCode == -7) {
                this.backClked = false;
                this.midlet.ShowWindow(1);
                this.midlet.display.setCurrent((Displayable)this.midlet.mainmenu);
            }
            if (pKeyCode != 53) {
                this.getClass();
                if (this.mark != 7) {
                    this.updateCrosshairsOnly = true;
                    this.CellSet.addElement(new CellBlock(this.cursorIndexPosX, this.cursorIndexPosY));
                    this.scoresave = false;
                }
            }
            if (55 != pKeyCode) {
                pKeyCode = this.getGameAction(pKeyCode);
            }
            switch (pKeyCode) {
                case -1: 
                case 1: {
                    if (this.cursorIndexPosY <= 0) break;
                    --this.cursorIndexPosY;
                    break;
                }
                case -2: 
                case 6: {
                    if (this.cursorIndexPosY >= this.fieldRow - 1) break;
                    ++this.cursorIndexPosY;
                    break;
                }
                case -3: 
                case 2: {
                    if (this.cursorIndexPosX <= 0) break;
                    --this.cursorIndexPosX;
                    break;
                }
                case -4: 
                case 5: {
                    if (this.cursorIndexPosX >= this.fieldCol - 1) break;
                    ++this.cursorIndexPosX;
                    break;
                }
                case 55: {
                    this.updateCrosshairsOnly = false;
                    this.CellSet.removeAllElements();
                    this.drawWholeScreen = true;
                    break;
                }
                case -5: 
                case 8: {
                    if (this.scoresave) break;
                    this.selectedColor = this.field[this.cursorIndexPosY][this.cursorIndexPosX];
                    if (this.selectedColor == 6) break;
                    this.Cellcount = 0;
                    this.starnum = 0;
                    this.updateCrosshairsOnly = false;
                    this.gatherColoredNeighbors(new CellBlock(this.cursorIndexPosX, this.cursorIndexPosY), this.selectedColor);
                    this.param.maxscore += this.CellSet.size() * this.CellSet.size();
                    for (int i = 0; i < this.CellSet.size(); ++i) {
                        this.cell = (CellBlock)this.CellSet.elementAt(i);
                        this.mark = 7;
                        this.starX3[i] = this.cell.xval;
                        this.starY3[i] = this.cell.yval;
                        ++this.Cellcount;
                        if (i != 0) continue;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pointerPressed(int x, int y) {
        this.pressx = x;
        this.pressy = y;
        this.startX = x;
        this.startY = y;
        this.pressFlag = true;
        if (x >= this.midlet.width - this.selectX1 * 2 && x <= this.midlet.width && y >= this.midlet.height - this.selectX1 * 3 && y <= this.midlet.height) {
            System.out.println(" press ");
            this.keyPressed(-7);
        }
        if (x >= this.BubbleImagesX && x <= this.midlet.width - this.BubbleImagesX && y >= this.BubbleImagesY && x <= this.midlet.height - this.BubbleImagesY) {
            this.updateCrosshairsOnly = true;
        }
    }

    public void keyRepeated(int keyCode) {
        int key = keyCode;
        this.keyPressed(key);
    }

    public void pointerDragged(int x, int y) {
        this.dragX = x;
        this.dragY = y;
        if (this.startX >= this.midlet.width - (this.backImage.getWidth() + this.selectWH) && this.startX <= this.midlet.width && this.startY >= this.midlet.height - this.backImage.getHeight() - this.selectWH && this.startY <= this.midlet.height) {
            System.out.println(" drag ");
            this.keyPressed(-7);
        }
    }

    public void pointerReleased(int x, int y) {
        this.releasex = x;
        this.releasey = y;
        if (x >= this.midlet.width - this.selectX1 * 2 && x <= this.midlet.width && y >= this.midlet.height - this.selectX1 * 3 && y <= this.midlet.height && this.startX == this.releasex && this.startY == this.releasey) {
            this.keyReleased(-7);
        }
        if (x >= this.BubbleImagesX && x <= this.midlet.width - this.BubbleImagesX && y >= this.BubbleImagesY && x <= this.midlet.height - this.BubbleImagesY) {
            this.updateCrosshairsOnly = false;
            this.keyReleased(-5);
            this.pressFlag = false;
        }
    }

    private void moveSliceLeft(int x) {
        try {
            int j;
            Vector slice;
            int i;
            if (x > this.fieldCol) {
                return;
            }
            Vector<Vector> storage = new Vector<Vector>(10);
            for (i = x; i < this.fieldCol; ++i) {
                slice = new Vector(10);
                for (j = 0; j < this.fieldRow; ++j) {
                    int tmp = this.field[j][i];
                    if (tmp == 6) continue;
                    slice.addElement(new CellBlock(i, j, this.field[j][i]));
                    this.field[j][i] = 6;
                }
                if (slice.size() > 0) {
                    storage.addElement(slice);
                }
                this.affectedSlices.addElement(new Integer(i));
            }
            for (i = 0; i < storage.size(); ++i) {
                slice = (Vector)storage.elementAt(i);
                for (j = 0; j < slice.size(); ++j) {
                    CellBlock c = (CellBlock)slice.elementAt(j);
                    this.field[c.yval][x + i] = c.color;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showNotify() {
        this.createImage();
        this.playTime = 0L;
        this.drawWholeScreen = true;
        try {
            this.threadFlag1 = true;
            this.midlet.playSound(2);
            BubbleCanvas bubbleCanvas = this;
            synchronized (bubbleCanvas) {
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hideNotify() {
        this.nullImages();
        this.midlet.stopSound(4);
        try {
            this.threadFlag1 = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createImage() {
        try {
            this.BubbleImages = new Image[6][3];
            for (int i = 0; i < 6; ++i) {
                this.BubbleImages[i][0] = Image.createImage((String)("/Image/" + i + "" + 0 + ".png"));
            }
            this.star = new Image[4];
            this.star[0] = Image.createImage((String)"/Image/star_A1.png");
            this.star[1] = Image.createImage((String)"/Image/star_A2.png");
            this.star[2] = Image.createImage((String)"/Image/star_A3.png");
            this.backImage = Image.createImage((String)"/back1.png");
            this.backClick = Image.createImage((String)"/back1_click.png");
            this.board = Image.createImage((String)"/Image/board.jpg");
            this.selector = Image.createImage((String)"/Image/selector.png");
            this.selector1 = Image.createImage((String)"/Image/selector1.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void nullImages() {
        int i;
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.BubbleImages[i][j] = null;
            }
        }
        this.selector = null;
        this.selector1 = null;
        for (i = 0; i < 3; ++i) {
            this.star[i] = null;
        }
        this.board = null;
        System.gc();
    }

    private void multiArrayMoveSliceY(int uppermostY, int lowermostY, int xIndex) {
        int distance = lowermostY - uppermostY + 1;
        for (int i = lowermostY; i >= 0; --i) {
            int sourceField = i - distance;
            this.field[i][xIndex] = sourceField >= 0 ? this.field[sourceField][xIndex] : 6;
        }
    }

    private void printArraySlice(int xIndex) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            sb.append(this.field[i][xIndex] + "|");
        }
    }

    public boolean isGameFinished() {
        boolean noMoreContiguousBlocks = true;
        for (int i = 0; i < this.fieldCol; ++i) {
            for (int j = 0; j < this.fieldRow; ++j) {
                if (this.field[j][i] == 6 || !this.hasNeighbors(new CellBlock(i, j, this.field[j][i]))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasNeighbors(CellBlock pCell) {
        try {
            Vector v = new Vector(10);
            if (pCell.yval > 0 && this.field[pCell.yval - 1][pCell.xval] == pCell.color) {
                return true;
            }
            if (pCell.yval < this.fieldRow && pCell.yval + 1 < this.fieldRow && this.field[pCell.yval + 1][pCell.xval] == pCell.color) {
                return true;
            }
            if (pCell.xval > 0 && this.field[pCell.yval][pCell.xval - 1] == pCell.color) {
                return true;
            }
            if (pCell.xval < this.fieldCol && pCell.xval + 1 < this.fieldCol && this.field[pCell.yval][pCell.xval + 1] == pCell.color) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void gatherColoredNeighbors(CellBlock pCell, int pColor) {
        try {
            CellBlock c;
            Vector<CellBlock> v = new Vector<CellBlock>(10);
            if (pCell.yval > 0 && this.field[pCell.yval - 1][pCell.xval] == pColor && !this.CellSet.contains(c = new CellBlock(pCell.xval, pCell.yval - 1))) {
                v.addElement(c);
                this.CellSet.addElement(c);
            }
            if (pCell.yval < this.fieldRow && pCell.yval + 1 < this.fieldRow && this.field[pCell.yval + 1][pCell.xval] == pColor && !this.CellSet.contains(c = new CellBlock(pCell.xval, pCell.yval + 1))) {
                v.addElement(c);
                this.CellSet.addElement(c);
            }
            if (pCell.xval > 0 && this.field[pCell.yval][pCell.xval - 1] == pColor && !this.CellSet.contains(c = new CellBlock(pCell.xval - 1, pCell.yval))) {
                v.addElement(c);
                this.CellSet.addElement(c);
            }
            if (pCell.xval < this.fieldCol && pCell.xval + 1 < this.fieldCol && this.field[pCell.yval][pCell.xval + 1] == pColor && !this.CellSet.contains(c = new CellBlock(pCell.xval + 1, pCell.yval))) {
                v.addElement(c);
                this.CellSet.addElement(c);
            }
            for (int i = 0; i < v.size(); ++i) {
                this.gatherColoredNeighbors((CellBlock)v.elementAt(i), pColor);
            }
            if (this.CellSet.size() == 1) {
                this.CellSet.removeAllElements();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getRandomNumber() {
        int diff = this.rand.nextInt();
        if (diff < 0) {
            diff *= -1;
        }
        return diff % 6;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fieldRow; ++i) {
            for (int j = 0; j < this.fieldCol; ++j) {
                sb.append(this.field[i][j] + " ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public TextField playerName() {
        try {
            this.highScoreForm = new Form("Enter your name");
            this.highScoreForm.append("Enter Your Name");
            this.textfield1 = new TextField("", "", 32, 0);
            this.highScoreForm.append((Item)this.textfield1);
            this.highScoreForm.addCommand(this.midlet.ok);
            this.midlet.display.setCurrent((Displayable)this.highScoreForm);
            this.highScoreForm.setCommandListener((CommandListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.textfield1;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.midlet.ok) {
            String name = this.textfield1.getString();
            if (name.length() == 0) {
                name = "Dummy";
            }
            for (int i = 0; i < 5; ++i) {
                if (this.param.maxscore < this.param.highscores[i]) continue;
                for (int j = 4; j > i; --j) {
                    this.param.highscores[j] = this.param.highscores[j - 1];
                    this.param.name[j] = this.param.name[j - 1];
                }
                this.param.highscores[i] = this.param.maxscore;
                this.param.name[i] = name;
                break;
            }
            this.textfield1.setString("");
            this.gameFinished = false;
            this.initialDraw = true;
            this.midlet.ShowWindow(1);
            this.midlet.display.setCurrent((Displayable)this.midlet.mainmenu);
        }
    }

    private class CellBlock {
        int xval;
        int yval;
        int color;

        public CellBlock(int x, int y) {
            this.xval = x;
            this.yval = y;
        }

        public CellBlock(int x, int y, int color) {
            this.xval = x;
            this.yval = y;
            this.color = color;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CellBlock)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            CellBlock c = (CellBlock)o;
            return c.xval == this.xval && c.yval == this.yval;
        }

        public String toString() {
            return "X" + this.xval + "/Y" + this.yval;
        }
    }
}

