/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

class GameParam {
    public boolean soundoff;
    public boolean vibrationoff;
    public int maxscore = 0;
    int level;
    int[][] rightBallMatrix;
    int[][] randomBallMatrix;
    int move;
    int levelCounter;
    int totalUnlockImage;
    public String[] name;
    public int[] highscores;
    boolean wallpaperImageFlag;
    boolean dbFlag;

    GameParam() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] compressToByte() {
        byte[] arr = null;
        ByteArrayOutputStream out1 = null;
        FilterOutputStream out = null;
        try {
            int i;
            out1 = new ByteArrayOutputStream();
            out = new DataOutputStream(out1);
            ((DataOutputStream)out).writeInt(this.maxscore);
            for (i = 0; i < 5; ++i) {
                ((DataOutputStream)out).writeUTF(this.name[i]);
            }
            for (i = 0; i < 5; ++i) {
                ((DataOutputStream)out).writeInt(this.highscores[i]);
            }
            arr = out1.toByteArray();
        }
        catch (Exception e) {
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                System.out.println("compressToByte1  " + e);
            }
            try {
                out1.close();
            }
            catch (Exception e) {
                System.out.println("compressToByte2  " + e);
            }
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandToVars(byte[] arr) {
        FilterInputStream in = null;
        try {
            int i;
            in = new DataInputStream(new ByteArrayInputStream(arr));
            this.maxscore = ((DataInputStream)in).readInt();
            this.name = new String[10];
            this.highscores = new int[10];
            for (i = 0; i < 5; ++i) {
                this.name[i] = ((DataInputStream)in).readUTF();
            }
            for (i = 0; i < 5; ++i) {
                this.highscores[i] = ((DataInputStream)in).readInt();
            }
        }
        catch (Exception e) {
            System.out.println("expandToVars= " + e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                System.out.println("expandToVars1= " + e);
            }
        }
    }

    private void insertData(RecordStore db, byte[] arr, int id) {
        try {
            if (this.dbFlag) {
                db.addRecord(arr, 0, arr.length);
            } else {
                db.setRecord(id, arr, 0, arr.length);
            }
        }
        catch (RecordStoreNotFoundException e2) {
            System.out.println("Ex1 in insertData for id=" + id);
        }
        catch (Exception e1) {
            System.out.println("Ex2 in insertData for id=" + id);
        }
    }

    public void saveSettings() {
        this.saveParamsToDB(false);
    }

    public void saveParamsToDB() {
        this.saveParamsToDB(true);
    }

    public void saveParamsToDB(boolean hole) {
        byte[] arr = new byte[1];
        try {
            RecordStore db = RecordStore.openRecordStore((String)"Bubble1", (boolean)true);
            int count = db.getNumRecords();
            this.dbFlag = count < 3;
            arr[0] = !this.soundoff ? (byte)1 : 0;
            this.insertData(db, arr, 1);
            arr[0] = !this.vibrationoff ? (byte)1 : 0;
            this.insertData(db, arr, 2);
            if (hole) {
                this.insertData(db, this.compressToByte(), 3);
            }
            db.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("Ex in saveDB");
        }
    }

    public void readParamsFromDB() {
        try {
            RecordStore db = RecordStore.openRecordStore((String)"Bubble1", (boolean)true);
            int count = db.getNumRecords();
            if (count < 3) {
                db.closeRecordStore();
                this.initParam();
                this.saveParamsToDB();
                return;
            }
            byte[] arr = db.getRecord(1);
            this.soundoff = arr[0] != 1;
            arr = db.getRecord(2);
            this.vibrationoff = arr[0] != 1;
            this.expandToVars(db.getRecord(3));
            db.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("Ex in read param " + e);
        }
    }

    public void defaultParam() {
    }

    public void initParam() {
        this.defaultParam();
        this.maxscore = 0;
        this.soundoff = false;
        this.vibrationoff = false;
        this.name = new String[5];
        this.highscores = new int[5];
        this.name[0] = "Sooraj";
        this.name[1] = "Manjit";
        this.name[2] = "Sonam";
        this.name[3] = "Anuja";
        this.name[4] = "Mohit";
        this.highscores[0] = 10;
        this.highscores[1] = 5;
        this.highscores[2] = 4;
        this.highscores[3] = 3;
        this.highscores[4] = 2;
    }

    public void setLevel(int level) {
    }
}

