/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Character;
import sk.inlogic.Game;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Obstacle {
    public static final int _TYPE_CIRCLE = 0;
    public static final int _TYPE_CIRCLE_SMALL = 1;
    public static final int _TYPE_CIRCLE_BIG = 2;
    public static final int _TYPE_FINISH = -1;
    public static final int _TYPE_RECT = 3;
    public static final int _TYPE_RECT_SMALL = 4;
    public static final int _TYPE_RECT_BIG = 5;
    public static final int _TYPE_CIRCLE_AND_RECT = 6;
    public static final int _TYPE_LINE = 7;
    public static final int _TYPE_CIRCLE_DOUBLE = 8;
    public static final int _TYPE_CIRCLE_TRIPPLE = 9;
    public static final int _TYPE_CIRCLE_U_D = 10;
    public static final int _TYPE_CIRCLE_L_R = 11;
    public static final int _TYPE_CIRCLE_R_L = 12;
    private boolean _bIsAlive;
    private boolean _bIsSwitcherAlive;
    private boolean _bIsStarAlive;
    private boolean _bLeft;
    private boolean _bBig;
    int _iType;
    int _iOrder;
    int _iX;
    int _iY;
    private int _iAngle = 0;
    private int _iActualPos;
    private int[] _iPosX;
    private int[] _iPosY;
    private int _WIDTH;
    private int _HEIGHT;
    private final int _SWITCER_BLUE;
    private final int _SWITCER_GREEN;
    private final int _SWITCER_RED;
    private final int _SWITCER_YELLOW;
    private final int _COLOR_BLACK;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    private final int _COLOR_NONE_TYPE;
    private final int _COLOR_BLUE_TYPE;
    private final int _COLOR_GREEN_TYPE;
    private final int _COLOR_RED_TYPE;
    private final int _COLOR_YELLOW_TYPE;
    private int _iColorType = -1;
    private int _iTotalObs = 0;
    private Game _scrGame;
    private Rectangle _rectStar;
    private Rectangle _rectColorSwitcher;
    private Rectangle _rectObstacle;
    private Rectangle _rectObstacleEmpty;
    private Rectangle[] _rectCollisions;
    private Sprite _sprStar;
    private Sprite _sprColorSwitcher;
    private Sprite _sprFinish;

    public Obstacle(Game game, int _itype, int _iorder, int _iTotal) {
        this._SWITCER_BLUE = 1;
        this._SWITCER_GREEN = 2;
        this._SWITCER_RED = 3;
        this._SWITCER_YELLOW = 4;
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._COLOR_NONE_TYPE = -1;
        this._COLOR_BLUE_TYPE = 0;
        this._COLOR_GREEN_TYPE = 1;
        this._COLOR_RED_TYPE = 2;
        this._COLOR_YELLOW_TYPE = 3;
        this._scrGame = game;
        this._iTotalObs = _iTotal;
        this._iType = _itype;
        this._iOrder = _iorder;
        this._bLeft = false;
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.initResources();
        this.calculate();
        this.createObstacle();
    }

    public Obstacle(int _itype, int _iorder) {
        this._SWITCER_BLUE = 1;
        this._SWITCER_GREEN = 2;
        this._SWITCER_RED = 3;
        this._SWITCER_YELLOW = 4;
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._COLOR_NONE_TYPE = -1;
        this._COLOR_BLUE_TYPE = 0;
        this._COLOR_GREEN_TYPE = 1;
        this._COLOR_RED_TYPE = 2;
        this._COLOR_YELLOW_TYPE = 3;
        this._iType = _itype;
        this._iOrder = _iorder;
        this._bLeft = false;
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this._WIDTH = 176;
        this._HEIGHT = 208;
        this.initResources();
        this.calculate();
    }

    private void initResources() {
        Resources.loadSprites(new int[]{78, 79, 69, 70, 71, 72, 96});
        if (Math.abs(RandomNum.getRandomInt(100, 1)) % 2 == 0) {
            this._sprStar = Resources.resSprs[78];
            this._bBig = true;
        } else {
            this._sprStar = Resources.resSprs[79];
            this._bBig = false;
        }
        this._sprFinish = Resources.resSprs[96];
        this._sprColorSwitcher = Resources.resSprs[69];
        this._bIsAlive = true;
    }

    private void calculate() {
        this.calculateObstacle();
        if (this._rectObstacle == null) {
            // empty if block
        }
        this._rectObstacleEmpty = new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), (this._rectObstacle.y + this._rectObstacle.height >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3));
        this._rectColorSwitcher = new Rectangle((MainCanvas.WIDTH >> 1) - this._sprColorSwitcher.getWidth(), this._rectObstacle.y - (this._sprColorSwitcher.getHeight() << 1) - this._sprColorSwitcher.getHeight(), this._sprColorSwitcher.getWidth() << 1, this._sprColorSwitcher.getHeight() << 1);
        if (this._iOrder < this._iTotalObs - 1) {
            this._bIsSwitcherAlive = true;
        }
        this._bIsSwitcherAlive = this._iType != -1;
        this._rectStar = new Rectangle(MainCanvas.WIDTH - this._sprStar.getWidth() >> 1, this._rectObstacle.getCenterY() - (this._sprStar.getHeight() >> 1), this._sprStar.getWidth(), this._sprStar.getHeight());
        if (this._iType != -1) {
            this._bIsStarAlive = true;
        }
    }

    private void calculateObstacle() {
        int _iPosY = 0;
        switch (this._iType) {
            case 0: {
                _iPosY = this._iOrder == 0 ? 0 - (this._WIDTH - (this._WIDTH >> 2)) >> 1 : this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._WIDTH - (this._WIDTH >> 2);
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(this._WIDTH - (this._WIDTH - (this._WIDTH >> 2) >> 1) - (this._WIDTH >> 1), _iPosY, this._WIDTH - (this._WIDTH >> 2), this._WIDTH - (this._WIDTH >> 2)) : new Rectangle((this._WIDTH - this._HEIGHT >> 1) + this._HEIGHT - (this._HEIGHT - (this._HEIGHT >> 2) >> 1) - (this._HEIGHT >> 1), _iPosY, this._HEIGHT - (this._HEIGHT >> 2), this._HEIGHT - (this._HEIGHT >> 2));
                return;
            }
            case 1: {
                _iPosY = this._iOrder == 0 ? 0 - (this._WIDTH >> 1 >> 1) : this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - (this._WIDTH >> 1);
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._WIDTH >> 2), _iPosY, this._WIDTH >> 1, this._WIDTH >> 1) : new Rectangle((this._WIDTH - this._HEIGHT >> 1) + (this._HEIGHT >> 1) - (this._HEIGHT >> 2), _iPosY, this._HEIGHT >> 1, this._HEIGHT >> 1);
                return;
            }
            case 2: {
                _iPosY = this._iOrder == 0 ? 0 - (this._WIDTH >> 1) >> 1 : this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._WIDTH;
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(0, _iPosY, this._WIDTH, this._WIDTH) : new Rectangle((this._WIDTH - this._HEIGHT >> 1) + 0, _iPosY, this._HEIGHT, this._HEIGHT);
                return;
            }
            case -1: {
                _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext();
                this._rectObstacle = new Rectangle(0, _iPosY, this._WIDTH, this._sprStar.getHeight() << 1);
                return;
            }
        }
    }

    public void ScrollDown() {
        this._rectObstacle.y += 3;
        this._rectColorSwitcher.y += 3;
        this._rectStar.y += 3;
    }

    public void ScrollUp() {
        this._rectObstacle.y -= 5;
    }

    private void createObstacle() {
        switch (this._iType) {
            default: 
        }
    }

    public void Restart() {
        this._bIsAlive = true;
    }

    public void Deactivate() {
        this._bIsAlive = false;
    }

    public void Update(long lastRunLenght, Character _char) {
        if (!this.IsAlive()) {
            return;
        }
        this.updateFinish(_char);
        this.updateSwitcher(_char);
        this.updateStar(_char);
        if (this._iType == 0) {
            this.IsCircleCollision(_char);
        } else if (this._iType == 2) {
            this.IsCircleCollision(_char);
        } else if (this._iType == 1) {
            this.IsCircleCollision(_char);
        }
        this.updateObstacle();
        this.checkAlive();
    }

    private void updateFinish(Character _r) {
        if (this._iType != -1) {
            return;
        }
        if (!this._bIsAlive) {
            return;
        }
        if (this._rectObstacle.contains(_r.GetPositionX(), _r.GetPositionY())) {
            this._scrGame.SetGameOver(true);
            this._bIsAlive = false;
        }
    }

    private void updateSwitcher(Character _r) {
        if (!this._bIsSwitcherAlive) {
            return;
        }
        if (this._rectColorSwitcher.contains(_r.GetPositionX(), _r.GetPositionY())) {
            _r.ChangeColor();
            this._bIsSwitcherAlive = false;
        }
    }

    private void updateStar(Character _r) {
        if (!this._bIsStarAlive) {
            return;
        }
        if (this._rectStar.contains(_r.GetPositionX(), _r.GetPositionY())) {
            if (!this._bBig) {
                this._scrGame.incScore(1);
            } else {
                this._scrGame.incScore(5);
            }
            this._bIsStarAlive = false;
        }
    }

    private void updateObstacle() {
        switch (this._iType) {
            case 0: {
                this.updateCirle();
                return;
            }
            case 1: {
                this.updateCircleSmall();
                return;
            }
            case 2: {
                this.updateCircleBig();
                return;
            }
            case 8: {
                this.updateCircleDouble();
                return;
            }
            case 9: {
                this.updateCircleTripple();
                return;
            }
            case 10: {
                this.updateCircleUD();
                return;
            }
            case 11: {
                this.updateCircleLR();
                return;
            }
            case 12: {
                this.updateCircleRL();
                return;
            }
            case 7: {
                this.updateLine();
                return;
            }
            case 6: {
                this.updateCitrcleAndRect();
                return;
            }
            case 3: {
                this.updateRect();
                return;
            }
            case 5: {
                this.updateRectBig();
                return;
            }
            case 4: {
                this.updateRectSmall();
                return;
            }
        }
    }

    private void updateCirle() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? ++this._iAngle : 0) : (this._iAngle < 0 ? 360 : --this._iAngle);
    }

    private void updateCircleSmall() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? ++this._iAngle : 0) : (this._iAngle < 0 ? 360 : --this._iAngle);
    }

    private void updateCircleBig() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? (this._iAngle += 2) : 0) : (this._iAngle < 0 ? 360 : (this._iAngle -= 2));
    }

    private void updateCircleDouble() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateCircleTripple() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateCircleUD() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateCircleLR() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateCircleRL() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateLine() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateCitrcleAndRect() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateRect() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateRectBig() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void updateRectSmall() {
        if (this._bLeft) {
            // empty if block
        }
    }

    private void checkAlive() {
        if (this._iY >= MainCanvas.HEIGHT) {
            this._bIsAlive = false;
        }
    }

    public void Paint(Graphics g) {
        if (!this.IsAlive()) {
            return;
        }
        this.paintObstacle(g);
        if (this.IsSwitcherAlive()) {
            this.paintColorSwither(g);
        }
        if (this.IsStarAlive()) {
            this.paintStar(g);
        }
    }

    private void paintColorSwither(Graphics g) {
        this.paintSwitcherFragment(g, Resources.resSprs[69], 1);
        this.paintSwitcherFragment(g, Resources.resSprs[70], 2);
        this.paintSwitcherFragment(g, Resources.resSprs[71], 3);
        this.paintSwitcherFragment(g, Resources.resSprs[72], 4);
    }

    private void paintSwitcherFragment(Graphics g, Sprite _sprFragment, int _iPos) {
        switch (_iPos) {
            case 1: {
                _sprFragment.setTransform(0);
                _sprFragment.setPosition(this._rectColorSwitcher.x, this._rectColorSwitcher.y);
                break;
            }
            case 2: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(2);
                _sprFragment.setPosition(this._rectColorSwitcher.x + _sprFragment.getWidth(), this._rectColorSwitcher.y);
                break;
            }
            case 3: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(3);
                _sprFragment.setPosition(this._rectColorSwitcher.x + _sprFragment.getWidth(), this._rectColorSwitcher.y + _sprFragment.getWidth());
                break;
            }
            case 4: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(1);
                _sprFragment.setPosition(this._rectColorSwitcher.x, this._rectColorSwitcher.y + _sprFragment.getWidth());
            }
        }
        _sprFragment.paint(g);
    }

    private void paintStar(Graphics g) {
        this._sprStar.setPosition(this._rectStar.x, this._rectStar.y);
        this._sprStar.paint(g);
    }

    private void paintObstacle(Graphics g) {
        switch (this._iType) {
            case 0: {
                this.paintCircle(g);
                return;
            }
            case 2: {
                this.paintCircle(g);
                return;
            }
            case 1: {
                this.paintCircle(g);
                return;
            }
            case -1: {
                this.paintFinish(g);
                return;
            }
        }
    }

    private void paintFinish(Graphics g) {
        for (int _iIdx = this._rectObstacle.x; _iIdx < this._rectObstacle.x + this._rectObstacle.width; _iIdx += this._sprFinish.getWidth()) {
            int _iIdy = this._rectObstacle.y;
            this._sprFinish.setPosition(_iIdx, _iIdy);
            this._sprFinish.paint(g);
        }
    }

    private void paintCircle(Graphics g) {
        int _iStartAngle = this.getStartAngle(0);
        g.setColor(45298);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(0), 90);
        if (_iStartAngle < 280 && _iStartAngle > 260) {
            this._iColorType = 0;
        }
        _iStartAngle = this.getStartAngle(1);
        g.setColor(46654);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(1), 90);
        if (_iStartAngle < 280 && _iStartAngle > 260) {
            this._iColorType = 1;
        }
        _iStartAngle = this.getStartAngle(2);
        g.setColor(16716619);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(2), 90);
        if (_iStartAngle < 280 && _iStartAngle > 260) {
            this._iColorType = 2;
        }
        _iStartAngle = this.getStartAngle(3);
        g.setColor(16771584);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(3), 90);
        if (_iStartAngle < 280 && _iStartAngle > 260) {
            this._iColorType = 3;
        }
        g.setColor(0);
        if (this._WIDTH < this._HEIGHT) {
            g.fillArc((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3), 0, 360);
        } else {
            g.fillArc((this._WIDTH - this._HEIGHT + this._HEIGHT >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3), 0, 360);
        }
    }

    private void paintSquare(Graphics g) {
    }

    private void paintLine(Graphics g) {
    }

    private void paintCross(Graphics g) {
    }

    private void paintRect(Graphics g) {
    }

    private int getStartAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 90 < 360 ? this._iAngle + 90 : this._iAngle + 90 - 360;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 180 < 360 ? this._iAngle + 180 : this._iAngle + 180 - 360;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 270 < 360 ? this._iAngle + 270 : this._iAngle + 270 - 360;
        }
        return _iRetVal;
    }

    public boolean IsCollisions(int _ix, int _iy) {
        if (!this.IsAlive()) {
            return false;
        }
        for (int _iIdx = 0; _iIdx < this._rectCollisions.length; ++_iIdx) {
            if (!this._rectCollisions[_iIdx].contains(_ix, _iy)) continue;
            return true;
        }
        return false;
    }

    public boolean IsCollision(Rectangle _rectCaracter) {
        if (!this.IsAlive()) {
            return false;
        }
        for (int _iIdx = 0; _iIdx < this._rectCollisions.length; ++_iIdx) {
            if (!this._rectCollisions[_iIdx].intersects(_rectCaracter)) continue;
            return true;
        }
        return false;
    }

    public boolean IsCircleCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        int _iStartAngle = this.getStartAngle(0);
        int _iColorType = 0;
        int[] _iAngles = new int[]{this.getStartAngle(0), this.getStartAngle(1), this.getStartAngle(2), this.getStartAngle(3)};
        if (_iAngles[0] < 280 && _iAngles[0] + 90 > 260) {
            _iColorType = 0;
        }
        _iStartAngle = this.getStartAngle(1);
        if (_iAngles[1] < 280 && _iAngles[1] + 90 > 260) {
            _iColorType = 1;
        }
        _iStartAngle = this.getStartAngle(2);
        if (_iAngles[2] < 280 && _iAngles[2] + 90 > 260) {
            _iColorType = 2;
        }
        _iStartAngle = this.getStartAngle(3);
        if (_iAngles[3] < 280 && _iAngles[3] + 90 > 260) {
            _iColorType = 3;
        }
        if (this._rectObstacle.contains(Char.GetPositionX(), Char.GetPositionY())) {
            Rectangle r;
            Rectangle re = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3)) : new Rectangle((this._WIDTH - this._HEIGHT + this._HEIGHT >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3));
            if (re.contains(Char.GetPositionX(), Char.GetPositionY()) && Char.GetPositionY() > this._rectObstacle.y + (this._rectObstacle.height >> 1)) {
                _iAngles = new int[]{this.getStartAngle(0), this.getStartAngle(1), this.getStartAngle(2), this.getStartAngle(3)};
                _iColorType = _iAngles[0] < 280 && _iAngles[0] + 90 > 260 ? 2 : (_iAngles[1] < 280 && _iAngles[1] + 90 > 260 ? 3 : (_iAngles[2] < 280 && _iAngles[2] + 90 > 260 ? 0 : (_iAngles[3] < 280 && _iAngles[3] + 90 > 260 ? 1 : -1)));
                if (Char.GetActualColor() != _iColorType && !(r = new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3))).contains(Char.GetPositionX(), Char.GetPositionY()) && Char.GetActualColor() != _iColorType) {
                    this._scrGame.SetGameOver(false);
                }
            }
            if (!re.contains(Char.GetPositionX(), Char.GetPositionY())) {
                if (Char.GetPositionY() < this._rectObstacle.y + (this._rectObstacle.height >> 1)) {
                    _iAngles = new int[]{this.getStartAngle(0), this.getStartAngle(1), this.getStartAngle(2), this.getStartAngle(3)};
                    _iColorType = _iAngles[0] < 280 && _iAngles[0] + 90 > 260 ? 2 : (_iAngles[1] < 280 && _iAngles[1] + 90 > 260 ? 3 : (_iAngles[2] < 280 && _iAngles[2] + 90 > 260 ? 0 : (_iAngles[3] < 280 && _iAngles[3] + 90 > 260 ? 1 : -1)));
                    if (Char.GetActualColor() != _iColorType && !(r = new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3))).contains(Char.GetPositionX(), Char.GetPositionY()) && Char.GetActualColor() != _iColorType) {
                        this._scrGame.SetGameOver(false);
                    }
                } else if (Char.GetActualColor() != _iColorType && !(r = new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3))).contains(Char.GetPositionX(), Char.GetPositionY())) {
                    this._scrGame.SetGameOver(false);
                }
            }
        }
        return false;
    }

    public boolean IsAlive() {
        return this._bIsAlive;
    }

    public boolean IsSwitcherAlive() {
        return this._bIsSwitcherAlive;
    }

    public boolean IsStarAlive() {
        return this._bIsStarAlive;
    }

    public int GetX() {
        return this._rectObstacle.x;
    }

    public int GetY() {
        return this._rectObstacle.x;
    }

    public int GetWidth() {
        return this._rectObstacle.width;
    }

    public int GetHeight() {
        return this._rectObstacle.height;
    }

    public int GetPositionForNext() {
        return this._rectColorSwitcher.y - this._rectColorSwitcher.height;
    }

    public class ObstaclesVars {
        int[] _iAngles;
        boolean[] _bLeft;
    }
}

