/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import sk.inlogic.Character;
import sk.inlogic.Levels;
import sk.inlogic.MainCanvas;
import sk.inlogic.Obstacle;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.util.Particles;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static Rectangle _rectGameArea;
    private int _iStatus;
    private int _iScore;
    private Obstacle[] _scrObstacles;
    private Character _scrCharacter;
    private Levels _lActuallevel;
    private int _iScoreInc = 0;
    private int _iScoreDelimiter = 2;
    private boolean _pressed = false;

    public Game() {
        this.init();
    }

    private void init() {
    }

    public void restartGame(Levels _levels, Rectangle _rectArea, int mode, boolean _bFirstTimePlaying, int _iSelectedCharacter) {
        this._lActuallevel = _levels;
        this.init();
        this._iStatus = 0;
        _rectGameArea = _rectArea;
        this.createWorld();
        this.createCharacter(_iSelectedCharacter);
        this._iScore = 0;
        this._iStatus = 1;
    }

    private void createWorld() {
        this._scrObstacles = new Obstacle[this._lActuallevel._iObstacles.length + 1];
        for (int _iIdx = 0; _iIdx < this._lActuallevel._iObstacles.length; ++_iIdx) {
            this._scrObstacles[_iIdx] = new Obstacle(this, this._lActuallevel._iObstacles[_iIdx], _iIdx, this._scrObstacles.length);
        }
        this._scrObstacles[this._lActuallevel._iObstacles.length] = new Obstacle(this, -1, this._lActuallevel._iObstacles.length, this._scrObstacles.length);
    }

    private void createCharacter(int _iSelectedCharacter) {
        this._scrCharacter = new Character(this, _iSelectedCharacter);
    }

    public void update(long lastRunLenght) {
        int _iIdx;
        for (_iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
            this._scrObstacles[_iIdx].Update(lastRunLenght, this._scrCharacter);
        }
        this._scrCharacter.Update(lastRunLenght);
        if (this._scrCharacter.GetPositionY() < MainCanvas.HEIGHT >> 1) {
            for (_iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
                this._scrObstacles[_iIdx].Update(lastRunLenght, this._scrCharacter);
                this._scrObstacles[_iIdx].ScrollDown();
            }
        }
        Particles.update();
        this.updateScore();
    }

    private void updateScore() {
        if (this._iScoreInc <= 0) {
            return;
        }
        if (this._iScoreInc > 0) {
            if (this._iScoreInc % this._iScoreDelimiter == 0) {
                this.incScoreLocal(this._iScoreInc / this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc / this._iScoreDelimiter;
            } else {
                this.incScoreLocal(this._iScoreInc % this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc % this._iScoreDelimiter;
            }
        }
    }

    public void incScore(int _iValue) {
        this._iScoreInc += _iValue;
    }

    private void incScoreLocal(int _iValue) {
        this._iScore += _iValue;
    }

    public void paint(Graphics g, int status) {
        this.paintObstacles(g);
        this.paintCharacter(g);
    }

    private void paintObstacles(Graphics g) {
        for (int _iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
            this._scrObstacles[_iIdx].Paint(g);
        }
    }

    private void paintCharacter(Graphics g) {
        this._scrCharacter.Paint(g);
    }

    public void releaaseControls() {
        this._pressed = false;
    }

    public void pointerPressed(int x, int y) {
        if (!this._pressed) {
            this._pressed = true;
            this.Jump();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this._pressed = false;
        }
    }

    public void Jump() {
        this._scrCharacter.Jump();
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public void SetGameOver(boolean _bWin) {
        this._iStatus = !_bWin ? 3 : 2;
    }

    public void UnlockLevel() {
        this._iScore = 10;
        this._iStatus = 2;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public Obstacle[] GetObstacles() {
        return this._scrObstacles;
    }

    public Obstacle GetObstacle(int _iOrder) {
        if (_iOrder > this._lActuallevel._iObstacles.length + 1) {
            return null;
        }
        return this._scrObstacles[_iOrder];
    }

    public Character GetCharacter() {
        return this._scrCharacter;
    }

    public int GetCharacterColor() {
        return this._scrCharacter.GetActualColor();
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

