/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Character;
import sk.inlogic.MainCanvas;
import sk.inlogic.Obstacle;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_OPTIONS = 6;
    public static final int COMP_ID_RIGHT_FK = 7;
    public static final int COMP_ID_LEFT_FK = 8;
    public static final int COMP_ID_SHOP = 9;
    public static final int COMP_ID_NONE = 10;
    private static final int TOTAL_COMP_IDS = 11;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualSceen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_SHOP = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private static final int SCREEN_OPTIONS = 5;
    private static final int SCREEN_TOPSCORES = 6;
    private static final int SCREEN_LEVELS = 6;
    private int _iActualPage = 0;
    private int _iTotalPages = 10;
    int _iPositionX = 0;
    int _iPositionY = 0;
    int _iSelectedLvl = 0;
    private Rectangle[] rectItems = new Rectangle[11];
    private Rectangle[] rectItems_TXT = new Rectangle[7];
    private int[][] _animationSequence = new int[9][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[11];
    private Rectangle _rectLevel;
    private Rectangle _rectCharacter;
    private Rectangle[] _rectLevels = new Rectangle[20];
    private Rectangle[] _rectCharacters = new Rectangle[12];
    private Rectangle _rectLevelArrowTop;
    private Rectangle _rectLevelArrowBottom;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectTopBig;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle _rectDialog;
    private Rectangle _rectAboutDialog;
    private Rectangle _rectTopBar;
    private int[] _addCharacterCost = new int[]{0, 25, 35, 50, 75, 100, 150, 350, 400, 550, 750, 900};
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private int _iSelectedLevel = 0;
    private int _iSelectedCharacter = 0;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    private int scoresCount = 0;
    private int count = 0;
    private String[] levelStars = new String[200];
    private String[] characters = new String[12];
    private String[] levelnames = new String[200];
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText _ptMnuItem;
    PreparedText _ptNavigationKeysBB;
    PreparedText title;
    PreparedText _ptInstruction;
    PreparedText _ptVersionOfGame;
    PreparedText _ptDifficulty;
    private int textOffsetY;
    private Image _imgGameLogo;
    private Image _imgCorpLogo;
    private Sprite _sprBtnArrow;
    private Sprite _sprBtnBack;
    private Sprite _sprBtnInfo;
    private Sprite _sprBtnShop;
    private Sprite _sprBtnPlay;
    private Sprite _sprBtnSoundOn;
    private Sprite _sprBtnSoundOff;
    private Sprite _sprBtnQuit;
    private Sprite _sprBtnSelectorBig;
    private Sprite _sprBtnSelectorSmall;
    private Sprite _sprIconNo;
    private Sprite _sprIconYes;
    private Sprite _sprLevelBoxB;
    private Sprite _sprLevelBoxG;
    private Sprite _sprLevelBoxR;
    private Sprite _sprLevelBoxY;
    private Sprite _sprLock;
    private Sprite _sprTopBarB;
    private Sprite _sprTopBarG;
    private Sprite _sprTopBarR;
    private Sprite _sprTopBarY;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private static int _totalRowTiles = 0;
    private static int _totalColTiles = 0;
    boolean check = false;
    int _iColorBg = 15691352;
    private int _iScore = 0;
    int _iMainCharacter = 0;
    private int _iMode = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int musicControler = 0;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    private final int _COLOR_BLACK;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    int _iAngle = 0;
    Obstacle obs;
    Obstacle obs2;
    Character character;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode) {
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._iPositionX = MainCanvas.counterX;
        this._iPositionY = MainCanvas.counterY;
        this._iActualPage = MainCanvas.page;
        this._iSelectedLevel = MainCanvas.level;
        this.actualSceen = 0;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
        this._iMode = _imode;
        this._iActualPage = MainCanvas.page;
        this._iSelectedLevel = MainCanvas.level;
    }

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode, int _iScreen) {
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._iPositionX = MainCanvas.counterX;
        this._iPositionY = MainCanvas.counterY;
        this._iSelectedLevel = MainCanvas.level;
        this._iActualPage = MainCanvas.page;
        this.actualSceen = _iScreen;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
        this._iMode = _imode;
        System.out.println("ScreenMenu end");
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.initMode();
        this.loadMainCharacter();
        this.loadBestScore();
        this.saveFirst();
        this.prepareLevelStars();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void prepareResources() {
        this._arrImages = new int[]{2, 0};
        this._arrSprites = new int[]{86, 88, 91, 93, 95, 94, 99, 97, 98, 100, 84, 85, 73, 74, 75, 76, 77, 80, 81, 82, 83, 29, 41, 1, 13, 17, 37, 9, 5, 45, 25, 21, 33, 30, 42, 2, 14, 18, 38, 10, 6, 46, 26, 22, 34};
        this._arrFonts = new int[]{0, 1, 4};
    }

    private void loadBestScore() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._iScore = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this._iScore;
        RMSObjects.localScores.userName = Integer.toString(0);
        RMSObjects.localScores.insertScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    private void saveFirst() {
    }

    private void prepareLevelStars() {
        Vector scores;
        for (int i = 0; i < 200; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(6);
        if (!RMSObjects.rmsConnects[6].load()) {
            RMSObjects.rmsConnects[6].create();
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(0);
            scoreItem.scoreValue = 1;
            RMSObjects.levels.userName = Integer.toString(0);
            RMSObjects.levels.insertScoreItem(scoreItem, 0);
            RMSObjects.rmsConnects[6].save();
        }
        if ((scores = RMSObjects.levels.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 200; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
        RMSObjects.rmsConnects[6].save();
        this.loadCharacters();
    }

    private void loadCharacters() {
        Vector scores;
        for (int i = 0; i < 12; ++i) {
            this.characters[i] = null;
        }
        RMSObjects.createRMSConnect(7);
        if (!RMSObjects.rmsConnects[7].load()) {
            RMSObjects.rmsConnects[7].create();
            this.saveDefaultCharacters();
        }
        if ((scores = RMSObjects.characters.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 12; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.characters[i] = Integer.toString(scoreItem.scoreValue);
                ++this.count;
                continue;
            }
            this.characters[i] = null;
        }
        RMSObjects.rmsConnects[7].save();
    }

    private void saveDefaultCharacters() {
        for (int _iIdx = 0; _iIdx < 12; ++_iIdx) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(_iIdx);
            scoreItem.scoreValue = _iIdx == 0 ? 1 : 0;
            RMSObjects.characters.userName = Integer.toString(_iIdx);
            RMSObjects.characters.insertScoreItem(scoreItem, _iIdx);
        }
        RMSObjects.rmsConnects[7].save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buyOrSelectCharacter() {
        System.out.println("_iSelectedCharacter: " + this._iSelectedCharacter);
        if (this.characters[this._iSelectedCharacter].equals("0")) {
            if (this._iSelectedCharacter == 0) {
                this.saveCharacterStars();
                this._iMainCharacter = this._iSelectedCharacter;
                this.saveMainCharacter();
            } else {
                if (this._iScore < this._addCharacterCost[this._iSelectedCharacter]) return;
                this._iScore -= this._addCharacterCost[this._iSelectedCharacter];
                this._iMainCharacter = this._iSelectedCharacter;
                System.out.println("save _iSelectedCharacter: " + this._iSelectedCharacter);
                this.saveBestScore();
                this.saveCharacterStars();
                this.saveMainCharacter();
            }
        } else {
            this._iMainCharacter = this._iSelectedCharacter;
            this.saveMainCharacter();
        }
        this.loadCharacters();
        this.mainCanvas.repaint();
    }

    private void saveCharacterStars() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = Integer.toString(this._iSelectedCharacter);
        scoreItem.scoreValue = this._iSelectedCharacter;
        System.out.println("scoreItem.scoreValue : " + scoreItem.scoreValue);
        RMSObjects.characters.userName = Integer.toString(0);
        RMSObjects.characters.insertScoreItem(scoreItem, this._iSelectedCharacter);
        System.out.println("_iSelectedCharacter: " + this._iSelectedCharacter);
        if (!RMSObjects.rmsConnects[7].isExist()) {
            RMSObjects.rmsConnects[7].create();
        }
        RMSObjects.rmsConnects[7].save();
    }

    private void loadMainCharacter() {
        Vector scores;
        RMSObjects.createRMSConnect(10);
        if (!RMSObjects.rmsConnects[10].load()) {
            RMSObjects.rmsConnects[10].create();
            this._iMainCharacter = 0;
            this.saveMainCharacter();
        }
        if ((scores = RMSObjects.mainCharacter.getScoresForGame(0)).size() <= 0) {
            this._iMainCharacter = 0;
            this.saveMainCharacter();
            return;
        }
        PowV2ScoreItem scoreItem = (PowV2ScoreItem)scores.elementAt(0);
        this._iMainCharacter = scoreItem.scoreValue;
    }

    private void saveMainCharacter() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = Integer.toString(0);
        scoreItem.scoreValue = this._iMainCharacter;
        RMSObjects.mainCharacter.userName = Integer.toString(0);
        RMSObjects.mainCharacter.insertScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[10].isExist()) {
            RMSObjects.rmsConnects[10].create();
        }
        RMSObjects.rmsConnects[10].save();
        System.err.println("char save: " + scoreItem.scoreValue);
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[2];
        this._imgCorpLogo = Resources.resImgs[0];
    }

    private void initSprites() {
        this._sprBtnArrow = Resources.resSprs[100];
        this._sprBtnBack = Resources.resSprs[86];
        this._sprBtnInfo = Resources.resSprs[88];
        this._sprBtnPlay = Resources.resSprs[91];
        this._sprBtnQuit = Resources.resSprs[99];
        this._sprBtnSelectorBig = Resources.resSprs[97];
        this._sprBtnSelectorSmall = Resources.resSprs[98];
        this._sprBtnShop = Resources.resSprs[93];
        this._sprBtnSoundOff = Resources.resSprs[95];
        this._sprBtnSoundOn = Resources.resSprs[94];
        this._sprIconNo = Resources.resSprs[84];
        this._sprIconYes = Resources.resSprs[85];
        this._sprLevelBoxB = Resources.resSprs[73];
        this._sprLevelBoxG = Resources.resSprs[74];
        this._sprLevelBoxR = Resources.resSprs[75];
        this._sprLevelBoxY = Resources.resSprs[76];
        this._sprLock = Resources.resSprs[77];
        this._sprTopBarB = Resources.resSprs[80];
        this._sprTopBarG = Resources.resSprs[81];
        this._sprTopBarR = Resources.resSprs[82];
        this._sprTopBarY = Resources.resSprs[83];
    }

    public void initTxt() {
        this._ptMnuItem = new PreparedText(Resources.resGFonts[0]);
        this._ptVersionOfGame = new PreparedText(Resources.resGFonts[0]);
        this._ptInstruction = new PreparedText(Resources.resGFonts[0]);
        this._ptNavigationKeysBB = new PreparedText(Resources.resGFonts[1]);
        this._ptDifficulty = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 8;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[5][0] = 6;
        this._animationSequence[5][1] = 7;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = 0;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[1][0] = 6;
        this._animationSequence[1][1] = 8;
        this._animationSequence[1][2] = 9;
        this._animationSequence[1][3] = -1;
        this._animationSequence[1][4] = -1;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[2][0] = 6;
        this._animationSequence[2][1] = -1;
        this._animationSequence[2][2] = -1;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 6;
        this._animationSequence[4][1] = 7;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = -1;
        this._animationSequence[2][2] = -1;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = -1;
        this._animationSequence[6][2] = -1;
        this._animationSequence[6][3] = -1;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[6][6] = -1;
        this._animationSequence[6][7] = -1;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems[7], _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectItems[8], _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectAboutDialog, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(3);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgCorpLogo = null;
        this._ptMnuItem = null;
        this._ptVersionOfGame = null;
        this._ptInstruction = null;
        this._ptNavigationKeysBB = null;
        this._ptDifficulty = null;
    }

    public void prepareTxt() {
        String controls = "";
        this.textOffsetY = 0;
        controls = Resources.resTexts[0].getHashedString(16);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this._ptInstruction.setLineHeightCorrection(-2);
    }

    private void initMode() {
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgGameLogo = Resources.resImgs[2];
        this._iColorBg = 15691352;
    }

    private void changeGraphicsForMode() {
        ++this._iMode;
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgGameLogo = Resources.resImgs[2];
        this._iColorBg = 15691352;
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[0].getHeight();
        int rectTextOffsetX = this._sprIconNo.getWidth() >> 1;
        int rectTextOffsetY = this._sprIconNo.getHeight() >> 1;
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(this._sprBtnBack.getWidth() >> 1, this.rectPanel.y + (this._sprBtnBack.getWidth() >> 1), _WIDTH - (this._sprBtnBack.getWidth() >> 1 << 1), this.rectPanel.height - (this.rectPanel.y + (this._sprBtnBack.getWidth() >> 1)));
        this._rectTopBar = new Rectangle(0, 0, this._sprTopBarB.getWidth(), this._sprTopBarB.getHeight());
        this.rectItems[7] = this.rectLeftFk = new Rectangle(0, _HEIGHT - (this._sprBtnBack.getHeight() << 1), this._sprBtnBack.getWidth() << 1, this._sprBtnBack.getHeight() << 1);
        this.rectItems[8] = this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - (this._sprBtnBack.getWidth() << 1), _HEIGHT - (this._sprBtnBack.getHeight() << 1), this._sprBtnBack.getWidth() << 1, this._sprBtnBack.getHeight() << 1);
        this.posX = (_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1);
        this.rectItems[0] = new Rectangle((_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1), (_HEIGHT >> 1) - (this._sprBtnPlay.getHeight() >> 3), this._sprBtnPlay.getWidth(), this._sprBtnPlay.getHeight());
        this.rectItems[0] = new Rectangle((_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1), (_HEIGHT >> 1) + (this._sprBtnShop.getHeight() >> 2), this._sprBtnPlay.getWidth(), this._sprBtnPlay.getHeight());
        int pY = this.rectItems[0].y + this.rectItems[0].height + (this._sprBtnShop.getWidth() >> 2);
        int pX = (_WIDTH >> 1) - (this._sprBtnShop.getWidth() >> 1);
        int pXoffset = this._sprBtnShop.getWidth() + (this._sprBtnShop.getWidth() >> 1);
        this.rectItems[2] = new Rectangle(pX, pY, this._sprBtnShop.getWidth(), this._sprBtnShop.getHeight());
        this.rectItems[1] = new Rectangle(pX - pXoffset, pY, this._sprBtnShop.getWidth(), this._sprBtnShop.getHeight());
        this.rectItems[3] = new Rectangle(pX + pXoffset, pY, this._sprBtnShop.getWidth(), this._sprBtnShop.getHeight());
        int posLogoY = (_HEIGHT - this.rectItems[0].y >> 1) - (this._imgGameLogo.getHeight() >> 1);
        this._rectTopBig = new Rectangle(_WIDTH >> 1, posLogoY, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprIconNo.getWidth() > 0 ? _windowWidth % this._sprIconNo.getWidth() : this._sprIconNo.getWidth();
        int _offsetTopY = (this._sprIconNo.getHeight() - this._sprIconNo.getHeight() << 1) + this._sprIconNo.getHeight();
        int _offsetBottomY = this._sprIconNo.getHeight() + (this._sprIconNo.getHeight() - this._sprIconNo.getHeight());
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprIconNo.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprIconNo.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectAboutDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this.calculateWindowTiles();
        this.calculateLevelsPosition();
        this.calculateCharactersPosition();
    }

    private void calculateLevelsPosition() {
        int _iOffsetLeft = this._sprBtnBack.getWidth();
        int _iOffsetRight = this._sprBtnBack.getWidth();
        int _iOffsetUp = this._sprBtnArrow.getWidth() + (this._sprBtnArrow.getWidth() >> 1);
        int _iOffsetDown = this._sprBtnBack.getHeight();
        this._rectLevel = new Rectangle();
        this._rectLevel = new Rectangle(_iOffsetLeft, _iOffsetUp, _WIDTH - (_iOffsetLeft << 1), _HEIGHT - _iOffsetUp - _iOffsetDown);
        int _iLevelOffsetX = (this._rectLevel.width - 4 * this._sprLevelBoxB.getWidth()) / 4;
        int _iLevelOffsetY = (this._rectLevel.height - 5 * this._sprLevelBoxB.getHeight()) / 5;
        int _iTmpPos = 0;
        for (int _iIdy = 0; _iIdy < 5; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
                int _iX = this._rectLevel.x + _iIdx * _iLevelOffsetX + _iIdx * this._sprLevelBoxB.getWidth();
                int _iY = this._rectLevel.y + _iIdy * _iLevelOffsetY + _iIdy * this._sprLevelBoxB.getHeight();
                this._rectLevels[_iTmpPos] = new Rectangle(_iX, _iY, this._sprLevelBoxB.getWidth(), this._sprLevelBoxB.getHeight());
                ++_iTmpPos;
            }
        }
    }

    private void calculateCharactersPosition() {
        int _iOffsetLeft = (_WIDTH - this._sprBtnBack.getWidth() * 3) / 4;
        int _iOffsetUp = this._sprTopBarB.getHeight() + (this._sprBtnBack.getHeight() >> 2);
        int _iOffsetDown = this._sprBtnBack.getHeight();
        this._rectCharacter = new Rectangle();
        this._rectCharacter = new Rectangle(_iOffsetLeft, _iOffsetUp, _WIDTH - (_iOffsetLeft << 1), _HEIGHT - _iOffsetUp - _iOffsetDown);
        int _iLevelOffsetX = (this._rectCharacter.width - 3 * this._sprLevelBoxB.getWidth()) / 3;
        int _iLevelOffsetY = (this._rectCharacter.height - 4 * this._sprLevelBoxB.getHeight()) / 4;
        _iLevelOffsetX = _iOffsetLeft;
        int _iOffset = _iLevelOffsetX >> 1;
        if ((this._rectCharacter.width - (3 * _iLevelOffsetX + 3 * this._sprLevelBoxB.getWidth())) / 2 != 0) {
            _iOffset = this._rectCharacter.width % 2 >> 1;
        }
        int _iTmpPos = 0;
        for (int _iIdy = 0; _iIdy < 4; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 3; ++_iIdx) {
                int _iX = _iOffset + this._rectCharacter.x + _iIdx * _iLevelOffsetX + _iIdx * this._sprLevelBoxB.getWidth();
                int _iY = this._rectCharacter.y + _iIdy * _iLevelOffsetY + _iIdy * this._sprLevelBoxB.getHeight();
                this._rectCharacters[_iTmpPos] = new Rectangle(_iX, _iY, this._sprLevelBoxB.getWidth(), this._sprLevelBoxB.getHeight());
                ++_iTmpPos;
            }
        }
    }

    private void calculateWindowTiles() {
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualSceen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
            return;
        }
        if (this.obs2 != null) {
            this.obs2.Update(lastRunLenght, this.character);
        }
        if (this.character != null) {
            this.character.Update(lastRunLenght);
        }
        if (this._iAngle < 0) {
            this._iAngle = 360;
            this.mainCanvas.repaint();
        } else {
            this._iAngle -= 3;
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualSceen].length; ++i) {
            if (this._animationSequence[this.actualSceen][i] == -1 || this._animationComponents[this._animationSequence[this.actualSceen][i]] == null || this._animationComponents[this._animationSequence[this.actualSceen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualSceen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 3) {
                    this.startGameScreen();
                }
                this._sequence = this._sequenceShow;
                this.actualSceen = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
                this.actualSceen = this.nextScreen;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startGameScreen() {
        MainCanvas.page = this._iActualPage;
        MainCanvas.level = this._iSelectedLevel;
        ScreenGame sg = new ScreenGame(this.mainCanvas, this._iSelectedLevel + 1 + this._iActualPage * 20, this._iMainCharacter);
        this.mainCanvas.changeLastActiveScreen(sg);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void musicInteruptUpdate() {
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.actualSceen) {
            case 0: {
                this.paintGameLogo(g);
                this.paintMainMenuDialogItems(g);
                break;
            }
            case 1: {
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 2: {
                this.paintShop(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
                break;
            }
            case 6: {
                this.paintLevels(g);
            }
        }
        this.paintFK(g);
    }

    private void paintCircle(Graphics g) {
        if (this.obs2 == null) {
            this.obs2 = new Obstacle(2, 0);
        }
        if (this.obs == null) {
            this.obs = new Obstacle(1, 0);
        }
        if (this.character == null) {
            this.character = new Character(0);
        }
        this.obs2.Paint(g);
        this.character.Paint(g);
    }

    private int getStartAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 90 < 360 ? this._iAngle + 90 : this._iAngle + 90 - 360;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 180 < 360 ? this._iAngle + 180 : this._iAngle + 180 - 360;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 270 < 360 ? this._iAngle + 270 : this._iAngle + 270 - 360;
        }
        return _iRetVal;
    }

    private int getEndAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle + 90;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 180 > 360 ? 360 - (this._iAngle + 180) : this._iAngle + 180;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 270 > 360 ? 360 - (this._iAngle + 270) : this._iAngle + 270;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 360 > 360 ? 360 - (this._iAngle + 360) : this._iAngle + 360;
        }
        return _iRetVal;
    }

    public void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.mainCanvas.getWidth(), this.mainCanvas.getHeight());
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.getCenterY(), 3);
    }

    private void paintInstrusctionTxt(Graphics g) {
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(16);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this._ptInstruction.setLineHeightCorrection(-2);
        this._ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintLevels(Graphics g) {
        int _iTmpPos = 0;
        for (int _iIdy = 0; _iIdy < 5; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
                if (this.levelStars[_iTmpPos + this._iActualPage * 20] == null) {
                    if (_iTmpPos == 0 && this._iActualPage == 0) {
                        this._sprLevelBoxG.setPosition(this._rectLevels[_iTmpPos].x, this._rectLevels[_iTmpPos].y);
                        this._sprLevelBoxG.paint(g);
                        this._ptInstruction.prepareText("" + (_iTmpPos + 1 + this._iActualPage * 20), this._rectLevels[_iTmpPos].width);
                        this._ptInstruction.drawText(g, this._rectLevels[_iTmpPos], 0, 3);
                    } else {
                        this._sprLevelBoxG.setPosition(this._rectLevels[_iTmpPos].x, this._rectLevels[_iTmpPos].y);
                        this._sprLevelBoxG.paint(g);
                        this._sprLock.setPosition(this._rectLevels[_iTmpPos].x + (this._sprLevelBoxR.getWidth() - this._sprLock.getWidth() >> 1), this._rectLevels[_iTmpPos].y + (this._sprLevelBoxR.getHeight() - this._sprLock.getHeight() >> 1));
                        this._sprLock.paint(g);
                    }
                } else {
                    this._sprLevelBoxG.setPosition(this._rectLevels[_iTmpPos].x, this._rectLevels[_iTmpPos].y);
                    this._sprLevelBoxG.paint(g);
                    this._ptInstruction.prepareText("" + (_iTmpPos + 1 + this._iActualPage * 20), this._rectLevels[_iTmpPos].width);
                    this._ptInstruction.drawText(g, this._rectLevels[_iTmpPos], 0, 3);
                }
                if (this._iSelectedLevel == _iTmpPos) {
                    g.setColor(0xFFFFFF);
                    g.drawRect(this._rectLevels[_iTmpPos].x, this._rectLevels[_iTmpPos].y, this._sprLevelBoxR.getWidth(), this._sprLevelBoxR.getHeight());
                }
                ++_iTmpPos;
            }
        }
        this.paintLevelArrows(g);
    }

    private void paintCharacters(Graphics g) {
        this._sprTopBarB.setPosition(0, 0);
        this._sprTopBarB.paint(g);
        Rectangle r = new Rectangle(0, 0, this._sprTopBarB.getWidth(), this._sprTopBarB.getHeight());
        PreparedText score = new PreparedText(Resources.resGFonts[0]);
        score.prepareText(Resources.resTexts[0].getHashedString(80) + "\n" + this._iScore, r.width);
        score.drawText(g, r, 0, 3);
        int _iTmpPos = 0;
        for (int _iIdy = 0; _iIdy < 4; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 3; ++_iIdx) {
                g.setColor(5262926);
                g.fillRoundRect(this._rectCharacters[_iTmpPos].x, this._rectCharacters[_iTmpPos].y, this._sprLevelBoxR.getWidth(), this._sprLevelBoxR.getHeight(), 10, 10);
                if (this.characters[_iTmpPos].equals("0")) {
                    if (_iTmpPos == 0) {
                        this.paintCharacter(g, _iTmpPos, false);
                    } else {
                        PreparedText _cost = new PreparedText(Resources.resGFonts[0]);
                        _cost.prepareText("" + this._addCharacterCost[_iTmpPos], this._rectCharacters[_iTmpPos].width);
                        _cost.drawText(g, this._rectCharacters[_iTmpPos], 0, 3);
                    }
                } else {
                    this.paintCharacter(g, _iTmpPos, false);
                }
                if (this._iSelectedCharacter == _iTmpPos) {
                    g.setColor(0xFFFFFF);
                    g.drawRoundRect(this._rectCharacters[this._iSelectedCharacter].x, this._rectCharacters[this._iSelectedCharacter].y, this._sprLevelBoxR.getWidth(), this._sprLevelBoxR.getHeight(), 10, 10);
                }
                ++_iTmpPos;
            }
        }
    }

    private void paintCharacter(Graphics g, int _iPosition, boolean _bLock) {
        Sprite _sprChar = null;
        switch (_iPosition) {
            case 0: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[30];
                    break;
                }
                _sprChar = Resources.resSprs[29];
                break;
            }
            case 1: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[42];
                    break;
                }
                _sprChar = Resources.resSprs[41];
                break;
            }
            case 2: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[2];
                    break;
                }
                _sprChar = Resources.resSprs[1];
                break;
            }
            case 3: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[14];
                    break;
                }
                _sprChar = Resources.resSprs[13];
                break;
            }
            case 4: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[18];
                    break;
                }
                _sprChar = Resources.resSprs[17];
                break;
            }
            case 5: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[38];
                    break;
                }
                _sprChar = Resources.resSprs[37];
                break;
            }
            case 6: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[10];
                    break;
                }
                _sprChar = Resources.resSprs[9];
                break;
            }
            case 7: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[6];
                    break;
                }
                _sprChar = Resources.resSprs[5];
                break;
            }
            case 8: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[46];
                    break;
                }
                _sprChar = Resources.resSprs[45];
                break;
            }
            case 9: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[26];
                    break;
                }
                _sprChar = Resources.resSprs[25];
                break;
            }
            case 10: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[22];
                    break;
                }
                _sprChar = Resources.resSprs[21];
                break;
            }
            case 11: {
                if (this._iSelectedCharacter == _iPosition) {
                    _sprChar = Resources.resSprs[34];
                    break;
                }
                _sprChar = Resources.resSprs[33];
                break;
            }
            default: {
                _sprChar = this._iSelectedCharacter == _iPosition ? Resources.resSprs[30] : Resources.resSprs[29];
            }
        }
        if (_bLock) {
            this._sprLock.setPosition(this._rectCharacters[_iPosition].x + (this._sprLevelBoxR.getWidth() - this._sprLock.getWidth() >> 1), this._rectCharacters[_iPosition].y + (this._sprLevelBoxR.getHeight() - this._sprLock.getHeight() >> 1));
            this._sprLock.paint(g);
        } else {
            if (_sprChar == null) {
                System.out.println("null _iPosition: " + _iPosition);
            }
            _sprChar.setPosition(this._rectCharacters[_iPosition].x + (this._sprLevelBoxR.getWidth() - _sprChar.getWidth() >> 1), this._rectCharacters[_iPosition].y + (this._sprLevelBoxR.getHeight() - _sprChar.getHeight() >> 1));
            _sprChar.paint(g);
        }
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstruction.getTextHeight() < this.rectText.height) {
            return;
        }
        if (this.scrollDOWN && this.scrollUP) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this._sprBtnArrow.getHeight() >> 1);
            this._sprBtnArrow.paint(g);
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, _HEIGHT - this._sprBtnArrow.getHeight());
            this._sprBtnArrow.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this._sprBtnArrow.getHeight() >> 1);
            this._sprBtnArrow.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, _HEIGHT - this._sprBtnArrow.getHeight());
            this._sprBtnArrow.paint(g);
        }
        this._sprBtnArrow.setTransform(0);
    }

    private void paintLevelArrows(Graphics g) {
        if (this._iActualPage > 0 && this._iActualPage < this._iTotalPages - 1) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y - this._sprBtnArrow.getHeight() - (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y + this._rectLevel.height + (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        } else if (this._iActualPage != this._iTotalPages - 1) {
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y + this._rectLevel.height + (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        }
        if (this._iActualPage != 0) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y - this._sprBtnArrow.getHeight() - (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        }
        this._sprBtnArrow.setTransform(0);
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptVersionOfGame.drawText(g, this.rectPanel, 0, 33);
    }

    private void paintQuit(Graphics g) {
        this._ptVersionOfGame.prepareText(Resources.resTexts[0].getHashedString(2), _WIDTH);
        this._ptVersionOfGame.drawText(g, this.rectText, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualSceen == 4) {
            this._sprIconNo.setPosition(this.rectRightFk.x + (this._sprIconNo.getWidth() << 1), this.rectRightFk.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconNo.paint(g);
            this._sprIconYes.setPosition(this.rectLeftFk.getCenterX() - this._sprIconNo.getWidth(), this.rectLeftFk.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconYes.paint(g);
        } else if (this.actualSceen == 0) {
            this._sprBtnQuit.setPosition(this.rectItems[8].x + (this._sprBtnQuit.getWidth() >> 1) + (this._sprBtnQuit.getWidth() >> 2), this.rectItems[8].y + (this._sprBtnQuit.getHeight() >> 1) + (this._sprBtnQuit.getWidth() >> 2));
            this._sprBtnQuit.paint(g);
        } else if (this.actualSceen != 0) {
            this._sprBtnBack.setFrame(0);
            this._sprBtnBack.setPosition(this.rectItems[8].x + (this._sprBtnBack.getWidth() >> 1) + (this._sprBtnQuit.getWidth() >> 2), this.rectItems[8].y + (this._sprBtnBack.getHeight() >> 1) + (this._sprBtnQuit.getWidth() >> 2));
            this._sprBtnBack.paint(g);
        }
    }

    private void paintMainMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 2) {
            this.paintGraphicsButton(g, this.selectedCompId, MainCanvas.soundManager.IsSoundOn() ? this._sprBtnSoundOn : this._sprBtnSoundOff, true);
        } else {
            this.paintGraphicsButton(g, 2, MainCanvas.soundManager.IsSoundOn() ? this._sprBtnSoundOn : this._sprBtnSoundOff, false);
        }
        if (this.selectedCompId == 1) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnInfo, true);
        } else {
            this.paintGraphicsButton(g, 1, this._sprBtnInfo, false);
        }
        if (this.selectedCompId == 3) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnShop, true);
        } else {
            this.paintGraphicsButton(g, 3, this._sprBtnShop, false);
        }
        if (this.selectedCompId == 0) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnPlay, true);
        } else {
            this.paintGraphicsButton(g, 0, this._sprBtnPlay, false);
        }
    }

    private void paintGraphicsButton(Graphics g, int _type, Sprite _sprite, boolean active) {
        if (active) {
            if (_type != 0) {
                _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                _sprite.paint(g);
                this._sprBtnSelectorSmall.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprBtnSelectorSmall.paint(g);
            } else {
                _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                _sprite.paint(g);
                this._sprBtnSelectorBig.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprBtnSelectorBig.paint(g);
            }
        } else if (_type != 0) {
            _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprite.paint(g);
        } else {
            _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprite.paint(g);
        }
    }

    private void paintTopBar(Graphics g) {
        if (this.actualSceen == 2) {
            this._sprTopBarB.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopBarB.paint(g);
        } else if (this.actualSceen == 6) {
            this._sprTopBarG.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopBarG.paint(g);
        }
    }

    private void paintShop(Graphics g) {
        this.paintCharacters(g);
    }

    private String getButtonName(int _idx) {
        if (_idx == 0) {
            return Resources.resTexts[0].getHashedString(21);
        }
        if (_idx == 1) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(23);
        }
        if (_idx == 2) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
        boolean _actualTileX = false;
        boolean _actualTileY = false;
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this.actualSceen) {
                    case 0: {
                        this.startAnimation(true, 4);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 1;
                        this.selectorCompId = 1;
                        break;
                    }
                    case 5: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 6: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 0);
                        this.selectorCompId = 3;
                        break;
                    }
                    case 4: {
                        this.startAnimation(true, 0);
                        this.selectorCompId = 0;
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this.actualSceen == 4) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.actualSceen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 6);
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                    break;
                                }
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.textOffsetY = 0;
                                    this.startAnimation(true, 1);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                if (this._iSelectedCharacter <= 2) {
                                    int _iTmp = this._iSelectedCharacter;
                                    this._iSelectedCharacter = 11 - _iTmp;
                                } else {
                                    this._iSelectedCharacter -= 3;
                                }
                            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                if (this._iSelectedCharacter >= 9) {
                                    int _iTmp = this._iSelectedCharacter;
                                    this._iSelectedCharacter = 12 - this._iSelectedCharacter;
                                } else {
                                    this._iSelectedCharacter += 3;
                                }
                            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this._iSelectedCharacter = this._iSelectedCharacter == 0 ? 11 : --this._iSelectedCharacter;
                            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this._iSelectedCharacter = this._iSelectedCharacter == 11 ? 0 : ++this._iSelectedCharacter;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            System.out.println("_iSelectedCharacter" + this._iSelectedCharacter);
                            this.buyOrSelectCharacter();
                            this.mainCanvas.repaint();
                            return;
                        }
                        case 6: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                if (this._iPositionY > 0) {
                                    --MainCanvas.counterY;
                                    --this._iPositionY;
                                    this._iSelectedLevel -= 4;
                                    MainCanvas.counterX = this._iPositionX;
                                    MainCanvas.counterY = this._iPositionY;
                                    break;
                                }
                                if (this._iActualPage <= 0) break;
                                MainCanvas.counterX = 0;
                                MainCanvas.counterY = 0;
                                this._iPositionX = 0;
                                this._iPositionY = 0;
                                --this._iActualPage;
                                this._iSelectedLevel = 0;
                                MainCanvas.counterX = this._iPositionX;
                                MainCanvas.counterY = this._iPositionY;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                if (this._iPositionY < 4) {
                                    ++MainCanvas.counterY;
                                    ++this._iPositionY;
                                    this._iSelectedLevel += 4;
                                    MainCanvas.counterX = this._iPositionX;
                                    MainCanvas.counterY = this._iPositionY;
                                } else if (this._iActualPage < 9) {
                                    this._iPositionX = 0;
                                    this._iPositionY = 0;
                                    MainCanvas.counterX = 0;
                                    MainCanvas.counterY = 0;
                                    ++this._iActualPage;
                                    ++MainCanvas.slcPack;
                                    this._iSelectedLevel = 0;
                                    MainCanvas.counterX = this._iPositionX;
                                    MainCanvas.counterY = this._iPositionY;
                                }
                                System.out.println("_iActualPage: " + this._iActualPage);
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                if (this._iPositionX <= 0) break;
                                --this._iPositionX;
                                --MainCanvas.counterX;
                                --this._iSelectedLevel;
                                MainCanvas.counterX = this._iPositionX;
                                MainCanvas.counterY = this._iPositionY;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                if (this._iPositionX >= 3) break;
                                ++this._iPositionX;
                                ++MainCanvas.counterX;
                                ++this._iSelectedLevel;
                                MainCanvas.counterX = this._iPositionX;
                                MainCanvas.counterY = this._iPositionY;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            System.out.println();
                            System.out.println("level : " + (this._iSelectedLevel + this._iActualPage * 20));
                            if (this.levelStars[this._iSelectedLevel + this._iActualPage * 20] == null) {
                                if (this._iSelectedLevel != 0) break;
                                this.startAnimation(true, 3);
                                break;
                            }
                            this.startAnimation(true, 3);
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        int _iTmpIdx;
        this.posX = x;
        this.posY = y;
        if (this.actualSceen == 2) {
            _iTmpIdx = 0;
            for (int _iIDx = 0; _iIDx < this._rectCharacters.length; ++_iIDx) {
                if (this._rectCharacters[_iIDx] == null || !this._rectCharacters[_iIDx].contains(x, y)) continue;
                this._iSelectedCharacter = _iIDx;
                this.buyOrSelectCharacter();
                this.mainCanvas.repaint();
                return;
            }
        }
        if (this.actualSceen == 6) {
            _iTmpIdx = 0;
            Rectangle top = new Rectangle(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y - this._sprBtnArrow.getHeight() - (this._sprBtnArrow.getHeight() >> 1), this._sprBtnArrow.getWidth(), this._sprBtnArrow.getHeight());
            if (top.contains(x, y)) {
                if (this._iActualPage > 0) {
                    --this._iActualPage;
                    this.mainCanvas.repaint();
                }
                return;
            }
            System.out.println("tu som som 2 ");
            top = new Rectangle(this._rectLevel.x + this._rectLevel.width >> 1, this._rectLevel.y + this._rectLevel.height + (this._sprBtnArrow.getHeight() >> 1), this._sprBtnArrow.getWidth(), this._sprBtnArrow.getHeight());
            if (top.contains(x, y)) {
                if (this._iActualPage < 9) {
                    ++this._iActualPage;
                    this.mainCanvas.repaint();
                }
                return;
            }
            System.out.println("tu som som 4 ");
            for (int _iIdx = 0; _iIdx < this._rectLevels.length; ++_iIdx) {
                if (this._rectLevels[_iTmpIdx] != null && this._rectLevels[_iTmpIdx].contains(x, y)) {
                    if (this.levelStars[_iTmpIdx + this._iActualPage * 20] != null) {
                        this._iSelectedLevel = _iTmpIdx + this._iActualPage * 20;
                        System.out.println("_iSelectedLevel: " + this._iSelectedLevel);
                        this.startAnimation(true, 3);
                        return;
                    }
                    if (_iTmpIdx == 0 && this._iActualPage == 0) {
                        this._iSelectedLevel = _iTmpIdx;
                        System.out.println("_iSelectedLevel: " + this._iSelectedLevel);
                        this.startAnimation(true, 3);
                        return;
                    }
                }
                ++_iTmpIdx;
            }
        }
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 10) {
                this.selectorCompId = this.selectedCompId = 10;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 10 || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            this.s = i;
            System.out.println("selectedCompId: " + this.selectedCompId);
            switch (this.selectedCompId) {
                case 5: {
                    this.force = 5;
                    this.selectedCompId = 5;
                    i = 5;
                    this.selectorCompId = 5;
                    this.a = this.selectedCompId;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 8: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.actualSceen == 1) {
            if (this._ptInstruction.getTextHeight() < this.rectText.height) {
                return;
            }
            System.out.println("SCROL");
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this._ptInstruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.selectedCompId != 10) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 8: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    case 7: {
                        Keys.keyReleased(-6);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 10;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 10) {
            System.out.println("tu som 0 : " + this.selectedCompId);
            switch (this.selectedCompId) {
                case 5: {
                    this.activeButton = true;
                    this.selectedCompId = this.force;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 4: {
                    if (this.actualSceen != 4) break;
                    X.quitApp();
                    break;
                }
                case 8: {
                    System.out.println("tu som 1");
                    this.activeButton = true;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    System.out.println("tu som 2");
                    this.activeButton = true;
                    this.keyReleased(-6);
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 10;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (this._ptInstruction.getTextHeight() < this.rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (!this.scrollUP && this.scrollDOWN) {
                return;
            }
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            if (this.scrollUP && !this.scrollDOWN) {
                return;
            }
            int maxOffsetY = this._ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }
}

