/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Levels;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int COMP_ID_G0_RESTART = 7;
    private static final int COMP_ID_G0_HOME = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] _rectItems_TXT = new Rectangle[9];
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectDialog;
    private Rectangle _rectGameOver;
    private Rectangle _rectTopBig;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private int selectedCompId;
    private static PreparedText _ptMenuItem;
    private static PreparedText _ptInstruction;
    private static PreparedText _ptActualScore;
    private static PreparedText _ptActualScoreGameOver;
    private static PreparedText best;
    private static PreparedText bestScore;
    private static PreparedText navigationKeysBB;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _imgGameLogo;
    private Sprite _sprBtnArrow;
    private Sprite _sprBtnBack;
    private Sprite _sprBtnInfo;
    private Sprite _sprBtnShop;
    private Sprite _sprBtnPlay;
    private Sprite _sprBtnNext;
    private Sprite _sprBtnRestart;
    private Sprite _sprBtnSoundOn;
    private Sprite _sprBtnSoundOff;
    private Sprite _sprBtnQuit;
    private Sprite _sprBtnSelectorBig;
    private Sprite _sprBtnSelectorSmall;
    private Sprite _sprIconNo;
    private Sprite _sprIconYes;
    private static int _WIDTH;
    private static int _HEIGHT;
    int _iMode = 0;
    private static final int NORMAL = 0;
    private static final int HARD = 1;
    private static final int EASY = 2;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    private int _iSelectedCharacter;
    private Levels _lActualLevel;
    int _iActLevel;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    private String[] levelStars;
    private int count;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    boolean _bBkickUpdate = true;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, int _iSelectedLevel, int _iSelectedCharacter) {
        this.mainCanvas = mainCanvas;
        this._iSelectedCharacter = _iSelectedCharacter;
        this._iMode = 0;
        this.initDimensions();
        this.status = 0;
        this._lActualLevel = new Levels();
        this._lActualLevel.LoadLevel(_iSelectedLevel);
        this._iActLevel = _iSelectedLevel;
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
        this._bBkickUpdate = false;
    }

    public void afterHide() {
        this.freeGraphics();
        this.freeResources();
    }

    private void prepareResources() {
        this._arrImages = new int[]{2};
        this._arrSprites = new int[]{57, 58, 59, 60, 49, 50, 51, 52, 53, 54, 55, 56, 61, 62, 63, 64, 65, 66, 67, 68, 96, 78, 79, 69, 70, 71, 72, 100, 86, 87, 89, 90, 91, 92, 97, 98, 95, 94, 93, 85, 84};
        this._arrFonts = new int[]{0, 3};
        Vector a = new Vector();
    }

    private int[] prepareResourcesCharacter() {
        switch (this._iSelectedCharacter) {
            case 0: {
                return new int[]{29, 30, 31, 32};
            }
            case 1: {
                return new int[]{41, 42, 43, 44};
            }
            case 2: {
                return new int[]{1, 2, 3, 4};
            }
            case 3: {
                return new int[]{13, 14, 15, 16};
            }
            case 4: {
                return new int[]{17, 18, 19, 20};
            }
            case 5: {
                return new int[]{37, 38, 39, 40};
            }
            case 6: {
                return new int[]{9, 10, 11, 12};
            }
            case 7: {
                return new int[]{5, 6, 7, 8};
            }
            case 8: {
                return new int[]{45, 46, 47, 48};
            }
            case 9: {
                return new int[]{25, 26, 27, 28};
            }
            case 10: {
                return new int[]{21, 22, 23, 24};
            }
            case 11: {
                return new int[]{33, 34, 35, 36};
            }
        }
        return new int[]{29, 30, 31, 32};
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadSprites(this.prepareResourcesCharacter());
        Resources.loadGFonts(this._arrFonts);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadSprites(this.prepareResourcesCharacter());
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[2];
    }

    private void initSprites() {
        this._sprBtnArrow = Resources.resSprs[100];
        this._sprBtnBack = Resources.resSprs[86];
        this._sprBtnInfo = Resources.resSprs[88];
        this._sprBtnShop = Resources.resSprs[93];
        this._sprBtnPlay = Resources.resSprs[91];
        this._sprBtnSoundOn = Resources.resSprs[94];
        this._sprBtnSoundOff = Resources.resSprs[95];
        this._sprBtnQuit = Resources.resSprs[87];
        this._sprBtnRestart = Resources.resSprs[92];
        this._sprBtnSelectorBig = Resources.resSprs[97];
        this._sprBtnSelectorSmall = Resources.resSprs[98];
        this._sprBtnNext = Resources.resSprs[89];
        this._sprIconNo = Resources.resSprs[84];
        this._sprIconYes = Resources.resSprs[85];
    }

    public void initTxt() {
        Resources.loadText(0);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptInstruction = new PreparedText(Resources.resGFonts[0]);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[2]);
        bestScore = new PreparedText(Resources.resGFonts[0]);
        best = new PreparedText(Resources.resGFonts[4]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 9;
        this._animationSequence[0][1] = 7;
        this._animationSequence[0][2] = 12;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 6;
        this._animationSequence[1][6] = 12;
        this._animationSequence[1][7] = 10;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 12;
        this._animationSequence[3][2] = 17;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = 5;
        this._animationSequence[3][5] = 13;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = 16;
        this._animationSequence[6][3] = 17;
        this._animationSequence[6][4] = 5;
        this._animationSequence[6][5] = 13;
        this._animationSequence[6][6] = 11;
        this._animationSequence[6][7] = 12;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = 16;
        this._animationSequence[5][3] = 17;
        this._animationSequence[5][4] = 5;
        this._animationSequence[5][5] = 13;
        this._animationSequence[5][6] = 12;
        this._animationSequence[5][7] = 11;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 10;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 16;
        this._animationSequence[2][3] = 17;
        this._animationSequence[2][4] = 0;
        this._animationSequence[2][5] = 11;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = 13;
        this._animationSequence[2][8] = 14;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectBestScore, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectGameArea, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this._rectGameOver, _WIDTH, _HEIGHT);
        this._animationComponents[14].startShowAnimation(3);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(3);
        this._animationComponents[6].startHideAnimation(2);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(0);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(3);
        this._animationComponents[14].startHideAnimation(3);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(16);
        _ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        _ptInstruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void loadFirstPlay() {
        Vector scores = RMSObjects.firstPlay.getScoresForGame(0);
        RMSObjects.createRMSConnect(9);
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this.bestScoreSave + RMSObjects.game.getScore();
        RMSObjects.localScores.userName = Integer.toString(0);
        RMSObjects.localScores.insertScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    private void saveLevelStars() {
        System.out.println("call saveLevelStars()");
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = this._iActLevel + 1;
        scoreItem.userName = Integer.toString(this._iActLevel + 1);
        scoreItem.scoreValue = 1;
        RMSObjects.levels.userName = Integer.toString(this._iActLevel + 1);
        RMSObjects.levels.insertScoreItem(scoreItem, this._iActLevel + 1);
        if (!RMSObjects.rmsConnects[6].isExist()) {
            RMSObjects.rmsConnects[6].create();
        }
        RMSObjects.rmsConnects[6].save();
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            Keys.resetAllPressedKeysAndActions();
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void calculatePositions() {
        int itemHeight;
        int rectPanelY = itemHeight = Resources.resGFonts[0].getHeight();
        int rectTextOffsetX = this._sprBtnBack.getWidth() >> 1;
        int rectTextOffsetY = this._sprBtnBack.getHeight() >> 1;
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        this.rectGameArea = new Rectangle(0, 0, _WIDTH, _HEIGHT);
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[2]);
        _ptActualScore.prepareText("0", this.mainCanvas.getWidth());
        this.rectScore = new Rectangle(this._sprBtnBack.getWidth() >> 1, itemHeight >> 1, this.mainCanvas.getWidth() - this._sprBtnBack.getWidth(), _ptActualScore.getTextHeight());
        this.rectBestScore = new Rectangle(0, itemHeight >> 1, this.mainCanvas.getWidth(), itemHeight);
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectItems[3] = new Rectangle((_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1), (_HEIGHT >> 1) + (this._sprBtnPlay.getHeight() >> 2), this._sprBtnPlay.getWidth(), this._sprBtnPlay.getHeight());
        int pY = this.rectItems[3].y + this.rectItems[3].height + (this._sprBtnBack.getWidth() >> 2);
        int pX = (_WIDTH >> 1) - (this._sprBtnBack.getWidth() >> 1);
        int pXoffset = this._sprBtnBack.getWidth() + (this._sprBtnBack.getWidth() >> 1);
        this.rectItems[5] = new Rectangle(pX, pY, this._sprBtnBack.getWidth(), this._sprBtnBack.getHeight());
        this.rectItems[0] = this.rectLeftFk = new Rectangle(0, _HEIGHT - (this._sprBtnBack.getHeight() << 1), this._sprBtnBack.getWidth() << 1, this._sprBtnBack.getHeight() << 1);
        this.rectItems[1] = this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - this._sprBtnBack.getWidth(), _HEIGHT - this._sprBtnBack.getHeight(), this._sprBtnBack.getWidth(), this._sprBtnBack.getHeight());
        this.rectPlay = new Rectangle(0, _HEIGHT >> 1, _WIDTH, itemHeight);
        int posLogoY = (_HEIGHT - this.rectItems[3].y >> 1) - (this._imgGameLogo.getHeight() >> 1);
        this._rectTopBig = new Rectangle(_WIDTH >> 1, posLogoY, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
    }

    private void calculateWindowTiles() {
    }

    public void update(long lastRunLenght) {
        System.out.println("status: " + this.status);
        this.animationController();
        this.animationComponentsUpdate();
        if (this.status == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            if (this._bBkickUpdate) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            this.mainCanvas.repaint();
            if (RMSObjects.game.isGameOver()) {
                this.selectedCompId = 3;
                this.startAnimation(true, 2);
            }
            if (RMSObjects.game.isLevelDone()) {
                this.selectedCompId = 3;
                this.startAnimation(true, 2);
            }
        }
        if (this.status == 2) {
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        if (_ptInstruction.getTextHeight() < this.rectText.height) {
            return;
        }
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = _ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g, this.status);
                this.paintPanelTop(g);
                break;
            }
            case 1: {
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintGameLogo(g);
                this.paintGameOver(g, RMSObjects.game.isLevelDone());
                break;
            }
            case 3: {
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.mainCanvas.getWidth(), this.mainCanvas.getHeight());
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.y, 17);
    }

    private void paintInstrusctionTxt(Graphics g) {
        _ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            Object _sprWarrior = null;
            String text = Resources.resTexts[0].getHashedString(13);
            String nect = this.bestScoreSave < RMSObjects.game.getScore() ? "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getScore() : "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + this.bestScoreSave;
            _ptMenuItem.prepareText(text, this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() + (_ptMenuItem.getTextHeight() >> 1), 3);
            bestScore.prepareText(nect, this.rectText.width);
            bestScore.drawText(g, this.rectText, _ptMenuItem.getTextHeight(), 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            _ptMenuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintGameOver(Graphics g, boolean _bWin) {
        if (this.selectedCompId == 3) {
            if (!_bWin) {
                this.paintButton(g, 3, this._sprBtnRestart, true);
            } else {
                this.paintButton(g, 3, this._sprBtnNext, true);
            }
        } else if (!_bWin) {
            this.paintButton(g, 3, this._sprBtnRestart, false);
        } else {
            this.paintButton(g, 3, this._sprBtnNext, false);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, this._sprBtnQuit, true);
        } else {
            this.paintButton(g, 5, this._sprBtnQuit, false);
        }
        PreparedText _over = new PreparedText(Resources.resGFonts[0]);
        if (_bWin) {
            _over.prepareText(Resources.resTexts[0].getHashedString(49), _WIDTH);
        } else {
            _over.prepareText(Resources.resTexts[0].getHashedString(13), _WIDTH);
        }
        int _iOffset = this._rectTopBig.y + this._rectTopBig.height + (_over.getTextHeight() >> 1);
        _over.drawText(g, new Rectangle(0, _iOffset, _WIDTH, _over.getTextHeight()), 0, 3);
    }

    private void paintArrows(Graphics g) {
        if (_ptInstruction.getTextHeight() < this.rectText.height) {
            return;
        }
        if (this.scrollDOWN && this.scrollUP) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprBtnArrow.getHeight() - (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprBtnArrow.setTransform(0);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprBtnArrow.getHeight() - (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprBtnArrow.setTransform(3);
            this._sprBtnArrow.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprBtnArrow.getHeight() >> 1));
            this._sprBtnArrow.paint(g);
        }
        this._sprBtnArrow.setTransform(0);
    }

    private void paintPanelTop(Graphics g) {
        if (RMSObjects.game.getScore() <= 0) {
            _ptActualScore.prepareText("0", this.rectScore.width);
        } else {
            _ptActualScore.prepareText("" + RMSObjects.game.getScore(), this.rectScore.width);
        }
        _ptActualScore.drawText(g, this.rectScore, 0, 6);
    }

    public void paintTop(Graphics g) {
    }

    private void paintFK(Graphics g) {
        int OffsetX = this._sprBtnBack.getWidth() >> 3;
        int OffsetY = this._sprBtnBack.getWidth() >> 3;
        if (this.status == 0) {
            this._sprBtnBack.setPosition(this.rectRightFk.x - OffsetX, this.rectRightFk.y - OffsetX);
            this._sprBtnBack.paint(g);
        } else if (this.status == 1) {
            this._sprBtnBack.setPosition(this.rectRightFk.x + this._sprBtnBack.getWidth() - OffsetX, this.rectRightFk.y + this._sprBtnBack.getHeight() - OffsetY);
            this._sprBtnBack.paint(g);
        } else if (this.status == 5) {
            Rectangle r = new Rectangle(this.mainCanvas.getWidth() - (this._sprBtnBack.getWidth() << 1), _HEIGHT - (this._sprBtnBack.getHeight() << 1), this._sprBtnBack.getWidth() << 1, this._sprBtnBack.getHeight() << 1);
            this._sprIconNo.setPosition(r.x + (this._sprIconNo.getWidth() << 1), r.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconNo.paint(g);
            this._sprIconYes.setPosition(this.rectLeftFk.getCenterX() - this._sprIconNo.getWidth(), this.rectLeftFk.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconYes.paint(g);
        } else if (this.status == 6) {
            Rectangle r = new Rectangle(this.mainCanvas.getWidth() - (this._sprBtnBack.getWidth() << 1), _HEIGHT - (this._sprBtnBack.getHeight() << 1), this._sprBtnBack.getWidth() << 1, this._sprBtnBack.getHeight() << 1);
            this._sprIconNo.setPosition(r.x + (this._sprIconNo.getWidth() << 1), r.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconNo.paint(g);
            this._sprIconYes.setPosition(this.rectLeftFk.getCenterX() - this._sprIconNo.getWidth(), this.rectLeftFk.y + (this._sprIconNo.getHeight() << 1));
            this._sprIconYes.paint(g);
        } else if (this.status == 2) {
            // empty if block
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 3) {
            this.paintButton(g, 3, this._sprBtnRestart, true);
        } else {
            this.paintButton(g, 3, this._sprBtnRestart, false);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, this._sprBtnQuit, true);
        } else {
            this.paintButton(g, 5, this._sprBtnQuit, false);
        }
    }

    private String getButtonName(int _idx) {
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(25);
        }
        if (_idx == 6) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 5) {
            return Resources.resTexts[0].getHashedString(19);
        }
        if (_idx == 4) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintButton(Graphics g, int _type, Sprite _sprBtn, boolean active) {
        if (active) {
            _sprBtn.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprBtn.paint(g);
            if (_type == 3) {
                this._sprBtnSelectorBig.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprBtnSelectorBig.paint(g);
            } else {
                this._sprBtnSelectorSmall.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprBtnSelectorSmall.paint(g);
            }
        } else {
            _sprBtn.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprBtn.paint(g);
        }
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
    }

    private void paintWindowBlue(Graphics g, Rectangle _rectWindow) {
    }

    private int getWindowTileSprite(int _x, int _y) {
        return 7;
    }

    private int getWindowTileSpriteBlue(int _x, int _y, int cols, int rows) {
        return 10;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
        if (0 != this.status || Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode) || keyCode == 49) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode) || keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
                    // empty if block
                }
                if (Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode) || Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode) || !Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.Jump();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.startAnimation(true, 7);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                Keys.resetAllPressedKeysAndActions();
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode) || !Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            Keys.resetAllPressedKeysAndActions();
            RMSObjects.game.releaaseControls();
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (this.selectedCompId == 3) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.selectedCompId = 5;
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.selectedCompId = 5;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (RMSObjects.game.isGameOver()) {
                    this.saveBestScore();
                    this.loadBestScore();
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    this.startAnimation(true, 0);
                    RMSObjects.game.releaaseControls();
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                } else if (RMSObjects.game.isLevelDone()) {
                    this.saveBestScore();
                    this.saveLevelStars();
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 6));
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                }
            }
        } else if (this.selectedCompId == 5) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.selectedCompId = 3;
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.selectedCompId = 3;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.status == 1) {
                    this.startAnimation(true, 6);
                } else if (RMSObjects.game.isGameOver()) {
                    this.saveBestScore();
                    this.loadBestScore();
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    this.startAnimation(true, 0);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                } else if (RMSObjects.game.isLevelDone()) {
                    this.saveBestScore();
                    this.saveLevelStars();
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 0));
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                }
            }
        }
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            if (this.rectItems[1].contains(x, y)) {
                this.setGameMenuStatus();
                this.mainCanvas.repaint();
                return;
            }
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block9: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block9;
                    }
                    Keys.keyPressed(-6);
                    continue block9;
                }
                case 5: {
                    if (RMSObjects.game.isGameOver()) {
                        this.saveBestScore();
                        this.loadBestScore();
                        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                        this.startAnimation(true, 0);
                        MainCanvas.soundManager.Stop();
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block9;
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                        continue block9;
                    }
                    if (RMSObjects.game.isLevelDone()) {
                        this.saveBestScore();
                        this.saveLevelStars();
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 0));
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block9;
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        continue block9;
                    }
                    if (this.status != 1) continue block9;
                    this.startAnimation(true, 6);
                    continue block9;
                }
                case 3: {
                    if (RMSObjects.game.isGameOver()) {
                        this.saveBestScore();
                        this.loadBestScore();
                        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                        this.startAnimation(true, 0);
                        MainCanvas.soundManager.Stop();
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block9;
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                        continue block9;
                    }
                    if (RMSObjects.game.isLevelDone()) {
                        this.saveBestScore();
                        this.saveLevelStars();
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 6));
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block9;
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        continue block9;
                    }
                    if (this.status != 1) continue block9;
                    this.saveBestScore();
                    this.loadBestScore();
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    this.startAnimation(true, 0);
                    MainCanvas.soundManager.Stop();
                    if (!MainCanvas.soundManager.IsSoundOn()) continue block9;
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    continue block9;
                }
                case 7: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block9;
                    }
                    Keys.keyPressed(-6);
                    continue block9;
                }
                case 8: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block9;
                    }
                    Keys.keyPressed(-7);
                    continue block9;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block9;
                    }
                    Keys.keyPressed(-7);
                    continue block9;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block9;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 8) {
                return true;
            }
            if (i == 7) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            if (this.rectItems[1].contains(x, y)) {
                this.setGameMenuStatus();
                this.mainCanvas.repaint();
                return;
            }
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 7: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 8: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
                this.selectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = _ptInstruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

