/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Game;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Character {
    private boolean _bIsAlive = false;
    private final int _STATE_INIT;
    private final int _STATE_JUMP;
    private final int _STATE_FALL;
    private final int _STATE_WAIT;
    private final int _STATE_COLLISION;
    private final int _COLOR_NONE;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    public int _iState = -1;
    int _iType;
    int _iActualColor = 0;
    int _iPositionX;
    int _iPositionY;
    int _iPositionYFallOffset = 2;
    int _iPositionYJumpOffset = 10;
    int _iAngle = 0;
    private int _iShiftY = 0;
    private int _iOffsetY = 0;
    private int _iTmpShift = 40;
    private int _iTmpPositionY = 0;
    private int _iTmpDefaultPositionY = 0;
    private int _iDelay;
    private int _iDelayActual;
    private Rectangle _rectCharacter;
    private Sprite _sprCharacter;
    private Sprite _sprCharacterBlue;
    private Sprite _sprCharacterGreen;
    private Sprite _sprCharacterRed;
    private Sprite _sprCharacterYellow;
    private Game _scrGame;
    int _iCount = 10;

    public Character(Game _scrgame, int _itype) {
        this._STATE_INIT = 0;
        this._STATE_JUMP = 1;
        this._STATE_FALL = 2;
        this._STATE_WAIT = 3;
        this._STATE_COLLISION = 4;
        this._COLOR_NONE = -1;
        this._COLOR_BLUE = 0;
        this._COLOR_GREEN = 1;
        this._COLOR_RED = 2;
        this._COLOR_YELLOW = 3;
        this._iType = _itype;
        this._scrGame = _scrgame;
        this._iActualColor = -1;
        this.SetState(0);
        this.setCharavterSprite();
        this.ChangeColor();
        this.calculateCharacter();
        this._bIsAlive = true;
    }

    public Character(int _itype) {
        this._STATE_INIT = 0;
        this._STATE_JUMP = 1;
        this._STATE_FALL = 2;
        this._STATE_WAIT = 3;
        this._STATE_COLLISION = 4;
        this._COLOR_NONE = -1;
        this._COLOR_BLUE = 0;
        this._COLOR_GREEN = 1;
        this._COLOR_RED = 2;
        this._COLOR_YELLOW = 3;
        this._iType = _itype;
        this._iActualColor = -1;
        this.SetState(0);
        this.setCharavterSprite();
        this.ChangeColor();
        this.calculateCharacter();
        this._bIsAlive = true;
    }

    private void setCharavterSprite() {
        Resources.loadSprites(new int[]{29, 30, 31, 32});
        switch (this._iType) {
            case 0: {
                this._sprCharacterBlue = Resources.resSprs[29];
                this._sprCharacterGreen = Resources.resSprs[30];
                this._sprCharacterRed = Resources.resSprs[31];
                this._sprCharacterYellow = Resources.resSprs[32];
                return;
            }
            case 1: {
                this._sprCharacterBlue = Resources.resSprs[41];
                this._sprCharacterGreen = Resources.resSprs[42];
                this._sprCharacterRed = Resources.resSprs[43];
                this._sprCharacterYellow = Resources.resSprs[44];
                return;
            }
            case 2: {
                this._sprCharacterBlue = Resources.resSprs[1];
                this._sprCharacterGreen = Resources.resSprs[2];
                this._sprCharacterRed = Resources.resSprs[3];
                this._sprCharacterYellow = Resources.resSprs[4];
                return;
            }
            case 3: {
                this._sprCharacterBlue = Resources.resSprs[13];
                this._sprCharacterGreen = Resources.resSprs[14];
                this._sprCharacterRed = Resources.resSprs[15];
                this._sprCharacterYellow = Resources.resSprs[16];
                return;
            }
            case 4: {
                this._sprCharacterBlue = Resources.resSprs[17];
                this._sprCharacterGreen = Resources.resSprs[18];
                this._sprCharacterRed = Resources.resSprs[19];
                this._sprCharacterYellow = Resources.resSprs[20];
                return;
            }
            case 5: {
                this._sprCharacterBlue = Resources.resSprs[37];
                this._sprCharacterGreen = Resources.resSprs[38];
                this._sprCharacterRed = Resources.resSprs[39];
                this._sprCharacterYellow = Resources.resSprs[40];
                return;
            }
            case 6: {
                this._sprCharacterBlue = Resources.resSprs[9];
                this._sprCharacterGreen = Resources.resSprs[10];
                this._sprCharacterRed = Resources.resSprs[11];
                this._sprCharacterYellow = Resources.resSprs[12];
                return;
            }
            case 7: {
                this._sprCharacterBlue = Resources.resSprs[5];
                this._sprCharacterGreen = Resources.resSprs[6];
                this._sprCharacterRed = Resources.resSprs[7];
                this._sprCharacterYellow = Resources.resSprs[8];
                return;
            }
            case 8: {
                this._sprCharacterBlue = Resources.resSprs[45];
                this._sprCharacterGreen = Resources.resSprs[46];
                this._sprCharacterRed = Resources.resSprs[47];
                this._sprCharacterYellow = Resources.resSprs[48];
                return;
            }
            case 9: {
                this._sprCharacterBlue = Resources.resSprs[25];
                this._sprCharacterGreen = Resources.resSprs[26];
                this._sprCharacterRed = Resources.resSprs[27];
                this._sprCharacterYellow = Resources.resSprs[28];
                return;
            }
            case 10: {
                this._sprCharacterBlue = Resources.resSprs[21];
                this._sprCharacterGreen = Resources.resSprs[22];
                this._sprCharacterRed = Resources.resSprs[23];
                this._sprCharacterYellow = Resources.resSprs[24];
                return;
            }
            case 11: {
                this._sprCharacterBlue = Resources.resSprs[33];
                this._sprCharacterGreen = Resources.resSprs[34];
                this._sprCharacterRed = Resources.resSprs[35];
                this._sprCharacterYellow = Resources.resSprs[36];
                return;
            }
        }
    }

    public void ChangeColor() {
        int _iTmpColor = RandomNum.getRandomInt(4, 0);
        if (_iTmpColor < 0) {
            _iTmpColor *= -1;
        }
        if (_iTmpColor == this._iActualColor) {
            this.ChangeColor();
        }
        this._iActualColor = _iTmpColor;
        this.setSpriteByColor();
    }

    private void setSpriteByColor() {
        switch (this._iActualColor) {
            case 0: {
                this._sprCharacter = this._sprCharacterBlue;
                return;
            }
            case 1: {
                this._sprCharacter = this._sprCharacterGreen;
                return;
            }
            case 2: {
                this._sprCharacter = this._sprCharacterRed;
                return;
            }
            case 3: {
                this._sprCharacter = this._sprCharacterYellow;
                return;
            }
        }
        this.ChangeColor();
    }

    private void calculateCharacter() {
        this._rectCharacter = new Rectangle((MainCanvas.WIDTH >> 1) - (this._sprCharacter.getWidth() >> 1), MainCanvas.HEIGHT - (this._sprCharacter.getHeight() << 1), this._sprCharacter.getWidth(), this._sprCharacter.getHeight());
    }

    public void Jump() {
        this.SetState(1);
    }

    public void Update(long lastRunLenght) {
        if (!this.IsAlive()) {
            return;
        }
        this.updateCharacterBehavioar();
    }

    private void updateCharacterBehavioar() {
        switch (this._iState) {
            case 0: {
                return;
            }
            case 1: {
                this.updateJump();
                return;
            }
            case 2: {
                this.updateFall();
                return;
            }
            case 3: {
                this.updateWait();
                return;
            }
        }
    }

    private void updateJump() {
        if (this.updateMoveUp()) {
            return;
        }
        this.SetState(3);
    }

    private void updateWait() {
        if (this._iDelayActual < this._iDelay) {
            this._iDelayActual += 3;
        } else {
            this.SetState(2);
        }
    }

    private void updateFall() {
        this._rectCharacter.y += this._iPositionYFallOffset;
        if (this._rectCharacter.y >= MainCanvas.HEIGHT) {
            this._scrGame.SetGameOver(false);
        }
    }

    private boolean updateMoveUp() {
        if (this._iCount > 0) {
            --this._iCount;
            this._rectCharacter.y -= 3;
            return true;
        }
        this._iCount = 5;
        return false;
    }

    public void Paint(Graphics g) {
        if (!this.IsAlive()) {
            return;
        }
        this._sprCharacter.setPosition(this._rectCharacter.x, this._rectCharacter.y);
        this._sprCharacter.paint(g);
    }

    public void SetState(int _iNewState) {
        if (_iNewState == this._iState) {
            return;
        }
        this._iState = _iNewState;
    }

    public boolean IsAlive() {
        return this._bIsAlive;
    }

    public int GetActualColor() {
        return this._iActualColor;
    }

    public int GetPositionX() {
        return this._rectCharacter.x;
    }

    public int GetPositionY() {
        return this._rectCharacter.y;
    }

    public void SetPositionX(int _iX) {
        this._rectCharacter.x = _iX;
    }

    public void SetPositionY(int _iY) {
        this._rectCharacter.y = _iY;
    }
}

