/*
 * Decompiled with CFR 0.152.
 */
package com.gamsole.monsterninja;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class JavaSprite {
    public Sprite sprite;
    int currentIndex;
    int width;
    int height;
    int transform;
    int locationX;
    int locationY;
    static int DEFAULT_WIDTH = 640;
    static int DEFAULT_HEIGHT = 480;
    static int screenWidth;
    static int screenHeight;
    static int adjustX;
    static final byte POTRAIT = 0;
    static final byte LANDSCAPE = 1;
    int refX;
    int refY;

    public JavaSprite(String image, int width, int height) throws Exception {
        this.width = width * 2;
        this.height = height * 2;
        Image defaultImg = Image.createImage((String)("/" + image));
        int totalheight = defaultImg.getHeight();
        int totalwidth = defaultImg.getWidth();
        double xUnits = totalwidth / width;
        double yUnits = totalheight / height;
        double unitWidth = Math.ceil((double)totalwidth / xUnits);
        double unitHeight = Math.ceil((double)totalheight / yUnits);
        double scaledWidth = Math.ceil(unitWidth * (double)screenWidth / 320.0);
        double scaledHeight = Math.ceil(unitHeight * (double)screenHeight / 240.0);
        this.sprite = new Sprite(this.createScaledImage(defaultImg, (int)(scaledWidth * xUnits), (int)(scaledHeight * yUnits)), (int)scaledWidth, (int)scaledHeight);
        this.currentIndex = 0;
        this.refX = (int)scaledWidth / 2;
        this.refY = (int)scaledHeight / 2;
    }

    private Image createScaledImage(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += original.getWidth();
        }
        rawInput = null;
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    protected Image createScaledImageOld(Image image, int newWidth, int newHeight) {
        int x;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        Image sImg = Image.createImage((int)newWidth, (int)newHeight);
        Graphics g = sImg.getGraphics();
        int[] lineRGB = new int[sourceWidth];
        int[] sourcePos = new int[newWidth];
        int y = 0;
        int eps = -(sourceWidth >> 1);
        for (x = 0; x < sourceWidth; ++x) {
            if ((eps += newWidth) << 1 < sourceWidth) continue;
            if (++y == newWidth) break;
            sourcePos[y] = x;
            eps -= sourceWidth;
        }
        for (y = 0; y < newHeight; ++y) {
            image.getRGB(lineRGB, 0, sourceWidth, 0, y * sourceHeight / newHeight, sourceWidth, 1);
            for (x = 1; x < newWidth; ++x) {
                lineRGB[x] = lineRGB[sourcePos[x]];
                g.drawRGB(lineRGB, 0, newWidth, 0, y, newWidth, 1, false);
            }
        }
        return sImg;
    }

    public void setTransform(int transform) {
        this.transform = transform;
    }

    public void setRefPixelPosition(int x, int y) {
        this.locationX = x;
        this.locationY = y;
    }

    public void setRefPixelPosition(float x, float y) {
        this.setRefPixelPosition((int)x, (int)y);
    }

    public void setX(int x) {
        this.locationX = x;
    }

    public void setY(int y) {
        this.locationY = y;
    }

    public int getX() {
        return this.locationX;
    }

    public int getY() {
        return this.locationY;
    }

    public void setFrame(int imageIndex) {
        this.currentIndex = imageIndex;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.currentIndex, this.locationX, this.locationY);
    }

    public void paint(Graphics graphics, boolean indiglo) {
        this.paint(graphics, this.currentIndex, this.locationX, this.locationY);
    }

    public void paint(Graphics graphics, int x, int y) {
        this.paint(graphics, this.currentIndex, x, y);
    }

    public void paint(Graphics graphics, int imageIndex, float x, float y) {
        this.paint(graphics, imageIndex, (int)x, (int)y);
    }

    public void paint(Graphics graphics, int imageIndex, int x, int y) {
        this.sprite.setFrame(imageIndex);
        int transformX = this.width / 2;
        int transformY = this.height / 2;
        this.sprite.defineReferencePixel(this.refX, this.refY);
        int drawX = (x + transformX) * screenWidth / DEFAULT_WIDTH;
        int drawY = (y + transformY) * screenHeight / DEFAULT_HEIGHT;
        this.sprite.setTransform(this.transform);
        this.sprite.setRefPixelPosition(drawX + adjustX, drawY);
        this.sprite.paint(graphics);
    }

    public void setLandaRotation(int angle) {
        int[] trans = new int[]{0, 5, 3, 6};
        this.setTransform(trans[(angle %= 360) / 90]);
        int frame = angle % 90 / 34;
        this.setFrame(frame);
    }
}

