/*
 * Decompiled with CFR 0.152.
 */
package com.gamsole.monsterninja;

import com.gamsole.monsterninja.models.LandaBase;
import com.gamsole.monsterninja.models.NinjaObject;
import java.util.Random;

public class GameSettings {
    public static final int DEVELOPER = 0;
    public static final int MAIN_SCREEN = 1;
    public static final int SELECT_LANGUAGE = 3;
    public static final int GAME_RUNNING = 100;
    public static final int GAMEOVER_WAIT = 205;
    public static final int GAMEOVER = 220;
    public String UserID;
    public String UserName;
    public boolean ShowHelp;
    public boolean IsPaused;
    public float DefaultAnimator;
    public int Status;
    public int Score;
    public int HighestScore;
    public int HelpIndex;
    public int BoardY;
    public int Lives;
    public int Bonus;
    public int SelectedMenu;
    public int SelectedNinjaObject;
    public int Wave;
    public double Delay;
    public boolean Sound;
    public boolean[] IsActive;
    public boolean NewHighScore;
    public boolean MovingLeft;
    public boolean MovingRight;
    public boolean Shooting;
    public float WaveAnimator;
    public boolean Explosion;
    public double ScreenY;
    public double accelerationX;
    public double accelerationY;
    public double velocityX;
    public double velocityY;
    public NinjaObject[] NinjaObjects;
    public Random random = new Random();

    public GameSettings() {
        this.CheckDefaults();
    }

    public void CheckDefaults() {
        this.HighestScore = new LandaBase().getValue("HighestScore");
    }

    public void StartGame() {
        this.Score = 0;
        this.Wave = 0;
        this.Lives = 3;
        this.Explosion = false;
        this.ResetStage();
        this.Status = 100;
    }

    public void ResetStage() {
        ++this.Wave;
        this.SelectedNinjaObject = -1;
        this.WaveAnimator = 0.0f;
        int objectCount = this.Wave / 5 + 2;
        if (this.Wave == 1) {
            objectCount = 1;
        } else if (objectCount > 4) {
            objectCount = 4;
        }
        this.NinjaObjects = new NinjaObject[objectCount];
        this.IsActive = new boolean[this.NinjaObjects.length];
        for (int i = 0; i < this.NinjaObjects.length; ++i) {
            float velocityY = 100.0f;
            float accelerationY = 500.0f + 20.0f * (float)this.Wave;
            if (accelerationY > 1000.0f) {
                accelerationY = 1000.0f;
            }
            int status = this.random.nextInt(100) % 2 == 0 ? 1 : 2;
            float x = 55 + this.random.nextInt(410);
            float y = 550.0f;
            float velocityX = 150.0f * (float)this.random.nextInt((int)x - 50) / 470.0f;
            if (status == 2) {
                velocityX = 150.0f * (float)this.random.nextInt(470 - (int)x) / 470.0f;
            }
            int type = this.random.nextInt(100) % 6;
            this.NinjaObjects[i] = new NinjaObject(velocityX, velocityY, accelerationY, type, status, x, y);
        }
        this.Delay = 1000.0;
    }

    public void updateGameRunning(double gameTime) {
        this.Delay -= (double)((float)(gameTime * 1000.0));
        if (this.Delay <= 0.0) {
            this.Delay = 100.0f + (float)this.random.nextInt(4) * 100.0f;
            for (int i = 0; i < this.IsActive.length; ++i) {
                if (this.IsActive[i]) continue;
                this.IsActive[i] = true;
                break;
            }
        }
        int deadCount = 0;
        for (int i = 0; i < this.NinjaObjects.length && this.IsActive[i]; ++i) {
            if (this.NinjaObjects[i].update(gameTime)) {
                this.didMiss();
            }
            if (this.NinjaObjects[i].status != -1) continue;
            ++deadCount;
        }
        if (deadCount == this.NinjaObjects.length) {
            this.WaveAnimator += (float)(gameTime * 1000.0);
            if (this.WaveAnimator >= 500.0f) {
                this.ResetStage();
            }
        }
    }

    void didMiss() {
        --this.Lives;
        if (this.Lives <= 0) {
            this.Gameover();
        }
    }

    void updateScore() {
        ++this.Score;
    }

    public void Gameover() {
        this.BoardY = -490;
        this.DefaultAnimator = 0.0f;
        this.Status = 205;
        if (this.Score > this.HighestScore) {
            this.HighestScore = this.Score * 1;
            new LandaBase().addValueCommit("HighestScore", this.HighestScore);
        }
    }
}

