/*
 * Decompiled with CFR 0.152.
 */
package com.gamsole.monsterninja;

import com.gamsole.monsterninja.JavaSprite;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LanderAlpha {
    public static final int WHITE = 0;
    public static final int YELLOW = 1;
    public static final int GREEN = 2;
    public static final int RED = 3;
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    public static final byte MESSAGEBOX = 0;
    public static final byte CONFIRM = 1;
    public static final byte NONE = 0;
    public static final byte NO = 1;
    public static final byte YES = 2;
    public static final byte OK = 3;
    public static final String[] smilies = new String[]{":)", ";)", ":(", ">:O", ":D", ":'(", ":O", ":p", "B-)", ":x", ":s", ":$", ":*", ":/", "<3", "(y)", "(n)", ":&", ":>", "=D", "<3<3", ";;)", "=))", "/:)", "#:-s", ":|", "({})", ">:/", "</3", "O:)", "nerd", "(=|", "=-?", "8-|", "<=-P", ">=)", "=)]", "=-c", "X_X", "(*)", "\\=D/", "*..*"};
    public static final byte ARROW_UP = 0;
    public static final byte ARROW_LEFT = 1;
    public static final byte ARROW_RIGHT = 2;
    public static final byte ARROW_DOWN = 3;
    public static int LastX;
    public static int firstX;
    public static byte messageStatus;

    public void drawMessage(Graphics graphics, Font paint, String message, int textColor, int highlightColor, byte messageType) {
        int yes = textColor;
        int no = textColor;
        int ok = textColor;
        this.drawString(graphics, paint, message, 100, 100, 600, textColor);
        if (messageType == 0) {
            this.drawString(graphics, paint, "OK", 0, 380, 800, ok);
        } else {
            this.drawString(graphics, paint, "YES", 0, 380, 300, yes);
            this.drawString(graphics, paint, "NO", 500, 380, 300, no);
        }
    }

    public int displayString(Graphics graphics, Font paint, String text, int y) {
        int stringWidth = paint.stringWidth(text) * JavaSprite.DEFAULT_WIDTH / JavaSprite.screenWidth;
        int x = (JavaSprite.DEFAULT_WIDTH - stringWidth) / 2;
        return this.displayString(graphics, paint, text, x, y);
    }

    public int isDrawSmiley(Graphics graphics, String text, int x, int y) {
        int length = 0;
        return length;
    }

    public int isSmiley(String text) {
        int length = 0;
        return length;
    }

    public String backspace(String text) {
        int i = text.length() - 4;
        int l = 0;
        if (i < 0) {
            i = 0;
        }
        while ((l = this.isSmiley(text.substring(i))) <= 0 && ++i <= text.length() - 1) {
        }
        if (l == 0) {
            l = 1;
        }
        if (text.length() > 0) {
            text = text.substring(0, text.length() - l);
        }
        return text;
    }

    public int length(String text) {
        int len = 0;
        for (int i = 0; i < text.length(); ++i) {
            int sx = this.isSmiley(text.substring(i));
            if (sx > 0) {
                i += sx - 1;
            }
            ++len;
        }
        return len;
    }

    public int textWidth(String text, Font paint) {
        int len = 0;
        for (int i = 0; i < text.length(); ++i) {
            int sx = this.isSmiley(text.substring(i));
            if (sx > 0) {
                i += sx - 1;
                len += 24;
            }
            len += paint.stringWidth("" + text.charAt(i)) * JavaSprite.DEFAULT_WIDTH / JavaSprite.screenWidth;
        }
        return len;
    }

    public int displayString(Graphics graphics, Font paint, String text, int x, int y) {
        return this.displayString(graphics, paint, text, x, y, 0);
    }

    public int displayString(Graphics graphics, Font paint, String text, int x, int y, int color) {
        int dx;
        graphics.setFont(paint);
        if (color == 0) {
            graphics.setColor(255, 255, 255);
        } else if (color == 1) {
            graphics.setColor(255, 255, 0);
        } else if (color == 3) {
            graphics.setColor(255, 0, 0);
        } else if (color == 2) {
            graphics.setColor(0, 255, 0);
        } else {
            graphics.setColor(0, 100, 255);
        }
        int end = 0;
        int width = 24;
        firstX = dx = x;
        LastX = dx;
        for (int i = 0; i < text.length(); ++i) {
            String smile = text.substring(i);
            int sx = this.isDrawSmiley(graphics, smile, x, y);
            if (sx > 0) {
                i += sx - 1;
                dx += 32;
                x += 32;
                continue;
            }
            char c = text.charAt(i);
            graphics.drawString("" + c, dx * JavaSprite.screenWidth / JavaSprite.DEFAULT_WIDTH, y * JavaSprite.screenHeight / JavaSprite.DEFAULT_HEIGHT, 20);
            dx += paint.stringWidth("" + c) * JavaSprite.DEFAULT_WIDTH / JavaSprite.screenWidth;
            x += paint.stringWidth("" + c) * JavaSprite.DEFAULT_WIDTH / JavaSprite.screenWidth;
        }
        LastX = end = dx;
        return end;
    }

    int Length(Font paint, String word) {
        int l = 0;
        for (int i = 0; i < word.length(); ++i) {
            String smile = word.substring(i);
            int sx = this.isSmiley(smile);
            if (sx > 0) {
                i += sx - 1;
                l += 32;
                continue;
            }
            char c = word.charAt(i);
            l += paint.stringWidth("" + c) * JavaSprite.DEFAULT_WIDTH / JavaSprite.screenWidth;
        }
        return l;
    }

    public int Height(Font font) {
        return font.getHeight() + font.getBaselinePosition();
    }

    public String[] split(String _strMessage, String _delimiter) {
        Vector<String> result = new Vector<String>();
        int pos = 0;
        int len = _strMessage.length();
        int lenD = _delimiter.length();
        for (int i = 0; i < len; ++i) {
            if (!_strMessage.substring(i, i + lenD).equals(_delimiter)) continue;
            if (i == pos) {
                result.addElement("");
            } else if (i > pos) {
                result.addElement(_strMessage.substring(pos, i));
            }
            pos = i + lenD;
            i += lenD - 1;
        }
        if (pos < len) {
            result.addElement(_strMessage.substring(pos, len));
        }
        String[] array = new String[result.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)result.elementAt(i);
        }
        return array;
    }

    public int drawString(Graphics graphics, Font paint, String text, int x, int y, int width) {
        return this.drawString(graphics, paint, text, x, y, width, 0);
    }

    public int drawString(Graphics graphics, Font paint, String text, int x, int y, int width, int color) {
        return this.drawString(graphics, paint, text, x, y, width, (byte)1, color);
    }

    public int drawString(Graphics graphics, Font paint, String text, int x, int y, int width, byte alignment, int color) {
        graphics.setFont(paint);
        LastX = x + width / 2;
        Vector<String> lines = new Vector<String>();
        String[] words = this.split(text, " ");
        for (int i = 0; i < words.length; ++i) {
            int w;
            String line = "";
            block1: for (int textWidth = 0; textWidth < width && i <= words.length - 1; textWidth += w, ++i) {
                String word = words[i];
                if (line.length() > 0) {
                    word = " " + word;
                }
                if ((w = this.Length(paint, word)) > width && line.length() == 0) {
                    textWidth = 0;
                    while (true) {
                        int st = 1;
                        while (this.Length(paint, word.substring(st)) < width && st + 1 < word.length()) {
                            ++st;
                        }
                        if (st + 1 >= word.length()) {
                            lines.addElement(word);
                            line = word;
                            break block1;
                        }
                        lines.addElement(word.substring(0, st + 1));
                        word = word.substring(st + 1);
                    }
                }
                if (textWidth + w > width) {
                    --i;
                    break;
                }
                if (line.length() > 0) {
                    line = line + " ";
                }
                line = line + words[i];
            }
            lines.addElement(line);
        }
        int dx = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int w = 5;
            int tw = this.Length(paint, (String)lines.elementAt(i));
            if (alignment == 1) {
                w = (width - tw) / 2;
            }
            dx = alignment == 2 ? x + width - (tw + 5) : x + w;
            this.displayString(graphics, paint, (String)lines.elementAt(i), dx, y, color);
            y += paint.getHeight() + paint.getBaselinePosition() * 2;
        }
        return y;
    }

    public String format(String mask, long n) {
        String value = "";
        String ds = Long.toString(n);
        value = mask.substring(0, mask.length() - ds.length()) + ds;
        return value;
    }

    public String format(String mask, int n) {
        String value = "";
        String ds = Long.toString(n);
        value = mask.substring(0, mask.length() - ds.length()) + ds;
        return value;
    }
}

