/*
 * Decompiled with CFR 0.152.
 */
package com.gamsole.monsterninja.models;

import com.gamsole.monsterninja.JavaSprite;
import com.gamsole.monsterninja.models.BaseObject;
import javax.microedition.lcdui.Graphics;

public class NinjaObject
extends BaseObject {
    public float velocityY;
    public float velocityX;
    public float accelerationY;
    public float distance;
    public float G;
    public float animator;
    public static final float G_RATIO = -1.2f;

    public NinjaObject(float velocityX, float velocityY, float accelerationY, int type, int status, float x, float y) {
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.accelerationY = accelerationY;
        this.G = (float)((double)-1.2f - (double)(accelerationY - 500.0f) * 0.3 / 500.0) * accelerationY;
        this.type = type;
        this.status = status;
        this.x = x;
        this.y = y;
        this.animator = 0.0f;
    }

    public boolean update(double gameTime) {
        boolean escaped = false;
        if (this.status == -1) {
            this.animator += (float)gameTime * 1000.0f;
        } else {
            this.velocityY = (float)((double)this.velocityY + gameTime * (double)this.accelerationY);
            this.y = (float)((double)this.y - (double)this.velocityY * gameTime);
            this.distance = (float)((double)this.distance + Math.abs((double)this.velocityY * gameTime));
            if (this.status == 1) {
                this.x = (float)((double)this.x - gameTime * (double)this.velocityX);
            } else if (this.status == 2) {
                this.x = (float)((double)this.x + gameTime * (double)this.velocityX);
            }
            this.accelerationY = (float)((double)this.accelerationY + gameTime * (double)this.G);
            if (this.velocityY < 0.0f && this.y >= 480.0f) {
                if (this.type != 5) {
                    escaped = true;
                }
                this.status = -1;
            }
        }
        return escaped;
    }

    public void draw(Graphics graphics, JavaSprite javaSprite, JavaSprite destroySprite) {
        int l = (int)this.distance % 400;
        int[] trans = new int[]{0, 5, 3, 6};
        if (this.status == -1 && this.type != 5) {
            if (this.animator < 250.0f) {
                int distance = (int)(48.0f + this.animator * 48.0f / 250.0f);
                float midpointX = this.x + 48.0f;
                float midpointY = this.y + 48.0f;
                destroySprite.setFrame(0);
                destroySprite.setRefPixelPosition(midpointX - (float)distance, midpointY - (float)distance);
                destroySprite.paint(graphics);
                destroySprite.setFrame(1);
                destroySprite.setRefPixelPosition(midpointX + (float)distance, midpointY - (float)distance);
                destroySprite.paint(graphics);
                destroySprite.setFrame(2);
                destroySprite.setRefPixelPosition(midpointX - (float)distance, midpointY + (float)distance);
                destroySprite.paint(graphics);
                destroySprite.setFrame(3);
                destroySprite.setRefPixelPosition(midpointX + (float)distance, midpointY + (float)distance);
                destroySprite.paint(graphics);
            }
        } else {
            javaSprite.setLandaRotation(l * 360 / 400);
            javaSprite.setRefPixelPosition(this.x, this.y);
            javaSprite.paint(graphics);
        }
    }
}

