/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.graphics;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.util.Rectangle;

public class Rendering2D {
    public static void paintImageFromSkin3H(Graphics g, Sprite skin, Rectangle bounds) {
        int step;
        int skinWidth = skin.getWidth();
        skin.setFrame(1);
        int to = bounds.getRight() - skin.getWidth();
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle r = new Rectangle(step, bounds.y, to - step, skin.getHeight());
        Rectangle intersect = clip.getIntersectsRectangle(r);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        for (step = bounds.x + skin.getWidth(); step < to; step += skinWidth) {
            skin.setPosition(step, bounds.y);
            skin.paint(g);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        skin.setFrame(0);
        skin.setPosition(bounds.x, bounds.y);
        skin.paint(g);
        skin.setFrame(2);
        skin.setPosition(bounds.getRight() - skin.getWidth(), bounds.y);
        skin.paint(g);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static void paintImageFromSkin3V(Graphics g, Sprite skin, Rectangle bounds) {
        int step;
        int skinHeight = skin.getHeight();
        skin.setFrame(1);
        int to = bounds.getBottom() - skin.getHeight();
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle r = new Rectangle(bounds.x, step, skin.getWidth(), to - step);
        Rectangle intersect = clip.getIntersectsRectangle(r);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        for (step = bounds.y + skin.getHeight(); step < to; step += skinHeight) {
            skin.setPosition(bounds.x, step);
            skin.paint(g);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        skin.setFrame(0);
        skin.setPosition(bounds.x, bounds.y);
        skin.paint(g);
        skin.setFrame(2);
        skin.setPosition(bounds.x, bounds.getBottom() - skin.getHeight());
        skin.paint(g);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static void paintImageFromSkin1H(Graphics g, Image skin, Rectangle bounds) {
        int skinWidth = skin.getWidth();
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle intersect = clip.getIntersectsRectangle(bounds);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        int to = intersect.getRight();
        for (int step = bounds.x; step < to; step += skinWidth) {
            if (step + skinWidth < intersect.x) continue;
            g.drawImage(skin, step, intersect.y, 20);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static void paintImageFromSkin1V(Graphics g, Image skin, Rectangle bounds) {
        int skinHeight = skin.getHeight();
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle intersect = clip.getIntersectsRectangle(bounds);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        int to = intersect.getBottom();
        for (int step = intersect.y; step < to; step += skinHeight) {
            g.drawImage(skin, intersect.x, step, 20);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static void paintImageFromSkin3HV(Graphics g, Sprite skin, Rectangle bounds) {
        int stepX;
        Rectangle r;
        int skinWidth = skin.getWidth();
        int skinHeight = skin.getHeight();
        int stepY = bounds.y + skinHeight;
        int toHorizontal = bounds.getRight() - skinWidth;
        int toVertical = bounds.getBottom() - skinHeight;
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle intersect = clip.getIntersectsRectangle(r = new Rectangle(stepX, bounds.y, bounds.width - 2 * skinWidth, bounds.height));
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        for (stepX = bounds.x + skinWidth; stepX < toHorizontal; stepX += skinWidth) {
            skin.setFrame(1);
            skin.setPosition(stepX, bounds.y);
            skin.paint(g);
            skin.setFrame(7);
            skin.setPosition(stepX, toVertical);
            skin.paint(g);
        }
        r.x = bounds.x;
        r.y = stepY;
        r.width = bounds.width;
        r.height = bounds.height - 2 * skinHeight;
        intersect = clip.getIntersectsRectangle(r);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        while (stepY < toVertical) {
            skin.setFrame(3);
            skin.setPosition(bounds.x, stepY);
            skin.paint(g);
            skin.setFrame(5);
            skin.setPosition(toHorizontal, stepY);
            skin.paint(g);
            stepY += skinHeight;
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        skin.setFrame(0);
        skin.setPosition(bounds.x, bounds.y);
        skin.paint(g);
        skin.setFrame(2);
        skin.setPosition(bounds.getRight() - skinWidth, bounds.y);
        skin.paint(g);
        skin.setFrame(6);
        skin.setPosition(bounds.x, bounds.getBottom() - skinHeight);
        skin.paint(g);
        skin.setFrame(8);
        skin.setPosition(bounds.getRight() - skinWidth, bounds.getBottom() - skinHeight);
        skin.paint(g);
        r.x = bounds.x + skinWidth;
        r.y = bounds.y + skinHeight;
        r.width = bounds.width - 2 * skinWidth;
        r.height = bounds.height - 2 * skinHeight;
        intersect = clip.getIntersectsRectangle(r);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        int a = 0;
        stepY = bounds.y + skinHeight;
        for (stepX = bounds.x + skinWidth; stepX < toHorizontal; stepX += skinWidth) {
            while (stepY < toVertical) {
                ++a;
                skin.setFrame(4);
                skin.setPosition(stepX, stepY);
                skin.paint(g);
                stepY += skinHeight;
            }
            stepY = bounds.y + skinHeight;
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static void paintImageFromSkin1HV(Graphics g, Image skin, Rectangle bounds) {
        int skinWidth = skin.getWidth();
        int skinHeight = skin.getHeight();
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        Rectangle intersect = clip.getIntersectsRectangle(bounds);
        if (intersect == null) {
            return;
        }
        g.setClip(intersect.x, intersect.y, intersect.width, intersect.height);
        int stepX = bounds.x;
        int toHorizontal = intersect.getRight();
        int toVertical = intersect.getBottom();
        for (int stepY = bounds.y; stepY < toVertical; stepY += skinHeight) {
            while (stepX < toHorizontal) {
                if (stepX + skinWidth >= intersect.x && stepY + skinHeight >= intersect.y) {
                    g.drawImage(skin, stepX, stepY, 20);
                }
                stepX += skinWidth;
            }
            stepX = bounds.x;
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }
}

