/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_ROTATE = 0;
    public static final int IMG_INLOGIC = 1;
    public static final int IMG_LOGO_1 = 2;
    public static final int IMG_LOGO_2 = 3;
    public static final int IMG_GAME_BG = 4;
    public static final int IMG_ICON_BTN = 5;
    public static final int TOTAL_IMGS = 6;
    public static Image[] resImgs = new Image[6];
    public static final int SPR_LANGUAGE = 0;
    public static final int SPR_ICONS = 1;
    public static final int SPR_DIALOG = 2;
    public static final int SPR_ARROWS_INSTRUCTIONS = 3;
    public static final int SPR_MENU_BTN = 4;
    public static final int SPR_POINTS_1 = 5;
    public static final int SPR_POINTS_2 = 6;
    public static final int SPR_POINTS_3 = 7;
    public static final int SPR_POINTS_4 = 8;
    public static final int SPR_DIALOG_2 = 9;
    public static final int TOTAL_SPRS = 10;
    public static Sprite[] resSprs = new Sprite[10];
    public static final int GFONT_MAIN = 0;
    public static final int GFONT_NUMBERS = 1;
    public static final int TOTAL_GFONTS = 2;
    public static GFont[] resGFonts = new GFont[2];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_ENABLE_MUSIC_QUESTION = 2;
    public static final int TEXT_MAIN_YES = 3;
    public static final int TEXT_MAIN_NO = 4;
    public static final int TEXT_MAIN_MENU = 5;
    public static final int TEXT_MAIN_BACK = 6;
    public static final int TEXT_MAIN_PLAY = 7;
    public static final int TEXT_MAIN_INSTRUCTIONS = 8;
    public static final int TEXT_MAIN_SOUND = 9;
    public static final int TEXT_MAIN_ABOUT = 10;
    public static final int TEXT_MAIN_RESUME = 11;
    public static final int TEXT_MAIN_QUIT = 12;
    public static final int TEXT_MAIN_QUIT_TO_MENU = 13;
    public static final int TEXT_MAIN_QUIT_TO_MENU_QUESTION = 14;
    public static final int TEXT_MAIN_ON = 15;
    public static final int TEXT_MAIN_OFF = 16;
    public static final int TEXT_MAIN_VERSION = 17;
    public static final int TEXT_MAIN_EXIT_APP_QUESTION = 18;
    public static final int TEXT_MAIN_CONTINUE = 19;
    public static final int TEXT_MAIN_PAUSE = 20;
    public static final int TEXT_MAIN_GAME_OVER = 21;
    public static final int TEXT_MAIN_GAME_PAUSED = 22;
    public static final int TEXT_MAIN_LENGTH = 23;
    public static final int TEXT_MAIN_PLACE = 24;
    public static final int TEXT_MAIN_BEST = 25;
    public static final int TEXT_MAIN_NEW_RECORD = 26;
    public static final int TEXT_MAIN_ABBREVIATIONS = 27;
    public static final int TEXT_MAIN_INSTRUCTIONS_TEXT = 35;
    public static final int TEXT_MAIN_CONTROLS_TEXT_TOUCH = 36;
    public static final int TEXT_MAIN_CONTROLS_TEXT_KEYBOARD = 37;
    public static boolean sysFont;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            System.out.println(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "I.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "had_menu_01.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "nadpis_menu_01.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "tiles_01.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "tlacidlo_01.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "vlajky_01.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "ikony_01.png";
                slicesX = 15;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "dialogove_01.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "sipky_01.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "tlacidlo_02.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "gulky_01.png";
                slicesX = 9;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "gulky_02.png";
                slicesX = 9;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "gulky_03.png";
                slicesX = 9;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "gulky_04.png";
                slicesX = 9;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "dialogove_02.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = null;
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 9: {
                fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', 'a', '\u00e6', 'b', 'c', 'd', '\u00f0', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e1', '\u00e0', '\u00e4', '\u00e5', '\u00e2', '\u00e3', '\u00e7', '\u010d', '\u010f', '\u00e9', '\u00e8', '\u00eb', '\u00ea', '\u00ed', '\u00ec', '\u00ef', '\u00ee', '\u013e', '\u0148', '\u00f1', '\u00f3', '\u00f2', '\u00f6', '\u00f4', '\u00f5', '\u00fa', '\u00f9', '\u00fc', '\u00fb', '\u016f', '\u00fd', '\u0155', '\u0159', '\u015b', '\u0161', '\u0165', '\u017e', '\u00df', '&', '@', '\\', '%', '+', '=', '\u00f7', '-', '.', ',', ':', '\'', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '|', '\u00a9', '(', ')', '/', ';', '$', '*', '#', ' '};
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 6, 4, 4, 4, 5, 4, 3, 4, 4, 1, 3, 5, 4, 5, 4, 4, 4, 4, 4, 4, 5, 4, 5, 7, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 1, 1, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 3, 5, 3, 3, 3, 3, 3, 3, 3, 3, 1, 2, 4, 1, 5, 3, 3, 3, 3, 2, 3, 3, 3, 4, 5, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 2, 2, 3, 3, 4, 4, 4, 4, 5, 2, 6, 5, 4, 5, 2, 1, 1, 1, 1, 3, 1, 3, 1, 3, 4, 3, 2, 3, 3, 4, 3, 3, 3, 3, 3, 1, 6, 2, 2, 2, 1, 3, 5, 5, 2};
                break;
            }
            case 13: {
                fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\\', '\\', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '\'', '\"', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', ' '};
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5, 4};
                break;
            }
            case 22: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u00ca', '\u00c9', '\u00c8', '\u00cb', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u00d1', '\u0147', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u0160', '\u015a', '\u0164', '\u00dd', '\u017d', '$', '\u00a3', '\u00a5', '#', '*', '@', '\\', '\u20ac', '\u00ae', '\u00a9', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '-', '=', ';', ',', '.', ':', '\"', '\'', '!', '?', '\u2014', '\u00f7', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00df', 'D', '\u00a1', '\u00bf', '/', ' '};
                spaceBetweenChars = 0;
                fontCharsWidth = new short[]{11, 9, 10, 11, 8, 8, 11, 10, 5, 5, 11, 7, 14, 11, 12, 8, 14, 10, 8, 10, 11, 11, 16, 10, 10, 12, 11, 11, 11, 11, 11, 10, 10, 11, 8, 8, 8, 5, 5, 7, 7, 8, 11, 12, 11, 11, 12, 11, 12, 10, 11, 11, 10, 9, 8, 10, 10, 10, 8, 10, 10, 10, 8, 14, 9, 10, 10, 12, 13, 6, 6, 8, 7, 6, 5, 4, 13, 6, 8, 8, 9, 6, 9, 5, 5, 5, 4, 6, 3, 4, 7, 17, 9, 9, 7, 9, 9, 9, 9, 9, 9, 8, 10, 9, 12, 5, 7, 9, 9};
                break;
            }
            case 32: {
                fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\\', '\\', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '\'', '\"', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', ' '};
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{17, 23, 13, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14, 13};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[fontCharsWidth.length - 1]);
    }

    private static GFont createGFontNumbers(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '#', ' '};
        short[] fontCharsWidth = new short[fontChars.length];
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 10: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{7, 5, 7, 7, 7, 6, 7, 7, 7, 7, 8, 7};
                break;
            }
            case 14: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{10, 6, 10, 10, 10, 10, 10, 10, 10, 10, 11, 10};
                break;
            }
            case 18: {
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{13, 8, 12, 12, 13, 12, 13, 13, 12, 13, 14, 13};
                break;
            }
            case 27: {
                spaceBetweenChars = 4;
                fontCharsWidth = new short[]{19, 11, 19, 19, 20, 18, 19, 18, 19, 18, 21, 19};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[fontCharsWidth.length - 1]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "cisla.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbers(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }
}

