/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameDefs;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    MainCanvas mainCanvas;
    GFont fontMain;
    GFont fontNumbers;
    Particles part;
    final byte SCREEN_INTRO;
    final byte SCREEN_MENU;
    final byte SCREEN_GAME = (byte)2;
    final byte INTRO_INIT_GRAPHICS;
    final byte INTRO_INIT;
    final byte INTRO_INLOGIC = (byte)2;
    final byte INTRO_LANGUAGE = (byte)3;
    final byte MENU_MAIN;
    final byte MENU_SETTINGS;
    final byte MENU_INSTRUCTIONS = (byte)2;
    final byte MENU_QUIT = (byte)3;
    final byte GAME_MAIN;
    final byte GAME_OVER;
    final byte GAME_PAUSE = (byte)2;
    final byte GAME_PAUSE_SETTINGS = (byte)3;
    final byte GAME_PAUSE_INSTRUCTIONS = (byte)4;
    final byte GAME_PAUSE_QUIT_TO_MENU = (byte)5;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_SETTINGS;
    final byte ID_MENU_INSTRUCTIONS = (byte)2;
    final byte TOTAL_MENU_ITEMS = (byte)3;
    final byte ID_PAUSE_SETTINGS;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_QUIT_TO_MENU = (byte)2;
    final byte TOTAL_PAUSE_ITEMS = (byte)3;
    final int TOTAL_SETTINGS_ITEMS;
    final int TOTAL_FAKE_AI_SNAKES;
    final int TOTAL_AI_SNAKES;
    final int TOTAL_POINTS;
    final int MAX_GAMEPLAY_SIZE_1;
    final int MAX_GAMEPLAY_SIZE_2;
    final int SNAKE_DEFAULT_LENGTH;
    final int MAX_SNAKE_LENGTH;
    final int SNAKE_DEFAULT_SIZE;
    final int SNAKE_TILES_SHIFT;
    final int BIG_MOVING_POINT_SCORE;
    final int DELAY_TIME;
    final int GAME_OVER_DELAY;
    final int AFTER_PAUSE_DELAY;
    final int SNAKE_REACTION_DELAY;
    final int CRASHED_SNAKE_DELAY;
    final int BIG_MOVING_POINT_DELAY;
    final int FAST_SNAKE_DELAY;
    final int FAST_SNAKE_GENERATE_POINT_DELAY;
    final int FAST_DURATION_MIN_DELAY;
    final int FAST_DURATION_MAX_DELAY;
    final int FAST_COUNTDOWN_MIN_DELAY;
    final int FAST_COUNTDOWN_MAX_DELAY;
    final int FAST_GLOW_DELAY;
    final int PLACE_DELAY;
    private int delay;
    Image imgInlogic;
    Image imgLogo1;
    Image imgLogo2;
    Image imgGameBg;
    Image imgIconBtn;
    Sprite sprLanguage;
    Sprite sprIcon;
    Sprite sprMenuBtn;
    Sprite sprDialog;
    Sprite sprArrowInstructions;
    Sprite sprPoints1;
    Sprite sprPoints2;
    Sprite sprPoints3;
    Sprite sprPoints4;
    Sprite sprDialog2;
    PreparedText prepText;
    Rectangle[] rectMenuItems;
    Rectangle[] rectPauseItems;
    Rectangle[] rectArrowsInstructions = new Rectangle[2];
    Rectangle rectLabelCenter;
    Rectangle rectDialog;
    Rectangle rectBigMovingPoint;
    Rectangle rectScoring;
    Rectangle rectAIScoring;
    Rectangle rectPomMenuBtn;
    Rectangle rectPomDialog;
    Rectangle[] rectSnake = new Rectangle[501];
    Rectangle[][] rectAISnake = new Rectangle[4][501];
    Rectangle[] rectPoint = new Rectangle[350];
    Rectangle rectSnakeCollision;
    Rectangle rectAISnakeCollision;
    Rectangle rectFastBtn;
    int iScreen;
    int iSubScreen;
    int iSelectedItem = 0;
    int iSelectedSettingsItem = 0;
    int iShiftDirection;
    int iShiftX;
    int iShiftStep;
    int updateCounter = 0;
    int iActualBestPlace = 0;
    int iActualMaxLength = 0;
    int iShowedMaxLength = 0;
    int iShowedBestPlace = 0;
    int iInstructionsShiftY = 0;
    int iInstructionsMaxShiftY = 0;
    int iTextLines = 0;
    int iCarY = 0;
    int tempScreen = 0;
    int tempSubScreen = 0;
    int iSelectorStep = 1;
    int iSelectorDirection = 1;
    int iSelectorX = 0;
    int iStatusBarY = 0;
    int iStatusBarActualY = 0;
    int iShowedItemsCounter = 0;
    int iShowedItems = -1;
    int iMaxShowedItems = 0;
    int iShiftControlLeftX = 0;
    int iShiftControlRightX = 0;
    int iControlsShiftIn = 0;
    int iControlsShiftOut = 0;
    int iMenuCenterY = 0;
    int iPauseMenuShiftY = 0;
    int iLogoYIn;
    int iLogoYIn2;
    int iLogoYOut;
    int iLogoActualY;
    int iLogoHeight;
    int iInstructionsY;
    int iInstructionsContentY;
    int iInstructionsHeight;
    int iInstructionsContentHeight;
    int iInstructionsWidth;
    int iBaseLabelHeight;
    int iDialogWidth;
    int iGameOverStep = 0;
    int iGameOverCounter = 0;
    int iGameOverHeight;
    int iGameOverContentHeight;
    int iGameOverWidth;
    int iBeforeGameOverCounter = 0;
    int iFontShiftY = 0;
    int iBgCount = 0;
    int iBgHeight = 0;
    int iBgShiftY0 = 0;
    int iBgShiftY1 = 0;
    int iControlsSpeed = 0;
    int iControlsShiftX = 0;
    int iControlsShiftY = 0;
    int iBlinkingPointCounter = 0;
    int iBlinkingGameOverCounter = 0;
    int iLogoSpringStep = 0;
    int iLogoSpringY = 0;
    int iAfterPauseCounter = 0;
    int iGameplayWidth = 0;
    int iGameplayHeight = 0;
    int iSnakePlace = 0;
    int iSnakeSize = 0;
    int iSnakeTileSize = 0;
    int iSnakeLength = 0;
    int iSnakeSpeed = 0;
    int iSnakeCursorX = -1;
    int iSnakeCursorY = -1;
    int iSnakeDdaShiftX = -1;
    int iSnakeDdaShiftY = -1;
    int iNewShiftX = -1;
    int iNewShiftY = -1;
    int iSnakeNewTiles = 0;
    int iSnakeColor = 0;
    int iSnakeSizeDivisor = 0;
    int iAiSnakeLengthStep = 0;
    int[] iAISnakeSize = new int[4];
    int[] iAISnakeTileSize = new int[4];
    int[] iAISnakeLength = new int[4];
    int[] iAISnakeSpeed = new int[4];
    int[] iAISnakeCursorX = new int[4];
    int[] iAISnakeCursorY = new int[4];
    int[] iAISnakeDdaShiftX = new int[4];
    int[] iAISnakeDdaShiftY = new int[4];
    int[] iAISnakeNewTiles = new int[4];
    int[] iAISnakeColor = new int[4];
    int[] iAISnakeReactionDelayCounter = new int[4];
    int[] iAISnakeReactionDirection = new int[4];
    int[] iAISnakeReturnType = new int[4];
    int[] iFakeAISnakeLength = new int[15];
    int iActivePointsCount = 0;
    int iPointsAreaWidth = 0;
    int iPointsAreaHeight = 0;
    int iPointsAreaShiftX = 0;
    int iPointsAreaShiftY = 0;
    int[] iPointSize = new int[350];
    int[] iPointColor = new int[350];
    int iSnakeEyeLeftX = 0;
    int iSnakeEyeLeftY = 0;
    int iSnakeEyeRightX = 0;
    int iSnakeEyeRightY = 0;
    int[] iAISnakeEyeLeftX = new int[4];
    int[] iAISnakeEyeLeftY = new int[4];
    int[] iAISnakeEyeRightX = new int[4];
    int[] iAISnakeEyeRightY = new int[4];
    int iCrashedSnakeCounter = 0;
    int[] iCrashedAISnakeCounter = new int[4];
    int iBigMovingPointDelayCounter = 0;
    int iBigMovingPointColor = 0;
    int iFastSnakeCounter = 0;
    int[] iFastAISnakeCounter = new int[4];
    int iFastSnakePointsCounter = 0;
    int[] iFastAISnakePointsCounter = new int[4];
    int iFastSnakeGlowCounter = 0;
    int[] iFastAISnakeGlowCounter = new int[4];
    int iPlaceDelayCounter = 0;
    int iPlaceDecrement = 0;
    boolean bLoading = false;
    boolean bGameOver = false;
    boolean bDragInstructions = false;
    boolean bNextScreen = false;
    boolean bControlLeftScrollIn = false;
    boolean bControlLeftScrollOut = false;
    boolean bControlRightScrollIn = false;
    boolean bControlRightScrollOut = false;
    boolean bGamePaused = true;
    boolean bNewRecord = false;
    boolean bBeforeGameOver = false;
    boolean[] bActivePoint = new boolean[350];
    boolean[] bPointBeforeEating = new boolean[350];
    boolean[] bMovingPoint = new boolean[350];
    boolean bSnakeCrashed = false;
    boolean[] bAISnakeCrashed = new boolean[4];
    boolean[] bAISnakeReactionChangeable = new boolean[4];
    boolean bBigMovingPointActive = false;
    boolean bBigMovingPointBeforeEating = false;
    boolean bFastSnake = false;
    boolean[] bFastAISnake = new boolean[4];
    boolean bFastSnakeGlow = false;
    boolean[] bFastAISnakeGlow = new boolean[4];
    String sPlay;
    String sAbout;
    String sInstructions;
    String sSoundOn;
    String sSoundOff;
    String sPause;
    String sQuitToMenu;
    String sGameOver;
    String sLength;
    String sPlace;
    String sResume;
    String sBest;
    String sNewRecord;
    String sGamePaused;
    int iBgCenterX = MainCanvas.WIDTH >> 1;
    int iBgCenterY = MainCanvas.HEIGHT >> 1;
    int iBgShiftX = 0;
    int iBgShiftY = 0;
    int iParticlesProbability = 0;
    int iBigMovingPointMoveType = -1;
    int iBigMovingPointMoveTypeLast = -1;
    int iBigMovingPointMoveCounter = 0;
    int iNextScreenCounter = 0;
    int[] PARTICLES_COLOR = new int[]{0xCCCCCC, 0xBBBBBB, 0xAAAAAA};

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_SETTINGS = 1;
        this.GAME_MAIN = 0;
        this.GAME_OVER = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_SETTINGS = 1;
        this.ID_PAUSE_SETTINGS = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.TOTAL_SETTINGS_ITEMS = 6;
        this.TOTAL_FAKE_AI_SNAKES = 15;
        this.TOTAL_AI_SNAKES = 4;
        this.TOTAL_POINTS = 350;
        this.MAX_GAMEPLAY_SIZE_1 = 15;
        this.MAX_GAMEPLAY_SIZE_2 = 20;
        this.SNAKE_DEFAULT_LENGTH = 11;
        this.MAX_SNAKE_LENGTH = 501;
        this.SNAKE_DEFAULT_SIZE = 5;
        this.SNAKE_TILES_SHIFT = 4;
        this.BIG_MOVING_POINT_SCORE = 20;
        this.DELAY_TIME = 3000;
        this.GAME_OVER_DELAY = 500;
        this.AFTER_PAUSE_DELAY = 500;
        this.SNAKE_REACTION_DELAY = 2000;
        this.CRASHED_SNAKE_DELAY = 300;
        this.BIG_MOVING_POINT_DELAY = 10000;
        this.FAST_SNAKE_DELAY = 250;
        this.FAST_SNAKE_GENERATE_POINT_DELAY = 500;
        this.FAST_DURATION_MIN_DELAY = 1000;
        this.FAST_DURATION_MAX_DELAY = 5000;
        this.FAST_COUNTDOWN_MIN_DELAY = 5000;
        this.FAST_COUNTDOWN_MAX_DELAY = 15000;
        this.FAST_GLOW_DELAY = 200;
        this.PLACE_DELAY = 250;
        this.mainCanvas = mainCanvas;
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!this.bLoading) {
            this.updateLogo();
            this.updateNextScreen(lTick);
            this.updateControlsPosition();
            this.updateShowedItems(lTick);
            block0 : switch (this.iScreen) {
                case 0: {
                    switch (this.iSubScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.initNextScreen(0, 3, false);
                            break block0;
                        }
                        case 3: {
                            this.updateSelector();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.iSubScreen) {
                        case 0: 
                        case 1: {
                            this.updateSelector();
                            break block0;
                        }
                        case 2: {
                            this.updateInstructions();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.iSubScreen) {
                        case 0: {
                            if (!this.bGamePaused) {
                                this.updateSnakesAndPoints(lTick);
                                this.updateScoring();
                                this.updatePlace(lTick);
                                this.updateAfterPauseCounter(lTick);
                                this.updateCollisions();
                            }
                            this.updateBeforeGameOver(lTick);
                            this.part.update2(this.iNewShiftX, this.iNewShiftY);
                            break block0;
                        }
                        case 1: {
                            this.updateGameOver(lTick);
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            this.updateSelector();
                            break block0;
                        }
                        case 4: {
                            this.updateInstructions();
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.mainCanvas.repaint();
        }
    }

    public void updateLogo() {
        if (this.iLogoSpringStep == 0) {
            this.iLogoSpringStep = MainCanvas.HEIGHT / 100;
            if (this.iLogoSpringStep < 1) {
                this.iLogoSpringStep = 1;
            }
        }
        if (this.iLogoSpringY != 0) {
            this.iLogoSpringY = 0;
        }
        int iType = 0;
        if (this.iScreen == 1 || this.tempScreen == 1) {
            if (this.iSubScreen == 0 || this.tempSubScreen == 0 || this.iSubScreen == 3 || this.tempSubScreen == 3) {
                iType = 1;
            } else if (this.iSubScreen == 1 || this.tempSubScreen == 1 || this.iSubScreen == 2 || this.tempSubScreen == 2) {
                iType = 2;
            }
        } else if (this.iScreen == 2 || this.tempScreen == 2) {
            if (this.iSubScreen == 2 || this.tempSubScreen == 2 || this.iSubScreen == 5 || this.tempSubScreen == 5) {
                iType = 3;
            } else if (this.iSubScreen == 1 || this.tempSubScreen == 1) {
                iType = 1;
            } else if (this.iSubScreen == 3 || this.tempSubScreen == 3 || this.iSubScreen == 4 || this.tempSubScreen == 4) {
                iType = 2;
            }
        }
        if (iType == 0) {
            if (this.iLogoActualY != this.iLogoYOut) {
                this.iLogoActualY -= this.iLogoHeight >> 3;
                if (this.iLogoActualY < this.iLogoYOut) {
                    this.iLogoActualY = this.iLogoYOut;
                }
            }
        } else if (iType == 1) {
            if (this.iLogoActualY != this.iLogoYIn) {
                if (this.iLogoActualY < this.iLogoYIn) {
                    this.iLogoActualY += this.iLogoHeight >> 3;
                    if (this.iLogoActualY > this.iLogoYIn) {
                        this.iLogoActualY = this.iLogoYIn;
                    }
                    if (this.iLogoActualY == this.iLogoYIn) {
                        this.iLogoSpringY = this.iLogoSpringStep;
                    }
                } else {
                    this.iLogoActualY -= this.iLogoHeight >> 3;
                    if (this.iLogoActualY < this.iLogoYIn) {
                        this.iLogoActualY = this.iLogoYIn;
                    }
                    if (this.iLogoActualY == this.iLogoYIn) {
                        this.iLogoSpringY = -this.iLogoSpringStep;
                    }
                }
            }
        } else if (iType == 2) {
            if (this.iLogoActualY != this.iLogoYIn2) {
                if (this.iLogoActualY < this.iLogoYIn2) {
                    this.iLogoActualY += this.iLogoHeight >> 3;
                    if (this.iLogoActualY > this.iLogoYIn2) {
                        this.iLogoActualY = this.iLogoYIn2;
                    }
                    if (this.iLogoActualY == this.iLogoYIn2) {
                        this.iLogoSpringY = this.iLogoSpringStep;
                    }
                } else {
                    this.iLogoActualY -= this.iLogoHeight >> 3;
                    if (this.iLogoActualY < this.iLogoYIn2) {
                        this.iLogoActualY = this.iLogoYIn2;
                    }
                    if (this.iLogoActualY == this.iLogoYIn2) {
                        this.iLogoSpringY = -this.iLogoSpringStep;
                    }
                }
            }
        } else if (iType == 3 && this.iLogoActualY != this.iLogoYIn + this.iPauseMenuShiftY) {
            this.iLogoActualY += this.iLogoHeight >> 3;
            if (this.iLogoActualY > this.iLogoYIn + this.iPauseMenuShiftY) {
                this.iLogoActualY = this.iLogoYIn + this.iPauseMenuShiftY;
            }
            if (this.iLogoActualY == this.iLogoYIn + this.iPauseMenuShiftY) {
                this.iLogoSpringY = this.iLogoSpringStep;
            }
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
            }
        }
    }

    public void updateScoring() {
        this.updateSnakeScoring();
        this.updateAISnakesScoring();
    }

    public void updateSnakeScoring() {
        if (this.bSnakeCrashed) {
            return;
        }
        if (this.rectScoring == null) {
            this.rectScoring = new Rectangle(0, 0, 0, 0);
        }
        int pom = 0;
        pom = MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? this.rectSnake[0].width >> 3 : this.rectSnake[0].width >> 2;
        if (pom < 1) {
            pom = 1;
        }
        this.rectScoring.x = this.rectSnake[0].x - pom;
        this.rectScoring.y = this.rectSnake[0].y - pom;
        this.rectScoring.width = this.rectSnake[0].width + (pom << 1);
        this.rectScoring.height = this.rectSnake[0].height + (pom << 1);
        for (int i = 0; i < 350; ++i) {
            if (!this.rectScoring.intersects(this.rectPoint[i])) continue;
            this.eatPoint(i);
        }
        if (this.bBigMovingPointActive && !this.bBigMovingPointBeforeEating && this.rectScoring.intersects(this.rectBigMovingPoint)) {
            this.eatBigMovingPoint();
        }
    }

    public void updateAISnakesScoring() {
        if (this.rectAIScoring == null) {
            this.rectAIScoring = new Rectangle(0, 0, 0, 0);
        }
        int pom = 0;
        pom = MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? this.rectSnake[0].width >> 3 : this.rectSnake[0].width >> 2;
        if (pom < 1) {
            pom = 1;
        }
        for (int j = 0; j < 4; ++j) {
            if (this.bAISnakeCrashed[j]) continue;
            this.rectAIScoring.x = this.rectAISnake[j][0].x - pom;
            this.rectAIScoring.y = this.rectAISnake[j][0].y - pom;
            this.rectAIScoring.width = this.rectAISnake[j][0].width + (pom << 1);
            this.rectAIScoring.height = this.rectAISnake[j][0].height + (pom << 1);
            for (int i = 0; i < 350; ++i) {
                if (!this.rectAIScoring.intersects(this.rectPoint[i])) continue;
                this.eatPointAI(j, i);
            }
            if (!this.bBigMovingPointActive || this.bBigMovingPointBeforeEating || this.rectBigMovingPoint.getCenterX() < 0 || this.rectBigMovingPoint.getCenterX() > MainCanvas.WIDTH || this.rectBigMovingPoint.getCenterY() < 0 || this.rectBigMovingPoint.getCenterY() > MainCanvas.HEIGHT || !this.rectAIScoring.intersects(this.rectBigMovingPoint)) continue;
            this.eatBigMovingPointAI(j);
        }
    }

    public void updatePlace(long lTick) {
        if (!this.bSnakeCrashed && !this.bBeforeGameOver) {
            int i;
            int pomSnakePlace = 20;
            for (i = 0; i < 4; ++i) {
                if (this.bAISnakeCrashed[i] || this.iAISnakeLength[i] >= this.iSnakeLength) continue;
                --pomSnakePlace;
            }
            for (i = 0; i < 15; ++i) {
                if (this.iFakeAISnakeLength[i] >= this.iSnakeLength) continue;
                --pomSnakePlace;
            }
            if (pomSnakePlace < 1) {
                pomSnakePlace = 1;
            }
            this.iSnakePlace = pomSnakePlace;
            if (this.iSnakePlace - this.iPlaceDecrement < this.iActualBestPlace || this.iActualBestPlace == 0) {
                this.iActualBestPlace = this.iSnakePlace - this.iPlaceDecrement;
            }
            this.updatePlaceDelay(lTick);
        }
    }

    public void updateGameOver(long lTick) {
        if (this.bGameOver && this.iGameOverStep <= 4) {
            if (this.iGameOverStep == 1) {
                if (this.iShowedMaxLength != this.iActualMaxLength) {
                    int step = this.iActualMaxLength >> 3;
                    if (step < 1) {
                        step = 1;
                    }
                    this.iShowedMaxLength += step;
                    if (this.iShowedMaxLength >= this.iActualMaxLength) {
                        this.iShowedMaxLength = this.iActualMaxLength;
                        this.iGameOverCounter = 0;
                    }
                    return;
                }
            } else if (this.iGameOverStep == 2) {
                if (this.iShowedBestPlace != this.iActualBestPlace) {
                    int step = this.iActualBestPlace >> 3;
                    if (step < 1) {
                        step = 1;
                    }
                    this.iShowedBestPlace -= step;
                    if (this.iShowedBestPlace <= this.iActualBestPlace) {
                        this.iShowedBestPlace = this.iActualBestPlace;
                        this.iGameOverCounter = 0;
                    }
                    return;
                }
            } else if (this.iGameOverStep == 3 && !this.bNewRecord) {
                ++this.iGameOverStep;
            }
            this.iGameOverCounter = (int)((long)this.iGameOverCounter + lTick);
            if (this.iGameOverCounter >= 500) {
                this.iGameOverCounter -= 500;
                ++this.iGameOverStep;
            }
        }
    }

    public void beforeGameOver() {
        this.iBeforeGameOverCounter = 1000;
        this.bBeforeGameOver = true;
    }

    public void updateBeforeGameOver(long lTick) {
        if (this.bBeforeGameOver && this.iBeforeGameOverCounter > 0) {
            this.iBeforeGameOverCounter = (int)((long)this.iBeforeGameOverCounter - lTick);
            if (this.iBeforeGameOverCounter <= 0) {
                this.gameOver();
            }
        }
    }

    public void gameOver() {
        if (!this.bGameOver) {
            this.bGameOver = true;
            this.iGameOverStep = 0;
            this.iGameOverCounter = 0;
            this.iShowedMaxLength = 0;
            this.iShowedBestPlace = 20;
            this.initNextScreen(2, 1, false);
        }
    }

    private void initGame() {
        this.initGameOverDialog();
        this.initGameplay();
        this.initSnake();
        this.initAISnakes();
        this.initPoints();
    }

    public void paint(Graphics g) {
        this.paintBg(g);
        block0 : switch (this.iScreen) {
            case 0: {
                switch (this.iSubScreen) {
                    case 2: {
                        this.paintInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.paintLogo(g);
                switch (this.iSubScreen) {
                    case 0: {
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintSettings(g);
                        break block0;
                    }
                    case 2: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 3: {
                        this.paintQuit(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (this.iSubScreen != 0) {
                    this.paintLogo(g);
                }
                switch (this.iSubScreen) {
                    case 0: {
                        this.paintGameMain(g);
                        break block0;
                    }
                    case 2: {
                        this.paintPauseMenu(g);
                        break block0;
                    }
                    case 3: {
                        this.paintSettings(g);
                        break block0;
                    }
                    case 4: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 5: {
                        this.paintQuitToMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintGameOver(g);
                        break block0;
                    }
                }
                break;
            }
        }
        this.paintControls(g);
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.iScreen) {
            case 0: {
                switch (this.iSubScreen) {
                    case 3: {
                        this.paintLeftButton(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.iSubScreen) {
                    case 0: 
                    case 1: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 2: {
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.iSubScreen) {
                    case 0: {
                        this.paintGameControls(g);
                        this.paintPauseButton(g);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 4: {
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 5: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 1: {
                        if (this.iGameOverStep < 4) break block0;
                        this.paintLeftButton(g);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void paintLeftButton(Graphics g) {
        if (!this.bControlLeftScrollIn && !this.bNextScreen) {
            this.bControlLeftScrollIn = true;
        }
        int iX = -this.iShiftControlLeftX;
        int iY = MainCanvas.HEIGHT - this.imgIconBtn.getHeight() - this.iControlsShiftY;
        g.drawImage(this.imgIconBtn, iX, iY, 20);
        this.sprIcon.setFrame(7);
        this.sprIcon.setPosition(iX + (this.imgIconBtn.getWidth() >> 1) - (this.sprIcon.getWidth() >> 1), iY + (this.imgIconBtn.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintRightButton(Graphics g) {
        if (!(this.iScreen == 2 && this.iSubScreen == 0 && this.bGameOver || this.bControlRightScrollIn || this.bNextScreen)) {
            this.bControlRightScrollIn = true;
        }
        int iX = MainCanvas.WIDTH - this.imgIconBtn.getWidth() + this.iShiftControlRightX;
        int iY = MainCanvas.HEIGHT - this.imgIconBtn.getHeight() - this.iControlsShiftY;
        g.drawImage(this.imgIconBtn, iX, iY, 20);
        switch (this.iScreen) {
            case 0: {
                this.sprIcon.setFrame(8);
                break;
            }
            case 1: {
                if (this.iSubScreen == 0) {
                    this.sprIcon.setFrame(5);
                    break;
                }
                if (this.iSubScreen == 3) {
                    this.sprIcon.setFrame(8);
                    break;
                }
                this.sprIcon.setFrame(5);
                break;
            }
            case 2: {
                if (this.iSubScreen == 5 || this.iSubScreen == 1) {
                    this.sprIcon.setFrame(8);
                    break;
                }
                this.sprIcon.setFrame(5);
                break;
            }
        }
        this.sprIcon.setPosition(iX + (this.imgIconBtn.getWidth() >> 1) - (this.sprIcon.getWidth() >> 1), iY + (this.imgIconBtn.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintPauseButton(Graphics g) {
        if (!this.bGameOver && !this.bBeforeGameOver) {
            if (!(this.iScreen == 2 && this.iSubScreen == 0 && this.bGameOver || this.bControlRightScrollIn || this.bNextScreen)) {
                this.bControlRightScrollIn = true;
            }
            this.sprIcon.setFrame(10);
            this.sprIcon.setPosition(MainCanvas.WIDTH - (this.sprIcon.getWidth() + (this.sprIcon.getWidth() >> 1)), MainCanvas.HEIGHT - (this.sprIcon.getHeight() + (this.sprIcon.getHeight() >> 1)));
            this.sprIcon.paint(g);
        }
    }

    public void paintGameControls(Graphics g) {
        if (!this.bGameOver && !this.bBeforeGameOver) {
            g.drawImage(this.imgIconBtn, this.rectFastBtn.x, this.rectFastBtn.y, 20);
            if (this.bFastSnake) {
                this.sprIcon.setFrame(14);
            } else {
                this.sprIcon.setFrame(13);
            }
            this.sprIcon.setPosition(this.rectFastBtn.getCenterX() - (this.sprIcon.getWidth() >> 1), this.rectFastBtn.getCenterY() - (this.sprIcon.getHeight() >> 1));
            this.sprIcon.paint(g);
            this.fontMain.drawString(g, "* ".toCharArray(), this.rectFastBtn.x, this.rectFastBtn.y - (this.fontMain.getHeight() >> 2), 24);
        }
    }

    public void paintBg(Graphics g) {
        if (this.iScreen == 2 && (this.iSubScreen == 0 || this.iSubScreen == 1)) {
            int iCountX = (this.iBgCenterX + this.iBgShiftX) / this.imgGameBg.getWidth() + 1;
            int iCountY = (this.iBgCenterY + this.iBgShiftY) / this.imgGameBg.getHeight() + 1;
            int iX = this.iBgCenterX + this.iBgShiftX - iCountX * this.imgGameBg.getWidth();
            int iY = this.iBgCenterY + this.iBgShiftY - iCountY * this.imgGameBg.getHeight();
            iCountX = (iCountX << 1) + 2;
            iCountY = (iCountY << 1) + 2;
            int iPomX = iX;
            int iPomY = iY;
            for (int i = 0; i < iCountX; ++i) {
                for (int j = 0; j < iCountY; ++j) {
                    if (iPomX + this.imgGameBg.getWidth() >= 0 && iPomX < MainCanvas.WIDTH && iPomY + this.imgGameBg.getHeight() >= 0 && iPomY < MainCanvas.HEIGHT) {
                        g.drawImage(this.imgGameBg, iPomX, iPomY, 20);
                    }
                    iPomY += this.imgGameBg.getHeight();
                }
                iPomX += this.imgGameBg.getWidth();
                iPomY = iY;
            }
        } else {
            g.setColor(1514787);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
    }

    public void paintInlogic(Graphics g) {
        g.drawImage(this.imgInlogic, (MainCanvas.WIDTH >> 1) - (this.imgInlogic.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (this.imgInlogic.getHeight() >> 1), 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            if (this.iShowedItems < i) continue;
            int pomShiftX = 0;
            if (i == GameDefs.iSelectedLanguage && this.iShowedItems == this.iMaxShowedItems) {
                pomShiftX = this.iSelectorX;
            }
            this.sprLanguage.setFrame(i);
            this.sprLanguage.setPosition(GameDefs.rectLanguages[i].x + pomShiftX, GameDefs.rectLanguages[i].y);
            this.sprLanguage.paint(g);
        }
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgLogo1, (MainCanvas.WIDTH >> 1) - (this.imgLogo1.getWidth() >> 1), this.iLogoActualY + this.iLogoSpringY, 20);
        g.drawImage(this.imgLogo2, (MainCanvas.WIDTH >> 1) - (this.imgLogo2.getWidth() >> 1), this.iLogoActualY + this.imgLogo1.getHeight() + this.iLogoSpringY, 20);
        if ((this.iScreen != 2 || this.tempScreen != 2 || this.iSubScreen != 1 && this.tempSubScreen != 1) && this.iScreen == 2 && (this.tempScreen == 2 || this.tempScreen == 1)) {
            this.paintStatusBar(g, true);
        }
    }

    public void paintMenuBtn(Graphics g, Rectangle rect, String s, boolean bSelected) {
        int iShiftX = 0;
        if (bSelected) {
            iShiftX = this.iSelectorX;
        }
        this.rectPomMenuBtn = new Rectangle(rect.x + iShiftX, rect.y, rect.width, rect.height);
        Rendering2D.paintImageFromSkin3HV(g, this.sprMenuBtn, this.rectPomMenuBtn);
        int iTextX = rect.getCenterX() - (this.fontMain.stringWidth(s.toCharArray()) >> 1);
        int iTextY = rect.getCenterY() - (this.fontMain.getHeight() >> 1);
        this.fontMain.drawString(g, s.toCharArray(), iTextX + iShiftX, iTextY, 20);
    }

    public void paintIconBtn(Graphics g, Rectangle rect, int id, boolean bSelected) {
        int iShiftX = 0;
        if (bSelected) {
            iShiftX = this.iSelectorX;
        }
        g.drawImage(this.imgIconBtn, rect.x + iShiftX, rect.y, 20);
        this.sprIcon.setFrame(id);
        this.sprIcon.setPosition(rect.getCenterX() - (this.sprIcon.getWidth() >> 1) + iShiftX, rect.getCenterY() - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintMainMenu(Graphics g) {
        if (this.iSelectedItem == 0) {
            this.paintMenuBtn(g, this.rectMenuItems[0], this.sPlay, true);
        } else {
            this.paintMenuBtn(g, this.rectMenuItems[0], this.sPlay, false);
        }
        if (this.iSelectedItem == 1) {
            this.paintIconBtn(g, this.rectMenuItems[1], 0, true);
        } else {
            this.paintIconBtn(g, this.rectMenuItems[1], 0, false);
        }
        if (this.iSelectedItem == 2) {
            this.paintIconBtn(g, this.rectMenuItems[2], 6, true);
        } else {
            this.paintIconBtn(g, this.rectMenuItems[2], 6, false);
        }
        if (Profile.iBestPlace != 0 && Profile.iMaxLength > 0) {
            int iShiftY = (this.fontNumbers.getHeight() >> 2) + (this.fontNumbers.getHeight() >> 3);
            if (iShiftY < 1) {
                iShiftY = 1;
            }
            int iY = MainCanvas.HEIGHT - this.fontNumbers.getHeight() * 3 - (iShiftY << 2);
            String s = "";
            String s2 = "";
            int iStringWidth = 0;
            s = this.sBest + ":";
            this.fontMain.drawString(g, s.toCharArray(), MainCanvas.WIDTH >> 1, iY + this.fontNumbers.getHeight() - this.fontMain.getHeight(), 17);
            s = this.sPlace + ": ";
            s2 = "#" + Profile.iBestPlace;
            iStringWidth = this.fontMain.stringWidth(s.toCharArray()) + this.fontNumbers.stringWidth(s2.toCharArray());
            this.fontMain.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (iStringWidth >> 1), (iY += this.fontNumbers.getHeight() + iShiftY) + this.fontNumbers.getHeight() - this.fontMain.getHeight() + this.iFontShiftY, 20);
            this.fontNumbers.drawString(g, s2.toCharArray(), (MainCanvas.WIDTH >> 1) + (iStringWidth >> 1), iY, 24);
            s = this.sLength + ": ";
            s2 = Profile.iMaxLength - 1 + "";
            iStringWidth = this.fontMain.stringWidth(s.toCharArray()) + this.fontNumbers.stringWidth(s2.toCharArray());
            this.fontMain.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (iStringWidth >> 1), (iY += this.fontNumbers.getHeight() + iShiftY) + this.fontNumbers.getHeight() - this.fontMain.getHeight() + this.iFontShiftY, 20);
            this.fontNumbers.drawString(g, s2.toCharArray(), (MainCanvas.WIDTH >> 1) + (iStringWidth >> 1), iY, 24);
        }
    }

    public void paintGamePausedDialog(Graphics g) {
        int width = this.rectDialog.width;
        int centerX = this.rectDialog.getCenterX();
        int iDialogWidth = (width >> 1) - (width >> 3);
        if (Resources.langCode.compareTo("de") == 0) {
            iDialogWidth = MainCanvas.WIDTH >= 480 ? (width >> 1) - (width >> 5) : (width >> 1) - (width >> 4);
        }
        int iDialogHeight = this.fontMain.getHeight() << 1;
        int iDialogCenterY = MainCanvas.HEIGHT - (iDialogHeight >> 1) - (iDialogHeight >> 3) - 1;
        this.paintDialog2(g, centerX, iDialogCenterY, iDialogWidth, iDialogHeight);
        this.fontMain.drawString(g, this.sGamePaused.toCharArray(), centerX, iDialogCenterY - (this.fontMain.getHeight() >> 1), 17);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintPauseMenu(Graphics g) {
        if (this.iSelectedItem == 0) {
            this.paintIconBtn(g, this.rectPauseItems[0], 0, true);
        } else {
            this.paintIconBtn(g, this.rectPauseItems[0], 0, false);
        }
        if (this.iSelectedItem == 1) {
            this.paintIconBtn(g, this.rectPauseItems[1], 6, true);
        } else {
            this.paintIconBtn(g, this.rectPauseItems[1], 6, false);
        }
        if (this.iSelectedItem == 2) {
            this.paintIconBtn(g, this.rectPauseItems[2], 9, true);
        } else {
            this.paintIconBtn(g, this.rectPauseItems[2], 9, false);
        }
        this.paintGamePausedDialog(g);
    }

    public void paintGameMain(Graphics g) {
        this.paintPoints(g);
        this.paintSnake(g);
        this.paintAISnakes(g);
        this.part.paint2(g);
        this.paintBigMovingPoint(g);
        this.paintStatusBar(g, false);
    }

    public void paintStatusBar(Graphics g, boolean bMovingWithLogo) {
        int iPomShiftY = 0;
        if (bMovingWithLogo) {
            if (this.iScreen == 2 && this.tempScreen == 2) {
                iPomShiftY = this.iLogoYIn + this.iPauseMenuShiftY - this.iLogoActualY;
            } else if (this.iScreen == 2 && this.tempScreen == 1) {
                iPomShiftY = this.iLogoYIn + this.iPauseMenuShiftY - this.iLogoActualY + this.fontNumbers.getHeight();
            }
            iPomShiftY -= this.iLogoSpringY;
        }
        int iShiftX = 0;
        iShiftX = MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 ? (MainCanvas.WIDTH < MainCanvas.HEIGHT ? (MainCanvas.WIDTH >> 3) - (MainCanvas.WIDTH >> 5) : (MainCanvas.HEIGHT >> 3) - (MainCanvas.HEIGHT >> 5)) : (MainCanvas.WIDTH < MainCanvas.HEIGHT ? (MainCanvas.WIDTH >> 3) - (MainCanvas.WIDTH >> 6) : (MainCanvas.HEIGHT >> 3) - (MainCanvas.HEIGHT >> 6));
        int iShiftY = this.fontNumbers.getHeight() - (this.fontNumbers.getHeight() >> 2) - iPomShiftY;
        int iNewShiftY = 0;
        if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640) {
            iNewShiftY = (this.fontMain.getHeight() >> 3) + 2;
        } else if (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480) {
            iNewShiftY = this.fontMain.getHeight() >> 2;
        }
        String s = this.sLength + ": ";
        int iX = iShiftX;
        this.fontMain.drawString(g, s.toCharArray(), iX, iShiftY + this.fontNumbers.getHeight() - this.fontMain.getHeight() + iNewShiftY, 20);
        int iStringWidth = this.fontMain.stringWidth(s.toCharArray());
        this.fontNumbers.drawString(g, (this.iSnakeLength - 1 + "").toCharArray(), iX += iStringWidth, iShiftY, 20);
        s = this.sPlace + ": ";
        iStringWidth = this.fontMain.stringWidth(s.toCharArray()) + this.fontNumbers.stringWidth("#0".toCharArray()) + (this.fontNumbers.getSpaceWidth() >> 1);
        iX = MainCanvas.WIDTH - iShiftX - iStringWidth;
        this.fontMain.drawString(g, s.toCharArray(), iX, iShiftY + this.fontNumbers.getHeight() - this.fontMain.getHeight() + iNewShiftY, 20);
        int pom = this.iSnakePlace - this.iPlaceDecrement;
        if (pom < 1) {
            pom = 1;
        }
        iStringWidth = this.fontMain.stringWidth(s.toCharArray());
        this.fontNumbers.drawString(g, ("#" + pom).toCharArray(), iX += iStringWidth, iShiftY, 20);
    }

    public int getColorShade(int iColor, int iPointer) {
        if (iPointer < 0) {
            iPointer = 0;
        }
        switch (iColor) {
            case 0: {
                return GameDefs.SNAKE_COLOR_1[iPointer];
            }
            case 1: {
                return GameDefs.SNAKE_COLOR_2[iPointer];
            }
            case 2: {
                return GameDefs.SNAKE_COLOR_3[iPointer];
            }
            case 3: {
                return GameDefs.SNAKE_COLOR_4[iPointer];
            }
            case 4: {
                return GameDefs.SNAKE_COLOR_5[iPointer];
            }
            case 5: {
                return GameDefs.SNAKE_COLOR_6[iPointer];
            }
            case 6: {
                return GameDefs.SNAKE_COLOR_7[iPointer];
            }
            case 7: {
                return GameDefs.SNAKE_COLOR_8[iPointer];
            }
        }
        return GameDefs.SNAKE_COLOR_9[iPointer];
    }

    public void paintSnake(Graphics g) {
        int iGlowShift;
        if (this.bSnakeCrashed && this.bBeforeGameOver) {
            return;
        }
        int pomDirection = 1;
        int pomPointer = 0;
        for (int i = 1; i < this.iSnakeLength; ++i) {
            if (pomDirection > 0) {
                if (pomPointer < 8) {
                    ++pomPointer;
                    continue;
                }
                --pomPointer;
                pomDirection = -1;
                continue;
            }
            if (pomPointer > 0) {
                --pomPointer;
                continue;
            }
            ++pomPointer;
            pomDirection = 1;
        }
        int n = iGlowShift = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.WIDTH / 200 : MainCanvas.HEIGHT / 200;
        if (iGlowShift < 1) {
            iGlowShift = 1;
        }
        pomDirection = -pomDirection;
        for (int i = this.iSnakeLength - 1; i >= 1; --i) {
            if (this.rectSnake[i].x < MainCanvas.WIDTH && this.rectSnake[i].getRight() >= 0 && this.rectSnake[i].y < MainCanvas.HEIGHT && this.rectSnake[i].getBottom() >= 0) {
                if (this.bFastSnake && this.bFastSnakeGlow) {
                    GameDefs.paintArc(g, this.getColorShade(this.iSnakeColor, pomPointer), this.rectSnake[i].x - iGlowShift, this.rectSnake[i].y - iGlowShift, this.rectSnake[i].width + (iGlowShift << 1), this.rectSnake[i].height + (iGlowShift << 1));
                } else {
                    GameDefs.paintArc(g, this.getColorShade(this.iSnakeColor, pomPointer), this.rectSnake[i].x, this.rectSnake[i].y, this.rectSnake[i].width, this.rectSnake[i].height);
                }
            }
            if (pomDirection > 0) {
                if (pomPointer < 8) {
                    ++pomPointer;
                    continue;
                }
                --pomPointer;
                pomDirection = -1;
                continue;
            }
            if (pomPointer > 0) {
                --pomPointer;
                continue;
            }
            ++pomPointer;
            pomDirection = 1;
        }
        int iEyesSize = this.iSnakeTileSize / 3;
        if (iEyesSize < 4) {
            iEyesSize = 4;
        }
        GameDefs.paintArc(g, 0xFFFFFF, this.iSnakeEyeLeftX - (iEyesSize >> 1), this.iSnakeEyeLeftY - (iEyesSize >> 1), iEyesSize, iEyesSize);
        GameDefs.paintArc(g, 0xFFFFFF, this.iSnakeEyeRightX - (iEyesSize >> 1), this.iSnakeEyeRightY - (iEyesSize >> 1), iEyesSize, iEyesSize);
        double dAngleCenter = GameDefs.atan2(this.iSnakeCursorY - this.iBgCenterY, this.iSnakeCursorX - this.iBgCenterX);
        int iEyesShift = iEyesSize / 3 - 1;
        if (iEyesShift < 2) {
            iEyesShift = 2;
        }
        int iCenterLeftX = this.iSnakeEyeLeftX + GameDefs.cos(dAngleCenter) * iEyesShift / 1000;
        int iCenterLeftY = this.iSnakeEyeLeftY + GameDefs.sin(dAngleCenter) * iEyesShift / 1000;
        int iCenterRightX = this.iSnakeEyeRightX + GameDefs.cos(dAngleCenter) * iEyesShift / 1000;
        int iCenterRightY = this.iSnakeEyeRightY + GameDefs.sin(dAngleCenter) * iEyesShift / 1000;
        int iEyesSize2 = iEyesSize - (iEyesSize >> 2) - 1;
        if (iEyesSize2 < 3) {
            iEyesSize2 = 3;
        }
        int iPomSpace2 = this.iSnakeTileSize;
        if (Math.abs(this.iSnakeCursorY - this.iBgCenterY) <= iPomSpace2) {
            if (this.iSnakeCursorX < this.iBgCenterX) {
                ++iCenterLeftX;
                ++iCenterRightX;
            } else {
                --iCenterLeftX;
                --iCenterRightX;
            }
        } else if (Math.abs(this.iSnakeCursorX - this.iBgCenterX) <= iPomSpace2) {
            if (this.iSnakeCursorY < this.iBgCenterY) {
                ++iCenterLeftY;
                ++iCenterRightY;
            } else {
                --iCenterLeftY;
                --iCenterRightY;
            }
        }
        if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640) {
            if (dAngleCenter > 2.94 || dAngleCenter < -2.94) {
                iCenterLeftX -= 2;
                iCenterRightX -= 2;
            } else if (dAngleCenter > 1.37 && dAngleCenter < 1.77) {
                ++iCenterLeftY;
                ++iCenterRightY;
            } else if (dAngleCenter > -1.77 && dAngleCenter < -1.37) {
                iCenterLeftY -= 2;
                iCenterRightY -= 2;
            } else if (!(dAngleCenter > -0.2) || !(dAngleCenter < 0.2)) {
                if (dAngleCenter > -1.57 && dAngleCenter < 0.0) {
                    ++iCenterLeftX;
                    ++iCenterRightX;
                    --iCenterLeftY;
                    --iCenterRightY;
                } else if (dAngleCenter > -3.14 && dAngleCenter < -1.57) {
                    --iCenterLeftX;
                    --iCenterRightX;
                    --iCenterLeftY;
                    --iCenterRightY;
                } else if (dAngleCenter > 1.57 && dAngleCenter < 3.14) {
                    --iCenterLeftX;
                    --iCenterRightX;
                    ++iCenterLeftY;
                    ++iCenterRightY;
                }
            }
        } else if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
            if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 287) {
                if (dAngleCenter > -1.52 && dAngleCenter < -1.46) {
                    --iCenterLeftY;
                    --iCenterRightY;
                } else if (dAngleCenter > -1.67 && dAngleCenter < -1.61) {
                    --iCenterLeftY;
                    --iCenterRightY;
                } else if (dAngleCenter > 1.46 && dAngleCenter < 1.52) {
                    ++iCenterLeftY;
                    ++iCenterRightY;
                } else if (dAngleCenter > 1.61 && dAngleCenter < 1.67) {
                    ++iCenterLeftY;
                    ++iCenterRightY;
                }
            } else if (dAngleCenter > 2.94 || dAngleCenter < -2.94) {
                --iCenterLeftX;
                --iCenterRightX;
            } else if (!(dAngleCenter > 1.37) || !(dAngleCenter < 1.77)) {
                if (dAngleCenter > -1.77 && dAngleCenter < -1.37) {
                    --iCenterLeftY;
                    --iCenterRightY;
                } else if (!(dAngleCenter > -0.2) || dAngleCenter < 0.2) {
                    // empty if block
                }
            }
        }
        GameDefs.paintArc(g, 0, iCenterLeftX - (iEyesSize2 >> 1), iCenterLeftY - (iEyesSize2 >> 1), iEyesSize2, iEyesSize2);
        GameDefs.paintArc(g, 0, iCenterRightX - (iEyesSize2 >> 1), iCenterRightY - (iEyesSize2 >> 1), iEyesSize2, iEyesSize2);
    }

    public void paintAISnakes(Graphics g) {
        int pomDirection = 1;
        int pomPointer = 0;
        int iEyesSize = 0;
        int iEyesSize2 = 0;
        int iEyesShift = 0;
        int iGlowShift = 1;
        int iGlowPom = 0;
        double dAngleCenter = 0.0;
        int iCenterLeftX = 0;
        int iCenterLeftY = 0;
        int iCenterRightX = 0;
        int iCenterRightY = 0;
        for (int j = 0; j < 4; ++j) {
            int i;
            if (this.bAISnakeCrashed[j] && this.iCrashedAISnakeCounter[j] <= 0) continue;
            int n = iGlowShift = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.WIDTH / 200 : MainCanvas.HEIGHT / 200;
            if (iGlowShift < 1) {
                iGlowShift = 1;
            }
            if ((iGlowPom = this.iAISnakeLength[j] - this.iSnakeLength) > 0 && iGlowPom > 125) {
                iGlowShift += iGlowPom / 250;
            }
            pomDirection = 1;
            pomPointer = 0;
            for (i = 1; i < this.iAISnakeLength[j]; ++i) {
                if (pomDirection > 0) {
                    if (pomPointer < 8) {
                        ++pomPointer;
                        continue;
                    }
                    --pomPointer;
                    pomDirection = -1;
                    continue;
                }
                if (pomPointer > 0) {
                    --pomPointer;
                    continue;
                }
                ++pomPointer;
                pomDirection = 1;
            }
            pomDirection = -pomDirection;
            for (i = this.iAISnakeLength[j] - 1; i >= 1; --i) {
                if (this.rectAISnake[j][i].x <= MainCanvas.WIDTH && this.rectAISnake[j][i].getRight() >= 0 && this.rectAISnake[j][i].y <= MainCanvas.HEIGHT && this.rectAISnake[j][i].getBottom() >= 0) {
                    if (this.bFastAISnake[j] && this.bFastAISnakeGlow[j]) {
                        GameDefs.paintArc(g, this.getColorShade(this.iAISnakeColor[j], pomPointer), this.rectAISnake[j][i].x - iGlowShift, this.rectAISnake[j][i].y - iGlowShift, this.rectAISnake[j][i].width + (iGlowShift << 1), this.rectAISnake[j][i].height + (iGlowShift << 1));
                    } else {
                        GameDefs.paintArc(g, this.getColorShade(this.iAISnakeColor[j], pomPointer), this.rectAISnake[j][i].x, this.rectAISnake[j][i].y, this.rectAISnake[j][i].width, this.rectAISnake[j][i].height);
                    }
                }
                if (pomDirection > 0) {
                    if (pomPointer < 8) {
                        ++pomPointer;
                        continue;
                    }
                    --pomPointer;
                    pomDirection = -1;
                    continue;
                }
                if (pomPointer > 0) {
                    --pomPointer;
                    continue;
                }
                ++pomPointer;
                pomDirection = 1;
            }
            if (this.rectAISnake[j][1].x > MainCanvas.WIDTH || this.rectAISnake[j][1].getRight() < 0 || this.rectAISnake[j][1].y > MainCanvas.HEIGHT || this.rectAISnake[j][1].getBottom() < 0) continue;
            iEyesSize = this.iAISnakeTileSize[j] / 3;
            if (iEyesSize < 4) {
                iEyesSize = 4;
            }
            GameDefs.paintArc(g, 0xFFFFFF, this.iAISnakeEyeLeftX[j] - (iEyesSize >> 1), this.iAISnakeEyeLeftY[j] - (iEyesSize >> 1), iEyesSize, iEyesSize);
            GameDefs.paintArc(g, 0xFFFFFF, this.iAISnakeEyeRightX[j] - (iEyesSize >> 1), this.iAISnakeEyeRightY[j] - (iEyesSize >> 1), iEyesSize, iEyesSize);
            dAngleCenter = GameDefs.atan2(this.iAISnakeCursorY[j] - this.iBgCenterY, this.iAISnakeCursorX[j] - this.iBgCenterX);
            iEyesShift = iEyesSize / 3 - 1;
            if (iEyesShift < 2) {
                iEyesShift = 2;
            }
            iCenterLeftX = this.iAISnakeEyeLeftX[j] + GameDefs.cos(dAngleCenter) * iEyesShift / 1000;
            iCenterLeftY = this.iAISnakeEyeLeftY[j] + GameDefs.sin(dAngleCenter) * iEyesShift / 1000;
            iCenterRightX = this.iAISnakeEyeRightX[j] + GameDefs.cos(dAngleCenter) * iEyesShift / 1000;
            iCenterRightY = this.iAISnakeEyeRightY[j] + GameDefs.sin(dAngleCenter) * iEyesShift / 1000;
            iEyesSize2 = iEyesSize - (iEyesSize >> 2) - 1;
            if (iEyesSize2 < 3) {
                iEyesSize2 = 3;
            }
            int iPomSpace2 = this.iSnakeTileSize;
            if (Math.abs(this.iAISnakeCursorY[j] - this.iBgCenterY) <= iPomSpace2) {
                if (this.iAISnakeCursorX[j] < this.iBgCenterX) {
                    ++iCenterLeftX;
                    ++iCenterRightX;
                } else {
                    --iCenterLeftX;
                    --iCenterRightX;
                }
            } else if (Math.abs(this.iAISnakeCursorX[j] - this.iBgCenterX) <= iPomSpace2) {
                if (this.iAISnakeCursorY[j] < this.iBgCenterY) {
                    ++iCenterLeftY;
                    ++iCenterRightY;
                } else {
                    --iCenterLeftY;
                    --iCenterRightY;
                }
            }
            if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
                if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 287) {
                    if (dAngleCenter > -0.2 && dAngleCenter < 0.2) {
                        ++iCenterLeftX;
                        ++iCenterRightX;
                    } else if (dAngleCenter > 1.37 && dAngleCenter < 1.77) {
                        ++iCenterLeftY;
                        ++iCenterRightY;
                    } else if (dAngleCenter >= 0.2 && dAngleCenter <= 1.37) {
                        ++iCenterLeftX;
                        ++iCenterRightX;
                        ++iCenterLeftY;
                        ++iCenterRightY;
                    }
                } else if (dAngleCenter > 2.94 || dAngleCenter < -2.94) {
                    --iCenterLeftX;
                    --iCenterRightX;
                } else if (!(dAngleCenter > 1.37) || !(dAngleCenter < 1.77)) {
                    if (dAngleCenter > -1.77 && dAngleCenter < -1.37) {
                        --iCenterLeftY;
                        --iCenterRightY;
                    } else if (!(dAngleCenter > -0.2) || dAngleCenter < 0.2) {
                        // empty if block
                    }
                }
            }
            GameDefs.paintArc(g, 0, iCenterLeftX - (iEyesSize2 >> 1), iCenterLeftY - (iEyesSize2 >> 1), iEyesSize2, iEyesSize2);
            GameDefs.paintArc(g, 0, iCenterRightX - (iEyesSize2 >> 1), iCenterRightY - (iEyesSize2 >> 1), iEyesSize2, iEyesSize2);
        }
    }

    public void paintPoints(Graphics g) {
        int iShiftStep;
        int iShiftX = 0;
        int iShiftY = 0;
        int n = iShiftStep = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH / 240 : MainCanvas.HEIGHT / 240;
        if (iShiftStep < 1) {
            iShiftStep = 1;
        }
        int iRand = 0;
        for (int i = 0; i < 350; ++i) {
            if (!this.bActivePoint[i] || this.rectPoint[i].x > MainCanvas.WIDTH || this.rectPoint[i].getRight() < 0 || this.rectPoint[i].y > MainCanvas.HEIGHT || this.rectPoint[i].getBottom() < 0) continue;
            if (this.bMovingPoint[i]) {
                iRand = RandomNum.getRandomUInt(4);
                if (iRand == 0) {
                    if (iShiftX != 0) {
                        iShiftX = 0;
                    }
                    if (iShiftY != 0) {
                        iShiftY = 0;
                    }
                } else if (iRand == 1) {
                    iRand = RandomNum.getRandomUInt(2);
                    iShiftX = (iRand == 0 ? 1 : -1) * iShiftStep;
                    if (iShiftY != 0) {
                        iShiftY = 0;
                    }
                } else if (iRand == 1) {
                    iRand = RandomNum.getRandomUInt(2);
                    iShiftY = (iRand == 0 ? 1 : -1) * iShiftStep;
                    if (iShiftX != 0) {
                        iShiftX = 0;
                    }
                } else {
                    iRand = RandomNum.getRandomUInt(2);
                    iShiftX = (iRand == 0 ? 1 : -1) * iShiftStep;
                    iRand = RandomNum.getRandomUInt(2);
                    iShiftY = (iRand == 0 ? 1 : -1) * iShiftStep;
                }
            } else {
                if (iShiftX != 0) {
                    iShiftX = 0;
                }
                if (iShiftY != 0) {
                    iShiftY = 0;
                }
            }
            if (this.iPointSize[i] == 1) {
                this.sprPoints4.setFrame(this.iPointColor[i]);
                this.sprPoints4.setPosition(this.rectPoint[i].x + iShiftX, this.rectPoint[i].y + iShiftY);
                this.sprPoints4.paint(g);
                continue;
            }
            if (this.iPointSize[i] == 2) {
                this.sprPoints3.setFrame(this.iPointColor[i]);
                this.sprPoints3.setPosition(this.rectPoint[i].x + iShiftX, this.rectPoint[i].y + iShiftY);
                this.sprPoints3.paint(g);
                continue;
            }
            if (this.iPointSize[i] == 3) {
                this.sprPoints2.setFrame(this.iPointColor[i]);
                this.sprPoints2.setPosition(this.rectPoint[i].x + iShiftX, this.rectPoint[i].y + iShiftY);
                this.sprPoints2.paint(g);
                continue;
            }
            this.sprPoints1.setFrame(this.iPointColor[i]);
            this.sprPoints1.setPosition(this.rectPoint[i].x + iShiftX, this.rectPoint[i].y + iShiftY);
            this.sprPoints1.paint(g);
        }
    }

    public void paintBigMovingPoint(Graphics g) {
        if (this.bBigMovingPointActive) {
            this.sprPoints1.setFrame(this.iBigMovingPointColor);
            this.sprPoints1.setPosition(this.rectBigMovingPoint.x, this.rectBigMovingPoint.y);
            this.sprPoints1.paint(g);
        }
    }

    public void paintGameOver(Graphics g) {
        int width = this.rectDialog.width;
        int centerX = this.rectDialog.getCenterX();
        int centerY = this.rectDialog.getCenterY();
        int iX = 0;
        int iY = 0;
        int iShiftX = 0;
        iShiftX = MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 ? width >> 4 : (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? (width >> 4) + (width >> 5) : width >> 3);
        int iStringWidth = 0;
        String s = "";
        String s2 = "";
        this.paintDialog(g, centerX, centerY, width, this.rectDialog.height);
        int pomShiftY = this.fontMain.getHeight() >> 3;
        iY = centerY - (this.iGameOverContentHeight >> 1) - this.iFontShiftY - pomShiftY;
        s = this.sGameOver;
        this.fontMain.drawString(g, s.toCharArray(), centerX, iY, 17);
        iY = centerY + (this.iGameOverContentHeight >> 1) + pomShiftY;
        if (this.iGameOverStep >= 1) {
            s = this.sLength + ": ";
            s2 = this.iShowedMaxLength - 1 + "";
            iStringWidth = this.fontMain.stringWidth(s.toCharArray()) + this.fontNumbers.stringWidth(s2.toCharArray());
            iX = centerX - (width >> 1) + iShiftX;
            this.fontMain.drawString(g, s.toCharArray(), iX, iY - this.fontMain.getHeight() + this.iFontShiftY, 20);
            this.fontNumbers.drawString(g, s2.toCharArray(), iX + iStringWidth, iY - this.fontNumbers.getHeight(), 24);
        }
        if (this.iGameOverStep >= 2) {
            s = this.sPlace + ": ";
            s2 = "#" + this.iShowedBestPlace;
            iStringWidth = this.fontMain.stringWidth(s.toCharArray()) + this.fontNumbers.stringWidth("#00".toCharArray());
            iX = centerX + (width >> 1) - iShiftX - iStringWidth;
            this.fontMain.drawString(g, s.toCharArray(), iX, iY - this.fontMain.getHeight() + this.iFontShiftY, 20);
            this.fontNumbers.drawString(g, s2.toCharArray(), iX + iStringWidth, iY - this.fontNumbers.getHeight(), 24);
        }
        if (this.iGameOverStep >= 3 && this.bNewRecord) {
            int iDialogWidth = 0;
            iDialogWidth = Resources.langCode.compareTo("en") == 0 ? (width >> 1) + (width >> 4) : (Resources.langCode.compareTo("fr") == 0 ? width - (width >> 2) - (width >> 4) : (width >> 1) + (width >> 3));
            int iDialogHeight = this.fontMain.getHeight() * 3;
            int iDialogCenterY = this.rectDialog.getBottom() + iDialogHeight / 3;
            this.paintDialog(g, centerX, iDialogCenterY, iDialogWidth, iDialogHeight);
            this.fontMain.drawString(g, this.sNewRecord.toCharArray(), centerX, iDialogCenterY - (this.fontMain.getHeight() >> 1), 17);
        }
    }

    public void paintSettings(Graphics g) {
        if (!this.bLoading && this.iLogoActualY == this.iLogoYIn2) {
            this.paintDialog(g, this.rectDialog.getCenterX(), this.rectDialog.getCenterY(), this.rectDialog.width, this.rectDialog.height);
            int iShiftX = 0;
            for (int i = 0; i < 6; ++i) {
                iShiftX = 0;
                if (this.iSelectedSettingsItem == i) {
                    iShiftX = this.iSelectorX;
                }
                this.sprLanguage.setFrame(i);
                this.sprLanguage.setPosition(GameDefs.rectLanguages[i].x + iShiftX, GameDefs.rectLanguages[i].y);
                this.sprLanguage.paint(g);
                if (GameDefs.iSelectedLanguage != i) continue;
                this.sprIcon.setFrame(7);
                this.sprIcon.setPosition(GameDefs.rectLanguages[i].getCenterX() - (this.sprIcon.getWidth() >> 1) + iShiftX, GameDefs.rectLanguages[i].getBottom());
                this.sprIcon.paint(g);
            }
        }
    }

    public void paintInstructions(Graphics g) {
        if (!this.bLoading && this.iLogoActualY == this.iLogoYIn2) {
            this.paintDialog(g, this.rectDialog.getCenterX(), this.rectDialog.getCenterY(), this.rectDialog.width, this.rectDialog.height);
            this.paintInstructionsText(g);
        }
    }

    public void paintInstructionsText(Graphics g) {
        if (this.iInstructionsShiftY > 0) {
            this.sprArrowInstructions.setFrame(1);
            this.sprArrowInstructions.setPosition(this.rectArrowsInstructions[0].getCenterX() - (this.sprArrowInstructions.getWidth() >> 1), this.rectArrowsInstructions[0].getCenterY() - (this.sprArrowInstructions.getHeight() >> 1));
            this.sprArrowInstructions.paint(g);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.sprArrowInstructions.setFrame(0);
            this.sprArrowInstructions.setPosition(this.rectArrowsInstructions[1].getCenterX() - (this.sprArrowInstructions.getWidth() >> 1), this.rectArrowsInstructions[1].getCenterY() - (this.sprArrowInstructions.getHeight() >> 1));
            this.sprArrowInstructions.paint(g);
        }
        g.setClip(0, this.iInstructionsContentY, MainCanvas.WIDTH, this.iInstructionsContentHeight);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            if (this.fontMain == null || (lineY = this.iInstructionsContentY + i * this.fontMain.getHeight() - this.iInstructionsShiftY) <= this.rectDialog.y || lineY + this.fontMain.getHeight() >= this.rectDialog.getBottom()) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        int iY = lineY - (this.fontMain.getHeight() << 1) - this.imgInlogic.getHeight();
        g.drawImage(this.imgInlogic, (MainCanvas.WIDTH >> 1) - (this.imgInlogic.getWidth() >> 1), iY, 20);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintQuit(Graphics g) {
        this.paintLogo(g);
        this.paintLabelCenter(g, this.rectLabelCenter);
    }

    public void paintQuitToMenu(Graphics g) {
        this.paintLogo(g);
        this.paintLabelCenter(g, this.rectLabelCenter);
    }

    public void paintLabelCenter(Graphics g, Rectangle rect) {
        if (this.iShowedItems == this.iMaxShowedItems) {
            this.paintDialog(g, rect.getCenterX(), rect.getCenterY(), rect.width, rect.height);
            int textHeight = this.fontMain.getHeight() * this.iTextLines;
            int pomY = rect.getCenterY() - (textHeight >> 1);
            for (int i = 0; i < this.iTextLines; ++i) {
                this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
                pomY += this.fontMain.getHeight();
            }
        }
    }

    public void paintDialog(Graphics g, int centerX, int centerY, int width, int height) {
        if (this.rectPomDialog == null) {
            this.rectPomDialog = new Rectangle(centerX - (width >> 1), centerY - (height >> 1), width, height);
        } else {
            if (this.rectPomDialog.x != centerX - (width >> 1)) {
                this.rectPomDialog.x = centerX - (width >> 1);
            }
            if (this.rectPomDialog.y != centerY - (height >> 1)) {
                this.rectPomDialog.y = centerY - (height >> 1);
            }
            if (this.rectPomDialog.width != width) {
                this.rectPomDialog.width = width;
            }
            if (this.rectPomDialog.height != height) {
                this.rectPomDialog.height = height;
            }
        }
        Rendering2D.paintImageFromSkin3HV(g, this.sprDialog, this.rectPomDialog);
    }

    public void paintDialog2(Graphics g, int centerX, int centerY, int width, int height) {
        if (this.rectPomDialog == null) {
            this.rectPomDialog = new Rectangle(centerX - (width >> 1), centerY - (height >> 1), width, height);
        } else {
            if (this.rectPomDialog.x != centerX - (width >> 1)) {
                this.rectPomDialog.x = centerX - (width >> 1);
            }
            if (this.rectPomDialog.y != centerY - (height >> 1)) {
                this.rectPomDialog.y = centerY - (height >> 1);
            }
            if (this.rectPomDialog.width != width) {
                this.rectPomDialog.width = width;
            }
            if (this.rectPomDialog.height != height) {
                this.rectPomDialog.height = height;
            }
        }
        Rendering2D.paintImageFromSkin3HV(g, this.sprDialog2, this.rectPomDialog);
    }

    public void keyPressed(int keyCode) {
        block0 : switch (this.iScreen) {
            case 0: {
                switch (this.iSubScreen) {
                    case 2: {
                        if (this.delay <= 100) break block0;
                        this.delay = 100;
                        break block0;
                    }
                    case 3: {
                        if (this.iShowedItems != this.iMaxShowedItems) break block0;
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            this.initNextScreen(1, 0, false);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeLanguage(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeLanguage(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeLanguage(2);
                            return;
                        }
                        if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                        this.changeLanguage(3);
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.iSubScreen) {
                    case 0: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.initNextScreen(1, 3, false);
                            return;
                        }
                        if (this.iShowedItems == this.iMaxShowedItems && (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53))) {
                            switch (this.iSelectedItem) {
                                case 0: {
                                    this.play(false);
                                    this.initNextScreen(2, 0, false);
                                    break;
                                }
                                case 1: {
                                    this.initNextScreen(1, 1, false);
                                    break;
                                }
                                case 2: {
                                    this.initNextScreen(1, 2, false);
                                    break;
                                }
                            }
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeSelectedMenuItem(2);
                            return;
                        }
                        if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                        this.changeSelectedMenuItem(3);
                        return;
                    }
                    case 1: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.initNextScreen(1, 0, false);
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            if (this.iSelectedSettingsItem < 6) {
                                GameDefs.iSelectedLanguage = this.iSelectedSettingsItem;
                                this.initTexts();
                            }
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeSelectedMenuItem(2);
                            return;
                        }
                        if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                        this.changeSelectedMenuItem(3);
                        return;
                    }
                    case 2: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.initNextScreen(1, 0, false);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.initNextScreen(1, 0, false);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode)) break block0;
                        this.quit();
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (this.iSubScreen) {
                    case 0: {
                        if (this.bGameOver || this.bBeforeGameOver || this.bSnakeCrashed) break block0;
                        if (Keys.isFKRightCode(keyCode)) {
                            this.pause(true);
                            return;
                        }
                        if (!Keys.isKeyPressed(42)) break block0;
                        if (this.bFastSnake) {
                            this.bFastSnake = false;
                            this.bFastSnakeGlow = false;
                            this.iFastSnakeGlowCounter = 0;
                            this.generatePointBehindSnake();
                            break block0;
                        }
                        if (this.bFastSnake) break block0;
                        this.bFastSnake = true;
                        this.iFastSnakePointsCounter = 0;
                        break block0;
                    }
                    case 1: {
                        if (this.iGameOverStep < 4 || !Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.iSelectedItem = 0;
                        this.initNextScreen(1, 0, false);
                        return;
                    }
                    case 2: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.unpause();
                            return;
                        }
                        if (this.iShowedItems == this.iMaxShowedItems && (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53))) {
                            switch (this.iSelectedItem) {
                                case 0: {
                                    this.initNextScreen(2, 3, false);
                                    break;
                                }
                                case 1: {
                                    this.initNextScreen(2, 4, false);
                                    break;
                                }
                                case 2: {
                                    this.initNextScreen(2, 5, false);
                                    break;
                                }
                            }
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeSelectedMenuItem(2);
                            return;
                        }
                        if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                        this.changeSelectedMenuItem(3);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.initNextScreen(2, 2, false);
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            if (this.iSelectedSettingsItem < 6) {
                                GameDefs.iSelectedLanguage = this.iSelectedSettingsItem;
                                this.initTexts();
                            }
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeSelectedMenuItem(2);
                            return;
                        }
                        if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                        this.changeSelectedMenuItem(3);
                        return;
                    }
                    case 4: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.initNextScreen(2, 2, false);
                        return;
                    }
                    case 5: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.initNextScreen(2, 2, false);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode)) break block0;
                        this.iSelectedItem = 0;
                        this.initNextScreen(1, 0, false);
                        return;
                    }
                }
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > this.rectDialog.x && x < this.rectDialog.getRight() && y > this.rectDialog.y && y < this.rectDialog.getBottom();
    }

    public void shiftTextUp() {
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
            }
        }
    }

    public void shiftTextDown() {
        if (this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
    }

    public void changeLanguage(int iType) {
        if (this.iShowedItems == this.iMaxShowedItems) {
            switch (iType) {
                case 0: {
                    if (GameDefs.iSelectedLanguage < 2) break;
                    GameDefs.iSelectedLanguage -= 2;
                    break;
                }
                case 1: {
                    if (GameDefs.iSelectedLanguage > 3) break;
                    GameDefs.iSelectedLanguage += 2;
                    break;
                }
                case 2: {
                    if (GameDefs.iSelectedLanguage % 2 != 1) break;
                    --GameDefs.iSelectedLanguage;
                    break;
                }
                case 3: {
                    if (GameDefs.iSelectedLanguage % 2 != 0) break;
                    ++GameDefs.iSelectedLanguage;
                    break;
                }
            }
            if (iType >= 0 && iType <= 3) {
                this.initSelector();
            }
        }
    }

    public void musicOff() {
        Profile.bMusic = false;
        Profile.save();
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeSelectedMenuItem(int iShiftType) {
        if (this.iShowedItems == this.iMaxShowedItems && !this.bNextScreen) {
            int oldSelectedItem;
            boolean bSettings = false;
            switch (this.iScreen) {
                case 1: {
                    if (this.iSubScreen == 0) {
                        oldSelectedItem = this.iSelectedItem;
                        if (iShiftType == 0) {
                            if (this.iSelectedItem > 0) {
                                this.iSelectedItem = 0;
                            }
                        } else if (iShiftType == 1) {
                            if (this.iSelectedItem == 0) {
                                this.iSelectedItem = 1;
                            }
                        } else if (iShiftType == 2) {
                            if (this.iSelectedItem != 1) {
                                this.iSelectedItem = 1;
                            }
                        } else if (iShiftType == 3 && this.iSelectedItem != 2) {
                            this.iSelectedItem = 2;
                        }
                        if (this.iSelectedItem == oldSelectedItem) break;
                        this.initSelector();
                        break;
                    }
                    if (this.iSubScreen != 1) break;
                    bSettings = true;
                    break;
                }
                case 2: {
                    if (this.iSubScreen == 2) {
                        oldSelectedItem = this.iSelectedItem;
                        if (iShiftType == 0) {
                            if (this.iSelectedItem > 1) {
                                this.iSelectedItem = 0;
                            }
                        } else if (iShiftType == 1) {
                            if (this.iSelectedItem < 2) {
                                this.iSelectedItem = 2;
                            }
                        } else if (iShiftType == 2) {
                            if (this.iSelectedItem != 0) {
                                this.iSelectedItem = 0;
                            }
                        } else if (iShiftType == 3 && this.iSelectedItem != 1) {
                            this.iSelectedItem = 1;
                        }
                        if (this.iSelectedItem == oldSelectedItem) break;
                        this.initSelector();
                        break;
                    }
                    if (this.iSubScreen != 3) break;
                    bSettings = true;
                    break;
                }
            }
            if (bSettings) {
                oldSelectedItem = this.iSelectedSettingsItem;
                if (iShiftType == 0) {
                    if (this.iSelectedSettingsItem > 2) {
                        this.iSelectedSettingsItem -= 3;
                        if (this.iSelectedSettingsItem < 0) {
                            this.iSelectedSettingsItem = 0;
                        }
                    }
                } else if (iShiftType == 1) {
                    if (this.iSelectedSettingsItem < 3) {
                        this.iSelectedSettingsItem += 3;
                        if (this.iSelectedSettingsItem > 5) {
                            this.iSelectedSettingsItem = 5;
                        }
                    }
                } else if (iShiftType == 2) {
                    if (this.iSelectedSettingsItem != 0 && this.iSelectedSettingsItem != 3) {
                        --this.iSelectedSettingsItem;
                        if (this.iSelectedSettingsItem < 0) {
                            this.iSelectedSettingsItem = 0;
                        }
                    }
                } else if (iShiftType == 3 && this.iSelectedSettingsItem != 2 && this.iSelectedSettingsItem != 5) {
                    ++this.iSelectedSettingsItem;
                    if (this.iSelectedSettingsItem > 5) {
                        this.iSelectedSettingsItem = 5;
                    }
                }
                if (this.iSelectedSettingsItem != oldSelectedItem) {
                    this.initSelector();
                }
            }
        }
    }

    public void updateAfterPauseCounter(long lTick) {
        if (this.iAfterPauseCounter > 0) {
            this.iAfterPauseCounter = (int)((long)this.iAfterPauseCounter - lTick);
        }
    }

    public void pause(boolean bMusic) {
        if (!(this.bGameOver || this.bBeforeGameOver || this.bSnakeCrashed)) {
            this.iSelectedItem = 0;
            this.initNextScreen(2, 2, false);
            this.iAfterPauseCounter = 500;
            this.bFastSnake = false;
            Keys.resetAllPressedKeysAndActions();
            if (bMusic) {
                // empty if block
            }
        }
    }

    public void unpause() {
        this.initNextScreen(2, 0, false);
        this.iAfterPauseCounter = 500;
        this.bFastSnake = false;
        Keys.resetAllPressedKeysAndActions();
    }

    public void initGameplay() {
        if (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480) {
            this.iGameplayWidth = MainCanvas.WIDTH * 20 / 10;
            this.iGameplayHeight = MainCanvas.HEIGHT * 20 / 10;
        } else {
            this.iGameplayWidth = MainCanvas.WIDTH * 15 / 10;
            this.iGameplayHeight = MainCanvas.HEIGHT * 15 / 10;
        }
        int iY = MainCanvas.HEIGHT - this.imgIconBtn.getHeight() - this.iControlsShiftY;
        this.rectFastBtn = new Rectangle((MainCanvas.WIDTH >> 1) - (this.imgIconBtn.getWidth() >> 1), iY, this.imgIconBtn.getWidth(), this.imgIconBtn.getHeight());
    }

    public void initPoints() {
        int i;
        this.iPointsAreaWidth = this.iGameplayWidth << 1;
        this.iPointsAreaHeight = this.iGameplayHeight << 1;
        this.iPointsAreaShiftX = MainCanvas.WIDTH >> 3;
        this.iPointsAreaShiftY = MainCanvas.HEIGHT >> 3;
        for (i = 0; i < 350; ++i) {
            this.bMovingPoint[i] = false;
            this.bActivePoint[i] = false;
            this.bPointBeforeEating[i] = false;
            this.iPointSize[i] = 0;
        }
        for (i = 0; i < 10; ++i) {
            this.generatePoint(i, -1);
        }
        this.bBigMovingPointActive = false;
        this.bBigMovingPointBeforeEating = false;
        this.iBigMovingPointDelayCounter = 10000;
        this.iBigMovingPointColor = 0;
        this.rectBigMovingPoint = new Rectangle(0, 0, this.sprPoints1.getWidth(), this.sprPoints1.getHeight());
    }

    public void eatPoint(int id) {
        if (this.bActivePoint[id] && !this.bPointBeforeEating[id]) {
            this.bPointBeforeEating[id] = true;
            int count = this.iPointSize[id];
            for (int i = 0; i < count; ++i) {
                if (this.iSnakeLength + i >= 501) continue;
                this.rectSnake[this.iSnakeLength + i] = new Rectangle(this.rectSnake[this.iSnakeLength + i - 1].x, this.rectSnake[this.iSnakeLength + i - 1].y, this.iSnakeTileSize, this.iSnakeTileSize);
            }
            this.iSnakeLength += count;
            this.iSnakeNewTiles += count;
            if (this.iSnakeLength > 501) {
                int pom = this.iSnakeLength - 501;
                this.iSnakeLength = 501;
                this.iSnakeNewTiles -= pom;
            }
            if (this.iSnakeLength > this.iActualMaxLength || this.iActualMaxLength == 0) {
                this.iActualMaxLength = this.iSnakeLength;
            }
            --this.iActivePointsCount;
            if (this.iActivePointsCount < 0) {
                this.iActivePointsCount = 0;
            }
            this.rectPoint[id].x += this.rectSnake[1].x - this.rectPoint[id].x >> 1;
            this.rectPoint[id].y += this.rectSnake[1].y - this.rectPoint[id].y >> 1;
        }
    }

    public void eatPointAI(int iSnakeId, int iPointId) {
        if (this.bActivePoint[iPointId] && !this.bPointBeforeEating[iPointId]) {
            this.bPointBeforeEating[iPointId] = true;
            int count = this.iPointSize[iPointId];
            for (int i = 0; i < count; ++i) {
                if (this.iAISnakeLength[iSnakeId] + i >= 501) continue;
                this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i] = new Rectangle(this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i - 1].x, this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i - 1].y, this.iAISnakeTileSize[iSnakeId], this.iAISnakeTileSize[iSnakeId]);
            }
            int n = iSnakeId;
            this.iAISnakeLength[n] = this.iAISnakeLength[n] + count;
            int n2 = iSnakeId;
            this.iAISnakeNewTiles[n2] = this.iAISnakeNewTiles[n2] + count;
            if (this.iAISnakeLength[iSnakeId] > 501) {
                int pom = this.iAISnakeLength[iSnakeId] - 501;
                this.iAISnakeLength[iSnakeId] = 501;
                int n3 = iSnakeId;
                this.iAISnakeNewTiles[n3] = this.iAISnakeNewTiles[n3] - pom;
            }
            --this.iActivePointsCount;
            if (this.iActivePointsCount < 0) {
                this.iActivePointsCount = 0;
            }
            this.rectPoint[iPointId].x += this.rectAISnake[iSnakeId][1].x - this.rectPoint[iPointId].x >> 1;
            this.rectPoint[iPointId].y += this.rectAISnake[iSnakeId][1].y - this.rectPoint[iPointId].y >> 1;
        }
    }

    public void eatBigMovingPoint() {
        if (this.bBigMovingPointActive && !this.bBigMovingPointBeforeEating) {
            this.bBigMovingPointBeforeEating = true;
            int count = 20;
            for (int i = 0; i < count; ++i) {
                if (this.iSnakeLength + i >= 501) continue;
                this.rectSnake[this.iSnakeLength + i] = new Rectangle(this.rectSnake[this.iSnakeLength + i - 1].x, this.rectSnake[this.iSnakeLength + i - 1].y, this.iSnakeTileSize, this.iSnakeTileSize);
            }
            this.iSnakeLength += count;
            this.iSnakeNewTiles += count;
            if (this.iSnakeLength > 501) {
                int pom = this.iSnakeLength - 501;
                this.iSnakeLength = 501;
                this.iSnakeNewTiles -= pom;
            }
            if (this.iSnakeLength > this.iActualMaxLength || this.iActualMaxLength == 0) {
                this.iActualMaxLength = this.iSnakeLength;
            }
            --this.iActivePointsCount;
            if (this.iActivePointsCount < 0) {
                this.iActivePointsCount = 0;
            }
            this.rectBigMovingPoint.x += this.rectSnake[1].x - this.rectBigMovingPoint.x >> 1;
            this.rectBigMovingPoint.y += this.rectSnake[1].y - this.rectBigMovingPoint.y >> 1;
        }
    }

    public void eatBigMovingPointAI(int iSnakeId) {
        if (this.bBigMovingPointActive && !this.bBigMovingPointBeforeEating) {
            this.bBigMovingPointBeforeEating = true;
            int count = 20;
            for (int i = 0; i < count; ++i) {
                if (this.iAISnakeLength[iSnakeId] + i >= 501) continue;
                this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i] = new Rectangle(this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i - 1].x, this.rectAISnake[iSnakeId][this.iAISnakeLength[iSnakeId] + i - 1].y, this.iAISnakeTileSize[iSnakeId], this.iAISnakeTileSize[iSnakeId]);
            }
            int n = iSnakeId;
            this.iAISnakeLength[n] = this.iAISnakeLength[n] + count;
            int n2 = iSnakeId;
            this.iAISnakeNewTiles[n2] = this.iAISnakeNewTiles[n2] + count;
            if (this.iAISnakeLength[iSnakeId] > 501) {
                int pom = this.iAISnakeLength[iSnakeId] - 501;
                this.iAISnakeLength[iSnakeId] = 501;
                int n3 = iSnakeId;
                this.iAISnakeNewTiles[n3] = this.iAISnakeNewTiles[n3] - pom;
            }
            --this.iActivePointsCount;
            if (this.iActivePointsCount < 0) {
                this.iActivePointsCount = 0;
            }
            this.rectBigMovingPoint.x += this.rectAISnake[iSnakeId][1].x - this.rectBigMovingPoint.x >> 1;
            this.rectBigMovingPoint.y += this.rectAISnake[iSnakeId][1].y - this.rectBigMovingPoint.y >> 1;
        }
    }

    public void generatePoint(int id, int iColor) {
        this.iPointSize[id] = 1 + RandomNum.getRandomUInt(2);
        int pomWidth = (this.iPointsAreaWidth >> 1) - (this.iPointsAreaWidth >> 3);
        int pomHeight = (this.iPointsAreaHeight >> 1) - (this.iPointsAreaHeight >> 3);
        int pomX = this.iBgCenterX + RandomNum.getRandomInt(pomWidth) - this.iNewShiftX * this.iPointsAreaShiftX;
        int pomY = this.iBgCenterY + RandomNum.getRandomInt(pomHeight) - this.iNewShiftY * this.iPointsAreaShiftY;
        int pomSize = 0;
        if (this.iPointSize[id] == 1) {
            pomSize = this.sprPoints4.getHeight();
        } else if (this.iPointSize[id] == 2) {
            pomSize = this.sprPoints3.getHeight();
        }
        this.rectPoint[id] = new Rectangle(pomX - (pomSize >> 1), pomY - (pomSize >> 1), pomSize, pomSize);
        boolean bOk = true;
        for (int i = 0; i < 350; ++i) {
            if (id == i || !this.bActivePoint[i] || !this.rectPoint[id].intersects(this.rectPoint[i])) continue;
            bOk = false;
            break;
        }
        if (bOk) {
            this.iPointColor[id] = iColor != -1 ? iColor : RandomNum.getRandomUInt(9);
            this.bPointBeforeEating[id] = false;
            this.bMovingPoint[id] = false;
            this.bActivePoint[id] = true;
            ++this.iActivePointsCount;
        }
    }

    public void generatePointAtPosition(int id, int iColor, int iX, int iY, int iSize, boolean bMoving) {
        this.iPointSize[id] = iSize;
        if (this.iPointSize[id] < 1) {
            this.iPointSize[id] = 1;
        } else if (this.iPointSize[id] > 4) {
            this.iPointSize[id] = 4;
        }
        int pomX = iX;
        int pomY = iY;
        int pomSize = 0;
        pomSize = this.iPointSize[id] == 1 ? this.sprPoints4.getHeight() : (this.iPointSize[id] == 2 ? this.sprPoints3.getHeight() : (this.iPointSize[id] == 3 ? this.sprPoints2.getHeight() : this.sprPoints1.getHeight()));
        this.rectPoint[id] = new Rectangle(pomX - (pomSize >> 1), pomY - (pomSize >> 1), pomSize, pomSize);
        boolean bOk = true;
        for (int i = 0; i < 350; ++i) {
            if (id == i || !this.bActivePoint[i] || !this.rectPoint[id].intersects(this.rectPoint[i])) continue;
            bOk = false;
            break;
        }
        if (bOk) {
            this.iPointColor[id] = iColor != -1 ? iColor : RandomNum.getRandomUInt(9);
            this.bPointBeforeEating[id] = false;
            this.bMovingPoint[id] = bMoving;
            this.bActivePoint[id] = true;
            ++this.iActivePointsCount;
        }
    }

    public void initSnake() {
        int iTileShift;
        int pom = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH : MainCanvas.HEIGHT;
        this.iSnakeSize = 5;
        this.iSnakeTileSize = pom >> 4;
        if (this.iSnakeTileSize < 1) {
            this.iSnakeTileSize = 1;
        }
        this.iSnakeLength = 11;
        this.iSnakePlace = 20;
        this.iActualMaxLength = this.iSnakeLength;
        this.iActualBestPlace = this.iSnakePlace;
        this.iSnakeNewTiles = 0;
        this.iSnakeColor = RandomNum.getRandomUInt(9);
        this.iSnakeSpeed = MainCanvas.HEIGHT <= 240 ? 2 : (MainCanvas.HEIGHT <= 360 ? 2 : (MainCanvas.HEIGHT <= 432 ? 2 : (MainCanvas.HEIGHT <= 480 ? 3 : (MainCanvas.WIDTH <= 360 && MainCanvas.HEIGHT <= 640 ? 3 : 3))));
        if (MainCanvas.WIDTH >= 480) {
            this.iSnakeSpeed = 3;
        }
        int iStartDirection = RandomNum.getRandomUInt(4);
        int n = iTileShift = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.WIDTH / 240 : MainCanvas.HEIGHT / 240;
        if (iTileShift < 1) {
            iTileShift = 1;
        }
        int iPomShiftX = 0;
        int iPomShiftY = 0;
        if (iStartDirection == 0) {
            iPomShiftX = iTileShift;
        } else if (iStartDirection == 1) {
            iPomShiftX = -iTileShift;
        } else if (iStartDirection == 2) {
            iPomShiftY = iTileShift;
        } else if (iStartDirection == 3) {
            iPomShiftY = -iTileShift;
        }
        this.rectSnake[0] = new Rectangle(this.iBgCenterX - (this.iSnakeTileSize >> 1), this.iBgCenterY - (this.iSnakeTileSize >> 1), this.iSnakeTileSize, this.iSnakeTileSize);
        for (int i = 1; i < this.iSnakeLength; ++i) {
            this.rectSnake[i] = new Rectangle(this.iBgCenterX - (this.iSnakeTileSize >> 1) + i * iPomShiftX, this.iBgCenterY - (this.iSnakeTileSize >> 1) + i * iPomShiftY, this.iSnakeTileSize, this.iSnakeTileSize);
        }
        if (iStartDirection == 0) {
            this.setCursor(0, MainCanvas.HEIGHT >> 1);
        } else if (iStartDirection == 1) {
            this.setCursor(MainCanvas.WIDTH, MainCanvas.HEIGHT >> 1);
        } else if (iStartDirection == 2) {
            this.setCursor(MainCanvas.WIDTH >> 1, 0);
        } else if (iStartDirection == 3) {
            this.setCursor(MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT);
        }
        this.bFastSnake = false;
        this.bFastSnakeGlow = false;
        this.iFastSnakeCounter = 0;
        this.iFastSnakeGlowCounter = 0;
        this.iCrashedSnakeCounter = 0;
        this.bSnakeCrashed = false;
    }

    public void initAISnakes() {
        if (this.iAiSnakeLengthStep == 0) {
            this.iAiSnakeLengthStep = 100;
        }
        for (int i = 0; i < 4; ++i) {
            this.generateAISnake(i, (i + 1) * this.iAiSnakeLengthStep);
        }
        int iStep = 31;
        for (int i = 0; i < 15; ++i) {
            this.iFakeAISnakeLength[i] = (i + 1) * iStep;
            if (this.iFakeAISnakeLength[i] >= 11) continue;
            this.iFakeAISnakeLength[i] = 11;
        }
    }

    public void generateAISnake(int id, int iLength) {
        int iTileShift;
        this.iAISnakeSize[id] = 5;
        this.iAISnakeTileSize[id] = this.iSnakeTileSize;
        if (iLength == -1) {
            this.iAISnakeLength[id] = 11;
        } else {
            this.iAISnakeLength[id] = iLength;
            if (this.iAISnakeLength[id] < 11) {
                this.iAISnakeLength[id] = 11;
            }
        }
        this.iAISnakeNewTiles[id] = 0;
        this.iAISnakeColor[id] = RandomNum.getRandomUInt(9);
        this.iAISnakeReactionDelayCounter[id] = 0;
        this.iAISnakeReactionDirection[id] = -1;
        this.bAISnakeReactionChangeable[id] = true;
        int iPomCenterX = 0;
        int iPomCenterY = 0;
        do {
            iPomCenterX = (MainCanvas.WIDTH >> 1) + RandomNum.getRandomInt(this.iGameplayWidth);
            iPomCenterY = (MainCanvas.HEIGHT >> 1) + RandomNum.getRandomInt(this.iGameplayHeight);
        } while (Math.abs((MainCanvas.WIDTH >> 1) - iPomCenterX) < this.iGameplayWidth >> 1 && Math.abs((MainCanvas.HEIGHT >> 1) - iPomCenterY) < this.iGameplayHeight >> 1);
        this.iAISnakeSpeed[id] = this.iSnakeSpeed;
        int n = iTileShift = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.WIDTH / 240 : MainCanvas.HEIGHT / 240;
        if (iTileShift < 1) {
            iTileShift = 1;
        }
        int iStartDirection = -1;
        iStartDirection = iPomCenterX < this.iBgCenterX ? (iPomCenterY < this.iBgCenterY ? 4 : (iPomCenterY > this.iBgCenterY ? 7 : 1)) : (iPomCenterX > this.iBgCenterX ? (iPomCenterY < this.iBgCenterY ? 5 : (iPomCenterY > this.iBgCenterY ? 6 : 0)) : (iPomCenterY < this.iBgCenterY ? 3 : (iPomCenterY > this.iBgCenterY ? 2 : -1)));
        int iPomShiftX = 0;
        int iPomShiftY = 0;
        if (iStartDirection == 0) {
            iPomShiftX = iTileShift;
        } else if (iStartDirection == 1) {
            iPomShiftX = -iTileShift;
        } else if (iStartDirection == 2) {
            iPomShiftY = iTileShift;
        } else if (iStartDirection == 3) {
            iPomShiftY = -iTileShift;
        } else if (iStartDirection == 4) {
            iPomShiftX = -(iTileShift - (iTileShift >> 2));
            iPomShiftY = -(iTileShift - (iTileShift >> 2));
        } else if (iStartDirection == 5) {
            iPomShiftX = iTileShift - (iTileShift >> 2);
            iPomShiftY = -(iTileShift - (iTileShift >> 2));
        } else if (iStartDirection == 6) {
            iPomShiftX = iTileShift - (iTileShift >> 2);
            iPomShiftY = iTileShift - (iTileShift >> 2);
        } else if (iStartDirection == 7) {
            iPomShiftX = -(iTileShift - (iTileShift >> 2));
            iPomShiftY = iTileShift - (iTileShift >> 2);
        }
        this.rectAISnake[id][0] = new Rectangle(iPomCenterX - (this.iAISnakeTileSize[id] >> 1), iPomCenterY - (this.iAISnakeTileSize[id] >> 1), this.iAISnakeTileSize[id], this.iAISnakeTileSize[id]);
        for (int j = 1; j < this.iAISnakeLength[id]; ++j) {
            this.rectAISnake[id][j] = new Rectangle(iPomCenterX - (this.iAISnakeTileSize[id] >> 1) + j * iPomShiftX, iPomCenterY - (this.iAISnakeTileSize[id] >> 1) + j * iPomShiftY, this.iAISnakeTileSize[id], this.iAISnakeTileSize[id]);
        }
        if (iStartDirection == 0) {
            this.setAICursor(id, 0, MainCanvas.HEIGHT >> 1);
        } else if (iStartDirection == 1) {
            this.setAICursor(id, MainCanvas.WIDTH, MainCanvas.HEIGHT >> 1);
        } else if (iStartDirection == 2) {
            this.setAICursor(id, MainCanvas.WIDTH >> 1, 0);
        } else if (iStartDirection == 3) {
            this.setAICursor(id, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT);
        } else if (iStartDirection == 4) {
            this.setAICursor(id, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        } else if (iStartDirection == 5) {
            this.setAICursor(id, 0, MainCanvas.HEIGHT);
        } else if (iStartDirection == 6) {
            this.setAICursor(id, 0, 0);
        } else if (iStartDirection == 7) {
            this.setAICursor(id, MainCanvas.WIDTH, 0);
        }
        this.updateAISnakeSize(id);
        this.bFastAISnake[id] = false;
        this.bFastAISnakeGlow[id] = false;
        this.iFastAISnakeCounter[id] = 1250 + RandomNum.getRandomUInt(10000);
        this.iFastAISnakeGlowCounter[id] = 0;
        this.iAISnakeReturnType[id] = -1;
        this.iCrashedAISnakeCounter[id] = 0;
        this.bAISnakeCrashed[id] = false;
    }

    public void setCursorNew(int iType) {
        int iSpeed;
        int n = iSpeed = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.HEIGHT / 6 : MainCanvas.WIDTH / 6;
        if (iSpeed < 1) {
            iSpeed = 1;
        }
        int iSpeed2 = iSpeed + iSpeed / 3;
        int iSpace = MainCanvas.WIDTH <= MainCanvas.HEIGHT ? MainCanvas.WIDTH >> 2 : MainCanvas.HEIGHT >> 2;
        boolean bOk = false;
        if (iType == 0) {
            if (this.iSnakeCursorX == 0 && this.iSnakeCursorY < MainCanvas.HEIGHT) {
                this.iSnakeCursorY = this.iSnakeCursorY >= iSpace && this.iSnakeCursorY < MainCanvas.HEIGHT - iSpace ? (this.iSnakeCursorY += iSpeed) : (this.iSnakeCursorY += iSpeed2);
                if (this.iSnakeCursorY > MainCanvas.HEIGHT) {
                    this.iSnakeCursorY = MainCanvas.HEIGHT;
                }
                bOk = true;
            } else if (this.iSnakeCursorX == MainCanvas.WIDTH && this.iSnakeCursorY > 0) {
                this.iSnakeCursorY = this.iSnakeCursorY <= MainCanvas.HEIGHT - iSpace && this.iSnakeCursorY > iSpace ? (this.iSnakeCursorY -= iSpeed) : (this.iSnakeCursorY -= iSpeed2);
                if (this.iSnakeCursorY < 0) {
                    this.iSnakeCursorY = 0;
                }
                bOk = true;
            } else if (this.iSnakeCursorY == 0 && this.iSnakeCursorX > 0) {
                this.iSnakeCursorX = this.iSnakeCursorX <= MainCanvas.WIDTH - iSpace && this.iSnakeCursorX > iSpace ? (this.iSnakeCursorX -= iSpeed) : (this.iSnakeCursorX -= iSpeed2);
                if (this.iSnakeCursorX < 0) {
                    this.iSnakeCursorX = 0;
                }
                bOk = true;
            } else if (this.iSnakeCursorY == MainCanvas.HEIGHT && this.iSnakeCursorX < MainCanvas.WIDTH) {
                this.iSnakeCursorX = this.iSnakeCursorX >= iSpace && this.iSnakeCursorX < MainCanvas.WIDTH - iSpace ? (this.iSnakeCursorX += iSpeed) : (this.iSnakeCursorX += iSpeed2);
                if (this.iSnakeCursorX > MainCanvas.WIDTH) {
                    this.iSnakeCursorX = MainCanvas.WIDTH;
                }
                bOk = true;
            }
        } else if (iType == 1) {
            if (this.iSnakeCursorX == MainCanvas.WIDTH && this.iSnakeCursorY < MainCanvas.HEIGHT) {
                this.iSnakeCursorY = this.iSnakeCursorY >= iSpace && this.iSnakeCursorY < MainCanvas.HEIGHT - iSpace ? (this.iSnakeCursorY += iSpeed) : (this.iSnakeCursorY += iSpeed2);
                if (this.iSnakeCursorY > MainCanvas.HEIGHT) {
                    this.iSnakeCursorY = MainCanvas.HEIGHT;
                }
                bOk = true;
            } else if (this.iSnakeCursorX == 0 && this.iSnakeCursorY > 0) {
                this.iSnakeCursorY = this.iSnakeCursorY <= MainCanvas.HEIGHT - iSpace && this.iSnakeCursorY > iSpace ? (this.iSnakeCursorY -= iSpeed) : (this.iSnakeCursorY -= iSpeed2);
                if (this.iSnakeCursorY < 0) {
                    this.iSnakeCursorY = 0;
                }
                bOk = true;
            } else if (this.iSnakeCursorY == MainCanvas.HEIGHT && this.iSnakeCursorX > 0) {
                this.iSnakeCursorX = this.iSnakeCursorX <= MainCanvas.WIDTH - iSpace && this.iSnakeCursorX > iSpace ? (this.iSnakeCursorX -= iSpeed) : (this.iSnakeCursorX -= iSpeed2);
                if (this.iSnakeCursorX < 0) {
                    this.iSnakeCursorX = 0;
                }
                bOk = true;
            } else if (this.iSnakeCursorY == 0 && this.iSnakeCursorX < MainCanvas.WIDTH) {
                this.iSnakeCursorX = this.iSnakeCursorX >= iSpace && this.iSnakeCursorX < MainCanvas.WIDTH - iSpace ? (this.iSnakeCursorX += iSpeed) : (this.iSnakeCursorX += iSpeed2);
                if (this.iSnakeCursorX > MainCanvas.WIDTH) {
                    this.iSnakeCursorX = MainCanvas.WIDTH;
                }
                bOk = true;
            }
        }
        if (bOk) {
            this.iSnakeDdaShiftX = this.iBgCenterX - this.iSnakeCursorX;
            this.iSnakeDdaShiftY = this.iBgCenterY - this.iSnakeCursorY;
        }
    }

    public int getNewKvadrant(double dAngle) {
        if (dAngle >= 5.8875) {
            return 0;
        }
        if (dAngle >= 5.495) {
            return 1;
        }
        if (dAngle >= 5.1025) {
            return 2;
        }
        if (dAngle >= 4.71) {
            return 3;
        }
        if (dAngle >= 4.3175) {
            return 4;
        }
        if (dAngle >= 3.925) {
            return 5;
        }
        if (dAngle >= 3.5325) {
            return 6;
        }
        if (dAngle >= 3.14) {
            return 7;
        }
        if (dAngle >= 2.7475) {
            return 8;
        }
        if (dAngle >= 2.355) {
            return 9;
        }
        if (dAngle >= 1.9625) {
            return 10;
        }
        if (dAngle >= 1.57) {
            return 11;
        }
        if (dAngle >= 1.1775) {
            return 12;
        }
        if (dAngle >= 0.785) {
            return 13;
        }
        if (dAngle >= 0.3925) {
            return 14;
        }
        if (dAngle >= 0.0) {
            return 15;
        }
        if (dAngle >= -0.3925) {
            return 0;
        }
        if (dAngle >= -0.785) {
            return 1;
        }
        if (dAngle >= -1.1775) {
            return 2;
        }
        if (dAngle >= -1.57) {
            return 3;
        }
        if (dAngle >= -1.9625) {
            return 4;
        }
        if (dAngle >= -2.355) {
            return 5;
        }
        if (dAngle >= -2.7475) {
            return 6;
        }
        if (dAngle >= -3.14) {
            return 7;
        }
        if (dAngle >= -3.5325) {
            return 8;
        }
        if (dAngle >= -3.925) {
            return 9;
        }
        if (dAngle >= -4.3175) {
            return 10;
        }
        if (dAngle >= -4.71) {
            return 11;
        }
        if (dAngle >= -5.1025) {
            return 12;
        }
        if (dAngle >= -5.495) {
            return 13;
        }
        if (dAngle >= -5.8875) {
            return 14;
        }
        return 15;
    }

    public void setCursor(int x, int y) {
        this.iSnakeCursorX = x;
        this.iSnakeCursorY = y;
        if (this.iSnakeCursorX < 0) {
            this.iSnakeCursorX = 0;
        } else if (this.iSnakeCursorX > MainCanvas.WIDTH) {
            this.iSnakeCursorX = MainCanvas.WIDTH;
        }
        if (this.iSnakeCursorY < 0) {
            this.iSnakeCursorY = 0;
        } else if (this.iSnakeCursorY > MainCanvas.HEIGHT) {
            this.iSnakeCursorY = MainCanvas.HEIGHT;
        }
        this.iSnakeDdaShiftX = this.iBgCenterX - this.iSnakeCursorX;
        this.iSnakeDdaShiftY = this.iBgCenterY - this.iSnakeCursorY;
    }

    public void setAICursor(int id, int x, int y) {
        if (x != -1) {
            this.iAISnakeCursorX[id] = x;
            if (this.iAISnakeCursorX[id] < 0) {
                this.iAISnakeCursorX[id] = 0;
            } else if (this.iAISnakeCursorX[id] > MainCanvas.WIDTH) {
                this.iAISnakeCursorX[id] = MainCanvas.WIDTH;
            }
            this.iAISnakeDdaShiftX[id] = this.iAISnakeCursorX[id] - this.iBgCenterX;
        }
        if (y != -1) {
            this.iAISnakeCursorY[id] = y;
            if (this.iAISnakeCursorY[id] < 0) {
                this.iAISnakeCursorY[id] = 0;
            } else if (this.iAISnakeCursorY[id] > MainCanvas.HEIGHT) {
                this.iAISnakeCursorY[id] = MainCanvas.HEIGHT;
            }
            this.iAISnakeDdaShiftY[id] = this.iAISnakeCursorY[id] - this.iBgCenterY;
        }
    }

    public void updateSnakesAndPoints(long lTick) {
        this.updateSnakeCursor();
        this.dda();
        for (int i = 0; i < 4; ++i) {
            this.ddaAI(i);
        }
        this.updateSnake(lTick);
        this.updateAISnakes(lTick);
        this.updatePoints();
        this.updateBigMovingPoint(lTick);
        this.updateSnakeEyes();
        this.updateAISnakesEyes();
        this.updateFastSnake(lTick);
        this.updateFastAISnakes(lTick);
    }

    public void updateFastSnake(long lTick) {
        if (this.bSnakeCrashed) {
            return;
        }
        if (!this.bFastSnake) {
            if (this.iFastSnakeCounter > 0) {
                this.iFastSnakeCounter = (int)((long)this.iFastSnakeCounter - lTick);
                if (this.iFastSnakeCounter < 0) {
                    this.iFastSnakeCounter = 0;
                }
            }
        } else {
            if (this.iSnakeLength <= 11) {
                this.bFastSnake = false;
                return;
            }
            this.iFastSnakeGlowCounter = (int)((long)this.iFastSnakeGlowCounter + lTick);
            if (this.iFastSnakeGlowCounter >= 200) {
                this.iFastSnakeGlowCounter = 0;
                this.bFastSnakeGlow = !this.bFastSnakeGlow;
            }
            this.iFastSnakePointsCounter = (int)((long)this.iFastSnakePointsCounter + lTick);
            if (this.iFastSnakePointsCounter >= 500) {
                this.iFastSnakePointsCounter = 0;
                this.generatePointBehindSnake();
            }
        }
        boolean bOk = false;
        if (this.bFastSnake) {
            this.iParticlesProbability = 6;
            bOk = true;
        } else if (this.iParticlesProbability < 60) {
            this.iParticlesProbability += 6;
            bOk = true;
        }
        if (bOk) {
            for (int i = 3; i < this.iSnakeLength - 1; ++i) {
                if (RandomNum.getRandomUInt(this.iParticlesProbability) != 0) continue;
                this.createParticles(this.rectSnake[i].getCenterX(), this.rectSnake[i].getCenterY());
            }
        }
    }

    public void generatePointBehindSnake() {
        if (this.iSnakeLength > 11) {
            for (int j = 0; j < 350; ++j) {
                if (this.bActivePoint[j]) continue;
                this.generatePointAtPosition(j, this.iSnakeColor, this.rectSnake[this.iSnakeLength - 1].getCenterX(), this.rectSnake[this.iSnakeLength - 1].getCenterY(), this.getPointNewSize(this.iSnakeLength), false);
                --this.iSnakeLength;
                if (this.iSnakeLength > 11) break;
                this.iSnakeLength = 11;
                this.bFastSnake = false;
                this.bFastSnakeGlow = false;
                this.iFastSnakeCounter = 0;
                this.iFastSnakeGlowCounter = 0;
                break;
            }
        }
    }

    public void updateFastAISnakes(long lTick) {
        int pom = 0;
        block0: for (int i = 0; i < 4; ++i) {
            int j;
            if (this.bAISnakeCrashed[i]) continue;
            if (!this.bFastAISnake[i]) {
                if (this.iFastAISnakeCounter[i] <= 0) continue;
                int n = i;
                this.iFastAISnakeCounter[n] = (int)((long)this.iFastAISnakeCounter[n] - lTick);
                if (this.iFastAISnakeCounter[i] < 0) {
                    this.iFastAISnakeCounter[i] = 0;
                }
                if (this.iFastAISnakeCounter[i] != 0) continue;
                pom = 0;
                for (j = 0; j < 4; ++j) {
                    if (!this.bFastAISnake[j]) continue;
                    ++pom;
                }
                if (pom < 3) {
                    this.iFastAISnakeCounter[i] = 1000 + RandomNum.getRandomUInt(4000);
                    this.bFastAISnake[i] = true;
                    continue;
                }
                this.iFastAISnakeCounter[i] = 5000 + RandomNum.getRandomUInt(10000);
                continue;
            }
            if (this.iFastAISnakeCounter[i] > 0) {
                int n = i;
                this.iFastAISnakeCounter[n] = (int)((long)this.iFastAISnakeCounter[n] - lTick);
                if (this.iFastAISnakeCounter[i] < 0) {
                    this.iFastAISnakeCounter[i] = 0;
                }
                if (this.iFastAISnakeCounter[i] == 0) {
                    this.bFastAISnake[i] = false;
                    this.bFastAISnakeGlow[i] = false;
                    this.iFastAISnakeCounter[i] = 5000 + RandomNum.getRandomUInt(10000);
                    this.iFastAISnakeGlowCounter[i] = 0;
                    continue;
                }
            }
            int n = i;
            this.iFastAISnakeGlowCounter[n] = (int)((long)this.iFastAISnakeGlowCounter[n] + lTick);
            if (this.iFastAISnakeGlowCounter[i] >= 200) {
                this.iFastAISnakeGlowCounter[i] = 0;
                this.bFastAISnakeGlow[i] = !this.bFastAISnakeGlow[i];
            }
            int n2 = i;
            this.iFastAISnakePointsCounter[n2] = (int)((long)this.iFastAISnakePointsCounter[n2] + lTick);
            if (this.iFastAISnakePointsCounter[i] < 500) continue;
            this.iFastAISnakePointsCounter[i] = 0;
            if (this.iAISnakeLength[i] <= 11) continue;
            for (j = 0; j < 350; ++j) {
                if (this.bActivePoint[j]) continue;
                this.generatePointAtPosition(j, this.iAISnakeColor[i], this.rectAISnake[i][this.iAISnakeLength[i] - 1].getCenterX(), this.rectAISnake[i][this.iAISnakeLength[i] - 1].getCenterY(), this.getPointNewSize(this.iAISnakeLength[i]), false);
                int n3 = i;
                this.iAISnakeLength[n3] = this.iAISnakeLength[n3] - 1;
                if (this.iAISnakeLength[i] > 11) continue block0;
                this.iAISnakeLength[i] = 11;
                this.bFastAISnake[i] = false;
                this.bFastAISnakeGlow[i] = false;
                this.iFastAISnakeCounter[i] = 5000 + RandomNum.getRandomUInt(10000);
                this.iFastAISnakeGlowCounter[i] = 0;
                continue block0;
            }
        }
    }

    public void updateCollisions() {
        int j;
        int pomValue = this.rectSnake[1].width >> 3;
        int pom1 = 0;
        int pom2 = 0;
        if (!this.bSnakeCrashed) {
            block0: for (int i = 0; i < 4; ++i) {
                if (this.bAISnakeCrashed[i]) continue;
                for (int j2 = 2; j2 < this.iAISnakeLength[i]; ++j2) {
                    if (this.rectAISnake[i][j2].getRight() < 0 || this.rectAISnake[i][j2].x > MainCanvas.WIDTH || this.rectAISnake[i][j2].getBottom() < 0 || this.rectAISnake[i][j2].y > MainCanvas.HEIGHT || (pom1 = this.hyp(this.rectSnake[1].getCenterX(), this.rectSnake[1].getCenterY(), this.rectAISnake[i][j2].getCenterX(), this.rectAISnake[i][j2].getCenterY())) > (pom2 = (this.rectSnake[1].width >> 1) + (this.rectAISnake[i][j2].width >> 1) + pomValue)) continue;
                    this.crashSnake();
                    i = 4;
                    continue block0;
                }
            }
        }
        if (!this.bSnakeCrashed) {
            block2: for (j = 0; j < 4; ++j) {
                if (this.bAISnakeCrashed[j]) continue;
                for (int k = 2; k < this.iSnakeLength; ++k) {
                    pom1 = this.hyp(this.rectAISnake[j][1].getCenterX(), this.rectAISnake[j][1].getCenterY(), this.rectSnake[k].getCenterX(), this.rectSnake[k].getCenterY());
                    if (pom1 > (pom2 = (this.rectAISnake[j][1].width >> 1) + (this.rectSnake[k].width >> 1) + pomValue)) continue;
                    this.crashAISnake(j);
                    continue block2;
                }
            }
        }
        for (j = 0; j < 4; ++j) {
            if (this.bAISnakeCrashed[j]) continue;
            block5: for (int i = 0; i < 4; ++i) {
                if (i == j || this.bAISnakeCrashed[i]) continue;
                for (int k = 2; k < this.iAISnakeLength[i]; ++k) {
                    pom1 = this.hyp(this.rectAISnake[j][1].getCenterX(), this.rectAISnake[j][1].getCenterY(), this.rectAISnake[i][k].getCenterX(), this.rectAISnake[i][k].getCenterY());
                    if (pom1 > (pom2 = (this.rectAISnake[j][1].width >> 1) + (this.rectAISnake[i][k].width >> 1) + pomValue)) continue;
                    this.crashAISnake(j);
                    i = 4;
                    continue block5;
                }
            }
        }
    }

    public void updateSnakeCursor() {
        if (this.bSnakeCrashed) {
            return;
        }
        if ((Keys.isActionPressed(3) || Keys.isKeyPressed(52)) && !Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) {
            this.setCursorNew(0);
            return;
        }
        if ((Keys.isActionPressed(4) || Keys.isKeyPressed(54)) && !Keys.isActionPressed(3) && !Keys.isKeyPressed(52)) {
            this.setCursorNew(1);
            return;
        }
    }

    public void dda() {
        int i;
        if (this.bSnakeCrashed) {
            if (this.iNewShiftX != 0) {
                this.iNewShiftX = 0;
            }
            if (this.iNewShiftY != 0) {
                this.iNewShiftY = 0;
            }
            return;
        }
        int shift = this.iSnakeSpeed;
        int endX = this.iBgCenterX + this.iSnakeDdaShiftX;
        int endY = this.iBgCenterY + this.iSnakeDdaShiftY;
        int deltaX = this.iSnakeDdaShiftX;
        int deltaY = this.iSnakeDdaShiftY;
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(this.iBgCenterX, this.iBgCenterY, endX, endY);
        if (this.iBgCenterX != endX || this.iBgCenterY != endY) {
            xAdd = (deltaX << shift) / count;
            yAdd = (deltaY << shift) / count;
        }
        if (this.bFastSnake) {
            int pom;
            int pom2 = 0;
            if (xAdd >= 4 || xAdd <= -4) {
                pom2 = xAdd >> 2;
            }
            if ((pom = xAdd - pom2) == 0) {
                if (xAdd < 0) {
                    pom = -1;
                } else if (xAdd > 0) {
                    pom = 1;
                }
            }
            xAdd += pom;
            pom2 = 0;
            if (yAdd >= 4 || yAdd <= -4) {
                pom2 = yAdd >> 2;
            }
            if ((pom = yAdd - pom2) == 0) {
                if (yAdd < 0) {
                    pom = -1;
                } else if (yAdd > 0) {
                    pom = 1;
                }
            }
            yAdd += pom;
        }
        this.iBgShiftX += xAdd;
        this.iBgShiftY += yAdd;
        if (this.iBgShiftX > this.imgGameBg.getWidth()) {
            this.iBgShiftX -= this.imgGameBg.getWidth();
        } else if (this.iBgShiftX < -this.imgGameBg.getWidth()) {
            this.iBgShiftX += this.imgGameBg.getWidth();
        }
        if (this.iBgShiftY > this.imgGameBg.getHeight()) {
            this.iBgShiftY -= this.imgGameBg.getHeight();
        } else if (this.iBgShiftY < -this.imgGameBg.getHeight()) {
            this.iBgShiftY += this.imgGameBg.getHeight();
        }
        this.iNewShiftX = xAdd;
        this.iNewShiftY = yAdd;
        for (i = 1; i < this.iSnakeLength; ++i) {
            this.rectSnake[i].x += this.iNewShiftX;
            this.rectSnake[i].y += this.iNewShiftY;
        }
        for (int j = 0; j < 4; ++j) {
            for (int i2 = 0; i2 < this.iAISnakeLength[j]; ++i2) {
                this.rectAISnake[j][i2].x += this.iNewShiftX;
                this.rectAISnake[j][i2].y += this.iNewShiftY;
            }
        }
        for (i = 0; i < 350; ++i) {
            if (!this.bActivePoint[i]) continue;
            this.rectPoint[i].x += this.iNewShiftX;
            this.rectPoint[i].y += this.iNewShiftY;
        }
        this.rectBigMovingPoint.x += this.iNewShiftX;
        this.rectBigMovingPoint.y += this.iNewShiftY;
    }

    public void ddaAI(int id) {
        if (this.bAISnakeCrashed[id]) {
            return;
        }
        int shift = this.iAISnakeSpeed[id];
        int startX = this.rectAISnake[id][0].getCenterX();
        int startY = this.rectAISnake[id][0].getCenterY();
        int endX = startX + this.iAISnakeDdaShiftX[id];
        int endY = startY + this.iAISnakeDdaShiftY[id];
        int deltaX = this.iAISnakeDdaShiftX[id];
        int deltaY = this.iAISnakeDdaShiftY[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(startX, startY, endX, endY);
        if (startX != endX || startY != endY) {
            xAdd = (deltaX << shift) / count;
            yAdd = (deltaY << shift) / count;
        }
        if (this.bFastAISnake[id]) {
            int pom;
            int pom2 = 0;
            if (xAdd >= 4 || xAdd <= -4) {
                pom2 = xAdd >> 2;
            }
            if ((pom = xAdd - pom2) == 0) {
                if (xAdd < 0) {
                    pom = -1;
                } else if (xAdd > 0) {
                    pom = 1;
                }
            }
            xAdd += pom;
            pom2 = 0;
            if (yAdd >= 4 || yAdd <= -4) {
                pom2 = yAdd >> 2;
            }
            if ((pom = yAdd - pom2) == 0) {
                if (yAdd < 0) {
                    pom = -1;
                } else if (yAdd > 0) {
                    pom = 1;
                }
            }
            yAdd += pom;
        }
        this.rectAISnake[id][0].x += xAdd;
        this.rectAISnake[id][0].y += yAdd;
    }

    public int hyp(int x1, int y1, int x2, int y2) {
        if ((x2 -= x1) < 0) {
            x2 = -x2;
        }
        if ((y2 -= y1) < 0) {
            y2 = -y2;
        }
        return x2 + y2 - ((x2 > y2 ? y2 : x2) >> 1);
    }

    public void updateSnake(long lTick) {
        int i;
        if (this.bSnakeCrashed) {
            if (this.iCrashedSnakeCounter > 0) {
                this.iCrashedSnakeCounter = (int)((long)this.iCrashedSnakeCounter - lTick);
                if (this.iCrashedSnakeCounter <= 0) {
                    this.beforeGameOver();
                }
            }
            return;
        }
        for (i = this.iSnakeLength - 1; i >= 1; --i) {
            if (i < this.iSnakeLength - this.iSnakeNewTiles) {
                this.rectSnake[i].x = this.rectSnake[i - 1].x;
                this.rectSnake[i].y = this.rectSnake[i - 1].y;
                continue;
            }
            --this.iSnakeNewTiles;
            if (this.iSnakeNewTiles >= 0) continue;
            this.iSnakeNewTiles = 0;
        }
        for (i = this.iSnakeLength - 1; i >= 1; --i) {
            if (i >= this.iSnakeLength - this.iSnakeNewTiles) continue;
            this.rectSnake[i].x += this.rectSnake[i - 1].getCenterX() - this.rectSnake[i].getCenterX() >> 1;
            this.rectSnake[i].y += this.rectSnake[i - 1].getCenterY() - this.rectSnake[i].getCenterY() >> 1;
        }
    }

    public void updateAISnakes(long lTick) {
        int pomMaxDistanceX = 0;
        int pomMaxDistanceY = 0;
        if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640) {
            pomMaxDistanceX = this.iGameplayWidth - (this.iGameplayWidth >> 2);
            pomMaxDistanceY = this.iGameplayHeight - (this.iGameplayHeight >> 2);
        } else if (MainCanvas.WIDTH >= 360 && MainCanvas.HEIGHT >= 640) {
            pomMaxDistanceX = this.iGameplayWidth - (this.iGameplayWidth >> 3);
            pomMaxDistanceY = this.iGameplayHeight - (this.iGameplayHeight >> 3);
        } else if (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480) {
            pomMaxDistanceX = this.iGameplayWidth - (this.iGameplayWidth >> 4);
            pomMaxDistanceY = this.iGameplayHeight - (this.iGameplayHeight >> 4);
        } else if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320) {
            pomMaxDistanceX = this.iGameplayWidth - (this.iGameplayWidth >> 5);
            pomMaxDistanceY = this.iGameplayHeight - (this.iGameplayHeight >> 5);
        } else {
            pomMaxDistanceX = this.iGameplayWidth;
            pomMaxDistanceY = this.iGameplayHeight;
        }
        for (int j = 0; j < 4; ++j) {
            int i;
            if (this.bAISnakeCrashed[j]) {
                if (this.iCrashedAISnakeCounter[j] <= 0) continue;
                int n = j;
                this.iCrashedAISnakeCounter[n] = (int)((long)this.iCrashedAISnakeCounter[n] - lTick);
                if (this.iCrashedAISnakeCounter[j] > 0) continue;
                this.generateAISnake(j, (j + 1) * this.iAiSnakeLengthStep);
                continue;
            }
            for (i = this.iAISnakeLength[j] - 1; i >= 1; --i) {
                if (i < this.iAISnakeLength[j] - this.iAISnakeNewTiles[j]) {
                    this.rectAISnake[j][i].x = this.rectAISnake[j][i - 1].x;
                    this.rectAISnake[j][i].y = this.rectAISnake[j][i - 1].y;
                    continue;
                }
                int n = j;
                this.iAISnakeNewTiles[n] = this.iAISnakeNewTiles[n] - 1;
                if (this.iAISnakeNewTiles[j] >= 0) continue;
                this.iAISnakeNewTiles[j] = 0;
            }
            for (i = this.iAISnakeLength[j] - 1; i >= 1; --i) {
                if (i >= this.iAISnakeLength[j] - this.iAISnakeNewTiles[j]) continue;
                this.rectAISnake[j][i].x += this.rectAISnake[j][i - 1].getCenterX() - this.rectAISnake[j][i].getCenterX() >> 1;
                this.rectAISnake[j][i].y += this.rectAISnake[j][i - 1].getCenterY() - this.rectAISnake[j][i].getCenterY() >> 1;
            }
            boolean bOk = true;
            int iNewX = -1;
            int iNewY = -1;
            if (Math.abs(this.rectAISnake[j][0].getCenterX() - this.iBgCenterX) > pomMaxDistanceX && Math.abs(this.rectAISnake[j][0].getCenterY() - this.iBgCenterY) > pomMaxDistanceY) {
                bOk = false;
                if (this.iAISnakeReturnType[j] != 0) {
                    this.iAISnakeReturnType[j] = 0;
                    if (this.rectAISnake[j][0].getCenterX() < this.iBgCenterX && this.rectAISnake[j][0].getCenterY() < this.iBgCenterY) {
                        iNewX = MainCanvas.WIDTH;
                        iNewY = MainCanvas.HEIGHT;
                    } else if (this.rectAISnake[j][0].getCenterX() < this.iBgCenterX && this.rectAISnake[j][0].getCenterY() > this.iBgCenterY) {
                        iNewX = MainCanvas.WIDTH;
                        iNewY = 0;
                    } else if (this.rectAISnake[j][0].getCenterX() > this.iBgCenterX && this.rectAISnake[j][0].getCenterY() < this.iBgCenterY) {
                        iNewX = 0;
                        iNewY = MainCanvas.HEIGHT;
                    } else {
                        iNewX = 0;
                        iNewY = 0;
                    }
                    this.setAICursor(j, iNewX, iNewY);
                }
            } else if (Math.abs(this.rectAISnake[j][0].getCenterX() - this.iBgCenterX) > pomMaxDistanceX) {
                bOk = false;
                if (this.iAISnakeReturnType[j] != 1) {
                    this.iAISnakeReturnType[j] = 1;
                    iNewX = this.rectAISnake[j][0].getCenterX() < this.iBgCenterX ? MainCanvas.WIDTH : 0;
                    iNewY = this.rectAISnake[j][0].getCenterY() < this.iBgCenterY ? (this.rectAISnake[j][0].getCenterY() < 0 ? MainCanvas.HEIGHT : MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2)) : (this.rectAISnake[j][0].getCenterY() > this.iBgCenterY ? (this.rectAISnake[j][0].getCenterY() > MainCanvas.HEIGHT ? 0 : MainCanvas.HEIGHT >> 2) : MainCanvas.HEIGHT >> 1);
                    this.setAICursor(j, iNewX, iNewY);
                }
            } else if (Math.abs(this.rectAISnake[j][0].getCenterY() - this.iBgCenterY) > pomMaxDistanceY) {
                bOk = false;
                if (this.iAISnakeReturnType[j] != 2) {
                    this.iAISnakeReturnType[j] = 2;
                    iNewY = this.rectAISnake[j][0].getCenterY() < this.iBgCenterY ? MainCanvas.HEIGHT : 0;
                    iNewX = this.rectAISnake[j][0].getCenterX() < this.iBgCenterX ? (this.rectAISnake[j][0].getCenterX() < 0 ? MainCanvas.WIDTH : MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2)) : (this.rectAISnake[j][0].getCenterX() > this.iBgCenterX ? (this.rectAISnake[j][0].getCenterX() > MainCanvas.WIDTH ? 0 : MainCanvas.WIDTH >> 2) : MainCanvas.WIDTH >> 1);
                    this.setAICursor(j, iNewX, iNewY);
                }
            } else {
                this.iAISnakeReturnType[j] = -1;
            }
            if (!bOk) {
                this.iFastAISnakeCounter[j] = 1000 + RandomNum.getRandomUInt(5000);
                this.bFastAISnake[j] = true;
                this.iAISnakeReactionDirection[j] = -1;
                this.iAISnakeReactionDelayCounter[j] = 2000;
                this.bAISnakeReactionChangeable[j] = false;
            }
            if (bOk) {
                int iPomShiftY;
                int iPomValue = 16;
                int iPomShiftX = MainCanvas.WIDTH / iPomValue;
                if (iPomShiftX < 1) {
                    iPomShiftX = 1;
                }
                if ((iPomShiftY = MainCanvas.HEIGHT / iPomValue) < 1) {
                    iPomShiftY = 1;
                }
                int pom = -1;
                if (this.bAISnakeReactionChangeable[j]) {
                    if (!(this.bSnakeCrashed && this.bBeforeGameOver || !this.getCollisionDetection(j))) {
                        pom = 0;
                        this.iAISnakeReactionDelayCounter[j] = 2000;
                        this.bAISnakeReactionChangeable[j] = false;
                    }
                    if (pom == -1) {
                        for (int k = 0; k < 4; ++k) {
                            if (k == j || this.bAISnakeCrashed[k] || !this.getCollisionDetection(j, k)) continue;
                            pom = 1;
                            this.iAISnakeReactionDelayCounter[j] = 2000;
                            this.bAISnakeReactionChangeable[j] = false;
                            break;
                        }
                    }
                }
                if (pom == -1 && this.iAISnakeReactionDelayCounter[j] > 0) {
                    pom = 2;
                    int n = j;
                    this.iAISnakeReactionDelayCounter[n] = (int)((long)this.iAISnakeReactionDelayCounter[n] - lTick);
                    if (!this.bAISnakeReactionChangeable[j] && this.iAISnakeReactionDelayCounter[j] <= 1750) {
                        this.bAISnakeReactionChangeable[j] = true;
                    }
                }
                if (pom == -1 && this.iAISnakeReactionDelayCounter[j] <= 0 && RandomNum.getRandomUInt(20) == 0) {
                    pom = 3;
                    this.iAISnakeReactionDirection[j] = RandomNum.getRandomUInt(8);
                    this.iAISnakeReactionDelayCounter[j] = 1000;
                    this.bAISnakeReactionChangeable[j] = false;
                }
                if (pom != -1) {
                    int iNewCursorX = -1;
                    int iNewCursorY = -1;
                    switch (this.iAISnakeReactionDirection[j]) {
                        case 0: {
                            if (this.iAISnakeCursorX[j] > MainCanvas.WIDTH >> 1) {
                                if (this.iAISnakeCursorY[j] != 0 && this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] < MainCanvas.HEIGHT >> 1 ? this.iAISnakeCursorY[j] - iPomShiftY : this.iAISnakeCursorY[j] + iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                if (this.iAISnakeCursorY[j] < MainCanvas.HEIGHT >> 1) {
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                    if (iNewCursorY > MainCanvas.HEIGHT >> 1) {
                                        iNewCursorY = MainCanvas.HEIGHT >> 1;
                                    }
                                } else {
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                    if (iNewCursorY < MainCanvas.HEIGHT >> 1) {
                                        iNewCursorY = MainCanvas.HEIGHT >> 1;
                                    }
                                }
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != 0 || iNewCursorY != MainCanvas.HEIGHT >> 1) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 1: {
                            if (this.iAISnakeCursorX[j] < MainCanvas.WIDTH >> 1) {
                                if (this.iAISnakeCursorY[j] != 0 && this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] < MainCanvas.HEIGHT >> 1 ? this.iAISnakeCursorY[j] - iPomShiftY : this.iAISnakeCursorY[j] + iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                if (this.iAISnakeCursorY[j] < MainCanvas.HEIGHT >> 1) {
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                    if (iNewCursorY > MainCanvas.HEIGHT >> 1) {
                                        iNewCursorY = MainCanvas.HEIGHT >> 1;
                                    }
                                } else {
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                    if (iNewCursorY < MainCanvas.HEIGHT >> 1) {
                                        iNewCursorY = MainCanvas.HEIGHT >> 1;
                                    }
                                }
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != MainCanvas.WIDTH || iNewCursorY != MainCanvas.HEIGHT >> 1) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 2: {
                            if (this.iAISnakeCursorY[j] > MainCanvas.HEIGHT >> 1) {
                                if (this.iAISnakeCursorX[j] != 0 && this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                    iNewCursorX = this.iAISnakeCursorX[j] < MainCanvas.WIDTH >> 1 ? this.iAISnakeCursorX[j] - iPomShiftX : this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorY[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                            } else {
                                if (this.iAISnakeCursorX[j] < MainCanvas.WIDTH >> 1) {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    if (iNewCursorX > MainCanvas.WIDTH >> 1) {
                                        iNewCursorX = MainCanvas.WIDTH >> 1;
                                    }
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    if (iNewCursorX < MainCanvas.WIDTH >> 1) {
                                        iNewCursorX = MainCanvas.WIDTH >> 1;
                                    }
                                }
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != MainCanvas.WIDTH >> 1 || iNewCursorY != 0) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 3: {
                            if (this.iAISnakeCursorY[j] < MainCanvas.HEIGHT >> 1) {
                                if (this.iAISnakeCursorX[j] != 0 && this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                    iNewCursorX = this.iAISnakeCursorX[j] < MainCanvas.WIDTH >> 1 ? this.iAISnakeCursorX[j] - iPomShiftX : this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                            } else {
                                if (this.iAISnakeCursorX[j] < MainCanvas.WIDTH >> 1) {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    if (iNewCursorX > MainCanvas.WIDTH >> 1) {
                                        iNewCursorX = MainCanvas.WIDTH >> 1;
                                    }
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    if (iNewCursorX < MainCanvas.WIDTH >> 1) {
                                        iNewCursorX = MainCanvas.WIDTH >> 1;
                                    }
                                }
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != MainCanvas.WIDTH >> 1 || iNewCursorY != MainCanvas.HEIGHT) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 4: {
                            if (this.iAISnakeCursorX[j] >= MainCanvas.WIDTH && this.iAISnakeCursorY[j] <= MainCanvas.HEIGHT) {
                                if (this.iAISnakeCursorY[j] != 0) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] <= MainCanvas.WIDTH && this.iAISnakeCursorY[j] >= MainCanvas.HEIGHT) {
                                if (this.iAISnakeCursorX[j] != 0) {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorX[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else if (this.iAISnakeCursorY[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != 0 || iNewCursorY != 0) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 5: {
                            if (this.iAISnakeCursorX[j] >= MainCanvas.WIDTH && this.iAISnakeCursorY[j] >= 0) {
                                if (this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] <= MainCanvas.WIDTH && this.iAISnakeCursorY[j] <= 0) {
                                if (this.iAISnakeCursorX[j] != 0) {
                                    iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorX[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j] - iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else if (this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != 0 || iNewCursorY != MainCanvas.HEIGHT) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 6: {
                            if (this.iAISnakeCursorX[j] <= 0 && this.iAISnakeCursorY[j] <= MainCanvas.HEIGHT) {
                                if (this.iAISnakeCursorY[j] != 0) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] >= 0 && this.iAISnakeCursorY[j] >= MainCanvas.HEIGHT) {
                                if (this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else if (this.iAISnakeCursorY[j] != 0) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] - iPomShiftY;
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != MainCanvas.WIDTH || iNewCursorY != 0) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                        case 7: {
                            if (this.iAISnakeCursorX[j] <= 0 && this.iAISnakeCursorY[j] >= 0) {
                                if (this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                }
                            } else if (this.iAISnakeCursorX[j] >= 0 && this.iAISnakeCursorY[j] <= 0) {
                                if (this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                    iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                    iNewCursorY = this.iAISnakeCursorY[j];
                                } else {
                                    iNewCursorX = this.iAISnakeCursorX[j];
                                    iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                                }
                            } else if (this.iAISnakeCursorX[j] != MainCanvas.WIDTH) {
                                iNewCursorX = this.iAISnakeCursorX[j] + iPomShiftX;
                                iNewCursorY = this.iAISnakeCursorY[j];
                            } else if (this.iAISnakeCursorY[j] != MainCanvas.HEIGHT) {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j] + iPomShiftY;
                            } else {
                                iNewCursorX = this.iAISnakeCursorX[j];
                                iNewCursorY = this.iAISnakeCursorY[j];
                            }
                            if (iNewCursorX < 0) {
                                iNewCursorX = 0;
                            } else if (iNewCursorX > MainCanvas.WIDTH) {
                                iNewCursorX = MainCanvas.WIDTH;
                            }
                            if (iNewCursorY < 0) {
                                iNewCursorY = 0;
                            } else if (iNewCursorY > MainCanvas.HEIGHT) {
                                iNewCursorY = MainCanvas.HEIGHT;
                            }
                            if (iNewCursorX != MainCanvas.WIDTH || iNewCursorY != MainCanvas.HEIGHT) break;
                            this.iAISnakeReactionDelayCounter[j] = 0;
                            this.bAISnakeReactionChangeable[j] = true;
                            this.iAISnakeReactionDirection[j] = -1;
                            break;
                        }
                    }
                    if (iNewCursorX != -1 || iNewCursorY != -1) {
                        this.setAICursor(j, iNewCursorX, iNewCursorY);
                    }
                    if (this.iAISnakeReactionDelayCounter[j] <= 0) {
                        this.iAISnakeReactionDirection[j] = -1;
                        pom = -1;
                        if (!this.bAISnakeReactionChangeable[j]) {
                            this.bAISnakeReactionChangeable[j] = true;
                        }
                    }
                }
            }
            this.updateAISnakeSize(j);
        }
    }

    public void updateAISnakeSize(int id) {
        int pomSizeStep2;
        int pom;
        if (this.iSnakeSizeDivisor == 0) {
            this.iSnakeSizeDivisor = 10;
        }
        int oldSize = this.iAISnakeSize[id];
        if (this.iAISnakeLength[id] == this.iSnakeLength) {
            this.iAISnakeSize[id] = 5;
        } else if (this.iAISnakeLength[id] < this.iSnakeLength) {
            pom = (this.iSnakeLength - this.iAISnakeLength[id]) / this.iSnakeSizeDivisor;
            this.iAISnakeSize[id] = 5 - pom >= 0 ? 5 - pom : 0;
        } else if (this.iAISnakeLength[id] > this.iSnakeLength) {
            pom = (this.iAISnakeLength[id] - this.iSnakeLength) / (this.iSnakeSizeDivisor + (this.iSnakeSizeDivisor >> 1));
            this.iAISnakeSize[id] = 5 + pom;
        }
        int pomSizeStep1 = this.iSnakeTileSize / 8;
        if (pomSizeStep1 < 1) {
            pomSizeStep1 = 1;
        }
        if ((pomSizeStep2 = this.iSnakeTileSize / 8) < 1) {
            pomSizeStep2 = 1;
        }
        int pomTileSize = 0;
        if (this.iAISnakeSize[id] == this.iSnakeSize) {
            pomTileSize = this.iSnakeTileSize;
        } else if (this.iAISnakeSize[id] < this.iSnakeSize) {
            pomTileSize = this.iSnakeTileSize - (this.iSnakeSize - this.iAISnakeSize[id]) * pomSizeStep1;
        } else if (this.iAISnakeSize[id] > this.iSnakeSize) {
            pomTileSize = this.iSnakeTileSize + (this.iAISnakeSize[id] - this.iSnakeSize) * pomSizeStep2;
        }
        if (pomTileSize < 2) {
            pomTileSize = 2;
        }
        int iCenterX = 0;
        int iCenterY = 0;
        if (this.iAISnakeSize[id] != oldSize) {
            this.iAISnakeTileSize[id] = pomTileSize;
            for (int i = 0; i < this.iAISnakeLength[id]; ++i) {
                iCenterX = this.rectAISnake[id][i].getCenterX();
                iCenterY = this.rectAISnake[id][i].getCenterY();
                this.rectAISnake[id][i].x = iCenterX - (pomTileSize >> 1);
                this.rectAISnake[id][i].y = iCenterY - (pomTileSize >> 1);
                this.rectAISnake[id][i].width = pomTileSize;
                this.rectAISnake[id][i].height = pomTileSize;
            }
        } else {
            for (int i = 0; i < this.iAISnakeLength[id]; ++i) {
                if (this.rectAISnake[id][i].width == this.rectAISnake[id][0].width && this.rectAISnake[id][i].height == this.rectAISnake[id][0].height) continue;
                iCenterX = this.rectAISnake[id][i].getCenterX();
                iCenterY = this.rectAISnake[id][i].getCenterY();
                this.rectAISnake[id][i].x = iCenterX - (pomTileSize >> 1);
                this.rectAISnake[id][i].y = iCenterY - (pomTileSize >> 1);
                this.rectAISnake[id][i].width = pomTileSize;
                this.rectAISnake[id][i].height = pomTileSize;
            }
        }
    }

    public void updateSnakeEyes() {
        if (this.bSnakeCrashed) {
            return;
        }
        int iHeadCenterX = this.rectSnake[1].getCenterX();
        int iHeadCenterY = this.rectSnake[1].getCenterY();
        int iHeadShift = this.iSnakeTileSize / 6 - 1;
        if (iHeadShift < 1) {
            iHeadShift = 1;
        }
        double dAngleCenter = GameDefs.atan2(this.iSnakeCursorY - iHeadCenterY, this.iSnakeCursorX - iHeadCenterX);
        double dAngleLeft = dAngleCenter - 1.57;
        double dAngleRight = dAngleCenter + 1.57;
        if (dAngleLeft < -6.28) {
            dAngleLeft += 6.28;
        } else if (dAngleLeft > 6.28) {
            dAngleLeft -= 6.28;
        }
        if (dAngleRight < -6.28) {
            dAngleRight += 6.28;
        } else if (dAngleRight > 6.28) {
            dAngleRight -= 6.28;
        }
        int iEyesCenterX = iHeadCenterX + GameDefs.cos(dAngleCenter) * iHeadShift / 1000;
        int iEyesCenterY = iHeadCenterY + GameDefs.sin(dAngleCenter) * iHeadShift / 1000;
        int iEyesShift = (this.iSnakeTileSize >> 2) + 1;
        this.iSnakeEyeLeftX = iEyesCenterX + GameDefs.cos(dAngleLeft) * iEyesShift / 1000;
        this.iSnakeEyeLeftY = iEyesCenterY + GameDefs.sin(dAngleLeft) * iEyesShift / 1000;
        this.iSnakeEyeRightX = iEyesCenterX + GameDefs.cos(dAngleRight) * iEyesShift / 1000;
        this.iSnakeEyeRightY = iEyesCenterY + GameDefs.sin(dAngleRight) * iEyesShift / 1000;
        if (MainCanvas.WIDTH < 240 || MainCanvas.HEIGHT < 287) {
            if (dAngleCenter > 1.47 && dAngleCenter < 1.67) {
                ++this.iSnakeEyeRightX;
            } else if (dAngleCenter > -1.67 && dAngleCenter < -1.47) {
                ++this.iSnakeEyeLeftX;
            }
        }
    }

    public void updateAISnakesEyes() {
        int iHeadCenterX = 0;
        int iHeadCenterY = 0;
        int iHeadShift = 0;
        int iEyesShift = 0;
        int iEyesCenterX = 0;
        int iEyesCenterY = 0;
        double dAngleCenter = 0.0;
        double dAngleLeft = 0.0;
        double dAngleRight = 0.0;
        for (int i = 0; i < 4; ++i) {
            iHeadCenterX = this.rectAISnake[i][1].getCenterX();
            iHeadCenterY = this.rectAISnake[i][1].getCenterY();
            iHeadShift = 0;
            if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 287) {
                iHeadShift = this.iSnakeTileSize / 6 - 1;
                if (this.iAISnakeTileSize[i] >= this.iSnakeTileSize * 6) {
                    iHeadShift = this.iAISnakeTileSize[i] / 12;
                } else if (this.iAISnakeTileSize[i] >= this.iSnakeTileSize << 2) {
                    iHeadShift = this.iAISnakeTileSize[i] / 10;
                } else if (this.iAISnakeTileSize[i] >= this.iSnakeTileSize << 1) {
                    iHeadShift = this.iAISnakeTileSize[i] / 8;
                }
            } else {
                iHeadShift = this.iSnakeTileSize / 6;
            }
            if (iHeadShift < 1) {
                iHeadShift = 1;
            }
            dAngleCenter = GameDefs.atan2(this.iAISnakeCursorY[i] - this.iBgCenterY, this.iAISnakeCursorX[i] - this.iBgCenterX);
            dAngleLeft = dAngleCenter - 1.57;
            dAngleRight = dAngleCenter + 1.57;
            if (dAngleLeft < -6.28) {
                dAngleLeft += 6.28;
            } else if (dAngleLeft > 6.28) {
                dAngleLeft -= 6.28;
            }
            if (dAngleRight < -6.28) {
                dAngleRight += 6.28;
            } else if (dAngleRight > 6.28) {
                dAngleRight -= 6.28;
            }
            iEyesCenterX = iHeadCenterX + GameDefs.cos(dAngleCenter) * iHeadShift / 1000;
            iEyesCenterY = iHeadCenterY + GameDefs.sin(dAngleCenter) * iHeadShift / 1000;
            iEyesShift = (this.iAISnakeTileSize[i] >> 2) + 1;
            this.iAISnakeEyeLeftX[i] = iEyesCenterX + GameDefs.cos(dAngleLeft) * iEyesShift / 1000;
            this.iAISnakeEyeLeftY[i] = iEyesCenterY + GameDefs.sin(dAngleLeft) * iEyesShift / 1000;
            this.iAISnakeEyeRightX[i] = iEyesCenterX + GameDefs.cos(dAngleRight) * iEyesShift / 1000;
            this.iAISnakeEyeRightY[i] = iEyesCenterY + GameDefs.sin(dAngleRight) * iEyesShift / 1000;
        }
    }

    public int getAICollisionKvadrant(int iAISnakeId, int iBaseSnakeId, int iBaseSnakeTileId) {
        int iCenterX = this.rectAISnake[iAISnakeId][0].getCenterX();
        int iCenterY = this.rectAISnake[iAISnakeId][0].getCenterY();
        int iBaseCenterX = 0;
        int iBaseCenterY = 0;
        if (iBaseSnakeId == -1) {
            iBaseCenterX = this.rectSnake[iBaseSnakeTileId].getCenterX();
            iBaseCenterY = this.rectSnake[iBaseSnakeTileId].getCenterY();
        } else {
            iBaseCenterX = this.rectAISnake[iBaseSnakeId][iBaseSnakeTileId].getCenterX();
            iBaseCenterY = this.rectAISnake[iBaseSnakeId][iBaseSnakeTileId].getCenterY();
        }
        if (Math.abs(iCenterY - iBaseCenterY) <= MainCanvas.HEIGHT >> 3) {
            if (iCenterX < iBaseCenterX) {
                return 0;
            }
            return 1;
        }
        if (Math.abs(iCenterX - iBaseCenterX) <= MainCanvas.WIDTH >> 3) {
            if (iCenterY < iBaseCenterY) {
                return 2;
            }
            return 3;
        }
        if (iCenterX < iBaseCenterX) {
            if (iCenterY < iBaseCenterY) {
                return 4;
            }
            return 5;
        }
        if (iCenterY < iBaseCenterY) {
            return 6;
        }
        return 7;
    }

    public boolean getCollisionDetection(int iAISnakeId) {
        int pom;
        if (this.rectSnakeCollision == null) {
            this.rectSnakeCollision = new Rectangle(0, 0, 0, 0);
        }
        if ((pom = this.rectAISnake[iAISnakeId][0].width * 3) < 1) {
            pom = 1;
        }
        this.rectSnakeCollision.x = this.rectAISnake[iAISnakeId][0].x - pom;
        this.rectSnakeCollision.y = this.rectAISnake[iAISnakeId][0].y - pom;
        this.rectSnakeCollision.width = this.rectAISnake[iAISnakeId][0].width + (pom << 1);
        this.rectSnakeCollision.height = this.rectAISnake[iAISnakeId][0].height + (pom << 1);
        for (int i = 1; i < this.iSnakeLength; ++i) {
            if (!this.rectSnakeCollision.intersects(this.rectSnake[i])) continue;
            this.iAISnakeReactionDirection[iAISnakeId] = this.getAICollisionKvadrant(iAISnakeId, -1, i);
            return true;
        }
        return false;
    }

    public boolean getCollisionDetection(int iAISnake1Id, int iAISnake2Id) {
        int pom;
        if (this.rectAISnakeCollision == null) {
            this.rectAISnakeCollision = new Rectangle(0, 0, 0, 0);
        }
        if ((pom = this.rectAISnake[iAISnake1Id][0].width * 3) < 1) {
            pom = 1;
        }
        this.rectAISnakeCollision.x = this.rectAISnake[iAISnake1Id][0].x - pom;
        this.rectAISnakeCollision.y = this.rectAISnake[iAISnake1Id][0].y - pom;
        this.rectAISnakeCollision.width = this.rectAISnake[iAISnake1Id][0].width + (pom << 1);
        this.rectAISnakeCollision.height = this.rectAISnake[iAISnake1Id][0].height + (pom << 1);
        for (int i = 1; i < this.iAISnakeLength[iAISnake2Id]; ++i) {
            if (!this.rectAISnakeCollision.intersects(this.rectAISnake[iAISnake2Id][i])) continue;
            this.iAISnakeReactionDirection[iAISnake1Id] = this.getAICollisionKvadrant(iAISnake1Id, iAISnake2Id, i);
            return true;
        }
        return false;
    }

    public void updatePoints() {
        int i;
        int iPomX = 0;
        int iPomY = 0;
        for (int i2 = 0; i2 < 350; ++i2) {
            if (!this.bActivePoint[i2]) continue;
            if (this.bFastSnake) {
                iPomX = this.iBgCenterX - (this.iNewShiftX >> 1) * this.iPointsAreaShiftX - this.rectPoint[i2].getCenterX();
                iPomY = this.iBgCenterY - (this.iNewShiftY >> 1) * this.iPointsAreaShiftY - this.rectPoint[i2].getCenterY();
            } else {
                iPomX = this.iBgCenterX - this.iNewShiftX * this.iPointsAreaShiftX - this.rectPoint[i2].getCenterX();
                iPomY = this.iBgCenterY - this.iNewShiftY * this.iPointsAreaShiftY - this.rectPoint[i2].getCenterY();
            }
            if (Math.abs(iPomX) <= this.iPointsAreaWidth >> 1 && Math.abs(iPomY) <= this.iPointsAreaHeight >> 1) continue;
            this.bActivePoint[i2] = false;
            this.bPointBeforeEating[i2] = false;
            --this.iActivePointsCount;
            if (this.iActivePointsCount >= 0) continue;
            this.iActivePointsCount = 0;
        }
        int pomWidth = (this.iPointsAreaWidth >> 1) - (this.iPointsAreaWidth >> 3);
        int pomHeight = (this.iPointsAreaHeight >> 1) - (this.iPointsAreaHeight >> 3);
        int iCount = 0;
        for (int i3 = 0; i3 < 350; ++i3) {
            if (!this.bActivePoint[i3] || Math.abs(this.iBgCenterX - this.iNewShiftX * this.iPointsAreaShiftX - this.rectPoint[i3].getCenterX()) >= pomWidth || Math.abs(this.iBgCenterY - this.iNewShiftY * this.iPointsAreaShiftY - this.rectPoint[i3].getCenterY()) >= pomHeight) continue;
            ++iCount;
        }
        boolean bOk = false;
        if (iCount < 43) {
            for (i = 0; i < 350; ++i) {
                bOk = false;
                if (!this.bActivePoint[i]) {
                    if (iCount < 0) {
                        if (RandomNum.getRandomUInt(10) == 0) {
                            bOk = true;
                        }
                    } else if (iCount < 0) {
                        if (RandomNum.getRandomUInt(20) == 0) {
                            bOk = true;
                        }
                    } else if (iCount < 1) {
                        if (RandomNum.getRandomUInt(30) == 0) {
                            bOk = true;
                        }
                    } else if (iCount < 2) {
                        if (RandomNum.getRandomUInt(40) == 0) {
                            bOk = true;
                        }
                    } else if (iCount < 5) {
                        if (RandomNum.getRandomUInt(50) == 0) {
                            bOk = true;
                        }
                    } else if (iCount < 10) {
                        if (RandomNum.getRandomUInt(60) == 0) {
                            bOk = true;
                        }
                    } else {
                        if (iCount >= 21) break;
                        if (RandomNum.getRandomUInt(70) == 0) {
                            bOk = true;
                        }
                    }
                }
                if (!bOk) continue;
                this.generatePoint(i, -1);
                ++iCount;
            }
        }
        for (i = 0; i < 350; ++i) {
            if (!this.bActivePoint[i] || !this.bPointBeforeEating[i]) continue;
            this.bActivePoint[i] = false;
            this.bPointBeforeEating[i] = false;
        }
    }

    public void updateBigMovingPoint(long lTick) {
        if (!this.bBigMovingPointActive) {
            this.iBigMovingPointDelayCounter = (int)((long)this.iBigMovingPointDelayCounter - lTick);
            if (this.iBigMovingPointDelayCounter <= 0) {
                int iRand = RandomNum.getRandomUInt(4);
                if (iRand == 0) {
                    this.rectBigMovingPoint.x = (MainCanvas.WIDTH >> 1) - (this.sprPoints1.getWidth() >> 1);
                    this.rectBigMovingPoint.y = -this.sprPoints1.getHeight() - (MainCanvas.HEIGHT >> 2);
                } else if (iRand == 1) {
                    this.rectBigMovingPoint.x = MainCanvas.WIDTH + (MainCanvas.WIDTH >> 2);
                    this.rectBigMovingPoint.y = (MainCanvas.HEIGHT >> 1) - (this.sprPoints1.getHeight() >> 1);
                } else if (iRand == 2) {
                    this.rectBigMovingPoint.x = (MainCanvas.WIDTH >> 1) - (this.sprPoints1.getWidth() >> 1);
                    this.rectBigMovingPoint.y = MainCanvas.HEIGHT + (MainCanvas.HEIGHT >> 2);
                } else if (iRand == 3) {
                    this.rectBigMovingPoint.x = -this.sprPoints1.getWidth() - (MainCanvas.WIDTH >> 2);
                    this.rectBigMovingPoint.y = (MainCanvas.HEIGHT >> 1) - (this.sprPoints1.getHeight() >> 1);
                }
                this.iBigMovingPointMoveType = -1;
                this.iBigMovingPointColor = RandomNum.getRandomUInt(9);
                this.bBigMovingPointBeforeEating = false;
                this.bBigMovingPointActive = true;
            }
        } else {
            int iMaxStep = this.iSnakeSpeed * 3;
            if (this.bBigMovingPointActive && !this.bBigMovingPointBeforeEating) {
                if (this.iBigMovingPointMoveType != -1 && this.iBigMovingPointMoveCounter > 0) {
                    int pomX = 1 + RandomNum.getRandomUInt(iMaxStep);
                    int pomY = 1 + RandomNum.getRandomUInt(iMaxStep);
                    int pomX2 = (iMaxStep >> 1) - 1 + RandomNum.getRandomUInt(iMaxStep - (iMaxStep >> 2));
                    int pomY2 = (iMaxStep >> 1) - 1 + RandomNum.getRandomUInt(iMaxStep - (iMaxStep >> 2));
                    if (this.iBigMovingPointMoveType == 0) {
                        this.rectBigMovingPoint.x += pomX;
                    } else if (this.iBigMovingPointMoveType == 1) {
                        this.rectBigMovingPoint.x += pomX;
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 2) {
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 3) {
                        this.rectBigMovingPoint.x -= pomX;
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 4) {
                        this.rectBigMovingPoint.x -= pomX;
                    } else if (this.iBigMovingPointMoveType == 5) {
                        this.rectBigMovingPoint.x -= pomX;
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 6) {
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 7) {
                        this.rectBigMovingPoint.x += pomX;
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 8) {
                        this.rectBigMovingPoint.x += pomX2;
                    } else if (this.iBigMovingPointMoveType == 9) {
                        this.rectBigMovingPoint.x += pomX2;
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 10) {
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 11) {
                        this.rectBigMovingPoint.x -= pomX2;
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 12) {
                        this.rectBigMovingPoint.x -= pomX2;
                    } else if (this.iBigMovingPointMoveType == 13) {
                        this.rectBigMovingPoint.x -= pomX2;
                        this.rectBigMovingPoint.y += pomY2;
                    } else if (this.iBigMovingPointMoveType == 14) {
                        this.rectBigMovingPoint.y += pomY2;
                    } else if (this.iBigMovingPointMoveType == 15) {
                        this.rectBigMovingPoint.x += pomX2;
                        this.rectBigMovingPoint.y += pomY2;
                    }
                    this.iBigMovingPointMoveType = -1;
                    --this.iBigMovingPointMoveCounter;
                    if (this.iBigMovingPointMoveCounter < 0) {
                        this.iBigMovingPointMoveCounter = 0;
                    }
                } else {
                    boolean bClose = false;
                    if (Math.abs(this.rectBigMovingPoint.getCenterX() - this.iBgCenterX) < (MainCanvas.WIDTH >> 2) + (MainCanvas.WIDTH >> 5) && Math.abs(this.rectBigMovingPoint.getCenterY() - this.iBgCenterY) < (MainCanvas.HEIGHT >> 2) + (MainCanvas.HEIGHT >> 5)) {
                        bClose = true;
                    }
                    if (bClose) {
                        if (this.rectBigMovingPoint.getCenterX() > MainCanvas.WIDTH >> 1 && Math.abs(this.rectBigMovingPoint.getCenterY() - (MainCanvas.HEIGHT >> 1)) < MainCanvas.HEIGHT >> 2) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(0, this.iBigMovingPointMoveTypeLast);
                        } else if (Math.abs(this.rectBigMovingPoint.getCenterX() - (MainCanvas.WIDTH >> 1)) < MainCanvas.WIDTH >> 2 && this.rectBigMovingPoint.getCenterY() < MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(1, this.iBigMovingPointMoveTypeLast);
                        } else if (this.rectBigMovingPoint.getCenterX() < MainCanvas.WIDTH >> 1 && Math.abs(this.rectBigMovingPoint.getCenterY() - (MainCanvas.HEIGHT >> 1)) < MainCanvas.HEIGHT >> 2) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(2, this.iBigMovingPointMoveTypeLast);
                        } else if (Math.abs(this.rectBigMovingPoint.getCenterX() - (MainCanvas.WIDTH >> 1)) < MainCanvas.WIDTH >> 2 && this.rectBigMovingPoint.getCenterY() > MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(3, this.iBigMovingPointMoveTypeLast);
                        } else if (this.rectBigMovingPoint.getCenterX() > MainCanvas.WIDTH >> 1 && this.rectBigMovingPoint.getCenterY() < MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(4, this.iBigMovingPointMoveTypeLast);
                        } else if (this.rectBigMovingPoint.getCenterX() < MainCanvas.WIDTH >> 1 && this.rectBigMovingPoint.getCenterY() < MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(5, this.iBigMovingPointMoveTypeLast);
                        } else if (this.rectBigMovingPoint.getCenterX() < MainCanvas.WIDTH >> 1 && this.rectBigMovingPoint.getCenterY() > MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(6, this.iBigMovingPointMoveTypeLast);
                        } else if (this.rectBigMovingPoint.getCenterX() > MainCanvas.WIDTH >> 1 && this.rectBigMovingPoint.getCenterY() > MainCanvas.HEIGHT >> 1) {
                            this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeClose(7, this.iBigMovingPointMoveTypeLast);
                        }
                    } else {
                        this.iBigMovingPointMoveType = this.getBigMovingPointMoveTypeRandom(this.iBigMovingPointMoveTypeLast);
                    }
                    this.iBigMovingPointMoveTypeLast = this.iBigMovingPointMoveType;
                    int pomX = 1 + RandomNum.getRandomUInt(iMaxStep);
                    int pomY = 1 + RandomNum.getRandomUInt(iMaxStep);
                    int pomX2 = (iMaxStep >> 1) - 1 + RandomNum.getRandomUInt(iMaxStep - (iMaxStep >> 2));
                    int pomY2 = (iMaxStep >> 1) - 1 + RandomNum.getRandomUInt(iMaxStep - (iMaxStep >> 2));
                    if (this.iBigMovingPointMoveType == 0) {
                        this.rectBigMovingPoint.x += pomX;
                    } else if (this.iBigMovingPointMoveType == 1) {
                        this.rectBigMovingPoint.x += pomX;
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 2) {
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 3) {
                        this.rectBigMovingPoint.x -= pomX;
                        this.rectBigMovingPoint.y -= pomY;
                    } else if (this.iBigMovingPointMoveType == 4) {
                        this.rectBigMovingPoint.x -= pomX;
                    } else if (this.iBigMovingPointMoveType == 5) {
                        this.rectBigMovingPoint.x -= pomX;
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 6) {
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 7) {
                        this.rectBigMovingPoint.x += pomX;
                        this.rectBigMovingPoint.y += pomY;
                    } else if (this.iBigMovingPointMoveType == 8) {
                        this.rectBigMovingPoint.x += pomX2;
                    } else if (this.iBigMovingPointMoveType == 9) {
                        this.rectBigMovingPoint.x += pomX2;
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 10) {
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 11) {
                        this.rectBigMovingPoint.x -= pomX2;
                        this.rectBigMovingPoint.y -= pomY2;
                    } else if (this.iBigMovingPointMoveType == 12) {
                        this.rectBigMovingPoint.x -= pomX2;
                    } else if (this.iBigMovingPointMoveType == 13) {
                        this.rectBigMovingPoint.x -= pomX2;
                        this.rectBigMovingPoint.y += pomY2;
                    } else if (this.iBigMovingPointMoveType == 14) {
                        this.rectBigMovingPoint.y += pomY2;
                    } else if (this.iBigMovingPointMoveType == 15) {
                        this.rectBigMovingPoint.x += pomX2;
                        this.rectBigMovingPoint.y += pomY2;
                    }
                    this.iBigMovingPointMoveCounter = 10;
                }
                if (this.rectBigMovingPoint.getCenterX() < 0) {
                    this.rectBigMovingPoint.x += (iMaxStep >> 1) + RandomNum.getRandomUInt(iMaxStep);
                } else if (this.rectBigMovingPoint.getCenterX() > MainCanvas.WIDTH) {
                    this.rectBigMovingPoint.x -= (iMaxStep >> 1) + RandomNum.getRandomUInt(iMaxStep);
                }
                if (this.rectBigMovingPoint.getCenterY() < 0) {
                    this.rectBigMovingPoint.y += (iMaxStep >> 1) + RandomNum.getRandomUInt(iMaxStep);
                } else if (this.rectBigMovingPoint.getCenterY() > MainCanvas.HEIGHT) {
                    this.rectBigMovingPoint.y -= (iMaxStep >> 1) + RandomNum.getRandomUInt(iMaxStep);
                }
            }
            if (this.bBigMovingPointActive && this.bBigMovingPointBeforeEating) {
                this.iBigMovingPointDelayCounter = 5000 + RandomNum.getRandomUInt(5000);
                this.bBigMovingPointActive = false;
            }
        }
    }

    public int getBigMovingPointMoveTypeClose(int iDirection, int iLastMoveType) {
        int pom7;
        int pom6;
        int pom5;
        int pom4;
        int pom3;
        int pom2;
        int pom1;
        if (iLastMoveType >= 8) {
            iLastMoveType -= 8;
        }
        if ((pom1 = iLastMoveType + 1) >= 8) {
            pom1 -= 8;
        }
        if ((pom2 = iLastMoveType + 2) >= 8) {
            pom2 -= 8;
        }
        if ((pom3 = iLastMoveType + 3) >= 8) {
            pom3 -= 8;
        }
        if ((pom4 = iLastMoveType + 4) >= 8) {
            pom4 -= 8;
        }
        if ((pom5 = iLastMoveType + 5) >= 8) {
            pom5 -= 8;
        }
        if ((pom6 = iLastMoveType + 6) >= 8) {
            pom6 -= 8;
        }
        if ((pom7 = iLastMoveType + 7) >= 8) {
            pom7 -= 8;
        }
        int[] iMoveType = iDirection == 0 ? new int[]{2, 1, 0, 7, 6} : (iDirection == 1 ? new int[]{4, 3, 2, 1, 0} : (iDirection == 2 ? new int[]{6, 5, 4, 3, 2} : (iDirection == 3 ? new int[]{0, 7, 6, 5, 4} : (iDirection == 4 ? new int[]{3, 2, 1, 0, 7} : (iDirection == 5 ? new int[]{5, 4, 3, 2, 1} : (iDirection == 6 ? new int[]{7, 6, 5, 4, 3} : new int[]{1, 0, 7, 6, 5}))))));
        if (this.iBigMovingPointMoveTypeLast == pom3) {
            return iMoveType[0] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom5) {
            return iMoveType[4] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom2) {
            return iMoveType[1] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom6) {
            return iMoveType[3] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom4) {
            if (RandomNum.getRandomUInt(2) == 0) {
                return iMoveType[0] + 8;
            }
            return iMoveType[4] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom1) {
            if (RandomNum.getRandomUInt(2) == 0) {
                return iMoveType[2] + 8;
            }
            return iMoveType[0] + 8;
        }
        if (this.iBigMovingPointMoveTypeLast == pom7) {
            if (RandomNum.getRandomUInt(2) == 0) {
                return iMoveType[2] + 8;
            }
            return iMoveType[4] + 8;
        }
        if (RandomNum.getRandomUInt(2) == 0) {
            return iMoveType[1] + 8;
        }
        return iMoveType[3] + 8;
    }

    public int getBigMovingPointMoveTypeRandom(int iLastMoveType) {
        if (iLastMoveType >= 8) {
            iLastMoveType -= 8;
        }
        int iMoveType = -1;
        if (RandomNum.getRandomUInt(2) == 0) {
            iMoveType = iLastMoveType - 1;
            if (iMoveType < 0) {
                iMoveType += 8;
            }
        } else {
            iMoveType = iLastMoveType + 1;
            if (iMoveType >= 8) {
                iMoveType -= 8;
            }
        }
        return iMoveType;
    }

    public int getPointNewSize(int iSnakeLength) {
        if (iSnakeLength < 250) {
            return 1 + RandomNum.getRandomUInt(2);
        }
        if (iSnakeLength < 376) {
            return 2 + RandomNum.getRandomUInt(2);
        }
        if (iSnakeLength < 439) {
            return 3 + RandomNum.getRandomUInt(2);
        }
        return 4;
    }

    public void crashSnake() {
        if (!this.bSnakeCrashed) {
            this.bSnakeCrashed = true;
            if (this.bFastSnake) {
                this.bFastSnake = false;
                this.bFastSnakeGlow = false;
                this.iFastSnakeGlowCounter = 0;
            }
            this.iCrashedSnakeCounter = 300;
            for (int j = 0; j < 350; ++j) {
                if (!this.bActivePoint[j] || this.rectPoint[j].getRight() >= 0 && this.rectPoint[j].x <= MainCanvas.WIDTH && this.rectPoint[j].getBottom() >= 0 && this.rectPoint[j].y <= MainCanvas.HEIGHT) continue;
                this.bActivePoint[j] = false;
            }
            int pomTileSize = this.iSnakeTileSize >> 1;
            int pomCounter = 3;
            int iLastX = -1000000;
            int iLastY = -1000000;
            block1: for (int i = 1; i < this.iSnakeLength; ++i) {
                if ((pomCounter >= 3 || RandomNum.getRandomUInt(2) == 0) && Math.abs(iLastX - this.rectSnake[i].getCenterX()) >= pomTileSize && Math.abs(iLastY - this.rectSnake[i].getCenterY()) >= pomTileSize && Math.abs(this.iBgCenterX - this.iNewShiftX * this.iPointsAreaShiftX - this.rectSnake[i].getCenterX()) < this.iPointsAreaWidth >> 1 && Math.abs(this.iBgCenterY - this.iNewShiftY * this.iPointsAreaShiftY - this.rectSnake[i].getCenterY()) < this.iPointsAreaHeight >> 1 && this.rectSnake[i].getRight() >= 0 && this.rectSnake[i].x <= MainCanvas.WIDTH && this.rectSnake[i].getBottom() >= 0 && this.rectSnake[i].y <= MainCanvas.HEIGHT) {
                    for (int j = 0; j < 350; ++j) {
                        if (this.bActivePoint[j]) continue;
                        pomCounter = 0;
                        iLastX = this.rectSnake[i].getCenterX();
                        iLastY = this.rectSnake[i].getCenterY();
                        this.generatePointAtPosition(j, this.iSnakeColor, this.rectSnake[i].getCenterX(), this.rectSnake[i].getCenterY(), this.getPointNewSize(this.iSnakeLength), true);
                        continue block1;
                    }
                    continue;
                }
                ++pomCounter;
            }
        }
    }

    public void updatePlaceDelay(long lTick) {
        if (!this.bSnakeCrashed && !this.bBeforeGameOver && this.iPlaceDecrement > 0) {
            this.iPlaceDelayCounter = (int)((long)this.iPlaceDelayCounter - lTick);
            if (this.iPlaceDelayCounter <= 0) {
                --this.iPlaceDecrement;
                if (this.iPlaceDecrement < 0) {
                    this.iPlaceDecrement = 0;
                } else if (this.iPlaceDecrement > 0) {
                    this.iPlaceDelayCounter = 250;
                }
            }
        }
    }

    public void crashAISnake(int id) {
        if (!this.bAISnakeCrashed[id]) {
            this.bAISnakeCrashed[id] = true;
            if (this.bFastAISnake[id]) {
                this.bFastAISnake[id] = false;
                this.bFastAISnakeGlow[id] = false;
                this.iFastAISnakeGlowCounter[id] = 0;
            }
            this.iCrashedAISnakeCounter[id] = 300;
            for (int j = 0; j < 350; ++j) {
                if (!this.bActivePoint[j] || this.rectPoint[j].getRight() >= -(MainCanvas.WIDTH << 1) && this.rectPoint[j].x <= MainCanvas.WIDTH * 3 && this.rectPoint[j].getBottom() >= -(MainCanvas.HEIGHT << 1) && this.rectPoint[j].y <= MainCanvas.HEIGHT * 3) continue;
                this.bActivePoint[j] = false;
            }
            int pomTileSize = this.iAISnakeTileSize[id] >> 1;
            int pomCounter = 3;
            int iLastX = -1000000;
            int iLastY = -1000000;
            block1: for (int i = 1; i < this.iAISnakeLength[id]; ++i) {
                if ((pomCounter >= 3 || RandomNum.getRandomUInt(3) == 0) && Math.abs(iLastX - this.rectAISnake[id][i].getCenterX()) >= pomTileSize && Math.abs(iLastY - this.rectAISnake[id][i].getCenterY()) >= pomTileSize && Math.abs(this.iBgCenterX - this.iNewShiftX * this.iPointsAreaShiftX - this.rectAISnake[id][i].getCenterX()) < this.iPointsAreaWidth >> 1 && Math.abs(this.iBgCenterY - this.iNewShiftY * this.iPointsAreaShiftY - this.rectAISnake[id][i].getCenterY()) < this.iPointsAreaHeight >> 1) {
                    for (int j = 0; j < 350; ++j) {
                        if (this.bActivePoint[j]) continue;
                        pomCounter = 0;
                        iLastX = this.rectAISnake[id][i].getCenterX();
                        iLastY = this.rectAISnake[id][i].getCenterY();
                        this.generatePointAtPosition(j, this.iAISnakeColor[id], this.rectAISnake[id][i].getCenterX(), this.rectAISnake[id][i].getCenterY(), this.getPointNewSize(this.iAISnakeLength[id]), true);
                        continue block1;
                    }
                    continue;
                }
                ++pomCounter;
            }
            if (!this.bSnakeCrashed && !this.bBeforeGameOver && this.iAISnakeLength[id] > this.iSnakeLength) {
                this.iPlaceDelayCounter = 250;
                ++this.iPlaceDecrement;
            }
        }
    }

    public void quit() {
        X.quitApp();
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.part = new Particles();
        this.iScreen = 0;
        this.iSubScreen = 0;
    }

    public void beforeInteruption() {
        if (this.iScreen != 0) {
            MainCanvas.soundManager.Stop();
            this.bGamePaused = true;
            if (this.iScreen == 2 && this.iSubScreen == 0 && !this.bGameOver && !this.bBeforeGameOver) {
                this.iSelectedItem = 0;
                this.iSubScreen = 2;
                this.tempScreen = this.iScreen;
                this.tempSubScreen = 2;
                this.nextScreen();
                this.initControlsPosition();
            }
        }
    }

    public void afterInteruption() {
        if (this.iScreen != 0) {
            if (Profile.bMusic) {
                // empty if block
            }
            this.bGamePaused = true;
            if (this.iScreen == 2 && this.iSubScreen == 0) {
                this.bGamePaused = false;
            }
        }
    }

    public void initGraphics() {
        if (!this.bNextScreen && !this.bLoading) {
            this.bLoading = true;
            Resources.loadGFonts(new int[]{0, 1});
            this.fontMain = Resources.resGFonts[0];
            this.fontNumbers = Resources.resGFonts[1];
            this.iFontShiftY = (this.fontMain.getHeight() >> 3) + (this.fontMain.getHeight() >> 4) + 1;
            if (this.iFontShiftY < 1) {
                this.iFontShiftY = 1;
            }
            Resources.loadImages(new int[]{1, 2, 3, 4, 5});
            this.imgInlogic = Resources.resImgs[1];
            this.imgLogo1 = Resources.resImgs[2];
            this.imgLogo2 = Resources.resImgs[3];
            this.imgGameBg = Resources.resImgs[4];
            this.imgIconBtn = Resources.resImgs[5];
            Resources.loadSprites(new int[]{0, 1, 4, 2, 3, 5, 6, 7, 8, 9});
            this.sprLanguage = Resources.resSprs[0];
            this.sprIcon = Resources.resSprs[1];
            this.sprMenuBtn = Resources.resSprs[4];
            this.sprDialog = Resources.resSprs[2];
            this.sprArrowInstructions = Resources.resSprs[3];
            this.sprPoints1 = Resources.resSprs[5];
            this.sprPoints2 = Resources.resSprs[6];
            this.sprPoints3 = Resources.resSprs[7];
            this.sprPoints4 = Resources.resSprs[8];
            this.sprDialog2 = Resources.resSprs[9];
            this.initNextScreen(0, 1, false);
            this.bLoading = false;
        }
    }

    public void initIntro() {
        if (!this.bNextScreen && !this.bLoading) {
            this.bLoading = true;
            GameDefs.iSelectedLanguage = 0;
            int iPomSpaceX = (MainCanvas.WIDTH - (this.sprLanguage.getWidth() << 1)) / 3;
            int iPomSpaceY = (MainCanvas.HEIGHT - this.imgIconBtn.getHeight() - this.sprLanguage.getHeight() * 3) / 4;
            int id = 0;
            int iPomY = 0;
            for (int i = 0; i < 3; ++i) {
                iPomY = iPomSpaceY + i * (this.sprLanguage.getHeight() + iPomSpaceY);
                GameDefs.rectLanguages[id] = new Rectangle(iPomSpaceX, iPomY, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
                GameDefs.rectLanguages[id + 1] = new Rectangle((iPomSpaceX << 1) + this.sprLanguage.getWidth(), iPomY, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
                id += 2;
            }
            this.iLogoHeight = this.imgLogo1.getHeight() + this.imgLogo2.getHeight();
            this.iLogoYIn = this.iLogoHeight >> 3;
            this.iLogoYIn2 = -this.imgLogo1.getHeight() + (this.imgLogo1.getHeight() >> 4);
            this.iLogoYOut = -this.iLogoHeight;
            this.iLogoActualY = -this.iLogoHeight;
            this.iBaseLabelHeight = this.sprMenuBtn.getHeight() * 3;
            this.iDialogWidth = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH - (MainCanvas.WIDTH >> 4) : MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 4);
            int y = (MainCanvas.HEIGHT >> 1) - (this.iBaseLabelHeight >> 1);
            this.rectLabelCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (this.iDialogWidth >> 1), y, this.iDialogWidth, this.iBaseLabelHeight);
            this.iBgCount = MainCanvas.HEIGHT / this.imgGameBg.getHeight() + 1;
            this.iBgHeight = this.iBgCount * this.imgGameBg.getHeight();
            this.iBgShiftY0 = 0;
            this.iBgShiftY1 = -this.iBgHeight;
            this.initControlsPosition();
            this.iShiftDirection = 1;
            this.iShiftX = 0;
            this.iShiftStep = MainCanvas.WIDTH / 120;
            if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                this.iShiftStep = MainCanvas.HEIGHT / 160;
            }
            this.initNextScreen(0, 2, false);
            this.bLoading = false;
        }
    }

    public void initMenu() {
        if (!this.bLoading) {
            int iFlagsHeight;
            this.bLoading = true;
            System.gc();
            this.iMenuCenterY = this.iLogoYIn + this.iLogoHeight + (MainCanvas.HEIGHT - this.iLogoYIn - this.iLogoHeight - this.imgIconBtn.getHeight() - this.iControlsShiftY >> 1);
            int iBtnWidth = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH / 3 : MainCanvas.HEIGHT / 3;
            int iBtnHeight = this.sprMenuBtn.getHeight() * 3;
            int iIconBtnWidth = this.imgIconBtn.getWidth();
            int iIconBtnHeight = this.imgIconBtn.getHeight();
            int iX = (MainCanvas.WIDTH >> 1) - (iBtnWidth >> 1);
            int iSpaceY = iIconBtnHeight >> 2;
            int iHeight = (iIconBtnHeight << 1) + (iSpaceY << 1);
            int iY = this.iMenuCenterY - (iHeight >> 1);
            this.rectMenuItems = new Rectangle[3];
            this.rectMenuItems[0] = new Rectangle(iX, iY, iBtnWidth, iBtnHeight);
            int iShiftX = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH >> 7 : MainCanvas.HEIGHT >> 7;
            int iIconBtnX1 = (MainCanvas.WIDTH >> 2) - (iIconBtnWidth >> 1) + (iShiftX -= iBtnWidth >> 4);
            int iIconBtnX2 = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2) - (iIconBtnWidth >> 1) - iShiftX;
            iY = this.iMenuCenterY + (iHeight >> 1) - iIconBtnHeight;
            if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 800) {
                iY += iIconBtnHeight >> 1;
            } else if (MainCanvas.WIDTH < 480 || MainCanvas.HEIGHT < 640) {
                if (MainCanvas.WIDTH >= 360 && MainCanvas.HEIGHT >= 640) {
                    iY += iIconBtnHeight >> 1;
                } else if (MainCanvas.WIDTH == 240 && MainCanvas.HEIGHT >= 400) {
                    iY += iIconBtnHeight >> 1;
                }
            }
            this.rectMenuItems[1] = new Rectangle(iIconBtnX1, iY, iIconBtnWidth, iIconBtnHeight);
            this.rectMenuItems[2] = new Rectangle(iIconBtnX2, iY, iIconBtnWidth, iIconBtnHeight);
            if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 800 || MainCanvas.WIDTH == 240 && MainCanvas.HEIGHT >= 400) {
                for (int i = 0; i < 3; ++i) {
                    this.rectMenuItems[i].y -= iIconBtnHeight >> 1;
                }
            }
            iX = (MainCanvas.WIDTH >> 1) - (iIconBtnWidth >> 1);
            int pom = this.fontMain.getHeight() > this.fontNumbers.getHeight() ? this.fontMain.getHeight() : this.fontNumbers.getHeight();
            this.iPauseMenuShiftY = pom + (pom >> 1);
            this.rectPauseItems = new Rectangle[3];
            this.rectPauseItems[0] = new Rectangle(this.rectMenuItems[1].x, this.rectMenuItems[0].y + this.iPauseMenuShiftY, iIconBtnWidth, iIconBtnHeight);
            this.rectPauseItems[1] = new Rectangle(this.rectMenuItems[2].x, this.rectMenuItems[0].y + this.iPauseMenuShiftY, iIconBtnWidth, iIconBtnHeight);
            this.rectPauseItems[2] = new Rectangle(iX, this.rectMenuItems[1].y + this.iPauseMenuShiftY, iIconBtnWidth, iIconBtnHeight);
            if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                this.rectPauseItems[0].x += iIconBtnWidth;
                this.rectPauseItems[1].x -= iIconBtnWidth;
            }
            this.rectPauseItems[2].y -= iIconBtnHeight >> 2;
            for (int i = 0; i < 3; ++i) {
                this.rectPauseItems[i].y -= iIconBtnHeight >> 3;
            }
            if (MainCanvas.WIDTH == 480 && MainCanvas.HEIGHT == 640) {
                this.rectPauseItems[0].y -= iIconBtnHeight >> 3;
                this.rectPauseItems[1].y -= iIconBtnHeight >> 3;
                this.rectPauseItems[2].y -= iIconBtnHeight >> 3;
            }
            int iInstructionsSpaceY = this.iBaseLabelHeight >> 1;
            this.iInstructionsY = this.iLogoYIn2 + this.iLogoHeight + iInstructionsSpaceY;
            int iDownSpaceY = this.imgIconBtn.getHeight() + this.iControlsShiftY + iInstructionsSpaceY;
            this.iInstructionsHeight = MainCanvas.HEIGHT - this.iInstructionsY - iDownSpaceY;
            int iPomArrowSpaceY = this.sprArrowInstructions.getHeight();
            if (iPomArrowSpaceY < 1) {
                iPomArrowSpaceY = 1;
            }
            this.iInstructionsContentHeight = this.iInstructionsHeight - (this.sprArrowInstructions.getHeight() << 1) - (iPomArrowSpaceY << 2);
            this.iInstructionsContentY = this.iInstructionsY + (this.iInstructionsHeight >> 1) - (this.iInstructionsContentHeight >> 1);
            this.iInstructionsWidth = this.iDialogWidth;
            iX = (MainCanvas.WIDTH >> 1) - (this.sprArrowInstructions.getWidth() >> 1);
            iY = this.iInstructionsContentY - this.sprArrowInstructions.getHeight() - iPomArrowSpaceY;
            this.rectArrowsInstructions[0] = new Rectangle(iX, iY, this.sprArrowInstructions.getWidth(), this.sprArrowInstructions.getHeight());
            iY = this.iInstructionsContentY + this.iInstructionsContentHeight + iPomArrowSpaceY;
            this.rectArrowsInstructions[1] = new Rectangle(iX, iY, this.sprArrowInstructions.getWidth(), this.sprArrowInstructions.getHeight());
            this.rectDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1), this.iInstructionsY, this.iInstructionsWidth, this.iInstructionsHeight);
            this.rectLabelCenter.y = this.iMenuCenterY - this.rectLabelCenter.height + (this.rectLabelCenter.height >> 2);
            this.rectLabelCenter.y += this.rectLabelCenter.height >> 2;
            int iSettingsSpaceY = this.sprLanguage.getHeight();
            int iSettingsHeight = iFlagsHeight = (this.sprLanguage.getHeight() << 1) + iSettingsSpaceY;
            int iPomSpaceX = this.rectDialog.width - this.sprLanguage.getWidth() * 3 >> 2;
            int iFlagsX = this.rectDialog.getCenterX() - (this.sprLanguage.getWidth() + (this.sprLanguage.getWidth() >> 1)) - iPomSpaceX;
            int iFlagsShiftX = this.sprLanguage.getWidth() + iPomSpaceX;
            int iFlagsY = this.rectDialog.getCenterY() - (iSettingsHeight >> 1);
            int id = 0;
            for (int i = 0; i < 2; ++i) {
                GameDefs.rectLanguages[id] = new Rectangle(iFlagsX, iFlagsY, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
                GameDefs.rectLanguages[id + 1] = new Rectangle(iFlagsX + iFlagsShiftX, iFlagsY, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
                GameDefs.rectLanguages[id + 2] = new Rectangle(iFlagsX + (iFlagsShiftX << 1), iFlagsY, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
                id += 3;
                iFlagsY += this.sprLanguage.getHeight() + iSettingsSpaceY;
            }
            this.musicOff();
            this.bLoading = false;
        }
    }

    public void initTexts() {
        Resources.initLangDirs(GameDefs.langCodes[GameDefs.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedItem = 0;
        this.sPlay = Resources.resTexts[0].getHashedString(7);
        this.sAbout = Resources.resTexts[0].getHashedString(10);
        this.sInstructions = Resources.resTexts[0].getHashedString(8);
        this.sSoundOn = Resources.resTexts[0].getHashedString(9) + " " + Resources.resTexts[0].getHashedString(15);
        this.sSoundOff = Resources.resTexts[0].getHashedString(9) + " " + Resources.resTexts[0].getHashedString(16);
        this.sPause = Resources.resTexts[0].getHashedString(20);
        this.sQuitToMenu = Resources.resTexts[0].getHashedString(13);
        this.sGameOver = Resources.resTexts[0].getHashedString(21);
        this.sLength = Resources.resTexts[0].getHashedString(23);
        this.sPlace = Resources.resTexts[0].getHashedString(24);
        this.sResume = Resources.resTexts[0].getHashedString(11);
        this.sBest = Resources.resTexts[0].getHashedString(25);
        this.sNewRecord = Resources.resTexts[0].getHashedString(26);
        this.sGamePaused = Resources.resTexts[0].getHashedString(22);
    }

    public void setTexts() {
        String s;
        this.iTextLines = 1;
        boolean bInstructions = false;
        block0 : switch (this.iScreen) {
            case 0: {
                switch (this.iSubScreen) {
                    default: 
                }
                break;
            }
            case 1: {
                switch (this.iSubScreen) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.rectDialog.width = this.iInstructionsWidth;
                        this.rectDialog.x = (MainCanvas.WIDTH >> 1) - (this.rectDialog.width >> 1);
                        this.rectDialog.height = this.iInstructionsHeight;
                        this.rectDialog.y = this.iInstructionsY;
                        break block0;
                    }
                    case 2: {
                        bInstructions = true;
                        break block0;
                    }
                    case 3: {
                        s = Resources.resTexts[0].getHashedString(12);
                        this.setLabelCenter(s);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.iSubScreen) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.rectDialog.width = this.iGameOverWidth;
                        this.rectDialog.x = (MainCanvas.WIDTH >> 1) - (this.iGameOverWidth >> 1);
                        this.rectDialog.height = this.iGameOverHeight;
                        this.rectDialog.y = this.iMenuCenterY - (this.iGameOverHeight >> 1);
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        this.rectDialog.width = this.iInstructionsWidth;
                        this.rectDialog.x = (MainCanvas.WIDTH >> 1) - (this.rectDialog.width >> 1);
                        this.rectDialog.height = this.iInstructionsHeight;
                        this.rectDialog.y = this.iInstructionsY;
                        break block0;
                    }
                    case 4: {
                        bInstructions = true;
                        break block0;
                    }
                    case 5: {
                        s = Resources.resTexts[0].getHashedString(14);
                        this.setLabelCenter(s);
                        break block0;
                    }
                }
                break;
            }
        }
        if (bInstructions) {
            this.bLoading = true;
            s = Resources.resTexts[0].getHashedString(35) + "\n\n\n";
            s = s + Resources.resTexts[0].getHashedString(37);
            if (Resources.resTexts[0].getHashedString(27).compareTo("") != 0) {
                s = s + "\n\n\n" + Resources.resTexts[0].getHashedString(27);
            }
            s = s + "\n\n\n";
            int iLines = this.imgInlogic.getHeight() / this.fontMain.getHeight() + 2;
            for (int i = 0; i < iLines; ++i) {
                s = s + "\n";
            }
            s = s + X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + "\n" + Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
            this.rectDialog.width = this.iInstructionsWidth;
            this.rectDialog.x = (MainCanvas.WIDTH >> 1) - (this.rectDialog.width >> 1);
            this.rectDialog.height = this.iInstructionsHeight;
            this.rectDialog.y = this.iInstructionsY;
            int textMaxWidth = this.rectDialog.width - (this.rectDialog.width >> 3);
            if (this.prepText == null) {
                this.prepText = new PreparedText(this.fontMain);
            }
            this.prepText.prepareText(s, textMaxWidth);
            this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
            this.iInstructionsShiftY = 0;
            this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - this.iInstructionsContentHeight;
            this.bDragInstructions = false;
            this.bLoading = false;
        }
    }

    public void play(boolean bRestart) {
        this.initGame();
        this.iParticlesProbability = 60;
        this.part.resetParticles();
        this.bBeforeGameOver = false;
        this.bGameOver = false;
    }

    public void initNextScreen(int nextScreen, int nextSubScreen, boolean bSetSound) {
        if (!this.bNextScreen) {
            this.bGamePaused = true;
            this.iNextScreenCounter = this.iScreen == 0 ? 1 : 5;
            if (this.iScreen == 0 && nextScreen == 1) {
                this.initSelector();
            }
            this.tempScreen = nextScreen;
            this.tempSubScreen = nextSubScreen;
            if (this.iScreen == 0) {
                this.setControlsOut();
            } else {
                this.setControlsOut();
            }
            this.bNextScreen = true;
        }
    }

    public void updateNextScreen(long lTick) {
        if (this.bNextScreen) {
            if (this.iNextScreenCounter > 0) {
                --this.iNextScreenCounter;
            } else if (!(this.bControlLeftScrollIn || this.bControlRightScrollIn || this.bControlLeftScrollOut || this.bControlRightScrollOut)) {
                this.nextScreen();
            }
        }
    }

    public void nextScreen() {
        System.gc();
        if (this.iScreen == 0 && this.tempScreen == 1 && this.tempSubScreen == 0) {
            this.initTexts();
            this.musicOff();
            this.initMenu();
        }
        this.iScreen = this.tempScreen;
        this.iSubScreen = this.tempSubScreen;
        block0 : switch (this.iScreen) {
            case 0: {
                switch (this.iSubScreen) {
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                    case 3: {
                        this.initShowedItems(6);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.iSubScreen) {
                    case 0: {
                        this.initShowedItems(3);
                        break block0;
                    }
                    case 1: {
                        this.iSelectedSettingsItem = 0;
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.iSubScreen) {
                    case 0: {
                        this.bGameOver = false;
                        this.bGamePaused = false;
                        break block0;
                    }
                    case 1: {
                        this.bNewRecord = false;
                        if (this.iActualMaxLength > Profile.iMaxLength) {
                            this.bNewRecord = true;
                            Profile.iMaxLength = this.iActualMaxLength;
                        }
                        if (this.iActualBestPlace < Profile.iBestPlace || Profile.iBestPlace == 0) {
                            this.bNewRecord = true;
                            Profile.iBestPlace = this.iActualBestPlace;
                        }
                        if (!this.bNewRecord) break block0;
                        Profile.save();
                        break block0;
                    }
                    case 2: {
                        this.initShowedItems(3);
                        break block0;
                    }
                    case 3: {
                        this.iSelectedSettingsItem = 0;
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                break;
            }
        }
        this.setTexts();
        this.bNextScreen = false;
    }

    public void initControlsPosition() {
        if (this.iControlsSpeed == 0) {
            this.iControlsSpeed = MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 ? 15 : (MainCanvas.WIDTH >= 360 && MainCanvas.HEIGHT >= 640 ? 14 : (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? 13 : (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 260 ? 12 : (MainCanvas.WIDTH >= 176 && MainCanvas.HEIGHT >= 220 ? 11 : 10))));
        }
        this.iControlsShiftX = this.imgIconBtn.getWidth() >> 3;
        this.iControlsShiftY = this.imgIconBtn.getHeight() >> 3;
        if (MainCanvas.WIDTH < 240 || MainCanvas.HEIGHT < 260) {
            this.iControlsShiftX = this.imgIconBtn.getWidth() >> 4;
            this.iControlsShiftY = this.imgIconBtn.getHeight() >> 4;
        }
        this.iControlsShiftIn = -this.iControlsShiftX;
        this.iShiftControlLeftX = this.iControlsShiftOut = this.imgIconBtn.getWidth() + this.iControlsShiftX;
        this.iShiftControlRightX = this.iControlsShiftOut;
        this.bControlLeftScrollIn = false;
        this.bControlLeftScrollOut = false;
        this.bControlRightScrollIn = false;
        this.bControlRightScrollOut = false;
    }

    public void setControlsOut() {
        this.bControlLeftScrollIn = false;
        this.bControlRightScrollIn = false;
        this.bControlLeftScrollOut = this.iShiftControlLeftX != this.iControlsShiftOut;
        this.bControlRightScrollOut = this.iShiftControlRightX != this.iControlsShiftOut;
    }

    public void updateControlsPosition() {
        if (this.bControlLeftScrollIn || this.bControlRightScrollIn || this.bControlLeftScrollOut || this.bControlRightScrollOut) {
            if (this.imgIconBtn != null) {
                if (this.bControlLeftScrollOut || this.bControlRightScrollOut) {
                    if (this.iShiftControlLeftX != this.iControlsShiftOut) {
                        this.iShiftControlLeftX += this.iControlsSpeed;
                        if (this.iShiftControlLeftX >= this.iControlsShiftOut) {
                            this.iShiftControlLeftX = this.iControlsShiftOut;
                        }
                    } else {
                        this.bControlLeftScrollOut = false;
                        this.bControlLeftScrollIn = false;
                    }
                    if (this.iShiftControlRightX != this.iControlsShiftOut) {
                        this.iShiftControlRightX += this.iControlsSpeed;
                        if (this.iShiftControlRightX >= this.iControlsShiftOut) {
                            this.iShiftControlRightX = this.iControlsShiftOut;
                        }
                    } else {
                        this.bControlRightScrollOut = false;
                        this.bControlRightScrollIn = false;
                    }
                } else if (this.bControlLeftScrollIn || this.bControlRightScrollIn) {
                    if (this.iScreen == 2 && this.iSubScreen == 1 && this.iGameOverStep < 4) {
                        return;
                    }
                    if (this.bControlLeftScrollIn && this.iShiftControlLeftX != this.iControlsShiftIn) {
                        this.iShiftControlLeftX -= this.iControlsSpeed;
                        if (this.iShiftControlLeftX <= this.iControlsShiftIn) {
                            this.iShiftControlLeftX = this.iControlsShiftIn;
                        }
                    }
                    if (this.bControlRightScrollIn && this.iShiftControlRightX != this.iControlsShiftIn) {
                        this.iShiftControlRightX -= this.iControlsSpeed;
                        if (this.iShiftControlRightX <= this.iControlsShiftIn) {
                            this.iShiftControlRightX = this.iControlsShiftIn;
                        }
                    }
                }
            } else {
                if (this.bControlRightScrollOut) {
                    this.bControlRightScrollOut = false;
                }
                if (this.bControlRightScrollIn) {
                    this.bControlRightScrollIn = false;
                }
            }
        }
    }

    public void initShowedItems(int iMaxItems) {
        this.iShowedItemsCounter = 0;
        this.iShowedItems = -1;
        this.iMaxShowedItems = iMaxItems;
    }

    public void updateShowedItems(long lTick) {
        if (!this.bNextScreen && this.iNextScreenCounter <= 0) {
            int pom = 60;
            if (this.iShowedItems < this.iMaxShowedItems) {
                this.iShowedItemsCounter = (int)((long)this.iShowedItemsCounter + lTick);
                if (this.iShowedItemsCounter >= pom) {
                    this.iShowedItemsCounter -= pom;
                    ++this.iShowedItems;
                    if (this.iShowedItems > this.iMaxShowedItems) {
                        this.iShowedItems = this.iMaxShowedItems;
                    }
                }
            }
        }
    }

    public void initSelector() {
        if (this.iSelectorStep == 0) {
            this.iSelectorStep = MainCanvas.WIDTH / 120;
            if (this.iSelectorStep < 1) {
                this.iSelectorStep = 1;
            }
        }
        this.iSelectorDirection = 1;
        this.iSelectorX = 0;
    }

    public void updateSelector() {
        if (this.iSelectorDirection > 0) {
            if (this.iSelectorX < this.iSelectorStep << 1) {
                this.iSelectorX += this.iSelectorStep;
            } else {
                this.iSelectorDirection = -1;
            }
        } else if (this.iSelectorX > -(this.iSelectorStep << 1)) {
            this.iSelectorX -= this.iSelectorStep;
        } else {
            this.iSelectorDirection = 1;
        }
    }

    public void setLabelCenter(String s) {
        int textMaxWidth = 0;
        this.rectLabelCenter.height = this.iBaseLabelHeight;
        textMaxWidth = this.rectLabelCenter.width - (this.rectLabelCenter.width >> 3);
        if (this.prepText == null) {
            this.prepText = new PreparedText(this.fontMain);
        }
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectLabelCenter.height += (this.iTextLines - 1) * this.fontMain.getHeight();
        }
        if (this.rectLabelCenter.height < this.sprDialog.getHeight() + (this.sprDialog.getHeight() >> 1)) {
            this.rectLabelCenter.height = this.sprDialog.getHeight() + (this.sprDialog.getHeight() >> 1);
        }
    }

    public void initGameOverDialog() {
        this.iGameOverContentHeight = this.fontNumbers.getHeight() * 3;
        this.iGameOverHeight = this.iGameOverContentHeight + this.fontNumbers.getHeight() * 3;
        this.iGameOverWidth = this.iInstructionsWidth;
    }

    public void createParticles(int x, int y) {
        int iX = x;
        int iY = y;
        int iSize = 0;
        iSize = MainCanvas.WIDTH >= 480 ? 2 : 1;
        int iVelX = 0;
        int iVelY = 0;
        int iAccX = 0;
        int iAccY = 0;
        int iColor = 0;
        if (this.iSnakeColor == 3) {
            int rand = RandomNum.getRandomUInt(this.PARTICLES_COLOR.length);
            iColor = this.PARTICLES_COLOR[rand];
        } else {
            iColor = 0xFFFFFF;
        }
        int iLife = 0;
        int iBaseLife = 1;
        int iMaxLife = 1;
        int iStartPositionShift = (this.rectSnake[1].width >> 1) + (this.rectSnake[1].width >> 3) + 1;
        iLife = iBaseLife + RandomNum.getRandomUInt(iMaxLife);
        this.part.createParticle2(iX += RandomNum.getRandomInt(iStartPositionShift), iY += RandomNum.getRandomInt(iStartPositionShift), iVelX, iVelY, iAccX, iAccY, iSize, iColor, iLife);
    }
}

