/*
 * Decompiled with CFR 0.152.
 */
package Coral.Math.Float;

import Coral.Math.Float.crlV4;

public class crlMath {
    public static final float TOL = 1.0E-6f;
    public static final double SQRT3 = 1.7320508075688772;
    public static final double LOG10 = 2.302585092994046;
    public static final double LOGdiv2 = -0.6931471805599453;
    public static final double PIdiv2 = 1.5707963267948966;
    public static final double PIdiv6 = 0.5235987755982988;
    public static final double PIdiv12 = 0.2617993877991494;
    public static final double PI2 = Math.PI * 2;
    public static final double PIinv = 0.3183098861837907;
    public static final double PI2inv = 0.15915494309189535;
    public static final double DEGTORAD = 0.017453292942564074;
    public static final double RADTODEG = 57.29577951308232;
    public static final float MPSTOMPH = 2.24f;
    public static final float MPSTOKMH = 3.6f;
    public static final float MPHTOMPS = 0.447f;
    public static final float PIf = (float)Math.PI;
    public static final float PI2f = (float)Math.PI * 2;
    public static final float PIdiv2f = 1.5707963f;
    public static final float PIdiv12f = 0.2617994f;
    public static final float PIdiv6f = 0.5235988f;
    public static final float PI2invf = 0.15915494f;
    public static final float SQRT3f = 1.7320508f;
    public static final float DEGTORADf = 0.017453294f;
    public static final float RADTODEGf = 57.295776f;

    public static double acos(double d2) {
        double d3 = crlMath.asin(d2);
        if (d3 == Double.NaN) {
            return d3;
        }
        return 1.5707963267948966 - d3;
    }

    public static double asin(double d2) {
        if (d2 < -1.0 || d2 > 1.0) {
            return Double.NaN;
        }
        if (d2 == -1.0) {
            return -1.5707963267948966;
        }
        if (d2 == 1.0) {
            return 1.5707963267948966;
        }
        return crlMath.atan(d2 / Math.sqrt(1.0 - d2 * d2));
    }

    public static double atan(double d2) {
        double d3;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        if (d2 > 1.0) {
            d2 = 1.0 / d2;
            bl2 = true;
        }
        while (d2 > 0.2617993877991494) {
            ++n;
            d3 = d2 + 1.7320508075688772;
            d3 = 1.0 / d3;
            d2 *= 1.7320508075688772;
            d2 -= 1.0;
            d2 *= d3;
        }
        double d4 = d2 * d2;
        d3 = d4 + 1.4087812;
        d3 = 0.55913709 / d3;
        d3 += 0.60310579;
        d3 -= d4 * 0.05160454;
        d3 *= d2;
        while (n > 0) {
            d3 += 0.5235987755982988;
            --n;
        }
        if (bl2) {
            d3 = 1.5707963267948966 - d3;
        }
        if (bl) {
            d3 = -d3;
        }
        return d3;
    }

    public static float acosf(float f2) {
        float f3 = crlMath.asinf(f2);
        if (f3 == Float.NaN) {
            return f3;
        }
        return 1.5707963f - f3;
    }

    public static float asinf(float f2) {
        if (f2 < -1.0f || f2 > 1.0f) {
            return Float.NaN;
        }
        if (f2 == -1.0f) {
            return -1.5707963f;
        }
        if (f2 == 1.0f) {
            return 1.5707963f;
        }
        return crlMath.atanf(f2 / (float)Math.sqrt(1.0f - f2 * f2));
    }

    public static float atanf(float f2) {
        float f3;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (f2 < 0.0f) {
            f2 = -f2;
            bl = true;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f / f2;
            bl2 = true;
        }
        while (f2 > 0.2617994f) {
            ++n;
            f3 = f2 + 1.7320508f;
            f3 = 1.0f / f3;
            f2 *= 1.7320508f;
            f2 -= 1.0f;
            f2 *= f3;
        }
        float f4 = f2 * f2;
        f3 = f4 + 1.4087812f;
        f3 = 0.5591371f / f3;
        f3 += 0.6031058f;
        f3 -= f4 * 0.05160454f;
        f3 *= f2;
        while (n > 0) {
            f3 += 0.5235988f;
            --n;
        }
        if (bl2) {
            f3 = 1.5707963f - f3;
        }
        if (bl) {
            f3 = -f3;
        }
        return f3;
    }

    public static double atan2(double d2, double d3) {
        if (d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d3 > 0.0) {
            return crlMath.atan(d2 / d3);
        }
        if (d3 < 0.0) {
            if (d2 < 0.0) {
                return -(Math.PI - crlMath.atan(d2 / d3));
            }
            return Math.PI - crlMath.atan(-d2 / d3);
        }
        if (d2 < 0.0) {
            return -1.5707963267948966;
        }
        return 1.5707963267948966;
    }

    public static float fast_atan2(float f2, float f3) {
        float f4;
        float f5;
        float f6;
        if (f3 == 0.0f) {
            if (f2 > 0.0f) {
                return 1.5707963f;
            }
            if (f2 == 0.0f) {
                return 0.0f;
            }
            return -1.5707963f;
        }
        float f7 = f2 / f3;
        float f8 = f6 = f5 < 0.0f ? -f7 : f7;
        if (f8 < 1.0f) {
            f4 = f7 / (1.0f + 0.28f * f7 * f7);
            if (f3 < 0.0f) {
                if (f2 < 0.0f) {
                    return f4 - (float)Math.PI;
                }
                return f4 + (float)Math.PI;
            }
        } else {
            f4 = 1.5707963f - f7 / (f7 * f7 + 0.28f);
            if (f2 < 0.0f) {
                return f4 - (float)Math.PI;
            }
        }
        return f4;
    }

    public static float invSqrt(float f2) {
        float f3 = 0.5f * f2;
        int n = Float.floatToIntBits(f2);
        n = 1597463174 - (n >> 1);
        f2 = Float.intBitsToFloat(n);
        f2 *= 1.5f - f3 * f2 * f2;
        return f2;
    }

    public static double exp(double d2) {
        if (d2 == 0.0) {
            return 1.0;
        }
        double d3 = 1.0;
        boolean bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        double d4 = d2 / 1.0;
        for (long i = 2L; i < 50L; ++i) {
            d3 += d4;
            d4 = d4 * d2 / (double)i;
        }
        if (bl) {
            return 1.0 / d3;
        }
        return d3;
    }

    private static double a(double d2) {
        double d3;
        if (!(d2 > 0.0)) {
            return Double.NaN;
        }
        double d4 = 0.0;
        int n = 0;
        while (d2 > 0.0 && d2 <= 1.0) {
            d2 *= 2.0;
            ++n;
        }
        --n;
        double d5 = (d2 /= 2.0) - 1.0;
        double d6 = d2 + 1.0;
        double d7 = d3 = d5 / d6;
        d6 = d3 * d3;
        for (long i = 1L; i < 50L; i += 2L) {
            d4 += d7 / (double)i;
            d7 *= d6;
        }
        d4 *= 2.0;
        for (int i = 0; i < n; ++i) {
            d4 += -0.6931471805599453;
        }
        return d4;
    }

    public static double log(double d2) {
        if (!(d2 > 0.0)) {
            return Double.NaN;
        }
        if (d2 == 1.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0 / d2;
            return -crlMath.a(d2);
        }
        return crlMath.a(d2);
    }

    public static double log10(double d2) {
        return crlMath.log(d2) / 2.302585092994046;
    }

    public static final float round2dp(float f2) {
        return (float)((int)((f2 + 0.005f) * 100.0f)) / 100.0f;
    }

    public static final double round2dp(double d2) {
        return (float)((int)((d2 + 0.005) * 100.0)) / 100.0f;
    }

    public static final float clamp(float f2, float f3, float f4) {
        return Math.min(Math.max(f2, f3), f4);
    }

    public static final double clamp(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }

    public static final float lerp(float f2, float f3, float f4) {
        return f3 + (f4 - f3) * f2;
    }

    public static final double lerp(double d2, double d3, double d4) {
        return d3 + (d4 - d3) * d2;
    }

    public static final float sgn(float f2) {
        if (f2 < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static final void calcNorms(crlV4 crlV42, crlV4 crlV43, crlV4 crlV44, crlV4 crlV45, crlV4 crlV46, crlV4 crlV47) {
        float f2 = crlV43.x - crlV42.x;
        float f3 = crlV43.y - crlV42.y;
        float f4 = crlV43.z - crlV42.z;
        float f5 = crlV44.x - crlV42.x;
        float f6 = crlV44.y - crlV42.y;
        float f7 = crlV44.z - crlV42.z;
        crlV46.x = f3 * f7 - f4 * f6;
        crlV46.y = f4 * f5 - f2 * f7;
        crlV46.z = f2 * f6 - f3 * f5;
        float f8 = 1.0f / (float)Math.sqrt(crlV46.x * crlV46.x + crlV46.y * crlV46.y + crlV46.z * crlV46.z);
        crlV46.x *= f8;
        crlV46.y *= f8;
        crlV46.z *= f8;
        crlV47.x = crlV44.x - crlV42.x;
        crlV47.y = crlV44.y - crlV42.y;
        crlV47.z = crlV44.z - crlV42.z;
        f8 = 1.0f / (float)Math.sqrt(crlV47.x * crlV47.x + crlV47.y * crlV47.y + crlV47.z * crlV47.z);
        crlV47.x *= f8;
        crlV47.y *= f8;
        crlV47.z *= f8;
        crlV45.x = crlV46.y * crlV47.z - crlV46.z * crlV47.y;
        crlV45.y = crlV46.z * crlV47.x - crlV46.x * crlV47.z;
        crlV45.z = crlV46.x * crlV47.y - crlV46.y * crlV47.x;
    }
}

