/*
 * Decompiled with CFR 0.152.
 */
package CGX.Events.SkySurfing;

import CGX.Events.SkySurfing.cScene;
import CGX.Events.SkySurfing.cSkySurfer;
import CGX.Events.SkySurfing.cSkySurfingTrickBar;
import CGX.Events.cArrowSequence;
import CGX.Events.cDirArrow;
import CGX.Events.cEvent;
import CGX.Events.cScore;
import CGX.Events.cTempScore;
import CGX.Events.cTime;
import CGX.Events.iArrowListener;
import CGX.Usefuls.cCamera;
import CGX.Usefuls.cGlobals;
import CGX.Usefuls.cUtils;
import CGX.Usefuls.cVector2;
import Coral.Graphics2D.crlFont;
import Coral.Util.crlResourceManager;
import Coral.crlCanvas;
import javax.microedition.lcdui.Graphics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class cSkySurfingEngine
extends cEvent
implements iArrowListener {
    private static final long[] a = new long[]{2226993133518L, 2291443664156L, 4225877033782L, 1402960026833L, 1461882091564L, 1971141012380L, 2032273430002L, 2354114297715L};
    public static final long[] _audioResources = new long[]{77417924077L};
    public static final int[] _audioTypes = new int[]{1};
    public static cSkySurfingEngine _instance;
    public static final int[] _arrowHitScores;
    private int a;
    private int b;
    public cSkySurfer _player;
    public cSkySurfingTrickBar _trickBar;
    public cTime _time;
    public cScene _scene;
    public cArrowSequence _arrows;

    public cSkySurfingEngine(int n) {
        super(n);
        _instance = this;
        this._player = new cSkySurfer();
        this._trickBar = new cSkySurfingTrickBar();
        this._trickBar._audioIndex = 0;
    }

    public void loadResources() {
        crlCanvas.gResourceManager.insertPack(a);
        crlCanvas.gResourceManager.insertPack(_audioResources);
    }

    public int init(int n) {
        if (n < 10) {
            n = 10;
            this._player.init();
        } else if (n < 20) {
            n = 20;
            this._trickBar.init();
            cCamera._p = new cVector2();
        } else if (n < 30) {
            n = 30;
            this._scene = new cScene();
        } else if (n < 40) {
            n = 40;
            ((cEvent)this).a = new cScore(cGlobals._fontScore);
            this._tempScore = new cTempScore(cGlobals._fontScore, ((cEvent)this).a);
            this._tempScore._audioIndex = 0;
            this._time = new cTime();
            this._time._levelTimeLimit = 90000;
            this._time.reset(true);
        } else if (n < 80) {
            n = 80;
            cGlobals._audioManager.open(_audioResources.length);
            cGlobals._audioManager.load(crlCanvas.gResourceManager, _audioResources, _audioTypes);
        } else if (n < 90) {
            n = 90;
            this._arrows = new cArrowSequence(this);
            this._arrows._reversed = true;
            this._arrows._hintCircles = true;
            this._arrows._arrowStateDistance = 10;
        } else if (n < 100) {
            n = 100;
            this.restart();
            this.update(0);
        }
        return n;
    }

    public void restart() {
        this._player.restart();
        this._arrows._spawnRangeX = new cVector2(this._player._position.x - 40, this._player._position.x + this._player._skySurfer.getWidth(0) + 5);
        this._arrows.restart();
        this.b = 3;
        this._trickBar.restart(this.b);
        this._time.reset(true);
        this._scene.restart();
        ((cEvent)this).a.reset();
        this._tempScore.reset();
        this._renderHUD = true;
        this.a = 0;
    }

    public void bankFailed() {
        --this.b;
        if (this.b < 3) {
            this.b = 3;
        }
        this._tempScore._score = 0;
        this._trickBar.restart(this.b);
        this.a = 1;
        this._player.startStand();
    }

    public void bankSucceeded() {
        ++this.b;
        if (this._trickBar._gotOneWrong) {
            this._tempScore._score = 0;
        }
        if (this._tempScore._score != 0) {
            this._tempScore._score += this._trickBar._drainTime / 4;
        }
        this._tempScore.bank();
        this._trickBar.restart(this.b);
        this.a = 1;
        this._player.startStand();
    }

    public void update(int n) {
        this.d(n);
        this.c(n);
        this.b(n);
    }

    private void b(int n) {
        this._scene.update(n);
        this._tempScore.update(n);
        cCamera._p.y = this._player._position.y - 30 - 180;
        cCamera._p.x = this._player._position.x - 180;
    }

    private void c(int n) {
        if (this.a != 0) {
            this._trickBar.update(n);
            this._player.update(n);
            this._tempScore._x = this._player._position.x - cCamera._p.x;
            this._tempScore._y = this._player._position.y - cCamera._p.y - this._player._skySurfer.getHeight(0) - cGlobals._fontScore._mFontHeight - 40;
            this._arrows._worldHitLineY = this._player._position.y;
            this._time.update(n);
            if (!this._time._timerRunning) {
                this.a(0);
            }
        }
    }

    private void d(int n) {
        int n2 = crlCanvas.mPad;
        switch (this.a) {
            case 0: {
                if (n2 != 16 || crlCanvas.mPadDB != 1) break;
                crlCanvas.mPadDB = 0;
                this.a = 1;
                this._time.start();
                return;
            }
            case 1: {
                this._arrows.update(n);
                this._arrows.updateInput(n);
            }
        }
    }

    public cTime getTime() {
        return this._time;
    }

    public void arrowHit(cDirArrow cDirArrow2) {
        this._tempScore._score += _arrowHitScores[cDirArrow2._hitState];
        if (cDirArrow2._hitState != 0) {
            cDirArrow2._visible = false;
            this._trickBar.addArrow(cDirArrow2._position.x - cCamera._p.x, cDirArrow2._position.y - cCamera._p.y, cDirArrow2._direction, cDirArrow2._hitState);
            if (this._trickBar._state == 1) {
                this.a = 2;
                return;
            }
        } else {
            this._tempScore._score -= _arrowHitScores[3];
            if (this._tempScore._score < 0) {
                this._tempScore._score = 0;
            }
            this._trickBar.removeArrow();
        }
    }

    public void render(Graphics graphics) {
        this._scene.renderBehind(graphics);
        this._player.render(graphics);
        this._scene.renderInfront(graphics);
        if (this.a == 1) {
            this._arrows.render(graphics);
        }
        if (this._renderHUD) {
            this.a(graphics);
        }
    }

    private void a(Graphics graphics) {
        this._time.render(graphics);
        this._trickBar.render(graphics);
        ((cEvent)this).a.render(graphics);
        this._tempScore.render(graphics);
        switch (this.a) {
            case 0: {
                crlFont crlFont2 = cGlobals._fontSmall;
                cUtils.drawCentredString(graphics, crlFont2, crlResourceManager.mLocaleText[23], 180, 180, true);
            }
        }
    }

    public void unloadResources() {
        crlCanvas.gResourceManager.destroyPack(a);
        crlCanvas.gResourceManager.destroyPack(_audioResources);
        cGlobals._audioManager.unload();
        _instance = null;
    }

    static {
        _arrowHitScores = new int[]{0, 20, 50, 100};
    }

    public static interface _gameStates {
        public static final int STARTING = 0;
        public static final int ARROWCOLLECTING = 1;
        public static final int BANKING = 2;
    }
}

