/*
 * Decompiled with CFR 0.152.
 */
package CGX.Events.Surfing;

import CGX.Events.Surfing.cPaddleBar;
import CGX.Events.Surfing.cScene;
import CGX.Events.Surfing.cSurfer;
import CGX.Events.cArrowScrollBar;
import CGX.Events.cBalanceBar;
import CGX.Events.cDirArrow;
import CGX.Events.cEvent;
import CGX.Events.cScore;
import CGX.Events.cTempScore;
import CGX.Events.cTime;
import CGX.Events.iArrowListener;
import CGX.Usefuls.cCamera;
import CGX.Usefuls.cGlobals;
import CGX.Usefuls.cSingleValAnimation$cAnimState;
import CGX.Usefuls.cUtils;
import CGX.Usefuls.cVector2;
import Coral.Graphics2D.crlFont;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import Coral.crlCanvas;
import javax.microedition.lcdui.Graphics;

public class cSurfingEngine
extends cEvent
implements iArrowListener {
    private static final long[] a = new long[]{4032326611829L, 1522690095738L, 3708182576399L, 3774559504919L, 3836126910780L, 3903841106604L, 3964673461121L, 4096291240384L, 2805612723537L};
    public static final long[] _audioResources = new long[]{77417924077L};
    public static final int[] _audioTypes = new int[]{1};
    public static cSurfingEngine _instance;
    public int _scoreMultiplier;
    private int c;
    private int d;
    public cSurfer _player;
    public cTime _time;
    public cScene _scene;
    public cBalanceBar _balanceBar;
    public cPaddleBar _paddleBar;
    public cArrowScrollBar _trickBar;

    public cSurfingEngine(int n) {
        super(n);
        _instance = this;
        this._player = new cSurfer();
        this._paddleBar = new cPaddleBar();
        this._trickBar = new cArrowScrollBar(this);
    }

    public void loadResources() {
        crlCanvas.gResourceManager.insertPack(a);
        crlCanvas.gResourceManager.insertPack(_audioResources);
    }

    public void init() {
        this._player.init();
        cCamera._p = new cVector2();
        this._trickBar.init();
        this._trickBar._y = 50;
        this._scene = new cScene();
        ((cEvent)this).a = new cScore(cGlobals._fontScore);
        this._tempScore = new cTempScore(cGlobals._fontScore, ((cEvent)this).a);
        this._tempScore._audioIndex = 0;
        this._balanceBar = new cBalanceBar(this._tempScore);
        this._tempScore._bankAnimTime = 1000;
        this._time = new cTime();
        this._time._levelTimeLimit = 90000;
        this._time.reset(true);
        this._balanceBar.init();
        this._paddleBar.init();
        this._paddleBar._position.x = cEvent.a / 2;
        this._paddleBar._position.y = cEvent.b - 20;
        this._balanceBar._x = cEvent.a / 2 - this._balanceBar._width / 2;
        this._balanceBar._y = 80;
        cGlobals._audioManager.open(_audioResources.length);
        cGlobals._audioManager.load(crlCanvas.gResourceManager, _audioResources, _audioTypes);
        this.restart();
        this.update(0);
    }

    public void restart() {
        this._player.restart();
        this._time.reset(true);
        this._scene.restart();
        ((cEvent)this).a.reset();
        this._tempScore.reset();
        this._renderHUD = true;
        this.c = 0;
        this._scoreMultiplier = 1;
        this._balanceBar.restart();
        this._trickBar.restart();
        this.d = 2;
    }

    public int startTrick() {
        if (this._tempScore._score != 0) {
            this._tempScore.bank();
        }
        int n = 2000 + this.d * 300;
        this._trickBar.start(this.d, n);
        return n;
    }

    public void stopTrick() {
        if (this._trickBar._missedAnyArrows || !this._trickBar._allArrowsDone) {
            this._tempScore._score = 0;
            this._player.setState(6);
            return;
        }
        this._tempScore.bank();
        ++this.d;
        this._player.setState(4);
    }

    public void stopWipeOut() {
        this._player.restart();
        this._scene.restart();
        this.d = 2;
        this._scoreMultiplier = 1;
        cCamera._p = new cVector2();
    }

    public void gotPaddleArrow() {
        ((cSingleValAnimation$cAnimState)this._player._paddleMoveAnim._states.elementAt((int)this._player._paddleMoveAnim._currentAnimState))._length -= 200;
    }

    public void missedPaddleArrow() {
        this._tempScore._score -= 50;
        if (this._tempScore._score < 0) {
            this._tempScore._score = 0;
        }
    }

    public void arrowHit(cDirArrow cDirArrow2) {
        if (cDirArrow2._hitState == 3) {
            this._tempScore._score += 50 * this.d;
        }
    }

    public void playerStateChange(int n) {
        if (n == 0) {
            this._tempScore.bank();
            this._paddleBar.startPaddle();
            return;
        }
        if (n == 1) {
            this._tempScore.bank();
            this._balanceBar.restart();
            return;
        }
        if (n == 3) {
            this._tempScore.bank();
        }
    }

    public void update(int n) {
        cSurfingEngine cSurfingEngine2 = this;
        int n2 = crlCanvas.mPad;
        switch (cSurfingEngine2.c) {
            case 0: {
                if (n2 != 16 || crlCanvas.mPadDB != 1) break;
                crlCanvas.mPadDB = 0;
                cSurfingEngine2.c = 1;
                cSurfingEngine2._time.start();
            }
        }
        n2 = n;
        cSurfingEngine2 = this;
        if (cSurfingEngine2.c != 0) {
            cSurfingEngine2._scene.update(n2);
            cSurfingEngine2._tempScore.update(n2);
            cSurfingEngine2._player.update(n2);
            cSurfingEngine2._time.update(n2);
            if (cSurfingEngine2._player._state == 0) {
                cSurfingEngine2._paddleBar.update(n2);
            } else if (cSurfingEngine2._player._state == 1) {
                cSurfingEngine2._balanceBar.update(n2);
            } else if (cSurfingEngine2._player._state == 5) {
                cSurfingEngine2._trickBar.update(n2);
            }
            if (!cSurfingEngine2._time._timerRunning) {
                cSurfingEngine2.a(0);
            }
        }
        if (cSurfingEngine2._player._state == 5 || cSurfingEngine2._player._state == 4) {
            cCamera._p.x = cSurfingEngine2._player._position.x - cEvent.a / 2;
        }
        cSurfingEngine2._tempScore._x = cSurfingEngine2._player._position.x - cCamera._p.x;
        cSurfingEngine2._tempScore._y = cSurfingEngine2._player._position.y - cCamera._p.y - 80;
    }

    public cTime getTime() {
        return this._time;
    }

    public void render(Graphics graphics) {
        this._scene.render(graphics);
        if (this._player._state == 0 && this._player._paddleMoveAnim._currentAnimState == 0) {
            this._scene.renderTrickWaveCrest(graphics);
            this._scene.renderBalanceWave(graphics);
            this._scene.renderPaddleWave(graphics);
            this._player.render(graphics);
        } else if (this._player._state == 0 && this._player._paddleMoveAnim._currentAnimState > 0) {
            this._scene.renderTrickWaveCrest(graphics);
            this._scene.renderBalanceWave(graphics);
            this._player.render(graphics);
            this._scene.renderPaddleWave(graphics);
        } else if (this._player._state == 1 && this._player._balanceMoveAnim._currentAnimState == 0) {
            this._scene.renderTrickWaveCrest(graphics);
            this._scene.renderBalanceWave(graphics);
            this._player.render(graphics);
            this._scene.renderPaddleWave(graphics);
        } else if (this._player._state == 6) {
            this._player.render(graphics);
            this._scene.renderBalanceWave(graphics);
            this._scene.renderPaddleWave(graphics);
            this._scene.renderTrickWaveCrest(graphics);
        } else {
            this._scene.renderTrickWaveCrest(graphics);
            this._player.render(graphics);
            this._scene.renderBalanceWave(graphics);
            this._scene.renderPaddleWave(graphics);
        }
        if (this._player._state == 5) {
            this._trickBar.render(graphics);
        }
        if (this._renderHUD) {
            if (this.c == 0) {
                crlFont crlFont2 = cGlobals._fontSmall;
                cUtils.drawCentredString(graphics, crlFont2, crlResourceManager.mLocaleText[23], cEvent.a / 2, cEvent.b / 2, true);
            } else {
                if (this._player._state == 0) {
                    this._paddleBar.render(graphics);
                } else if (this._player._state == 1) {
                    this._balanceBar.render(graphics);
                }
                if (this._scoreMultiplier != 1) {
                    crlString crlString2 = new crlString("X" + this._scoreMultiplier);
                    cGlobals._fontScore.print(graphics, 5, cEvent.b / 2, crlString2);
                }
                this._tempScore.render(graphics);
            }
            this._time.render(graphics);
            ((cEvent)this).a.render(graphics);
        }
    }

    public void unloadResources() {
        crlCanvas.gResourceManager.destroyPack(a);
        crlCanvas.gResourceManager.destroyPack(_audioResources);
        cGlobals._audioManager.unload();
        _instance = null;
    }

    public int init(int n) {
        this.init();
        return 100;
    }
}

