/*
 * Decompiled with CFR 0.152.
 */
package CGX.Events.SkySurfing;

import CGX.Events.SkySurfing.cScene;
import CGX.Events.SkySurfing.cSkySurfer;
import CGX.Events.SkySurfing.cSkySurfingTrickBar;
import CGX.Events.cArrowSequence;
import CGX.Events.cDirArrow;
import CGX.Events.cEvent;
import CGX.Events.cScore;
import CGX.Events.cTempScore;
import CGX.Events.cTime;
import CGX.Events.iArrowListener;
import CGX.Usefuls.cCamera;
import CGX.Usefuls.cGlobals;
import CGX.Usefuls.cUtils;
import CGX.Usefuls.cVector2;
import Coral.Graphics2D.crlFont;
import Coral.Util.crlResourceManager;
import Coral.crlCanvas;
import javax.microedition.lcdui.Graphics;

public class cSkySurfingEngine
extends cEvent
implements iArrowListener {
    private static final long[] a = new long[]{2225581900598L, 2293405900100L, 4096291240384L, 1401825175086L, 1461682313925L, 1970681469988L, 2035039674687L, 2357168761902L};
    public static final long[] _audioResources = new long[]{77417924077L};
    public static final int[] _audioTypes = new int[]{1};
    public static cSkySurfingEngine _instance;
    public static final int[] _arrowHitScores;
    private int c;
    private int d;
    public cSkySurfer _player;
    public cSkySurfingTrickBar _trickBar;
    public cTime _time;
    public cScene _scene;
    public cArrowSequence _arrows;

    public cSkySurfingEngine(int n) {
        super(n);
        _instance = this;
        this._player = new cSkySurfer();
        this._trickBar = new cSkySurfingTrickBar();
        this._trickBar._audioIndex = 0;
    }

    public void loadResources() {
        crlCanvas.gResourceManager.insertPack(a);
        crlCanvas.gResourceManager.insertPack(_audioResources);
    }

    public int init(int n) {
        if (n < 10) {
            n = 10;
            this._player.init();
        } else if (n < 20) {
            n = 20;
            this._trickBar.init();
            cCamera._p = new cVector2();
        } else if (n < 30) {
            n = 30;
            this._scene = new cScene();
        } else if (n < 40) {
            n = 40;
            ((cEvent)this).a = new cScore(cGlobals._fontScore);
            this._tempScore = new cTempScore(cGlobals._fontScore, ((cEvent)this).a);
            this._tempScore._audioIndex = 0;
            this._time = new cTime();
            this._time._levelTimeLimit = 90000;
            this._time.reset(true);
        } else if (n < 80) {
            n = 80;
            cGlobals._audioManager.open(_audioResources.length);
            cGlobals._audioManager.load(crlCanvas.gResourceManager, _audioResources, _audioTypes);
        } else if (n < 90) {
            n = 90;
            this._arrows = new cArrowSequence(this);
            this._arrows._reversed = true;
            this._arrows._hintCircles = true;
            this._arrows._arrowStateDistance = 10;
        } else if (n < 100) {
            n = 100;
            this.restart();
            this.update(0);
        }
        return n;
    }

    public void restart() {
        this._player.restart();
        this._arrows._spawnRangeX = new cVector2(this._player._position.x - 40, this._player._position.x + this._player._skySurfer.getWidth(0) + 5);
        this._arrows.restart();
        this.d = 3;
        this._trickBar.restart(this.d);
        this._time.reset(true);
        this._scene.restart();
        ((cEvent)this).a.reset();
        this._tempScore.reset();
        this._renderHUD = true;
        this.c = 0;
    }

    public void bankFailed() {
        --this.d;
        if (this.d < 3) {
            this.d = 3;
        }
        this._tempScore._score = 0;
        this._trickBar.restart(this.d);
        this.c = 1;
        this._player.startStand();
    }

    public void bankSucceeded() {
        ++this.d;
        if (this._trickBar._gotOneWrong) {
            this._tempScore._score = 0;
        }
        if (this._tempScore._score != 0) {
            this._tempScore._score += this._trickBar._drainTime / 4;
        }
        this._tempScore.bank();
        this._trickBar.restart(this.d);
        this.c = 1;
        this._player.startStand();
    }

    public void update(int n) {
        int n2 = n;
        cSkySurfingEngine cSkySurfingEngine2 = this;
        int n3 = crlCanvas.mPad;
        switch (cSkySurfingEngine2.c) {
            case 0: {
                if (n3 != 16 || crlCanvas.mPadDB != 1) break;
                crlCanvas.mPadDB = 0;
                cSkySurfingEngine2.c = 1;
                cSkySurfingEngine2._time.start();
                break;
            }
            case 1: {
                cSkySurfingEngine2._arrows.update(n2);
                cSkySurfingEngine2._arrows.updateInput(n2);
            }
        }
        n2 = n;
        cSkySurfingEngine2 = this;
        if (cSkySurfingEngine2.c != 0) {
            cSkySurfingEngine2._trickBar.update(n2);
            cSkySurfingEngine2._player.update(n2);
            cSkySurfingEngine2._tempScore._x = cSkySurfingEngine2._player._position.x - cCamera._p.x;
            cSkySurfingEngine2._tempScore._y = cSkySurfingEngine2._player._position.y - cCamera._p.y - cSkySurfingEngine2._player._skySurfer.getHeight(0) - cGlobals._fontScore.getHeight() - 40;
            cSkySurfingEngine2._arrows._worldHitLineY = cSkySurfingEngine2._player._position.y;
            cSkySurfingEngine2._time.update(n2);
            if (!cSkySurfingEngine2._time._timerRunning) {
                cSkySurfingEngine2.a(0);
            }
        }
        n2 = n;
        cSkySurfingEngine2 = this;
        cSkySurfingEngine2._scene.update(n2);
        cSkySurfingEngine2._tempScore.update(n2);
        cCamera._p.y = cSkySurfingEngine2._player._position.y - 30 - cEvent.b / 2;
        cCamera._p.x = cSkySurfingEngine2._player._position.x - cEvent.a / 2;
    }

    public cTime getTime() {
        return this._time;
    }

    public void arrowHit(cDirArrow cDirArrow2) {
        this._tempScore._score += _arrowHitScores[cDirArrow2._hitState];
        if (cDirArrow2._hitState != 0) {
            cDirArrow2._visible = false;
            this._trickBar.addArrow(cDirArrow2._position.x - cCamera._p.x, cDirArrow2._position.y - cCamera._p.y, cDirArrow2._direction, cDirArrow2._hitState);
            if (this._trickBar._state == 1) {
                this.c = 2;
                return;
            }
        } else {
            this._tempScore._score -= _arrowHitScores[3];
            if (this._tempScore._score < 0) {
                this._tempScore._score = 0;
            }
            this._trickBar.removeArrow();
        }
    }

    public void render(Graphics graphics) {
        ((cSkySurfingEngine)((Object)crlFont2))._scene.renderBehind(graphics);
        ((cSkySurfingEngine)((Object)crlFont2))._player.render(graphics);
        ((cSkySurfingEngine)((Object)crlFont2))._scene.renderInfront(graphics);
        if (((cSkySurfingEngine)((Object)crlFont2)).c == 1) {
            ((cSkySurfingEngine)((Object)crlFont2))._arrows.render(graphics);
        }
        if (((cEvent)((Object)crlFont2))._renderHUD) {
            ((cSkySurfingEngine)((Object)crlFont2))._time.render(graphics);
            ((cSkySurfingEngine)((Object)crlFont2))._trickBar.render(graphics);
            ((cEvent)((Object)crlFont2)).a.render(graphics);
            ((cEvent)((Object)crlFont2))._tempScore.render(graphics);
            switch (((cSkySurfingEngine)((Object)crlFont2)).c) {
                case 0: {
                    crlFont crlFont2 = cGlobals._fontSmall;
                    cUtils.drawCentredString(graphics, crlFont2, crlResourceManager.mLocaleText[23], cEvent.a / 2, cEvent.b / 2, true);
                }
            }
        }
    }

    public void unloadResources() {
        crlCanvas.gResourceManager.destroyPack(a);
        crlCanvas.gResourceManager.destroyPack(_audioResources);
        cGlobals._audioManager.unload();
        _instance = null;
    }

    static {
        _arrowHitScores = new int[]{0, 20, 50, 100};
    }
}

