/*
 * Decompiled with CFR 0.152.
 */
package CGX.Events.RollerBlading;

import CGX.Events.RollerBlading.cBladeTrack;
import CGX.Events.RollerBlading.cRollerBlader;
import CGX.Events.RollerBlading.cScene;
import CGX.Events.cBalanceBar;
import CGX.Events.cEvent;
import CGX.Events.cScore;
import CGX.Events.cTempScore;
import CGX.Events.cTime;
import CGX.Usefuls.cCamera;
import CGX.Usefuls.cGlobals;
import CGX.Usefuls.cUtils;
import CGX.Usefuls.cVector2;
import Coral.Graphics2D.crlFont;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import Coral.crlCanvas;
import javax.microedition.lcdui.Graphics;

public class cRollerBladingEngine
extends cEvent {
    private static final long[] a = new long[]{3514074190677L, 3450102741239L, 3646002695239L, 3709562816575L, 1162634490814L, 3771124675679L, 3578390383583L, 1523799279894L, 1582723063436L};
    public static final long[] _audioResources = new long[]{77417924077L};
    public static final int[] _audioTypes = new int[]{1};
    public static cRollerBladingEngine _instance;
    public int _scoreMultiplier;
    private int c;
    public cRollerBlader _player;
    public cBladeTrack _track;
    public cTime _time;
    public cScene _scene;
    public cBalanceBar _balanceBar;

    public cRollerBladingEngine(int n) {
        super(n);
        _instance = this;
        this._player = new cRollerBlader();
        this._track = new cBladeTrack();
    }

    public void loadResources() {
        crlCanvas.gResourceManager.insertPack(a);
        crlCanvas.gResourceManager.insertPack(_audioResources);
    }

    public void init() {
        this._player.init();
        this._track.init();
        cCamera._p = new cVector2();
        this._scene = new cScene();
        ((cEvent)this).a = new cScore(cGlobals._fontScore);
        this._tempScore = new cTempScore(cGlobals._fontScore, ((cEvent)this).a);
        this._tempScore._audioIndex = 0;
        this._balanceBar = new cBalanceBar(this._tempScore);
        this._tempScore._bankAnimTime = 1000;
        this._time = new cTime();
        this._time._levelTimeLimit = 90000;
        this._time.reset(true);
        this._balanceBar.init();
        this._balanceBar._x = cEvent.a / 2 - this._balanceBar._width / 2;
        this._balanceBar._y = cEvent.b / 4;
        cGlobals._audioManager.open(_audioResources.length);
        cGlobals._audioManager.load(crlCanvas.gResourceManager, _audioResources, _audioTypes);
        this.restart();
        this.update(0);
    }

    public void restart() {
        this._player.restart();
        this._time.reset(true);
        this._scene.restart();
        ((cEvent)this).a.reset();
        this._tempScore.reset();
        this._renderHUD = true;
        this.c = 0;
        this._scoreMultiplier = 1;
        this._balanceBar.restart();
    }

    public void update(int n) {
        cRollerBladingEngine cRollerBladingEngine2 = this;
        int n2 = crlCanvas.mPad;
        switch (cRollerBladingEngine2.c) {
            case 0: {
                if (n2 != 16 || crlCanvas.mPadDB != 1) break;
                crlCanvas.mPadDB = 0;
                cRollerBladingEngine2.c = 1;
                cRollerBladingEngine2._time.start();
            }
        }
        n2 = n;
        cRollerBladingEngine2 = this;
        if (cRollerBladingEngine2.c != 0) {
            cRollerBladingEngine2._player.update(n2);
            cRollerBladingEngine2._time.update(n2);
            if (!cRollerBladingEngine2._time._timerRunning) {
                cRollerBladingEngine2.a(0);
            }
        }
        if (cRollerBladingEngine2._player._state == 2) {
            cRollerBladingEngine2._balanceBar.update(n2);
        }
        cCamera._p.x = cRollerBladingEngine2._player._position.x - cEvent.a / 4;
        cCamera._p.y = cRollerBladingEngine2._player._position.y - cEvent.b + cEvent.b / 4;
        cRollerBladingEngine2._tempScore._x = cRollerBladingEngine2._player._position.x - cCamera._p.x - cRollerBladingEngine2._player._blader.getWidth(0);
        cRollerBladingEngine2._tempScore._y = cRollerBladingEngine2._player._position.y - cCamera._p.y - cRollerBladingEngine2._player._blader.getHeight(0) - cGlobals._fontScore.getHeight() - 40;
        n2 = n;
        cRollerBladingEngine2 = this;
        cRollerBladingEngine2._track.update(n2);
        cRollerBladingEngine2._scene.update(n2);
        cRollerBladingEngine2._tempScore.update(n2);
        if (cRollerBladingEngine2._track.passedEndPost()) {
            cRollerBladingEngine2.a(0);
        }
    }

    public void beginGrind() {
        this._balanceBar.restart();
    }

    public void comboGot() {
        this._tempScore._score += 20 * this._scoreMultiplier;
        ++this._scoreMultiplier;
    }

    public void comboBank() {
        this._tempScore.bank();
        this._scoreMultiplier = 1;
    }

    public void comboFailed() {
        this._scoreMultiplier = 1;
        this._tempScore._score = 0;
    }

    public cTime getTime() {
        return this._time;
    }

    public void render(Graphics graphics) {
        this._scene.render(graphics);
        this._track.render(graphics);
        this._player.render(graphics);
        if (this._renderHUD) {
            Object object;
            switch (this.c) {
                case 0: {
                    object = cGlobals._fontSmall;
                    cUtils.drawCentredString(graphics, (crlFont)object, crlResourceManager.mLocaleText[23], cEvent.a / 2, cEvent.b / 2, true);
                }
            }
            if (this._scoreMultiplier != 1) {
                object = new crlString("X" + this._scoreMultiplier);
                cGlobals._fontScore.print(graphics, this._tempScore._x, this._tempScore._y + cGlobals._fontScore.getHeight() + 2, (crlString)object);
            }
            if (this._player._state == 2) {
                this._balanceBar.render(graphics);
            }
            this._time.render(graphics);
            ((cEvent)this).a.render(graphics);
            this._tempScore.render(graphics);
        }
    }

    public void unloadResources() {
        crlCanvas.gResourceManager.destroyPack(a);
        crlCanvas.gResourceManager.destroyPack(_audioResources);
        cGlobals._audioManager.unload();
        _instance = null;
    }
}

