/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Ball
implements DATA {
    long x;
    long y;
    long dx;
    long dy;
    int color;
    int CNT = 50;
    boolean active = true;
    boolean animated = false;
    boolean moving = false;
    boolean too_many_contr_pts = false;
    boolean standing = false;
    int frame = 0;
    int last_hit_ball = -1;
    boolean hit_board = false;
    int lose = -1;
    int idx;
    int cur_contr_pt = 0;
    BallInfo[] time_tbl = new BallInfo[this.CNT];
    int old_frame = 0;

    Ball(long a_x, long a_y, long a_dx, long a_dy, int a_idx) {
        this.x = a_x - (long)a_idx;
        this.y = a_y - (long)a_idx;
        this.dx = a_dx;
        this.dy = a_dy;
        this.idx = a_idx;
        for (int i = 0; i < this.CNT; ++i) {
            this.time_tbl[i] = new BallInfo();
        }
        this.time_tbl[0].x = this.x;
        this.time_tbl[0].y = this.y;
        this.time_tbl[0].dx = this.dx;
        this.time_tbl[0].dy = this.dy;
        this.time_tbl[0].t = 0L;
    }

    public void render_shadow(Graphics a_g) {
        if (this.active) {
            a_g.setClip((int)((this.x >> 7) - 7L + 14L), (int)((this.y >> 7) - 7L + 15L + 6L), 15, 4);
            a_g.drawImage(C._instance.img_ball_shadow, (int)((this.x >> 7) - 7L + 14L), (int)((this.y >> 7) - 7L + 15L + 6L), 0);
        }
    }

    public void render_shadow_at_pt(long a_x, long a_y, Graphics a_g) {
        if (this.active) {
            a_g.setClip((int)((a_x >> 7) - 7L + 14L), (int)((a_y >> 7) - 7L + 15L + 6L), 15, 4);
            a_g.drawImage(C._instance.img_ball_shadow, (int)((a_x >> 7) - 7L + 14L), (int)((a_y >> 7) - 7L + 15L + 6L), 0);
        }
    }

    public void render(Graphics a_g) {
        if (!this.animated) {
            a_g.setClip((int)((this.x >> 7) - 7L + 14L), (int)((this.y >> 7) - 7L + 15L), 15, 15);
            a_g.drawImage(C._instance.balls_img, (int)((this.x >> 7) - 7L + 14L), (int)((this.y >> 7) - (long)(this.idx * 14) - 7L + 15L), 0);
        } else {
            a_g.setClip((int)(this.x >> 7) - 7 + 14, (int)(this.y >> 7) - 7 + 15, 14, 15);
            a_g.drawImage(C._instance.balls_matrix_img, (int)(this.x >> 7) - 7 - this.idx * 14 + 14, (int)(this.y >> 7) - 7 - this.frame / 3 * 14 + 15, 0);
        }
    }

    public void render_at_pt(long a_x, long a_y, Graphics a_g) {
        if (!this.animated) {
            a_g.setClip((int)((a_x >> 7) - 7L + 14L), (int)((a_y >> 7) - 7L + 15L), 15, 15);
            a_g.drawImage(C._instance.balls_img, (int)((a_x >> 7) - 7L + 14L), (int)((a_y >> 7) - (long)(this.idx * 14) - 7L + 15L), 0);
        } else {
            a_g.setClip((int)((a_x >> 7) - 7L + 14L), (int)((a_y >> 7) - 7L + 15L), 14, 15);
            a_g.drawImage(C._instance.balls_matrix_img, (int)((a_x >> 7) - 7L - (long)(this.idx * 14) + 14L), (int)((a_y >> 7) - 7L - (long)((this.old_frame != this.frame ? 5 : this.frame / 3) * 14) + 15L), 0);
            this.old_frame = this.frame;
        }
    }

    public void update_at_time(long time) {
        try {
            int i;
            for (i = 1; time > this.time_tbl[i].t && i < this.cur_contr_pt; ++i) {
            }
            if (this.time_tbl[--i].lose_point) {
                this.active = false;
            } else {
                long new_x = this.time_tbl[i].x + this.time_tbl[i].dx * (time - this.time_tbl[i].t) / 1000L;
                long new_y = this.time_tbl[i].y + this.time_tbl[i].dy * (time - this.time_tbl[i].t) / 1000L;
                if (this.animated && (this.x - new_x) * (this.x - new_x) + (this.y - new_y) * (this.y - new_y) >= 128L) {
                    this.frame = this.frame < 15 ? ++this.frame : 0;
                }
                this.x = new_x;
                this.y = new_y;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void update_at_delta_time(long t) {
        if (!this.standing) {
            this.x += this.dx * t / 1000L;
            this.y += this.dy * t / 1000L;
        }
    }

    public void add_control_pt(long time, boolean last_pt) {
        if (!last_pt) {
            if (!this.standing) {
                ++this.cur_contr_pt;
                this.time_tbl[this.cur_contr_pt].t = time;
                this.time_tbl[this.cur_contr_pt].x = this.x;
                this.time_tbl[this.cur_contr_pt].y = this.y;
                this.time_tbl[this.cur_contr_pt].dx = this.dx;
                this.time_tbl[this.cur_contr_pt].dy = this.dy;
                this.time_tbl[this.cur_contr_pt].lose_point = this.lose >= 0;
            }
            if (this.cur_contr_pt >= this.CNT - 6) {
                this.too_many_contr_pts = true;
            }
        } else {
            ++this.cur_contr_pt;
            this.time_tbl[this.cur_contr_pt].t = time;
            this.time_tbl[this.cur_contr_pt].x = this.x;
            this.time_tbl[this.cur_contr_pt].y = this.y;
            this.time_tbl[this.cur_contr_pt].dx = this.dx;
            this.time_tbl[this.cur_contr_pt].dy = this.dy;
            this.time_tbl[this.cur_contr_pt].lose_point = this.lose >= 0;
        }
    }
}

