/*
 * Decompiled with CFR 0.152.
 */
package digeebird;

public class Footboard {
    private int mX;
    private int mVirtualY;
    private int mWidth;
    private int mHeith;
    private int mType;
    private int mFrameAmount;
    private int mFrameDelay;
    private int mFrameCounter;
    private int mUnstableBoardDelay;

    public int getVirtualY() {
        return this.mVirtualY;
    }

    public int getMinX() {
        return this.mX;
    }

    public int getMaxX() {
        return this.mX + this.mWidth;
    }

    public int getMinY() {
        return this.mVirtualY / 5;
    }

    public int getMaxY() {
        return this.mVirtualY / 5 + this.mHeith;
    }

    public int getType() {
        return this.mType;
    }

    public void addY(int virtualPixel) {
        this.mVirtualY += virtualPixel;
    }

    public boolean isBoardBreak() {
        return --this.mUnstableBoardDelay == 0;
    }

    public boolean isMarked() {
        return this.mUnstableBoardDelay != 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextFrame() {
        try {
            int n = this.mFrameCounter / this.mFrameDelay;
            return n;
        }
        finally {
            ++this.mFrameCounter;
            if (this.mFrameCounter == this.mFrameAmount * this.mFrameDelay) {
                this.mFrameCounter = 0;
            }
        }
    }

    public Footboard(int x, int y, int width, int heith, int type, int frameAmount, int frameDelay) {
        this.mX = x;
        this.mVirtualY = y * 5;
        this.mWidth = width;
        this.mHeith = heith;
        this.mType = type;
        this.mFrameAmount = frameAmount;
        this.mFrameDelay = frameDelay;
        this.mUnstableBoardDelay = 5;
        this.mFrameCounter = 0;
    }
}

