/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

class GameManager
implements Runnable {
    static final int MILLIS_PER_TICK = 100;
    static final int MAX_INV = 16;
    static final int STAND_INV = 8;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int GM_UP = 1;
    static final int GM_DOWN = 2;
    static final int GM_LEFT = 3;
    static final int GM_RIGHT = 4;
    static final int GM_FIRE = 5;
    static final int GM_LSIDE = 6;
    static final int GM_RSIDE = 7;
    private final OneMIDlet midlet;
    private final Dictionary dict;
    public final GameEffects gameEffects;
    private final Canvas canvas;
    private Image invgfx;
    private Image textgfx;
    private Image menugfx;
    public View view;
    private int ticks = 0;
    public int status;
    public int tempStatus;
    private int option;
    public boolean[] options = new boolean[5];
    private int gameWidth;
    private int gameHeight;
    private boolean redrawBG;
    private boolean availBG;
    public byte[] invItem = new byte[16];
    private int[][] invSquareXY = new int[16][2];
    private int invSquareSize;
    private int[] invLineFromX = new int[8];
    private int[] invLineFromY = new int[8];
    private int[] invLineToX = new int[8];
    private int[] invLineToY = new int[8];
    private int itemX;
    private int itemY;
    private int itemCurrent;
    private int itemSelect;
    private volatile boolean isPaused = false;
    private volatile Thread animationThread = null;
    private static final Font GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    private static final int fontHeight = GAME_FONT.getHeight();
    public byte[] gameAction = new byte[32];
    public int gameActionCount;
    public int gameActionCurrent;
    public final int GM_MENU;
    public final int GM_NEW_GAME;
    public final int GM_PLAY;
    public final int GM_INV;
    public final int GM_DEAD;
    public final int GM_NEW_LEVEL;
    public final int GM_EOL;
    public final int GM_MAP;
    public final int GM_CONT;
    private boolean hasBeenShown = false;
    public int xEnd;
    public int yEnd;
    public int xMap;
    public int yMap;
    public int direction;
    public int HP;
    public int maxHP;
    public int iDex;
    public int iAtt;
    public int iDef;
    public byte gameLevel;
    public int showText;
    public int textTimer;
    public boolean clearText;
    public boolean showItem;
    public boolean clearItem;
    public boolean clrInvTxt;
    public boolean showHP;
    public int iHit;
    public int iRecovery;
    public int[][] showBlood = new int[4][2];
    public int compassDirec;
    public int rowBorder;
    public int colBorder;
    public byte[] itemDsc = new byte[]{1, 2, 3, 0, 0, 0, 0, 0, 4, 5, 6, 7, 0, 0, 0, 0, 8, 9, 10, 0, 0, 0, 0, 0, 11, 12, 13, 0, 0, 0, 0, 0, 14, 15, 16, 17, 0, 0, 0, 0, 18, 19, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, 0, 0, 0, 0, 0, 23, 24, 25, 26, 27, 28, 29, 0};
    public byte[] bStory;
    public boolean bShowStory;
    public boolean bLoadQuik;
    public boolean bLoadGame;

    GameManager(OneMIDlet oneMIDlet, Dictionary dictionary, GameEffects gameEffects, Canvas canvas) {
        this.GM_MENU = 0;
        this.GM_NEW_GAME = 1;
        this.GM_PLAY = 2;
        this.GM_INV = 3;
        this.GM_DEAD = 4;
        this.GM_NEW_LEVEL = 5;
        this.GM_EOL = 6;
        this.GM_MAP = 7;
        this.GM_CONT = 8;
        this.midlet = oneMIDlet;
        this.dict = dictionary;
        this.canvas = canvas;
        this.gameEffects = gameEffects;
        this.gameWidth = this.canvas.getWidth();
        this.gameHeight = this.canvas.getHeight();
        if (this.gameHeight == 65) {
            this.rowBorder = 0;
            this.colBorder = 0;
            this.itemX = 0;
            this.itemY = this.gameHeight - 12;
            this.availBG = false;
        } else {
            this.rowBorder = 4;
            this.colBorder = 4;
            this.itemX = 96;
            this.itemY = 108;
            this.availBG = true;
        }
        this.invSquareSize = 16;
        int n = this.availBG ? 2 : 0;
        int n2 = this.availBG ? 0 : 18;
        int n3 = this.availBG ? 0 : 12;
        int n4 = 0;
        while (n4 < 4) {
            this.invSquareXY[n4 << 1][0] = this.colBorder + 4;
            this.invSquareXY[n4 << 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 1][0] = this.colBorder + 4 + (this.invSquareSize + n);
            this.invSquareXY[(n4 << 1) + 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 8][0] = this.colBorder + 10 + (this.invSquareSize + n << 1);
            this.invSquareXY[(n4 << 1) + 8][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 9][0] = this.availBG ? 82 : 62;
            int[] nArray = this.invSquareXY[(n4 << 1) + 9];
            nArray[0] = nArray[0] + (this.colBorder + (this.invSquareSize + n));
            this.invSquareXY[(n4 << 1) + 9][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invLineFromX[n4 << 1] = this.invSquareXY[(n4 << 1) + 8][0] + this.invSquareSize;
            this.invLineFromY[n4 << 1] = this.invSquareXY[(n4 << 1) + 8][1] + (this.invSquareSize >> 1);
            this.invLineFromX[(n4 << 1) + 1] = this.invSquareXY[(n4 << 1) + 9][0] - 1;
            this.invLineFromY[(n4 << 1) + 1] = this.invSquareXY[(n4 << 1) + 9][1] + (this.invSquareSize >> 1);
            ++n4;
        }
        this.invLineToX[0] = 85 - n2;
        this.invLineToY[0] = 20 - n3;
        this.invLineToX[1] = 0;
        this.invLineToY[1] = 0;
        this.invLineToX[2] = 85 - n2;
        this.invLineToY[2] = 32 - n3;
        this.invLineToX[3] = 94 - n2;
        this.invLineToY[3] = 43 - n3;
        this.invLineToX[4] = 78 - n2;
        this.invLineToY[4] = 44 - n3;
        this.invLineToX[5] = 112 - n2;
        this.invLineToY[5] = 42 - n3;
        this.invLineFromX[5] = 112;
        this.invLineFromY[5] = 43;
        this.invLineToX[6] = 58 - n2;
        this.invLineToY[6] = 61 - n3;
        this.invLineFromX[6] = 58;
        this.invLineFromY[6] = 60;
        this.invLineToX[7] = 85 - n2;
        this.invLineToY[7] = 64 - n3;
        if (!this.availBG) {
            this.rowBorder = -5;
        }
        this.init();
    }

    void init() {
        this.animationThread = null;
        this.isPaused = false;
        this.hasBeenShown = false;
        this.status = 0;
        this.gameEffects.lightsOn();
        this.textgfx = this.gameEffects.getGfx("/t.png");
        int n = 0;
        while (n < this.options.length) {
            this.options[n] = false;
            ++n;
        }
        this.options[1] = true;
        this.options[4] = true;
        try {
            StringBuffer stringBuffer = new StringBuffer("DUNSET");
            this.options[0] = Settings.getValue(Settings.GM_CONT, stringBuffer);
            this.options[2] = Settings.getValue(Settings.GM_LOAD, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {
            throw new IllegalArgumentException("EC:0x04");
        }
        this.option = this.options[0] ? 0 : 1;
        this.bLoadQuik = false;
        this.bLoadGame = false;
    }

    void setupView() {
        byte by = (byte)(this.gameLevel + 1 >> 1);
        if (this.view == null) {
            int n = 120;
            int n2 = 80;
            if (this.gameHeight == 65) {
                n = 96;
                n2 = 70;
            }
            this.view = new View(this, n, n2, this.colBorder, this.rowBorder);
            this.view.initTile();
            this.invgfx = this.gameEffects.getGfx("/i.png");
            int n3 = 0;
            Image image = this.gameEffects.getGfx("/1.png");
            short[] sArray = new short[64 * 64];
            this.view.convertImage(0, image, sArray, 0 << 6);
            image = null;
            if (this.gameLevel <= 3) {
                image = this.gameEffects.getGfx("/1.png");
            } else {
                image = this.gameEffects.getGfx("/2.png");
                n3 = 1;
                this.view.bigMon = true;
            }
            int n4 = 1;
            while (n4 < 4) {
                this.view.convertImage(n4, image, sArray, n4 - n3 << 6);
                ++n4;
            }
            this.view.setColorDepth();
            this.view.init();
        }
        this.view.initLevel(by);
    }

    public void changeCont(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("DUNSET");
        this.option = n;
        this.options[0] = bl;
        try {
            Settings.setValue(Settings.GM_CONT, bl, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {}
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                long l;
                if (thread != this.animationThread) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (!this.isPaused) {
                    if (this.canvas.isShown()) {
                        if (!this.hasBeenShown) {
                            this.hasBeenShown = true;
                        }
                        this.tick();
                        this.gameEffects.lightsOn();
                    } else if (this.hasBeenShown) {
                        this.pause();
                    }
                }
                if (this.canvas.isShown()) {
                    this.canvas.repaint(0, 0, this.gameWidth, this.gameHeight);
                    this.canvas.serviceRepaints();
                }
                if ((l = System.currentTimeMillis() - l2) < 100L) {
                    GameManager gameManager = this;
                    synchronized (gameManager) {
                        this.wait(100L - l);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void start(boolean bl) {
        this.animationThread = new Thread(this);
        this.animationThread.start();
        if (bl) {
            this.pause();
        } else {
            this.resume();
        }
        this.redrawAll();
    }

    public synchronized void stop() {
        this.animationThread = null;
        this.gameEffects.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = true;
        }
        if (this.status != 0) {
            this.options[0] = true;
            this.option = 0;
        }
        this.gameEffects.pause();
        this.redrawAll();
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }

    void redrawAll() {
    }

    void closePressed() {
        if (this.status != 6 && this.status != 5 && this.status != 4) {
            if (!this.isPaused) {
                this.pause();
                this.changeCont(0, true);
            } else {
                if (this.option == 0 && this.status == 0) {
                    this.bLoadQuik = true;
                } else if (this.option == 1) {
                    this.status = 1;
                    this.view = null;
                    this.options[3] = false;
                } else if (this.option == 2) {
                    this.bLoadGame = true;
                    this.gameActionCurrent = this.gameActionCount;
                    this.status = 0;
                } else if (this.option == 3) {
                    Settings.storeGame(false, this, this.view);
                } else if (this.option == 4) {
                    if (this.status == 8) {
                        this.status = this.tempStatus;
                        this.ticks = 0;
                        this.gameActionCurrent = this.gameActionCount;
                    } else {
                        this.tempStatus = this.status;
                        this.status = 8;
                    }
                }
                this.resume();
            }
        }
    }

    public void keyReleased(int n) {
        this.canvas.getGameAction(n);
    }

    public void keyPressed(int n) {
        block35: {
            block36: {
                if (!this.isPaused || !this.canvas.isShown()) break block36;
                switch (this.canvas.getGameAction(n)) {
                    case 6: {
                        ++this.option;
                        int n2 = 0;
                        while (n2 < this.options.length) {
                            if (this.option < 0) {
                                this.option = this.options.length - 1;
                            }
                            if (this.option >= this.options.length) {
                                this.option = 0;
                            }
                            if (!this.options[this.option]) {
                                ++this.option;
                                ++n2;
                                continue;
                            }
                            break block35;
                        }
                        break block35;
                    }
                    case 1: {
                        --this.option;
                        int n3 = 0;
                        while (n3 < this.options.length) {
                            if (this.option < 0) {
                                this.option = this.options.length - 1;
                            }
                            if (this.option >= this.options.length) {
                                this.option = 0;
                            }
                            if (!this.options[this.option]) {
                                --this.option;
                                ++n3;
                                continue;
                            }
                            break block35;
                        }
                        break block35;
                    }
                    case 8: {
                        if (this.option == 0 && this.status == 0) {
                            this.bLoadQuik = true;
                        } else if (this.option == 1) {
                            this.status = 1;
                            this.view = null;
                            this.options[3] = false;
                        } else if (this.option == 2) {
                            this.bLoadGame = true;
                            this.bLoadQuik = false;
                            this.gameActionCurrent = this.gameActionCount;
                            this.status = 0;
                        } else if (this.option == 3) {
                            Settings.storeGame(false, this, this.view);
                        }
                        if (this.option == 4) {
                            if (this.status == 8) {
                                this.status = this.tempStatus;
                                this.ticks = 0;
                                this.gameActionCurrent = this.gameActionCount;
                            } else {
                                this.tempStatus = this.status;
                                this.status = 8;
                            }
                        }
                        this.resume();
                    }
                }
                break block35;
            }
            switch (this.canvas.getGameAction(n)) {
                case 1: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 1;
                    break;
                }
                case 6: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 2;
                    break;
                }
                case 2: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 3;
                    break;
                }
                case 5: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 4;
                    break;
                }
                case 8: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 5;
                    break;
                }
                case 9: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 6;
                    break;
                }
                case 10: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 7;
                    break;
                }
                case 11: {
                    if (this.status == 2) {
                        this.itemSelect = -1;
                        this.itemCurrent = 0;
                        this.status = 3;
                        break;
                    }
                    if (this.status == 3) {
                        this.status = 7;
                        this.ticks = 0;
                        this.gameActionCount = this.gameActionCurrent;
                        break;
                    }
                    if (this.status != 7) break;
                    this.status = 2;
                    this.ticks = 0;
                    this.gameActionCount = this.gameActionCurrent;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = false;
        }
        this.gameEffects.resume();
    }

    private void tick() {
        switch (this.status) {
            case 0: {
                this.view = null;
                this.invgfx = null;
                if (this.menugfx == null && !this.bLoadQuik && !this.bLoadGame) {
                    this.menugfx = this.gameEffects.getGfx("/f.png");
                    this.pause();
                    break;
                }
                this.status = 1;
                this.options[3] = false;
                break;
            }
            case 1: {
                this.menugfx = null;
                this.gameLevel = 1;
                int n = 0;
                while (n < 16) {
                    this.invItem[n] = 0;
                    ++n;
                }
                this.HP = 32;
                this.maxHP = 63;
                this.iDex = 10;
                this.iDef = 5;
                this.iAtt = 6;
                this.status = 5;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.ticks = 0;
                break;
            }
            case 5: {
                if (this.gameActionCount != this.gameActionCurrent && this.ticks != 0) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        --this.ticks;
                        if (this.ticks < 1) {
                            this.ticks = 1;
                        }
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        ++this.ticks;
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        this.ticks = 10;
                        this.bShowStory = false;
                    }
                }
                if (!(this.ticks != 0 && !this.bShowStory || this.bLoadQuik || this.bLoadGame)) {
                    if (this.ticks != 0) break;
                    this.bShowStory = true;
                    ++this.ticks;
                    int n = 0;
                    try {
                        this.showItem = true;
                        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(this.gameLevel).append(".txt")))));
                        n = 370;
                        this.bStory = new byte[n];
                        dataInputStream.readFully(this.bStory);
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (Exception exception) {
                        this.bStory = new byte[n];
                        this.ticks = this.gameHeight << 2;
                        this.bShowStory = false;
                        this.showItem = false;
                    }
                    break;
                }
                if (this.gameLevel == 6) {
                    this.gameActionCurrent = this.gameActionCount;
                    this.status = 0;
                    break;
                }
                if (this.bLoadQuik || this.bLoadGame) {
                    Settings.getGame(this.bLoadQuik, this, null, false);
                }
                this.bStory = null;
                this.setupView();
                int n = 0;
                while (n < 4) {
                    this.showBlood[n][0] = 0;
                    this.showBlood[n][1] = 0;
                    ++n;
                }
                if ((this.bLoadQuik || this.bLoadGame) && this.status != 6) {
                    Settings.getGame(this.bLoadQuik, this, this.view, true);
                } else {
                    if (this.gameLevel != 1 || this.status == 6) {
                        n = 0;
                        while (n < 16) {
                            if (this.invItem[n] != 0) {
                                this.view.itemType[48 - 16 + n] = this.invItem[n];
                                this.view.itemX[48 - 16 + n] = 65;
                                this.invItem[n] = (byte)(48 - 16 + n + 1);
                            }
                            ++n;
                        }
                    }
                    this.iHit = -1;
                    this.iRecovery = 0;
                }
                this.view.createMap((this.bLoadQuik || this.bLoadGame) && this.status != 6);
                this.bLoadQuik = false;
                this.bLoadGame = false;
                this.itemCurrent = 0;
                this.itemSelect = -1;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.redrawBG = this.availBG;
                this.showHP = true;
                this.showText = 0;
                this.textTimer = 0;
                this.showItem = false;
                this.compassDirec = this.direction + 1 & 3;
                this.options[3] = true;
                this.status = 2;
                break;
            }
            case 6: {
                ++this.ticks;
                if (this.ticks > 30 || this.gameActionCurrent != this.gameActionCount && this.ticks > 20) {
                    this.gameLevel = (byte)(this.gameLevel + 1);
                    this.view = null;
                    this.status = 5;
                    this.gameActionCount = 0;
                    this.gameActionCurrent = 0;
                    this.ticks = 0;
                    break;
                }
                this.gameActionCurrent = this.gameActionCount;
                break;
            }
            case 2: {
                int n = this.xMap;
                int n2 = this.yMap;
                int n3 = this.xMap;
                int n4 = this.yMap;
                if (this.iRecovery > 0) {
                    --this.iRecovery;
                }
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        if (this.direction == 0) {
                            --n4;
                        } else if (this.direction == 1) {
                            ++n3;
                        } else if (this.direction == 2) {
                            ++n4;
                        } else if (this.direction == 3) {
                            --n3;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        if (this.direction == 0) {
                            ++n4;
                        } else if (this.direction == 1) {
                            --n3;
                        } else if (this.direction == 2) {
                            --n4;
                        } else if (this.direction == 3) {
                            ++n3;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 6) {
                        if (this.direction == 0) {
                            --n3;
                        } else if (this.direction == 1) {
                            --n4;
                        } else if (this.direction == 2) {
                            ++n3;
                        } else if (this.direction == 3) {
                            ++n4;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 7) {
                        if (this.direction == 0) {
                            ++n3;
                        } else if (this.direction == 1) {
                            ++n4;
                        } else if (this.direction == 2) {
                            --n3;
                        } else if (this.direction == 3) {
                            --n4;
                        }
                    }
                    if (!(this.xMap == n3 && this.yMap == n4 || this.view.moveCollision(n3, n4))) {
                        this.xMap = n3;
                        this.yMap = n4;
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 3) {
                        --this.direction;
                        if (this.direction < 0) {
                            this.direction = 3;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 4) {
                        ++this.direction;
                        if (this.direction > 3) {
                            this.direction = 0;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        n3 = this.xMap;
                        n4 = this.yMap;
                        if (this.direction == 0) {
                            --n4;
                        } else if (this.direction == 1) {
                            ++n3;
                        } else if (this.direction == 2) {
                            ++n4;
                        } else if (this.direction == 3) {
                            --n3;
                        }
                        int n5 = this.iRecovery != 0 ? 0 : this.view.attackMon(n3, n4, this.iAtt, this.iDex);
                        if (n5 == -1) {
                            if (!this.view.doorOpenClose(n3, n4)) {
                                this.showText = this.view.checkSpecial(this.xMap, this.yMap);
                                if (this.showText != 0) {
                                    this.textTimer = 30;
                                }
                                this.showItem = (this.view.mapItem[this.xMap][this.yMap] & 1) != 0;
                            }
                        } else if (this.iRecovery <= 0) {
                            this.iHit = n5;
                            this.iRecovery = this.iDex;
                        }
                    }
                }
                if (this.xMap == this.xEnd && this.yMap == this.yEnd) {
                    this.options[3] = false;
                    this.status = 6;
                    int n6 = 0;
                    while (n6 < 16) {
                        if (this.invItem[n6] != 0) {
                            this.invItem[n6] = this.view.itemType[this.invItem[n6] - 1];
                        }
                        if (this.invItem[n6] == 49) {
                            this.invItem[n6] = 0;
                        }
                        ++n6;
                    }
                    Settings.storeGame(true, this, this.view);
                    this.ticks = 0;
                    break;
                }
                if (this.xMap != n | this.yMap != n2) {
                    this.view.checkMap(n, n2, false);
                    this.showItem = this.view.checkMap(this.xMap, this.yMap, true);
                }
                this.view.doorUpdate();
                this.view.lineOfSite(this.xMap, this.yMap, this.direction);
                this.view.ai();
                break;
            }
            case 3: {
                if (this.gameActionCurrent == this.gameActionCount) break;
                ++this.gameActionCurrent;
                this.gameActionCurrent &= 0x1F;
                if (this.gameAction[this.gameActionCurrent] == 1) {
                    this.itemCurrent = this.itemCurrent == 0 || this.itemCurrent == 1 || this.itemCurrent == 8 || this.itemCurrent == 9 ? (this.itemCurrent += 6) : (this.itemCurrent -= 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 2) {
                    this.itemCurrent = this.itemCurrent == 6 || this.itemCurrent == 7 || this.itemCurrent == 14 || this.itemCurrent == 15 ? (this.itemCurrent -= 6) : (this.itemCurrent += 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 3) {
                    this.itemCurrent = (this.itemCurrent & 9) == 0 ? (this.itemCurrent += 9) : ((this.itemCurrent & 9) == 8 ? (this.itemCurrent -= 7) : --this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] == 4) {
                    this.itemCurrent = (this.itemCurrent & 9) == 1 ? (this.itemCurrent += 7) : ((this.itemCurrent & 9) == 9 ? (this.itemCurrent -= 9) : ++this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] != 5) break;
                if (this.itemSelect == -1) {
                    if (this.itemCurrent == 9) break;
                    this.itemSelect = this.itemCurrent;
                    break;
                }
                if (this.itemSelect == this.itemCurrent) {
                    if (this.invItem[this.itemCurrent] == 0) {
                        this.itemSelect = -1;
                        break;
                    }
                    this.view.dropItem(this.xMap, this.yMap, this.invItem[this.itemCurrent] - 1, true);
                    this.showItem = true;
                    this.invItem[this.itemCurrent] = 0;
                    this.itemSelect = -1;
                    break;
                }
                int n = this.invItem[this.itemSelect] == 0 ? -1 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3;
                int n7 = this.invItem[this.itemCurrent] == 0 ? -1 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3;
                boolean bl = true;
                if (this.itemCurrent >= 8 || this.itemSelect >= 8) {
                    if (n == 0 && this.itemCurrent != 8 && this.itemCurrent >= 8 || n7 == 0 && this.itemSelect != 8 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 1 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n7 == 1 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 2 && this.itemCurrent != 11 && this.itemCurrent >= 8 || n7 == 2 && this.itemSelect != 11 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 3 && this.itemCurrent != 10 && this.itemCurrent >= 8 || n7 == 3 && this.itemSelect != 10 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 4 && this.itemCurrent != 13 && this.itemCurrent != 14 && this.itemCurrent >= 8 || n7 == 4 && this.itemSelect != 13 && this.itemSelect != 14 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 5 && this.itemCurrent != 9 && this.itemCurrent >= 8 || n7 == 5 && this.itemSelect != 9 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 6 || n7 == 6) {
                        bl = false;
                    }
                    if (n == 7 && this.itemCurrent != 15 && this.itemCurrent >= 8 || n7 == 7 && this.itemSelect != 15 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 8 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n7 == 8 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                }
                if (!bl) break;
                if (this.itemCurrent == 9 && n == 5) {
                    if (this.HP < this.maxHP) {
                        this.invItem[this.itemSelect] = 0;
                        this.HP += 10;
                        if (this.HP > this.maxHP) {
                            this.HP = this.maxHP;
                        }
                        this.showHP = true;
                    }
                } else {
                    int n8;
                    int n9;
                    if (n >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8 || n7 >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8) {
                        n9 = this.itemCurrent >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
                        int n10 = n8 = this.itemCurrent >= 8 ? n : n7;
                        if (n8 == 0 || n8 == 7) {
                            this.iDef += this.view.helmet[n9 + n9];
                            this.iDex -= this.view.helmet[n9 + n9 + 1];
                        } else if (n8 == 1) {
                            this.iAtt += this.view.sword[n9 + n9];
                            this.iDex -= this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 2 || n8 == 3) {
                            this.iDef += this.view.sword[n9 + n9];
                            this.iDex -= this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 4) {
                            this.iAtt += this.view.ring[n9 + n9 + n9];
                            this.iDef += this.view.ring[n9 + n9 + n9 + 1];
                            this.iDex -= this.view.ring[n9 + n9 + n9 + 2];
                        }
                    }
                    if (n >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8 || n7 >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8) {
                        n9 = this.itemSelect >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
                        int n11 = n8 = this.itemSelect >= 8 ? n : n7;
                        if (n8 == 0 || n8 == 7) {
                            this.iDef -= this.view.helmet[n9 + n9];
                            this.iDex += this.view.helmet[n9 + n9 + 1];
                        } else if (n8 == 1) {
                            this.iAtt -= this.view.sword[n9 + n9];
                            this.iDex += this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 2 || n8 == 3) {
                            this.iDef -= this.view.sword[n9 + n9];
                            this.iDex += this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 4) {
                            this.iAtt -= this.view.ring[n9 + n9 + n9];
                            this.iDef -= this.view.ring[n9 + n9 + n9 + 1];
                            this.iDex += this.view.ring[n9 + n9 + n9 + 2];
                        }
                    }
                    n9 = this.invItem[this.itemCurrent];
                    this.invItem[this.itemCurrent] = this.invItem[this.itemSelect];
                    this.invItem[this.itemSelect] = (byte)n9;
                }
                this.itemSelect = -1;
                break;
            }
            case 7: {
                ++this.ticks;
                if (this.ticks != 258) break;
                this.ticks = 2;
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.view.xSize / 5) {
                    this.view.itemType[n] = this.ticks < 8 ? (byte)0 : (byte)(this.view.itemType[n] + Util.getRandomInt(0, 2));
                    ++n;
                }
                ++this.ticks;
                if (this.ticks < this.view.ySize) break;
                this.gameActionCurrent = this.gameActionCount;
                this.status = 0;
                break;
            }
            case 8: {
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        ++this.ticks;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        --this.ticks;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        this.status = this.tempStatus;
                    }
                    this.redrawBG = true;
                    this.showHP = true;
                }
                if (this.ticks > 0) {
                    this.ticks = 0;
                }
                if (this.ticks < -5) {
                    this.ticks = -5;
                }
                if (!this.availBG) break;
                this.ticks = 1;
            }
        }
    }

    public void manHit(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            n2 = this.calcHit(n2, n4, this.iDef, 10, false, true);
        }
        this.HP -= n2;
        this.showHP = true;
        if (this.HP < 0) {
            this.HP = 0;
            this.changeCont(1, false);
            this.options[3] = false;
            this.status = 4;
            this.ticks = 0;
        }
        n = n - this.direction & 3;
        n += 2;
        this.showBlood[n &= 3][0] = n2;
        this.showBlood[n][1] = n3;
    }

    public int calcHit(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = bl && this.view.scrolls[2] > 0 ? n - n3 >> 1 : 0;
        n = Util.getRandomInt(n5, n - (n3 = bl2 && this.view.scrolls[1] > 0 ? n3 + (n3 >> 1) : n3) + n5);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics var1_1) {
        block100: {
            block101: {
                var1_1.setFont(GameManager.GAME_FONT);
                if (this.status == 0) {
                    var2_2 = this.availBG == false ? 4 : 16;
                    var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                    var1_1.setColor(0, 0, 0);
                    var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                    if (this.menugfx != null) {
                        var1_1.drawImage(this.menugfx, this.gameWidth >> 1, this.gameHeight - 1, 33);
                    }
                    var1_1.setColor(192, 32, 32);
                    var1_1.drawString("Dark Horde", this.gameWidth >> 1, var2_2, 17);
                } else if (this.status == 6) {
                    var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                    var1_1.setColor(0, 0, 0);
                    if (this.ticks <= 8) {
                        var2_2 = 0;
                        while (var2_2 < this.view.xSize >> 3) {
                            if (this.ticks + (var2_2 << 3) < this.view.xSize) {
                                var1_1.drawLine(this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder, this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder + this.view.ySize - 1);
                            }
                            ++var2_2;
                        }
                    } else {
                        var2_2 = 0;
                        var3_3 = 0;
                        while (var3_3 < this.view.totSecret) {
                            if (this.view.secretFound[var3_3] == 1) {
                                ++var2_2;
                            }
                            ++var3_3;
                        }
                        var4_6 = new StringBuffer("");
                        var4_6.append(var2_2);
                        var4_6.append(this.dict.getString(Dictionary.OF));
                        var4_6.append(this.view.totSecret);
                        this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - 12, var4_6);
                        var4_6 = null;
                        var4_6 = new StringBuffer(this.dict.getString(Dictionary.SECRETS_FOUND));
                        this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - 4, var4_6);
                        var4_6 = null;
                        var4_6 = new StringBuffer(this.dict.getString(Dictionary.LEVEL_COMPLETE));
                        this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) + 12, var4_6);
                    }
                } else if (this.status == 5 && this.ticks != 0) {
                    if (this.showItem) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(0, 0, 0);
                        var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(255, 255, 255);
                    }
                    if (!this.isPaused && this.showItem) {
                        if (this.bStory == null) {
                            return;
                        }
                        var2_2 = 2;
                        var3_3 = GameManager.fontHeight - GameManager.fontHeight * this.ticks;
                        var4_7 = var2_2;
                        var5_14 = var3_3;
                        var6_15 = this.bStory.length;
                        var9_19 = 3;
                        var10_20 = new StringBuffer("");
                        while (var9_19 < var6_15) {
                            if ((var7_21 = this.bStory[var9_19++]) == 32 || var7_21 == 13 || var7_21 == 44 || var7_21 == 10 || var7_21 == 58) {
                                if (var7_21 == 58) break;
                                if (var4_7 + GameManager.GAME_FONT.stringWidth(var10_20.toString()) > this.gameWidth - 4) {
                                    var4_7 = var2_2;
                                    var5_14 += GameManager.fontHeight;
                                }
                                var1_1.drawString(var10_20.toString(), var4_7, var5_14, 20);
                                if (var7_21 == 32) {
                                    var4_7 += GameManager.GAME_FONT.stringWidth(var10_20.toString()) + 4;
                                }
                                if (var7_21 == 13) {
                                    var4_7 = var2_2;
                                    var5_14 += GameManager.fontHeight << 1;
                                }
                                if (var7_21 == 44) {
                                    var4_7 = var2_2;
                                    var5_14 += GameManager.fontHeight;
                                }
                                var10_20 = null;
                                var10_20 = new StringBuffer("");
                                continue;
                            }
                            var10_20.append((char)var7_21);
                        }
                        this.showItem = false;
                    }
                } else if (this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                    if (this.redrawBG) {
                        this.drawBackground(var1_1);
                    }
                    if (this.clrInvTxt) {
                        if (this.availBG) {
                            var1_1.setColor(0, 0, 0);
                            var1_1.fillRect(this.colBorder, 88, this.gameWidth - (this.colBorder << 1), 14);
                        }
                        this.clrInvTxt = false;
                    }
                    this.view.getMap(this.direction, this.xMap, this.yMap);
                    var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                    this.view.floorToView();
                    this.view.getRayCast();
                    this.view.doRayCast();
                    this.view.getObjectMap(this.direction);
                    this.view.showView(var1_1);
                    if (this.gameHeight == 65) {
                        this.drawFace(var1_1);
                    }
                    if (this.showItem) {
                        var1_1.setClip(this.itemX, this.itemY, 16, 11);
                        var1_1.drawImage(this.invgfx, this.itemX - 16, this.itemY - 85, 20);
                        this.clearItem = true;
                    } else if (this.clearItem) {
                        if (this.availBG) {
                            var1_1.setClip(this.itemX, this.itemY, 16, 11);
                            var1_1.fillRect(this.itemX, this.itemY, 16, 11);
                        }
                        this.clearItem = false;
                    }
                    if (this.iRecovery > 0) {
                        var2_2 = this.gameWidth - 16 >> 1;
                        var3_4 = (this.view.ySize - 16 >> 1) + this.view.yLoc;
                        var1_1.setClip(var2_2, var3_4, 16, 16);
                        var1_1.drawImage(this.invgfx, var2_2 - 32, var3_4 - 80, 20);
                        var4_8 = new StringBuffer("");
                        var4_8.append(this.iHit);
                        var1_1.setClip(var2_2 - 8, var3_4 - 8, 32, 32);
                        var1_1.setColor(255, 255, 255);
                        var1_1.drawString(var4_8.toString(), var2_2 + 8, var3_4 + 8 - (GameManager.fontHeight >> 1), 17);
                    }
                    if (this.compassDirec != this.direction || this.gameHeight == 65) {
                        this.drawComp(var1_1);
                    }
                    if (this.showText != 0) {
                        var2_2 = this.availBG != false ? 93 : this.gameHeight - 5;
                        var3_5 = new StringBuffer("");
                        var3_5.append(this.dict.getString(this.showText));
                        this.drawSmallText(var1_1, this.gameWidth >> 1, var2_2, var3_5);
                        this.clrInvTxt = true;
                        if (this.textTimer == 0) {
                            this.showText = 0;
                        } else {
                            --this.textTimer;
                        }
                    }
                    var2_2 = this.view.xLoc + this.view.xSize - 8;
                    var3_3 = this.colBorder + 2;
                    var4_9 = 0;
                    while (var4_9 < this.view.scrolls.length) {
                        var1_1.setClip(var2_2, var3_3, 8, 8);
                        if (this.view.scrolls[var4_9] > 16 || (this.view.scrolls[var4_9] & 2) != 0) {
                            var1_1.drawImage(this.invgfx, var2_2 - ((var4_9 & 1) << 3), var3_3 - (48 + (var4_9 >> 1 << 3)), 20);
                        }
                        if (this.view.scrolls[var4_9] != 0) {
                            v0 = var4_9;
                            this.view.scrolls[v0] = (byte)(this.view.scrolls[v0] - 1);
                            var3_3 += 8;
                        }
                        ++var4_9;
                    }
                } else if (this.status == 3) {
                    if (this.redrawBG) {
                        this.drawBackground(var1_1);
                    }
                    this.view.showView(var1_1);
                    this.drawInv(var1_1);
                } else if (this.status == 4 && this.ticks != 0) {
                    var2_2 = 0;
                    while (var2_2 < this.view.xSize / 5) {
                        var3_3 = var2_2 * 5 + this.colBorder;
                        var4_10 = var3_3 + 5;
                        var5_14 = this.availBG != false ? this.view.itemType[var2_2] + this.rowBorder : this.view.itemType[var2_2];
                        var6_15 = var5_14 - 4;
                        if (var6_15 < this.rowBorder) {
                            var1_1.setClip(var3_3, this.rowBorder, 5, var5_14 - this.rowBorder);
                        } else {
                            var1_1.setClip(var3_3, var6_15, 5, 4);
                        }
                        var1_1.drawImage(this.invgfx, var3_3 - 36, var6_15 - 73, 20);
                        ++var2_2;
                    }
                }
                if (this.status == 3 || this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                    if (this.showHP || !this.availBG) {
                        if (this.availBG) {
                            var1_1.setClip(5, 120, 32, 4);
                            if (this.HP > 0) {
                                if (this.HP > 32) {
                                    var1_1.setColor(0, 255, 0);
                                } else if (this.HP > 16) {
                                    var1_1.setColor(255, 255, 0);
                                } else {
                                    var1_1.setColor(255, 0, 0);
                                }
                                var1_1.fillRect(5, 120, this.HP >> 1, 4);
                            }
                            if (this.HP < 64) {
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(5 + (this.HP >> 1), 120, 32 - (this.HP >> 1), 4);
                            }
                        } else if (this.status != 3) {
                            var1_1.setClip(0, 16, 16, 2);
                            var1_1.setColor(0, 0, 0);
                            var1_1.fillRect(0, 16, 16, 2);
                            if (this.HP > 32) {
                                var1_1.setColor(0, 255, 0);
                            } else if (this.HP > 16) {
                                var1_1.setColor(255, 255, 0);
                            } else {
                                var1_1.setColor(255, 0, 0);
                            }
                            var1_1.fillRect(0, 16, this.HP >> 2, 4);
                        }
                        this.showHP = false;
                    }
                    if (this.status != 3) {
                        var2_2 = this.availBG != false ? 4 : 2;
                        var3_3 = 0;
                        while (var3_3 < 4) {
                            if (this.showBlood[var3_3][1] > 0) {
                                var4_11 = this.availBG != false ? this.view.xLoc + 8 : 0;
                                var5_14 = this.availBG != false ? this.view.yLoc + this.view.ySize + 26 : 0;
                                switch (var3_3) {
                                    case 0: {
                                        var5_14 -= var2_2;
                                        break;
                                    }
                                    case 1: {
                                        var4_11 += var2_2;
                                        break;
                                    }
                                    case 2: {
                                        var5_14 += var2_2;
                                        break;
                                    }
                                    case 3: {
                                        var4_11 -= var2_2;
                                    }
                                }
                                var1_1.setClip(var4_11, var5_14, 16, 16);
                                if (this.showBlood[var3_3][1] == 1) {
                                    if (this.availBG) {
                                        var1_1.setColor(0, 0, 0);
                                        var1_1.fillRect(var4_11, var5_14, 16, 16);
                                        this.drawFace(var1_1);
                                    }
                                } else {
                                    var1_1.drawImage(this.invgfx, var4_11 - 32, var5_14 - 80, 20);
                                    var6_16 = new StringBuffer("");
                                    var6_16.append(this.showBlood[var3_3][0]);
                                    var1_1.setClip(var4_11 - 8, var5_14 - 8, 32, 32);
                                    var1_1.setColor(255, 255, 255);
                                    var1_1.drawString(var6_16.toString(), var4_11 + 8, var5_14 + 8 - (GameManager.fontHeight >> 1), 17);
                                }
                                v1 = this.showBlood[var3_3];
                                v1[1] = v1[1] - 1;
                                if (var3_3 == 2 && this.showBlood[var3_3][1] == 0) {
                                    this.showHP = true;
                                }
                            }
                            ++var3_3;
                        }
                    }
                }
                if (this.status != 7) break block100;
                var2_2 = this.view.xLoc + (this.view.xSize - (32 << 1) >> 2) * 3;
                var3_3 = this.view.yLoc + (this.view.ySize - (32 << 1) >> 1);
                if (var3_3 < 0) {
                    var3_3 = 0;
                }
                var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                if (this.ticks != 1 && !this.redrawBG) break block101;
                if (this.redrawBG) {
                    this.drawBackground(var1_1);
                }
                var1_1.setColor(0, 128, 54);
                var1_1.fillRect(var2_2, var3_3, 32 << 1, 32 << 1);
                var4_12 = 0;
                if (true) ** GOTO lbl267
                do {
                    var1_1.setColor(0, 160, 54);
                    var1_1.drawLine(var2_2, var3_3 + (var4_12 << 3), var2_2 + (32 << 1), var3_3 + (var4_12 << 3));
                    var1_1.drawLine(var2_2 + (var4_12 << 3), var3_3, var2_2 + (var4_12 << 3), var3_3 + (32 << 1));
                    ++var4_12;
lbl267:
                    // 2 sources

                } while (var4_12 <= 32 >> 2);
                var5_14 = 0;
                if (true) ** GOTO lbl313
                do {
                    var6_17 = 0;
                    if (true) ** GOTO lbl310
                    do {
                        block102: {
                            block105: {
                                block107: {
                                    block106: {
                                        block104: {
                                            block103: {
                                                if ((this.view.mapItem[var6_17][var5_14] & 4) == 0) break block102;
                                                var7_21 = this.view.mapOne[var6_17 + (var5_14 << 5)];
                                                if ((var7_21 & 17) == 0) break block103;
                                                if ((var7_21 & 17) == 17) {
                                                    var1_1.setColor(255, 255, 255);
                                                } else {
                                                    var1_1.setColor(172, 211, 115);
                                                }
                                                var1_1.fillRect(var6_17 + var6_17 + var2_2, var5_14 + var5_14 + var3_3, 2, 2);
                                                break block102;
                                            }
                                            if (var6_17 == 0) break block104;
                                            if (this.view.mapOne[var6_17 + (var5_14 << 5) - 1] != 0) break block105;
                                        }
                                        if (var6_17 == 32 - 1) break block106;
                                        if (this.view.mapOne[var6_17 + (var5_14 << 5) + 1] != 0) break block105;
                                    }
                                    if (var5_14 == 0) break block107;
                                    if (this.view.mapOne[var6_17 + (var5_14 << 5) - 32] != 0) break block105;
                                }
                                if (var5_14 == 32 - 1) break block102;
                                if (this.view.mapOne[var6_17 + (var5_14 << 5) + 32] == 0) break block102;
                            }
                            var1_1.setColor(0, 0, 0);
                            var1_1.fillRect(var6_17 + var6_17 + var2_2, var5_14 + var5_14 + var3_3, 2, 2);
                        }
                        ++var6_17;
lbl310:
                        // 2 sources

                    } while (var6_17 < 32);
                    ++var5_14;
lbl313:
                    // 2 sources

                } while (var5_14 < 32);
            }
            if ((this.ticks & 8) == 0) {
                var1_1.setColor(0, 0, 255);
            } else {
                var1_1.setColor(172, 211, 115);
            }
            var1_1.fillRect(this.xMap + this.xMap + var2_2, this.yMap + this.yMap + var3_3, 2, 2);
        }
        if (this.status == 8) {
            var1_1.setColor(32, 128, 160);
            var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
            var1_1.setColor(255, 255, 255);
            var2_2 = 0;
            while (var2_2 < 8) {
                var1_1.drawString(this.dict.getString(Dictionary.I1 + var2_2), 1, (var2_2 + this.ticks) * GameManager.fontHeight, 20);
                ++var2_2;
            }
        }
        if (this.isPaused) {
            var2_2 = -3;
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                if (this.options[var3_3]) {
                    ++var2_2;
                }
                ++var3_3;
            }
            var4_13 = this.gameWidth >> 1;
            var5_14 = this.view != null ? (this.view.ySize >> 1) - (var2_2 * 8 + (GameManager.fontHeight + 2) >> 1) + this.view.yLoc : (this.gameHeight >> 1) - (var2_2 * 8 + (GameManager.fontHeight + 2) >> 1);
            var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
            var1_1.setColor(0, 0, 0);
            var1_1.fillRect(var4_13 - 35, var5_14 - (GameManager.fontHeight >> 1) - 4, 70, (var2_2 + 2 << 3) + GameManager.fontHeight + 10);
            var1_1.setColor(255, 255, 0);
            var1_1.drawRect(var4_13 - 35, var5_14 - (GameManager.fontHeight >> 1) - 4, 70, (var2_2 + 2 << 3) + GameManager.fontHeight + 10);
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                var6_18 = new StringBuffer(this.dict.getString(Dictionary.MENU_0 + var3_3));
                if (this.options[var3_3]) {
                    if (this.option == var3_3) {
                        this.showOption(var1_1, var4_13, var5_14, var6_18);
                        var5_14 += GameManager.fontHeight;
                    } else {
                        this.drawSmallText(var1_1, var4_13, var5_14, var6_18);
                        var5_14 += 8;
                    }
                }
                ++var3_3;
            }
        }
    }

    void showOption(Graphics graphics, int n, int n2, StringBuffer stringBuffer) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawString(stringBuffer.toString(), n + 1, (n2 -= 3) + 1, 17);
        graphics.setColor(255, 255, 0);
        graphics.drawString(stringBuffer.toString(), n, n2, 17);
    }

    void drawBackground(Graphics graphics) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.gameWidth, this.gameHeight);
        if (this.availBG) {
            int n = this.view.xSize + 1;
            int n2 = this.view.ySize + this.rowBorder + 2;
            graphics.setColor(255, 255, 255);
            graphics.drawRect(this.colBorder - 1, n2, n, 16);
            graphics.drawRect(this.colBorder - 1, n2 += 18, n, this.gameHeight - n2 - 2);
        }
        this.drawFace(graphics);
        this.drawComp(graphics);
        this.redrawBG = false;
    }

    void drawFace(Graphics graphics) {
        int n = this.view.xLoc + 2;
        int n2 = !this.availBG ? 0 : this.view.yLoc + this.view.ySize + 22;
        graphics.setClip(n, n2, 16, 16);
        graphics.drawImage(this.invgfx, n, n2 - 80, 20);
    }

    void drawComp(Graphics graphics) {
        this.compassDirec = this.direction;
        if (!this.availBG) {
            StringBuffer stringBuffer;
            switch (this.compassDirec) {
                case 0: {
                    stringBuffer = new StringBuffer("N");
                    break;
                }
                case 1: {
                    stringBuffer = new StringBuffer("E");
                    break;
                }
                case 2: {
                    stringBuffer = new StringBuffer("S");
                    break;
                }
                case 3: {
                    stringBuffer = new StringBuffer("W");
                    break;
                }
                default: {
                    stringBuffer = new StringBuffer(" ");
                }
            }
            this.drawSmallText(graphics, 4, 22, stringBuffer);
        } else {
            int n = 56;
            int n2 = 110;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer("W-N-E-S-W-N");
            switch (this.compassDirec) {
                case 0: {
                    n3 = 4;
                    break;
                }
                case 1: {
                    n3 = 16;
                    break;
                }
                case 2: {
                    n3 = 28;
                    break;
                }
                case 3: {
                    n3 = 40;
                }
            }
            graphics.setClip(n, n2, 25, 15);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(n, n2, 25, 16);
            graphics.setColor(255, 255, 255);
            graphics.drawString(stringBuffer.toString(), n - n3, n2, 20);
        }
    }

    void drawInv(Graphics graphics) {
        int n;
        graphics.setColor(0, 128, 54);
        int n2 = this.availBG ? 74 + this.view.xLoc : 60 + this.view.xLoc;
        int n3 = this.availBG ? 16 + this.view.yLoc : 8;
        graphics.setClip(n2, n3, 16, 48);
        graphics.drawImage(this.invgfx, n2, n3, 20);
        graphics.setClip(0, 0, 128, 128);
        int n4 = 0;
        while (n4 < 16) {
            n2 = this.invSquareXY[n4][0];
            n3 = this.invSquareXY[n4][1];
            if (this.itemSelect == n4) {
                graphics.setColor(241, 238, 133);
            } else {
                graphics.setColor(149, 192, 162);
            }
            graphics.fillRect(n2, n3, this.invSquareSize, this.invSquareSize);
            if (this.itemSelect == n4) {
                graphics.setColor(255, 255, 192);
            } else {
                graphics.setColor(192, 239, 205);
            }
            graphics.drawLine(n2, n3, n2 + this.invSquareSize - 1, n3);
            graphics.drawLine(n2, n3, n2, n3 + this.invSquareSize - 1);
            if (this.itemSelect == n4) {
                graphics.setColor(175, 175, 102);
            } else {
                graphics.setColor(96, 128, 104);
            }
            graphics.drawLine(n2 + this.invSquareSize - 1, n3 + 1, n2 + this.invSquareSize - 1, n3 + this.invSquareSize - 1);
            graphics.drawLine(n2 + 1, n3 + this.invSquareSize - 1, n2 + this.invSquareSize - 1, n3 + this.invSquareSize - 1);
            if (this.invItem[n4] != 0) {
                n = this.view.itemType[this.invItem[n4] - 1] - 1 >> 3;
                graphics.setClip(n2, n3, 16, 16);
                graphics.drawImage(this.invgfx, n2 - 16 - ((n & 1) << 4), n3 - (n >> 1 << 4), 20);
                graphics.setClip(0, 0, 128, 128);
            } else if (n4 == 9) {
                graphics.setClip(n2, n3 + 3, 16, 9);
                graphics.drawImage(this.invgfx, n2 - 32, n3 - 61, 20);
                graphics.setClip(0, 0, 128, 128);
            }
            ++n4;
        }
        graphics.setColor(192, 239, 205);
        n4 = 0;
        while (n4 < 8) {
            if (n4 != 1 && n4 != 5 && (n4 != 6 || this.availBG)) {
                graphics.drawLine(this.invLineFromX[n4], this.invLineFromY[n4], this.invLineToX[n4], this.invLineToY[n4]);
            }
            ++n4;
        }
        graphics.setClip(0, 0, 128, 128);
        n2 = this.invSquareXY[this.itemCurrent][0];
        n3 = this.invSquareXY[this.itemCurrent][1];
        graphics.setColor(255, 0, 0);
        graphics.drawRect(n2, n3, this.invSquareSize - 1, this.invSquareSize - 1);
        n2 = this.gameWidth >> 1;
        int n5 = n3 = this.availBG ? 91 : this.gameHeight - 14;
        if (this.availBG) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(this.colBorder, n3 - 3, this.gameWidth - (this.colBorder << 1), 14);
        }
        if (this.invItem[this.itemCurrent] != 0) {
            n = this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1;
            int n6 = n >> 3;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            StringBuffer stringBuffer = new StringBuffer(this.dict.getString(this.itemDsc[n] + Dictionary.TEXT_DEX));
            StringBuffer stringBuffer2 = new StringBuffer("");
            this.drawSmallText(graphics, n2, n3, stringBuffer);
            n &= 7;
            if (n6 == 0 || n6 == 7) {
                n8 += this.view.helmet[n + n];
                n9 -= this.view.helmet[n + n + 1];
            } else if (n6 == 1) {
                n7 += this.view.sword[n + n];
                n9 -= this.view.sword[n + n + 1];
            } else if (n6 == 2 || n6 == 3) {
                n8 += this.view.sword[n + n];
                n9 -= this.view.sword[n + n + 1];
            } else if (n6 == 4) {
                n7 += this.view.ring[n + n + n];
                n8 += this.view.ring[n + n + n + 1];
                n9 -= this.view.ring[n + n + n + 2];
            }
            n9 = -n9;
            if (n7 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_ATT));
                if (n7 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n7);
                stringBuffer2.append(" ");
            }
            if (n8 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEF));
                if (n8 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n8);
                stringBuffer2.append(" ");
            }
            if (n9 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEX));
                if (n9 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n9);
            }
            this.drawSmallText(graphics, n2, n3 += 7, stringBuffer2);
            this.clrInvTxt = true;
        }
    }

    void drawSmallText(Graphics graphics, int n, int n2, StringBuffer stringBuffer) {
        int n3 = stringBuffer.length();
        if (n + n3 + n3 + n3 >= this.gameWidth - this.colBorder) {
            n = this.gameWidth - this.colBorder - 1 - (n3 + n3 + n3);
        }
        n2 -= 3;
        if ((n -= n3 + n3 + n3) < this.colBorder) {
            n = this.colBorder;
        }
        if (n2 < this.rowBorder) {
            n2 = this.rowBorder < 0 ? 0 : this.rowBorder;
        }
        int n4 = 0;
        while (n4 < n3) {
            graphics.setClip(n, n2, 6, 7);
            int n5 = stringBuffer.charAt(n4);
            if (n5 == 43) {
                n5 = 222;
            } else if (n5 == 45) {
                n5 = 216;
            } else {
                n5 = n5 >= 48 && n5 <= 57 ? (n5 -= 22) : (n5 -= 65);
                n5 *= 6;
            }
            if (n5 >= 0 && n5 <= 222) {
                graphics.drawImage(this.textgfx, n - n5, n2, 20);
            }
            n += 6;
            ++n4;
        }
    }
}

