/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

class MyPlayer
extends Sprite {
    static int cv_isTakingDamage;
    static int cv_moveType;
    static boolean cv_isDamaging;
    boolean isAiDamaging;
    static final int BACK_KICK = -1;
    static final int PUNCH = 1;
    static final int FRONT_KICK = 2;
    static final int ACTION_KICK = 3;
    static final int KNIFE_ACTION = 4;
    static final int BOMB_ACTION = 5;
    int health = 50;
    int playerState;
    boolean iv_forward;
    private boolean iv_flyingKick;
    private boolean jumping;
    public boolean ducking;
    public boolean exploded;
    public boolean isVisible;
    private int jumpingIndex = 0;
    private int[] jumpingArray = new int[]{12, 12, 12, 10, 7, 5, 3, 1};
    private int speedIndex = 0;
    private int[] walkingArray = new int[]{0, 1, 3, 6};
    private int fallingSpeed = 0;
    private int[] idleFrameSequence = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1};
    private int[] dyingFrameSequence = new int[]{29, 30, 31, 32};
    private int[] walkingFrameSequence = new int[]{3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
    private int[] duckingFrameSequence = new int[]{2};
    private int[] fallingDown = new int[]{20};
    private int[] jumpingFrameSequence = new int[]{19};
    int frameWidth;
    int frameHeight;
    static final int IDLE_STATE = 0;
    static final int WALKING_STATE = 1;
    static final int DUCKING_STATE = 2;
    static final int FALLING_STATE = 4;
    static final int DYING_STATE = 5;
    static final int ACTION_STATE = 6;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int UP = 2;
    static final int DOWN = 3;
    static final int LEFTUP = 4;
    static final int RIGHTUP = 5;
    static final int FIRE = 6;
    static final int FIREUP = 7;
    static final int FIREDOWN = 8;
    static final int FIRELEFT = 9;
    static final int FIRERIGHT = 10;
    static final int NONE = -1;
    int iv_aiType;
    static final int AI_ARCHER = 1;
    static final int AI_SPEAR = 2;
    static final int AI_SWORD = 3;
    static final int AI_REDDY = 4;
    int iv_weaponType;
    static final int WT_KNIFE = 1;
    static final int WT_BOMB = 2;
    boolean playerOnRect;
    private static int[] walkingX;
    private static int[] walkingY;
    private static int[] walkingWidth;
    private static int[] walkingHeight;
    private int iv_flashingIndex;

    MyPlayer(Image image, int w, int h, int aiType) {
        super(image, w, h);
        this.iv_aiType = aiType;
        this.frameWidth = w;
        this.frameHeight = h;
        this.iv_forward = true;
        this.ducking = false;
        this.applyAIFrames();
        this.playerState = 0;
        this.setFrameSequence(this.idleFrameSequence);
        this.isVisible = aiType <= 0;
        this.playerOnRect = false;
        this.exploded = false;
    }

    private void applyAIFrames() {
        if (this.iv_aiType > 0) {
            switch (this.iv_aiType) {
                case 1: {
                    int[] frq = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
                    this.idleFrameSequence = frq;
                    this.fallingDown[0] = 0;
                    int[] frq1 = new int[]{2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
                    this.walkingFrameSequence = frq1;
                    int[] frq2 = new int[]{1};
                    this.duckingFrameSequence = frq2;
                    this.ducking = false;
                    int[] walkingArray = new int[]{0, 1, 3, 6, 8};
                    this.walkingArray = walkingArray;
                    break;
                }
                case 2: {
                    int[] frq = new int[]{0, 0, 1, 1, 0, 0, 1, 1};
                    this.idleFrameSequence = frq;
                    this.fallingDown[0] = 0;
                    int[] frq1 = new int[]{4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11};
                    this.walkingFrameSequence = frq1;
                    this.duckingFrameSequence[0] = 2;
                    break;
                }
                case 3: {
                    int[] frq = new int[]{0, 0, 0};
                    this.idleFrameSequence = frq;
                    this.fallingDown[0] = 0;
                    int[] frq1 = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
                    this.walkingFrameSequence = frq1;
                    this.duckingFrameSequence[0] = 1;
                    break;
                }
                case 4: {
                    int[] frq = new int[]{0, 0, 0, 1, 1, 1};
                    this.idleFrameSequence = frq;
                    this.fallingDown[0] = 17;
                    int[] frq1 = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
                    this.walkingFrameSequence = frq1;
                    this.duckingFrameSequence[0] = 2;
                }
            }
        } else if (this.iv_aiType < 0) {
            if (this.iv_aiType == -10) {
                int[] frq = new int[]{0, 1, 2, 3};
                this.idleFrameSequence = frq;
            } else {
                this.fallingDown[0] = 0;
                int[] frq = new int[]{3, 3, 3, 4, 4};
                this.idleFrameSequence = frq;
                int[] frq1 = new int[]{5, 6, 7, 8, 9};
                this.walkingFrameSequence = frq1;
            }
        }
    }

    void recreateWalkingLayer(int level) {
        switch (level) {
            case 1: {
                int[] wX = new int[]{0, RajuFightClubCanvas.MAP_WIDTH, 16};
                int[] wY = new int[]{0, 0, RajuFightClubCanvas.SCREEN_HEIGHT - 16};
                int[] wWidth = new int[]{16, 16, RajuFightClubCanvas.MAP_WIDTH};
                int[] wHeight = new int[]{900, RajuFightClubCanvas.SCREEN_HEIGHT, 16};
                walkingX = wX;
                walkingY = wY;
                walkingWidth = wWidth;
                walkingHeight = wHeight;
                break;
            }
            case 3: {
                int[] wX = new int[]{0, RajuFightClubCanvas.MAP_WIDTH, 16};
                int[] wY = new int[]{0, 0, RajuFightClubCanvas.SCREEN_HEIGHT - 16 - 8};
                int[] wWidth = new int[]{16, 16, RajuFightClubCanvas.MAP_WIDTH};
                int[] wHeight = new int[]{900, RajuFightClubCanvas.SCREEN_HEIGHT, 16};
                walkingX = wX;
                walkingY = wY;
                walkingWidth = wWidth;
                walkingHeight = wHeight;
                break;
            }
            case 4: {
                int[] wX = new int[]{0, RajuFightClubCanvas.MAP_WIDTH, 16};
                int[] wY = new int[]{0, 0, RajuFightClubCanvas.SCREEN_HEIGHT - 16};
                int[] wWidth = new int[]{16, 16, RajuFightClubCanvas.MAP_WIDTH};
                int[] wHeight = new int[]{900, RajuFightClubCanvas.SCREEN_HEIGHT, 16};
                walkingX = wX;
                walkingY = wY;
                walkingWidth = wWidth;
                walkingHeight = wHeight;
                break;
            }
            default: {
                int[] wX = new int[]{0, RajuFightClubCanvas.MAP_WIDTH, 16};
                int[] wY = new int[]{0, 0, RajuFightClubCanvas.SCREEN_HEIGHT};
                int[] wWidth = new int[]{16, 16, RajuFightClubCanvas.MAP_WIDTH};
                int[] wHeight = new int[]{900, RajuFightClubCanvas.SCREEN_HEIGHT, 16};
                walkingX = wX;
                walkingY = wY;
                walkingWidth = wWidth;
                walkingHeight = wHeight;
            }
        }
        this.setVisible(true);
    }

    void paintWalkingLayer(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int i = walkingX.length - 1; i >= 0; --i) {
            g.fillRect(walkingX[i], walkingY[i], walkingWidth[i], walkingHeight[i]);
            g.drawRect(walkingX[i], walkingY[i], walkingWidth[i], walkingHeight[i]);
        }
    }

    int collidesWithWalkingLayer() {
        int quaterFrameWidth = this.frameWidth / 4;
        int r1x1 = this.getX() + quaterFrameWidth;
        int r1x2 = r1x1 + this.frameWidth / 2;
        int r1y1 = this.getY();
        int r1y2 = r1y1 + this.frameHeight;
        for (int i = walkingX.length - 1; i >= 0; --i) {
            int r2x1 = walkingX[i];
            int r2y1 = walkingY[i];
            int r2x2 = r2x1 + walkingWidth[i];
            int r2y2 = r2y1 + walkingHeight[i];
            if (r2x1 >= r1x2 || r2y1 >= r1y2 || r2x2 <= r1x1 || r2y2 <= r1y1) continue;
            return i;
        }
        return -1;
    }

    void reset(int px1) {
        this.health = 50;
        if (!this.iv_forward) {
            this.setTransform(0);
            this.iv_forward = true;
        }
        this.playerState = 0;
        this.setFrameSequence(this.idleFrameSequence);
        if (this.iv_aiType > 0) {
            this.setVisible(true);
            switch (this.iv_aiType) {
                case 1: {
                    this.setPosition(this.getX() + 250, this.getY());
                    break;
                }
                case 2: {
                    this.setPosition(this.getX() + 230, this.getY());
                    break;
                }
                case 3: {
                    this.setPosition(this.getX() + 200, this.getY());
                }
            }
            int currentWalkingRect = this.collidesWithWalkingLayer();
            if (currentWalkingRect >= 0) {
                this.setPosition(this.getX(), walkingY[currentWalkingRect] - this.frameHeight);
            }
        }
    }

    void setDeadState(boolean isDucking) {
        if (this.iv_aiType > 0) {
            this.playerState = 5;
            switch (this.iv_aiType) {
                case 1: {
                    if (this.ducking) {
                        int[] frq = new int[]{19, 19, 20, 20, 21, 21};
                        this.dyingFrameSequence = frq;
                    } else {
                        int[] frq = new int[]{19, 19, 20, 20, 21, 21};
                        this.dyingFrameSequence = frq;
                    }
                    this.setFrameSequence(this.dyingFrameSequence);
                    break;
                }
                case 2: {
                    if (this.playerState == 2 && !isDucking) {
                        int[] frq = new int[]{16, 16, 17, 17, 17};
                        this.dyingFrameSequence = frq;
                    } else if (this.playerState != 2 && isDucking) {
                        int[] frq = new int[]{16, 16, 17, 17, 17};
                        this.dyingFrameSequence = frq;
                    } else {
                        int[] frq = new int[]{16, 16, 17, 17, 17};
                        this.dyingFrameSequence = frq;
                    }
                    this.setFrameSequence(this.dyingFrameSequence);
                    break;
                }
                case 3: {
                    if (this.playerState == 2 && !isDucking) {
                        int[] frq = new int[]{10, 10, 11, 11, 12, 12, 12};
                        this.dyingFrameSequence = frq;
                    } else if (this.playerState != 2 && isDucking) {
                        int[] frq = new int[]{10, 10, 11, 11, 12, 12, 12};
                        this.dyingFrameSequence = frq;
                    } else {
                        int[] frq = new int[]{10, 10, 11, 11, 12, 12, 12};
                        this.dyingFrameSequence = frq;
                    }
                    this.setFrameSequence(this.dyingFrameSequence);
                    break;
                }
                case 4: {
                    int[] frq = new int[]{22, 22, 23, 23, 23, 24, 24, 24};
                    this.dyingFrameSequence = frq;
                    this.setFrameSequence(this.dyingFrameSequence);
                }
            }
        } else {
            if (this.jumping || this.playerState == 4) {
                this.setPosition(this.getX(), RajuFightClubCanvas.SCREEN_HEIGHT - 108);
            }
            this.playerState = 5;
            this.setFrameSequence(this.dyingFrameSequence);
            this.health = 0;
            cv_isTakingDamage = 0;
            cv_moveType = 0;
            cv_isDamaging = false;
            this.isAiDamaging = false;
        }
    }

    private int getDirection(int key) {
        if ((key & 0x100) != 0) {
            if ((key & 2) != 0) {
                return 7;
            }
            if ((key & 4) != 0) {
                return 9;
            }
            if ((key & 0x20) != 0) {
                return 10;
            }
            if ((key & 0x40) != 0) {
                return 8;
            }
            return 6;
        }
        if ((key & 2) != 0) {
            if ((key & 4) != 0) {
                if (this.iv_aiType == 0 && cv_isTakingDamage < 0) {
                    if (this.iv_forward) {
                        return 9;
                    }
                    return -1;
                }
                return 4;
            }
            if ((key & 0x20) != 0) {
                if (this.iv_aiType == 0 && cv_isTakingDamage > 0) {
                    if (this.iv_forward) {
                        return -1;
                    }
                    return 10;
                }
                return 5;
            }
            return 2;
        }
        if ((key & 4) != 0) {
            if (this.iv_aiType == 0 && cv_isTakingDamage < 0) {
                if (this.iv_forward) {
                    return 9;
                }
                return -1;
            }
            return 0;
        }
        if ((key & 0x20) != 0) {
            if (this.iv_aiType == 0 && cv_isTakingDamage > 0) {
                if (this.iv_forward) {
                    return -1;
                }
                return 10;
            }
            return 1;
        }
        if ((key & 0x40) != 0) {
            return 3;
        }
        return -1;
    }

    void setDirection() {
        if (this.iv_forward) {
            this.setTransform(0);
            this.move(-this.frameWidth, 0);
            while (this.collidesWithWalkingLayer() >= 0) {
                this.move(1, 0);
            }
        } else {
            this.setTransform(2);
            this.move(this.frameWidth, 0);
            while (this.collidesWithWalkingLayer() >= 0) {
                this.move(-1, 0);
            }
        }
    }

    private void walk(boolean forward) {
        if (forward != this.iv_forward) {
            this.iv_forward = forward;
            this.speedIndex = 0;
            this.setDirection();
        }
        if (forward) {
            this.move(this.walkingArray[this.speedIndex], 0);
            if (this.collidesWithWalkingLayer() >= 0) {
                this.move(-this.walkingArray[this.speedIndex], 0);
            }
        } else {
            if (this.iv_aiType == 1 && this.getX() <= 10) {
                this.input(32);
            }
            this.move(-this.walkingArray[this.speedIndex], 0);
            if (this.collidesWithWalkingLayer() >= 0) {
                this.move(this.walkingArray[this.speedIndex], 0);
            }
        }
        if (this.jumping) {
            if (this.jumpingIndex < 5) {
                this.move(0, -this.jumpingArray[this.jumpingIndex]);
                int currentWalkingRect = this.collidesWithWalkingLayer();
                if (currentWalkingRect >= 0) {
                    this.setPosition(this.getX(), walkingY[currentWalkingRect] + walkingHeight[currentWalkingRect]);
                    this.jumping = false;
                    this.jumpingIndex = 0;
                    this.fallingSpeed = 0;
                    this.playerState = 4;
                    this.setFrameSequence(this.fallingDown);
                } else {
                    ++this.jumpingIndex;
                }
            } else {
                this.jumping = false;
                this.jumpingIndex = 0;
                this.fallingSpeed = 0;
                this.playerState = 4;
                this.setFrameSequence(this.fallingDown);
            }
        } else {
            int currentWalkingRect = this.collidesWithWalkingLayer();
            if (currentWalkingRect >= 0) {
                this.setPosition(this.getX(), walkingY[currentWalkingRect] - this.frameHeight);
            } else {
                this.move(0, 1);
                if (this.collidesWithWalkingLayer() >= 0) {
                    this.move(0, -1);
                } else {
                    this.fallingSpeed = 0;
                    this.playerState = 4;
                    this.setFrameSequence(this.fallingDown);
                }
            }
        }
    }

    boolean input(int key) {
        if (this.playerState == 5) {
            if (this.getFrame() < this.dyingFrameSequence.length - 1) {
                this.nextFrame();
                this.iv_flashingIndex = 0;
            } else if (this.iv_flashingIndex < 15) {
                if (this.iv_flashingIndex % 2 == 0) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                ++this.iv_flashingIndex;
            } else {
                return true;
            }
            return false;
        }
        if (RajuFightClubCanvas.currentLevel == 3 && this.iv_aiType == 0 && this.playerState == 0) {
            this.move(0, 5);
            if (this.collidesWithWalkingLayer() >= 0 || this.playerOnRect) {
                this.move(0, -5);
            } else {
                this.fallingSpeed = 0;
                this.playerState = 4;
                this.setFrameSequence(this.fallingDown);
                return false;
            }
        }
        int currentKeys = this.getDirection(key);
        if (this.playerState == 6) {
            if (this.iv_flyingKick) {
                this.fallingSpeed += 2;
                this.move(0, this.fallingSpeed);
                int currentWalkingRect = this.collidesWithWalkingLayer();
                if (currentWalkingRect >= 0) {
                    this.setPosition(this.getX(), walkingY[currentWalkingRect] - this.frameHeight);
                    this.fallingSpeed = 0;
                    this.speedIndex = 0;
                    this.playerState = 0;
                    this.setFrameSequence(this.idleFrameSequence);
                    this.iv_flyingKick = false;
                    cv_isDamaging = false;
                    cv_moveType = 0;
                }
            } else if (this.iv_aiType == 0 && currentKeys > 6 && !cv_isDamaging) {
                this.setActionState(currentKeys);
            } else {
                this.nextFrame();
                if (this.getFrame() == 0) {
                    this.playerState = 0;
                    this.setFrameSequence(this.idleFrameSequence);
                    if (this.iv_aiType == 0) {
                        cv_isDamaging = false;
                        cv_moveType = 0;
                    }
                }
            }
            return false;
        }
        if (!this.jumping && currentKeys >= 6) {
            if (this.playerState == 4) {
                if (this.iv_aiType == 0) {
                    this.iv_flyingKick = true;
                    cv_moveType = 1;
                    int[] frq = new int[]{22};
                    this.setFrameSequence(frq);
                    this.playerState = 6;
                }
            } else if (this.playerState != 6) {
                this.setActionState(currentKeys);
            }
        } else {
            block0 : switch (this.playerState) {
                case 0: {
                    switch (currentKeys) {
                        case 0: {
                            if (!RajuFightClubCanvas.startGame) break block0;
                            if (this.iv_forward) {
                                this.iv_forward = false;
                                this.speedIndex = 0;
                                this.setDirection();
                            }
                            this.playerState = 1;
                            this.setFrameSequence(this.walkingFrameSequence);
                            break block0;
                        }
                        case 1: {
                            if (!this.iv_forward) {
                                this.iv_forward = true;
                                this.speedIndex = 0;
                                this.setDirection();
                            }
                            this.playerState = 1;
                            this.setFrameSequence(this.walkingFrameSequence);
                            break block0;
                        }
                        case 2: 
                        case 4: 
                        case 5: {
                            if (this.jumping) break block0;
                            if (key == 5) {
                                if (this.iv_forward) {
                                    this.iv_forward = false;
                                    this.speedIndex = 4;
                                    this.setDirection();
                                }
                            } else if (key == 4 && !this.iv_forward) {
                                this.iv_forward = true;
                                this.speedIndex = 4;
                                this.setDirection();
                            }
                            this.playerState = 1;
                            this.jumping = true;
                            this.setFrameSequence(this.jumpingFrameSequence);
                            break block0;
                        }
                        case 3: {
                            this.playerState = 2;
                            this.ducking = true;
                            this.setFrameSequence(this.duckingFrameSequence);
                            break block0;
                        }
                    }
                    this.nextFrame();
                    break;
                }
                case 1: {
                    switch (currentKeys) {
                        case 4: {
                            if (!this.jumping) {
                                this.jumping = true;
                                this.setFrameSequence(this.jumpingFrameSequence);
                            }
                        }
                        case 0: {
                            if (this.jumping) {
                                if (this.speedIndex > 3) {
                                    --this.speedIndex;
                                }
                                this.ducking = false;
                                this.walk(this.iv_forward);
                                break block0;
                            }
                            ++this.speedIndex;
                            if (this.speedIndex >= this.walkingArray.length) {
                                this.speedIndex = this.walkingArray.length - 1;
                            }
                            this.walk(false);
                            this.ducking = false;
                            this.nextFrame();
                            break block0;
                        }
                        case 5: {
                            if (!this.jumping) {
                                this.jumping = true;
                                this.setFrameSequence(this.jumpingFrameSequence);
                            }
                        }
                        case 1: {
                            if (this.jumping) {
                                if (this.speedIndex > 3) {
                                    --this.speedIndex;
                                }
                                this.ducking = false;
                                this.walk(this.iv_forward);
                            } else {
                                ++this.speedIndex;
                                if (this.speedIndex >= this.walkingArray.length) {
                                    this.speedIndex = this.walkingArray.length - 1;
                                }
                                this.ducking = false;
                                this.walk(true);
                                this.nextFrame();
                            }
                            RajuFightClubCanvas.startGame = true;
                            break block0;
                        }
                        case 2: {
                            if (!this.jumping) {
                                this.jumping = true;
                                this.ducking = false;
                                this.setFrameSequence(this.jumpingFrameSequence);
                                break block0;
                            }
                            if (this.speedIndex > 3) {
                                --this.speedIndex;
                            }
                            this.walk(this.iv_forward);
                            break block0;
                        }
                        case 3: {
                            if (this.jumping) break block0;
                            this.playerState = 2;
                            this.ducking = true;
                            this.setFrameSequence(this.duckingFrameSequence);
                            break block0;
                        }
                    }
                    if (this.speedIndex > 0) {
                        --this.speedIndex;
                        this.walk(this.iv_forward);
                        this.nextFrame();
                        break;
                    }
                    if (this.jumping) {
                        this.walk(this.iv_forward);
                        break;
                    }
                    this.playerState = 0;
                    this.setFrameSequence(this.idleFrameSequence);
                    break;
                }
                case 4: {
                    this.fallingSpeed += 2;
                    if (this.speedIndex > 0) {
                        this.move(this.iv_forward ? this.walkingArray[this.speedIndex] : -this.walkingArray[this.speedIndex], 0);
                        if (this.collidesWithWalkingLayer() >= 0) {
                            this.move(this.iv_forward ? -this.walkingArray[this.speedIndex] : this.walkingArray[this.speedIndex], 0);
                            this.speedIndex = 0;
                        }
                    }
                    this.move(0, this.fallingSpeed);
                    int currentWalkingRect = this.collidesWithWalkingLayer();
                    if (currentWalkingRect >= 0) {
                        this.setPosition(this.getX(), walkingY[currentWalkingRect] - this.frameHeight);
                        this.fallingSpeed = 0;
                        this.speedIndex = 0;
                        this.playerState = 0;
                        this.setFrameSequence(this.idleFrameSequence);
                        this.setPosition(this.getX(), walkingY[currentWalkingRect] - this.frameHeight);
                        break;
                    }
                    if (RajuFightClubCanvas.currentLevel != 3 || !this.playerOnRect) break;
                    this.fallingSpeed = 0;
                    this.speedIndex = 0;
                    this.playerState = 0;
                    this.setFrameSequence(this.idleFrameSequence);
                    break;
                }
                case 5: {
                    if (this.getFrame() >= this.dyingFrameSequence.length - 1) break;
                    this.nextFrame();
                    break;
                }
                case 2: {
                    switch (currentKeys) {
                        case 0: {
                            if (this.iv_forward) {
                                this.iv_forward = false;
                                this.speedIndex = 0;
                                this.setDirection();
                                break block0;
                            }
                            this.playerState = 1;
                            this.setFrameSequence(this.walkingFrameSequence);
                            break block0;
                        }
                        case 1: {
                            if (!this.iv_forward) {
                                this.iv_forward = true;
                                this.speedIndex = 0;
                                this.setDirection();
                                break block0;
                            }
                            this.playerState = 1;
                            this.setFrameSequence(this.walkingFrameSequence);
                            break block0;
                        }
                        case 2: 
                        case 4: 
                        case 5: {
                            this.playerState = 0;
                            this.setFrameSequence(this.idleFrameSequence);
                        }
                    }
                }
            }
        }
        return false;
    }

    private void setActionState(int currentKeys) {
        if (this.iv_aiType > 0) {
            switch (this.iv_aiType) {
                case 1: {
                    int[] frq = new int[]{10, 10, 11, 11, 12, 12, 13, 13, 14, 14};
                    this.setFrameSequence(frq);
                    break;
                }
                case 2: {
                    int[] frq = new int[]{12, 12, 13, 13, 14, 14, 15, 15, 16, 16};
                    this.setFrameSequence(frq);
                    break;
                }
                case 3: {
                    int[] frq = new int[]{7, 8, 8, 9, 9, 10, 10};
                    this.setFrameSequence(frq);
                }
            }
        } else {
            switch (currentKeys) {
                case 6: {
                    if (this.jumping || this.playerState == 4) {
                        if (cv_moveType == 3) break;
                        int[] frq = new int[]{23, 23, 24, 24, 25, 25};
                        this.setFrameSequence(frq);
                        cv_moveType = 3;
                        break;
                    }
                    if (this.playerState == 2) {
                        this.ducking = true;
                        int[] frq = new int[]{10, 10, 11, 11, 12, 12, 13, 13, 14, 14};
                        this.setFrameSequence(frq);
                        cv_moveType = 3;
                        break;
                    }
                    cv_moveType = 1;
                    if (RajuFightClubCanvas.nextInt(100) < 80) {
                        int[] frq = new int[]{15, 15, 16, 16};
                        this.setFrameSequence(frq);
                        break;
                    }
                    if (RajuFightClubCanvas.nextInt(10) < 3) {
                        int[] frq = new int[]{15, 16, 17, 17, 18, 18, 19, 19};
                        this.setFrameSequence(frq);
                        break;
                    }
                    int[] frq = new int[]{15, 16, 17, 17, 18, 18, 19, 19};
                    this.setFrameSequence(frq);
                    break;
                }
                case 7: {
                    if (cv_moveType == 3) break;
                    int[] frq = new int[]{23, 23, 24, 24, 25, 25};
                    this.setFrameSequence(frq);
                    cv_moveType = 3;
                    break;
                }
                case 8: {
                    if (cv_moveType == 3) break;
                    int[] frq = new int[]{10, 11, 12, 13, 14};
                    this.setFrameSequence(frq);
                    cv_moveType = 3;
                    break;
                }
                case 9: {
                    if (cv_moveType == 2) break;
                    int[] frq = new int[]{26, 26, 27, 27, 28, 28};
                    this.setFrameSequence(frq);
                    cv_moveType = 2;
                    break;
                }
                case 10: {
                    if (!this.iv_forward || cv_moveType == 2) break;
                    int[] frq = new int[]{26, 26, 27, 27, 28, 28};
                    this.setFrameSequence(frq);
                    cv_moveType = 2;
                }
            }
            this.playerState = 6;
        }
        this.playerState = 6;
    }

    boolean collidesWith(int r1x1, int r1y1, int r1x2, int r1y2) {
        int r2x1 = this.getX();
        int r2x2 = this.getX() + this.frameWidth;
        int r2y1 = this.getY();
        int r2y2 = this.getY() + this.frameHeight;
        return r2x1 < r1x2 && r2y1 < r1y2 && r2x2 > r1x1 && r2y2 > r1y1;
    }

    void ai(int px1, boolean playerUnderAttack) {
        if (this.playerState == 5) {
            if (this.getFrame() < this.dyingFrameSequence.length - 1) {
                this.nextFrame();
                this.iv_flashingIndex = 0;
            } else if (this.iv_flashingIndex < 10) {
                if (this.iv_flashingIndex % 2 == 0) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                ++this.iv_flashingIndex;
            } else {
                this.reset(px1);
            }
        } else if (this.playerState == 6 && this.iv_aiType > 0) {
            this.nextFrame();
            if (this.getFrame() == 0) {
                this.playerState = 0;
                this.setFrameSequence(this.idleFrameSequence);
                this.isAiDamaging = false;
            }
        } else {
            switch (this.iv_aiType) {
                case 1: 
                case 2: 
                case 3: {
                    int playerWidth = 70;
                    int x = this.getX();
                    int y = this.getY();
                    int px2 = px1 + 70;
                    if (playerUnderAttack) {
                        if (this.collidesWith(px1 - 70, y, px2 + 70, y + this.frameHeight)) {
                            if (x < px1 + 35) {
                                this.input(4);
                                break;
                            }
                            this.input(32);
                            break;
                        }
                        this.playerState = 0;
                        this.setFrameSequence(this.idleFrameSequence);
                        break;
                    }
                    if (this.collidesWith(px1, y, px2, y + this.frameHeight)) {
                        if (this.iv_forward) {
                            if (x < px1 + 35) {
                                if (this.iv_aiType == 2) {
                                    this.setPosition(px1 - 20, this.getY());
                                } else {
                                    this.setPosition(px1 - 20, this.getY());
                                }
                                this.input(256);
                                break;
                            }
                            this.input(32);
                            break;
                        }
                        if (x < px1 + 35) {
                            this.input(4);
                            break;
                        }
                        if (RajuFightClubCanvas.nextInt(10) < 3) {
                            if (this.iv_aiType == 2) {
                                this.setPosition(px2 - 30, this.getY());
                            } else {
                                this.setPosition(px2 - 30, this.getY());
                            }
                            this.input(256);
                            break;
                        }
                        this.input(64);
                        break;
                    }
                    if (px2 < x) {
                        this.input(4);
                        break;
                    }
                    if (px1 > x) {
                        this.input(32);
                        break;
                    }
                    this.input(this.iv_forward ? 32 : 4);
                }
            }
        }
    }

    void aiReddy(int[] availableHealthPack, MyPlayer player, boolean isColliding) {
        if (this.playerState == 5) {
            if (this.getFrame() < this.dyingFrameSequence.length - 1) {
                this.nextFrame();
                this.iv_flashingIndex = 0;
            } else if (this.iv_flashingIndex < 15) {
                if (this.iv_flashingIndex % 2 == 0) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                ++this.iv_flashingIndex;
            } else {
                this.setVisible(true);
            }
        } else if (this.playerState == 6) {
            this.nextFrame();
            if (this.getFrame() == 0) {
                this.playerState = 0;
                this.setFrameSequence(this.idleFrameSequence);
                this.isAiDamaging = false;
            }
        } else if (availableHealthPack != null && this.health < 25) {
            if (this.collidesWith(availableHealthPack[0], availableHealthPack[1], availableHealthPack[0] + 22, availableHealthPack[1] + 19)) {
                this.input(64);
            } else if (availableHealthPack[0] < this.getX()) {
                this.input(4);
            } else {
                this.input(32);
            }
        } else if (this.health > 35) {
            if (isColliding) {
                if (this.playerState != 6) {
                    if (cv_isDamaging) {
                        this.nextFrame();
                    } else {
                        this.hurtHim(player);
                    }
                }
            } else if (player.getX() < this.getX()) {
                this.input(4);
            } else {
                this.input(32);
            }
        } else if (this.health > 15) {
            if (isColliding) {
                if (RajuFightClubCanvas.nextInt(20) < 5) {
                    if (this.getX() < 50) {
                        this.input(32);
                    } else if (this.getX() > 400) {
                        this.input(4);
                    } else if (this.iv_forward) {
                        this.input(32);
                    } else {
                        this.input(4);
                    }
                } else if (this.playerState != 6) {
                    if (cv_isDamaging) {
                        this.nextFrame();
                    } else {
                        this.hurtHim(player);
                    }
                }
            } else if (availableHealthPack != null) {
                if (this.collidesWith(availableHealthPack[0], availableHealthPack[1], availableHealthPack[0] + 22, availableHealthPack[1] + 19)) {
                    this.input(64);
                } else if (availableHealthPack[0] < this.getX()) {
                    this.input(4);
                } else {
                    this.input(32);
                }
            } else if (RajuFightClubCanvas.nextInt(10) < 2) {
                this.input(2);
            } else {
                this.input(64);
            }
        } else {
            switch (RajuFightClubCanvas.nextInt(10)) {
                case 1: {
                    this.input(2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.input(64);
                }
                default: {
                    if (this.getX() < 50) {
                        this.input(32);
                        break;
                    }
                    if (this.getX() > 400) {
                        this.input(4);
                        break;
                    }
                    if (this.iv_forward) {
                        this.input(32);
                        break;
                    }
                    this.input(4);
                }
            }
        }
    }

    private void hurtHim(MyPlayer player) {
        if (player.getX() + 27 < this.getX()) {
            if (this.iv_forward) {
                this.iv_forward = false;
                this.setTransform(2);
            }
        } else if (!this.iv_forward) {
            this.iv_forward = true;
            this.setTransform(0);
        }
        if (this.iv_forward) {
            this.setPosition(player.getX() - 35, this.getY());
        } else {
            this.setPosition(player.getX() + 35, this.getY());
        }
        int currentKeys = 6 + RajuFightClubCanvas.nextInt(5);
        if (player.playerState == 2 && RajuFightClubCanvas.nextInt(10) < 3) {
            currentKeys = 8;
        }
        this.playerState = 6;
        if (!player.jumping) {
            if (player.playerState == 2) {
                if (currentKeys == 8) {
                    --player.health;
                }
            } else {
                player.health = currentKeys > 6 ? (player.health -= 2) : --player.health;
            }
        }
        switch (currentKeys) {
            case 6: {
                if (this.playerState == 2) {
                    int[] frq = new int[]{17, 17, 18, 18, 18};
                    this.setFrameSequence(frq);
                    break;
                }
                if (RajuFightClubCanvas.nextInt(100) < 60) {
                    int[] frq = new int[]{8, 8, 9, 9};
                    this.setFrameSequence(frq);
                    break;
                }
                if (RajuFightClubCanvas.nextInt(10) < 3) {
                    int[] frq = new int[]{10, 10, 11, 11, 11};
                    this.setFrameSequence(frq);
                    break;
                }
                int[] frq = new int[]{25, 25, 26, 26, 27, 27};
                this.setFrameSequence(frq);
                break;
            }
            case 7: {
                int[] frq = new int[]{14, 14, 15, 15, 16, 16};
                this.setFrameSequence(frq);
                break;
            }
            case 8: {
                int[] frq = new int[]{17, 17, 18, 18, 18};
                this.setFrameSequence(frq);
                break;
            }
            case 9: {
                if (this.iv_forward) {
                    int[] frq = new int[]{0, 13, 13};
                    this.setFrameSequence(frq);
                    break;
                }
                int[] frq = new int[]{0, 12, 12};
                this.setFrameSequence(frq);
                break;
            }
            case 10: {
                if (this.iv_forward) {
                    int[] frq = new int[]{0, 12, 12};
                    this.setFrameSequence(frq);
                    break;
                }
                int[] frq = new int[]{0, 13, 13};
                this.setFrameSequence(frq);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hit(int weapon, boolean isDucking, boolean forward) {
        int bloodPositionX = this.getX() + 40;
        int bloodPositionY = this.getY() + 30;
        if (this.iv_aiType > 0 && this.ducking) {
            return false;
        }
        if ((this.jumping || this.playerState == 4) && isDucking || this.playerState == 2 && !isDucking && cv_moveType != 3) {
            return false;
        }
        if (forward) {
            if (this.iv_forward) {
                bloodPositionY = this.playerState == 2 || isDucking ? this.getY() + 50 : this.getY() + 30;
                if (this.iv_aiType > 0) {
                    this.health -= 25;
                    RajuFightClubCanvas.score += 15;
                } else {
                    this.health -= 4;
                }
            } else {
                if (this.playerState == 2) return true;
                bloodPositionY = isDucking ? this.getY() + 50 : this.getY() + 30;
                if (this.iv_aiType > 0) {
                    this.health -= 25;
                    RajuFightClubCanvas.score += 15;
                } else {
                    this.health -= 4;
                }
            }
        } else if (!this.iv_forward) {
            bloodPositionY = this.playerState == 2 || isDucking ? this.getY() + 50 : this.getY() + 30;
            if (this.iv_aiType > 0) {
                this.health -= 25;
                RajuFightClubCanvas.score += 15;
            } else {
                this.health -= 4;
            }
        } else {
            if (this.playerState == 2) return true;
            bloodPositionY = isDucking ? this.getY() + 50 : this.getY() + 30;
            if (this.iv_aiType > 0) {
                this.health -= 25;
                RajuFightClubCanvas.score += 15;
            } else {
                this.health -= 4;
            }
        }
        if (this.health <= 0) {
            this.health = 0;
            this.setDeadState(isDucking);
        }
        RajuFightClubCanvas.iv_bloodSprite.setPosition(bloodPositionX, bloodPositionY);
        RajuFightClubCanvas.iv_bloodSprite.paint(RajuFightClubCanvas.g);
        return true;
    }

    boolean hit(int weapon, boolean isDucking) {
        int bloodPositionX = this.getX() + 35;
        int bloodPositionY = this.getY() + 30;
        if (this.iv_aiType > 0) {
            if (weapon != 2 && (this.jumping || this.playerState == 2 && cv_moveType != 3)) {
                return false;
            }
            cv_isDamaging = true;
            switch (cv_moveType) {
                case -1: {
                    if (this.iv_aiType == 1) {
                        this.health -= 30;
                    }
                }
                case 2: {
                    RajuFightClubCanvas.score += 15;
                    if (this.iv_aiType == 4) {
                        this.health -= 2;
                        break;
                    }
                    this.health -= 15;
                    break;
                }
                case 1: {
                    RajuFightClubCanvas.score += 5;
                    if (this.iv_aiType == 4) {
                        --this.health;
                        break;
                    }
                    this.health -= 8;
                    break;
                }
                case 3: {
                    RajuFightClubCanvas.score += 25;
                    if (this.iv_aiType == 4) {
                        this.health -= 4;
                        break;
                    }
                    this.health -= 20;
                }
            }
            if (this.playerState != 1) {
                block6 : switch (this.iv_aiType) {
                    case 1: {
                        int[] frq = new int[]{8, 9, 10, 11, 12};
                        this.setFrameSequence(frq);
                        break;
                    }
                    case 2: {
                        int[] frq = new int[]{12, 12, 12, 13, 13, 13, 14, 14, 15, 15, 16, 16};
                        this.playerState = 6;
                        this.setFrameSequence(frq);
                        break;
                    }
                    case 3: {
                        int[] frq = new int[]{7, 8, 8, 9, 9, 10, 10};
                        this.setFrameSequence(frq);
                        bloodPositionY += 15;
                        break;
                    }
                    case 4: {
                        switch (cv_moveType) {
                            case -1: {
                                int[] frq = new int[]{19, 20, 20, 21, 21};
                                this.setFrameSequence(frq);
                                bloodPositionY += 15;
                                break block6;
                            }
                            case 2: {
                                int[] frq = new int[]{8, 8, 11, 11, 11};
                                this.setFrameSequence(frq);
                                bloodPositionY += 15;
                                break block6;
                            }
                            case 3: {
                                int[] frq = new int[]{17, 17, 18, 18, 18};
                                this.setFrameSequence(frq);
                                bloodPositionY += 15;
                                break block6;
                            }
                        }
                        int[] frq = new int[]{8, 9, 9, 10, 10};
                        this.setFrameSequence(frq);
                        bloodPositionY += 15;
                    }
                }
            }
            RajuFightClubCanvas.iv_bloodSprite.setPosition(bloodPositionX, bloodPositionY);
            RajuFightClubCanvas.iv_bloodSprite.paint(RajuFightClubCanvas.g);
        } else if (weapon == 2) {
            this.health -= 3;
        } else {
            if (this.jumping || cv_moveType != 0) {
                return false;
            }
            this.health -= 3;
        }
        if (this.health <= 0) {
            this.health = 0;
            this.setDeadState(isDucking);
        }
        RajuFightClubCanvas.iv_bloodSprite.setPosition(bloodPositionX, bloodPositionY);
        RajuFightClubCanvas.iv_bloodSprite.paint(RajuFightClubCanvas.g);
        return true;
    }
}

