/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;

class RajuFightClub_SmallCanvas
extends GameCanvas
implements Runnable {
    static int MAP_WIDTH = 128;
    static int SCREEN_WIDTH = 128;
    static int SCREEN_HEIGHT = 160;
    static int MIDX = SCREEN_WIDTH >> 1;
    static int MIDY = SCREEN_HEIGHT >> 1;
    static final int MAIN_MENU = 0;
    static final int PAUSE_MENU = 1;
    static final int OPTIONS_MENU = 2;
    static final int SOUNDS_MENU = 3;
    static final int VIBRATION_MENU = 4;
    static final int CONFIRMATION_MENU = 5;
    static final int START_MENU = 6;
    static final int LANGUAGE_MENU = 7;
    static int language = 2;
    static int score;
    static int barCount;
    static int currentLevel;
    static int gameState;
    private int lastGameState = -1;
    private boolean iv_isPlayerDying;
    private int iv_oldPlayerX;
    private int iv_oldPlayerY;
    static final int SPLASH_STATE = 0;
    static final int MAINMENU_STATE = 1;
    static final int HIGHSCORES_STATE = 2;
    static final int NEWGAME_STATE = 3;
    static final int NEXTLEVEL_STATE = 4;
    static final int UI_STATE = 5;
    static final int ABOUT_STATE = 6;
    static final int HELP_STATE = 7;
    static final int OPENINGCURTAIN_STATE = 8;
    static final int GAMECOMPLETE_STATE = 9;
    static final int DIALOG_STATE = 12;
    static final int PLAYING_STATE = 13;
    static int soundVolume;
    private boolean vibrations = true;
    private boolean paused = false;
    static boolean explode;
    static boolean exploded;
    private boolean usePartnerLogo = true;
    private int menuType;
    private int menuIndex;
    private String[] menuItems;
    private String[] mmenuItems = new String[]{"\u958b\u59cb", "\u9078\u64c7", "\u5206\u6578", "\u5e6b\u52a9", "\u95dc\u65bc", "\u9000\u51fa"};
    private String[] ppmenuItems = new String[]{"*\u7e7c\u7e8c", "\u65b0\u904a\u6232", "\u56de\u4e0a\u9801"};
    private String[] omenuItems = new String[]{"\u8072\u97f3", "\u632f\u52d5", "\u56de\u4e0a\u9801"};
    private String[] soundsItems = new String[]{"\u95dc", "\u4f4e", "\u4e2d", "\u9ad8", "\u56de\u4e0a\u9801"};
    private String[] vibrationItems = new String[]{"\u958b", "\u95dc", "\u56de\u4e0a\u9801"};
    private String[] confirmationItems = new String[]{"\u5426", "\u662f"};
    private String[] pauseMenuItems = new String[]{"\u91cd\u65b0\u958b\u59cb", "\u8072\u97f3", "\u632f\u52d5", "\u4e3b\u76ee\u9304"};
    private String[] mmenuItems1 = new String[]{"\u5f00\u59cb", "\u9009\u62e9", "\u5206\u6570", "\u5e2e\u52a9", "\u5173\u4e8e", "\u9000\u51fa"};
    private String[] ppmenuItems1 = new String[]{"*\u7ee7\u7eed", "\u65b0\u6e38\u620f", "\u56de"};
    private String[] omenuItems1 = new String[]{"\u58f0\u97f3", "\u632f\u52a8", "\u56de"};
    private String[] soundsItems1 = new String[]{"\u5173", "\u4f4e", "\u4e2d", "\u9ad8", "\u56de"};
    private String[] vibrationItems1 = new String[]{"\u5f00", "\u5173", "\u56de"};
    private String[] confirmationItems1 = new String[]{"\u5426", "\u662f"};
    private String[] pauseMenuItems1 = new String[]{"\u91cd\u65b0\u5f00\u59cb", "\u58f0\u97f3", "\u632f\u52a8", "\u4e3b\u76ee\u5f55"};
    private String[] mmenuItems2 = new String[]{"START", "OPTIONS", "HIGHSCORES", "HELP", "ABOUT", "EXIT"};
    private String[] ppmenuItems2 = new String[]{"*CONTINUE", "NEW GAME", "BACK"};
    private String[] omenuItems2 = new String[]{"SOUNDS", "BACK"};
    private String[] soundsItems2 = new String[]{"OFF", "LOW", "MEDIUM", "HIGH", "BACK"};
    private String[] vibrationItems2 = new String[]{"ON", "OFF", "BACK"};
    private String[] confirmationItems2 = new String[]{"NO", "YES"};
    private String[] pauseMenuItems2 = new String[]{"RESUME", "SOUNDS", "MAIN MENU"};
    private JamesFightClub midlet;
    static Graphics g;
    private Thread thread;
    private boolean playing;
    private String exceptionMessage = null;
    private Font systemFont;
    private Font boldFont;
    private String helpText2 = "CONTROLS:~ ~JUMP = 2/UP key.~~LEFT = 4/LEFT key~~RIGHT = 6/RIGHT key~~DUCK/DOWN = 8/DOWN key~~HIGH KICK = 2 AND FIRE key~~LOW KICK = 8 AND FIRE key~~BACK KICK = LEFT/RIGHT AND FIRE key~LOW KICK = LEFT/RIGHT AND FIRE key~~KICK = 5/FIRE key~~PAUSE = RIGHT SOFT key.~";
    private String aboutText2 = " [ABOUT]~  ~James Fight Club 1.0\u00a9 2015. ~ ~ALL RIGHTS RESERVED.~ ~GAME DEVELOPED & PUBLISHED BY Mobi2fun.";
    private String completeText2 = "CONGRATULATIONS!!!~You had finished playing JamesFightClub.";
    Timer timer;
    static final int FRAME_SIZE = 12;
    private BGLayer[] backLayer;
    private MyPlayer player;
    private MyPlayer[] goon;
    public static boolean startGame;
    private Image titleImage = null;
    private Image translucentStrip = null;
    private String[] names = null;
    private int[] scores = new int[5];
    private Image[] iv_headsImage;
    private Image iv_healthPack;
    static Sprite iv_bloodSprite;
    int dir = 1;
    boolean gameOver = false;
    private int traverseIndex = -69;
    private int temp = 20;
    private int iv_curtainStyle;
    int rz2LogoY = 0;
    private int[][] triggerRects;
    private boolean[] triggerFlag;
    private int[][] healthRects;
    private boolean[] healthFlag;
    private int healthDelay = 5000;
    private long[] healthReappearTime;
    private int availableHealthPack;
    private int iv_LevelProgressIndex;
    private long inputDelay = -1L;
    static final int MENU_X;
    private boolean iv_confirmNewGameStart;
    private boolean iv_confirmExit;
    private static int MAX_LENGTH;
    private boolean takeInput;
    private char[] uName = new char[]{' ', ' ', ' ', ' ', ' ', ' '};
    private int nameIndex;
    private int repeatIndex;
    private int lastKey = -1;
    private long keyDelay;
    private static long WAIT_TIME;
    private static final int LSK = -6;
    private static final int RSK = -7;
    private boolean iv_lskPressed;
    static final int BACKGROUNDSOUND = 0;
    static final int PUNCHSOUND = 1;
    static final int ATTACKSOUND = 2;
    static Player[] musicPlayer;
    private RecordStore rs;
    private final int RECORD_SIZE;
    private byte[] rec = new byte[5];
    int fWidth;
    int fHeight;
    int fStripWidth;
    Image imgFont;
    Image imgFontSmall_B;
    Image imgFontSmall_G;
    private Sprite iv_boxCorners;
    private int iv_boxIndex;
    private static final int BOX_SIZE = 130;
    private String[] fSplitText;
    private int fLinesPerPage;
    private int fTotalPages;
    private int fLinesInStringArray;
    private int fCurLine;
    private static final int FT_CUSTOM = 0;
    private static final int FT_SYSTEM = 2;
    private static final int F_SPACE_BETWEEN_LINES = 4;
    private static final int USE = 0;
    private static final int OK = 1;
    private static final int CANCEL = 2;
    private static final int PAUSE = 3;
    private Image[] softKeyLabels;
    Timer loadingTimer;
    BGLoadingTask loadingTask;
    static int seed;

    RajuFightClub_SmallCanvas(JamesFightClub midlet) {
        super(false);
        this.RECORD_SIZE = 5;
        this.setFullScreenMode(true);
        seed = (int)System.currentTimeMillis();
        this.midlet = midlet;
        g = this.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        this.iv_curtainStyle = RajuFightClub_SmallCanvas.nextInt(5);
    }

    void start() {
        this.systemFont = Font.getFont((int)0, (int)0, (int)8);
        this.boldFont = Font.getFont((int)0, (int)1, (int)8);
        this.readRMS();
        this.fillHighScoresData();
        this.initMedia();
        this.playing = true;
        gameState = 0;
        this.createGameAssets();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void createGameAssets() {
        this.getHighScores(this.scores);
        Image image = null;
        try {
            image = Image.createImage((String)"/player.png");
            this.player = new MyPlayer(image, 49, 49, 0);
            this.iv_healthPack = Image.createImage((String)"/h.png");
            this.iv_headsImage = new Image[3];
            this.iv_headsImage[0] = Image.createImage((String)"/ph.png");
            this.iv_headsImage[1] = Image.createImage((String)"/mh.png");
            this.softKeyLabels = new Image[6];
            this.softKeyLabels[0] = Image.createImage((String)"/use.png");
            this.softKeyLabels[1] = Image.createImage((String)"/ok.png");
            this.softKeyLabels[2] = Image.createImage((String)"/cancel.png");
            this.softKeyLabels[3] = Image.createImage((String)"/pause.png");
            this.softKeyLabels[4] = Image.createImage((String)"/up.png");
            this.softKeyLabels[5] = Image.createImage((String)"/down.png");
            this.iv_boxCorners = new Sprite(Image.createImage((String)"/box.png"), 8, 8);
            this.goon = new MyPlayer[3];
            this.goon[0] = new MyPlayer(Image.createImage((String)"/e1.png"), 40, 56, 2);
            this.goon[1] = new MyPlayer(Image.createImage((String)"/e2.png"), 27, 41, 1);
            this.goon[2] = new MyPlayer(Image.createImage((String)"/e3.png"), 40, 55, 3);
            iv_bloodSprite = new Sprite(Image.createImage((String)"/bld.png"), 15, 16);
        }
        catch (IOException ex) {
            System.out.println("error while creating gameAssets");
            this.exceptionMessage = "In createGameAssets: " + ex.getMessage();
            ex.printStackTrace();
        }
        image = null;
        try {
            this.titleImage = this.usePartnerLogo ? Image.createImage((String)"/partnerLogo.png") : Image.createImage((String)"/lg.png");
            this.translucentStrip = Image.createImage((String)"/b.png");
        }
        catch (IOException ex) {
            this.exceptionMessage = "Code:003" + ex.getMessage();
            ex.printStackTrace();
        }
    }

    void resetGameAssets() {
        this.player.health = 50;
        this.goon = new MyPlayer[3];
        try {
            this.goon[0] = new MyPlayer(Image.createImage((String)"/e1.png"), 40, 56, 2);
            this.goon[1] = new MyPlayer(Image.createImage((String)"/e2.png"), 27, 41, 1);
            this.goon[2] = new MyPlayer(Image.createImage((String)"/e3.png"), 40, 55, 3);
        }
        catch (IOException ex) {
            this.exceptionMessage = "Code:003" + ex.getMessage();
            ex.printStackTrace();
        }
    }

    public void run() {
        int timeStep = 50;
        while (this.playing) {
            long start = System.currentTimeMillis();
            try {
                this.gameLoop();
            }
            catch (Exception e) {
                g.setColor(0);
                g.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
                g.setColor(0xFFFFFF);
                g.drawString("Err: " + e.getMessage(), 0, 5, 0);
                g.drawString("Ex: " + e, 0, 20, 0);
                e.printStackTrace();
            }
            this.flushGraphics();
            long end = System.currentTimeMillis();
            int duration = (int)(end - start);
            if (duration < timeStep) {
                try {
                    Thread.sleep(timeStep - duration);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    this.exceptionMessage = "001:" + ie.getMessage();
                    this.playing = false;
                }
                continue;
            }
            RajuFightClub_SmallCanvas rajuFightClub_SmallCanvas = this;
            rajuFightClub_SmallCanvas.thread.yield();
        }
    }

    void gameLoop() {
        switch (gameState) {
            case 0: {
                ++this.traverseIndex;
                if (this.traverseIndex < -40) {
                    switch (this.iv_curtainStyle) {
                        case 0: {
                            g.setClip(0, 0, this.temp, SCREEN_HEIGHT);
                            g.drawImage(this.titleImage, MIDX, MIDY, 3);
                            g.setClip(SCREEN_WIDTH - this.temp, 0, this.temp, SCREEN_HEIGHT);
                            this.temp += SCREEN_WIDTH / 30;
                            break;
                        }
                        case 2: {
                            g.setClip(0, MIDY - this.temp, SCREEN_WIDTH, this.temp << 1);
                            this.temp += SCREEN_HEIGHT / 30;
                            break;
                        }
                        case 3: {
                            g.setClip(MIDX - this.temp, 0, this.temp << 1, SCREEN_HEIGHT);
                            this.temp += SCREEN_WIDTH / 30;
                        }
                        default: {
                            g.setClip(MIDX - this.temp, MIDY - this.temp, this.temp << 1, this.temp << 1);
                            this.temp += SCREEN_HEIGHT / 30;
                        }
                    }
                    g.drawImage(this.titleImage, MIDX, MIDY, 3);
                    break;
                }
                if (this.traverseIndex >= -40 && this.traverseIndex < 0) {
                    g.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
                    try {
                        this.titleImage = Image.createImage((String)"/ms.png");
                    }
                    catch (Exception ex) {
                        System.out.println("cant find menuscreen");
                        ex.printStackTrace();
                    }
                    g.drawImage(this.titleImage, 0, 0, 0);
                    break;
                }
                if (this.traverseIndex == 0) {
                    try {
                        this.titleImage = Image.createImage((String)"/menu.png");
                    }
                    catch (Exception ex) {
                        System.out.println("cant find menuscreen");
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.traverseIndex > 30 && this.traverseIndex < 83) {
                    g.drawImage(this.titleImage, 0, 0, 0);
                    break;
                }
                g.drawImage(this.titleImage, 0, 0, 0);
                score = 0;
                barCount = 0;
                this.traverseIndex = 0;
                this.temp = 0;
                this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                this.menuType = 0;
                this.keyDelay = System.currentTimeMillis() + 200L;
                gameState = 1;
                if (soundVolume <= 0 || musicPlayer[0].getState() == 400) break;
                try {
                    musicPlayer[0].start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 6: 
            case 7: {
                if (!this.drawTextBox()) break;
                this.keyDelay = System.currentTimeMillis() + 200L;
                gameState = 1;
                this.iv_lskPressed = false;
                break;
            }
            case 2: {
                g.drawImage(this.titleImage, 0, 0, 0);
                if (this.names == null) {
                    this.names = this.getHighScores(this.scores);
                }
                if (!this.paintBox()) break;
                for (int i = 0; i < 5; ++i) {
                    if (this.scores[i] <= 0) continue;
                    g.setFont(this.systemFont);
                    g.drawString(this.names[i], 15, 50 + i * 12 + 6, 20);
                    g.drawString("" + this.scores[i], 110, 50 + i * 12 + 6, 24);
                }
                this.drawSplitText(SCREEN_WIDTH / 2, 25, 17, 2, 0xFFFFFF, SCREEN_HEIGHT - 85);
                this.drawSoftKeyLabels(this.softKeyLabels[1], null);
                int key = this.getKeyStates();
                if (this.inputDelay < System.currentTimeMillis()) {
                    this.inputDelay = System.currentTimeMillis() + 50L;
                    key = this.getKeyStates();
                    if ((key & 2) != 0) {
                        key = -1;
                    } else if ((key & 0x40) != 0) {
                        key = 1;
                    } else if ((key & 0x100) != 0) {
                        key = -5;
                    }
                }
                if (key != -5 && !this.iv_lskPressed) break;
                this.menuIndex = 0;
                this.paused = false;
                this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                this.menuType = 0;
                this.keyDelay = System.currentTimeMillis() + 200L;
                gameState = 1;
                this.names = null;
                this.iv_lskPressed = false;
                this.getKeyStates();
                break;
            }
            case 5: {
                g.drawImage(this.titleImage, 0, 0, 0);
                if (!this.paintBox()) break;
                g.setColor(13696250);
                g.setFont(this.systemFont);
                this.drawSplitText(SCREEN_WIDTH / 2, 20, 17, 2, 0xFFFFFF, SCREEN_HEIGHT - 35);
                if (this.nameIndex < MAX_LENGTH - 1 && this.uName[this.nameIndex] != ' ' && this.keyDelay < System.currentTimeMillis()) {
                    ++this.nameIndex;
                    this.repeatIndex = 0;
                }
                g.drawRect(MIDX - 40, MIDY + 30, 70, 15);
                g.setFont(this.boldFont);
                String nameStr = new String(this.uName);
                g.drawString(nameStr, MIDX - 35, MIDY + 33, 0);
                if (this.nameIndex > 0) {
                    this.drawSoftKeyLabels(this.softKeyLabels[1], this.softKeyLabels[2]);
                    g.drawString("_", MIDX - 35 + this.boldFont.charsWidth(this.uName, 0, this.nameIndex), MIDY + 30, 0);
                } else {
                    g.drawString("_", MIDX - 35, MIDY + 30, 0);
                }
                if (this.takeInput) break;
                this.updateHighScores();
                this.takeInput = false;
                this.names = null;
                this.fLinesInStringArray = language == 0 ? this.splitText("\u5206\u6578", SCREEN_WIDTH - 20, 0) : (language == 1 ? this.splitText("\u5206\u6570", SCREEN_WIDTH - 20, 0) : this.splitText("HIGHSCORES", SCREEN_WIDTH - 10, 0));
                this.fCurLine = 0;
                this.iv_boxIndex = 0;
                this.iv_lskPressed = false;
                gameState = 2;
                this.paused = false;
                this.menuIndex = 0;
                this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                this.ppmenuItems2[0] = "*";
                this.menuType = 0;
                break;
            }
            case 1: {
                g.translate(-g.getTranslateX(), -g.getTranslateY());
                g.drawImage(this.titleImage, 0, 0, 0);
                if (this.menuType == 5) {
                    if (this.iv_confirmNewGameStart) {
                        g.drawString("YOU WILL LOSE YOUR", MIDX, 2, 17);
                        g.drawString("CURRENT PROGRESS!", MIDX, 18, 17);
                    } else {
                        g.drawString("ARE U SURE?", MIDX, 18, 17);
                    }
                } else if (this.paused && this.menuType != 0) {
                    g.drawString("GAME PAUSED", MIDX, 18, 17);
                }
                this.animateMainMenu();
                this.drawSoftKeyLabels(this.softKeyLabels[1], null);
                break;
            }
            case 3: {
                currentLevel = 1;
                score = 0;
                this.fCurLine = 0;
                this.iv_boxIndex = 0;
                this.resetGameAssets();
                g.translate(-g.getTranslateX(), -g.getTranslateY());
                this.loadBackLayer();
                gameState = 4;
            }
            case 4: {
                this.gameOver = false;
                try {
                    musicPlayer[0].stop();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                if (this.loadingTask.layersLoaded > 0) {
                    this.createLevelAssets();
                    gameState = 8;
                    this.iv_curtainStyle = RajuFightClub_SmallCanvas.nextInt(5);
                    this.temp = 0;
                    this.traverseIndex = 0;
                    this.getKeyStates();
                    break;
                }
                if (language == 0) {
                    g.drawString("\u8f09\u5165\u4e2d...", MIDX, SCREEN_HEIGHT - 10, 33);
                    break;
                }
                if (language == 1) {
                    g.drawString("\u9ad4\u5165\u4e2d...", MIDX, SCREEN_HEIGHT - 10, 33);
                    break;
                }
                g.drawString("Loading...", SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, 17);
                break;
            }
            case 8: {
                ++this.traverseIndex;
                if (this.traverseIndex < 30) {
                    switch (this.iv_curtainStyle) {
                        case 0: {
                            g.setClip(0, 0, this.temp, SCREEN_HEIGHT);
                            this.paintBg();
                            this.player.paint(g);
                            g.setClip(SCREEN_WIDTH - this.temp, 0, this.temp, SCREEN_HEIGHT);
                            this.temp += SCREEN_WIDTH / 30;
                            break;
                        }
                        case 1: {
                            g.setClip(0, 0, SCREEN_WIDTH, this.temp);
                            this.paintBg();
                            this.player.paint(g);
                            g.setClip(0, SCREEN_HEIGHT - this.temp, SCREEN_WIDTH, this.temp);
                            this.temp += SCREEN_WIDTH / 30;
                            break;
                        }
                        case 2: {
                            g.setClip(0, MIDY - this.temp, SCREEN_WIDTH, this.temp << 1);
                            this.temp += SCREEN_HEIGHT / 30;
                            break;
                        }
                        case 3: {
                            g.setClip(MIDX - this.temp, 0, this.temp << 1, SCREEN_HEIGHT);
                            this.temp += SCREEN_WIDTH / 30;
                        }
                        default: {
                            g.setClip(MIDX - this.temp, MIDY - this.temp, this.temp << 1, this.temp << 1);
                            this.temp += SCREEN_HEIGHT / 30;
                        }
                    }
                    this.paintBg();
                    this.player.paint(g);
                    break;
                }
                this.getKeyStates();
                if (currentLevel == 4) {
                    g.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
                    this.paintLevelAssets(0);
                    int x = -g.getTranslateX();
                    int y = -g.getTranslateY();
                    g.translate(x, y);
                    this.paintBg();
                    this.player.paint(g);
                    gameState = 13;
                    break;
                }
                gameState = 13;
                break;
            }
            case 13: {
                try {
                    int i = this.getKeyStates();
                    if (i != 0) {
                        this.iv_lskPressed = false;
                    }
                    if (this.player.input(i)) {
                        switch (RajuFightClub_SmallCanvas.nextInt(20)) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (currentLevel == 4) {
                                    if (language == 0) {
                                        this.fLinesInStringArray = this.splitText("\u76e1\u53ef\u80fd\u5730\u5c0d\u6297\u548c\u6bba\u6b7b\u6240\u6709\u7684\u6575\u4eba.\u5343\u842c\u4e0d\u8981\u8b93\u4ed6\u9078\u64c7\u751f\u547d\u503c.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    if (language == 1) {
                                        this.fLinesInStringArray = this.splitText("\u5c3d\u53ef\u80fd\u5730\u5bf9\u6297\u548c\u6740\u6b7b\u6240\u6709\u7684\u654c\u4eba.\u5343\u4e07\u4e0d\u8981\u8ba9\u4ed6\u9009\u62e9\u751f\u547d\u503c.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    this.fLinesInStringArray = this.splitText("Try again and kill the villain. And dont let him pick the health.~Enter Your name:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                if (language == 0) {
                                    this.fLinesInStringArray = this.splitText("\u4e0d\u8981\u8f15\u6613\u6b7b\u6389!~\u4f7f\u7528\u8e22\u7684\u52d5\u4f5c\u53ef\u5f97\u5230\u66f4\u591a\u7684\u6bba\u50b7\u529b\u53ca\u5206\u6578.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                if (language == 1) {
                                    this.fLinesInStringArray = this.splitText("\u4e0d\u8981\u8f7b\u6613\u6b7b\u6389!~\u4f7f\u7528\u8e22\u7684\u52a8\u4f5c\u53ef\u5f97\u5230\u66f4\u591a\u7684\u6740\u4f24\u529b\u53ca\u5206\u6570.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                this.fLinesInStringArray = this.splitText("Use action kicks for more damage and score.~Enter Your name:", SCREEN_WIDTH + 30, 0);
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: {
                                if (currentLevel == 4) {
                                    if (language == 0) {
                                        this.fLinesInStringArray = this.splitText("\u76e1\u53ef\u80fd\u5730\u79fb\u52d5.\u5343\u842c\u4e0d\u8981\u8b93\u4ed6\u9078\u64c7\u751f\u547d\u503c.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    if (language == 1) {
                                        this.fLinesInStringArray = this.splitText("\u5c3d\u53ef\u80fd\u5730\u79fb\u52a8.\u5343\u4e07\u4e0d\u8981\u8ba9\u4ed6\u9009\u62e9\u751f\u547d\u503c.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    this.fLinesInStringArray = this.splitText("Try your best moves. And dont let him pick the health.~Enter Your name:", SCREEN_WIDTH + 25, 0);
                                    break;
                                }
                                if (language == 0) {
                                    this.fLinesInStringArray = this.splitText("\u5c0f\u5fc3!~\u5728\u653b\u64ca\u4e4b\u9593\u4f60\u53ef\u4ee5\u501f\u8457\u6309\u76f8\u53cd~\u7684\u65b9\u5411\u5c31\u53ef\u4f7f\u7528\u81ea\u52d5\u7684\u8ff4\u8e22.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                if (language == 1) {
                                    this.fLinesInStringArray = this.splitText("\u5c0f\u5fc3 !~\u5728\u653b\u51fb\u4e4b\u95f4\u4f60\u53ef\u4ee5\u501f\u7740\u6309\u76f8\u53cd\u7684\u65b9\u5411\u5c31\u53ef\u4f7f\u7528\u81ea\u52a8\u7684\u56de\u8e22.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                this.fLinesInStringArray = this.splitText("You can use autoBackKick by pressing opposite direction.~Enter Your name:", SCREEN_WIDTH + 25, 0);
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 9: {
                                if (currentLevel == 4) {
                                    if (language == 0) {
                                        this.fLinesInStringArray = this.splitText("\u73fe\u5728\u8ab0\u5c07\u4f86\u62ef\u6551\u4f60\u7684\u738b\u570b~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0);
                                        break;
                                    }
                                    if (language == 1) {
                                        this.fLinesInStringArray = this.splitText("\u73b0\u5728\u8c01\u5c06\u6765\u62ef\u6551\u4f60\u7684\u738b\u56fd?~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0);
                                        break;
                                    }
                                    this.fLinesInStringArray = this.splitText("Now, who will save your kingdom?~ ~Enter Your name:", SCREEN_WIDTH + 25, 0);
                                    break;
                                }
                                if (language == 0) {
                                    this.fLinesInStringArray = this.splitText("\u5c0f\u5fc3\u4f60\u6575\u4eba\u7684\u52d5\u4f5c ~\u4f7f\u7528\u4e0b\u8e22\u53bb\u50b7\u5bb3\u6216\u9583\u907f\u6575\u4eba.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0);
                                    break;
                                }
                                if (language == 1) {
                                    this.fLinesInStringArray = this.splitText("\u5c0f\u5fc3\u4f60\u654c\u4eba\u7684\u52a8\u4f5c!~\u4f7f\u7528\u4e0b\u8e22\u53bb\u4f24\u5bb3\u6216\u95ea\u907f\u654c\u4eba.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0);
                                    break;
                                }
                                this.fLinesInStringArray = this.splitText("Use low kick to hurt ducking enemy.~Enter Your name:", SCREEN_WIDTH + 25, 0);
                                break;
                            }
                            default: {
                                if (currentLevel == 4) {
                                    if (language == 0) {
                                        this.fLinesInStringArray = this.splitText("\u76e1\u53ef\u80fd\u5730\u5c0d\u6297\u548c\u6bba\u6b7b\u6240\u6709\u7684\u6575\u4eba.\u5343\u842c\u4e0d\u8981\u8b93\u4ed6\u9078\u64c7\u751f\u547d\u503c.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    if (language == 1) {
                                        this.fLinesInStringArray = this.splitText("\u5c3d\u53ef\u80fd\u5730\u5bf9\u6297\u548c\u6740\u6b7b\u6240\u6709\u7684\u654c\u4eba.\u5343\u4e07\u4e0d\u8981\u8ba9\u4ed6\u9009\u62e9\u751f\u547d\u503c.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 30, 0);
                                        break;
                                    }
                                    this.fLinesInStringArray = this.splitText("Try again and kill the villain. And dont let him pick the health.~Enter Your name:", SCREEN_WIDTH + 30, 0);
                                    break;
                                }
                                this.fLinesInStringArray = language == 0 ? this.splitText("\u5225\u8b93\u4f60\u81ea\u5df1\u88ab\u6bba\u5230!~\u8981\u5c0d\u6297\u5f13\u7bad\u624b\u8ff4\u8e22\u662f\u5f88\u6709\u6548\u7684.~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0) : (language == 1 ? this.splitText("\u522b\u8ba9\u4f60\u81ea\u5df1\u88ab\u6740\u5230! ~\u8981\u5bf9\u6297\u5f13\u7bad\u624b\u56de\u8e22\u662f\u5f88\u6709\u6548\u7684.~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0) : this.splitText("Back Kick is very effective against the Enemy.~Enter Your name:", SCREEN_WIDTH + 25, 0));
                            }
                        }
                        this.fCurLine = 0;
                        this.iv_boxIndex = 0;
                        g.translate(-g.getTranslateX(), -g.getTranslateY());
                        gameState = 5;
                        this.getKeyStates();
                        this.iv_lskPressed = false;
                        this.takeInput = true;
                        break;
                    }
                    if (!this.gameOver) {
                        this.updateScrolling();
                        this.paintBg();
                        this.paintLevelAssets(i);
                        break;
                    }
                    this.gameOver();
                }
                catch (Exception e) {
                    System.out.println("problem");
                    e.printStackTrace();
                }
                break;
            }
        }
        if (!this.paused) {
            this.lastGameState = gameState;
        }
    }

    private void paintLevelAssets(int states) {
        switch (currentLevel) {
            case 1: {
                int i;
                for (i = this.triggerRects.length - 1; i >= 0; --i) {
                    if (!this.triggerFlag[i] || !this.player.collidesWith(this.triggerRects[i][0], this.triggerRects[i][1], this.triggerRects[i][2], this.triggerRects[i][3])) continue;
                    currentLevel = 3;
                    this.writeRMS();
                    this.fCurLine = 0;
                    this.iv_boxIndex = 0;
                    g.translate(-g.getTranslateX(), -g.getTranslateY());
                    this.getKeyStates();
                    this.loadBackLayer();
                    gameState = 4;
                    this.triggerFlag[i] = false;
                    break;
                }
                for (i = this.healthRects.length - 1; i >= 0; --i) {
                    if (!this.healthFlag[i]) continue;
                    g.drawImage(this.iv_healthPack, this.healthRects[i][0], this.healthRects[i][1], 0);
                    if (this.player.health >= 50 || !this.player.collidesWith(this.healthRects[i][0] + 30, this.healthRects[i][1], this.healthRects[i][0], this.healthRects[i][1])) continue;
                    g.drawImage(this.softKeyLabels[5], -g.getTranslateX() + MIDX, -g.getTranslateY() + SCREEN_HEIGHT - 2, 33);
                    if ((states & 0x40) == 0 || (states & 0x100) != 0) break;
                    this.player.health = 50;
                    this.healthFlag[i] = false;
                    break;
                }
                if (this.player.playerState == 6) {
                    this.processGoons();
                    this.player.paint(g);
                } else {
                    this.player.paint(g);
                    this.processGoons();
                }
                this.drawSoftKeyLabels(null, this.softKeyLabels[3]);
                break;
            }
            case 3: {
                int i;
                int offsetX = -g.getTranslateX();
                for (i = this.triggerRects.length - 1; i >= 0; --i) {
                    if (!this.triggerFlag[i] || !this.player.collidesWith(this.triggerRects[i][0], this.triggerRects[i][1], this.triggerRects[i][2], this.triggerRects[i][3])) continue;
                    currentLevel = 4;
                    this.writeRMS();
                    this.fCurLine = 0;
                    this.iv_boxIndex = 0;
                    g.translate(-g.getTranslateX(), -g.getTranslateY());
                    this.getKeyStates();
                    this.iv_lskPressed = false;
                    this.loadBackLayer();
                    gameState = 4;
                    this.triggerFlag[i] = false;
                }
                if (this.player.playerState == 6) {
                    this.processGoons();
                    this.player.paint(g);
                } else {
                    this.player.paint(g);
                    this.processGoons();
                }
                for (i = this.healthRects.length - 1; i >= 0; --i) {
                    if (!this.healthFlag[i]) continue;
                    g.drawImage(this.iv_healthPack, this.healthRects[i][0], this.healthRects[i][1], 0);
                    if (this.player.health >= 50 || !this.player.collidesWith(this.healthRects[i][0], this.healthRects[i][1], this.healthRects[i][0] + this.iv_healthPack.getWidth(), this.healthRects[i][1])) continue;
                    if (this.healthRects[i][1] < this.player.getY() + this.player.getHeight() / 2) {
                        g.drawImage(this.softKeyLabels[4], -g.getTranslateX() + MIDX, -g.getTranslateY() + SCREEN_HEIGHT - 2, 33);
                        if ((states & 2) == 0 || (states & 0x100) != 0) break;
                        this.player.health = 50;
                        this.healthFlag[i] = false;
                        break;
                    }
                    g.drawImage(this.softKeyLabels[5], -g.getTranslateX() + MIDX, -g.getTranslateY() + SCREEN_HEIGHT - 2, 33);
                    if ((states & 0x40) == 0 || (states & 0x100) != 0) break;
                    this.player.health = 50;
                    this.healthFlag[i] = false;
                    break;
                }
                this.drawSoftKeyLabels(null, this.softKeyLabels[3]);
                break;
            }
            case 4: {
                if (this.player.getX() < 50) {
                    this.player.setPosition(50, this.player.getY());
                } else if (this.player.getX() > 480) {
                    this.player.setPosition(480, this.player.getY());
                }
                if (this.player.playerState == 6 || this.goon[0].health <= 0) {
                    this.processReddy();
                    this.player.paint(g);
                } else {
                    this.player.paint(g);
                    this.processReddy();
                }
                this.availableHealthPack = -1;
                for (int i = this.healthRects.length - 1; i >= 0; --i) {
                    if (this.healthFlag[i]) {
                        this.availableHealthPack = i;
                        g.drawImage(this.iv_healthPack, this.healthRects[i][0], this.healthRects[i][1], 0);
                        if (this.player.health < 50 && this.player.collidesWith(this.healthRects[i][0], this.healthRects[i][1], this.healthRects[i][0] + 22, this.healthRects[i][1] + 19)) {
                            g.drawImage(this.softKeyLabels[5], -g.getTranslateX() + MIDX, -g.getTranslateY() + SCREEN_HEIGHT - 2, 33);
                            if ((states & 0x40) == 0 || (states & 0x100) != 0) break;
                            this.player.health = 50;
                            this.healthFlag[i] = false;
                            this.availableHealthPack = -1;
                            this.healthReappearTime[i] = System.currentTimeMillis() + (long)this.healthDelay;
                            break;
                        }
                        if (this.availableHealthPack < 0 || this.goon[0].health >= 50 || !this.goon[0].collidesWith(this.healthRects[i][0], this.healthRects[i][1], this.healthRects[i][0] + 22, this.healthRects[i][1] + 19)) continue;
                        g.drawImage(this.softKeyLabels[5], -g.getTranslateX() + MIDX, -g.getTranslateY() + SCREEN_HEIGHT - 2, 33);
                        if (this.goon[0].playerState != 2) break;
                        this.goon[0].health = 50;
                        this.healthFlag[i] = false;
                        this.healthReappearTime[i] = System.currentTimeMillis() + (long)this.healthDelay;
                        break;
                    }
                    if (currentLevel != 4 || this.healthReappearTime[i] >= System.currentTimeMillis()) continue;
                    this.healthDelay += 1000;
                    if (this.healthDelay > 20000) {
                        this.healthDelay = 20000;
                    }
                    this.healthFlag[i] = true;
                }
                if (this.goon[0].health <= 0 && this.player.collidesWith(MAP_WIDTH - 50, SCREEN_HEIGHT - 90, MAP_WIDTH, SCREEN_HEIGHT)) {
                    this.gameOver = true;
                    this.gameOver();
                } else if (this.gameOver) {
                    this.gameOver();
                } else if (this.player.health <= 0 && this.player.playerState != 5) {
                    this.player.setDeadState(false);
                }
                this.drawSoftKeyLabels(null, this.softKeyLabels[3]);
            }
        }
    }

    private void processReddy() {
        MyPlayer.cv_isTakingDamage = 0;
        boolean playerUnderAttack = false;
        if (this.goon[0].health > 0 && this.player.collidesWith(this.goon[0].getX(), this.goon[0].getY(), this.goon[0].getX() + this.goon[0].getWidth(), this.goon[0].getY() + this.goon[0].getHeight())) {
            playerUnderAttack = true;
        }
        this.goon[0].aiReddy(this.availableHealthPack < 0 ? null : this.healthRects[this.availableHealthPack], this.player, playerUnderAttack);
        this.goon[0].paint(g);
        if (this.player.playerState == 6 && !MyPlayer.cv_isDamaging && this.goon[0].playerState != 5 && this.player.collidesWith(this.goon[0], false)) {
            if (this.player.getX() + 27 <= this.goon[0].getX()) {
                if (this.player.iv_forward) {
                    if (MyPlayer.cv_moveType != -1) {
                        this.goon[0].hit(1, this.player.ducking);
                    }
                } else if (MyPlayer.cv_moveType == -1) {
                    this.goon[0].hit(1, this.player.ducking);
                }
            } else if (this.player.iv_forward) {
                if (MyPlayer.cv_moveType == -1) {
                    this.goon[0].hit(1, this.player.ducking);
                }
            } else if (MyPlayer.cv_moveType != -1) {
                this.goon[0].hit(1, this.player.ducking);
            }
        }
        this.paintHud(playerUnderAttack);
    }

    private void processGoons() {
        int i;
        MyPlayer.cv_isTakingDamage = 0;
        boolean playerUnderAttack = false;
        int attackingGoon = -1;
        int offsetX = -g.getTranslateX();
        int offsetY = -g.getTranslateY();
        int px1 = this.player.getX();
        for (i = this.goon.length - 1; i >= 0; --i) {
            if (this.goon[i].health <= 0 || !this.player.collidesWith(this.goon[i].getX(), this.goon[i].getY(), this.goon[i].getX() + this.goon[i].getWidth(), this.goon[i].getY() + this.goon[i].getHeight())) continue;
            playerUnderAttack = true;
            attackingGoon = i;
            MyPlayer.cv_isTakingDamage = px1 + this.player.frameWidth / 2 <= this.goon[attackingGoon].getX() ? 1 : -1;
            if (this.player.playerState == 5 || this.goon[i].isAiDamaging || this.goon[i].playerState != 6) break;
            this.goon[i].isAiDamaging = true;
            this.player.hit(1, this.goon[i].ducking);
            break;
        }
        if (currentLevel == 4) {
            this.goon[0].aiReddy(this.availableHealthPack < 0 ? null : this.healthRects[this.availableHealthPack], this.player, playerUnderAttack);
            this.goon[0].paint(g);
            g.setColor(0xFF0000);
            g.fillRect(this.goon[0].getX(), this.goon[0].getY() - 5, 25, 3);
            g.setColor(65280);
            g.fillRect(this.goon[0].getX(), this.goon[0].getY() - 5, this.goon[0].health / 2, 3);
        } else {
            for (i = this.goon.length - 1; i >= 0; --i) {
                if (!this.goon[i].collidesWith(offsetX - 20, offsetY, offsetX + SCREEN_WIDTH + 20, offsetY + SCREEN_HEIGHT)) continue;
                this.goon[i].ai(px1, i == attackingGoon ? false : playerUnderAttack);
                if (this.goon[i].health > 0) {
                    g.setColor(0xFF0000);
                    g.fillRect(this.goon[i].getX(), this.goon[i].getY() - 5, 25, 3);
                    g.setColor(65280);
                    g.fillRect(this.goon[i].getX(), this.goon[i].getY() - 5, this.goon[i].health / 2, 3);
                }
                this.goon[i].paint(g);
                this.goon[i].isVisible = true;
            }
            for (i = this.goon.length - 1; i >= 0; --i) {
                if (!this.goon[i].collidesWith(px1 - 200, offsetY, px1 - 180, offsetY + SCREEN_HEIGHT)) continue;
                this.goon[i].reset(px1);
            }
        }
        if (this.player.playerState == 6 && !MyPlayer.cv_isDamaging && attackingGoon >= 0 && this.goon[attackingGoon].playerState != 5 && this.player.collidesWith(this.goon[attackingGoon], false)) {
            if (px1 + this.player.frameWidth / 2 <= this.goon[attackingGoon].getX()) {
                if (this.player.iv_forward) {
                    this.goon[attackingGoon].hit(1, this.player.ducking);
                }
            } else if (!this.player.iv_forward) {
                this.goon[attackingGoon].hit(1, this.player.ducking);
            }
        }
        this.paintHud(playerUnderAttack);
    }

    private void paintHud(boolean playerUnderAttack) {
        if (playerUnderAttack) {
            g.setColor(153 + RajuFightClub_SmallCanvas.nextSignedInt(50), 34 + RajuFightClub_SmallCanvas.nextSignedInt(20), 34 + RajuFightClub_SmallCanvas.nextSignedInt(20));
        } else {
            g.setColor(0x11AA11);
        }
        int offsetX = -g.getTranslateX();
        int offsetY = -g.getTranslateY();
        g.fillRoundRect(offsetX + 2, offsetY + 2, this.iv_headsImage[0].getWidth(), this.iv_headsImage[0].getHeight(), 5, 5);
        g.drawImage(this.iv_headsImage[0], offsetX + 2, offsetY + 2, 0);
        g.setColor(0);
        g.setColor(0xFF0000);
        g.fillRoundRect(offsetX + 25, offsetY + 3, 25, 4, 1, 1);
        g.setColor(65280);
        g.fillRoundRect(offsetX + 25, offsetY + 3, this.player.health / 2, 4, 1, 1);
        String scoreString = "" + score;
        g.setFont(this.systemFont);
        int strHeight = this.systemFont.getHeight();
        int strWidth = this.systemFont.charsWidth(scoreString.toCharArray(), 0, scoreString.length());
        g.setColor(16759055);
        g.drawRoundRect(offsetX + 25, offsetY + 10, strWidth + 14, strHeight + 4, 3, 3);
        g.setColor(0);
        g.fillRoundRect(offsetX + 26, offsetY + 11, strWidth + 13, strHeight + 3, 3, 3);
        g.setColor(16759055);
        g.drawString(scoreString, offsetX + 33, offsetY + 12, 0);
        if (currentLevel == 4) {
            g.drawImage(this.iv_headsImage[1], offsetX + SCREEN_WIDTH - 2, offsetY + 2, 24);
            g.setColor(0);
            g.setColor(0xFF0000);
            g.fillRoundRect(offsetX + 90 + SCREEN_WIDTH - 139, offsetY + 3, 25, 4, 1, 1);
            g.setColor(65280);
            g.fillRoundRect(offsetX + 90 + SCREEN_WIDTH - 139 + (25 - this.goon[0].health / 2), offsetY + 3, this.goon[0].health / 2, 4, 1, 1);
        }
    }

    private void updateScrolling() {
        int diffX = 0;
        int px = this.player.getX() + (this.player.frameWidth >> 1);
        int diffY = 0;
        int py = this.player.getY() - 20;
        if (px >= MIDX) {
            diffX = MIDX - px;
        }
        if (currentLevel < 2 && py > MIDY) {
            diffY = MIDY - py;
        } else if (this.player.getY() > SCREEN_HEIGHT) {
            this.fLinesInStringArray = language == 0 ? this.splitText("\u5225\u6389\u5165\u7aaa\u5751\u88e1!~\u505a\u4e00\u8dd1\u8df3\u52d5\u4f5c.~ ~ ~\u8f38\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0) : (language == 1 ? this.splitText("\u522b\u6389\u5165\u6d3c\u5751\u91cc! ~\u505a\u4e00\u8dd1\u8df3\u52a8\u4f5c.~ ~ ~\u8f93\u5165\u4f60\u7684\u540d\u5b57:", SCREEN_WIDTH + 20, 0) : this.splitText("Dont fall in the pit!~Take a running jump.~Enter your name:", SCREEN_WIDTH + 20, 0));
            this.fCurLine = 0;
            this.iv_boxIndex = 0;
            g.translate(-g.getTranslateX(), -g.getTranslateY());
            gameState = 5;
            this.getKeyStates();
            this.iv_lskPressed = false;
            this.takeInput = true;
            return;
        }
        g.translate(diffX - g.getTranslateX(), diffY - g.getTranslateY());
        int offsetX = -g.getTranslateX();
        if (offsetX + SCREEN_WIDTH > MAP_WIDTH) {
            g.translate(offsetX + SCREEN_WIDTH - MAP_WIDTH, 0);
        }
    }

    private void gameOver() {
        this.fLinesInStringArray = this.splitText(this.completeText2, SCREEN_WIDTH, 0);
        this.fCurLine = 0;
        this.iv_boxIndex = 0;
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        this.getKeyStates();
        gameState = 5;
        this.takeInput = true;
    }

    private void createLevelAssets() {
        Object image = null;
        this.iv_LevelProgressIndex = 0;
        switch (currentLevel) {
            case 1: {
                int i;
                int[][] triggerRects = new int[][]{{MAP_WIDTH - 24, 84, MAP_WIDTH + 48, 216}};
                this.triggerRects = triggerRects;
                this.triggerFlag = new boolean[triggerRects.length];
                for (int i2 = this.triggerFlag.length - 1; i2 >= 0; --i2) {
                    this.triggerFlag[i2] = true;
                }
                int[][] healthRects = new int[][]{{252, SCREEN_HEIGHT - 36}, {612, SCREEN_HEIGHT - 36}, {864, SCREEN_HEIGHT - 36}, {1104, SCREEN_HEIGHT - 36}, {1440, SCREEN_HEIGHT - 36}, {1680, SCREEN_HEIGHT - 36}};
                this.healthRects = healthRects;
                this.healthFlag = new boolean[healthRects.length];
                for (i = this.healthFlag.length - 1; i >= 0; --i) {
                    this.healthFlag[i] = true;
                }
                this.player.reset(0);
                this.player.setPosition(60, SCREEN_HEIGHT - 75);
                for (i = this.goon.length - 1; i >= 0; --i) {
                    this.goon[i].setPosition(this.player.getX() + 200 + i * 100, this.player.getY() - (this.goon[i].frameHeight - this.player.frameHeight));
                }
                break;
            }
            case 3: {
                int i;
                int[][] triggerRects = new int[][]{{MAP_WIDTH - 24, 84, MAP_WIDTH + 48, 216}};
                this.triggerRects = triggerRects;
                this.triggerFlag = new boolean[triggerRects.length];
                for (int i3 = this.triggerFlag.length - 1; i3 >= 0; --i3) {
                    this.triggerFlag[i3] = true;
                }
                int[][] healthRects = new int[][]{{492, SCREEN_HEIGHT - 20 - 12}, {816, SCREEN_HEIGHT - 20 - 12}, {1104, SCREEN_HEIGHT - 20 - 12}, {1500, SCREEN_HEIGHT - 20 - 12}, {1680, SCREEN_HEIGHT - 20 - 12}, {2400, SCREEN_HEIGHT - 20 - 12}};
                this.healthRects = healthRects;
                this.healthFlag = new boolean[healthRects.length];
                for (i = this.healthFlag.length - 1; i >= 0; --i) {
                    this.healthFlag[i] = true;
                }
                this.player.setPosition(35, SCREEN_HEIGHT - 75);
                for (i = this.goon.length - 1; i >= 0; --i) {
                    this.goon[i].setPosition(this.player.getX() + 110 + i * 260, this.player.getY() - (this.goon[i].getHeight() - this.player.getHeight()));
                }
                break;
            }
            case 4: {
                this.player.reset(0);
                this.player.setPosition(30, SCREEN_HEIGHT - 70);
                int[][] healthRects = new int[][]{{72, SCREEN_HEIGHT - 24}, {300, SCREEN_HEIGHT - 24}};
                this.healthRects = healthRects;
                this.healthFlag = new boolean[healthRects.length];
                this.healthReappearTime = new long[healthRects.length];
                for (int i = this.healthFlag.length - 1; i >= 0; --i) {
                    this.healthFlag[i] = true;
                }
                this.goon = new MyPlayer[1];
                try {
                    this.goon[0] = new MyPlayer(Image.createImage((String)"/e4.png"), 29, 40, 4);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.goon[0].setPosition(this.player.getX() + 200, SCREEN_HEIGHT - 90);
            }
        }
        image = null;
    }

    protected void hideNotify() {
        try {
            musicPlayer[0].stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        if (gameState >= 13) {
            this.pauseGame();
        }
    }

    void animateMainMenu() {
        startGame = false;
        int key = 0;
        if (this.inputDelay < System.currentTimeMillis()) {
            this.inputDelay = System.currentTimeMillis() + 500L;
            key = this.getKeyStates();
            if (key != 0) {
                if (soundVolume > 0 && musicPlayer[0].getState() != 400) {
                    try {
                        musicPlayer[0].start();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                }
                if ((key & 2) != 0) {
                    key = -1;
                } else if ((key & 0x40) != 0) {
                    key = 1;
                } else if ((key & 0x100) != 0) {
                    key = -5;
                }
            }
        }
        if (this.iv_lskPressed) {
            key = -5;
        }
        this.iv_lskPressed = false;
        if (key != 0 && soundVolume > 0 && musicPlayer[0].getState() != 400) {
            try {
                musicPlayer[0].start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        if (key == -5) {
            block3 : switch (this.menuType) {
                case 5: {
                    switch (this.menuIndex) {
                        case 0: {
                            if (this.iv_confirmExit) {
                                this.iv_confirmExit = false;
                                this.menuIndex = 0;
                                this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                                this.menuType = 0;
                                break block3;
                            }
                            if (this.iv_confirmNewGameStart) {
                                this.menuIndex = 0;
                                this.menuItems = language == 0 ? this.ppmenuItems : (language == 1 ? this.ppmenuItems1 : this.ppmenuItems2);
                                this.menuType = 6;
                                break block3;
                            }
                            this.menuIndex = 0;
                            this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                            this.menuType = 0;
                            break block3;
                        }
                        case 1: {
                            if (this.iv_confirmExit) {
                                this.playing = false;
                                try {
                                    for (int i = musicPlayer.length - 1; i >= 0; --i) {
                                        musicPlayer[i].stop();
                                    }
                                }
                                catch (MediaException ex) {
                                    ex.printStackTrace();
                                }
                                this.midlet.destroyApp(true);
                                this.midlet.notifyDestroyed();
                                break block3;
                            }
                            if (!this.iv_confirmNewGameStart) break block3;
                            this.paused = false;
                            gameState = 3;
                            break block3;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuItems = language == 0 ? this.ppmenuItems : (language == 1 ? this.ppmenuItems1 : this.ppmenuItems2);
                            this.menuType = 6;
                            break block3;
                        }
                        case 1: {
                            this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                            this.menuType = 2;
                            break block3;
                        }
                        case 2: {
                            this.fLinesInStringArray = language == 0 ? this.splitText("\u5206\u6578", SCREEN_WIDTH - 20, 0) : (language == 1 ? this.splitText("\u5206\u6570", SCREEN_WIDTH - 20, 0) : this.splitText("HIGHSCORES", SCREEN_WIDTH - 20, 2));
                            this.fCurLine = 0;
                            this.iv_boxIndex = 0;
                            gameState = 2;
                            break block3;
                        }
                        case 3: {
                            this.fLinesInStringArray = this.splitText(this.helpText2, SCREEN_WIDTH, 0);
                            this.fCurLine = 0;
                            this.iv_boxIndex = 0;
                            gameState = 7;
                            break block3;
                        }
                        case 4: {
                            this.fLinesInStringArray = this.splitText(this.aboutText2, SCREEN_WIDTH, 0);
                            this.fCurLine = 0;
                            this.iv_boxIndex = 0;
                            gameState = 6;
                            break block3;
                        }
                    }
                    this.menuIndex = 0;
                    this.menuItems = language == 0 ? this.confirmationItems : (language == 1 ? this.confirmationItems1 : this.confirmationItems2);
                    this.menuType = 5;
                    this.iv_confirmExit = true;
                    break;
                }
                case 6: {
                    switch (this.menuIndex) {
                        case 0: {
                            if (this.paused) {
                                this.iv_confirmNewGameStart = false;
                                this.paused = false;
                                this.resumeGame();
                            }
                            System.out.println("pausedddddddddddddddddddddd      " + this.paused);
                            break block3;
                        }
                        case 1: {
                            if (language == 0) {
                                if (this.ppmenuItems[0].charAt(0) == '*') {
                                    gameState = 3;
                                    break block3;
                                }
                                this.iv_confirmNewGameStart = true;
                                this.menuIndex = 0;
                                this.menuItems = this.confirmationItems;
                                this.menuType = 5;
                                break block3;
                            }
                            if (language == 1) {
                                if (this.ppmenuItems1[0].charAt(0) == '*') {
                                    gameState = 3;
                                    break block3;
                                }
                                this.iv_confirmNewGameStart = true;
                                this.menuIndex = 0;
                                this.menuItems = this.confirmationItems1;
                                this.menuType = 5;
                                break block3;
                            }
                            if (this.ppmenuItems2[0].charAt(0) == '*') {
                                gameState = 3;
                                break block3;
                            }
                            this.iv_confirmNewGameStart = true;
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems2;
                            this.menuType = 5;
                            break block3;
                        }
                    }
                    this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                    this.menuType = 0;
                    break;
                }
                case 2: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuIndex = soundVolume / 33;
                            this.menuItems = language == 0 ? this.soundsItems : (language == 1 ? this.soundsItems1 : this.soundsItems2);
                            this.menuType = 3;
                            break block3;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                    this.menuType = 0;
                    break;
                }
                case 3: {
                    switch (this.menuIndex) {
                        case 0: {
                            soundVolume = 0;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 1: {
                            soundVolume = 33;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 2: {
                            soundVolume = 66;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 3: {
                            soundVolume = 100;
                            this.writeRMS();
                            this.initMedia();
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                    this.menuType = 2;
                    break;
                }
                case 4: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.vibrations = true;
                            this.midlet.vibra(1000);
                            this.writeRMS();
                            break;
                        }
                        case 1: {
                            this.vibrations = false;
                            this.writeRMS();
                            break;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                    this.menuType = 2;
                    break;
                }
                case 1: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.resumeGame();
                            System.out.println("resumessssdddddddddddddddddddddddddddddddddd");
                            break block3;
                        }
                        case 2: {
                            this.menuIndex = 0;
                            this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                            this.menuType = 0;
                            this.getKeyStates();
                            if (language == 0) {
                                this.ppmenuItems[0] = "\u91cd\u65b0\u958b\u59cb";
                            } else if (language == 1) {
                                this.ppmenuItems1[0] = "\u91cd\u65b0\u5f00\u59cb";
                            } else if (this.paused && !this.gameOver) {
                                this.ppmenuItems2[0] = "RESUME";
                            }
                            this.inputDelay = System.currentTimeMillis() + 500L;
                            break block3;
                        }
                        case 1: {
                            this.menuIndex = soundVolume / 33;
                            this.menuItems = language == 0 ? this.soundsItems : (language == 1 ? this.soundsItems1 : this.soundsItems2);
                            this.menuType = 3;
                        }
                    }
                }
            }
            if (this.menuType != 3 && this.menuType != 4) {
                this.menuIndex = 0;
            }
        }
        if (this.menuItems[this.menuIndex].charAt(0) == '*') {
            key = 1;
        }
        if (key == 1 || key == -1) {
            do {
                this.menuIndex += key;
                if (this.menuIndex == -1) {
                    this.menuIndex = this.menuItems.length - 1;
                    continue;
                }
                if (this.menuIndex != this.menuItems.length) continue;
                this.menuIndex = 0;
            } while (this.menuItems[this.menuIndex].charAt(0) == '*');
        }
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.menuItems[i].charAt(0) == '*') continue;
            if (i == this.menuIndex) {
                g.setStrokeStyle(1);
                g.setColor(65280);
                if (this.menuType != 0 && (this.paused || this.menuItems == this.confirmationItems || this.menuItems == this.confirmationItems1 || this.menuItems == this.confirmationItems2)) {
                    g.drawRect(MENU_X - this.boldFont.stringWidth(this.menuItems[i]) / 2 - 3, 12 * i + 34, this.boldFont.stringWidth(this.menuItems[i]) + 3, this.boldFont.getHeight());
                } else {
                    g.drawRect(MENU_X - this.boldFont.stringWidth(this.menuItems[i]) / 2 - 3, 12 * i + 4, this.boldFont.stringWidth(this.menuItems[i]) + 3, this.boldFont.getHeight());
                }
                g.setFont(this.boldFont);
                g.setColor(16549888);
            } else {
                g.setFont(this.boldFont);
                g.setColor(0xFFF000);
            }
            if (this.menuType != 0 && (this.paused || this.menuItems == this.confirmationItems || this.menuItems == this.confirmationItems1 || this.menuItems == this.confirmationItems2)) {
                g.drawString(this.menuItems[i], MENU_X, 12 * i + 35, 17);
                continue;
            }
            g.drawString(this.menuItems[i], MENU_X, 12 * i + 5, 17);
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -7 || keyCode == 42) {
            if (gameState >= 13) {
                this.pauseGame();
            }
        } else if (keyCode == -6 || keyCode == 8) {
            this.iv_lskPressed = true;
        }
    }

    void pauseGame() {
        if (this.paused) {
            return;
        }
        try {
            musicPlayer[0].stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
        this.menuType = 1;
        this.menuIndex = 0;
        this.lastGameState = gameState;
        this.keyDelay = System.currentTimeMillis() + 200L;
        this.getKeyStates();
        gameState = 1;
        this.paused = true;
    }

    private void resumeGame() {
        this.paused = false;
        try {
            musicPlayer[0].stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        gameState = this.lastGameState;
    }

    public void keyReleased(int keyCode) {
        if (this.takeInput) {
            this.getInput(keyCode);
        }
    }

    private void getInput(int keyCode) {
        if (keyCode > 49 && keyCode <= 57) {
            if (this.lastKey == keyCode && this.keyDelay > System.currentTimeMillis() && this.nameIndex > 0) {
                --this.nameIndex;
                ++this.repeatIndex;
                this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                this.lastKey = keyCode;
                switch (keyCode) {
                    default: {
                        if (this.repeatIndex < 3) {
                            this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50) + this.repeatIndex);
                            ++this.nameIndex;
                            break;
                        }
                        if (this.repeatIndex == 3) {
                            this.uName[this.nameIndex] = (char)keyCode;
                            ++this.nameIndex;
                            break;
                        }
                        this.repeatIndex = 0;
                        this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                        ++this.nameIndex;
                        break;
                    }
                    case 55: {
                        if (this.repeatIndex < 4) {
                            this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50) + this.repeatIndex);
                            ++this.nameIndex;
                            break;
                        }
                        if (this.repeatIndex == 4) {
                            this.uName[this.nameIndex] = (char)keyCode;
                            ++this.nameIndex;
                            break;
                        }
                        this.repeatIndex = 0;
                        this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                        ++this.nameIndex;
                        break;
                    }
                    case 56: {
                        if (this.repeatIndex < 3) {
                            this.uName[this.nameIndex] = (char)(84 + this.repeatIndex);
                            ++this.nameIndex;
                            break;
                        }
                        if (this.repeatIndex == 3) {
                            this.uName[this.nameIndex] = (char)keyCode;
                            ++this.nameIndex;
                            break;
                        }
                        this.repeatIndex = 0;
                        this.uName[this.nameIndex] = 84;
                        ++this.nameIndex;
                        break;
                    }
                    case 57: {
                        if (this.repeatIndex < 4) {
                            this.uName[this.nameIndex] = (char)(87 + this.repeatIndex);
                            ++this.nameIndex;
                            break;
                        }
                        if (this.repeatIndex == 4) {
                            this.uName[this.nameIndex] = (char)keyCode;
                            ++this.nameIndex;
                            break;
                        }
                        this.repeatIndex = 0;
                        this.uName[this.nameIndex] = 87;
                        ++this.nameIndex;
                        break;
                    }
                }
            } else if (this.nameIndex < MAX_LENGTH) {
                this.repeatIndex = 0;
                this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                this.lastKey = keyCode;
                switch (keyCode) {
                    default: {
                        this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                        ++this.nameIndex;
                        break;
                    }
                    case 49: {
                        this.uName[this.nameIndex] = 45;
                        ++this.nameIndex;
                        break;
                    }
                    case 56: {
                        this.uName[this.nameIndex] = 84;
                        ++this.nameIndex;
                        break;
                    }
                    case 57: {
                        this.uName[this.nameIndex] = 87;
                        ++this.nameIndex;
                        break;
                    }
                }
            }
        } else if ((keyCode == -8 || keyCode == -7 || keyCode == -23) && this.nameIndex > 0) {
            --this.nameIndex;
            this.uName[this.nameIndex] = 32;
            this.keyDelay = System.currentTimeMillis();
        } else if (keyCode == -4) {
            this.keyDelay = System.currentTimeMillis();
        } else if ((keyCode == -5 || keyCode == -6) && this.nameIndex >= 1) {
            this.takeInput = false;
        }
    }

    private void initMedia() {
        if (musicPlayer == null) {
            String[] musicFiles = new String[]{"/bg.mid", "/sword.mid", "/attack.mid", "/bg2.wav"};
            String xtension = "mid";
            musicPlayer = new Player[3];
            for (int i = 0; i < musicPlayer.length; ++i) {
                try {
                    InputStream is = this.getClass().getResourceAsStream(musicFiles[i]);
                    RajuFightClub_SmallCanvas.musicPlayer[i] = musicFiles[i].endsWith(xtension) ? Manager.createPlayer((InputStream)is, (String)"audio/midi") : Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
                    musicPlayer[i].realize();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(" " + e.getMessage());
                }
            }
            musicPlayer[0].setLoopCount(-1);
        }
        if (soundVolume > 0) {
            VolumeControl vc = (VolumeControl)musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(soundVolume);
            vc = (VolumeControl)musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(soundVolume);
            vc = (VolumeControl)musicPlayer[1].getControl("VolumeControl");
            vc.setLevel(soundVolume);
            vc = (VolumeControl)musicPlayer[2].getControl("VolumeControl");
            vc.setLevel(soundVolume);
        } else {
            try {
                musicPlayer[0].stop();
                musicPlayer[1].stop();
                musicPlayer[2].stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    void writeRMS() {
        this.rec[0] = 0;
        this.rec[0] = (byte)(soundVolume / 33);
        if (this.vibrations) {
            this.rec[0] = (byte)(this.rec[0] | 4);
        }
        this.rec[1] = (byte)currentLevel;
        this.rec[2] = (byte)score;
        this.rec[3] = (byte)(score >>> 8);
        this.rec[4] = (byte)(score >>> 16);
        try {
            this.rs = RecordStore.openRecordStore((String)"JDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(1, this.rec, 0, 5);
            } else {
                this.rs.addRecord(this.rec, 0, 5);
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    void readRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)"JDB", (boolean)true);
            this.rec = this.rs.getRecord(1);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open settings recordStore for reading" + e);
            return;
        }
        soundVolume = (this.rec[0] & 3) * 33;
        this.vibrations = (this.rec[0] & 4) != 0;
        currentLevel = this.rec[1];
    }

    void fillHighScoresData() {
        try {
            this.rs = RecordStore.openRecordStore((String)"JScoresDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.closeRecordStore();
                return;
            }
            byte[] b = new byte[14];
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    String[] getHighScores(int[] scores) {
        byte[] records = new byte[14];
        String[] names = new String[5];
        try {
            this.rs = RecordStore.openRecordStore((String)"JScoresDB", (boolean)true);
            records = this.rs.getRecord(1);
            names[0] = new String(records, 0, 6);
            scores[0] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(2);
            names[1] = new String(records, 0, 6);
            scores[1] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(3);
            names[2] = new String(records, 0, 6);
            scores[2] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(4);
            names[3] = new String(records, 0, 6);
            scores[3] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(5);
            names[4] = new String(records, 0, 6);
            scores[4] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore " + e);
        }
        return names;
    }

    void updateHighScores() {
        if (score <= 0) {
            return;
        }
        int pos = -1;
        int[] highScores = new int[5];
        byte[][] records = new byte[14][5];
        try {
            int i;
            this.rs = RecordStore.openRecordStore((String)"JScoresDB", (boolean)true);
            records[0] = this.rs.getRecord(1);
            highScores[0] = records[0][6] & 0xFF | records[0][7] << 8 & 0xFF00 | records[0][8] << 16 & 0xFF0000;
            records[1] = this.rs.getRecord(2);
            highScores[1] = records[1][6] & 0xFF | records[1][7] << 8 & 0xFF00 | records[1][8] << 16 & 0xFF0000;
            records[2] = this.rs.getRecord(3);
            highScores[2] = records[2][6] & 0xFF | records[2][7] << 8 & 0xFF00 | records[2][8] << 16 & 0xFF0000;
            records[3] = this.rs.getRecord(4);
            highScores[3] = records[3][6] & 0xFF | records[3][7] << 8 & 0xFF00 | records[3][8] << 16 & 0xFF0000;
            records[4] = this.rs.getRecord(5);
            highScores[4] = records[4][6] & 0xFF | records[4][7] << 8 & 0xFF00 | records[4][8] << 16 & 0xFF0000;
            for (i = 4; i >= 0; --i) {
                if (score <= highScores[i]) continue;
                pos = i;
            }
            if (pos != -1) {
                i = 4;
                while (i > pos - 1) {
                    System.arraycopy(records[i - 1], 0, records[i], 0, 14);
                    if (--i != 0) continue;
                }
                records[pos][0] = (byte)this.uName[0];
                records[pos][1] = (byte)this.uName[1];
                records[pos][2] = (byte)this.uName[2];
                records[pos][3] = (byte)this.uName[3];
                records[pos][4] = (byte)this.uName[4];
                records[pos][5] = (byte)this.uName[5];
                records[pos][6] = (byte)score;
                records[pos][7] = (byte)(score >>> 8);
                records[pos][8] = (byte)(score >>> 16);
                for (i = pos; i < 5; ++i) {
                    this.rs.setRecord(i + 1, records[i], 0, 14);
                }
                if (language == 0) {
                    this.mmenuItems[2] = "\u5206\u6578";
                } else if (language == 1) {
                    this.mmenuItems1[2] = "\u5206\u6570";
                } else {
                    this.mmenuItems2[2] = "HIGHSCORES";
                }
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore for updation" + e);
        }
    }

    private void drawText(Graphics g, String text, int text_x, int text_y, int align, int text_colour) {
        g.setColor(text_colour);
        g.drawString(text, text_x, text_y, align);
    }

    private void setFontAttributes(int font_type) {
        if (font_type == 0) {
            this.fWidth = 10;
            this.fHeight = 10;
            this.fStripWidth = 6;
        } else if (font_type == 2) {
            this.fHeight = this.systemFont.getHeight();
            this.fWidth = this.systemFont.charWidth('B');
        }
    }

    private void drawCustomText(Graphics g, String text, int xpos, int ypos, int align, int font_type) {
        this.setFontAttributes(font_type);
        if (text.length() > 0) {
            int letter = 0;
            int font_xoffset = 0;
            int font_yoffset = 0;
            int string_xpos = xpos;
            int spacer = 0;
            if (align == 17) {
                string_xpos = xpos - text.length() * (this.fWidth >> 1);
            } else if (align == 24) {
                string_xpos = xpos - text.length() * this.fWidth;
            }
            for (int i = 0; i < text.length(); ++i) {
                if (font_type != 0) {
                    letter = text.charAt(i) >= '0' && text.charAt(i) <= '9' ? text.charAt(i) - 16 : text.charAt(i) - 65;
                    char tempChar = text.charAt(i);
                    switch (tempChar) {
                        case '.': {
                            letter = 29;
                            break;
                        }
                        case '[': {
                            letter = 26;
                            break;
                        }
                        case ']': {
                            letter = 27;
                            break;
                        }
                        case '$': {
                            letter = 31;
                            break;
                        }
                        case ':': {
                            letter = 28;
                            break;
                        }
                        case '%': {
                            letter = 42;
                        }
                        case '*': {
                            letter = 43;
                            break;
                        }
                        case '/': {
                            letter = 44;
                            break;
                        }
                        case '\'': {
                            letter = 45;
                            break;
                        }
                        case '_': {
                            letter = 46;
                        }
                    }
                } else {
                    letter = text.charAt(i);
                    if (letter >= 65 && letter <= 90) {
                        letter -= 65;
                    } else if (letter >= 48 && letter <= 57) {
                        letter -= 22;
                    } else if (letter == 32) {
                        letter = -1;
                    }
                }
                font_xoffset = (letter - letter / this.fStripWidth * this.fStripWidth) * this.fWidth;
                font_yoffset = letter / this.fStripWidth * this.fHeight;
                if (letter == 0) {
                    spacer += 0;
                }
                if (letter == -1) continue;
                g.setClip(string_xpos + i * this.fWidth - spacer, ypos, this.fWidth, this.fHeight);
                g.drawImage(this.imgFont, string_xpos + i * this.fWidth - font_xoffset - spacer, ypos - font_yoffset, 20);
            }
        }
        g.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    }

    private boolean paintBox() {
        if (this.iv_boxIndex < 130) {
            this.iv_boxIndex += (130 - this.iv_boxIndex) / 5 + 1;
            g.setColor(0);
            g.fillRect(MIDX - (this.iv_boxIndex >> 1), MIDY - (this.iv_boxIndex >> 1), this.iv_boxIndex, this.iv_boxIndex);
            g.setColor(9895934);
            g.drawRect(MIDX - (this.iv_boxIndex >> 1), MIDY - (this.iv_boxIndex >> 1), this.iv_boxIndex, this.iv_boxIndex);
            this.iv_boxCorners.setFrame(0);
            this.iv_boxCorners.setPosition(MIDX - (this.iv_boxIndex >> 1), MIDY - (this.iv_boxIndex >> 1));
            this.iv_boxCorners.paint(g);
            this.iv_boxCorners.setFrame(1);
            this.iv_boxCorners.setPosition(MIDX + (this.iv_boxIndex >> 1) - 7, MIDY - (this.iv_boxIndex >> 1));
            this.iv_boxCorners.paint(g);
            this.iv_boxCorners.setFrame(2);
            this.iv_boxCorners.setPosition(MIDX - (this.iv_boxIndex >> 1), MIDY + (this.iv_boxIndex >> 1) - 7);
            this.iv_boxCorners.paint(g);
            this.iv_boxCorners.setFrame(3);
            this.iv_boxCorners.setPosition(MIDX + (this.iv_boxIndex >> 1) - 7, MIDY + (this.iv_boxIndex >> 1) - 7);
            this.iv_boxCorners.paint(g);
            this.getKeyStates();
            return false;
        }
        g.setColor(0);
        g.fillRect(MIDX - 65, MIDY - 65, 130, 130);
        g.setColor(9895934);
        g.drawRect(MIDX - 65, MIDY - 65, 130, 130);
        this.iv_boxCorners.setFrame(0);
        this.iv_boxCorners.setPosition(MIDX - 65, MIDY - 65);
        this.iv_boxCorners.paint(g);
        this.iv_boxCorners.setFrame(1);
        this.iv_boxCorners.setPosition(MIDX + 65 - 7, MIDY - 65);
        this.iv_boxCorners.paint(g);
        this.iv_boxCorners.setFrame(2);
        this.iv_boxCorners.setPosition(MIDX - 65, MIDY + 65 - 7);
        this.iv_boxCorners.paint(g);
        this.iv_boxCorners.setFrame(3);
        this.iv_boxCorners.setPosition(MIDX + 65 - 7, MIDY + 65 - 7);
        this.iv_boxCorners.paint(g);
        return true;
    }

    private boolean drawTextBox() {
        g.drawImage(this.titleImage, 0, 0, 0);
        g.setFont(this.systemFont);
        if (this.paintBox()) {
            this.drawSplitText(SCREEN_WIDTH / 2, 15, 17, 2, 0xFFFFFF, SCREEN_HEIGHT - 30);
            this.drawSoftKeyLabels(this.softKeyLabels[1], null);
            int key = this.getKeyStates();
            if (this.inputDelay < System.currentTimeMillis()) {
                this.inputDelay = System.currentTimeMillis() + 50L;
                key = this.getKeyStates();
                if ((key & 2) != 0) {
                    key = -1;
                } else if ((key & 0x40) != 0) {
                    key = 1;
                } else if ((key & 0x100) != 0) {
                    key = -5;
                }
            }
            if (this.fCurLine + this.fLinesPerPage < this.fLinesInStringArray) {
                g.drawImage(this.softKeyLabels[5], MIDX, MIDY + 65, 3);
                if (key == 1) {
                    ++this.fCurLine;
                }
            }
            if (this.fCurLine > 0) {
                g.drawImage(this.softKeyLabels[4], MIDX, MIDY - 65, 3);
                if (key == -1) {
                    --this.fCurLine;
                }
            }
            if (key == -5 || this.iv_lskPressed) {
                return true;
            }
        }
        return false;
    }

    private int splitText(String text_to_split, int box_width, int font_type) {
        this.setFontAttributes(font_type);
        String temp_string = "";
        this.fSplitText = new String[150];
        int string_num = 0;
        int last_break_pos = 0;
        int last_break_in_string = 0;
        int pos_in_string = 0;
        char character = '\u0000';
        for (int i = 0; i < text_to_split.length(); ++i) {
            character = text_to_split.charAt(i);
            ++pos_in_string;
            temp_string = temp_string + text_to_split.charAt(i);
            int string_width_in_pixels = font_type != 2 ? temp_string.length() * this.fWidth : this.systemFont.stringWidth(temp_string);
            if (character == ' ' || character == '.' || character == '!' || character == '?' || character == ',' || character == '-' || character == '=') {
                last_break_pos = i;
                last_break_in_string = pos_in_string;
            }
            if (character == '~') {
                if (pos_in_string != 1) {
                    this.fSplitText[string_num] = temp_string.length() > 0 ? temp_string.substring(0, temp_string.length() - 1) : "";
                    ++string_num;
                }
                temp_string = "";
                pos_in_string = 0;
                last_break_in_string = 0;
            }
            if (string_width_in_pixels < box_width && i < text_to_split.length() - 1) continue;
            if (last_break_in_string <= 0) {
                if (string_width_in_pixels >= box_width) {
                    this.fSplitText[string_num] = temp_string.length() > 0 ? temp_string.substring(0, temp_string.length() - 1) : "";
                    --i;
                    ++string_num;
                    temp_string = "";
                    pos_in_string = 0;
                    last_break_in_string = 0;
                    continue;
                }
                this.fSplitText[string_num] = temp_string.substring(0, temp_string.length());
                ++string_num;
                temp_string = "";
                pos_in_string = 0;
                last_break_in_string = 0;
                break;
            }
            if (string_width_in_pixels >= box_width) {
                this.fSplitText[string_num] = temp_string.substring(0, last_break_in_string);
                i = last_break_pos;
                ++string_num;
                temp_string = "";
                pos_in_string = 0;
                last_break_in_string = 0;
                continue;
            }
            this.fSplitText[string_num] = temp_string.substring(0, temp_string.length());
            ++string_num;
            temp_string = "";
            pos_in_string = 0;
            last_break_in_string = 0;
            break;
        }
        return string_num;
    }

    private void drawSplitText(int text_xpos, int text_ypos, int alignment, int font_type, int color, int box_height) {
        int line_dist_factor = font_type == 0 ? 1 : 0;
        int dist_between_lines = font_type == 2 ? this.fHeight + (4 - line_dist_factor) : this.fHeight + (4 - line_dist_factor);
        this.fLinesPerPage = box_height / dist_between_lines;
        this.fTotalPages = this.fLinesInStringArray / this.fLinesPerPage;
        for (int i = this.fCurLine; i < this.fCurLine + this.fLinesPerPage; ++i) {
            if (this.fSplitText[i] == null) continue;
            if (font_type != 2) {
                this.drawCustomText(g, this.fSplitText[i], text_xpos, text_ypos + (i - this.fCurLine) * dist_between_lines, alignment, font_type);
                continue;
            }
            this.drawText(g, this.fSplitText[i], text_xpos, text_ypos + (i - this.fCurLine) * dist_between_lines, alignment, color);
        }
    }

    private void drawSoftKeyLabels(Image left, Image right) {
        int offsetX = -g.getTranslateX();
        int offsetY = -g.getTranslateY();
        if (left != null) {
            g.drawImage(left, offsetX + 2, offsetY + SCREEN_HEIGHT - 2, 36);
        }
        if (right != null) {
            g.drawImage(right, offsetX + SCREEN_WIDTH - 2, offsetY + SCREEN_HEIGHT - 2, 40);
        }
    }

    private void loadBackLayer() {
        this.backLayer = currentLevel == 4 ? new BGLayer[1] : new BGLayer[3];
        this.loadingTask = new BGLoadingTask(this.backLayer);
        this.loadingTimer = new Timer();
        this.loadingTimer.scheduleAtFixedRate((TimerTask)this.loadingTask, 0L, 75L);
        switch (currentLevel) {
            case 1: 
            case 2: 
            case 3: {
                MAP_WIDTH = 2880;
                break;
            }
            case 4: {
                MAP_WIDTH = 360;
            }
        }
        this.player.recreateWalkingLayer(currentLevel);
    }

    private void paintBg() {
        int r1x1 = -g.getTranslateX();
        int r1y1 = -g.getTranslateY();
        g.setClip(r1x1, r1y1, SCREEN_WIDTH, SCREEN_HEIGHT);
        if (currentLevel == 4) {
            this.backLayer[0].paint(g, -g.getTranslateX(), -g.getTranslateY());
        } else {
            int r1x2 = r1x1 + SCREEN_WIDTH;
            int r1y2 = r1y1 + SCREEN_HEIGHT;
            for (int i = this.backLayer.length - 1; i >= 0; --i) {
                if (this.backLayer[i] == null) continue;
                int r2x1 = this.backLayer[i].getX();
                int r2x2 = r2x1 + this.backLayer[i].getColumns() * 12;
                int r2y1 = this.backLayer[i].getY();
                int r2y2 = r2y1 + this.backLayer[i].getRows() * 12;
                if (r2x1 >= r1x2 || r2y1 >= r1y2 || r2x2 <= r1x1 || r2y2 <= r1y1) continue;
                this.backLayer[i].paint(g, r1x1, r1y1);
            }
        }
    }

    static int nextInt() {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return seed >>> 8;
    }

    static int nextInt(int n) {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return (seed >>> 8) % n;
    }

    static int nextSignedInt(int n) {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return (seed >>> 8) % (n * 2) - n;
    }

    static {
        soundVolume = 66;
        explode = false;
        exploded = false;
        startGame = false;
        MENU_X = SCREEN_WIDTH / 2;
        MAX_LENGTH = 6;
        WAIT_TIME = 2000L;
    }
}

