/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BGLayer {
    private int x;
    private int y;
    private int cellHeight;
    private int cellWidth;
    private int rows;
    private int columns;
    private int[][] cellMatrix;
    private boolean visible;
    private boolean updated;

    public BGLayer(int columns, int rows, int tileWidth, int tileHeight) {
        if (BGLoadingTask.sourceImage.getWidth() % tileWidth != 0 || BGLoadingTask.sourceImage.getHeight() % tileHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.rows = rows;
        this.cellMatrix = new int[rows][columns];
        this.cellWidth = tileWidth;
        this.cellHeight = tileHeight;
        this.visible = true;
    }

    public void setCell(int col, int row, int tileIndex) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (tileIndex > BGLoadingTask.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        this.cellMatrix[row][col] = tileIndex--;
        if (tileIndex >= 0 && BGLoadingTask.allFrames[tileIndex] == null) {
            try {
                BGLoadingTask.allFrames[tileIndex] = Image.createImage((int)this.cellWidth, (int)this.cellHeight);
                Graphics g = BGLoadingTask.allFrames[tileIndex].getGraphics();
                g.setColor(12508659);
                g.fillRect(0, 0, 16, 16);
                g.drawImage(BGLoadingTask.sourceImage, -(tileIndex % BGLoadingTask.imageColumns) * 16, -(tileIndex / BGLoadingTask.imageColumns) * 16, 0);
            }
            catch (Exception e) {
                System.out.println("ex while creating a frame of index" + tileIndex);
            }
        }
        this.updated = true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void paint(Graphics g, int translatedX, int translatedY) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int startRow;
            int startColumn = (translatedX - this.x) / 16;
            if (startColumn < 0) {
                startColumn = 0;
            }
            if ((startRow = (translatedY - this.y) / 16) < 0) {
                startRow = 0;
            }
            int endColumn = startColumn + 16;
            int endRow = startRow + 21;
            if (endColumn > this.columns) {
                endColumn = this.columns;
            }
            if (endRow > this.rows) {
                endRow = this.rows;
            }
            for (int i = startColumn; i < endColumn; ++i) {
                for (int j = startRow; j < endRow; ++j) {
                    int frameNo = this.cellMatrix[j][i];
                    if (frameNo <= 0) continue;
                    g.drawImage(BGLoadingTask.allFrames[--frameNo], this.x + i * 16, this.y + j * 16, 0);
                }
            }
        }
    }
}

