/*
 * Decompiled with CFR 0.152.
 */
package kitmaker.online.score.api;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import kitmaker.online.score.api.KitConException;
import kitmaker.online.score.api.KitLang;
import kitmaker.online.score.api.KitScore;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public final class KitHttpManager {
    private static final String SERVER_URL = "http://www.kitmakerlive.com";
    private static final String INSTALL_CODE_URL = "/getInstallationCode";
    private static final String SUBMIT_SCORE_URL = "/addOnlineScore";
    private static final String GET_RANKINGS_URL = "/getOnlineScores";
    private static final String GAME_CODE_PROPER = "MIDlet-1";
    private static final String VER_PROPER = "MIDlet-Version";
    private static final String DEB_PROPER = "binMode";
    private static final String DEB_STATE = "DEBUG";
    private static final String CONF_FILE = "CON_CONF";
    private static final String ANS_STATUS = "status";
    private static final String ANS_DESCRIP = "status_details";
    private static final String GAME_CODE = "gamecode";
    private static final String GAME_VER = "gameversion";
    private static final String LANGUAGE = "language";
    private static final String TIMES_PLAYED = "totalgames";
    private static final String FAMILY = "family";
    private static final String DEVICE_DATA = "devicedata";
    private static final String START_DATE = "firstexecutiondate";
    private static final String JSON_ADD = "jsonadditionaldata";
    private static final String INSTALL_CODE = "installationcode";
    private static final String NAME_SCR = "name";
    private static final String AVATAR_SCR = "avatar";
    private static final String BEST1 = "bestscoretable1";
    private static final String BEST2 = "bestscoretable2";
    private static final String BEST3 = "bestscoretable3";
    private static final String BEST4 = "bestscoretable4";
    private static final String BEST5 = "bestscoretable5";
    private static final String RES_RANK = "results";
    private static final String MY_RANK = "getcurrentposition";
    private static final String RANKING1 = "gettable1";
    private static final String RANKING2 = "gettable2";
    private static final String RANKING3 = "gettable3";
    private static final String RANKING4 = "gettable4";
    private static final String RANKING5 = "gettable5";
    private static final String EMAILS = "emailto";
    private static StringBuffer mailList = new StringBuffer();
    private static StringBuffer errorPrompt = new StringBuffer();
    private static KitScore handler;
    private static MIDlet main;
    private static JSONObject submitScore;
    private static JSONObject rankingRequest;
    private static JSONObject configInfo;
    private static boolean initiated;
    private static boolean connectionSuccess;
    private static boolean connectionReady;
    private static Ranking ranks;
    private static Signal signal;

    static void addMessage(String message) {
        String debugProperty = main.getAppProperty(DEB_PROPER);
        if (debugProperty != null && debugProperty.equals(DEB_STATE)) {
            errorPrompt.append(errorPrompt.length() != 0 ? "," : "").append(message.replace('\n', ' '));
        }
    }

    public static StringBuffer getErrorPrompt() {
        StringBuffer result = errorPrompt;
        return result;
    }

    public static String getName(int tableIndex, int recordIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getName(tableIndex, recordIndex);
        }
        return "nobody";
    }

    public static String getAvatar(int tableIndex, int recordIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getAvatar(tableIndex, recordIndex);
        }
        return "noavatar";
    }

    public static int getScore(int tableIndex, int recordIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getScore(tableIndex, recordIndex);
        }
        return Integer.MIN_VALUE;
    }

    public static String getPlayerName(int tableIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getPlayerName(tableIndex);
        }
        return "nobody";
    }

    public static int getPlayerPos(int tableIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getPlayerPos(tableIndex);
        }
        return -1;
    }

    public static String getPlayerAvatar(int tableIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getPlayerAvatar(tableIndex);
        }
        return "noavatar";
    }

    public static int getPlayerScore(int tableIndex) {
        if (initiated && ranks != null) {
            return KitHttpManager.ranks.getPlayerScore(tableIndex);
        }
        return -1;
    }

    private KitHttpManager() {
    }

    public static void init(KitScore newHandler, MIDlet newMain) {
        if (!initiated) {
            try {
                if (newHandler == null) {
                    throw new KitConException(KitConException.SYSTEM_PROBLEM, "1");
                }
                if (newMain == null) {
                    throw new KitConException(KitConException.SYSTEM_PROBLEM, "2");
                }
                handler = newHandler;
                main = newMain;
                ranks = new Ranking();
                KitHttpManager.execInit();
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void free() {
        Thread exe = new Thread(){

            public void run() {
                KitHttpManager.takeTurn();
                if (initiated) {
                    handler = null;
                    main = null;
                    KitHttpManager.freeObjects();
                    initiated = (connectionSuccess = (connectionReady = false));
                }
                KitHttpManager.freeTurn();
            }
        };
        exe.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeTurn() {
        Signal signal = KitHttpManager.signal;
        synchronized (signal) {
            while (!KitHttpManager.signal.checkIn()) {
                try {
                    KitHttpManager.signal.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    KitHttpManager.addMessage("Thread exception => " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeTurn() {
        Signal signal = KitHttpManager.signal;
        synchronized (signal) {
            KitHttpManager.signal.free();
            KitHttpManager.signal.notify();
        }
    }

    private static void execInit() {
        Thread exe = new Thread(){

            public void run() {
                KitHttpManager.takeTurn();
                try {
                    KitHttpManager.checkInitiated();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    KitHttpManager.addMessage("General exception: " + e.getMessage());
                }
                KitHttpManager.freeTurn();
            }
        };
        exe.start();
    }

    private static void checkInitiated() {
        if (!initiated) {
            KitHttpManager.initConfig();
            initiated = true;
        }
    }

    private static void freeObjects() {
        configInfo = null;
        rankingRequest = null;
        submitScore = null;
        KitHttpManager.ranks.empty();
        ranks = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfig() {
        configInfo = new JSONObject();
        try {
            String family;
            int index;
            String gamecode = main.getAppProperty(GAME_CODE_PROPER);
            gamecode = gamecode.substring(0, gamecode.indexOf(","));
            int counter = 0;
            String aux = gamecode;
            while ((index = aux.indexOf("_")) != -1) {
                aux = aux.substring(index + 1, aux.length() - 1);
                ++counter;
            }
            try {
                if (counter != 2) {
                    throw new KitConException(KitConException.SYSTEM_PROBLEM, "3");
                }
                family = gamecode.substring(gamecode.lastIndexOf(95) + 1);
                gamecode = gamecode.substring(0, gamecode.lastIndexOf(95));
            }
            catch (KitConException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("Error in properties => " + ex.getMessage());
                family = null;
                gamecode = null;
            }
            String gameversion = main.getAppProperty(VER_PROPER);
            String deviceData = System.getProperty("microedition.platform");
            configInfo.put(GAME_CODE, gamecode != null ? gamecode : "");
            configInfo.put(GAME_VER, gameversion != null ? gameversion : "0.0.0");
            configInfo.put(LANGUAGE, new KitLang(KitLang.ENG).toString());
            configInfo.put(TIMES_PLAYED, 0);
            configInfo.put(FAMILY, family != null ? family : "nofamily");
            configInfo.put(DEVICE_DATA, deviceData != null ? deviceData : "null");
            configInfo.put(JSON_ADD, "");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
        }
        RecordStore storedConfig = null;
        try {
            storedConfig = RecordStore.openRecordStore((String)CONF_FILE, (boolean)false);
            if (storedConfig.getNumRecords() != 1) {
                RecordStore.deleteRecordStore((String)CONF_FILE);
                throw new RecordStoreNotFoundException();
            }
            byte[] buffer = storedConfig.getRecord(1);
            try {
                JSONObject savedConfig = new JSONObject(KitHttpManager.byteBuffAsString(buffer));
                configInfo.put(INSTALL_CODE, savedConfig.getString(INSTALL_CODE));
                configInfo.put(START_DATE, savedConfig.getString(START_DATE));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
        }
        catch (RecordStoreNotFoundException ex) {
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
            try {
                configInfo.put(INSTALL_CODE, "-1");
                configInfo.put(START_DATE, KitHttpManager.dateToFormat(new Date()));
            }
            catch (JSONException ex1) {
                ex1.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex1.getMessage());
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
        }
        finally {
            if (storedConfig != null) {
                try {
                    storedConfig.closeRecordStore();
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                    KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                    KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfig() {
        RecordStore storedConfig = null;
        try {
            storedConfig = RecordStore.openRecordStore((String)CONF_FILE, (boolean)true);
            JSONObject savedConfig = new JSONObject();
            try {
                savedConfig.put(INSTALL_CODE, configInfo.getString(INSTALL_CODE));
                savedConfig.put(START_DATE, configInfo.getString(START_DATE));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
            byte[] buffer = KitHttpManager.stringAsByteBuffer(savedConfig.toString());
            if (storedConfig.getNumRecords() == 0) {
                storedConfig.addRecord(buffer, 0, buffer.length);
            } else {
                storedConfig.setRecord(1, buffer, 0, buffer.length);
            }
        }
        catch (RecordStoreFullException ex) {
            System.out.println("Config record full.");
            ex.printStackTrace();
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
        }
        catch (RecordStoreNotFoundException ex) {
            System.out.println("Config record not found.");
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            System.out.println("Config record unknown error.");
            ex.printStackTrace();
            KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
        }
        finally {
            if (storedConfig != null) {
                try {
                    storedConfig.closeRecordStore();
                }
                catch (RecordStoreNotOpenException ex) {
                    System.out.println("Config record was not opened.");
                    ex.printStackTrace();
                    KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
                }
                catch (RecordStoreException ex) {
                    System.out.println("Config record unknown error.");
                    ex.printStackTrace();
                    KitHttpManager.addMessage("RecordStore exception => " + ex.getMessage());
                }
            }
        }
    }

    private static String byteBuffAsString(byte[] buffer) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            text.append((char)buffer[i]);
        }
        return text.toString();
    }

    private static byte[] stringAsByteBuffer(String chain) {
        byte[] result = new byte[chain.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)chain.charAt(i);
        }
        return result;
    }

    private static String dateToFormat(Date otherDate) {
        StringBuffer petition = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        Date today = new Date();
        calendar.setTime(today);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        petition.append(year).append("-").append(month < 10 ? "0" : "").append(month).append("-").append(day < 10 ? "0" : "").append(day).append(" ").append(hour < 10 ? "0" : "").append(hour).append(":").append(minute < 10 ? "0" : "").append(minute).append(":").append(second < 10 ? "0" : "").append(second);
        return petition.toString();
    }

    public static void addEmails(final String email) {
        Thread exe = new Thread(){

            public void run() {
                KitHttpManager.takeTurn();
                if (initiated) {
                    mailList.append(mailList.length() > 0 ? "," : "").append(email);
                    try {
                        JSONObject listEmails = new JSONObject();
                        listEmails.put(KitHttpManager.EMAILS, mailList.toString());
                        configInfo.put(KitHttpManager.JSON_ADD, listEmails.toString());
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                        KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    }
                } else {
                    try {
                        throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
                    }
                    catch (KitConException ex) {
                        ex.printStackTrace();
                    }
                }
                KitHttpManager.freeTurn();
            }
        };
        exe.start();
    }

    public static void setLanguage(KitLang newLang) {
        if (initiated) {
            try {
                configInfo.put(LANGUAGE, newLang.toString());
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setTotalTimesPlayed(int timesPlayed) {
        if (initiated) {
            try {
                configInfo.put(TIMES_PLAYED, timesPlayed);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setResultsNumber(int numResults) {
        if (initiated) {
            if (numResults > 0) {
                if (rankingRequest == null) {
                    rankingRequest = new JSONObject();
                }
                try {
                    rankingRequest.put(RES_RANK, numResults);
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                }
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setRequestedTables(boolean table1, boolean table2, boolean table3, boolean table4, boolean table5) {
        if (initiated) {
            if (table1 || table2 || table3 || table4 || table5) {
                if (rankingRequest == null) {
                    rankingRequest = new JSONObject();
                }
                try {
                    rankingRequest.put(RANKING1, table1 ? "yes" : "no");
                    rankingRequest.put(RANKING2, table2 ? "yes" : "no");
                    rankingRequest.put(RANKING3, table3 ? "yes" : "no");
                    rankingRequest.put(RANKING4, table4 ? "yes" : "no");
                    rankingRequest.put(RANKING5, table5 ? "yes" : "no");
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                }
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setRequestCurrentPosition(boolean getCurrentPos) {
        if (initiated) {
            if (rankingRequest == null) {
                rankingRequest = new JSONObject();
            }
            try {
                rankingRequest.put(MY_RANK, getCurrentPos ? "yes" : "no");
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean isConnectionReady() {
        return initiated && connectionReady;
    }

    public static boolean isConnectionSuccessful() {
        return initiated && connectionReady && connectionSuccess;
    }

    public static void requestScoreTables() {
        connectionReady = false;
        Thread exe = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block10: {
                    KitHttpManager.takeTurn();
                    try {
                        if (initiated) {
                            connectionSuccess = true;
                            handler.prepareScoreTablesPetition();
                            if (KitHttpManager.obtainRankingTables()) {
                                handler.processScoreTables();
                                KitHttpManager.saveConfig();
                            } else {
                                connectionSuccess = false;
                            }
                            connectionReady = true;
                            break block10;
                        }
                        try {
                            throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
                        }
                        catch (KitConException ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        KitHttpManager.addMessage("General exception => " + e.getMessage());
                    }
                    finally {
                        KitHttpManager.freeTurn();
                    }
                }
            }
        };
        exe.start();
    }

    private static boolean obtainRankingTables() {
        try {
            if (rankingRequest == null) {
                throw new KitConException(KitConException.REQUEST_RANKING_DETAILS, "0");
            }
            KitHttpManager.getInstallationCode();
            StringBuffer petition = new StringBuffer();
            petition.append("&installationcode=").append(configInfo.getString(INSTALL_CODE));
            petition.append("&jsonadditionaldata=").append(configInfo.getString(JSON_ADD));
            petition.append("&gamecode=").append(configInfo.getString(GAME_CODE));
            String charlist = rankingRequest.getString(RES_RANK);
            if (charlist != null) {
                petition.append("&results=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(RANKING1)) != null) {
                petition.append("&gettable1=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(RANKING2)) != null) {
                petition.append("&gettable2=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(RANKING3)) != null) {
                petition.append("&gettable3=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(RANKING4)) != null) {
                petition.append("&gettable4=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(RANKING5)) != null) {
                petition.append("&gettable5=").append(charlist);
            }
            if ((charlist = rankingRequest.getString(MY_RANK)) != null) {
                petition.append("&getcurrentposition=").append(charlist);
            }
            rankingRequest = null;
            String response = KitHttpManager.connectToServer(GET_RANKINGS_URL, petition.toString());
            try {
                if (response != null) {
                    JSONObject jsonResponse = new JSONObject(response);
                    String status = jsonResponse.getString(ANS_STATUS);
                    if (!status.equals("OK")) {
                        String status_details = jsonResponse.getString(ANS_DESCRIP);
                        throw new KitConException(KitConException.REQUEST_RANKING, status_details);
                    }
                    KitHttpManager.ranks.fill(jsonResponse);
                    return true;
                }
                throw new KitConException();
            }
            catch (KitConException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (KitConException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("KitConException => " + ex.getMessage());
            return false;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            return false;
        }
    }

    public static void submitScore() {
        connectionReady = false;
        Thread exe = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block10: {
                    KitHttpManager.takeTurn();
                    try {
                        if (initiated) {
                            connectionSuccess = true;
                            handler.prepareSubmitScore();
                            if (KitHttpManager.uploadScore()) {
                                KitHttpManager.saveConfig();
                            } else {
                                connectionSuccess = false;
                            }
                            connectionReady = true;
                            break block10;
                        }
                        try {
                            throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
                        }
                        catch (KitConException ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        KitHttpManager.addMessage("General exception => " + e.getMessage());
                    }
                    finally {
                        KitHttpManager.freeTurn();
                    }
                }
            }
        };
        exe.start();
    }

    private static boolean uploadScore() {
        if (KitHttpManager.checkScoreForm()) {
            try {
                int charlist;
                if (submitScore == null) {
                    throw new KitConException(KitConException.SUBMIT_SCORE_DETAILS, "0");
                }
                KitHttpManager.getInstallationCode();
                StringBuffer petition = new StringBuffer();
                petition.append("&installationcode=").append(configInfo.getString(INSTALL_CODE));
                petition.append("&gamecode=").append(configInfo.getString(GAME_CODE));
                petition.append("&name=").append(submitScore.getString(NAME_SCR));
                petition.append("&avatar=").append(submitScore.getString(AVATAR_SCR));
                petition.append("&totalgames=").append(configInfo.getInt(TIMES_PLAYED));
                petition.append("&bestscoretable1=").append(submitScore.getString(BEST1));
                try {
                    charlist = submitScore.getInt(BEST2);
                    if (charlist != -1) {
                        petition.append("&bestscoretable2=").append(charlist);
                    }
                }
                catch (JSONException ex) {
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    charlist = -1;
                }
                try {
                    charlist = submitScore.getInt(BEST3);
                    if (charlist != -1) {
                        petition.append("&bestscoretable3=").append(charlist);
                    }
                }
                catch (JSONException ex) {
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    charlist = -1;
                }
                try {
                    charlist = submitScore.getInt(BEST4);
                    if (charlist != -1) {
                        petition.append("&bestscoretable4=").append(charlist);
                    }
                }
                catch (JSONException ex) {
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    charlist = -1;
                }
                try {
                    charlist = submitScore.getInt(BEST5);
                    if (charlist != -1) {
                        petition.append("&bestscoretable5=").append(charlist);
                    }
                }
                catch (JSONException ex) {
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    charlist = -1;
                }
                petition.append("&language=").append(configInfo.getString(LANGUAGE));
                petition.append("&jsonadditionaldata=").append(configInfo.getString(JSON_ADD));
                submitScore = null;
                String response = KitHttpManager.connectToServer(SUBMIT_SCORE_URL, petition.toString());
                try {
                    if (response != null) {
                        JSONObject jsonResponse = new JSONObject(response);
                        String status = jsonResponse.getString(ANS_STATUS);
                        if (!status.equals("OK")) {
                            String status_details = jsonResponse.getString(ANS_DESCRIP);
                            throw new KitConException(KitConException.SUBMIT_SCORE, status_details);
                        }
                        return true;
                    }
                    throw new KitConException();
                }
                catch (KitConException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (KitConException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("KitConException => " + ex.getMessage());
                return false;
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                return false;
            }
        }
        return false;
    }

    public static void registerApplication() {
        connectionReady = false;
        Thread exe = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block10: {
                    KitHttpManager.takeTurn();
                    try {
                        if (initiated) {
                            connectionSuccess = true;
                            if (KitHttpManager.registerConnection()) {
                                KitHttpManager.saveConfig();
                            } else {
                                connectionSuccess = false;
                            }
                            connectionReady = true;
                            break block10;
                        }
                        try {
                            throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
                        }
                        catch (KitConException ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        KitHttpManager.addMessage("General exception => " + e.getMessage());
                    }
                    finally {
                        KitHttpManager.freeTurn();
                    }
                }
            }
        };
        exe.start();
    }

    private static boolean registerConnection() {
        boolean result;
        KitHttpManager.getInstallationCode();
        try {
            String storedInstallCode = configInfo.getString(INSTALL_CODE);
            result = storedInstallCode != null && !storedInstallCode.equals("-1");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            return false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkScoreForm() {
        boolean result;
        boolean bl = result = submitScore != null;
        if (result) {
            try {
                submitScore.getString(NAME_SCR);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                System.err.println("No name for score specified.");
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                result = false;
            }
            finally {
                try {
                    submitScore.getInt(BEST1);
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                    System.err.println("No score for ranking table number 1 specified.");
                    KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    result = false;
                }
            }
        } else {
            System.err.println("No information specified for submit score form");
        }
        return result;
    }

    public static void setName(String name) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(NAME_SCR, name);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setAvatar(String avIndex) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(AVATAR_SCR, avIndex);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setScore1(int points) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(BEST1, points);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setScore2(int points) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(BEST2, points);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setScore3(int points) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(BEST3, points);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setScore4(int points) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(BEST4, points);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setScore5(int points) {
        if (initiated) {
            if (submitScore == null) {
                submitScore = new JSONObject();
            }
            try {
                submitScore.put(BEST5, points);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
            }
        } else {
            try {
                throw new KitConException(KitConException.SYSTEM_PROBLEM, "0");
            }
            catch (KitConException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void getInstallationCode() {
        try {
            String storedInstallCode = configInfo.getString(INSTALL_CODE);
            if (storedInstallCode == null || storedInstallCode.equals("-1")) {
                StringBuffer petition = new StringBuffer();
                JSONObject jsonPetition = new JSONObject();
                jsonPetition.put(GAME_CODE, configInfo.getString(GAME_CODE));
                jsonPetition.put(GAME_VER, configInfo.getString(GAME_VER));
                jsonPetition.put(LANGUAGE, configInfo.getString(LANGUAGE));
                jsonPetition.put(TIMES_PLAYED, configInfo.getInt(TIMES_PLAYED));
                jsonPetition.put(FAMILY, configInfo.getString(FAMILY));
                jsonPetition.put(DEVICE_DATA, configInfo.getString(DEVICE_DATA));
                jsonPetition.put(START_DATE, configInfo.getString(START_DATE));
                jsonPetition.put(JSON_ADD, configInfo.getString(JSON_ADD));
                petition.append("&gamecode=").append(jsonPetition.getString(GAME_CODE));
                petition.append("&gameversion=").append(jsonPetition.getString(GAME_VER));
                petition.append("&language=").append(jsonPetition.getString(LANGUAGE));
                petition.append("&totalgames=").append(jsonPetition.getInt(TIMES_PLAYED));
                petition.append("&family=").append(jsonPetition.getString(FAMILY));
                petition.append("&devicedata=").append(jsonPetition.getString(DEVICE_DATA));
                petition.append("&firstexecutiondate=").append(jsonPetition.getString(START_DATE));
                petition.append("&jsonadditionaldata=").append(jsonPetition.getString(JSON_ADD));
                String response = KitHttpManager.connectToServer(INSTALL_CODE_URL, petition.toString());
                try {
                    JSONObject jsonResponse;
                    if (response != null) {
                        jsonResponse = new JSONObject(response);
                        String status = jsonResponse.getString(ANS_STATUS);
                        if (!status.equals("OK")) {
                            String status_details = jsonResponse.getString(ANS_DESCRIP);
                            throw new KitConException(KitConException.DEMAND_INSTALL_CODE, status_details);
                        }
                    } else {
                        throw new KitConException();
                    }
                    configInfo.put(INSTALL_CODE, jsonResponse.getString(INSTALL_CODE));
                }
                catch (KitConException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String connectToServer(String URL2, String message) {
        HttpConnection c = null;
        FilterInputStream is = null;
        OutputStream os = null;
        StringBuffer content = new StringBuffer();
        try {
            try {
                if (c == null) {
                    c = (HttpConnection)Connector.open((String)(SERVER_URL + URL2));
                }
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                c.setRequestProperty("Content-Length", String.valueOf(message.getBytes().length));
                os = c.openOutputStream();
                os.write(message.getBytes());
                os.flush();
                int rc = c.getResponseCode();
                if (rc != 200) {
                    throw new IOException("HTTP response code: " + rc);
                }
                is = new DataInputStream(c.openInputStream());
                try {
                    while (is != null) {
                        content.append((char)((DataInputStream)is).readUnsignedByte());
                    }
                }
                catch (EOFException e) {
                    KitHttpManager.addMessage("EOF exception => " + e.getMessage());
                    try {
                        is.close();
                    }
                    catch (Exception a) {
                        a.printStackTrace();
                        KitHttpManager.addMessage("General exception => " + a.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    KitHttpManager.addMessage("General exception => " + e.getMessage());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("IO exception => " + ex.getMessage());
            }
            catch (ClassCastException e) {
                KitHttpManager.addMessage("Class cast exception => " + e.getMessage());
                throw new IllegalArgumentException("Not an HTTP URL");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("IO exception on DataInputStream for connection process => " + ex.getMessage());
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("IO exception on OutputStream for connection process => " + ex.getMessage());
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            KitHttpManager.addMessage("IO exception on HttpConnection for connection process => " + ex.getMessage());
        }
        return content.length() == 0 ? null : content.toString();
    }

    static {
        initiated = false;
        connectionSuccess = false;
        connectionReady = true;
        signal = new Signal();
    }

    private static class Signal {
        private boolean turn = true;

        private Signal() {
        }

        private boolean checkIn() {
            boolean result = this.turn;
            this.turn = false;
            return result;
        }

        private void free() {
            this.turn = true;
        }
    }

    private static class Ranking {
        private TableList[] tables;

        private Ranking() {
        }

        private void empty() {
            if (this.tables != null) {
                for (int i = 0; i < this.tables.length; ++i) {
                    if (this.tables[i] == null) continue;
                    this.tables[i].empty();
                    this.tables[i] = null;
                }
                this.tables = null;
            }
        }

        private void fill(JSONObject rankings) {
            try {
                this.empty();
                this.tables = new TableList[5];
                for (int i = 0; i < 5; ++i) {
                    int currentposition;
                    JSONObject table = rankings.getJSONObject("table" + (i + 1));
                    this.fillTable(i, table.get(KitHttpManager.RES_RANK) != JSONObject.NULL ? table.getJSONArray(KitHttpManager.RES_RANK) : null);
                    try {
                        currentposition = table.getInt("currentposition");
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                        KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                        currentposition = 0;
                    }
                    if (currentposition != 0) {
                        this.tables[i].addPlayerRank(currentposition, table.getString("currentname"), table.getString("currentavatar"), table.getInt("currentscore"));
                        continue;
                    }
                    this.tables[i].addPlayerRank(currentposition, null, null, 0);
                }
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                this.empty();
            }
        }

        private void fillTable(int tableIndex, JSONArray jsonResultsTable) {
            if (jsonResultsTable != null) {
                int tableLenght = jsonResultsTable.length();
                this.tables[tableIndex] = new TableList(tableLenght);
                for (int i = 0; i < tableLenght; ++i) {
                    try {
                        JSONObject tableRecord = jsonResultsTable.getJSONObject(i);
                        this.tables[tableIndex].addRecord(tableRecord.getString(KitHttpManager.NAME_SCR), tableRecord.getString(KitHttpManager.AVATAR_SCR), tableRecord.getInt("score"));
                        continue;
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                        KitHttpManager.addMessage("JSON exception => " + ex.getMessage());
                    }
                }
            } else {
                this.tables[tableIndex] = new TableList(0);
            }
        }

        private String getName(int tableIndex, int recordIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getName(recordIndex);
            }
            return "nobody";
        }

        private String getAvatar(int tableIndex, int recordIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getAvatar(recordIndex);
            }
            return "noavatar";
        }

        private int getScore(int tableIndex, int recordIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getScore(recordIndex);
            }
            return Integer.MIN_VALUE;
        }

        private int getPlayerPos(int tableIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getPlayerPos();
            }
            return -1;
        }

        private String getPlayerName(int tableIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getPlayerName();
            }
            return "nobody";
        }

        private String getPlayerAvatar(int tableIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getPlayerAvatar();
            }
            return "noavatar";
        }

        private int getPlayerScore(int tableIndex) {
            if (this.tables != null && tableIndex > -1 && tableIndex < 5 && this.tables[tableIndex] != null) {
                return this.tables[tableIndex].getPlayerScore();
            }
            return -1;
        }

        private class TableList {
            private Record[] records;
            private int playerPos;
            private int numRecords;

            private TableList(int newNumRecords) {
                this.records = new Record[(newNumRecords < 0 ? 0 : newNumRecords) + 1];
                this.numRecords = 0;
            }

            private void addRecord(String name, String avatar, int score) {
                if (this.numRecords < this.records.length - 1 && name != null && name.length() > 0 && avatar != null) {
                    this.records[this.numRecords] = new Record(name, avatar, score);
                    ++this.numRecords;
                }
            }

            private String getName(int index) {
                if (index > -1 && index < this.numRecords) {
                    return this.records[index].getName();
                }
                return "nobody";
            }

            private String getAvatar(int index) {
                if (index > -1 && index < this.numRecords) {
                    return this.records[index].getAvatar();
                }
                return "noavatar";
            }

            private int getScore(int index) {
                if (index > -1 && index < this.numRecords) {
                    return this.records[index].getScrore();
                }
                return Integer.MIN_VALUE;
            }

            private void addPlayerRank(int pos, String name, String avatar, int score) {
                if (this.records[this.records.length - 1] == null && pos > 0 && name != null && name.length() > 0 && avatar != null) {
                    this.playerPos = pos;
                    this.records[this.records.length - 1] = new Record(name, avatar, score);
                }
            }

            private int getPlayerPos() {
                if (this.records[this.records.length - 1] != null) {
                    return this.playerPos;
                }
                return -1;
            }

            private String getPlayerName() {
                if (this.records[this.records.length - 1] != null) {
                    return this.records[this.records.length - 1].getName();
                }
                return "nobody";
            }

            private String getPlayerAvatar() {
                if (this.records[this.records.length - 1] != null) {
                    return this.records[this.records.length - 1].getAvatar();
                }
                return "noavatar";
            }

            private int getPlayerScore() {
                if (this.records[this.records.length - 1] != null) {
                    return this.records[this.records.length - 1].getScrore();
                }
                return -1;
            }

            private int length() {
                return this.records != null ? this.records.length : 0;
            }

            private void empty() {
                if (this.records != null) {
                    for (int i = 0; i < this.records.length; ++i) {
                        this.records[i] = null;
                    }
                    this.records = null;
                    this.numRecords = 0;
                }
            }

            private class Record {
                private String name;
                private String avatar;
                private int score;

                private Record(String newName, String newAvatar, int newScore) {
                    this.name = newName;
                    this.avatar = newAvatar;
                    this.score = newScore;
                }

                private String getName() {
                    return this.name;
                }

                private String getAvatar() {
                    return this.avatar;
                }

                private int getScrore() {
                    return this.score;
                }
            }
        }
    }
}

