/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer.objects;

import com.kitmaker.riosupersoccer.Game;
import com.kitmaker.riosupersoccer.Gfx;
import com.kitmaker.riosupersoccer.SP;
import com.kitmaker.riosupersoccer.SndManager;
import com.kitmaker.riosupersoccer.WelderTools.WeeldSprite;
import com.kitmaker.riosupersoccer.WorldPhysics;
import com.kitmaker.riosupersoccer.objects.Ball;
import com.kitmaker.riosupersoccer.objects.Object;
import com.kitmaker.riosupersoccer.tool.Math2D;
import javax.microedition.lcdui.Graphics;

public abstract class Soccerman
extends Object {
    protected WeeldSprite vWeeldSoccerman;
    protected WeeldSprite vWeeldSoccermanExp;
    private static final int NUMBER_SPRITES_PLAYERS = 10;
    private static final int NUMBER_SPRITES_EXPLOSIONS = 8;
    private static final int NUMBER_SPRITES = 18;
    public static int iIDWeelder = 10;
    public static int iIDWeelderExp = 0;
    public static final int NONE = -1;
    public static final int SUPERSHOOT_N = 0;
    public static final int SUPERSHOOT_S = 1;
    public static int iStateSuperShoot = -1;
    public static boolean isDeceleration = true;
    private boolean isDecelerating = false;
    private int iInitLogicAngle;
    private long lCurrentIncX;
    private long lCurrentIncY;
    private long lLimitIncX;
    private long lLimitIncY;
    protected int iTypeSoccerman;
    public static final int TYPE_PLAYER_IA = 0;
    public static final int TYPE_GOALIE = 1;
    protected boolean isControlable;
    protected static int[] iAlineationPlayable = new int[]{-1, -1};
    public int iAreaAlineation;
    public static final int AREA_0 = 0;
    public static final int AREA_1 = 1;
    public static final int AREA_2 = 2;
    public static final int AREA_3 = 3;
    public static final int AREA_4 = 4;
    public static final int AREA_5 = 5;
    public static final int AREA_6 = 6;
    public static final int AREA_7 = 7;
    public static final int AREA_8 = 8;
    public static final int AREA_9 = 9;
    public static final int AREA_10 = 10;
    public static final int AREA_11 = 11;
    public static final int AREA_12 = 12;
    public static final int AREA_13 = 13;
    public static final int AREA_14 = 14;
    public static final int AREA_15 = 15;
    public static final int AREA_16 = 16;
    public static final int AREA_17 = 17;
    public static final int AREA_18 = 18;
    public static final int AREA_19 = 19;
    public static final int AREA_20 = 20;
    public static final int AREA_21 = 21;
    public int iMyField;
    public static final int FIELD_NORTH = 0;
    public static final int FIELD_SOUTH = 1;
    protected long iActionArea;
    protected static int iBallPosesionID;
    protected static int iIdKO;
    private int iStateAction;
    protected int iNewStateAction;
    public static final int ST_ACT_NONE = 0;
    public static final int ST_ACT_RUNNING = 1;
    public static final int ST_ACT_SHOOTING = 2;
    public static final int ST_ACT_PASSING = 3;
    public static final int ST_ACT_MOWING = 4;
    public static final int ST_ACT_KO = 5;
    public static final int ST_ACT_EXPLOTING = 6;
    public static final int ST_ACT_MOVING_LEFT = 7;
    public static final int ST_ACT_MOVING_RIGHT = 8;
    public static final int ST_ACT_CATCHBALL = 9;
    public static final int ST_ACT_JUMPING_LEFT = 10;
    public static final int ST_ACT_JUMPING_RIGHT = 11;
    public static final int ANGLE_DIR_NORTH = 90;
    public static final int ANGLE_DIR_NORTH_EAST = 45;
    public static final int ANGLE_DIR_WEST = 180;
    public static final int ANGLE_DIR_EAST = 0;
    public static final int ANGLE_DIR_SOUTH_EAST = 315;
    public static final int ANGLE_DIR_SOUTH = 270;
    public static final int ANGLE_DIR_SOUTH_WEST = 225;
    public static final int ANGLE_DIR_NORTH_WEST = 135;
    protected int iAngleMow;
    protected int iCurrentAnimation;
    protected boolean isBucle;
    public static final int ANIM_NONE_N = 0;
    public static final int ANIM_NONE_S = 1;
    public static final int ANIM_NONE_W = 2;
    public static final int ANIM_NONE_E = 3;
    public static final int ANIM_NONE_NW = 4;
    public static final int ANIM_NONE_NE = 5;
    public static final int ANIM_NONE_SW = 6;
    public static final int ANIM_NONE_SE = 7;
    public static final int ANIM_RUN_N = 8;
    public static final int ANIM_RUN_S = 9;
    public static final int ANIM_RUN_W = 10;
    public static final int ANIM_RUN_E = 11;
    public static final int ANIM_RUN_NW = 12;
    public static final int ANIM_RUN_NE = 13;
    public static final int ANIM_RUN_SW = 14;
    public static final int ANIM_RUN_SE = 15;
    public static final int ANIM_SHOOT_N = 16;
    public static final int ANIM_SHOOT_S = 17;
    public static final int ANIM_SHOOT_W = 18;
    public static final int ANIM_SHOOT_E = 19;
    public static final int ANIM_SHOOT_NW = 20;
    public static final int ANIM_SHOOT_NE = 21;
    public static final int ANIM_SHOOT_SW = 22;
    public static final int ANIM_SHOOT_SE = 23;
    public static final int ANIM_MOW_N = 24;
    public static final int ANIM_MOW_S = 25;
    public static final int ANIM_MOW_W = 26;
    public static final int ANIM_MOW_E = 27;
    public static final int ANIM_MOW_NW = 28;
    public static final int ANIM_MOW_NE = 29;
    public static final int ANIM_MOW_SW = 30;
    public static final int ANIM_MOW_SE = 31;
    public static final int ANIM_KO_N = 32;
    public static final int ANIM_KO_S = 33;
    public static final int ANIM_EXPLOSION = 0;
    public static final int ANIM_GOALIE_NONE_N = 0;
    public static final int ANIM_GOALIE_NONE_S = 1;
    public static final int ANIM_GOALIE_LEFT_N = 2;
    public static final int ANIM_GOALIE_RIGHT_N = 3;
    public static final int ANIM_GOALIE_LEFT_S = 4;
    public static final int ANIM_GOALIE_RIGHT_S = 5;
    public static final int ANIM_GOALIE_CATCHBALL_N = 6;
    public static final int ANIM_GOALIE_CATCHBALL_S = 7;
    public static final int ANIM_GOALIE_JUMPING_LEFT_N = 8;
    public static final int ANIM_GOALIE_JUMPING_RIGHT_N = 9;
    public static final int ANIM_GOALIE_JUMPING_LEFT_S = 10;
    public static final int ANIM_GOALIE_JUMPING_RIGHT_S = 11;
    public static final int ANIM_GOALIE_SHOOT_N = 12;
    public static final int ANIM_GOALIE_SHOOT_S = 13;
    public static final int ANIM_GOALIE_KO_N = 14;
    public static final int ANIM_GOALIE_KO_S = 15;
    protected static boolean isAlertGoal;
    protected static boolean isGoalieBall;
    public static boolean isSuperShootPlayer;
    public static boolean isSuperShootEnemy;
    public static long SPEED;
    public static long SPEED_BALL;
    public static long SPEED_MOW;
    public static long SPEED_GOALIE;
    public static long SPEED_GOALIE_JUMP;
    protected long lCurrentSpeed;
    protected long lCounterAction;
    protected static long MINIM_DURATION_ACTION;
    protected static int iLastAnimation;
    protected long lNearPlayDistantX;
    protected long lNearPlayDistantY;
    protected long lNearPlayPosX;
    protected long lNearPlayPosY;
    protected int iNearPlayAngle;
    protected int iNearPlayState;
    protected int iNearPlayAlienation;
    protected long lObjetiveX;
    protected long lObjetiveY;
    protected int iLayerSoccerman;
    protected long lPosMineX;
    protected long lPosMineY;
    public static boolean isFirstPass;
    public static final int DOMAIN_NONE = 0;
    public static final int DOMAIN_PLAYER = 1;
    public static final int DOMAIN_IA = 2;

    public Soccerman(int _lPosX, int _lPosY, int _iPosZ, long _lWorldWidth, long _lWorldHeight, int _iPrecionBits, int _typeSoccerman, int _iAreaAliniation, String _sPathHead, String _sPathAnuBody, boolean _isControlable) {
        super(_lPosX, _lPosY, _iPosZ, _lWorldWidth, _lWorldHeight, _iPrecionBits);
        this.iTypeSoccerman = _typeSoccerman;
        this.iAreaAlineation = _iAreaAliniation;
        this.iAreaAlineation = _iAreaAliniation;
        lWidth = 7168L;
        lHeight = 10752L;
        this.iActionArea = (lWidth + lHeight) / 2L * 3L;
        this.isControlable = _isControlable;
        if (this.iTypeSoccerman == 0) {
            this.vWeeldSoccerman = new WeeldSprite(iIDWeelder++, new String[]{"/bodies.png", _sPathHead}, _sPathAnuBody, 0, 0, 18);
            this.vWeeldSoccerman.loadPoolImage(_isControlable ? (byte)1 : 2);
            if (Gfx.mina != null) {
                this.vWeeldSoccermanExp = new WeeldSprite(iIDWeelderExp++, new String[]{"/explosion.png"}, "/explosion.anu", 0, 0, 18);
                this.vWeeldSoccermanExp.loadPoolImage((byte)4);
            }
        } else {
            this.vWeeldSoccerman = new WeeldSprite(iIDWeelder++, new String[]{"/goalie.png"}, "/portero.anu", 0, 0, 18);
            this.vWeeldSoccerman.loadPoolImage((byte)3);
        }
        SPEED = isDeceleration ? 32768L : 24576L;
        SPEED = SPEED / 4L * 3L;
        SPEED_BALL = SPEED / 4L * 3L;
        SPEED_MOW = SPEED;
        SPEED_GOALIE = 16384L;
        SPEED_GOALIE_JUMP = SPEED_GOALIE + SPEED_GOALIE / 4L;
    }

    public void update(long _lDeltaTime) {
    }

    public void update(long _lDeltaTime, Soccerman[] _vOtherPlayers, Ball _vBall) {
        this.lIncrementX = 0L;
        this.lIncrementY = 0L;
        if (this.iTypeSoccerman == 1) {
            if (this.getStateAction() == 10) {
                this.setPosX(this.getPosX() - this.lCurrentSpeed);
            } else if (this.getStateAction() == 11) {
                this.setPosX(this.getPosX() + this.lCurrentSpeed);
            }
            if (this.getStateAction() == 7 && this.getPosX() > (WorldPhysics.getWorldWidth() >> 1) - 11520L) {
                this.setPosX(this.getPosX() - this.lCurrentSpeed);
            }
        } else {
            this.putPlayables(_vOtherPlayers, _vBall);
        }
        this.updateFormatCollide(_vBall);
        if (this.vWeeldSoccerman.getAnimation() != this.iCurrentAnimation) {
            this.vWeeldSoccerman.setAnimation(this.iCurrentAnimation, this.isBucle);
        }
        this.vWeeldSoccerman.update();
        if (this.vWeeldSoccerman.loopFinished() || !this.vWeeldSoccerman.isPlaying()) {
            this.iStateAction = 0;
            this.updateAnimation();
        }
    }

    public void update(long _lDeltaTime, Soccerman[] _vOtherPlayers, Ball _vBall, boolean _isHavePower) {
        this.iInitLogicAngle = this.iAngle;
        this.lNearPlayDistantX = this.lWorldWidth;
        this.lNearPlayDistantY = this.lWorldHeight;
        if ((_vBall.getDomain() == 0 || _vBall.getDomain() == 21) && this.iStateAction != 2) {
            this.goToMyArea(WorldPhysics.getMargin());
        } else {
            this.putPlayables(_vOtherPlayers, _vBall);
            if (this.isPlayable()) {
                if (this.isControlable) {
                    this.listenControls(_vBall);
                } else {
                    this.IAControls(_vBall, _vOtherPlayers, _lDeltaTime);
                }
            } else {
                this.putAutoControl(_vBall);
            }
        }
        this.updateState();
        this.resolutionState(_lDeltaTime, _vBall);
        this.updateCollide(_vBall);
        this.moveSoccerman(_lDeltaTime, _vBall);
        this.updateAnimation();
        this.lCounterAction = iLastAnimation == this.getCurrentAnimation() ? (this.lCounterAction += _lDeltaTime) : 0L;
        if (this.iStateAction != 6) {
            if (this.vWeeldSoccerman.getAnimation() != this.iCurrentAnimation) {
                this.vWeeldSoccerman.setAnimation(this.iCurrentAnimation, this.isBucle);
            }
            this.vWeeldSoccerman.update();
        } else if (Gfx.mina != null) {
            this.vWeeldSoccermanExp.update();
        }
    }

    protected void goToMyArea(long _lWorldMarign) {
        if (this.isCollide(this.getZoneAreaX(this.lWorldWidth, this.lWorldHeight, _lWorldMarign), this.getZoneAreaY(this.lWorldWidth, this.lWorldHeight, _lWorldMarign), lWidth, lHeight)) {
            this.iNewStateAction = 0;
        } else {
            this.iAngle = Math2D.getAngle360(this.lPosX, this.lPosY, this.getZoneAreaX(this.lWorldWidth, this.lWorldHeight, _lWorldMarign), this.getZoneAreaY(this.lWorldWidth, this.lWorldHeight, _lWorldMarign));
            this.iNewStateAction = 1;
        }
    }

    private void putPlayables(Soccerman[] _vOtherPlayers, Ball _vBall) {
        this.setNearDataPlayer(_vOtherPlayers, _vBall);
        if (iBallPosesionID != this.iAreaAlineation) {
            int anotherDist;
            int iDist = (int)(this.getDistanceBallX(_vBall) + this.getDistanceBallY(_vBall));
            if (iDist > (anotherDist = (int)(this.lNearPlayDistantX + this.lNearPlayDistantY)) || this.iStateAction == 5 || this.iStateAction == 6) {
                this.setAlineationPlayable(this.iNearPlayAlienation);
            } else {
                this.setAlineationPlayable(this.iAreaAlineation);
            }
        } else {
            this.setAlineationPlayable(this.iAreaAlineation);
        }
    }

    protected void putAutoControl(Ball _vBall) {
        if (this.getStateAction() == 0 || this.getStateAction() == 1) {
            this.iNewStateAction = 1;
            if (this.iNearPlayState == 1 && this.getDistanceBallX(_vBall) + this.getDistanceBallY(_vBall) >> 1 > this.iActionArea >> 1 && this.isGoToAtack(this.iNearPlayAngle) && !this.isInArea(this.lPosY)) {
                this.iAngle = this.iNearPlayAngle;
            } else if (this.isCollide(this.lObjetiveX, this.lObjetiveY, lWidth, lHeight) || this.isOutLimitHeight(this.lPosY) || this.isOutLimitWidth(this.lPosX)) {
                this.putUncheckObj(_vBall);
                this.iAngle = Math2D.getAngle360(this.getPosX(), this.getPosY(), this.lObjetiveX, this.lObjetiveY);
            }
        }
    }

    protected boolean isGoToAtack(int _iAngle) {
        if (this.iMyField == 0) {
            return _iAngle > 225 && _iAngle < 315;
        }
        return _iAngle > 45 && _iAngle < 135;
    }

    protected boolean isOutLimitHeight(long _lPosY) {
        return _lPosY + lHeight > WorldPhysics.getWorldHeight() - WorldPhysics.getMargin() - WorldPhysics.getiLineThickness() - (long)(1 << iPrecisionBits) || _lPosY < WorldPhysics.getMargin() + WorldPhysics.getiLineThickness() + (long)(1 << iPrecisionBits);
    }

    protected boolean isOutLimitWidth(long _lPosX) {
        return _lPosX + lWidth > WorldPhysics.getWorldWidth() - WorldPhysics.getMargin() - WorldPhysics.getiLineThickness() - (long)(1 << iPrecisionBits) || _lPosX < WorldPhysics.getMargin() + WorldPhysics.getiLineThickness() + (long)(1 << iPrecisionBits);
    }

    protected boolean isMoreNearToGoal(Soccerman[] _vOtherPlayers) {
        long otherY = this.iMyField == 0 ? 0L : this.lWorldHeight;
        for (int i = 0; i < _vOtherPlayers.length; ++i) {
            if (_vOtherPlayers[i].getAreaAlineation() == this.iAreaAlineation) continue;
            if (this.iMyField == 0) {
                if (_vOtherPlayers[i].getPosY() <= this.lPosY) continue;
                otherY = _vOtherPlayers[i].getPosY();
                continue;
            }
            if (_vOtherPlayers[i].getPosY() >= this.lPosY) continue;
            otherY = _vOtherPlayers[i].getPosY();
        }
        if (this.iMyField == 0) {
            return otherY <= this.lPosY;
        }
        return otherY >= this.lPosY;
    }

    private boolean isMayTo44() {
        if (Math2D.getDif360(this.iInitLogicAngle, this.iAngle) > 44) {
            if (this.isThePlayable()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    protected void updateState() {
        if (iIdKO == this.iAreaAlineation) {
            iIdKO = -1;
            this.iStateAction = 5;
            SndManager.PlayFX((byte)2, 0);
            return;
        }
        if (this.iStateAction == 3 || this.iStateAction == 2 || this.iStateAction == 4 || this.iStateAction == 5 || this.iStateAction == 6) {
            if (this.iStateAction == 6) {
                if (this.vWeeldSoccermanExp.loopFinished()) {
                    this.iStateAction = 0;
                }
            } else {
                if (this.vWeeldSoccerman.loopFinished() || !this.vWeeldSoccerman.isPlaying()) {
                    this.iStateAction = 0;
                }
                if (isDeceleration && this.iStateAction == 4) {
                    this.isDecelerating = true;
                }
            }
            return;
        }
        switch (this.iNewStateAction) {
            case 0: 
            case 1: {
                if (isDeceleration && (this.iNewStateAction == 0 || this.isMayTo44()) && (this.iStateAction == 1 || this.iStateAction == 4)) {
                    this.isDecelerating = true;
                }
                this.iStateAction = this.iNewStateAction;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (isDeceleration && (this.iStateAction == 1 || this.iStateAction == 4)) {
                    this.isDecelerating = true;
                }
                if (this.iStateAction != 0 && this.iStateAction != 1) break;
                this.iStateAction = this.iNewStateAction;
                if (this.iNewStateAction != 4) break;
                this.iAngleMow = this.iAngle;
                if (!isDeceleration) break;
                this.isDecelerating = false;
            }
        }
    }

    protected void resolutionState(long _lDeltaTime, Ball _vBall) {
        if (this.iStateAction != 4) {
            this.lCurrentSpeed = this.isPlayable() ? (this.isWithBall() || this.isCollide(_vBall.getPosX(), _vBall.getPosY(), _vBall.getWidth() << 1, _vBall.getHeight() << 1) ? SPEED_BALL : SPEED) : (this.iNearPlayState == 1 ? SPEED_BALL : SPEED);
            if (this.iStateAction == 2 && this.isWithBall() && this.isPlayable()) {
                if (Game.iHaveThePowerPlayer && this.isControlable || Game.iHaveThePowerEnemy && !this.isControlable) {
                    if (this.iMyField == 0) {
                        _vBall.putDataAngle(270, 3);
                        iStateSuperShoot = 1;
                        this.iAngle = 270;
                    } else {
                        _vBall.putDataAngle(90, 3);
                        iStateSuperShoot = 0;
                        this.iAngle = 90;
                    }
                    if (this.isControlable) {
                        Game.resetLevelPlayer();
                    } else {
                        Game.resetLevelEnemy();
                    }
                    SndManager.PlayFX((byte)1, 0);
                    isSuperShootPlayer = this.isControlable;
                    isSuperShootEnemy = !this.isControlable;
                } else {
                    _vBall.putDataAngle(this.iAngle, 1);
                }
                _vBall.resetPlayerMovement();
                _vBall.setFree(true);
                iBallPosesionID = -1;
                isAlertGoal = true;
            } else if (this.iStateAction == 3 && this.isWithBall() && this.isPlayable()) {
                _vBall.putDataAngle(Math2D.getAngle360(this.getPosX(), this.getPosY(), this.lNearPlayPosX - (_vBall.getWidth() >> 1), this.lNearPlayPosY - (_vBall.getHeight() >> 1)), 0);
                _vBall.resetPlayerMovement();
                _vBall.setFree(true);
                iBallPosesionID = -1;
                isFirstPass = false;
            }
        } else if (this.iStateAction == 4) {
            this.lCurrentSpeed = SPEED_MOW;
        }
    }

    public void drawShadow(Graphics _g, int _lPosX, int _lPosY, int _iScrWidth, int _iScrHeight) {
        if (Gfx.shadowPlayer != null && this.isDrawInScreen(_lPosX, _lPosY, _iScrWidth, _iScrHeight) && this.iStateAction != 6) {
            _g.drawImage(Gfx.shadowPlayer, _lPosX + (int)(this.getWidth() >> iPrecisionBits >> 1), _lPosY + (int)(this.getHeight() >> iPrecisionBits), 3);
        }
    }

    protected abstract void drawSelector(Graphics var1, int var2, int var3, Ball var4);

    public void draw(Graphics _g, int _lPosX, int _lPosY, int iPosZ, int _iScrWidth, int _iScrHeight, Ball _vBall) {
        this.drawSelector(_g, _lPosX, _lPosY, _vBall);
        if (this.iStateAction != 6) {
            this.vWeeldSoccerman.setDrawPosition(_lPosX + (int)(lWidth >> 1 >> iPrecisionBits), _lPosY + (int)(lHeight >> iPrecisionBits));
            if (this.isDrawInScreen(_lPosX, _lPosY, _iScrWidth, _iScrHeight)) {
                this.vWeeldSoccerman.drawFrame(_g);
            }
        } else {
            this.vWeeldSoccermanExp.setDrawPosition(WorldPhysics.getConversionDrawX(_vBall.getPosDrawX(), (int)(this.lPosMineX >> 8) + (Gfx.mina.getWidth() / 3 >> 1)), WorldPhysics.getConversionDrawY(_vBall.getPosDrawY(), (int)(this.lPosMineY >> 8)) + (Gfx.mina.getHeight() >> 1));
            if (this.isDrawInScreen(_lPosX, _lPosY, _iScrWidth, _iScrHeight)) {
                this.vWeeldSoccermanExp.drawFrame(_g);
            }
        }
    }

    protected abstract void updateTriangleSelect();

    protected boolean isBallFrienly(Ball _vBall) {
        switch (_vBall.getDomain()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.iAreaAlineation < 11 && !_vBall.isFree();
            }
        }
        return this.iAreaAlineation > 10 && !_vBall.isFree();
    }

    private void updateCollide(Ball _vBall) {
        if ((!this.isBallFrienly(_vBall) && this.iStateAction == 4 || _vBall.isFree() && _vBall.isAvaivable()) && this.iStateAction != 3 && this.iStateAction != 2 && this.iStateAction != 6 && this.iStateAction != 5 && this.isCollide(_vBall.getPosX(), _vBall.getPosY(), _vBall.getWidth(), _vBall.getHeight()) && _vBall.iTypeShoot != 3) {
            if (!this.isBallFrienly(_vBall) && this.iStateAction == 4) {
                iIdKO = iBallPosesionID;
            }
            iBallPosesionID = this.iAreaAlineation;
            _vBall.setFree(false);
            _vBall.stopRun();
            _vBall.setDomain(this.iAreaAlineation);
        }
        if (this.isCollide(_vBall.getPosX(), _vBall.getPosY(), _vBall.getWidth(), _vBall.getHeight()) && _vBall.iTypeShoot == 3 && this.iStateAction != 6) {
            if (this.isPlayable() && this.iMyField != iStateSuperShoot && this.isControlable) {
                return;
            }
            if (this.isPlayable() && this.iMyField != iStateSuperShoot && !this.isControlable) {
                return;
            }
            this.iStateAction = 5;
        }
    }

    private void updateFormatCollide(Ball _vBall) {
        if (this.isCollide(_vBall.getPosX(), _vBall.getPosY(), _vBall.getWidth(), _vBall.getHeight())) {
            iBallPosesionID = this.iAreaAlineation;
            _vBall.setFree(false);
            _vBall.stopRun();
            _vBall.setDomain(this.iAreaAlineation);
        }
    }

    private void moveSoccerman(long _lDeltaTime, Ball _vBall) {
        if (isDeceleration && this.isDecelerating) {
            if (!this.isControlable || this.isPlayable()) {
                // empty if block
            }
            if (this.lCurrentIncX != 0L) {
                this.lCurrentIncX = this.lLimitIncX > 0L ? (this.lCurrentIncX -= (this.lCurrentIncX >> 3) + 1L) : (this.lCurrentIncX -= (this.lCurrentIncX >> 3) - 1L);
            }
            if (this.lCurrentIncY != 0L) {
                this.lCurrentIncY = this.lLimitIncY > 0L ? (this.lCurrentIncY -= (this.lCurrentIncY >> 3) + 1L) : (this.lCurrentIncY -= (this.lCurrentIncY >> 3) - 1L);
            }
            if (this.lCurrentIncX > 0L) {
                if (this.lCurrentIncX < SPEED >> 3) {
                    this.lCurrentIncX = 0L;
                }
            } else if (this.lCurrentIncX > -SPEED >> 3) {
                this.lCurrentIncX = 0L;
            }
            if (this.lCurrentIncY > 0L) {
                if (this.lCurrentIncY < SPEED >> 3) {
                    this.lCurrentIncY = 0L;
                }
            } else if (this.lCurrentIncY > -SPEED >> 3) {
                this.lCurrentIncY = 0L;
            }
            if (this.lCurrentIncX == 0L && this.lCurrentIncY == 0L) {
                this.isDecelerating = false;
                return;
            }
            this.setPosX(this.getPosX() + this.lCurrentIncX * _lDeltaTime / 1000L);
            this.setPosY(this.getPosY() - this.lCurrentIncY * _lDeltaTime / 1000L);
        } else if (this.iStateAction == 1 || this.iStateAction == 4) {
            this.lSin = Math2D.sin(this.iStateAction == 4 ? this.iAngleMow : this.iAngle);
            this.lCos = Math2D.cos(this.iStateAction == 4 ? this.iAngleMow : this.iAngle);
            this.lIncrementX = this.lCos * this.lCurrentSpeed / this.lMaxCos;
            this.lIncrementY = this.lSin * this.lCurrentSpeed / this.lMaxSin;
            if (isDeceleration) {
                this.lLimitIncX = this.lIncrementX;
                this.lLimitIncY = this.lIncrementY;
            }
            if (!(_vBall.isFree() && _vBall.getTypeShoot() == 0 && !_vBall.isAvaivable() && (this.isPlayable() || this.getPosX() == this.lObjetiveX && this.getPosY() == this.lObjetiveY))) {
                this.lCurrentIncX = this.lIncrementX;
                this.lCurrentIncY = this.lIncrementY;
                this.setPosX(this.getPosX() + this.lIncrementX * _lDeltaTime / 1000L);
                this.setPosY(this.getPosY() - this.lIncrementY * _lDeltaTime / 1000L);
            }
        }
        if (this.getPosX() + lWidth > WorldPhysics.getWorldWidth() - WorldPhysics.getMargin()) {
            this.setPosX(WorldPhysics.getWorldWidth() - WorldPhysics.getMargin() - lWidth);
            this.lIncrementX = 0L;
            this.lCurrentIncX = 0L;
        } else if (this.getPosX() < WorldPhysics.getMargin()) {
            this.setPosX(WorldPhysics.getMargin());
            this.lIncrementX = 0L;
            this.lCurrentIncX = 0L;
        }
        if (this.getPosY() + lHeight > WorldPhysics.getWorldHeight() - WorldPhysics.getMargin()) {
            this.setPosY(WorldPhysics.getWorldHeight() - WorldPhysics.getMargin() - lHeight);
            this.lIncrementY = 0L;
            this.lCurrentIncY = 0L;
        } else if (this.getPosY() < WorldPhysics.getMargin()) {
            this.setPosY(WorldPhysics.getMargin());
            this.lIncrementY = 0L;
            this.lCurrentIncY = 0L;
        }
    }

    protected void setNearDataPlayer(Soccerman[] _vOtherPlayers, Ball _vBall) {
        this.lNearPlayDistantX = this.lWorldWidth;
        this.lNearPlayDistantY = this.lWorldHeight;
        if (_vOtherPlayers != null) {
            for (int i = 0; i < _vOtherPlayers.length; ++i) {
                if (_vOtherPlayers[i].getAreaAlineation() == this.iAreaAlineation || this.lNearPlayDistantX + this.lNearPlayDistantY <= _vOtherPlayers[i].getDistanceBallX(_vBall) + _vOtherPlayers[i].getDistanceBallY(_vBall) || _vOtherPlayers[i].getStateAction() == 5 || _vOtherPlayers[i].getStateAction() == 6 || _vOtherPlayers[i].getType() == 1) continue;
                this.lNearPlayDistantX = _vOtherPlayers[i].getDistanceBallX(_vBall);
                this.lNearPlayDistantY = _vOtherPlayers[i].getDistanceBallY(_vBall);
                this.lNearPlayPosX = _vOtherPlayers[i].getPosX();
                this.lNearPlayPosY = _vOtherPlayers[i].getPosY();
                this.iNearPlayAngle = _vOtherPlayers[i].getAngleDirection();
                this.iNearPlayState = _vOtherPlayers[i].getStateAction();
                this.iNearPlayAlienation = _vOtherPlayers[i].getAreaAlineation();
            }
        }
    }

    protected boolean isCollide(long _ObjX, long _ObjY, long _ObjW, long _ObjH) {
        return this.getPosX() + lWidth > _ObjX && this.getPosY() + lHeight > _ObjY && _ObjX + _ObjW > this.getPosX() && _ObjY + _ObjH > this.getPosY();
    }

    protected abstract void listenControls(Ball var1);

    protected abstract void IAControls(Ball var1, Soccerman[] var2, long var3);

    private void putUncheckObj(Ball _vBall) {
        this.lObjetiveX = SP.getRandom((int)(_vBall.getPosX() - 65536L), (int)(_vBall.getPosX() + 65536L));
        this.lObjetiveY = this.getPosY() + lHeight < _vBall.getPosY() ? (long)SP.getRandom((int)(_vBall.getPosY() - this.iActionArea - 32768L), (int)(_vBall.getPosY() - this.iActionArea)) : (long)SP.getRandom((int)(_vBall.getPosY() + this.iActionArea), (int)(_vBall.getPosY() + this.iActionArea + 32768L));
        if (this.isOutLimitWidth(this.lObjetiveX)) {
            this.lObjetiveX = SP.getRandom((int)((WorldPhysics.getWorldWidth() >> 1) - (WorldPhysics.getAreaWidth() >> 1)), (int)((WorldPhysics.getWorldWidth() >> 1) + (WorldPhysics.getAreaWidth() >> 1)));
        }
        if (this.isOutLimitHeight(this.lObjetiveY)) {
            this.lObjetiveY = SP.getRandom((int)((WorldPhysics.getWorldHeight() >> 1) - WorldPhysics.getAreaHeight()), (int)((WorldPhysics.getWorldHeight() >> 1) + WorldPhysics.getAreaHeight()));
        }
    }

    public void resetPlayer(long _lWorldWidth, long _lWorldHeight, long _lWorldMargin, int _iPutAreaAlineationBall, int _iNumberPlayers) {
        this.formatState(_iNumberPlayers, _iPutAreaAlineationBall);
        this.formatPosition(_lWorldWidth, _lWorldHeight, _lWorldMargin, _iPutAreaAlineationBall, _iNumberPlayers);
        this.updateAnimation();
        iBallPosesionID = -1;
        iIdKO = -1;
    }

    protected void formatState(int _numberPlayers, int _iPutAreaAlineationBall) {
        this.iNewStateAction = this.iStateAction = 0;
        this.iMyField = this.iAreaAlineation < 11 ? 0 : 1;
        int n = this.iAngle = this.iAreaAlineation < 11 ? 270 : 90;
        if (_iPutAreaAlineationBall == this.iAreaAlineation) {
            if (this.iAreaAlineation == 1) {
                this.iAngle = 90;
            } else if (this.iAreaAlineation == 20) {
                this.iAngle = 270;
            }
        }
    }

    protected void formatPosition(long _lWorldWidth, long _lWorldHeight, long _lWorldMarign, int _iPutAreaAlineationBall, int _iNumberPlayers) {
        this.setPosX(this.getZoneAreaX(_lWorldWidth, _lWorldHeight, _lWorldMarign));
        this.setPosY(this.getZoneAreaY(_lWorldWidth, _lWorldHeight, _lWorldMarign));
        if (this.getAreaAlineation() == 1 && _iPutAreaAlineationBall == this.iAreaAlineation) {
            this.setPosX(_lWorldWidth / 2L - (lWidth >> 2));
            this.setPosY(_lWorldHeight / 2L - lHeight - (lHeight >> 2));
        }
        if (this.getAreaAlineation() == 20 && _iPutAreaAlineationBall == this.iAreaAlineation) {
            this.setPosX(_lWorldWidth / 2L - (lWidth >> 2));
            this.setPosY(_lWorldHeight / 2L - lHeight + (lHeight >> 2));
        }
    }

    protected long getZoneAreaX(long _lWorldWidth, long _lWorldHeight, long _lWorldMarign) {
        switch (this.iAreaAlineation) {
            case 0: {
                return _lWorldWidth / 2L - lWidth / 2L;
            }
            case 10: {
                return _lWorldWidth / 4L * 4L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 9: {
                return _lWorldWidth / 4L * 3L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 8: {
                return _lWorldWidth / 4L * 2L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 7: {
                return _lWorldWidth / 4L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 6: {
                return _lWorldWidth / 3L * 3L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 5: {
                return _lWorldWidth / 3L * 2L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 4: {
                return _lWorldWidth / 3L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 3: {
                return _lWorldWidth / 2L + _lWorldWidth / 8L - lWidth / 2L;
            }
            case 2: {
                return _lWorldWidth / 2L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 1: {
                return _lWorldWidth / 2L + lWidth;
            }
            case 20: {
                return _lWorldWidth / 2L + lWidth;
            }
            case 19: {
                return _lWorldWidth / 2L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 18: {
                return _lWorldWidth / 2L + _lWorldWidth / 8L - lWidth / 2L;
            }
            case 17: {
                return _lWorldWidth / 3L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 16: {
                return _lWorldWidth / 3L * 2L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 15: {
                return _lWorldWidth / 3L * 3L - _lWorldWidth / 6L - lWidth / 2L;
            }
            case 14: {
                return _lWorldWidth / 4L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 13: {
                return _lWorldWidth / 4L * 2L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 12: {
                return _lWorldWidth / 4L * 3L - _lWorldWidth / 8L - lWidth / 2L;
            }
            case 11: {
                return _lWorldWidth / 4L * 4L - _lWorldWidth / 8L - lWidth / 2L;
            }
        }
        return _lWorldWidth / 2L - lWidth / 2L;
    }

    protected long getZoneAreaY(long _lWorldWidth, long _lWorldHeight, long _lWorldMarign) {
        switch (this.iAreaAlineation) {
            case 0: {
                return _lWorldMarign;
            }
            case 10: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L * 3L;
            }
            case 9: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L * 3L;
            }
            case 8: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L * 3L;
            }
            case 7: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L * 3L;
            }
            case 6: {
                return _lWorldHeight / 2L - _lWorldHeight / 4L;
            }
            case 5: {
                return _lWorldHeight / 2L - _lWorldHeight / 4L;
            }
            case 4: {
                return _lWorldHeight / 2L - _lWorldHeight / 4L;
            }
            case 3: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L;
            }
            case 2: {
                return _lWorldHeight / 2L - _lWorldHeight / 8L;
            }
            case 1: {
                return _lWorldHeight / 2L - lHeight * 2L;
            }
            case 20: {
                return _lWorldHeight / 2L + lHeight;
            }
            case 19: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L - lHeight;
            }
            case 18: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L - lHeight;
            }
            case 17: {
                return _lWorldHeight / 2L + _lWorldHeight / 4L - lHeight;
            }
            case 16: {
                return _lWorldHeight / 2L + _lWorldHeight / 4L - lHeight;
            }
            case 15: {
                return _lWorldHeight / 2L + _lWorldHeight / 4L - lHeight;
            }
            case 14: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L * 3L - lHeight;
            }
            case 13: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L * 3L - lHeight;
            }
            case 12: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L * 3L - lHeight;
            }
            case 11: {
                return _lWorldHeight / 2L + _lWorldHeight / 8L * 3L - lHeight;
            }
        }
        return _lWorldHeight - _lWorldMarign - lHeight - lHeight / 4L;
    }

    protected void updateAnimation() {
        int ang = this.iAngle;
        this.iCurrentAnimation = ang <= 22 ? (this.iStateAction == 1 ? 11 : (this.iStateAction == 2 || this.iStateAction == 3 ? 19 : (this.iStateAction == 4 ? 27 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 3))))) : (ang <= 67 ? (this.iStateAction == 1 ? 13 : (this.iStateAction == 2 || this.iStateAction == 3 ? 21 : (this.iStateAction == 4 ? 29 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 5))))) : (ang <= 102 ? (this.iStateAction == 1 ? 8 : (this.iStateAction == 2 || this.iStateAction == 3 ? 16 : (this.iStateAction == 4 ? 24 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 0))))) : (ang <= 157 ? (this.iStateAction == 1 ? 12 : (this.iStateAction == 2 || this.iStateAction == 3 ? 20 : (this.iStateAction == 4 ? 28 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 4))))) : (ang <= 203 ? (this.iStateAction == 1 ? 10 : (this.iStateAction == 2 || this.iStateAction == 3 ? 18 : (this.iStateAction == 4 ? 26 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 2))))) : (ang <= 248 ? (this.iStateAction == 1 ? 14 : (this.iStateAction == 2 || this.iStateAction == 3 ? 22 : (this.iStateAction == 4 ? 30 : (this.iStateAction == 5 ? 33 : (this.iStateAction == 6 ? 0 : 6))))) : (ang <= 293 ? (this.iStateAction == 1 ? 9 : (this.iStateAction == 2 || this.iStateAction == 3 ? 17 : (this.iStateAction == 4 ? 25 : (this.iStateAction == 5 ? 33 : (this.iStateAction == 6 ? 0 : 1))))) : (ang <= 337 ? (this.iStateAction == 1 ? 15 : (this.iStateAction == 2 || this.iStateAction == 3 ? 23 : (this.iStateAction == 4 ? 31 : (this.iStateAction == 5 ? 33 : (this.iStateAction == 6 ? 0 : 7))))) : (this.iStateAction == 1 ? 11 : (this.iStateAction == 2 || this.iStateAction == 3 ? 19 : (this.iStateAction == 4 ? 27 : (this.iStateAction == 5 ? 32 : (this.iStateAction == 6 ? 0 : 3))))))))))));
        this.isBucle = this.iStateAction == 0 || this.iStateAction == 1;
    }

    private long getLimit() {
        return this.iMyField == 0 ? WorldPhysics.getWorldHeight() - (WorldPhysics.getAreaHeight() + WorldPhysics.getMargin()) : WorldPhysics.getAreaHeight() + WorldPhysics.getMargin();
    }

    public boolean isInArea(long _lPosY) {
        if (this.iMyField == 0) {
            return _lPosY > this.getLimit();
        }
        return _lPosY < this.getLimit();
    }

    public boolean checkMineColision(int _iMineX, int _iMineY, int _iMineW, int _iMineH, long _iBallX, long _iBallY, long _iBallW, long _iBallH) {
        return (long)_iMineX < _iBallX + (_iBallW >> 1) + (long)(240 << iPrecisionBits) && (long)_iMineX > _iBallX + (_iBallW >> 1) - (long)(240 << iPrecisionBits) && (long)_iMineY < _iBallY + (_iBallH >> 1) + (long)(320 << iPrecisionBits) && (long)_iMineY > _iBallY + (_iBallH >> 1) - (long)(320 << iPrecisionBits) && this.isCollide(_iMineX, _iMineY, _iMineW, _iMineH);
    }

    public static void quitPosesionBall(Ball _vBall) {
        iBallPosesionID = -1;
        _vBall.setFree(true);
        _vBall.setDomain(-1);
        _vBall.resetPlayerMovement();
    }

    public boolean isWithBall() {
        return iBallPosesionID == this.iAreaAlineation;
    }

    public int getAreaAlineation() {
        return this.iAreaAlineation;
    }

    public void setAreaAlineation(int _iAreaAlineation) {
        this.iAreaAlineation = _iAreaAlineation;
    }

    public long getDistanceBallX(Ball _vBall) {
        return _vBall.getPosX() - this.getPosX() < 0L ? (_vBall.getPosX() - this.getPosX()) * -1L : _vBall.getPosX() - this.getPosX();
    }

    public long getDistanceBallY(Ball _vBall) {
        return _vBall.getPosY() - this.getPosY() < 0L ? (_vBall.getPosY() - this.getPosY()) * -1L : _vBall.getPosY() - this.getPosY();
    }

    public long getDistenceBalla(Ball _vBall) {
        return this.getDistanceBallX(_vBall) + this.getDistanceBallY(_vBall) >> 1;
    }

    public long getDistance(long _lPosX, long _lPosY) {
        return (_lPosY - this.getPosY() < 0L ? (_lPosY - this.getPosY()) * -1L : _lPosY - this.getPosY()) + (_lPosX - this.getPosX() < 0L ? (_lPosX - this.getPosX()) * -1L : _lPosX - this.getPosX()) >> 1;
    }

    public int getStateAction() {
        return this.iStateAction;
    }

    public void setStateAction(int _iStateAction) {
        this.iStateAction = _iStateAction;
    }

    public int getCurrentAnimation() {
        return this.iCurrentAnimation;
    }

    public boolean isThePlayable() {
        return this.isControlable && this.getAlineationPlayable() == this.iAreaAlineation;
    }

    public boolean isPlayable() {
        return this.getAlineationPlayable() == this.iAreaAlineation;
    }

    public boolean isControlable() {
        return this.isControlable;
    }

    public int getAngleDirection() {
        return this.iAngle;
    }

    public int getType() {
        return this.iTypeSoccerman;
    }

    public int getLayer() {
        return this.iLayerSoccerman;
    }

    public void setLayer(int _layer) {
        this.iLayerSoccerman = _layer;
    }

    public void startExplosionAnim() {
        this.vWeeldSoccermanExp.setAnimation(0, false);
    }

    public void setPosMineX(long _lPosMineX) {
        this.lPosMineX = _lPosMineX;
    }

    public void setPosMineY(long _lPosMineY) {
        this.lPosMineY = _lPosMineY;
    }

    private void setAlineationPlayable(int _iAlineationPlayable) {
        if (this.iMyField == 0) {
            Soccerman.iAlineationPlayable[0] = _iAlineationPlayable;
        } else {
            Soccerman.iAlineationPlayable[1] = _iAlineationPlayable;
        }
    }

    public int getAlineationPlayable() {
        if (this.iMyField == 0) {
            return iAlineationPlayable[0];
        }
        return iAlineationPlayable[1];
    }

    public static int getDomainBall(Ball _vBall, int _iPlayerField, int _iNumPlayers) {
        if (_vBall.getDomain() <= _iNumPlayers) {
            if (_iPlayerField == 0) {
                return 1;
            }
            return 2;
        }
        if (_iPlayerField == 1) {
            return 1;
        }
        return 2;
    }

    static {
        MINIM_DURATION_ACTION = 500L;
    }
}

