/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer.objects;

import com.kitmaker.riosupersoccer.Menu;
import com.kitmaker.riosupersoccer.SP;
import com.kitmaker.riosupersoccer.TournamentManager;
import com.kitmaker.riosupersoccer.WorldPhysics;
import com.kitmaker.riosupersoccer.objects.Ball;
import com.kitmaker.riosupersoccer.objects.Soccerman;
import javax.microedition.lcdui.Graphics;

public final class Goalie
extends Soccerman {
    public static final boolean CONTROLABLE = false;
    private int iCounterWait;
    private static int MAX_WAIT = 3000;
    private static int PROB_TO_ERRATE = Menu.MODE == 2 ? 50 - TournamentManager.matchesPlayed * 10 : 50;

    public Goalie(int _lPosX, int _lPosY, int _iPosZ, long _lWorldWidth, long _lWorldHeight, long _lWorldMargin, int _iPrecionBits, int _iAreaAliniation, int _iPutAreaAlineationBall, String _sPathHead, String _sPathAnuBody) {
        super(_lPosX, _lPosY, _iPosZ, _lWorldWidth, _lWorldHeight, _iPrecionBits, 1, _iAreaAliniation, _sPathHead, _sPathAnuBody, false);
        this.resetPlayer(_lWorldWidth, _lWorldHeight, _lWorldMargin, _iPutAreaAlineationBall, 5);
    }

    public void update(long _lDeltaTime, Soccerman[] _vOtherPlayers, Ball _vBall, boolean _isHavePower) {
        this.putGoalControl(_lDeltaTime, _vBall);
        this.updateState();
        this.resolutionState(_lDeltaTime, _vBall);
        this.updateAnimation();
        if (this.vWeeldSoccerman.getAnimation() != this.iCurrentAnimation) {
            this.vWeeldSoccerman.setAnimation(this.iCurrentAnimation, this.isBucle);
        }
        this.vWeeldSoccerman.update();
    }

    public void putGoalControl(long _lDeltaTime, Ball _vBall) {
        if (this.isWithBall()) {
            if (this.iCounterWait > MAX_WAIT) {
                this.iNewStateAction = 2;
            } else {
                this.iNewStateAction = 9;
                this.iCounterWait = (int)((long)this.iCounterWait + _lDeltaTime);
            }
        } else {
            if (isAlertGoal) {
                if (this.iMyField == 0) {
                    if (_vBall.getAngle() < 80) {
                        this.iNewStateAction = SP.getRandom(100) > PROB_TO_ERRATE || !this.isInPosX() ? 11 : 10;
                    } else if (_vBall.getAngle() > 100) {
                        this.iNewStateAction = SP.getRandom(100) > PROB_TO_ERRATE || !this.isInPosX() ? 10 : 11;
                    }
                } else if (this.iMyField == 1) {
                    if (_vBall.getAngle() < 260) {
                        this.iNewStateAction = SP.getRandom(100) > PROB_TO_ERRATE || !this.isInPosX() ? 10 : 11;
                    } else if (_vBall.getAngle() > 280) {
                        this.iNewStateAction = SP.getRandom(100) > PROB_TO_ERRATE || !this.isInPosX() ? 11 : 10;
                    }
                }
                System.out.println("_vBall.getAngle(): " + _vBall.getAngle());
                System.out.println("iNewStateAction: " + this.iNewStateAction);
            } else if (_vBall.getPosX() > this.getPosX() + SPEED_GOALIE * _lDeltaTime / 1000L) {
                this.iNewStateAction = 8;
            } else if (_vBall.getPosX() < this.getPosX() - SPEED_GOALIE * _lDeltaTime / 1000L) {
                this.iNewStateAction = 7;
            }
            if (this.isCollide(_vBall.getPosX(), _vBall.getPosY(), _vBall.getWidth(), _vBall.getHeight()) && (this.getStateAction() == 0 || this.getStateAction() == 7 || this.getStateAction() == 8 || this.getStateAction() == 10 || this.getStateAction() == 11)) {
                if (_vBall.iTypeShoot == 3) {
                    this.setStateAction(5);
                } else {
                    iBallPosesionID = this.iAreaAlineation;
                    _vBall.setFree(false);
                    _vBall.stopRun();
                    _vBall.setDomain(this.iAreaAlineation);
                    this.iCounterWait = 0;
                }
            }
        }
        isAlertGoal = false;
    }

    public void updateState() {
        if (this.getStateAction() == 3 || this.getStateAction() == 2 || this.getStateAction() == 10 || this.getStateAction() == 11 || this.getStateAction() == 5) {
            if (this.vWeeldSoccerman.loopFinished() || !this.vWeeldSoccerman.isPlaying()) {
                this.setStateAction(0);
            }
            return;
        }
        switch (this.iNewStateAction) {
            case 0: 
            case 7: 
            case 8: 
            case 9: {
                this.setStateAction(this.iNewStateAction);
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                if (this.getStateAction() != 0 && this.getStateAction() != 7 && this.getStateAction() != 8 && this.getStateAction() != 9) break;
                this.setStateAction(this.iNewStateAction);
            }
        }
    }

    public void resolutionState(long _lDeltaTime, Ball _vBall) {
        if (this.getStateAction() != 10 && this.getStateAction() != 11) {
            this.lCurrentSpeed = Soccerman.SPEED_GOALIE;
            if (this.getStateAction() == 2 && this.isWithBall()) {
                _vBall.putDataAngle(this.iAngle + SP.getRandom(-20, 20), 2);
                _vBall.resetPlayerMovement();
                _vBall.setFree(true);
                iBallPosesionID = -1;
            }
        } else {
            this.lCurrentSpeed = SPEED_GOALIE_JUMP;
        }
        this.moveSoccerman(_lDeltaTime, _vBall);
    }

    private void moveSoccerman(long _lDeltaTime, Ball _vBall) {
        this.lCurrentSpeed = this.lCurrentSpeed * _lDeltaTime / 1000L;
        if (this.getStateAction() == 10) {
            this.setPosX(this.getPosX() - this.lCurrentSpeed);
        } else if (this.getStateAction() == 11) {
            this.setPosX(this.getPosX() + this.lCurrentSpeed);
        }
        if (this.getStateAction() == 7) {
            if (this.getPosX() > (WorldPhysics.getWorldWidth() >> 1) - 11520L) {
                this.setPosX(this.getPosX() - this.lCurrentSpeed);
            }
        } else if (this.getStateAction() == 8 && this.getPosX() < (WorldPhysics.getWorldWidth() >> 1) + 11520L) {
            this.setPosX(this.getPosX() + this.lCurrentSpeed);
        }
    }

    public void resetPlayer(long _lWorldWidth, long _lWorldHeight, long _lWorldMargin, int _iPutAreaAlineationBall) {
        iBallPosesionID = -1;
        iIdKO = -1;
        this.setStateAction(0);
        this.iNewStateAction = this.getStateAction();
        this.iMyField = this.iAreaAlineation < 5 ? 0 : 1;
        int n = this.iAngle = this.iAreaAlineation < 5 ? 270 : 90;
        if (_iPutAreaAlineationBall == this.iAreaAlineation) {
            if (this.iAreaAlineation == 4) {
                this.iAngle = 90;
            } else if (this.iAreaAlineation == 5) {
                this.iAngle = 270;
            }
        }
        this.formatPosition(_lWorldWidth, _lWorldHeight, _lWorldMargin, _iPutAreaAlineationBall, 5);
        this.updateAnimation();
    }

    protected void updateAnimation() {
        this.iCurrentAnimation = this.iMyField == 0 ? (this.getStateAction() == 2 ? 13 : (this.getStateAction() == 7 ? 4 : (this.getStateAction() == 8 ? 4 : (this.getStateAction() == 10 ? 10 : (this.getStateAction() == 11 ? 11 : (this.getStateAction() == 9 ? 7 : (this.getStateAction() == 5 ? 15 : 1))))))) : (this.getStateAction() == 2 ? 12 : (this.getStateAction() == 7 ? 2 : (this.getStateAction() == 8 ? 2 : (this.getStateAction() == 10 ? 8 : (this.getStateAction() == 11 ? 9 : (this.getStateAction() == 9 ? 6 : (this.getStateAction() == 5 ? 14 : 0)))))));
        this.isBucle = this.getStateAction() == 0 || this.getStateAction() == 7 || this.getStateAction() == 8;
    }

    public boolean isInPosX() {
        return this.getPosX() + (lWidth >> 1) > (WorldPhysics.getWorldWidth() >> 1) - 11520L && this.getPosX() + (lWidth >> 1) < (WorldPhysics.getWorldWidth() >> 1) + 11520L;
    }

    protected void putAutoControl() {
    }

    protected void listenControls(Ball _vBall) {
    }

    protected void IAControls(Ball _vBall, Soccerman[] _vOtherPlayers, long _lDeltaTime) {
    }

    protected void drawSelector(Graphics _g, int _lPosX, int _lPosY) {
    }

    protected void updateTriangleSelect() {
    }

    protected void drawSelector(Graphics _g, int _lPosX, int _lPosY, Ball _vBall) {
    }

    public void draw(Graphics _g, int _lPosX, int _lPosY, int _lPosZ) {
    }
}

