/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer.objects;

import com.kitmaker.riosupersoccer.Game;
import com.kitmaker.riosupersoccer.SP;
import com.kitmaker.riosupersoccer.WorldPhysics;
import com.kitmaker.riosupersoccer.objects.Object;
import com.kitmaker.riosupersoccer.tool.Math2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Ball
extends Object {
    private static Image[] vImageBalls;
    private static Image vImageShadow;
    private static final int NUMBER_FRAMES = 2;
    private static final int NUMBER_ZOOMS = 3;
    public long iCurrentSpeed;
    public static long SPEED_HIGH_SHOOT;
    public static final long SPEED_SHOOT;
    public static final long SPEED_PASS;
    public static long BITS_DECELERATION;
    private boolean isShuperShoot;
    private int iAnimationIndex;
    private int iAnimationIndexZ;
    private int[] iWidth;
    private int[] iHeight;
    private long iMaxIncrementX;
    private long iMaxIncrementY;
    private long iMaxIncrementZ;
    private long iMaxCuIncrementX;
    private long iMaxCuIncrementY;
    private static final int Z_ELEVATION = 3;
    public int iTypeShoot;
    public static final int PASS = 0;
    public static final int SHOOT = 1;
    public static final int HIGHT_SHOOT = 2;
    public static final int SUPER_SHOOT = 3;
    private boolean isFree;
    private boolean isInGoalNorth;
    private boolean isInGoalSouth;
    private int iExtraX;
    private int iExtraY;
    private int iIncX;
    private int iIncY;
    private int iTotalExtraX;
    private int iTotalExtraY;
    private int iSpeed;
    private int iPosSoccerDomain;

    public void setFree(boolean _isFree) {
        this.isFree = _isFree;
    }

    public boolean isFree() {
        return this.isFree;
    }

    public Ball(long _lPosX, long _lPosY, long _lPosZ, long _lWorldWidth, long _lWorldHeight, int _iPrecionBits, Image[] _vImages, Image _vShadow) {
        super(_lPosX, _lPosY, _lPosZ, _lWorldWidth, _lWorldHeight, _iPrecionBits);
        if (vImageBalls == null) {
            vImageBalls = _vImages;
        }
        if (vImageShadow == null) {
            vImageShadow = _vShadow;
        }
        if (this.iWidth == null) {
            this.iWidth = new int[3];
        }
        if (this.iHeight == null) {
            this.iHeight = new int[3];
        }
        this.iWidth[0] = vImageBalls[0].getWidth() / 2;
        this.iWidth[1] = vImageBalls[1].getWidth() / 2;
        this.iWidth[2] = vImageBalls[2].getWidth() / 2;
        this.iHeight[0] = vImageBalls[0].getHeight();
        this.iHeight[1] = vImageBalls[1].getHeight();
        this.iHeight[2] = vImageBalls[1].getHeight();
        lWidth = this.iWidth[0] << iPrecisionBits;
        lHeight = this.iHeight[0] << iPrecisionBits;
        this.isShuperShoot = false;
        this.resetValues();
    }

    public void update(long _lDeltaTime) {
        if (!this.isGoal()) {
            this.putLimitsCollide();
            this.move(_lDeltaTime);
        }
        this.updateAnimation(this.iTypeShoot);
    }

    public void draw(Graphics _g, int _lPosX, int _lPosY, int _lPosZ) {
        int mierda = 2;
        _g.setClip(0, 0, 240, 320);
        _g.drawImage(vImageShadow, _lPosX + mierda + this.iIncX, _lPosY + mierda + this.iIncY, 0);
        int modZ = (int)this.lPosZ >> 8;
        _g.setClip(_lPosX + this.iIncX, _lPosY - modZ + this.iIncY, this.iWidth[this.iAnimationIndexZ], this.iHeight[this.iAnimationIndexZ]);
        _g.drawImage(vImageBalls[this.iAnimationIndexZ], _lPosX - this.iAnimationIndex * this.iWidth[this.iAnimationIndexZ] + this.iIncX, _lPosY - modZ + this.iIncY, 0);
        _g.setClip(0, 0, 240, 320);
    }

    public void draw(Graphics _g, int _lPosX, int _lPosY, int _lPosZ, int _iPlayerW, int _iPlayerH, int _iPlayerAngle) {
        if (_iPlayerAngle <= 22) {
            _lPosX += _iPlayerW;
            _lPosY += _iPlayerH - this.iHeight[2];
        } else if (_iPlayerAngle <= 67) {
            _lPosX += _iPlayerW;
            _lPosY += _iPlayerH - this.iHeight[2];
        } else if (_iPlayerAngle <= 102) {
            _lPosX += (_iPlayerW >> 1) - (this.iWidth[2] >> 1);
            _lPosY -= this.iHeight[2];
        } else if (_iPlayerAngle <= 157) {
            _lPosX -= this.iWidth[2];
            _lPosY += _iPlayerH - this.iHeight[2];
        } else if (_iPlayerAngle <= 203) {
            _lPosX -= this.iWidth[2];
            _lPosY += _iPlayerH - this.iHeight[2];
        } else if (_iPlayerAngle <= 248) {
            _lPosX -= this.iWidth[2];
            _lPosY += _iPlayerH;
        } else if (_iPlayerAngle <= 293) {
            _lPosX += (_iPlayerW >> 1) - (this.iWidth[2] >> 1);
            _lPosY += _iPlayerH;
        } else if (_iPlayerAngle <= 337) {
            _lPosX += _iPlayerW;
            _lPosY += _iPlayerH;
        } else if (_iPlayerAngle > 337) {
            _lPosX += _iPlayerW;
            _lPosY += _iPlayerH - this.iHeight[2];
        }
        this.draw(_g, _lPosX, _lPosY, _lPosZ);
    }

    public void setPlayerMovement(int _iPlayerAngle, boolean _isSoocRunning) {
        if (!this.isRunning() && _isSoocRunning) {
            int totalIcr = SP.getRandom(this.iWidth[2] / 4, this.iWidth[2] / 2 * 2);
            if (_iPlayerAngle <= 22) {
                this.iIncX = this.getRunMovimentX(false, true, totalIcr);
                this.iIncY = this.getRunMovimentY(false, false, totalIcr);
            } else if (_iPlayerAngle <= 67) {
                this.iIncX = this.getRunMovimentX(false, true, totalIcr);
                this.iIncY = this.getRunMovimentY(false, false, totalIcr);
            } else if (_iPlayerAngle <= 102) {
                this.iIncX = this.getRunMovimentX(false, false, totalIcr);
                this.iIncY = this.getRunMovimentY(true, false, totalIcr);
            } else if (_iPlayerAngle <= 157) {
                this.iIncX = this.getRunMovimentX(true, false, totalIcr);
                this.iIncY = this.getRunMovimentY(true, false, totalIcr);
            } else if (_iPlayerAngle <= 203) {
                this.iIncX = this.getRunMovimentX(true, false, totalIcr);
                this.iIncY = this.getRunMovimentY(false, false, totalIcr);
            } else if (_iPlayerAngle <= 248) {
                this.iIncX = this.getRunMovimentX(true, false, totalIcr);
                this.iIncY = this.getRunMovimentY(false, true, totalIcr);
            } else if (_iPlayerAngle <= 293) {
                this.iIncX = this.getRunMovimentX(false, false, totalIcr);
                this.iIncY = this.getRunMovimentY(false, true, totalIcr);
            } else if (_iPlayerAngle <= 337) {
                this.iIncX = this.getRunMovimentX(false, true, totalIcr);
                this.iIncY = this.getRunMovimentY(false, true, totalIcr);
            } else {
                this.iIncX = this.getRunMovimentX(false, true, totalIcr);
                this.iIncY = this.getRunMovimentY(false, false, totalIcr);
            }
        } else {
            this.iExtraX = 0;
            this.iExtraY = 0;
        }
    }

    public void resetPlayerMovement() {
        this.iSpeed = 0;
        this.iIncX = 0;
        this.iExtraX = 0;
        this.iTotalExtraX = 0;
        this.iIncY = 0;
        this.iExtraY = 0;
        this.iTotalExtraY = 0;
    }

    private int getRunMovimentX(boolean _isDirLeft, boolean _isDirRight, int _iTotalIcr) {
        if (_isDirLeft || _isDirRight) {
            this.iExtraX = this.iTotalExtraX > 0 ? (this.iExtraX < this.iTotalExtraX ? (this.iExtraX += this.iSpeed) : 0) : (this.iExtraX > this.iTotalExtraX ? (this.iExtraX -= this.iSpeed) : 0);
            this.putRunMovimentX(_isDirLeft, _isDirRight, _iTotalIcr);
        } else {
            this.iExtraX = 0;
            this.iTotalExtraX = 0;
        }
        return this.iExtraX;
    }

    private void putRunMovimentX(boolean _isDirLeft, boolean _isDirRight, int _iToalIncr) {
        this.iSpeed = (byte)((this.iWidth[2] / 9 > 0 ? this.iWidth[2] / 9 : 1) * 2);
        if (_isDirLeft) {
            this.iTotalExtraX = _iToalIncr * -1;
        } else if (_isDirRight) {
            this.iTotalExtraX = _iToalIncr;
        }
    }

    private int getRunMovimentY(boolean _isDirUp, boolean _isDirDown, int _iTotalInc) {
        if (_isDirUp || _isDirDown) {
            this.iExtraY = this.iTotalExtraY > 0 ? (this.iExtraY < this.iTotalExtraY ? (this.iExtraY += this.iSpeed) : 0) : (this.iExtraY > this.iTotalExtraY ? (this.iExtraY -= this.iSpeed) : 0);
            this.putRunMovimentY(_isDirUp, _isDirDown, _iTotalInc);
        } else {
            this.iExtraY = 0;
            this.iTotalExtraY = 0;
        }
        return this.iExtraY;
    }

    private void putRunMovimentY(boolean _isDirUp, boolean _isDirDown, int _iTotalInc) {
        this.iSpeed = (byte)((this.iWidth[2] / 9 > 0 ? this.iWidth[2] / 9 : 1) * 2);
        if (_isDirUp) {
            this.iTotalExtraY = _iTotalInc * -1;
        } else if (_isDirDown) {
            this.iTotalExtraY = _iTotalInc;
        }
    }

    private void putLimitsCollide() {
        int iIcmX = (int)(this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX);
        int iIcmY = (int)(this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY);
        int iMaxIcmX = (int)(this.iMaxIncrementX < 0L ? this.iMaxIncrementX * -1L : this.iMaxIncrementX);
        int iMaxIcmY = (int)(this.iMaxIncrementY < 0L ? this.iMaxIncrementY * -1L : this.iMaxIncrementY);
        if (iIcmX + iIcmY > 0) {
            long spd;
            if (this.getPosX() > WorldPhysics.getWorldWidth() - WorldPhysics.getMargin()) {
                this.iAngle = this.iAngle > 270 && this.iAngle < 360 || this.iAngle > 0 && this.iAngle < 90 ? (180 - (this.iAngle - 360)) % 360 : (this.iAngle + 180) % 360;
                this.setPosX(WorldPhysics.getWorldWidth() - WorldPhysics.getMargin());
                spd = (long)(iIcmX + iIcmY) * this.iCurrentSpeed / (long)(iMaxIcmX + iMaxIcmY);
                this.lSin = Math2D.sin(this.iAngle);
                this.lCos = Math2D.cos(this.iAngle);
                this.lIncrementX = (int)(this.lCos * spd / this.lMaxCos);
                this.lIncrementY = (int)(this.lSin * spd / this.lMaxSin);
                this.isShuperShoot = false;
                Game.resetSuperShoot();
            }
            if (this.getPosX() < WorldPhysics.getMargin()) {
                this.iAngle = this.iAngle > 90 && this.iAngle < 270 ? (360 - (this.iAngle - 180)) % 360 : (this.iAngle + 180) % 360;
                this.setPosX(WorldPhysics.getMargin());
                spd = (long)(iIcmX + iIcmY) * this.iCurrentSpeed / (long)(iMaxIcmX + iMaxIcmY);
                this.lSin = Math2D.sin(this.iAngle);
                this.lCos = Math2D.cos(this.iAngle);
                this.lIncrementX = (int)(this.lCos * spd / this.lMaxCos);
                this.lIncrementY = (int)(this.lSin * spd / this.lMaxSin);
                this.isShuperShoot = false;
                Game.resetSuperShoot();
            }
            if (this.getPosY() > WorldPhysics.getWorldHeight() - WorldPhysics.getMargin()) {
                this.iAngle = this.iAngle > 180 && this.iAngle < 360 ? 90 + (270 - this.iAngle) : (this.iAngle + 180) % 360;
                this.setPosY(WorldPhysics.getWorldHeight() - WorldPhysics.getMargin());
                spd = (long)(iIcmX + iIcmY) * this.iCurrentSpeed / (long)(iMaxIcmX + iMaxIcmY);
                this.lSin = Math2D.sin(this.iAngle);
                this.lCos = Math2D.cos(this.iAngle);
                this.lIncrementX = this.lCos * spd / this.lMaxCos;
                this.lIncrementY = this.lSin * spd / this.lMaxSin;
                this.isShuperShoot = false;
                Game.resetSuperShoot();
            }
            if (this.getPosY() < WorldPhysics.getMargin()) {
                this.iAngle = this.iAngle > 0 && this.iAngle < 180 ? 270 + (90 - this.iAngle) : (this.iAngle + 180) % 360;
                this.setPosY(WorldPhysics.getMargin());
                spd = (long)(iIcmX + iIcmY) * this.iCurrentSpeed / (long)(iMaxIcmX + iMaxIcmY);
                this.lSin = Math2D.sin(this.iAngle);
                this.lCos = Math2D.cos(this.iAngle);
                this.lIncrementX = (int)(this.lCos * spd / this.lMaxCos);
                this.lIncrementY = (int)(this.lSin * spd / this.lMaxSin);
                this.isShuperShoot = false;
                Game.resetSuperShoot();
            }
        }
    }

    private boolean isGoal() {
        if (this.getPosX() > (WorldPhysics.getWorldWidth() >> 1) - 11520L && this.getPosX() < (WorldPhysics.getWorldWidth() >> 1) + 11520L) {
            if (this.getPosY() + (long)(this.iHeight[this.iAnimationIndexZ] << iPrecisionBits) > WorldPhysics.getWorldHeight() - WorldPhysics.getMargin()) {
                this.isInGoalSouth = true;
                this.isInGoalNorth = false;
                this.lIncrementX = 0L;
                this.lIncrementY = 0L;
                this.lPosZ = 0L;
                this.iAnimationIndexZ = 2;
                this.lPosY = WorldPhysics.getWorldHeight() - WorldPhysics.getMargin() + (WorldPhysics.getMargin() >> 2);
                return true;
            }
            if (this.getPosY() < WorldPhysics.getMargin()) {
                this.isInGoalNorth = true;
                this.isInGoalSouth = false;
                this.lIncrementX = 0L;
                this.lIncrementY = 0L;
                this.lPosZ = 0L;
                this.iAnimationIndexZ = 2;
                this.lPosY = WorldPhysics.getMargin() - lHeight - (WorldPhysics.getMargin() >> 2);
                return true;
            }
        }
        return false;
    }

    public void putDataAngle(int _iAngle, int _iTypeShoot) {
        this.iTypeShoot = _iTypeShoot;
        this.iPosSoccerDomain = -1;
        switch (_iTypeShoot) {
            case 0: {
                this.iCurrentSpeed = SPEED_PASS;
                break;
            }
            case 1: {
                this.iCurrentSpeed = SPEED_SHOOT;
                break;
            }
            case 2: {
                this.iCurrentSpeed = SPEED_HIGH_SHOOT;
                break;
            }
            default: {
                this.iCurrentSpeed = SPEED_PASS / 4L * 3L;
                this.isShuperShoot = true;
            }
        }
        this.iAngle = _iAngle == -1 ? SP.getRandom(0, 360) : _iAngle;
        this.lSin = Math2D.sin(this.iAngle);
        this.lCos = Math2D.cos(this.iAngle);
        this.lIncrementX = (int)(this.lCos * this.iCurrentSpeed / this.lMaxCos);
        this.lIncrementY = (int)(this.lSin * this.iCurrentSpeed / this.lMaxSin);
        this.iMaxIncrementX = this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX;
        this.iMaxIncrementY = this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY;
        this.iMaxIncrementZ = (this.iMaxIncrementX + this.iMaxIncrementY >> 3) / 2L;
        this.iMaxCuIncrementX = this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX;
        this.iMaxCuIncrementY = this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY;
    }

    private void move(long _lDeltaTime) {
        this.putDeceleration();
        this.updatePosZ();
        if (!this.isShuperShoot || Game.isSuperShoot) {
            this.setPosX(this.getPosX() + this.lIncrementX * _lDeltaTime / 1000L);
            this.setPosY(this.getPosY() - this.lIncrementY * _lDeltaTime / 1000L);
        }
    }

    private void putDeceleration() {
        if (!this.isShuperShoot) {
            BITS_DECELERATION = 8L;
            if (this.lIncrementX > 0L) {
                this.lIncrementX -= this.lIncrementX / BITS_DECELERATION + 1L;
            } else if (this.lIncrementX < 0L) {
                this.lIncrementX -= this.lIncrementX / BITS_DECELERATION - 1L;
            }
            if (this.lIncrementY > 0L) {
                this.lIncrementY -= this.lIncrementY / BITS_DECELERATION + 1L;
            } else if (this.lIncrementY < 0L) {
                this.lIncrementY -= this.lIncrementY / BITS_DECELERATION - 1L;
            }
        }
    }

    private void updatePosZ() {
        long icmY;
        long icmX = this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX;
        long l = icmY = this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY;
        if (icmX + icmY >> 3 > this.iMaxCuIncrementX + this.iMaxCuIncrementY >> 3 >> 1) {
            this.lPosZ = (this.iMaxCuIncrementX + this.iMaxCuIncrementY >> 3) - (icmX + icmY >> 3);
        } else {
            this.lPosZ -= ((this.iMaxCuIncrementX + this.iMaxCuIncrementY >> 3) - (icmX + icmY >> 3)) / BITS_DECELERATION;
            if (this.lPosZ < 0L) {
                this.lPosZ = 0L;
                this.iMaxCuIncrementX = this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX;
                this.iMaxCuIncrementY = this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY;
            }
        }
    }

    private void updateAnimation(int _iTypeShoot) {
        block14: {
            block13: {
                long incPosY;
                long incPosX = this.lIncrementX < 0L ? this.lIncrementX * -1L : this.lIncrementX;
                long l = incPosY = this.lIncrementY < 0L ? this.lIncrementY * -1L : this.lIncrementY;
                if ((incPosX >> iPrecisionBits) + (incPosY >> iPrecisionBits) <= 0L) break block13;
                int minSpeedXFrame = 1;
                int speedFrame = (int)((incPosX + incPosY) / 2L * (long)minSpeedXFrame / ((this.iMaxIncrementX + this.iMaxIncrementY) / 2L));
                speedFrame = minSpeedXFrame - speedFrame;
                int n = minSpeedXFrame = minSpeedXFrame < 1 ? 1 : minSpeedXFrame;
                if (SP.iFrame % (minSpeedXFrame * (speedFrame + 1)) == 0) {
                    ++this.iAnimationIndex;
                    if (this.iAnimationIndex > 1) {
                        this.iAnimationIndex = 0;
                    }
                }
                switch (_iTypeShoot) {
                    case 0: {
                        this.iAnimationIndexZ = 2;
                        break;
                    }
                    case 1: {
                        long portion = this.iMaxIncrementZ / 2L;
                        if (this.lPosZ < portion) {
                            this.iAnimationIndexZ = 2;
                            break;
                        }
                        if (this.lPosZ < portion * 2L) {
                            this.iAnimationIndexZ = 1;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        long portion = this.iMaxIncrementZ / 6L;
                        if (this.lPosZ < portion) {
                            this.iAnimationIndexZ = 2;
                            break;
                        }
                        if (this.lPosZ < portion * 2L) {
                            this.iAnimationIndexZ = 1;
                            break;
                        }
                        if (this.lPosZ < portion * 3L) {
                            this.iAnimationIndexZ = 0;
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if ((this.iExtraX != 0 || this.iExtraY != 0) && SP.iFrame % 2 / 2 == 0) {
                ++this.iAnimationIndex;
                if (this.iAnimationIndex > 1) {
                    this.iAnimationIndex = 0;
                }
            }
        }
    }

    public long getIncrementShootX() {
        return this.lIncrementX;
    }

    public long getIncrementShootY() {
        return this.lIncrementY;
    }

    public void setIncrementShootX(int _iIncrement) {
        this.lIncrementX = _iIncrement;
    }

    public void setIncrementShootY(int _iIncrement) {
        this.lIncrementY = _iIncrement;
    }

    public long getPosZ() {
        return this.lPosZ;
    }

    public long getMaxPosZ() {
        return this.iMaxIncrementZ;
    }

    public boolean isRunning() {
        return this.lIncrementX != 0L || this.lIncrementY != 0L;
    }

    public void stopRun() {
        this.lIncrementX = 0L;
        this.lIncrementY = 0L;
        this.iAnimationIndexZ = 2;
        this.isShuperShoot = false;
    }

    public void stopSuperShoot() {
        this.isShuperShoot = false;
        this.iTypeShoot = -1;
    }

    public boolean isAvaivable() {
        long incY;
        long maxIncX = this.iMaxIncrementX > 0L ? this.iMaxIncrementX : this.iMaxIncrementX * -1L;
        long maxIncY = this.iMaxIncrementY > 0L ? this.iMaxIncrementY : this.iMaxIncrementY * -1L;
        long incX = this.lIncrementX > 0L ? this.lIncrementX : this.lIncrementX * -1L;
        long l = incY = this.lIncrementY > 0L ? this.lIncrementY : this.lIncrementY * -1L;
        return incX <= maxIncX / 2L && incY <= maxIncY / 2L && this.iAnimationIndexZ >= 2;
    }

    public void resetValues() {
        this.lIncrementX = 0L;
        this.lIncrementY = 0L;
        this.lPosZ = 0L;
        this.iAnimationIndexZ = 2;
        this.isInGoalNorth = false;
        this.isInGoalSouth = false;
        this.isShuperShoot = false;
        this.isFree = true;
        this.iPosSoccerDomain = -1;
        this.iTypeShoot = -1;
    }

    public boolean isGoalNorth() {
        return this.isInGoalNorth;
    }

    public boolean isGoalSouth() {
        return this.isInGoalSouth;
    }

    public int getTypeShoot() {
        return this.iTypeShoot;
    }

    public void setDomain(int _iPosSoccerDomain) {
        this.iPosSoccerDomain = _iPosSoccerDomain;
    }

    public int getDomain() {
        return this.iPosSoccerDomain;
    }

    static {
        SPEED_HIGH_SHOOT = WorldPhysics.getWorldHeight() / 2L + WorldPhysics.getWorldHeight() / 16L;
        SPEED_SHOOT = SPEED_HIGH_SHOOT / 6L * 4L;
        SPEED_PASS = SPEED_SHOOT / 10L * 8L;
        BITS_DECELERATION = 16L;
    }
}

