/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer;

import com.kitmaker.riosupersoccer.MidletPBSP;
import com.kitmaker.riosupersoccer.SP;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SndManager {
    public static final boolean SOUND_SUPPORTED = true;
    public static boolean FX_SUPPORTED = false;
    static final byte MUSIC_NOMUSIC = -1;
    static final byte MUSIC_MENU = 0;
    static final byte MUSIC_PLAYING = 1;
    static final byte MUSIC_PRIM = 2;
    static final byte MUSIC_PITIDO = 3;
    static final byte MUSIC_VICTORIS = 4;
    static final byte MUSIC_WIN = 5;
    static final byte MUSIC_LOSE = 6;
    static final String[] MUSIC_FILES = new String[]{"/mainmenu.mid", "/playing.mid", "/prim.mid", "/pitido.mid", "/gol.mid", "/win.mid", "/lose.mid"};
    public static final byte FX_NOFX = -1;
    public static final byte FX_EXPLOSION = 0;
    public static final byte FX_SUPERCHUTE = 1;
    public static final byte FX_GRITO = 2;
    static final byte TOTAL_FX = 5;
    static final String[] SNDFX_FILES = new String[]{"/explosion.wav", "/superchute.wav", "/grito.wav"};
    static final int[] SOUND_VOLUME = new int[]{0, 30, 60, 90};
    public static boolean ms_bSound = false;
    static int ms_iSoundVolumeIndex = SOUND_VOLUME.length - 2;
    static boolean ms_bUpdatingSound = false;
    static boolean ms_bAsyncException = false;
    static byte ms_iAsyncClip;
    static boolean ms_bAsyncLoop;
    static boolean ms_bNewClip;
    static final int NUM_MUSIC;
    static final int NUM_SNDFX;
    static byte ms_iCurrentFXClip;
    static long ms_lCurrentClipStartTime;
    private static Player ms_vMusicPlayer;
    public static Player[] ms_vSndFxPlayer;
    static final int NUM_MUSIC_CLIPS;
    static byte ms_iCurrentMusicClip;
    static byte ms_iNewMusicClip;
    static boolean ms_bCurrentMusicLooping;
    static boolean ms_bNewMusicLooping;
    static boolean loopMusic;
    static final int NUM_FX_CLIPS;
    static final String MEDIAID_MID = "audio/midi";
    static final String MEDIAID_WAV = "audio/x-wav";
    static final String MEDIAID_AMR = "audio/amr";
    static final String MEDIAID_MP3 = "audio/mpeg";
    static String ms_zMediaId;
    static boolean ms_bPausedClip;
    static byte ms_iPausedCurrentClip;
    static boolean ms_bPausedCurrentLooping;
    public static final int TONE_MOVE = 0;
    public static final int TONE_SELECT = 1;
    public static final int TONE_BACK = 2;

    static void DeleteFX() {
        SndManager.StopFX();
        for (byte i = 0; i < ms_vSndFxPlayer.length; i = (byte)(i + 1)) {
            SndManager.DeleteFX(i);
        }
    }

    static void DeleteFX(byte _iIndex) {
        if (ms_vSndFxPlayer != null) {
            try {
                ms_vSndFxPlayer[_iIndex].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SndManager.ms_vSndFxPlayer[_iIndex] = null;
        }
    }

    static void LoadFX(byte index) {
        if (FX_SUPPORTED) {
            if (SNDFX_FILES[index].endsWith("amr")) {
                ms_zMediaId = MEDIAID_AMR;
            } else if (SNDFX_FILES[index].endsWith("wav")) {
                ms_zMediaId = MEDIAID_WAV;
            } else if (SNDFX_FILES[index].endsWith("mp3")) {
                ms_zMediaId = MEDIAID_MP3;
            }
            try {
                if (ms_vSndFxPlayer[index] == null) {
                    SndManager.ms_vSndFxPlayer[index] = Manager.createPlayer((InputStream)((Object)((Object)MidletPBSP.vMidletInstance)).getClass().getResourceAsStream(SNDFX_FILES[index]), (String)ms_zMediaId);
                    ms_vSndFxPlayer[index].prefetch();
                    ms_vSndFxPlayer[index].realize();
                }
            }
            catch (Exception e) {
                System.out.println(index + "; " + e.toString());
            }
        } else {
            SndManager.ms_vSndFxPlayer[index] = null;
        }
    }

    static void LoadAllFXa() {
        if (FX_SUPPORTED) {
            for (int i = 0; i < 5; ++i) {
                if (SNDFX_FILES[i].endsWith("amr")) {
                    ms_zMediaId = MEDIAID_AMR;
                } else if (SNDFX_FILES[i].endsWith("wav")) {
                    ms_zMediaId = MEDIAID_WAV;
                } else if (SNDFX_FILES[i].endsWith("mp3")) {
                    ms_zMediaId = MEDIAID_MP3;
                }
                try {
                    if (ms_vSndFxPlayer[i] == null) {
                        SndManager.ms_vSndFxPlayer[i] = Manager.createPlayer((InputStream)((Object)((Object)MidletPBSP.vMidletInstance)).getClass().getResourceAsStream(SNDFX_FILES[i]), (String)ms_zMediaId);
                    }
                    ms_vSndFxPlayer[i].prefetch();
                    ms_vSndFxPlayer[i].realize();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(i + "; " + e.toString());
                }
            }
        } else {
            SndManager.ms_vSndFxPlayer[0] = null;
        }
    }

    static void UpdateMusic() {
        if (!ms_bSound) {
            return;
        }
        ms_bUpdatingSound = true;
        if (System.currentTimeMillis() >= ms_lCurrentClipStartTime) {
            if (ms_bSound && (ms_bNewClip || ms_bCurrentMusicLooping) && (ms_iCurrentMusicClip == -1 || ms_vMusicPlayer == null || ms_vMusicPlayer.getState() != 400)) {
                if (ms_bNewClip) {
                    if (ms_iCurrentMusicClip != -1) {
                        try {
                            if (ms_vMusicPlayer != null) {
                                ms_vMusicPlayer.close();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ms_vMusicPlayer = null;
                    }
                    ms_iCurrentMusicClip = ms_iNewMusicClip;
                    ms_bCurrentMusicLooping = ms_bNewMusicLooping;
                } else {
                    try {
                        if (ms_vMusicPlayer.getState() != 400) {
                            ms_vMusicPlayer.deallocate();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer == null) {
                    try {
                        ms_vMusicPlayer = Manager.createPlayer((InputStream)((Object)((Object)MidletPBSP.vMidletInstance)).getClass().getResourceAsStream(MUSIC_FILES[ms_iCurrentMusicClip]), (String)MEDIAID_MID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                    try {
                        ms_vMusicPlayer.realize();
                    }
                    catch (Exception e) {
                        ms_vMusicPlayer = null;
                    }
                }
                try {
                    VolumeControl vVolumeControl = (VolumeControl)ms_vMusicPlayer.getControl("VolumeControl");
                    vVolumeControl.setLevel(SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    ms_vMusicPlayer.start();
                    ms_bAsyncException = false;
                }
                catch (Exception e) {
                    if (ms_vMusicPlayer.getState() == 200) {
                        ms_bAsyncException = true;
                        ms_iAsyncClip = ms_iCurrentMusicClip;
                        ms_bAsyncLoop = ms_bCurrentMusicLooping;
                        SndManager.StopMusic();
                    }
                    return;
                }
            }
            ms_bNewClip = false;
        }
        ms_bUpdatingSound = false;
    }

    public static void LoadMusic(byte _iSoundID, boolean _bLooping) {
        ms_zMediaId = MEDIAID_MID;
        ms_bNewMusicLooping = _bLooping;
        ms_lCurrentClipStartTime = System.currentTimeMillis();
        ms_iCurrentMusicClip = _iSoundID;
        ms_iNewMusicClip = _iSoundID;
        ms_bNewClip = true;
        ms_bUpdatingSound = true;
        if (System.currentTimeMillis() >= ms_lCurrentClipStartTime) {
            if ((ms_bNewClip || ms_bCurrentMusicLooping) && (ms_iCurrentMusicClip == -1 || ms_vMusicPlayer == null || ms_vMusicPlayer.getState() != 400)) {
                if (ms_bNewClip) {
                    if (ms_iCurrentMusicClip != -1) {
                        try {
                            ms_vMusicPlayer.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ms_vMusicPlayer = null;
                    }
                    ms_iCurrentMusicClip = ms_iNewMusicClip;
                    ms_bCurrentMusicLooping = ms_bNewMusicLooping;
                } else {
                    try {
                        if (ms_vMusicPlayer.getState() != 400) {
                            ms_vMusicPlayer.deallocate();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer == null) {
                    try {
                        ms_vMusicPlayer = Manager.createPlayer((InputStream)((Object)((Object)MidletPBSP.vMidletInstance)).getClass().getResourceAsStream(MUSIC_FILES[ms_iCurrentMusicClip]), (String)MEDIAID_MID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                    try {
                        ms_vMusicPlayer.realize();
                    }
                    catch (Exception e) {
                        ms_vMusicPlayer = null;
                    }
                }
                try {
                    ms_vMusicPlayer.prefetch();
                    ms_bAsyncException = false;
                }
                catch (Exception e) {
                    if (ms_vMusicPlayer.getState() == 200) {
                        ms_bAsyncException = true;
                        ms_iAsyncClip = ms_iCurrentMusicClip;
                        ms_bAsyncLoop = ms_bCurrentMusicLooping;
                        SndManager.StopMusic();
                    }
                    return;
                }
            }
            ms_bNewClip = false;
        }
        ms_bUpdatingSound = false;
        SndManager.PauseMusic();
        SndManager.UpdateMusic();
    }

    static void PlayMusic(byte _iSoundID, boolean _bLooping, int _iDelay) {
        if (ms_bSound) {
            ms_zMediaId = MEDIAID_MID;
            ms_bNewMusicLooping = _bLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + (long)_iDelay;
            ms_iCurrentMusicClip = _iSoundID;
            ms_iNewMusicClip = _iSoundID;
            ms_bNewClip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopMusic() {
        if (ms_iCurrentMusicClip != -1) {
            ms_bNewClip = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                try {
                    ms_vMusicPlayer.close();
                }
                finally {
                    ms_vMusicPlayer = null;
                }
            }
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            ms_lCurrentClipStartTime = Long.MAX_VALUE;
        }
    }

    static void PauseMusic() {
        if (ms_iCurrentMusicClip == -1) {
            System.out.println("Not pausing (no snd being played) - Frame " + SP.iFrame);
        } else {
            ms_bNewClip = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                ms_bPausedClip = true;
                ms_iPausedCurrentClip = ms_iCurrentMusicClip;
                ms_bPausedCurrentLooping = ms_bCurrentMusicLooping;
                try {
                    ms_vMusicPlayer.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            ms_lCurrentClipStartTime = Long.MAX_VALUE;
        }
    }

    static void UnpauseMusic() {
        if (ms_bSound && ms_bAsyncException) {
            SndManager.PlayMusic(ms_iAsyncClip, ms_bAsyncLoop, 1000);
            ms_bAsyncException = false;
        }
        if (ms_bSound && ms_bPausedClip) {
            ms_bNewMusicLooping = ms_bPausedCurrentLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + 100L;
            ms_iNewMusicClip = ms_iPausedCurrentClip;
            ms_bNewClip = true;
            ms_bPausedClip = false;
        }
    }

    public static void PlayFX(byte _iFXID, int _bLoopCount) {
        if (FX_SUPPORTED && ms_bSound) {
            try {
                if (ms_iCurrentFXClip != -1 && ms_vSndFxPlayer[ms_iCurrentFXClip] != null && ms_vSndFxPlayer[ms_iCurrentFXClip].getState() == 400 && ms_iCurrentFXClip != _iFXID) {
                    ms_vSndFxPlayer[ms_iCurrentFXClip].stop();
                }
            }
            catch (Exception ex) {
                SndManager.ms_vSndFxPlayer[SndManager.ms_iCurrentFXClip] = null;
            }
            ms_iCurrentFXClip = _iFXID;
            if (ms_vSndFxPlayer[ms_iCurrentFXClip] == null) {
                SndManager.LoadFX(_iFXID);
            }
            try {
                if (ms_vSndFxPlayer[ms_iCurrentFXClip].getState() != 400) {
                    VolumeControl vVolumeControl = (VolumeControl)ms_vSndFxPlayer[ms_iCurrentFXClip].getControl("VolumeControl");
                    vVolumeControl.setLevel(SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    ms_vSndFxPlayer[ms_iCurrentFXClip].start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void StopFX() {
        if (FX_SUPPORTED && ms_iCurrentFXClip != -1 && ms_vSndFxPlayer[ms_iCurrentFXClip] != null && ms_vSndFxPlayer[ms_iCurrentFXClip].getState() != 200) {
            try {
                ms_vSndFxPlayer[ms_iCurrentFXClip].stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public static void PlayTone(int _iType) {
        try {
            if (ms_bSound) {
                if (_iType == 0) {
                    Manager.playTone((int)68, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 1) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)68, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 2) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)52, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void FlushSndManager() {
        ms_bSound = false;
        SndManager.StopMusic();
        SndManager.DeleteFX();
    }

    static {
        NUM_MUSIC = MUSIC_FILES.length;
        NUM_SNDFX = SNDFX_FILES.length;
        ms_iCurrentFXClip = (byte)-1;
        ms_lCurrentClipStartTime = Long.MAX_VALUE;
        ms_vSndFxPlayer = new Player[NUM_SNDFX];
        NUM_MUSIC_CLIPS = MUSIC_FILES.length;
        ms_iCurrentMusicClip = (byte)-1;
        ms_iNewMusicClip = (byte)-1;
        NUM_FX_CLIPS = SNDFX_FILES.length;
    }
}

