/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer;

public class WorldPhysics {
    private static long iWindowsWidth;
    private static long iWindowsHeight;
    private static int iWorldWidth;
    private static int iWorldHeight;
    private static long iCircleRadius;
    private static long iLineThickness;
    private static long iAreaWidth;
    private static long iAreaHeight;
    private static long iFieldMargin;
    public static final int PRECISION_BITS = 8;
    public static final int TILE_SIZE = 16384;
    public static final long GOAL_SIZE = 12800L;

    public static void initialize(int _iWindowsWidth, int _iWindowsHeight, int _iWorldWidth, int _iWorldHeight) {
        iWindowsWidth = _iWindowsWidth;
        iWindowsHeight = _iWindowsHeight;
        iWorldWidth = _iWorldWidth << 8;
        iWorldHeight = _iWorldHeight << 8;
        iCircleRadius = (int)WorldPhysics.getWorldWidth() / 8;
        iLineThickness = 1024L;
        iAreaWidth = iCircleRadius * 2L + iCircleRadius / 2L;
        iAreaHeight = iCircleRadius + iCircleRadius / 2L;
        iFieldMargin = iCircleRadius / 2L + iCircleRadius / 6L;
    }

    public static long getWorldWidth() {
        return iWorldWidth;
    }

    public static long getWorldHeight() {
        return iWorldHeight;
    }

    public static long getWorldPlayWidth() {
        return (long)iWorldWidth - iFieldMargin;
    }

    public static long getWorldPlayHeight() {
        return (long)iWorldHeight - iFieldMargin;
    }

    public static long getMargin() {
        return iFieldMargin;
    }

    public static long getCircleRadius() {
        return iCircleRadius;
    }

    public static long getiLineThickness() {
        return iLineThickness;
    }

    public static long getAreaWidth() {
        return iAreaWidth;
    }

    public static long getAreaHeight() {
        return iAreaHeight;
    }

    public static int[] getIndexDrawX(int _iPlayerX, int _iNumberTilesX) {
        int iniX = 0;
        int finalX = _iNumberTilesX;
        int indexPlayerPos = _iPlayerX / 64;
        iniX = (int)((long)indexPlayerPos - iWindowsWidth / 2L / 64L) - 1;
        finalX = (int)((long)indexPlayerPos + iWindowsWidth / 2L / 64L) + 2;
        int exc = 0;
        if (iniX < 0) {
            exc = iniX * -1;
            iniX = 0;
        }
        if ((finalX += exc) > _iNumberTilesX - 1) {
            exc = finalX - _iNumberTilesX;
            iniX = iniX - exc >= 0 ? iniX - exc : iniX;
            finalX = _iNumberTilesX;
        }
        return new int[]{iniX, finalX};
    }

    public static int[] getIndexDrawY(int _iPlayerY, int _iNumberTilesY) {
        int iniY = 0;
        int finalY = _iNumberTilesY;
        int indexPlayerPos = _iPlayerY / 64;
        iniY = (int)((long)indexPlayerPos - iWindowsHeight / 2L / 64L) - 1;
        finalY = (int)((long)indexPlayerPos + iWindowsHeight / 2L / 64L) + 2;
        int exc = 0;
        if (iniY < 0) {
            exc = iniY * -1;
            iniY = 0;
        }
        if ((finalY += exc) > _iNumberTilesY - 1) {
            exc = finalY - _iNumberTilesY;
            iniY = iniY - exc >= 0 ? iniY - exc : iniY;
            finalY = _iNumberTilesY;
        }
        return new int[]{iniY, finalY};
    }

    public static int getConversionDrawX(int _iPlayerDrawX) {
        int worldW = iWorldWidth >> 8;
        long excededX = 0L;
        if ((long)_iPlayerDrawX > (long)worldW - iWindowsWidth / 2L) {
            excededX = (long)_iPlayerDrawX - ((long)worldW - iWindowsWidth / 2L);
        } else if ((long)_iPlayerDrawX < iWindowsWidth / 2L) {
            excededX = (long)_iPlayerDrawX - iWindowsWidth / 2L;
        }
        return (int)(iWindowsWidth / 2L + excededX);
    }

    public static int getConversionDrawY(int _iPlayerDrawY) {
        int worldH = iWorldHeight >> 8;
        long excededY = 0L;
        if ((long)_iPlayerDrawY > (long)worldH - iWindowsHeight / 2L) {
            excededY = (long)_iPlayerDrawY - ((long)worldH - iWindowsHeight / 2L);
        } else if ((long)_iPlayerDrawY < iWindowsHeight / 2L) {
            excededY = (long)_iPlayerDrawY - iWindowsHeight / 2L;
        }
        return (int)(iWindowsHeight / 2L + excededY);
    }

    public static int getConversionDrawX(int _iRefenceObjectX, int _iObjectDrawX) {
        int worldW = iWorldWidth >> 8;
        if ((long)_iRefenceObjectX < (long)worldW - iWindowsWidth / 2L) {
            if ((long)_iRefenceObjectX > iWindowsWidth / 2L) {
                return (int)(iWindowsWidth / 2L + (long)(_iObjectDrawX - _iRefenceObjectX));
            }
            return (int)(iWindowsWidth / 2L + (long)(_iObjectDrawX - _iRefenceObjectX) - (iWindowsWidth / 2L - (long)_iRefenceObjectX));
        }
        return (int)(iWindowsWidth / 2L + (long)(_iObjectDrawX - _iRefenceObjectX) + ((long)_iRefenceObjectX - ((long)worldW - iWindowsWidth / 2L)));
    }

    public static int getConversionDrawY(int _iRefenceObjectY, int _iObjectDrawY) {
        int worldH = iWorldHeight >> 8;
        if ((long)_iRefenceObjectY < (long)worldH - iWindowsHeight / 2L) {
            if ((long)_iRefenceObjectY > iWindowsHeight / 2L) {
                return (int)(iWindowsHeight / 2L + (long)(_iObjectDrawY - _iRefenceObjectY));
            }
            return (int)(iWindowsHeight / 2L + (long)(_iObjectDrawY - _iRefenceObjectY) - (iWindowsHeight / 2L - (long)_iRefenceObjectY));
        }
        return (int)(iWindowsHeight / 2L + (long)(_iObjectDrawY - _iRefenceObjectY) + ((long)_iRefenceObjectY - ((long)worldH - iWindowsHeight / 2L)));
    }
}

