/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer.tool;

public class Math2D {
    public static final int BITS = 10;
    public static final long UNIT = 1024L;
    public static final long PI = 3217L;
    public static final long[] SIN = new long[]{0L, 18L, 36L, 54L, 71L, 89L, 107L, 125L, 143L, 160L, 178L, 195L, 213L, 230L, 248L, 265L, 282L, 299L, 316L, 333L, 350L, 367L, 384L, 400L, 416L, 433L, 449L, 465L, 481L, 496L, 512L, 527L, 543L, 558L, 573L, 587L, 602L, 616L, 630L, 644L, 658L, 672L, 685L, 698L, 711L, 724L, 737L, 749L, 761L, 773L, 784L, 796L, 807L, 818L, 828L, 839L, 849L, 859L, 868L, 878L, 887L, 896L, 904L, 912L, 920L, 928L, 935L, 943L, 949L, 956L, 962L, 968L, 974L, 979L, 984L, 989L, 994L, 998L, 1002L, 1005L, 1008L, 1011L, 1014L, 1016L, 1018L, 1020L, 1022L, 1023L, 1023L, 1024L, 1024L};

    private static long product(long n, long m) {
        return n * m >> 10;
    }

    private static long divide(long n, long m) {
        return (n << 10) / m;
    }

    private static long next(long n, long i) {
        return n + i / n >> 1;
    }

    public static long sqrt(long number) {
        if (number == 0L) {
            return 0L;
        }
        long r = number <<= 10;
        long t = 0L;
        while (t != r) {
            t = r;
            r = (number << 10) / r + r >> 1;
        }
        return r >> 5;
    }

    public static long pow2(long n) {
        return n * n >> 10;
    }

    public static long[] normal(long pX, long pY, long qX, long qY, long x, long y) {
        long[] u = new long[]{qY - pY, pX - qX};
        if ((y - pY) * (qX - pX) > (x - pX) * (qY - pY)) {
            u[0] = pY - qY;
            u[1] = qX - pX;
        }
        u = Math2D.normalize(u[0], u[1]);
        return u;
    }

    public static long[] normalize(long x1, long y1) {
        long[] v = new long[]{0L, 0L};
        v[1] = Math2D.sqrt((x1 >>= 10) * x1 + (y1 >>= 10) * y1 >> 10);
        if (v[1] == 0L) {
            v[0] = x1;
            v[1] = y1;
            return v;
        }
        v[0] = (x1 << 10) / v[1];
        v[1] = (y1 << 10) / v[1];
        return v;
    }

    public static long[] getPointOverRect(long x3, long y3, long x1, long y1, long x2, long y2) {
        long[] pQ = new long[]{0L, 0L};
        if (Math.abs(x1 - x2) < 1024L) {
            pQ[0] = x1;
            pQ[1] = y3;
        } else if (Math.abs(y1 - y2) < 1024L) {
            pQ[0] = x3;
            pQ[1] = y1;
        } else {
            long m = (y2 - y1 << 10) / (x2 - x1);
            if (m != 0L) {
                long num = (x3 << 10) / m;
                num += m * x1 >> 10;
                num += y3 - y1;
                num = m * num >> 10;
                pQ[0] = (num << 10) / ((m * m >> 10) + 1024L);
                pQ[1] = y1 + (m * (pQ[0] - x1) >> 10);
            } else {
                pQ[0] = x3;
                pQ[1] = y1;
            }
        }
        return pQ;
    }

    public static int getRelativePosition(long x3, long y3, long x1, long y1, long x2, long y2) {
        if (x1 == x2) {
            return 0;
        }
        long[] p = Math2D.getPointOverRect(x3, y3, x1, y1, x2, y2);
        if (y3 > p[1]) {
            return 1;
        }
        if (y3 < p[1]) {
            return -1;
        }
        return 0;
    }

    public static int getRelativePosition2(long x3, long y3, long x1, long y1, long x2, long y2) {
        if (x1 >= x2 - 3000L) {
            return 0;
        }
        long[] p = Math2D.getPointOverRect(x3, y3, x1, y1, x2, y2);
        if (y3 > p[1]) {
            return 1;
        }
        if (y3 < p[1]) {
            return -1;
        }
        return 0;
    }

    public static long[] rotatePoint(long x1, long y1, int angle) {
        long[] pos = new long[]{0L, 0L};
        pos[0] = x1 * Math2D.cos(angle) - y1 * Math2D.sin(angle) >> 10;
        pos[1] = y1 * Math2D.cos(angle) + x1 * Math2D.sin(angle) >> 10;
        return pos;
    }

    public static long[] rotatePoint(long x1, long y1, int angle, long xC, long yC) {
        long[] pos = new long[]{0L, 0L};
        pos[0] = (x1 - xC) * Math2D.cos(angle) - (y1 - yC) * Math2D.sin(angle) >> 10;
        pos[1] = (y1 - yC) * Math2D.cos(angle) + (x1 - xC) * Math2D.sin(angle) >> 10;
        pos[0] = pos[0] + xC;
        pos[1] = pos[1] + yC;
        return pos;
    }

    public static long sin(int angle) {
        if (0 <= angle && angle <= 90) {
            return SIN[angle];
        }
        if (-90 <= angle && angle < 0) {
            return -SIN[-angle];
        }
        if (90 < angle && angle <= 180) {
            return SIN[180 - angle];
        }
        if (-180 <= angle && angle < -90) {
            return -SIN[180 + angle];
        }
        if (angle > 180) {
            while (angle > 180) {
                angle -= 360;
            }
        } else if (angle < 180) {
            while (angle < 0) {
                angle += 360;
            }
        } else {
            System.out.println("CAN'T COMPUTE sin(" + angle + ")");
        }
        return Math2D.sin(angle);
    }

    public static long cos(int angle) {
        return Math2D.sin(90 + angle);
    }

    public static int atan(long x1, long y1, long x2, long y2) {
        long angle;
        long x = x2 - x1;
        long y = y2 - y1;
        long coeff_1 = 804L;
        long coeff_2 = 3L * coeff_1;
        long abs_y = Math.abs(y);
        if (x == 0L) {
            return 90;
        }
        if (y == 0L) {
            return 0;
        }
        if (x > 0L) {
            long r = x - abs_y << 10;
            angle = coeff_1 - coeff_1 * (r /= x + abs_y);
        } else {
            long r = x + abs_y << 10;
            angle = coeff_2 - coeff_1 * (r /= abs_y - x);
        }
        angle = angle * 180L / 3217L >> 10;
        if (x >= 0L) {
            return y < 0L ? (int)(-angle - 45L) : (int)(angle + 45L);
        }
        return y < 0L ? (int)(-angle + 45L) : (int)(angle - 45L);
    }

    public static int atan2(long x1, long y1, long x2, long y2) {
        long angle;
        long x = x2 - x1;
        long y = y2 - y1;
        long coeff_1 = 804L;
        long coeff_2 = 3L * coeff_1;
        long abs_y = Math.abs(y);
        if (x < 0L) {
            x = Math.abs(x);
        }
        if (x == 0L) {
            return 90;
        }
        if (y == 0L) {
            return 0;
        }
        if (x > 0L) {
            long r = x - abs_y << 10;
            angle = coeff_1 - coeff_1 * (r /= x + abs_y);
        } else {
            long r = x + abs_y << 10;
            angle = coeff_2 - coeff_1 * (r /= abs_y - x);
        }
        angle = angle * 180L / 3217L >> 10;
        if (x >= 0L) {
            return y < 0L ? (int)(-angle - 45L) : (int)(angle + 45L);
        }
        return y < 0L ? (int)(-angle + 45L) : (int)(angle - 45L);
    }

    public static long distancePointRect_Pow2(long x1, long y1, long x2, long y2, long x3, long y3) {
        long d = 0L;
        if (Math.abs(x2 - x3) < 1024L) {
            d = x2 - x1;
            d = d * d >> 10;
        } else if (Math.abs(y2 - y3) < 1024L) {
            d = y2 - y1;
            d = d * d >> 10;
        } else {
            long m = (y3 - y2 << 10) / (x3 - x2);
            long num = m * (x1 - x2) >> 10;
            num = num - y1 + y2;
            num = num * num >> 10;
            long den = m * m >> 10;
            d = (num << 10) / (den += 1024L);
        }
        return d;
    }

    public static long distancePointPoint_Pow2(long x1, long y1, long x2, long y2) {
        long d = 0L;
        if (Math.abs(x2 - x1) < 1024L) {
            d = y2 - y1;
            d = d * d >> 10;
        } else if (Math.abs(y2 - y1) < 1024L) {
            d = x2 - x1;
            d = d * d >> 10;
        } else {
            d = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) >> 10;
        }
        return d;
    }

    public static boolean intersectionPointRects(long x1, long y1, long x2, long y2, long x3, long y3, long x4, long y4, long[] pQ) {
        long Ma = (y2 - y1 << 10) / (x2 - x1);
        long Mb = (y4 - y3 << 10) / (x4 - x3);
        if (Ma == Mb) {
            if (y3 - y1 == Ma * (x3 - x1)) {
                pQ = null;
                return true;
            }
            return false;
        }
        if (pQ != null) {
            pQ[0] = y3 - y1 + (Ma * x1 >> 10) - (Mb * x3 >> 10);
            pQ[0] = (pQ[0] << 10) / (Ma - Mb);
            pQ[1] = (Ma * (pQ[0] - x1) >> 10) + y1;
        }
        return true;
    }

    public static boolean intersectionPointSegments(long x1, long y1, long x2, long y2, long x3, long y3, long x4, long y4, long[] pQ) {
        return Math2D.intersectionPointRects(x1, y1, x2, y2, x3, y3, x4, y4, pQ) && Math.min(x1, x2) <= pQ[0] && pQ[0] <= Math.max(x1, x2) && Math.min(y1, y2) <= pQ[1] && pQ[1] <= Math.max(y1, y2) && Math.min(x3, x4) <= pQ[0] && pQ[0] <= Math.max(x3, x4) && Math.min(y3, y4) <= pQ[1] && pQ[1] <= Math.max(y3, y4);
    }

    public static int intersectionPolygonSegment(long[] px, long[] py, long sx1, long sy1, long sx2, long sy2, long[] pQ) {
        for (int s = 0; s < px.length - 1; ++s) {
            if (!Math2D.intersectionPointSegments(px[s], py[s], px[s + 1], py[s + 1], sx1, sy1, sx2, sy2, pQ)) continue;
            return s;
        }
        if (Math2D.intersectionPointSegments(px[px.length - 1], py[px.length - 1], px[0], py[0], sx1, sy1, sx2, sy2, pQ)) {
            return px.length - 1;
        }
        return -1;
    }

    public static int getPixel(long c) {
        return (int)c >> 10;
    }

    public static long getWorld(long c) {
        return c >> 10;
    }

    public static int getAngle360(long _iPosX1, long _iPosY1, long _iPosX2, long _iPosY2) {
        int angle360 = Math2D.atan(_iPosX1, _iPosY1, _iPosX2, _iPosY2);
        int n = angle360 = angle360 < 0 ? angle360 * -1 : angle360;
        if (_iPosX2 == _iPosX1) {
            if (_iPosY2 == _iPosY1) {
                return -1;
            }
            if (_iPosY2 > _iPosY1) {
                return 270;
            }
            return 90;
        }
        if (_iPosY2 == _iPosY1) {
            if (_iPosX2 == _iPosX1) {
                return -1;
            }
            if (_iPosX2 > _iPosX1) {
                return 0;
            }
            return 180;
        }
        if (_iPosX2 > _iPosX1 && _iPosY2 < _iPosY1) {
            return angle360;
        }
        if (_iPosX2 < _iPosX1 && _iPosY2 < _iPosY1) {
            return 180 - angle360;
        }
        if (_iPosX2 < _iPosX1 && _iPosY2 > _iPosY1) {
            return 180 + angle360;
        }
        return 360 - angle360;
    }

    public static int getDif360(int _iAng1, int _iAng2) {
        if (_iAng1 == _iAng2) {
            return 0;
        }
        if (_iAng1 + _iAng2 > 360) {
            if ((_iAng1 < 180 || _iAng2 < 180) && (_iAng1 > _iAng2 ? _iAng1 : _iAng2) - (_iAng1 < _iAng2 ? _iAng1 : _iAng2) > 180) {
                return 360 - (_iAng1 > _iAng2 ? _iAng1 : _iAng2) + (_iAng1 < _iAng2 ? _iAng1 : _iAng2);
            }
            if (_iAng1 > _iAng2) {
                return 360 - (_iAng2 + (360 - _iAng1) % 360);
            }
            return 360 - (_iAng1 + (360 - _iAng2) % 360);
        }
        if (_iAng1 + _iAng2 == 360) {
            if ((_iAng1 < 180 || _iAng2 < 180) && (_iAng1 > _iAng2 ? _iAng1 : _iAng2) - (_iAng1 < _iAng2 ? _iAng1 : _iAng2) < 180) {
                return (_iAng1 > _iAng2 ? _iAng1 : _iAng2) - (_iAng1 < _iAng2 ? _iAng1 : _iAng2);
            }
            return 360 - (_iAng1 > _iAng2 ? _iAng1 : _iAng2) + (_iAng1 < _iAng2 ? _iAng1 : _iAng2);
        }
        if ((_iAng1 < 180 || _iAng2 < 180) && (_iAng1 > _iAng2 ? _iAng1 : _iAng2) - (_iAng1 < _iAng2 ? _iAng1 : _iAng2) > 180) {
            return 360 - (360 + (_iAng1 - _iAng2 > 0 ? _iAng1 - _iAng2 : (_iAng1 - _iAng2) * -1)) % 360;
        }
        return _iAng1 - _iAng2 > 0 ? _iAng1 - _iAng2 : (_iAng1 - _iAng2) * -1;
    }
}

