/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Levels;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int COMP_ID_G0_RESTART = 7;
    private static final int COMP_ID_G0_HOME = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] _rectItems_TXT = new Rectangle[9];
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectDialog;
    private Rectangle _rectGameOver;
    private Rectangle _rectTopBig;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private int selectedCompId;
    private static PreparedText _ptMenuItem;
    private static PreparedText _ptInstruction;
    private static PreparedText _ptActualScore;
    private static PreparedText _ptActualScoreGameOver;
    private static PreparedText best;
    private static PreparedText bestScore;
    private static PreparedText navigationKeysBB;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _imgGameLogo;
    private Image _imgMenuBg;
    private Sprite _sprIconsFk;
    private Sprite _sprIconsResultPlay;
    private Sprite _sprIconsMenu;
    private Sprite _sprCrow;
    private Sprite _sprWindow;
    private Sprite _sprGameTiles;
    private Sprite _sprFireWorks;
    private Sprite _sprFinalBtn;
    private Sprite _sprIconcMenuSelector;
    private static int _WIDTH;
    private static int _HEIGHT;
    int _iMode = 0;
    private static final int NORMAL = 0;
    private static final int HARD = 1;
    private static final int EASY = 2;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    private Levels _lActualLevel;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    boolean _bBkickUpdate = true;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, int mode) {
        this.mainCanvas = mainCanvas;
        this._iMode = 0;
        this.initDimensions();
        this.status = 0;
        this._lActualLevel = new Levels();
        this._lActualLevel.LoadLevel(1);
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true);
        this._bBkickUpdate = false;
    }

    public void afterHide() {
        this.freeGraphics();
        this.freeResources();
    }

    private void prepareResources() {
        this._arrImages = new int[]{3, 2};
        this._arrSprites = new int[]{12, 6, 21, 22, 8, 9, 17, 13, 14, 15, 19, 20};
        this._arrFonts = new int[]{0, 1, 2, 3, 4};
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[2];
        this._imgMenuBg = Resources.resImgs[3];
    }

    private void initSprites() {
        this._sprIconsFk = Resources.resSprs[12];
        this._sprCrow = Resources.resSprs[21];
        this._sprFireWorks = Resources.resSprs[22];
        this._sprIconsMenu = Resources.resSprs[6];
        this._sprIconcMenuSelector = Resources.resSprs[9];
        this._sprWindow = Resources.resSprs[17];
        this._sprGameTiles = Resources.resSprs[13];
        this._sprFinalBtn = Resources.resSprs[8];
    }

    public void initTxt() {
        Resources.loadText(0);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptInstruction = new PreparedText(Resources.resGFonts[0]);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[2]);
        bestScore = new PreparedText(Resources.resGFonts[0]);
        best = new PreparedText(Resources.resGFonts[4]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 9;
        this._animationSequence[0][1] = 7;
        this._animationSequence[0][2] = 12;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 6;
        this._animationSequence[1][6] = 12;
        this._animationSequence[1][7] = 10;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 12;
        this._animationSequence[3][2] = 17;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = 5;
        this._animationSequence[3][5] = 13;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = 16;
        this._animationSequence[6][3] = 17;
        this._animationSequence[6][4] = 5;
        this._animationSequence[6][5] = 13;
        this._animationSequence[6][6] = 11;
        this._animationSequence[6][7] = 12;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = 16;
        this._animationSequence[5][3] = 17;
        this._animationSequence[5][4] = 5;
        this._animationSequence[5][5] = 13;
        this._animationSequence[5][6] = 12;
        this._animationSequence[5][7] = 11;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = 9;
        this._animationSequence[2][2] = 16;
        this._animationSequence[2][3] = 17;
        this._animationSequence[2][4] = 5;
        this._animationSequence[2][5] = 11;
        this._animationSequence[2][6] = 12;
        this._animationSequence[2][7] = 13;
        this._animationSequence[2][8] = 14;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectBestScore, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectGameArea, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this._rectGameOver, _WIDTH, _HEIGHT);
        this._animationComponents[14].startShowAnimation(3);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(3);
        this._animationComponents[6].startHideAnimation(2);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(0);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(3);
        this._animationComponents[14].startHideAnimation(3);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgMenuBg = null;
        this._sprFireWorks = null;
        this._sprIconsFk = null;
        this._sprIconsMenu = null;
        this._sprCrow = null;
        this._sprWindow = null;
        this._sprGameTiles = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(17) + "\n                                                             \n                                         \n                 \n  ";
        _ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        _ptInstruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores = RMSObjects.normal.getScoresForGame(0);
        if (this._iMode == 2) {
            RMSObjects.createRMSConnect(4);
            if (!RMSObjects.rmsConnects[4].load()) {
                RMSObjects.rmsConnects[4].create();
            }
            scores = RMSObjects.easy.getScoresForGame(0);
        } else if (this._iMode == 0) {
            RMSObjects.createRMSConnect(5);
            if (!RMSObjects.rmsConnects[5].load()) {
                RMSObjects.rmsConnects[5].create();
            }
            scores = RMSObjects.normal.getScoresForGame(0);
        } else if (this._iMode == 1) {
            RMSObjects.createRMSConnect(3);
            if (!RMSObjects.rmsConnects[3].load()) {
                RMSObjects.rmsConnects[3].create();
            }
            scores = RMSObjects.hard.getScoresForGame(0);
        } else {
            RMSObjects.createRMSConnect(5);
            if (!RMSObjects.rmsConnects[5].load()) {
                RMSObjects.rmsConnects[5].create();
            }
            scores = RMSObjects.normal.getScoresForGame(0);
        }
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void loadFirstPlay() {
        Vector scores = RMSObjects.firstPlay.getScoresForGame(0);
        RMSObjects.createRMSConnect(6);
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            if (this._iMode == 2) {
                RMSObjects.easy.userName = Integer.toString(0);
                RMSObjects.easy.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                RMSObjects.rmsConnects[4].save();
            } else if (this._iMode == 0) {
                RMSObjects.normal.userName = Integer.toString(0);
                RMSObjects.normal.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                RMSObjects.rmsConnects[5].save();
            } else if (this._iMode == 1) {
                RMSObjects.hard.userName = Integer.toString(0);
                RMSObjects.hard.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                RMSObjects.rmsConnects[3].save();
            }
        }
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            Keys.resetAllPressedKeysAndActions();
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        int itemHeight;
        int rectPanelY = itemHeight = Resources.resGFonts[0].getHeight();
        int rectTextOffsetX = this._sprIconsFk.getWidth() >> 1;
        int rectTextOffsetY = this._sprIconsFk.getHeight() >> 1;
        int _gaWidth = this._sprGameTiles.getWidth() * 5;
        int _gaHeight = this._sprGameTiles.getWidth() * 5;
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        this.rectGameArea = new Rectangle(_WIDTH - _gaWidth >> 1, _HEIGHT - _gaHeight >> 1, _gaWidth, _gaHeight);
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[2]);
        _ptActualScore.prepareText("0", this.mainCanvas.getWidth());
        this.rectScore = new Rectangle(0, itemHeight >> 1, this.mainCanvas.getWidth(), _ptActualScore.getTextHeight());
        this.rectBestScore = new Rectangle(0, itemHeight >> 1, this.mainCanvas.getWidth(), itemHeight);
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectItems[3] = new Rectangle((_WIDTH >> 1) - (this._sprIconsMenu.getWidth() >> 1), (_HEIGHT >> 1) + (this._sprIconsMenu.getHeight() >> 2), this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        int pY = this.rectItems[3].y + this.rectItems[3].height + (this._sprIconsMenu.getWidth() >> 2);
        int pX = (_WIDTH >> 1) - (this._sprIconsMenu.getWidth() >> 1);
        int pXoffset = this._sprIconsMenu.getWidth() + (this._sprIconsMenu.getWidth() >> 1);
        this.rectItems[4] = new Rectangle(pX, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        this.rectItems[6] = new Rectangle(pX - pXoffset, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        this.rectItems[5] = new Rectangle(pX + pXoffset, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        this.rectItems[0] = this.rectLeftFk = new Rectangle(0, _HEIGHT - (this._sprIconsFk.getHeight() << 1), this._sprIconsFk.getWidth() << 1, this._sprIconsFk.getHeight() << 1);
        this.rectItems[1] = this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - (this._sprIconsFk.getWidth() << 1), _HEIGHT - (this._sprIconsFk.getHeight() << 1), this._sprIconsFk.getWidth() << 1, this._sprIconsFk.getHeight() << 1);
        this.rectPlay = new Rectangle(0, _HEIGHT >> 1, _WIDTH, itemHeight);
        int posLogoY = (_HEIGHT - this.rectItems[3].y >> 1) - (this._imgGameLogo.getHeight() >> 1);
        this._rectTopBig = new Rectangle(_WIDTH >> 1, posLogoY, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindow.getWidth() > 0 ? _windowWidth % this._sprWindow.getWidth() : this._sprWindow.getWidth();
        int _offsetTopY = (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight() << 1) + this._sprIconsFk.getHeight();
        int _offsetBottomY = this._sprIconsFk.getHeight() + (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight());
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprWindow.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindow.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        int _offsetTopGameOverY = (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight() << 1) + this._sprIconsFk.getHeight();
        int _offsetBottomGameOverY = this._sprFinalBtn.getHeight() + (this._sprWindow.getWidth() << 1);
        int _panelHeightGameOver = _HEIGHT - _offsetTopGameOverY - _offsetBottomGameOverY;
        int _iFinalHeightGameOver = _panelHeightGameOver % this._sprWindow.getWidth() == 0 ? _panelHeightGameOver : _panelHeightGameOver - _panelHeightGameOver % this._sprWindow.getWidth();
        this._rectGameOver = new Rectangle(_offsetX, _offsetTopGameOverY, _WIDTH - (_offsetX << 1), _iFinalHeightGameOver);
        this.rectItems[8] = new Rectangle((_WIDTH >> 1) + this._sprFinalBtn.getWidth(), this._rectGameOver.y + this._rectGameOver.height + this._sprWindow.getWidth(), this._sprFinalBtn.getWidth(), this._sprFinalBtn.getHeight());
        this.rectItems[7] = new Rectangle((_WIDTH >> 1) - (this._sprFinalBtn.getWidth() << 1), this._rectGameOver.y + this._rectGameOver.height + this._sprWindow.getWidth(), this._sprFinalBtn.getWidth(), this._sprFinalBtn.getHeight());
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColTiles = (_WIDTH - (this._iOffsetX << 1)) / this._sprWindow.getWidth();
        this._iTotalRowTiles = this._iFinalHeight / this._sprWindow.getWidth();
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
        if (this.status == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            if (this._bBkickUpdate) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            this.mainCanvas.repaint();
            if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
            }
        }
        if (this.status == 2) {
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = _ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g, this.status);
                this.paintPanelTop(g);
                break;
            }
            case 1: {
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintGameOver(g);
                break;
            }
            case 3: {
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.drawImage(this._imgMenuBg, _WIDTH >> 1, _HEIGHT >> 1, 3);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.y, 17);
    }

    private void paintInstrusctionTxt(Graphics g) {
        _ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            Sprite _sprWarrior = Resources.resSprs[14];
            _sprWarrior.setFrame(RMSObjects.game.GetMaxTile() - 1);
            _sprWarrior.setPosition((this.rectText.width >> 1) - (_sprWarrior.getWidth() >> 1), this.rectText.y);
            _sprWarrior.paint(g);
            String text = Resources.resTexts[0].getHashedString(13);
            String nect = this.bestScoreSave < RMSObjects.game.getScore() ? "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getScore() : "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + this.bestScoreSave;
            _ptMenuItem.prepareText(text, this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() + (_ptMenuItem.getTextHeight() >> 1), 3);
            bestScore.prepareText(nect, this.rectText.width);
            bestScore.drawText(g, this.rectText, _ptMenuItem.getTextHeight(), 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            _ptMenuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintGameOver(Graphics g) {
        this.paintWindow(g, this._rectGameOver);
        int _iWarrior = 0;
        Sprite _sprWarrior = Resources.resSprs[14];
        _iWarrior = RMSObjects.game.GetMaxTile() != 0 ? RMSObjects.game.GetMaxTile() - 1 : 0;
        _sprWarrior.setFrame(_iWarrior);
        _sprWarrior.setPosition((this._rectGameOver.width >> 1) - (_sprWarrior.getHeight() >> 3), this._rectGameOver.y + this._rectGameOver.height - _sprWarrior.getHeight() - (_sprWarrior.getHeight() >> 1));
        this._sprFireWorks.setPosition(_sprWarrior.getX() - ((this._sprFireWorks.getWidth() >> 1) - (_sprWarrior.getWidth() >> 1)), _sprWarrior.getY());
        this._sprFireWorks.paint(g);
        _sprWarrior.paint(g);
        this._sprCrow.setPosition((this._rectGameOver.width >> 1) - (this._sprCrow.getWidth() >> 3), this._rectGameOver.y);
        this._sprCrow.paint(g);
        String text = "" + RMSObjects.game.getScore();
        String nect = this.bestScoreSave < RMSObjects.game.getScore() ? "" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getScore() : "" + Resources.resTexts[0].getHashedString(83) + ": " + this.bestScoreSave;
        this.paintWindowBlue(g, new Rectangle(this._rectGameOver.x, this._sprCrow.getY() + this._sprCrow.getHeight() + (this._sprWindow.getWidth() >> 2), this._rectGameOver.width, 5 * this._sprWindow.getWidth()));
        Rectangle _rectScore = new Rectangle(this._rectGameOver.x, this._sprCrow.getY() + this._sprCrow.getHeight() + (this._sprWindow.getWidth() >> 2), this._rectGameOver.width, 5 * this._sprWindow.getWidth());
        Rectangle _rectBestScore = new Rectangle(this._rectGameOver.x, _rectScore.y + _rectScore.height, this._rectGameOver.width, 5 * this._sprWindow.getWidth());
        _ptActualScoreGameOver.prepareText(text, _rectScore.width);
        _ptActualScoreGameOver.drawText(g, _rectScore, 0, 3);
        best.prepareText(nect, _rectBestScore.width);
        best.drawText(g, _rectBestScore, -(best.getTextHeight() >> 1), 17);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprIconsFk.setFrame(1);
            this._sprIconsFk.setTransform(0);
            this._sprIconsFk.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprIconsFk.getHeight() - (this._sprIconsFk.getHeight() >> 1));
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setTransform(3);
            this._sprIconsFk.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprIconsFk.getHeight() >> 1));
            this._sprIconsFk.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprIconsFk.setFrame(1);
            this._sprIconsFk.setTransform(0);
            this._sprIconsFk.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprIconsFk.getHeight() - (this._sprIconsFk.getHeight() >> 1));
            this._sprIconsFk.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprIconsFk.setFrame(1);
            this._sprIconsFk.setTransform(3);
            this._sprIconsFk.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprIconsFk.getHeight() >> 1));
            this._sprIconsFk.paint(g);
        }
        this._sprIconsFk.setTransform(0);
    }

    private void paintPanelTop(Graphics g) {
        if (RMSObjects.game.getScore() <= 0) {
            _ptActualScore.prepareText("0", this.rectScore.width);
            System.out.println("RMSObjects.game.getScore(): " + RMSObjects.game.getScore());
        } else {
            _ptActualScore.prepareText("" + RMSObjects.game.getScore(), this.rectScore.width);
        }
        _ptActualScore.drawText(g, this.rectScore, 0, 3);
    }

    public void paintTop(Graphics g) {
    }

    private void paintFK(Graphics g) {
        if (this.status == 0) {
            this._sprIconsFk.setFrame(0);
            this._sprIconsFk.setPosition(this.rectRightFk.x + this._sprIconsFk.getWidth(), this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 4) {
            this._sprIconsFk.setFrame(2);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 1) {
            this._sprIconsFk.setFrame(2);
            this._sprIconsFk.setPosition(this.rectRightFk.x + this._sprIconsFk.getWidth(), this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 3) {
            this._sprIconsFk.setFrame(2);
            this._sprIconsFk.setPosition(this.rectRightFk.x + this._sprIconsFk.getWidth(), this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 5) {
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectRightFk.x + this._sprIconsFk.getWidth(), this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 6) {
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectRightFk.x + this._sprIconsFk.getWidth(), this.rectRightFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.status == 2) {
            this._sprFinalBtn.setFrame(0);
            this._sprFinalBtn.setPosition(this.rectItems[7].x, this.rectItems[7].y);
            this._sprFinalBtn.paint(g);
            this._sprFinalBtn.setFrame(1);
            this._sprFinalBtn.setPosition(this.rectItems[8].x, this.rectItems[8].y);
            this._sprFinalBtn.paint(g);
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 3) {
            this.paintButton(g, 3, 3, true);
        } else {
            this.paintButton(g, 3, 3, false);
        }
        if (this.selectedCompId == 6) {
            this.paintButton(g, 6, 0, true);
        } else {
            this.paintButton(g, 6, 0, false);
        }
        if (this.selectedCompId == 4) {
            this.paintButton(g, 4, MainCanvas.soundManager.IsSoundOn() ? 1 : 5, true);
        } else {
            this.paintButton(g, 4, MainCanvas.soundManager.IsSoundOn() ? 1 : 5, false);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, 4, true);
        } else {
            this.paintButton(g, 5, 4, false);
        }
    }

    private String getButtonName(int _idx) {
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(25);
        }
        if (_idx == 6) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 5) {
            return Resources.resTexts[0].getHashedString(19);
        }
        if (_idx == 4) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            this._sprIconsMenu.setFrame(frame);
            this._sprIconsMenu.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            this._sprIconsMenu.paint(g);
        } else {
            this._sprIconsMenu.setFrame(frame);
            this._sprIconsMenu.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            this._sprIconsMenu.paint(g);
        }
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = _rectWindow.x; x < _rectWindow.x + _rectWindow.width; x += this._sprWindow.getWidth()) {
            for (int y = _rectWindow.y; y < _rectWindow.y + _rectWindow.height; y += this._sprWindow.getWidth()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintWindowBlue(Graphics g, Rectangle _rectWindow) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        int _iTmpRows = 3;
        for (int x = _rectWindow.x; x < _rectWindow.x + _rectWindow.width; x += this._sprWindow.getWidth()) {
            for (int y = _rectWindow.y; y < _rectWindow.y + _rectWindow.height; y += this._sprWindow.getWidth()) {
                this._sprWindow.setFrame(this.getWindowTileSpriteBlue(_actualTileX, _actualTileY, this._iTotalColTiles, _iTmpRows));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getWindowTileSprite(int _x, int _y) {
        return 7;
    }

    private int getWindowTileSpriteBlue(int _x, int _y, int cols, int rows) {
        return 10;
    }

    public void keyPressed(int keyCode) {
        if (0 != this.status || Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode)) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (!Keys.isFKLeftCode(keyCode)) {
                    if (keyCode == 49) {
                        RMSObjects.game.GetTileInfo();
                    } else if (keyCode == 51) {
                        RMSObjects.game.clear();
                    } else if (keyCode == 57) {
                        RMSObjects.game.clear();
                    } else if (keyCode == 55) {
                        RMSObjects.game.clear();
                    }
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.MoveSelector(3);
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.MoveSelector(4);
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.MoveSelector(1);
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.MoveSelector(2);
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.SelectTile();
                RMSObjects.game.rotate();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                if (this.selectedCompId != 3 && this.selectedCompId != 6 && this.selectedCompId != 5) break;
                this.checkButton2 = this.selectedCompId;
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.startAnimation(true, 7);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                Keys.resetAllPressedKeysAndActions();
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            Keys.resetAllPressedKeysAndActions();
            RMSObjects.game.releaaseControls();
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
            this.checkButton = this.selectedCompId;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block7: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
                this.checkButton2 = this.selectedCompId;
            }
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block7;
                    }
                    Keys.keyPressed(-6);
                    continue block7;
                }
                case 7: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block7;
                    }
                    Keys.keyPressed(-6);
                    continue block7;
                }
                case 8: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        this.mainCanvas.repaint();
                        continue block7;
                    }
                    Keys.keyPressed(-7);
                    continue block7;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        this.mainCanvas.repaint();
                        continue block7;
                    }
                    Keys.keyPressed(-7);
                    continue block7;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    if (this.selectedCompId == 4) {
                        this.selectedCompId = this.checkButton2;
                    }
                    this.mainCanvas.repaint();
                    continue block7;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 8) {
                return true;
            }
            if (i == 7) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                if (this.selectedCompId != 6 && (this.selectedCompId == 3 || this.selectedCompId == 5)) {
                    if (this.checkButton2 == 6 || this.checkButton2 == 3 || this.checkButton2 == 5) {
                        this.selectedCompId = this.checkButton2;
                        break;
                    }
                    this.selectedCompId = 3;
                    break;
                }
                this.selectedCompId = this.checkButton;
                break;
            }
            case 7: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                if (this.selectedCompId != 6 && (this.selectedCompId == 3 || this.selectedCompId == 5)) {
                    if (this.checkButton2 == 6 || this.checkButton2 == 3 || this.checkButton2 == 5) {
                        this.selectedCompId = this.checkButton2;
                        break;
                    }
                    this.selectedCompId = 3;
                    break;
                }
                this.selectedCompId = this.checkButton;
                break;
            }
            case 8: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
            }
        }
        if (this.selectedCompId == 4) {
            this.selectedCompId = 3;
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = _ptInstruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

