/*
 * Decompiled with CFR 0.152.
 */
class cActor {
    static cActor[] s_listRoots = new cActor[4];
    cActor m_next;
    cActor m_prev;
    int m_actorListID = -1;
    int m_type;
    int m_x;
    int m_y;
    int m_z;
    int[] m_blending = null;
    int m_paletteID;
    int m_currentAnim;
    int m_currentLoopAnim;
    int m_currentSingleAnim;
    int m_objectType;
    int m_scene;
    boolean m_isLoopingAnim;
    GLLibPlayer m_animationPlayer;
    int m_levelOfDetail;
    int m_sceneObjectIdx = -1;
    static int s_debugScene = -1;
    static int s_debugObjectIdx = -1;

    cActor() {
    }

    static void ActorLists_ClearAll() {
        for (int i = 0; i < 4; ++i) {
            cActor.ActorLists_ClearList(i);
        }
    }

    static void ActorLists_ClearList(int p_iList) {
        while (s_listRoots[p_iList] != null) {
            s_listRoots[p_iList].Remove();
        }
    }

    static void ActorLists_InsertInList(cActor p_actor, int p_iList) {
        p_actor.m_actorListID = p_iList;
        cActor prevE = null;
        cActor nextE = s_listRoots[p_iList];
        while (nextE != null && p_actor.GetZOrder() > nextE.GetZOrder()) {
            prevE = nextE;
            nextE = nextE.m_next;
        }
        p_actor.m_prev = prevE;
        p_actor.m_next = nextE;
        if (prevE == null) {
            cActor.s_listRoots[p_iList] = p_actor;
        } else {
            prevE.m_next = p_actor;
        }
        if (nextE != null) {
            nextE.m_prev = p_actor;
        }
    }

    void Remove() {
        if (this.m_prev != null) {
            this.m_prev.m_next = this.m_next;
        } else {
            cActor.s_listRoots[this.m_actorListID] = this.m_next;
        }
        if (this.m_next != null) {
            this.m_next.m_prev = this.m_prev;
        }
        this.m_actorListID = -1;
        this.m_next = null;
        this.m_prev = null;
    }

    public void Set(int p_type, int[] p_param) {
        if (this.m_sceneObjectIdx == -1) {
            this.m_scene = s_debugScene;
            this.m_sceneObjectIdx = s_debugObjectIdx;
        }
        try {
            this.m_type = p_type;
            this.m_x = p_param[2];
            this.m_y = p_param[3];
            this.m_levelOfDetail = 0;
            switch (this.m_type) {
                case 0: {
                    ASprite sprite = cGame.m_sceneSprites[p_param[5]];
                    this.m_z = p_param[8];
                    this.m_levelOfDetail = p_param[12];
                    this.m_paletteID = p_param[9];
                    if (this.m_objectType == 5) {
                        this.m_paletteID = cGame.s_opponentCharPalIdx;
                    }
                    if (this.m_animationPlayer == null) {
                        this.m_animationPlayer = new GLLibPlayer(sprite, this.m_x, this.m_y);
                    }
                    this.m_currentLoopAnim = (this.m_objectType == 2 || this.m_objectType == 5) && cGame.s_enableDrums ? p_param[6] + 33 : p_param[6];
                    this.m_animationPlayer.SetAnim(this.m_currentLoopAnim, -1);
                    this.m_objectType = p_param[7];
                    if (this.m_objectType == 6 || this.m_objectType == 8 || this.m_objectType == 7) {
                        if (this.m_blending == null) {
                            this.m_blending = new int[5];
                        }
                        this.m_blending[0] = p_param[9];
                        this.m_blending[1] = p_param[9];
                        this.m_blending[2] = 0;
                        this.m_blending[3] = 0;
                    } else if (this.m_paletteID > 0) {
                        this.m_animationPlayer.GetSprite().SetCurrentPalette(this.m_paletteID);
                    }
                    this.m_scene = 0;
                    this.m_isLoopingAnim = true;
                    this.m_currentSingleAnim = -1;
                    break;
                }
                default: {
                    this.m_type = -1;
                    break;
                }
            }
        }
        catch (Exception e) {
            this.DebugSceneObjectException("*** Actor set method returned an error");
        }
        this.DebugSOCorrectDefinition(p_param[5], this.m_objectType);
    }

    public void Set(int _type, short[] p_param) {
        int[] newParams = new int[p_param.length];
        for (int i = 0; i < newParams.length; ++i) {
            newParams[i] = p_param[i];
        }
        this.Set(_type, newParams);
    }

    void Update() {
        if (this.m_levelOfDetail > cGame.s_deviceLvlOfDetail) {
            return;
        }
        if (this.m_animationPlayer != null) {
            if (this.m_isLoopingAnim) {
                if (this.m_currentSingleAnim >= 0) {
                    this.m_currentAnim = this.m_currentSingleAnim;
                    this.m_animationPlayer.SetAnim(this.m_currentAnim, 1);
                    this.m_isLoopingAnim = false;
                } else if (this.m_currentAnim != this.m_currentLoopAnim) {
                    this.m_currentAnim = this.m_currentLoopAnim;
                    this.m_animationPlayer.SetAnim(this.m_currentAnim, -1);
                }
            } else if (this.m_animationPlayer.IsAnimOver()) {
                this.m_currentAnim = this.m_currentLoopAnim;
                this.m_currentSingleAnim = -1;
                this.m_animationPlayer.SetAnim(this.m_currentAnim, -1);
                this.m_isLoopingAnim = true;
            }
            if (this.m_blending != null && this.m_blending[3] < this.m_blending[2]) {
                this.m_blending[3] = this.m_blending[3] + cGame.s_game_frameDT;
                if (this.m_blending[3] >= this.m_blending[2]) {
                    if (this.m_blending[4] == 0) {
                        int temp = this.m_blending[0];
                        this.m_blending[0] = this.m_blending[1];
                        this.m_blending[1] = temp;
                        this.m_blending[3] = 0;
                    } else if (this.m_blending[4] == 1) {
                        this.m_blending[0] = this.m_blending[1];
                        this.m_blending[2] = 0;
                        this.m_blending[3] = 0;
                    }
                }
            }
            this.m_animationPlayer.Update(cGame.s_game_frameDT);
        }
        switch (this.m_type) {
            case -1: {
                this.Remove();
            }
        }
    }

    public void Draw() {
        if (this.m_levelOfDetail > cGame.s_deviceLvlOfDetail) {
            return;
        }
        long debugFpsSpentTime = System.currentTimeMillis();
        switch (this.m_type) {
            case 0: {
                ASprite animPlayerSprite = this.m_animationPlayer.GetSprite();
                animPlayerSprite.SetCurrentPalette(this.m_paletteID);
                if (animPlayerSprite.GetCurrentPalette() != this.m_paletteID) {
                    animPlayerSprite.SetCurrentPalette(this.m_paletteID);
                }
                if (this.m_objectType == 2) {
                    int posX = this.m_x + this.ApplyDeph(cGame.s_cameraX, this.m_z);
                    int posY = this.m_y + this.ApplyDeph(cGame.s_cameraY, this.m_z);
                    cGame.PaintRockerAnim(this.m_animationPlayer, cGame.s_gameCharacter, cGame.s_rockerGuitar, posX, posY, 0, cGame.s_enableDrums);
                    break;
                }
                if (this.m_objectType == 5) {
                    int posX = this.m_x + this.ApplyDeph(cGame.s_cameraX, this.m_z);
                    int posY = this.m_y + this.ApplyDeph(cGame.s_cameraY, this.m_z);
                    int flags = 0;
                    if (!cGame.s_enableDrums) {
                        flags = 1;
                    }
                    cGame.PaintRockerAnim(this.m_animationPlayer, cGame.s_opponentCharIdx, cGame.s_bossInstrument, posX, posY, flags, cGame.s_enableDrums);
                    break;
                }
                if (this.m_blending != null) {
                    if (this.m_blending[3] >= this.m_blending[2]) {
                        animPlayerSprite.SetCurrentPalette(this.m_blending[1]);
                    } else if (this.m_blending[3] == 0) {
                        animPlayerSprite.SetCurrentPalette(this.m_blending[0]);
                    } else {
                        int blendValue = this.m_blending[3] * 255 / this.m_blending[2];
                        if (blendValue < 0 || blendValue > 255) {
                            this.DebugSceneObjectException(null);
                        }
                        animPlayerSprite.PaletteBlending_BuildPalette(blendValue, this.m_blending[0], this.m_blending[1], cGame.m_customLightPalette, false);
                        animPlayerSprite.SetCurrentPalette(cGame.m_customLightPalette);
                        animPlayerSprite.PaletteBlending_SynchCache();
                    }
                }
                if (this.m_objectType == 11) {
                    if (cGame.m_dangerFading == 0) break;
                    break;
                }
                if (this.m_objectType == 6 || this.m_objectType == 7 || this.m_objectType == 8) break;
                this.m_animationPlayer.SetPos(this.m_x + this.ApplyDeph(cGame.s_cameraX, this.m_z), this.m_y + this.ApplyDeph(cGame.s_cameraY, this.m_z));
                this.m_animationPlayer.Render();
            }
        }
    }

    private int ApplyDeph(int cameraDisp, int objectDeep) {
        return -(cameraDisp * objectDeep) / 100;
    }

    int GetZOrder() {
        return (this.m_z << 20) + (cGame.Math_FixedPointToInt(this.m_y) << 10) + cGame.Math_FixedPointToInt(this.m_x);
    }

    public static cActor Create(int p_type, short[] p_param) {
        return cActor.Create(p_type, 1, p_param);
    }

    public static cActor Create(int p_type, int p_listID, short[] p_param) {
        cActor actor = new cActor();
        actor.Set(p_type, p_param);
        cActor.ActorLists_InsertInList(actor, p_listID);
        return actor;
    }

    public void DebugSceneObjectException(String errorMessage) {
        if (errorMessage != null) {
            // empty if block
        }
    }

    public void DebugSOCorrectDefinition(int n, int n2) {
        String string = null;
        if (n2 == 2 && n != 2) {
            string = " User rocker must use the sprite rocker / incorrect definition of object type";
        }
        if (n2 == 5 && n != 14) {
            string = " Opponent rocker must use the correct sprite / incorrect definition of object type";
        }
        if (string != null) {
            this.DebugSceneObjectException(string);
        }
    }
}

