/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.VolumeControl;

class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    private int curAnim;
    private int curFrame;
    public int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private int curBlend;
    private int curScale;
    private static int k_animBaseFrameTime = 1000 / 25;
    private static final int k_snd_nbChannel = 1;
    static int s_snd_masterVolume;
    static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static int[] s_snd_sndDuration;
    private static String[] s_snd_sndResourceURL;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static long[] s_snd_playTime;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static GLLibPlayer s_pSoundPlayerIns;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;

    GLLibPlayer() {
        this.Reset();
    }

    GLLibPlayer(ASprite aSprite, int n, int n2) {
        if (25 > 1000) {
            cGame.Assert(false, "GLLibPlayer : Invalid value of GLLibConfig.sprite_animFPS > 1000");
        }
        this.Reset();
        this.posX = n;
        this.posY = n2;
        this.SetSprite(aSprite);
    }

    void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = -1;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.animIsOver = true;
        if (false) {
            this.curScale = -1;
        }
        if (false) {
            this.curBlend = -1;
        }
    }

    void SetPos(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    ASprite GetSprite() {
        return this.sprite;
    }

    void SetSprite(ASprite aSprite) {
        this.sprite = aSprite;
        this.SetAnim(-1, -1);
    }

    void SetAnim(int n) {
        cGame.Warning("GLLibPlayer.SetAnim(int anim) . this function is deprecated, use GLLibPlayer.SetAnim(int anim, int nbLoop) instead");
        this.SetAnim(n, -1);
    }

    void SetAnim(int n, int n2, boolean bl) {
        if (bl) {
            this.SetAnim(-1, 1);
        }
        this.SetAnim(n, n2);
    }

    void SetAnim(int n, int n2) {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.SetAnim().sprite is not set");
        }
        if (n >= this.GetNbanim()) {
            cGame.Assert(false, "GLLibPlayer.SetAnim().anim out of range");
        }
        if (n2 == 0) {
            cGame.Assert(false, "GLLibPlayer.SetAnim().nbLoop is invalid");
        }
        if (this.animIsOver || n != this.curAnim) {
            this.curAnim = n;
            this.SetFrame(0);
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    int GetAnim() {
        return this.curAnim;
    }

    int SetFrame(int n) {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.SetFrame().sprite is not set");
        }
        if (n < 0) {
            cGame.Assert(false, "GLLibPlayer.SetFrame().frame is negative");
        }
        if (this.curAnim < 0) {
            return -1;
        }
        int n2 = this.GetNbFrame();
        while (n > n2) {
            n -= n2;
        }
        this.curFrame = n;
        this.curTime = 0;
        return n;
    }

    int GetFrame() {
        return this.curFrame;
    }

    int GetNbanim() {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.GetNbanim().sprite is not set");
        }
        return this.sprite._anims_naf.length;
    }

    int GetNbFrame() {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.GetNbFrame().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    int GetDuration() {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.GetDuration().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    boolean IsAnimOver() {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.isAnimOver().sprite is not set");
        }
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    void Render() {
        if (this.sprite == null) {
            cGame.Assert(false, "GLLibPlayer.render().sprite is not set");
        }
        if (this.curAnim < 0) {
            return;
        }
        if (false || false) {
            if (false && this.curScale != -1) {
                int n = 11;
                cGame.PFX_EnableEffect(n, false);
                cGame.PFX_SetParam(11, 1, this.curScale);
                if (false && this.curBlend != -1) {
                    cGame.PFX_SetParam(11, 2, this.curBlend);
                }
            } else if (false && this.curBlend != -1) {
                int n = 10;
                cGame.PFX_EnableEffect(n, false);
                cGame.PFX_SetParam(10, 1, this.curBlend);
            }
        }
        this.sprite.PaintAFrame(cGame.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
        if (false || false) {
            cGame.s_PFX_type &= 0xFFFFF21F;
        }
    }

    void Update(int n) {
        block18: {
            int n2;
            block17: {
                if (n < 0) {
                    cGame.Assert(false, "GLLibPlayer.Update.DT is negative");
                }
                if (25 == 1000) {
                    if (n > 1) {
                        cGame.Warning("GLLibPlayer.Update was called with DT larger than 1, the player is currently working as Frame Based Player");
                    }
                } else if (n == 1) {
                    cGame.Warning("GLLibPlayer.Update was called with DT equal 1, the player is currently working as a Time Based Player, it should be more than 1 ms ?");
                }
                if (this.animIsOver || this.curAnim < 0) {
                    return;
                }
                n2 = this.GetDuration();
                if (n2 == 0) {
                    cGame.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                }
                if (!true) break block17;
                if (this.curTime < n2) break block18;
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else if (this.nbLoop == 0) {
                    this.animIsOver = true;
                } else {
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                n2 = this.GetDuration();
                if (n2 != 0) break block18;
                cGame.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                break block18;
            }
            while (this.curTime >= n2) {
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else {
                    if (this.nbLoop == 0) {
                        this.animIsOver = true;
                        break;
                    }
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                if ((n2 = this.GetDuration()) != 0) continue;
                cGame.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
            }
        }
        this.curTime += n;
    }

    private static int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static final int SndQueue_GetData(int n, int n2) {
        return s_snd_queue[GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]) + n2];
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (s_snd_queue_size[n] >= 7) {
            cGame.Assert(false, "SndQueue_Push: Too many sound requests given before Snd_Update!");
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        int n10 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n10 - i - 1);
            if (s_snd_queue[(n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)) + 0] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7 + 0] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n10);
        GLLibPlayer.s_snd_queue[n7 + 0] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n11 = n;
        s_snd_queue_size[n11] = s_snd_queue_size[n11] + 1;
    }

    private static final void SndQueue_Push(int n, int n2) {
        GLLibPlayer.SndQueue_Push(n, n2, -1, -1, -1, -1);
    }

    private static void SndQueue_Pop(int n) {
        GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
        int n2 = n;
        s_snd_queue_size[n2] = s_snd_queue_size[n2] - 1;
    }

    static void Snd_Init(int n) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_Init");
        }
        if (k_snd_nbChannel > 1) {
            if (false) {
                cGame.Dbg("    WARNING nb of sound channel is set to more than one");
            }
            if (false) {
                cGame.Dbg("    - this is your responsability to make sure that phone with lower");
            }
            if (false) {
                cGame.Dbg("     nb of sound channel will play the important sound (BGM, SFX...)");
            }
        }
        cGame.Dbg("Snd_Init : JSR135");
        if (false) {
            cGame.Dbg("microedition.media.version is :" + System.getProperty("microedition.media.version"));
        }
        if (false) {
            cGame.Dbg("phone support mixing : " + System.getProperty("supports.mixing"));
        }
        if (System.getProperty("supports.mixing").equals("true")) {
            if (false) {
                cGame.Dbg("    WARNING this phone support mixing, that ONLY means: ");
            }
            if (false) {
                cGame.Dbg("    - Manager.playTone can play 2 tones simultaneously");
            }
            if (false) {
                cGame.Dbg("    - Manager.playTone and one Player can be used at the same time");
            }
            if (false) {
                cGame.Dbg("    - At least 2 Players can playback audio simultaneously");
            }
        }
        s_snd_Player = new Player[k_snd_nbChannel];
        if (true) {
            s_snd_PlayerSlot = new Player[n];
        }
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.s_snd_index[i] = -1;
            GLLibPlayer.s_snd_queue_pointer[i] = 0;
            GLLibPlayer.s_snd_queue_size[i] = 0;
        }
        s_snd_maxNbSoundSlot = n;
        s_snd_sndSlot = new byte[s_snd_maxNbSoundSlot][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        if (false) {
            s_snd_sndResourceURL = new String[s_snd_maxNbSoundSlot];
        }
        if (false) {
            s_snd_sndDuration = new int[s_snd_maxNbSoundSlot];
            s_snd_playTime = new long[k_snd_nbChannel];
        }
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
        if (true) {
            s_pSoundPlayerIns = new GLLibPlayer();
            s_pThread = new Thread(s_pSoundPlayerIns);
            s_pThread.start();
        }
    }

    static void Snd_LoadSound(String string, int n, boolean bl) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n >= s_snd_sndSlot.length) {
            cGame.Assert(false, "resourceIndex is larger that slot count. Read the Warning in the doc.");
        }
        if (false) {
            cGame.Dbg("Snd_LoadSound : " + n);
        }
        if (n < 0) {
            return;
        }
        if (s_snd_sndSlot == null) {
            cGame.Assert(false, "Snd_LoadSound.snd not correctly initialized");
        }
        cGame.Pack_Open(string);
        byte[] byArray = cGame.Pack_ReadData(n);
        GLLibPlayer.Snd_LoadSound(byArray, cGame.s_pack_lastDataReadMimeType, n, bl);
    }

    static void Snd_LoadSound(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (!true && bl) {
            cGame.Assert(false, "Snd_LoadSound: Trying to cache sound but sound_useCachedPlayers is FALSE!");
        }
        if (n2 >= s_snd_sndSlot.length) {
            cGame.Assert(false, "index is larger that slot count. Read the Warning in the doc.");
        }
        if (false) {
            cGame.Dbg("Snd_LoadSound for slot : " + n2);
        }
        GLLibPlayer.s_snd_sndSlot[n2] = byArray;
        GLLibPlayer.s_snd_sndType[n2] = n;
        if (false) {
            cGame.Dbg("Snd_LoadSound has mime : " + cGame.GetMIME(s_snd_sndType[n2]));
        }
        if (true && bl) {
            if (false) {
                cGame.Dbg("    create player (" + cGame.GetMIME(s_snd_sndType[n2]) + ")");
            }
            GLLibPlayer.s_snd_PlayerSlot[n2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)cGame.GetMIME(s_snd_sndType[n2]));
            if (false) {
                if (false) {
                    cGame.Dbg("    realize player");
                }
                s_snd_PlayerSlot[n2].realize();
                if (false) {
                    if (false) {
                        cGame.Dbg("    prefetch player");
                    }
                    s_snd_PlayerSlot[n2].prefetch();
                }
            }
            GLLibPlayer.s_snd_sndSlot[n2] = null;
        }
    }

    static boolean Snd_IsLoaded(int n) {
        if (s_snd_sndSlot != null && n < s_snd_sndSlot.length && s_snd_sndSlot[n] != null) {
            return true;
        }
        return s_snd_PlayerSlot != null && n < s_snd_PlayerSlot.length && s_snd_PlayerSlot[n] != null;
    }

    static void Snd_UnLoadSound(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_UnLoadSound : unloading sound at slot " + n);
        }
        if (s_snd_sndSlot == null) {
            cGame.Assert(false, "Snd_UnLoadSound : array is not initialised");
        }
        if (n < 0) {
            return;
        }
        GLLibPlayer.s_snd_sndSlot[n] = null;
        if (false) {
            GLLibPlayer.s_snd_sndResourceURL[n] = null;
        }
        if (true) {
            if (s_snd_PlayerSlot != null && s_snd_PlayerSlot[n] != null) {
                s_snd_PlayerSlot[n].close();
            }
            GLLibPlayer.s_snd_PlayerSlot[n] = null;
            for (int i = 0; i < k_snd_nbChannel; ++i) {
                if (n != GLLibPlayer.Snd_GetCurrentSoundIndex(i)) continue;
                GLLibPlayer.s_snd_state[i] = 0;
                GLLibPlayer.s_snd_Player[i] = null;
            }
        }
        if (true) {
            System.gc();
        }
    }

    static final void Snd_FreeChannel(int n) {
        if (!true) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_FreeChannel " + n);
        }
        GLLibPlayer.SndQueue_Push(n, 2, -1, -1, -1, -1);
    }

    static void Snd_PrepareSound(int n, int n2, int n3) {
        if (!true) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_PrepareSound " + n2);
        }
        if (n2 < 0) {
            if (false) {
                cGame.Dbg("    dummy sound skiping");
            }
            return;
        }
        GLLibPlayer.SndQueue_Push(n, 1, n2, n3, -1, -1);
    }

    static void Snd_Play(int n, int n2, int n3, int n4, int n5) {
        if (true) {
            if (false) {
                cGame.Dbg("Snd_Play: Channel[" + n + "], ID[" + n2 + "], Loop[" + n3 + "], Volume[" + n4 + "] and Priority[" + n5 + "]");
            }
            if (n3 < 0) {
                cGame.Assert(false, "Snd_Play: Invalid loop number of " + n3);
            }
            if (n >= k_snd_nbChannel) {
                cGame.Assert(false, "Snd_Play: Attempting to play on channel " + n + " while only have max " + k_snd_nbChannel);
            }
            if (n2 < 0 || n4 == 0) {
                if (false) {
                    cGame.Dbg("    dummy sound skiping");
                }
                return;
            }
            GLLibPlayer.SndQueue_Push(n, 3, n2, n5, n4, n3);
        }
    }

    static final void Snd_Stop(int n) {
        if (!true) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_stop");
        }
        GLLibPlayer.SndQueue_Push(n, 4);
    }

    private static void Snd_PrepareExec(int n) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_PrepareExec");
        }
        int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
        int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        GLLibPlayer.Snd_FreeChannelExec(n);
        if (false) {
            cGame.Dbg("prepareexec : channel : " + n);
        }
        if (false) {
            cGame.Dbg("prepareexec : index   : " + n2);
        }
        if (true) {
            GLLibPlayer.s_snd_Player[n] = s_snd_PlayerSlot[n2];
        }
        if (false && s_snd_Player[n] == null && s_snd_sndResourceURL[n2] != null) {
            cGame.Dbg("    create player from URL:" + s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = true;
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((String)s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = false;
        }
        if (s_snd_Player[n] == null) {
            if (false) {
                cGame.Dbg("    create player (" + cGame.GetMIME(s_snd_sndType[n2]) + ")");
            }
            if (s_snd_sndSlot[n2] == null) {
                cGame.Dbg("    create player: player is null and raw data is null too... reload!!");
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)cGame.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            cGame.Dbg("    ERROR.player is null 1266");
            return;
        }
        if (!false) {
            if (false) {
                cGame.Dbg("    realize player");
            }
            s_snd_Player[n].realize();
        }
        if (!false) {
            if (false) {
                cGame.Dbg("    prefetch player");
            }
            s_snd_Player[n].prefetch();
        }
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
    }

    private static void Snd_PlayExec(int n) throws Exception {
        if (!true || cGame.s_game_isPaused) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_PlayExec for channel : " + n);
        }
        GLLibPlayer.Snd_PrepareExec(n);
        if (cGame.s_game_isPaused) {
            return;
        }
        if (s_snd_state[n] != 1 || s_snd_Player[n] == null) {
            if (false) {
                cGame.Dbg("Snd_playExec : Cant play, state not ready or player is null");
            }
            return;
        }
        int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
        int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
        int n4 = GLLibPlayer.SndQueue_GetData(n, 4);
        int n5 = GLLibPlayer.SndQueue_GetData(n, 3);
        if (false) {
            cGame.Dbg("    set loop count");
        }
        if (n4 == 0) {
            s_snd_Player[n].setLoopCount(-1);
        } else {
            s_snd_Player[n].setLoopCount(n4);
        }
        if (false) {
            if (false) {
                cGame.Dbg("    set volume");
            }
            ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n5 * s_snd_masterVolume * 100 / 10000);
        }
        if (false) {
            cGame.Dbg("    start player");
        }
        if (true) {
            s_snd_Player[n].setMediaTime(0L);
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
        GLLibPlayer.s_snd_volume[n] = n5;
        GLLibPlayer.s_snd_loop[n] = n4;
        GLLibPlayer.s_snd_priority[n] = n3;
        GLLibPlayer.s_snd_index[n] = n2;
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = System.currentTimeMillis();
        }
    }

    private static void Snd_StopExec(int n) throws Exception {
        if (false) {
            cGame.Dbg("Snd_stopExec");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 1;
        if (false) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = 0L;
        }
    }

    private static void Snd_PauseExec(int n) throws Exception {
        if (false) {
            cGame.Dbg("Snd_PauseExec");
        }
        if (s_snd_state[n] != 2) {
            return;
        }
        if (s_snd_Player[n] == null) {
            cGame.Assert(false, "Snd_pauseExec.player is null 1638");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        if (s_snd_Player[n].getState() != 400) {
            cGame.Assert(false, "Snd_pauseExec.player wasn't playing");
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 3;
    }

    private static void Snd_ResumeExec(int n) throws Exception {
        if (false) {
            cGame.Dbg("Snd_ResumeExec");
        }
        if (s_snd_state[n] != 3) {
            return;
        }
        if (s_snd_Player[n] == null) {
            cGame.Assert(false, "Snd_resumeExec.player is null 1681");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
    }

    static void Snd_Update() {
        if (true) {
            if (s_pThread != null && !s_pThread.isAlive()) {
                s_pThread.start();
            }
        } else {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    private static void Snd_Update_Exec() {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            int n;
            if (s_snd_queue_size[i] > 0 && s_snd_state[i] == 2) {
                try {
                    n = GLLibPlayer.Snd_IsPlaying(i);
                }
                catch (Exception exception) {
                    cGame.Dbg("Snd_update.error on channel (" + i + ")." + exception);
                    n = 0;
                }
                if (n == 0) {
                    GLLibPlayer.s_snd_state[i] = 1;
                }
            }
            while (s_snd_queue_size[i] > 0) {
                try {
                    if (false) {
                        cGame.Dbg("Snd_update");
                    }
                    n = GLLibPlayer.SndQueue_GetData(i, 0);
                    switch (n) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(i);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(i);
                            break;
                        }
                        case 3: {
                            GLLibPlayer.Snd_PlayExec(i);
                            break;
                        }
                        case 4: {
                            GLLibPlayer.Snd_StopExec(i);
                            break;
                        }
                        case 5: {
                            GLLibPlayer.Snd_PauseExec(i);
                            break;
                        }
                        case 6: {
                            GLLibPlayer.Snd_ResumeExec(i);
                        }
                    }
                }
                catch (Exception exception) {
                    cGame.Dbg("Snd_update.error on channel (" + i + ")." + exception);
                    exception.printStackTrace();
                }
                GLLibPlayer.SndQueue_Pop(i);
            }
        }
    }

    public void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                Thread.sleep(1000 / 15);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (s_snd_Player[n] == null) {
            return false;
        }
        if (false) {
            int n2 = GLLibPlayer.Snd_GetCurrentSoundIndex(n);
            if (n2 < 0) {
                return false;
            }
            if (s_snd_loop[n] != 0 && System.currentTimeMillis() - s_snd_playTime[n] > (long)(s_snd_sndDuration[n2] * s_snd_loop[n])) {
                return false;
            }
        } else if (s_snd_Player[n].getState() != 400) {
            return false;
        }
        return true;
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            cGame.Dbg("Snd_FreeChannelExec = " + n);
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            if (!false) {
                s_snd_Player[n].deallocate();
            }
            if (!true) {
                s_snd_Player[n].close();
            } else {
                int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
                if (n2 < 0 || s_snd_PlayerSlot[n2] == null) {
                    s_snd_Player[n].close();
                }
            }
            GLLibPlayer.s_snd_Player[n] = null;
            if (true) {
                System.gc();
            }
        }
        GLLibPlayer.s_snd_state[n] = 0;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        if (!true) {
            GLLibPlayer.Snd_Update();
        } else if (cGame.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static int Snd_GetCurrentSoundIndex(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[n];
        }
        return -1;
    }

    static boolean Snd_MidiSetChannelVolume(int n, int n2, int n3) throws Exception {
        MIDIControl mIDIControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (true && (mIDIControl = (MIDIControl)s_snd_Player[n].getControl("MIDIControl")) != null) {
            mIDIControl.shortMidiEvent(0xB0 | n2, 7, n3);
            return true;
        }
        return false;
    }

    static void Snd_PauseNotify() {
        if (!(!true || s_snd_IgnoreSoundsOnInterrupt && false)) {
            try {
                GLLibPlayer.Snd_StopAllSounds();
                if (true && cGame.s_game_isPaused) {
                    GLLibPlayer.Snd_Update_Exec();
                }
            }
            catch (Exception exception) {
                cGame.Dbg("Snd_PauseNotify: exception!");
            }
        }
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = 4;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

