/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Set;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer
implements PlayerListener {
    public static final int IMMENSITY = -1;
    public static final int UNREALIZED = 1;
    public static final int REALIZED = 2;
    public static final int PREFETCHED = 3;
    public static final int STARTED = 4;
    public static final int CLOSED = 5;
    Player MusicPlayer;
    VolumeControl control;
    boolean notActive;
    public int playCount;

    public void load(String fileName) {
        try {
            InputStream inputstream = this.getClass().getResourceAsStream(fileName);
            if (inputstream == null) {
                System.out.println("Error happens: InputStream not found " + fileName);
            }
            if (this.MusicPlayer == null) {
                this.MusicPlayer = Set.midMusic ? Manager.createPlayer((InputStream)inputstream, (String)"audio/midi") : Manager.createPlayer((InputStream)inputstream, (String)"audio/mpeg");
            } else {
                this.MusicPlayer.stop();
                this.MusicPlayer.close();
                this.MusicPlayer = null;
                this.MusicPlayer = Set.midMusic ? Manager.createPlayer((InputStream)inputstream, (String)"audio/midi") : Manager.createPlayer((InputStream)inputstream, (String)"audio/mpeg");
            }
            if (this.MusicPlayer == null) {
                System.out.println("Error handler happens: InputStream " + fileName);
            } else {
                this.MusicPlayer.addPlayerListener((PlayerListener)this);
                this.MusicPlayer.realize();
                this.MusicPlayer.prefetch();
                System.out.println("Realized Player: " + fileName);
            }
            this.control = (VolumeControl)this.MusicPlayer.getControl("VolumeControl");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (MediaException e) {
            e.printStackTrace();
            System.out.println((Object)e);
        }
    }

    public void setLevel(int level) {
        if (this.control != null) {
            this.control.setLevel(level);
        }
    }

    public void destroyAt() {
        if (this.MusicPlayer != null) {
            this.MusicPlayer.close();
            this.MusicPlayer = null;
        }
    }

    public void destroyAll() {
        if (this.MusicPlayer != null) {
            this.MusicPlayer.close();
            this.MusicPlayer = null;
        }
    }

    public void play(final int times, final int level) {
        if (this.MusicPlayer != null) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        if (MusicPlayer.this.getPlayState() == 4) {
                            MusicPlayer.this.MusicPlayer.stop();
                        }
                        MusicPlayer.this.MusicPlayer.setLoopCount(times);
                        MusicPlayer.this.setLevel(level);
                        MusicPlayer.this.MusicPlayer.start();
                    }
                    catch (MediaException e) {
                        e.printStackTrace();
                    }
                }
            });
            t.start();
        }
    }

    public void setPlayCount(int s) {
        this.playCount = s;
    }

    public void noRunPlay(int level, int count) {
        try {
            if (this.MusicPlayer != null) {
                if (this.MusicPlayer.getState() != 400) {
                    ++this.playCount;
                }
                if (this.playCount > count) {
                    this.setLevel(level);
                    this.MusicPlayer.start();
                    this.playCount = 0;
                }
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public int getPlayState() {
        switch (this.MusicPlayer.getState()) {
            case 100: {
                return 1;
            }
            case 200: {
                return 2;
            }
            case 300: {
                return 3;
            }
            case 400: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }

    public void stop() {
        if (this.MusicPlayer != null && this.MusicPlayer.getState() == 400) {
            try {
                this.MusicPlayer.stop();
                System.out.println("The Player stoped here:" + this.MusicPlayer.getMediaTime() + "State " + this.MusicPlayer.getState());
            }
            catch (MediaException e) {
                e.printStackTrace();
                System.out.println((Object)e);
            }
        }
    }

    public void playerUpdate(Player musicplayer, String event, Object eventData) {
    }
}

