/*
 * Decompiled with CFR 0.152.
 */
class LeaderboardCanvas
extends ZoneClass {
    public static final String RANK_SVR_IP = "usadev.gamevil.net";
    public static final int RANK_SVR_PORT = 11014;
    public static final int GID = 18;
    public static final byte LEADERBOARD_TOP_NUM = 50;
    public static final byte MAX_NUM_PER_PAGE = 5;
    GVRanking ranking;
    GVL2_XTextField_Eng textFieldName;
    long chkTime;
    int leaderboardState;
    int userRank;
    private int textY;
    private int errorCode;
    private byte canUseName;
    public static final byte LST_INIT = 0;
    public static final byte LST_NAME = 1;
    public static final byte LST_NAME_CHECK = 2;
    public static final byte LST_LEADERBOARD = 16;
    public static final byte LST_ERROR = 32;
    private byte netState;
    public static final byte NET_INI = 16;
    public static final byte NET_WAIT = 17;
    public static final byte NET_SEND = 18;
    public static final byte NET_RESULT = 19;
    private static int[][] leaderboard_rank;
    private static String[][] leaderboard_name;
    private static long[][] leaderboard_score;
    public static int leaderboard_page;
    public static int topRankPage;
    public static boolean isTopRankLastPage;
    public static final byte ERROR_NONE = 0;
    public static final byte ERROR_RANK_DENY_CONNECT = 1;
    public static final byte ERROR_RANK_CONNECT = 2;
    public static final byte ERROR_POST = 3;
    public static final byte ERROR_READ_TOP = 4;
    public static final byte ERROR_READ_MYRANK = 5;
    public static final byte ERROR_READ_NEAR_RANK = 6;
    public static final byte ERROR_EXIST_NAME = 7;
    private boolean reflashReady = false;
    public static int flag;

    public LeaderboardCanvas(ObsClass pClass) {
        super(pClass);
    }

    public void stClass() {
        this.chkTime = System.currentTimeMillis();
        this.ranking = new GVRanking();
        this.clearBlack();
        this.textFieldName = new GVL2_XTextField_Eng("", 12, 12);
        leaderboard_rank = new int[2][50];
        leaderboard_name = new String[2][50];
        leaderboard_score = new long[2][50];
        this.netState = (byte)16;
        this.errorCode = 0;
        this.textY = this.cY - 46;
        topRankPage = 0;
        this.goto_init();
    }

    public void goto_init() {
        this.leaderboardState = 0;
        leaderboard_page = 0;
        if (ObsClass.nameCheck == 1) {
            this.goto_leaderboard();
        } else {
            this.goto_name();
        }
    }

    public void callCheck() {
        if (this.netState != 19) {
            this.ranking.closeRanking();
            this.goto_error((byte)1);
        }
    }

    public void goto_name() {
        this.leaderboardState = 1;
    }

    public void goto_name_check() {
        this.netState = (byte)17;
        this.leaderboardState = 2;
    }

    public void goto_leaderboard() {
        this.netState = (byte)17;
        this.leaderboardState = 16;
    }

    public void goto_error(byte nError) {
        this.errorCode = nError;
        this.leaderboardState = 32;
    }

    public void draw() {
        this.drawBackground();
        this.drawPopup(true);
        ObsClass.ifont.setColor(255, 255, 255);
        ObsClass.ifont.drawScriptAlign(ObsClass.scr.getStr(32), this.cX - 29, this.textY - 27, 120, 10, 17);
        switch (this.leaderboardState) {
            case 1: {
                this.draw_name();
                break;
            }
            case 2: {
                this.draw_name_check();
                break;
            }
            case 16: {
                this.draw_leaderboard();
                break;
            }
            case 32: {
                ObsClass.ifont.setColor(0, 0, 0);
                if (this.errorCode == 1) {
                    this.drawStringC(ObsClass.scr.getStr(303) + " |Error Code:" + this.errorCode, this.cX, this.cY - 18, 120);
                } else {
                    this.drawStringC(ObsClass.scr.getStr(291) + " |Error Code:" + this.errorCode, this.cX, this.cY - 8, 120);
                }
                this.drawBtn_bg();
                this.drawBtn_ok();
                break;
            }
            default: {
                this.drawWaiting();
            }
        }
        this.reflashReady = true;
    }

    public void draw_name() {
        this.setColor(0, 0, 0);
        this.drawStringC(ObsClass.scr.getStr(288), this.cX, this.textY, 120);
        String tmpName = this.textFieldName.getString().substring(0, this.textFieldName.getCursor());
        int tmpCursorX = this.cX - ObsClass.ifont.getStrWidth(this.textFieldName.getString()) / 2 + ObsClass.ifont.getStrWidth(tmpName) + 1;
        if (this.thCnt % 4 < 2) {
            this.bg.setColor(0, 0, 0);
            this.bg.drawLine(tmpCursorX, this.textY + 53, tmpCursorX + 5, this.textY + 53);
        }
        this.drawStringL(this.textFieldName.getString(), this.cX - ObsClass.ifont.getStrWidth(this.textFieldName.getString()) / 2, this.textY + 45, 120);
        this.bg.setColor(128, 128, 128);
        this.bg.drawLine(this.cX - 50, this.textY + 55, this.cX + 50, this.textY + 55);
        this.drawStringC(ObsClass.scr.getStr(289), this.cX, this.textY + 57, 120);
        this.drawBtn_bg();
        if (this.textFieldName.getLength() >= 4) {
            this.drawBtn_ok();
        }
        this.drawBtn_cancel();
    }

    public void draw_name_check() {
        switch (this.netState) {
            case 17: {
                this.drawWaiting();
                this.drawBtn_bg();
                this.drawBtn_cancel();
                break;
            }
            case 18: {
                this.drawWaiting();
                this.drawBtn_bg();
                this.drawBtn_cancel();
                break;
            }
            case 19: {
                if (this.canUseName == 0) {
                    this.drawBtn_bg();
                    this.drawBtn_cancel();
                    break;
                }
                ObsClass.ifont.setColor(0, 0, 0);
                this.drawStringC(ObsClass.scr.getStr(309), this.cX, this.cY - 8, 120);
                this.drawBtn_bg();
                this.drawBtn_ok();
            }
        }
    }

    public void draw_leaderboard() {
        switch (this.netState) {
            case 17: {
                this.drawWaiting();
                break;
            }
            case 18: {
                ObsClass.ifont.setColor(0, 0, 0);
                this.drawStringC(ObsClass.scr.getStr(290), this.cX, this.cY + 3, 120);
                this.drawBtn_bg();
                this.drawBtn_cancel();
                break;
            }
            case 19: {
                int start;
                int i;
                this.setColor(255, 255, 255);
                this.drawStringC(leaderboard_page + 1 + "/2", this.cX + 43, this.cY - 68, 120);
                if (leaderboard_page != 0 && this.thCnt % 4 != 0) {
                    this.drawImagePzx(this.pClass.sprite_popup, 12, this.cX + 35 - 12, this.cY - 68, 0);
                }
                if (leaderboard_page != 1 && this.thCnt % 4 != 0) {
                    this.drawImagePzx(this.pClass.sprite_popup, 13, this.cX + 73 - 12, this.cY - 68, 0);
                }
                ObsClass.ifont.setColor(0, 0, 0);
                if (leaderboard_page == 0) {
                    this.drawStringC(ObsClass.scr.getStr(292) + this.userRank, this.cX, this.cY - 51, 120);
                    if (ObsClass.maxIQ >= 0) {
                        this.drawStringC(ObsClass.scr.getStr(293) + ObsClass.maxIQ, this.cX, this.cY - 41, 120);
                    } else {
                        this.drawStringC(ObsClass.scr.getStr(293) + "0", this.cX, this.cY - 41, 120);
                    }
                } else if (leaderboard_page == 1) {
                    this.drawStringC(ObsClass.scr.getStr(294), this.cX, this.cY - 44, 120);
                }
                this.bg.setColor(0, 0, 0);
                this.bg.drawLine(this.cX - 64, this.cY - 29, this.cX + 63, this.cY - 29);
                this.bg.setColor(128, 128, 128);
                for (int i2 = 0; i2 < 4; ++i2) {
                    for (int k = 0; k < 26; ++k) {
                        this.bg.drawLine(this.cX - 64 + k * 5, this.cY - 25 + 16 + 18 * i2, this.cX - 61 + k * 5, this.cY - 25 + 16 + 18 * i2);
                    }
                }
                isTopRankLastPage = false;
                int tmpCnt = 0;
                for (i = start = topRankPage * 5; i < start + 5; ++i) {
                    if (leaderboard_rank[leaderboard_page][i] != 0) {
                        ++tmpCnt;
                        if (this.userRank == leaderboard_rank[leaderboard_page][i]) {
                            ObsClass.ifont.setColor(255, 0, 0);
                        } else {
                            ObsClass.ifont.setColor(0, 0, 0);
                        }
                        this.drawStringL("" + leaderboard_rank[leaderboard_page][i], this.cX - 60, this.cY - 25 + 18 * (i - start), 120);
                        this.drawStringR(leaderboard_name[leaderboard_page][i], this.cX + 59, this.cY - 25 + 18 * (i - start), 120);
                        if (leaderboard_score[leaderboard_page][i] < 0L) {
                            this.drawStringR("0", this.cX + 59, this.cY - 17 + 18 * (i - start), 120);
                            continue;
                        }
                        this.drawStringR("" + leaderboard_score[leaderboard_page][i], this.cX + 59, this.cY - 17 + 18 * (i - start), 120);
                        continue;
                    }
                    isTopRankLastPage = true;
                    break;
                }
                if (i >= 50) {
                    isTopRankLastPage = true;
                } else if (!isTopRankLastPage && tmpCnt == 5 && leaderboard_rank[leaderboard_page][i] == 0) {
                    isTopRankLastPage = true;
                }
                if (leaderboard_page == 0 && this.thCnt % 4 != 0) {
                    if (topRankPage > 0) {
                        this.drawImagePzx(this.pClass.sprite_popup, 15, this.cX, this.cY - 32, 0);
                    }
                    if (!isTopRankLastPage) {
                        this.drawImagePzx(this.pClass.sprite_popup, 16, this.cX, this.cY + 66, 0);
                    }
                }
                this.drawBtn_bg();
                this.drawBtn_cancel();
                break;
            }
            default: {
                this.drawWaiting();
            }
        }
    }

    private void drawWaiting() {
        ObsClass.ifont.setColor(0, 0, 0);
        this.drawStringC(ObsClass.scr.getStr(290), this.cX, this.cY + 3 * (this.thCnt % 2), 120);
        this.drawBtn_bg();
        this.drawBtn_cancel();
    }

    private void getExistName() {
        this.canUseName = 0;
        String VERSION = "" + ObsClass.pClass.getAppProperty("MIDlet-Version");
        int isConnect = 0;
        isConnect = this.ranking.connectRanking(this.textFieldName.getString(), 18, VERSION, RANK_SVR_IP, 11014);
        if (isConnect == 2) {
            this.ranking.closeRanking();
            this.goto_error((byte)1);
            return;
        }
        if (isConnect != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)2);
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.ranking.setPutFieldValue(i, 0L);
        }
        this.ranking.sendExistPhoneNumber((byte)1, this.textFieldName.getString());
        if (this.ranking.getAck() != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)7);
            return;
        }
        this.canUseName = this.ranking.getExistPhoneNumber();
    }

    private void getNetLeaderboard() {
        int i;
        String VERSION = "" + ObsClass.pClass.getAppProperty("MIDlet-Version");
        int isConnect = 0;
        System.out.println("Leaderboard getNetleaderboard Step 3 ");
        isConnect = this.ranking.connectRanking(ObsClass.userName, 18, VERSION, RANK_SVR_IP, 11014);
        System.out.println("Leaderboard getNetleaderboard Step 4 ");
        if (isConnect == 2) {
            this.ranking.closeRanking();
            this.goto_error((byte)1);
            return;
        }
        if (isConnect != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)2);
            return;
        }
        if (ObsClass.maxIQ < 0) {
            this.ranking.setPutFieldValue(0, 0L);
        } else {
            this.ranking.setPutFieldValue(0, ObsClass.maxIQ);
        }
        this.ranking.setPutFieldValue(3, 0L);
        this.ranking.sendPutRanking("NONE", 0, 1);
        if (this.ranking.getAck() != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)3);
            return;
        }
        this.ranking.setReqFieldIndex(0).setReqFieldSortType(0, 0).sendReqRanking(0, 1, 1, 50);
        if (this.ranking.getAck() != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)4);
            return;
        }
        for (int i2 = 0; i2 < 50; ++i2) {
            LeaderboardCanvas.leaderboard_rank[0][i2] = 0;
        }
        int total = this.ranking.getListCount();
        if (total > 10) {
            total = 10;
        }
        for (int i3 = 0; i3 < total; ++i3) {
            LeaderboardCanvas.leaderboard_rank[0][i3] = this.ranking.getUserRanking(i3);
            LeaderboardCanvas.leaderboard_name[0][i3] = this.ranking.getUserNickname(i3);
            LeaderboardCanvas.leaderboard_score[0][i3] = this.ranking.getUserFieldValue(i3, 0);
        }
        this.userRank = this.ranking.getMyRanking();
        if (this.userRank == 0) {
            this.ranking.closeRanking();
            this.goto_error((byte)5);
            return;
        }
        this.ranking.setReqFieldIndex(0).setReqFieldSortType(0, 0).sendReqRanking(-1, 1, 1, 5);
        if (this.ranking.getAck() != 1) {
            this.ranking.closeRanking();
            this.goto_error((byte)6);
            return;
        }
        int startRank = this.userRank - 2;
        if (startRank < 1) {
            startRank = 1;
        }
        for (i = 0; i < 50; ++i) {
            LeaderboardCanvas.leaderboard_rank[1][i] = 0;
        }
        for (i = 0; i < this.ranking.getListCount(); ++i) {
            LeaderboardCanvas.leaderboard_rank[1][i] = this.ranking.getUserRanking(i);
            LeaderboardCanvas.leaderboard_name[1][i] = this.ranking.getUserNickname(i);
            LeaderboardCanvas.leaderboard_score[1][i] = this.ranking.getUserFieldValue(i, 0);
        }
    }

    public void clearM() {
        this.pClass.stopSound();
        MenuCanvas.delSound = true;
        this.thChk = false;
    }

    public void keyPressed(int keyCode) {
        if (!this.thChk) {
            return;
        }
        if (!this.reflashReady) {
            return;
        }
        switch (this.leaderboardState) {
            case 1: {
                if (this.textFieldName.getLength() >= 4 && (keyCode == -6 || keyCode == -5)) {
                    this.goto_name_check();
                    break;
                }
                if (this.textFieldName.getLength() == 0 && (keyCode == -7 || keyCode == -8)) {
                    this.out();
                    break;
                }
                this.textFieldName.keyPressed(keyCode);
                break;
            }
            case 2: {
                if (this.netState == 17 || this.netState == 18) {
                    if (keyCode != -7 && keyCode != -8) break;
                    this.out();
                    break;
                }
                if (this.netState != 19) break;
                if (this.canUseName == 0) {
                    if (keyCode != -7 && keyCode != -8) break;
                    this.out();
                    break;
                }
                if (keyCode != -6 && keyCode != -5) break;
                this.goto_name();
                break;
            }
            case 16: {
                if (keyCode == -7 || keyCode == -8) {
                    this.out();
                    break;
                }
                if (this.netState != 19) break;
                if (keyCode == -4 && leaderboard_page == 0) {
                    leaderboard_page = 1;
                    topRankPage = 0;
                } else if (keyCode == -3 && leaderboard_page == 1) {
                    leaderboard_page = 0;
                    topRankPage = 0;
                }
                if (leaderboard_page != 0) break;
                if (keyCode == -1) {
                    if (topRankPage <= 0) break;
                    --topRankPage;
                    break;
                }
                if (keyCode != -2 || topRankPage != 0 || isTopRankLastPage) break;
                ++topRankPage;
                break;
            }
            case 32: {
                if (keyCode != -6 && keyCode != -5) break;
                this.out();
            }
        }
    }

    public void out() {
        this.clearM();
        this.ranking.closeRanking();
        this.pClass.changeZone((byte)2);
    }

    public void proc() {
        switch (this.netState) {
            case 17: {
                this.netState = (byte)18;
                break;
            }
            case 18: {
                this.netState = (byte)19;
                if (ObsClass.nameCheck != 1) {
                    this.getExistName();
                    break;
                }
                this.getNetLeaderboard();
                break;
            }
            case 19: {
                if (ObsClass.nameCheck == 1 || this.canUseName != 0) break;
                ObsClass.userName = this.textFieldName.getString();
                ObsClass.nameCheck = 1;
                this.pClass.saveUserName(ObsClass.userName);
                this.goto_leaderboard();
            }
        }
    }

    static {
        flag = 0;
    }
}

