/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Drawer {
    public static final int TRANSPARENT = -1;
    public static final int WHITE = -2;
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 5;
    public static final int FONT_SPACE = 1;
    public static int FONT_OFFSET = 0;
    public static Graphics _g;
    static boolean flg_enFont;

    public static void setColor(Graphics g, int color) {
        switch (color) {
            case -1: {
                g.setColor(255, 255, 255);
                break;
            }
            case -2: {
                g.setColor(255, 255, 255);
                break;
            }
            default: {
                g.setColor(color);
            }
        }
    }

    public static void clearScreen(Graphics g, int width, int height) {
        int current = g.getColor();
        Drawer.setColor(g, -2);
        g.fillRect(0, 0, width, height);
        g.setColor(current);
    }

    public static void drawImage(Graphics g, int x, int y, Image image) {
        g.drawImage(image, x, y, 0);
    }

    public static void drawImage(Graphics g, int x, int y, Image image, int manipulation) {
        g.drawImage(image, x, y, 0);
    }

    public static void drawImage(Image image, int x, int y) {
        _g.drawImage(image, x, y, 0);
    }

    public static void drawImage(Graphics g, Image image, int x, int y, int anchor) {
        g.drawImage(image, x, y, anchor);
    }

    public static void setG(Graphics g) {
        _g = g;
    }

    public static void drawClipImage(Graphics g, Image image, int x, int y, int w, int h, int offsetX, int offsetY) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.setClip(x, y, w - GameCanvas.clipMod + 1, h - GameCanvas.clipMod + 1);
        g.drawImage(image, x - offsetX, y - offsetY, 0);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public static void drawClipImage(Image image, int x, int y, int w, int h, int offsetX, int offsetY) {
        Drawer.drawClipImage(image, x, y, w, h, offsetX, offsetY, 0);
    }

    public static void drawClipImage(Image img, int x, int y, int w, int h, int offsetX, int offsetY, int anchor) {
        Drawer.drawClipImage(_g, img, x, y, w, h, offsetX, offsetY, anchor);
    }

    public static void drawClipImage(Graphics _g, Image img, int x, int y, int w, int h, int offsetX, int offsetY, int anchor) {
        int clipX = _g.getClipX();
        int clipY = _g.getClipY();
        int clipW = _g.getClipWidth();
        int clipH = _g.getClipHeight();
        if (anchor != 20 && anchor != 0) {
            if (anchor == 17) {
                x -= w / 2;
            } else if (anchor == 24) {
                x -= w;
            } else if (anchor == 6) {
                y -= h / 2;
            } else if (anchor == 3) {
                x -= w / 2;
                y -= h / 2;
            } else if (anchor == 10) {
                x -= w;
                y -= h / 2;
            } else if (anchor == 36) {
                y -= h;
            } else if (anchor == 33) {
                x -= w / 2;
                y -= h;
            } else if (anchor == 40) {
                x -= w;
                y -= h;
            } else if (anchor == 3) {
                x -= w / 2;
                y -= h / 2;
            } else if (anchor == 24) {
                x -= w;
            } else if (anchor == 33) {
                x -= w / 2;
                y -= h;
            } else if (anchor != 20) {
                if (anchor == 40) {
                    x -= w;
                    y -= h;
                } else {
                    System.out.println(" error, no support anchor. drawClipImage===============");
                }
            }
        }
        _g.setClip(x, y, w - GameCanvas.clipMod + 1, h - GameCanvas.clipMod + 1);
        _g.drawImage(img, x - offsetX, y - offsetY, 0);
        _g.setClip(clipX, clipY, clipW, clipH);
    }

    public static void drawRegion(Image img, int x, int y, int offsetX, int offsetY, int w, int h, int transform, int anchor) {
        _g.drawRegion(img, offsetX, offsetY, w, h, transform, x, y, anchor);
    }

    public static void drawRegion(Graphics g, Image img, int x, int y, int offsetX, int offsetY, int w, int h, int transform, int anchor) {
        g.drawRegion(img, offsetX, offsetY, w, h, transform, x, y, anchor);
    }

    public static void drawStr(Graphics g, int x, int y, String s, Image fontImg) {
    }

    public static int matchFont(char ch) {
        int offset = 0;
        return offset;
    }

    public static int getCharWidth(char c) {
        int charWidth = 0;
        switch (c) {
            case 'I': {
                charWidth = 1;
                break;
            }
            case 'f': {
                charWidth = 3;
                break;
            }
            case 'i': {
                charWidth = 1;
                break;
            }
            case 'j': {
                charWidth = 3;
                break;
            }
            case 'k': {
                charWidth = 4;
                break;
            }
            case 'l': {
                charWidth = 1;
                break;
            }
            case 'r': {
                charWidth = 4;
                break;
            }
            case 't': {
                charWidth = 4;
                break;
            }
            case ' ': {
                charWidth = 3;
                break;
            }
            default: {
                charWidth = 5;
            }
        }
        return charWidth;
    }

    public static int StrWidth(String s) {
        try {
            int len = s.length();
            char[] charArr = new char[len];
            s.getChars(0, len, charArr, 0);
            int strFontLen = 0;
            for (int i = 0; i < len; ++i) {
                strFontLen += Drawer.getCharWidth(charArr[i]) + 1;
            }
            return strFontLen;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int StrHeight(String s) {
        return 9;
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int color) {
        int current = g.getColor();
        Drawer.setColor(g, color);
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(current);
    }

    public static void drawFillRect(Graphics g, int x, int y, int width, int height, int color) {
        int current = g.getColor();
        Drawer.setColor(g, color);
        g.fillRect(x, y, width, height);
        g.setColor(current);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int color) {
        int current = g.getColor();
        Drawer.setColor(g, color);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(current);
    }
}

