/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GVL2_ImageFont_Eng {
    private static final int MAX_IMAGE_SIZE = 1024;
    private static final int MAX_IMAGE_CNT = 10;
    public static final byte ALIGN_LEFT = 16;
    public static final byte ALIGN_CENTER = 17;
    public static final byte ALIGN_RIGHT = 18;
    private static Vector myVector;
    private static Graphics gx;
    private static byte charMaxWidth;
    private static byte fontHeight;
    private static byte fontSpace;
    private static byte[] imageByteData;
    private static int imageByteDataSize;
    private static Image fontImg;
    private static String lastString;
    private static int lastStringLine;
    private static Image[] colorImage;
    private static byte[][] colorValue;
    private static int colorCount;
    private static int pngPlatteStart;

    public GVL2_ImageFont_Eng(String imgName, byte nFontWidth, byte nFontHeight, byte nFontSpace) {
        myVector = new Vector();
        charMaxWidth = nFontWidth;
        fontHeight = nFontHeight;
        fontSpace = nFontSpace;
        colorImage = new Image[10];
        colorValue = new byte[10][3];
        colorCount = 0;
        pngPlatteStart = 0;
        this.loadImageByteData(imgName);
        lastString = "";
        this.setColor(0, 0, 0);
    }

    public void setGraphics(Graphics g) {
        gx = g;
    }

    public void setColor(int r, int g, int b) {
        int i;
        if (colorCount == 10) {
            fontImg = null;
            fontImg = colorImage[0];
            return;
        }
        for (i = 0; i < colorCount; ++i) {
            if (colorValue[i][0] != (byte)r || colorValue[i][1] != (byte)g || colorValue[i][2] != (byte)b) continue;
            fontImg = null;
            fontImg = colorImage[i];
            return;
        }
        if (pngPlatteStart == 0) {
            for (i = 0; i < 100; ++i) {
                if (imageByteData[i] != 80 || imageByteData[i + 1] != 76 || imageByteData[i + 2] != 84 || imageByteData[i + 3] != 69) continue;
                pngPlatteStart = i + 4;
                break;
            }
        }
        int iPalOffset = pngPlatteStart;
        GVL2_ImageFont_Eng.imageByteData[iPalOffset + 0] = (byte)r;
        GVL2_ImageFont_Eng.imageByteData[iPalOffset + 1] = (byte)g;
        GVL2_ImageFont_Eng.imageByteData[iPalOffset + 2] = (byte)b;
        if (r == 0 && g == 0 && b == 0) {
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 6] = 54;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 7] = -3;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 8] = 98;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 9] = -81;
        } else if (r == 255 && g == 255 && b == 255) {
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 6] = -58;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 7] = 88;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 8] = 8;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 9] = 30;
        } else if (r == 255 && g == 0 && b == 0) {
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 6] = -46;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 7] = 57;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 8] = -55;
            GVL2_ImageFont_Eng.imageByteData[iPalOffset + 9] = 99;
        }
        try {
            GVL2_ImageFont_Eng.colorImage[GVL2_ImageFont_Eng.colorCount] = null;
            GVL2_ImageFont_Eng.colorImage[GVL2_ImageFont_Eng.colorCount] = Image.createImage((byte[])imageByteData, (int)0, (int)imageByteDataSize);
            GVL2_ImageFont_Eng.colorValue[GVL2_ImageFont_Eng.colorCount][0] = (byte)r;
            GVL2_ImageFont_Eng.colorValue[GVL2_ImageFont_Eng.colorCount][1] = (byte)g;
            GVL2_ImageFont_Eng.colorValue[GVL2_ImageFont_Eng.colorCount][2] = (byte)b;
            fontImg = null;
            fontImg = colorImage[colorCount];
            ++colorCount;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getColorImageCnt() {
        return colorCount;
    }

    private void loadImageByteData(String imgName) {
        try {
            imageByteData = GVL2_FileMgr.readFile(imgName, 1024);
            imageByteDataSize = GVL2_FileMgr.getLastReadFileLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getFontHeight() {
        return fontHeight;
    }

    public byte getFontSpace() {
        return fontSpace;
    }

    public int parseString(String str, int bound) {
        int strReadindex = 0;
        int lastBlankIndex = 0;
        if (str.compareTo(lastString) == 0) {
            return lastStringLine;
        }
        if (str.compareTo("") == 0 || str.compareTo(lastString) == 0) {
            return 0;
        }
        lastString = str;
        myVector.removeAllElements();
        for (int i = 0; i <= str.length(); ++i) {
            if (i != str.length()) {
                if (str.charAt(i) == '|') {
                    if (strReadindex == i) {
                        myVector.addElement("");
                    } else {
                        myVector.addElement(str.substring(strReadindex, i));
                    }
                    strReadindex = i + 1;
                    continue;
                }
                if (str.charAt(i) != ' ') continue;
                String tempStr = str.substring(strReadindex, i);
                if (this.getStrWidth(tempStr) > bound) {
                    i = lastBlankIndex;
                    myVector.addElement(str.substring(strReadindex, i));
                    strReadindex = i + 1;
                    continue;
                }
                lastBlankIndex = i;
                continue;
            }
            if (this.getStrWidth(str.substring(strReadindex)) > bound) {
                myVector.addElement(str.substring(strReadindex, lastBlankIndex));
                myVector.addElement(str.substring(lastBlankIndex + 1));
                continue;
            }
            myVector.addElement(str.substring(strReadindex));
        }
        lastStringLine = myVector.size();
        return myVector.size();
    }

    public int getStrWidth(String nStr) {
        int charLen = nStr.length();
        int totalWidth = 0;
        int space = 0;
        char[] charArr = new char[charLen];
        if (charLen == 0) {
            return 0;
        }
        nStr.getChars(0, charLen, charArr, 0);
        for (int i = 0; i < charLen; ++i) {
            if (charArr[i] == ' ') {
                totalWidth += this.getCharWidth(charArr[i]);
                space = 0;
                continue;
            }
            totalWidth += this.getCharWidth(charArr[i]) + space;
            space = 1;
        }
        return totalWidth;
    }

    public void drawLineStr(String nStr, int nx, int ny) {
        int charLen = nStr.length();
        int totalWidth = 0;
        int space = 0;
        char[] charArr = new char[charLen];
        nStr.getChars(0, charLen, charArr, 0);
        for (int i = 0; i < charLen; ++i) {
            if (charArr[i] == ' ') {
                if (i != 0) {
                    totalWidth += this.getCharWidth(charArr[i - 1]);
                }
                space = 0;
            } else {
                if (i != 0) {
                    totalWidth += this.getCharWidth(charArr[i - 1]) + space;
                }
                space = 1;
            }
            int offset = this.getMatchFont(charArr[i]);
            this.drawClipImage(nx + totalWidth, ny, offset * charMaxWidth, 0, charMaxWidth, fontHeight);
        }
    }

    private void drawClipImage(int nx, int ny, int offsetX, int offsetY, int nw, int nh) {
        int clipX = gx.getClipX();
        int clipY = gx.getClipY();
        int clipW = gx.getClipWidth();
        int clipH = gx.getClipHeight();
        gx.setClip(nx, ny, nw, nh);
        gx.drawImage(fontImg, nx - offsetX, ny - offsetY, 0);
        gx.setClip(clipX, clipY, clipW, clipH);
    }

    public int drawScript(String nStr, int nx, int ny, int width, int height) {
        return this.drawScriptAlign(nStr, nx, ny, width, height, 16);
    }

    public int drawScriptAlign(String nStr, int nx, int ny, int width, int height, int align) {
        int num = 0;
        num = this.parseString(nStr, width);
        for (int i = 0; i < num; ++i) {
            String subStr = (String)myVector.elementAt(i);
            int subWidth = this.getStrWidth(subStr);
            int subX = align == 17 ? nx - subWidth / 2 : (align == 18 ? nx - subWidth : nx);
            this.drawLineStr(subStr, subX, ny + i * height);
        }
        return num;
    }

    public int drawScriptPage(String nStr, int nx, int ny, int width, int height, int page, int line) {
        int num = 0;
        num = this.parseString(nStr, width);
        int startLine = page * line;
        int endLine = (page + 1) * line;
        int start = startLine;
        int end = endLine > num ? num : endLine;
        for (int i = start; i < end; ++i) {
            this.drawLineStr((String)myVector.elementAt(i), nx, ny + (i - start) * height);
        }
        int totalPage = num % line == 0 ? num / line : num / line + 1;
        return totalPage;
    }

    public int getMatchFont(char ch) {
        int offset = 0;
        if (ch >= 'A' && ch <= 'Z') {
            offset = 32 + (ch - 65);
        } else if (ch >= 'a' && ch <= 'z') {
            offset = 64 + (ch - 97);
        } else if (ch >= '0' && ch <= '9') {
            offset = 15 + (ch - 48);
        } else if (ch == '!') {
            offset = 0;
        } else if (ch == '\"') {
            offset = 1;
        } else if (ch == '#') {
            offset = 2;
        } else if (ch == '$') {
            offset = 3;
        } else if (ch == '%') {
            offset = 4;
        } else if (ch == '&') {
            offset = 5;
        } else if (ch == '\'') {
            offset = 6;
        } else if (ch == '(') {
            offset = 7;
        } else if (ch == ')') {
            offset = 8;
        } else if (ch == '*') {
            offset = 9;
        } else if (ch == '+') {
            offset = 10;
        } else if (ch == ',') {
            offset = 11;
        } else if (ch == '-') {
            offset = 12;
        } else if (ch == '.') {
            offset = 13;
        } else if (ch == '/') {
            offset = 14;
        } else if (ch == ':') {
            offset = 25;
        } else if (ch == ';') {
            offset = 26;
        } else if (ch == '<') {
            offset = 27;
        } else if (ch == '=') {
            offset = 28;
        } else if (ch == '>') {
            offset = 29;
        } else if (ch == '?') {
            offset = 30;
        } else if (ch == '@') {
            offset = 31;
        } else if (ch == '[') {
            offset = 58;
        } else if (ch == ']') {
            offset = 60;
        } else if (ch == '^') {
            offset = 61;
        } else if (ch == '_') {
            offset = 62;
        } else if (ch == '`') {
            offset = 63;
        } else if (ch == '{') {
            offset = 90;
        } else if (ch == '|') {
            offset = 91;
        } else if (ch == '}') {
            offset = 92;
        } else if (ch == '~') {
            offset = 93;
        } else if (ch == ' ') {
            offset = 99;
        }
        return offset;
    }

    public int getCharWidth(char ch) {
        int char_width = 0;
        switch (ch) {
            case 'f': {
                char_width = 4;
                break;
            }
            case 'i': {
                char_width = 1;
                break;
            }
            case 'j': {
                char_width = 3;
                break;
            }
            case 'k': {
                char_width = 4;
                break;
            }
            case 'l': {
                char_width = 3;
                break;
            }
            case 't': {
                char_width = 3;
                break;
            }
            case 'I': {
                char_width = 3;
                break;
            }
            case 'J': {
                char_width = 4;
                break;
            }
            case '.': {
                char_width = 1;
                break;
            }
            case ',': {
                char_width = 2;
                break;
            }
            default: {
                char_width = 5;
            }
        }
        return char_width;
    }

    public int drawScriptAlignX(String nStr, int nx, int ny, int width, int height, int align, int clipHeight) {
        int num = 0;
        num = this.parseString(nStr, width);
        for (int i = 0; i < num; ++i) {
            String subStr = (String)myVector.elementAt(i);
            int subWidth = this.getStrWidth(subStr);
            int subX = align == 17 ? nx - subWidth / 2 : (align == 18 ? nx - subWidth : nx);
            this.drawLineStr(subStr, subX, ny + i * height);
        }
        return num;
    }
}

