/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GVDrawer {
    public static final int WHITE = 0xFFFFFF;
    public static final int LIGHT_GRAY = 0xAAAAAA;
    public static final int DARK_GRAY = 0x555555;
    public static final int BLACK = 0;
    private static Graphics g;
    private static int m_clipX;
    private static int m_clipY;
    private static int m_clipW;
    private static int m_clipH;
    private static Image maskImg;
    private static Graphics maskG;
    private static Graphics nowG;
    public static final int FONT_ENG_PX = 5;
    public static final int FONT_HAN_PX = 9;
    public static final int FONT_HEIGHT = 11;
    public static final int UNI_BASE = 44032;
    public static final int TYPE_HORZ = 1;
    public static final int TYPE_VERT = 2;
    public static final int TYPE_BOTH = 4;
    public static final int NO_CHO = 19;
    public static final int NO_JUNG = 21;
    public static final int NO_JONG = 28;
    public static final int NO_JMJ = 588;
    private static Image m_pAlphaNum;
    private static Image m_pCho_Vert;
    private static Image m_pCho_Horz;
    private static Image m_pCho_Horz_J;
    private static Image m_pCho_Both;
    private static Image m_pJung;
    private static Image m_pJung_V_J;
    private static Image m_pJung_H_J;
    private static Image m_pJong;
    private static final int H_ALPHA = 10;
    private static final int W_ALPHA = 5;
    private static final int H_CHO_VERT = 10;
    private static final int W_CHO_VERT = 5;
    private static final int H_CHO_HORZ = 6;
    private static final int W_CHO_HORZ = 7;
    private static final int H_CHO_HORZJ = 5;
    private static final int W_CHO_HORZJ = 7;
    private static final int H_CHO_BOTH = 5;
    private static final int W_CHO_BOTH = 5;
    private static final int H_JUNG = 11;
    private static final int W_JUNG = 9;
    private static final int H_JUNG_VJ = 7;
    private static final int W_JUNG_VJ = 4;
    private static final int H_JUNG_HJ = 3;
    private static final int W_JUNG_HJ = 9;
    private static final int H_JONG = 5;
    private static final int W_JONG = 9;
    static Image[] numberFont;
    private static boolean bPNG;
    static int[] crc_table;
    static int dataptr;
    static int crcfrom;
    static int pngsize;
    static byte[] data;
    static byte[] PNG_header;
    static byte[] PNG_End;

    public static void init() {
        maskImg = Image.createImage((int)GameCanvas.LCD_WIDTH, (int)11);
        maskG = maskImg.getGraphics();
        GVDrawer.make_crc_table();
    }

    public static void init(int maskW, int maskH) {
        maskImg = Image.createImage((int)maskW, (int)maskH);
        maskG = maskImg.getGraphics();
        GVDrawer.make_crc_table();
    }

    public static Image createImage(String imgName, boolean isPNG) {
        Image im = null;
        try {
            im = Image.createImage((String)(imgName + ".png"));
        }
        catch (Exception e) {
            System.out.println("createImage e:" + e);
        }
        System.gc();
        return im;
    }

    public static Image createMirrorImage(String imgName) {
        Image im = null;
        try {
            byte[] abyte0 = GVUtil.readFile(imgName + ".png");
            im = GVDrawer.createMirrorImage(abyte0, 0, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return im;
    }

    public static Image createPalImage(String imgName, int index) {
        try {
            byte[] abyte0 = GVUtil.readFile(imgName);
            if (index > 0) {
                int iPalLength = (abyte0[46] & 0xFF) << 8 | abyte0[45] & 0xFF;
                int iPalOffset = (abyte0[48] & 0xFF) << 8 | abyte0[47] & 0xFF;
                System.arraycopy(abyte0, 49 + (index - 1) * iPalLength, abyte0, iPalOffset, iPalLength);
            }
            Image img = Image.createImage((byte[])abyte0, (int)0, (int)abyte0.length);
            System.gc();
            return img;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setGraphics(Graphics srcG) {
        g = srcG;
    }

    public static void clipRect(int x, int y, int width, int height) {
        m_clipX = g.getClipX();
        m_clipY = g.getClipY();
        m_clipW = g.getClipWidth();
        m_clipH = g.getClipHeight();
        g.clipRect(x, y, width, height);
    }

    public static void restoreClip() {
        g.setClip(m_clipX, m_clipY, m_clipW, m_clipH);
    }

    public static void translate(int x, int y) {
        g.translate(x, y);
    }

    public static void drawImage(Image image, int x, int y) {
        g.drawImage(image, x, y, 20);
    }

    public static void drawImage(Image image, int x, int y, int anchor) {
        g.drawImage(image, x, y, anchor);
    }

    public static void drawClipImage(Image image, int x, int y, int w, int h, int offsetX, int offsetY) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.setClip(x, y, w - GameCanvas.clipMod + 1, h - GameCanvas.clipMod + 1);
        g.drawImage(image, x - offsetX, y - offsetY, 0);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public static void drawImageAlpha(Image image, int x, int y) {
    }

    public static void drawHLine(int x, int y, int len, int color) {
        if (len > 0) {
            g.setColor(color);
            g.drawLine(x, y, x + len - 1, y);
        }
    }

    public static void drawVLine(int x, int y, int len, int color) {
        if (len > 0) {
            g.setColor(color);
            g.drawLine(x, y, x, y + len - 1);
        }
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        g.setColor(color);
        g.drawRect(x, y, width - 1, height - 1);
    }

    public static void fillRect(int x, int y, int width, int height, int color) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
    }

    public static void draw3DRect(int x, int y, int width, int height, int c1, int c2) {
        g.setColor(c2);
        g.drawRect(x, y, width - 1, height - 1);
        GVDrawer.drawHLine(x, y, width, c1);
        GVDrawer.drawVLine(x, y, height - 1, c1);
    }

    public static void drawRoundRect(int x, int y, int width, int height, int r, int color) {
        GVDrawer.drawHLine(x + r, y, width - 2 * r, color);
        GVDrawer.drawHLine(x + r, y + height - 1, width - 2 * r, color);
        GVDrawer.drawVLine(x, y + r, height - 2 * r, color);
        GVDrawer.drawVLine(x + width - 1, y + r, height - 2 * r, color);
        if (r == 2) {
            GVDrawer.fillRect(x + 1, y + 1, 1, 1, color);
            GVDrawer.fillRect(x + width - 2, y + 1, 1, 1, color);
            GVDrawer.fillRect(x + 1, y + height - 2, 1, 1, color);
            GVDrawer.fillRect(x + width - 2, y + height - 2, 1, 1, color);
        }
    }

    public static void draw3DRoundRect(int x, int y, int width, int height, int c1, int c2) {
        GVDrawer.drawVLine(x + width - 1, y + 1, height - 2, c2);
        GVDrawer.drawHLine(x + 1, y + height - 1, width - 2, c2);
        GVDrawer.drawHLine(x + 1, y, width - 2, c1);
        GVDrawer.drawVLine(x, y + 1, height - 2, c1);
    }

    public static void fillRectXOR(int x, int y, int width, int height, int color) {
    }

    public static void fillRoundRect(int x, int y, int width, int height, int r, int color) {
        GVDrawer.fillRect(x + 1, y + 1, width - 2, height - 2, color);
        GVDrawer.drawRoundRect(x, y, width, height, r, color);
    }

    public static void drawLine(int x, int y, int x2, int y2, int color) {
        g.setColor(color);
        g.drawLine(x, y, x2, y2);
    }

    public static Image capture(int x, int y, int width, int height) {
        return null;
    }

    public static void loadFont() {
        m_pAlphaNum = GVDrawer.createImage("f_alpha", false);
        m_pCho_Vert = GVDrawer.createImage("f_chov", false);
        m_pCho_Horz = GVDrawer.createImage("f_choh", false);
        m_pCho_Horz_J = GVDrawer.createImage("f_chohj", false);
        m_pCho_Both = GVDrawer.createImage("f_chob", false);
        m_pJung = GVDrawer.createImage("f_jung", false);
        m_pJung_V_J = GVDrawer.createImage("f_jungvj", false);
        m_pJung_H_J = GVDrawer.createImage("f_junghj", false);
        m_pJong = GVDrawer.createImage("f_jong", false);
        for (int i = 0; i < 3; ++i) {
            GVDrawer.numberFont[i] = GVDrawer.createImage("number" + i, false);
        }
    }

    public static void drawChar(char UniCode, int iTextX, int iTextY, int color) {
        if (UniCode == ' ') {
            return;
        }
        if (color != 0xFFFFFF) {
            if ('\uac00' <= UniCode && '\ud7a3' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u314f' <= UniCode && '\u3163' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u3131' <= UniCode && '\u314e' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u1100' <= UniCode && '\u1112' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u1161' <= UniCode && '\u1175' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else {
                GVDrawer.fillRectXOR(iTextX, iTextY, 5, 12, ~color);
            }
        }
        if (!('0' <= UniCode && '9' >= UniCode || 'A' <= UniCode && 'Z' >= UniCode)) {
            if ('a' <= UniCode && 'z' >= UniCode) {
                switch (UniCode) {
                    case 'g': 
                    case 'p': 
                    case 'q': 
                    case 'y': {
                        int offY = 2;
                        break;
                    }
                    default: {
                        boolean offY = true;
                        break;
                    }
                }
            } else if ('\uac00' > UniCode || '\ud7a3' < UniCode) {
                if (!('\u314f' <= UniCode && '\u3163' >= UniCode || '\u1161' <= UniCode && '\u1175' >= UniCode)) {
                    if ('\u3131' <= UniCode && '\u314e' >= UniCode) {
                        int iCode_ChoSung = 0;
                        if ('\u3131' <= UniCode && '\u3132' >= UniCode) {
                            iCode_ChoSung = UniCode - 12593;
                        } else if (UniCode == '\u3134') {
                            iCode_ChoSung = UniCode - 12593 - 1;
                        } else if ('\u3137' <= UniCode && '\u3139' >= UniCode) {
                            iCode_ChoSung = UniCode - 12593 - 3;
                        } else if ('\u3141' <= UniCode && '\u3143' >= UniCode) {
                            iCode_ChoSung = UniCode - 12593 - 10;
                        } else if ('\u3145' <= UniCode && '\u314e' >= UniCode) {
                            iCode_ChoSung = UniCode - 12593 - 11;
                        }
                    } else if ('\u1100' <= UniCode && '\u1112' >= UniCode) {
                        // empty if block
                    }
                }
            } else {
                int iCode_ChoSung = (UniCode - 44032) / 588;
                int iCode_JungSung = (UniCode - 44032) % 588 / 28;
                int iCode_JongSung = (UniCode - 44032) % 28;
                int iType = 4;
                if (0 <= iCode_JungSung && iCode_JungSung <= 7) {
                    iType = 2;
                } else if (iCode_JungSung == 20) {
                    iType = 2;
                } else if (iCode_JungSung == 8) {
                    iType = 1;
                } else if (iCode_JungSung == 12) {
                    iType = 1;
                } else if (iCode_JungSung == 13) {
                    iType = 1;
                } else if (iCode_JungSung == 17) {
                    iType = 1;
                } else if (iCode_JungSung == 18) {
                    iType = 1;
                }
                if (iCode_JongSung != 0) {
                    int iJungIndex;
                    boolean largeCho = false;
                    if (iType == 1) {
                        if (iCode_ChoSung == 5 || iCode_ChoSung == 16) {
                            largeCho = true;
                        }
                    } else {
                        largeCho = true;
                    }
                    if ((iJungIndex = GVDrawer.getJungSungIndex(iCode_JungSung)) >= 0) {
                        boolean largeJong = iCode_JongSung >= 8 && iCode_JongSung <= 15 || iCode_JongSung == 23 || iCode_JongSung == 25 || iCode_JongSung == 27;
                        int offY = 4;
                        if (iJungIndex < 3) {
                            if (largeCho) {
                                offY = 5;
                            }
                        } else if (largeJong) {
                            offY = 3;
                        }
                    }
                    switch (iCode_JungSung) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 15: {
                            boolean offX = true;
                            break;
                        }
                        default: {
                            boolean offX = false;
                            break;
                        }
                    }
                } else if (iType == 2 || iType == 1) {
                    // empty if block
                }
            }
        }
        if (color != 0xFFFFFF) {
            if ('\uac00' <= UniCode && '\ud7a3' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u314f' <= UniCode && '\u3163' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u3131' <= UniCode && '\u314e' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u1100' <= UniCode && '\u1112' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else if ('\u1161' <= UniCode && '\u1175' >= UniCode) {
                GVDrawer.fillRectXOR(iTextX, iTextY, 9, 11, ~color);
            } else {
                GVDrawer.fillRectXOR(iTextX, iTextY, 5, 12, ~color);
            }
        }
    }

    private static int getEtcIndex(int UniCode) {
        switch (UniCode) {
            case 43: {
                return 62;
            }
            case 45: {
                return 63;
            }
            case 47: {
                return 64;
            }
            case 42: {
                return 65;
            }
            case 61: {
                return 66;
            }
            case 46: {
                return 67;
            }
            case 44: {
                return 68;
            }
            case 33: {
                return 69;
            }
            case 63: {
                return 70;
            }
            case 95: {
                return 71;
            }
            case 58: {
                return 72;
            }
            case 59: {
                return 73;
            }
            case 91: {
                return 74;
            }
            case 93: {
                return 75;
            }
            case 40: {
                return 76;
            }
            case 41: {
                return 77;
            }
            case 34: {
                return 78;
            }
            case 38: {
                return 79;
            }
            case 64: {
                return 80;
            }
            case 126: {
                return 81;
            }
            case 60: {
                return 82;
            }
            case 62: {
                return 83;
            }
            case 39: {
                return 84;
            }
            case 35: {
                return 85;
            }
            case 37: {
                return 86;
            }
        }
        return 80;
    }

    private static int getJungSungIndex(int iIndex) {
        switch (iIndex) {
            case 8: {
                return 0;
            }
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 3;
            }
            case 14: 
            case 15: 
            case 16: {
                return 4;
            }
            case 17: {
                return 5;
            }
            case 18: {
                return 6;
            }
            case 19: {
                return 7;
            }
        }
        return -1;
    }

    public static void drawChars(char[] text, int off, int len, int x, int y, int anchor, int color) {
        if ((anchor & 1) != 0) {
            x -= GVDrawer.charsWidth(text, off, len) / 2;
        } else if ((anchor & 8) != 0) {
            x -= GVDrawer.charsWidth(text, off, len);
        }
        int clipX1 = g.getClipX();
        int clipX2 = clipX1 + g.getClipWidth();
        int last = off + len;
        int drawX = x;
        int realX1 = 0;
        int realX2 = 0;
        if (color != 0xFFFFFF) {
            int width = GVDrawer.charsWidth(text, 0, text.length);
            realX1 = Math.max(clipX1, x);
            realX2 = Math.min(clipX2, x + width);
            GVDrawer.fillRectXOR(realX1, y, realX2 - realX1, 12, ~color);
        }
        for (int i = off; i < last; ++i) {
            char c = text[i];
            int cw = GVDrawer.charWidth(c);
            if (drawX < clipX2 && drawX + cw > clipX1) {
                GVDrawer.drawChar(c, drawX, y, 0xFFFFFF);
            }
            drawX += cw;
        }
        if (color != 0xFFFFFF) {
            GVDrawer.fillRectXOR(realX1, y, realX2 - realX1, 12, ~color);
        }
    }

    public static void drawString(String s, int x, int y, int anchor, int color) {
        GVDrawer.drawChars(s.toCharArray(), 0, s.length(), x, y, anchor, color);
    }

    public static void drawMultiString(String s, int x, int y, int width, int anchor, int fg) {
        GVDrawer.drawMultiString(s, x, y, width, anchor, fg, 2);
    }

    public static void drawMultiString(String s, int x, int y, int width, int anchor, int fg, int spacing) {
        char[] text = s.toCharArray();
        int clipY1 = g.getClipY();
        int clipY2 = clipY1 + g.getClipHeight();
        int i = 0;
        int j = 0;
        int k = 0;
        while (i + j <= text.length) {
            int drawY;
            if (i + j < text.length && text[i + j] == '|') {
                if ((drawY = y + (11 + spacing) * k++) < clipY2 && drawY + 11 > clipY1) {
                    GVDrawer.drawChars(text, i, j, x, drawY, anchor, fg);
                }
                i += j + 1;
                j = 0;
            } else if (GVDrawer.charsWidth(text, i, j) > width) {
                --j;
                if ((drawY = y + (11 + spacing) * k++) < clipY2 && drawY + 11 > clipY1) {
                    GVDrawer.drawChars(text, i, j, x, drawY, anchor, fg);
                }
                i += j;
                j = 0;
                if (text[i] == ' ') {
                    ++i;
                }
            } else if (i + j == text.length && (drawY = y + (11 + spacing) * k++) < clipY2 && drawY + 11 > clipY1) {
                GVDrawer.drawChars(text, i, j, x, drawY, anchor, fg);
            }
            ++j;
        }
    }

    public static void drawPage(String s, int x, int y, int width, int lineNum, int page, int fg) {
        int realLine = 0;
        char[] text = s.toCharArray();
        int i = 0;
        int j = 0;
        int k = 0;
        while (i + j <= text.length) {
            if (GVDrawer.charsWidth(text, i, j) > width) {
                --j;
                if (k / lineNum == page) {
                    GVDrawer.drawChars(text, i, j, x, y + 14 * realLine++, 0, fg);
                }
                ++k;
                i += j;
                j = 0;
                if (text[i] == ' ') {
                    ++i;
                }
            } else if (i + j == text.length) {
                if (k / lineNum == page) {
                    GVDrawer.drawChars(text, i, j, x, y + 14 * realLine++, 0, fg);
                }
                ++k;
            }
            ++j;
        }
    }

    public static int charWidth(char UniCode) {
        if ('\uac00' <= UniCode && '\ud7a3' >= UniCode) {
            return 10;
        }
        if ('\u314f' <= UniCode && '\u3163' >= UniCode) {
            return 10;
        }
        if ('\u3131' <= UniCode && '\u314e' >= UniCode) {
            return 10;
        }
        if ('\u1100' <= UniCode && '\u1112' >= UniCode) {
            return 10;
        }
        if ('\u1161' <= UniCode && '\u1175' >= UniCode) {
            return 10;
        }
        return 6;
    }

    public static int charsWidth(char[] text, int off, int len) {
        int width = 0;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            width += GVDrawer.charWidth(text[i]);
        }
        return width;
    }

    public static int stringWidth(String s) {
        char[] chArr = s.toCharArray();
        return GVDrawer.charsWidth(chArr, 0, chArr.length);
    }

    public static int getMultiStringLine(String s, int width) {
        return GVDrawer.getMultiStringLine(s, width, 2);
    }

    public static int getMultiStringLine(String s, int width, int spacing) {
        char[] text = s.toCharArray();
        int line = 0;
        int i = 0;
        int j = 0;
        while (i + j <= text.length) {
            if (i + j < text.length && text[i + j] == '|') {
                ++line;
                i += j + 1;
                j = 0;
            } else if (GVDrawer.charsWidth(text, i, j) > width) {
                ++line;
                i += --j;
                j = 0;
                if (text[i] == ' ') {
                    ++i;
                }
            } else if (i + j == text.length) {
                ++line;
            }
            ++j;
        }
        return line;
    }

    public static int getTotalPage(String s, int width, int lineNum) {
        char[] text = s.toCharArray();
        int k = 0;
        int i = 0;
        int j = 0;
        while (i + j <= text.length) {
            if (i + j < text.length && text[i + j] == '|') {
                ++k;
                i += j + 1;
                j = 0;
            } else if (GVDrawer.charsWidth(text, i, j) > width) {
                ++k;
                i += --j;
                j = 0;
                if (text[i] == ' ') {
                    ++i;
                }
            } else if (i + j == text.length) {
                ++k;
            }
            ++j;
        }
        return k / lineNum + (k % lineNum > 0 ? 1 : 0);
    }

    public static void drawNumberChars(char[] text, int len, int x, int y, int anchor, int style) {
    }

    public static void drawNumberString(String s, int x, int y, int anchor, int style) {
        GVDrawer.drawNumberChars(s.toCharArray(), s.length(), x, y, anchor, style);
    }

    public static void drawNumber(int num, int x, int y, int anchor) {
        GVDrawer.drawNumberString(GVDrawer.getNumberString(num), x, y, anchor, 1);
    }

    public static String getNumberString(int num) {
        char[] tempChars = new char[20];
        tempChars[19] = (char)(num % 10 + 48);
        int pos = 19;
        int pow = 10;
        int i = 1;
        while (num / pow != 0) {
            --pos;
            if (i % 3 == 0) {
                tempChars[pos--] = 44;
            }
            tempChars[pos] = (char)(num / pow % 10 + 48);
            pow *= 10;
            ++i;
        }
        return new String(tempChars, pos, 20 - pos);
    }

    public static int getNumberWidth(char[] text, int len, int style) {
        int width = 1;
        switch (style) {
            case 0: 
            case 1: {
                for (int i = 0; i < len; ++i) {
                    if (text[i] == ':') {
                        width += 2;
                        continue;
                    }
                    if (text[i] == ',') {
                        width += 4;
                        continue;
                    }
                    width += 6;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    if (text[i] == '/') {
                        width += 4;
                        continue;
                    }
                    if (text[i] == '*') {
                        width += 6;
                        continue;
                    }
                    width += 5;
                }
                break;
            }
        }
        return width;
    }

    public static int getNumberWidth(String s, int style) {
        return GVDrawer.getNumberWidth(s.toCharArray(), s.length(), style);
    }

    static Image create(int width, int height, int palette, byte[] idata, byte[] pal, int trans, int flips, int palOffset, int imgOffset) throws Exception {
        try {
            int i;
            pngsize = palette * 3 + (width + 1) * height + 80;
            if (trans > -1) {
                pngsize += 13 + trans;
            }
            data = new byte[pngsize];
            System.arraycopy(PNG_header, 0, data, 0, PNG_header.length);
            GVDrawer.data[19] = (byte)width;
            GVDrawer.data[23] = (byte)height;
            dataptr = 29;
            GVDrawer.writeInt(GVDrawer.calc_crc(data, 12, 17));
            GVDrawer.writeInt(palette * 3);
            crcfrom = dataptr;
            GVDrawer.writeHeader("PLTE");
            System.arraycopy(pal, 0, data, dataptr, pal.length);
            dataptr += palette * 3 + 4;
            if (trans > -1) {
                GVDrawer.writeInt(trans + 1);
                crcfrom = dataptr;
                GVDrawer.writeHeader("tRNS");
                for (i = 0; i < trans; ++i) {
                    GVDrawer.data[GVDrawer.dataptr++] = -1;
                }
                GVDrawer.data[GVDrawer.dataptr++] = 0;
                GVDrawer.writeInt(GVDrawer.calc_crc(data, crcfrom, dataptr - crcfrom));
            }
            int compsize = (width + 1) * height;
            GVDrawer.writeInt(compsize + 11);
            crcfrom = dataptr;
            GVDrawer.writeHeader("IDAT");
            GVDrawer.data[GVDrawer.dataptr++] = 120;
            GVDrawer.data[GVDrawer.dataptr++] = -38;
            GVDrawer.data[GVDrawer.dataptr++] = 1;
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(compsize & 0xFF);
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(compsize >>> 8 & 0xFF);
            GVDrawer.data[GVDrawer.dataptr] = ~data[dataptr - 2];
            GVDrawer.data[++GVDrawer.dataptr] = ~data[dataptr - 2];
            int adlerstart = ++dataptr;
            switch (flips) {
                case 0: {
                    i = imgOffset;
                    System.arraycopy(idata, 0, data, dataptr, idata.length);
                    dataptr += idata.length;
                    break;
                }
                case 1: {
                    int m = 0;
                    for (int y = 0; y < height; ++y) {
                        i = (y + 1) * width + imgOffset;
                        i += m;
                        GVDrawer.data[GVDrawer.dataptr++] = 0;
                        for (int x = 0; x < width; ++x) {
                            GVDrawer.data[GVDrawer.dataptr++] = idata[i--];
                        }
                        ++m;
                    }
                    break;
                }
            }
            int adler1 = 1;
            int adler2 = 0;
            for (i = 0; i < compsize; ++i) {
                adler2 = (adler1 += data[adlerstart + i] & 0xFF) + adler2;
                adler1 %= 65521;
                adler2 %= 65521;
            }
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(adler2 >> 8 & 0xFF);
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(adler2 & 0xFF);
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(adler1 >> 8 & 0xFF);
            GVDrawer.data[GVDrawer.dataptr++] = (byte)(adler1 & 0xFF);
            GVDrawer.writeInt(GVDrawer.calc_crc(data, crcfrom, dataptr - crcfrom));
            System.arraycopy(PNG_End, 0, data, dataptr, PNG_End.length);
            idata = null;
            pal = null;
            return Image.createImage((byte[])data, (int)0, (int)(dataptr += PNG_End.length));
        }
        catch (Exception e) {
            System.out.println("e:" + e);
            return null;
        }
    }

    static void writeInt(long crc) {
        GVDrawer.data[GVDrawer.dataptr++] = (byte)(crc >>> 24 & 0xFFL);
        GVDrawer.data[GVDrawer.dataptr++] = (byte)(crc >>> 16 & 0xFFL);
        GVDrawer.data[GVDrawer.dataptr++] = (byte)(crc >>> 8 & 0xFFL);
        GVDrawer.data[GVDrawer.dataptr++] = (byte)(crc & 0xFFL);
    }

    static void writeHeader(String t) {
        for (int i = 0; i < 4; ++i) {
            GVDrawer.data[GVDrawer.dataptr++] = (byte)t.charAt(i);
        }
    }

    static void make_crc_table() {
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            GVDrawer.crc_table[n] = c;
        }
    }

    static long calc_crc(byte[] buf, int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    public static Image createMirrorImage(byte[] buf, int offset, int imgKind) throws Exception {
        GVInputPacket dip = new GVInputPacket(buf);
        try {
            int totalSize = 16;
            int wid = dip.readBigInt(totalSize);
            int hei = dip.readBigInt(totalSize += 4);
            totalSize += 4;
            int size = dip.readBigInt(totalSize += 9);
            String chunkName = dip.readString(totalSize += 4, 4);
            totalSize += 4;
            int iPlatSize = size;
            byte[] pal = new byte[iPlatSize + 4];
            for (int i = 0; i < pal.length; ++i) {
                pal[i] = dip.readByte(totalSize++);
            }
            byte tRNS = dip.readByte(totalSize += 8);
            size = dip.readBigInt(totalSize += 5);
            byte[] idata = new byte[size - 11];
            if (dip.readByte(totalSize + 8) == 120 && dip.readByte(totalSize + 9) == -38 && dip.readByte(totalSize + 10) == 1) {
                totalSize += 15;
                for (int i = 0; i < idata.length; ++i) {
                    idata[i] = dip.readByte(totalSize++);
                }
                return GVDrawer.create(wid, hei, iPlatSize / 3, idata, pal, tRNS, imgKind, 0, 0);
            }
            if (imgKind == 0) {
                try {
                    return Image.createImage((byte[])buf, (int)0, (int)buf.length);
                }
                catch (Exception e) {
                }
            } else {
                System.out.println("Error! \ubc18\uc804 \uc774\ubbf8\uc9c0\ub97c \uc0dd\uc131 \uc624\ub958(\uc555\ucd95\ub41c \uc774\ubbf8\uc9c0) return null");
            }
            return null;
        }
        catch (Exception e) {
            GVSpriteManager.t = GVSpriteManager.t + "111 createMirrorImage e:" + e;
            return null;
        }
    }

    static {
        numberFont = new Image[3];
        PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
        PNG_End = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

