/*
 * Decompiled with CFR 0.152.
 */
package wb.games;

import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import wb.games.Draw;
import wb.games.GamePositions;
import wb.games.GameText;
import wb.games.Gameplay;
import wb.games.LevelData;
import wb.games.Loading;
import wb.games.Menu;
import wb.games.nokias40.ASSound;

public class FSCanvas
extends FullCanvas
implements Runnable {
    Thread CanvasThread;
    Random rand;
    private static MIDlet midlet;
    GameText Text;
    GamePositions Positions;
    Menu menu;
    Loading ImageData;
    LevelData levelData;
    int GameState = 0;
    static int OffsetX;
    static int OffsetY;
    Draw draw;
    Gameplay GP;
    long lastElapsed = 0L;
    boolean GameOver = false;
    boolean Paused = false;
    boolean SHOWBOUNDINGBOXES = false;
    byte PgCur = 0;
    byte PgLinCur = 0;
    boolean PgLinEnd = false;
    ASSound BK_music;
    boolean ISRaining = false;
    public byte musicInd;
    boolean bKeyPressed = false;
    byte doWhatOnLoad = 0;
    byte loadTick = 0;
    byte loadMaxTick = (byte)2;
    byte gotoStateAfterLoad = 0;
    boolean bLoadingDone = false;
    boolean bFakeSoftkeyLabel = true;
    boolean bPlayTheMusic = false;
    private String softkeyLeft;
    private String softkeyRight;

    static {
        OffsetX = 0;
        OffsetY = 0;
    }

    public static MIDlet getMIDlet() {
        return midlet;
    }

    public FSCanvas(MIDlet midlet) {
        FSCanvas.midlet = midlet;
        this.isDoubleBuffered();
        this.Text = new GameText();
        this.menu = new Menu(this);
        this.ImageData = new Loading();
        this.BK_music = new ASSound("/Song1.ota");
        if (!this.BK_music.isValid()) {
            this.BK_music = null;
            System.out.println("Unable to load music");
        }
        this.levelData = new LevelData(this);
        this.draw = new Draw();
        this.GP = new Gameplay();
        this.menu.ReferenceCanvas(this);
        this.rand = new Random(System.currentTimeMillis());
        this.Positions = new GamePositions(this);
    }

    public void run() {
        int loopDelay = 66;
        while (!this.Paused) {
            long loopStartTime = System.currentTimeMillis();
            this.tick();
            long loopEndTime = System.currentTimeMillis();
            int loopTime = (int)(loopEndTime - loopStartTime);
            if (loopTime < loopDelay) {
                try {
                    Thread.sleep(loopDelay - loopTime);
                }
                catch (Exception e) {
                    break;
                }
            }
            this.lastElapsed = System.currentTimeMillis() - loopStartTime;
        }
    }

    void setSoftKeyLabel(String left, String right) {
        this.softkeyLeft = left;
        this.softkeyRight = right;
    }

    void drawSoftKeyLabels(Graphics g) {
        if (!this.bFakeSoftkeyLabel) {
            return;
        }
        g.setClip(-OffsetX, -OffsetY, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.fillRect(-OffsetX, this.getHeight() - this.menu.BOLD.GetHeight() - OffsetY, this.getWidth(), this.menu.BOLD.GetHeight());
        if (this.softkeyLeft != "") {
            this.draw.DrawATextString(g, this.menu.BOLD, 0xFFFFFF, this.softkeyLeft, (short)(-OffsetX), (short)(this.getHeight() - this.menu.BOLD.GetHeight() - OffsetY));
        }
        if (this.softkeyRight != "") {
            this.draw.DrawATextString(g, this.menu.BOLD_RIGHT, 0xFFFFFF, this.softkeyRight, (short)(-OffsetX + this.getWidth()), (short)(this.getHeight() - this.menu.BOLD.GetHeight() - OffsetY));
        }
    }

    void timeToLoadSomething(byte toWhatState, byte how) {
        this.gotoStateAfterLoad = toWhatState;
        this.doWhatOnLoad = how;
        this.loadTick = 0;
        this.GameState = 10;
    }

    final void timeToLoadSomething(byte how) {
        this.timeToLoadSomething((byte)this.GameState, how);
    }

    void tick() {
        if (this.GameOver) {
            this.levelData.SaveData(this);
            midlet.notifyDestroyed();
            return;
        }
        if (this.bLoadingDone) {
            this.GameState = this.gotoStateAfterLoad;
            this.bLoadingDone = false;
            return;
        }
        if (this.GameState == 10) {
            if (this.loadTick >= this.loadMaxTick) {
                this.bLoadingDone = true;
                switch (this.doWhatOnLoad) {
                    case 0: {
                        this.Text.ChangeLanguage(this.levelData.language - 1);
                        this.setSoftKeyLabel(this.Text.Select, this.Text.Back);
                        break;
                    }
                    case 1: {
                        this.GP.inputHappened = true;
                        this.GP.NextLevel(this);
                        break;
                    }
                    case 2: {
                        byte by = this.levelData.LevelNum = (byte)(this.levelData.ContinueLevelData - 2);
                        this.levelData.getClass();
                        if (by >= 35 - 1) {
                            this.levelData.LevelNum = 0;
                        }
                        this.levelData.LevelUp(this, this.ImageData);
                        this.GP.Animation2Active = false;
                        this.setSoftKeyLabel(this.Text.Pause, "");
                        break;
                    }
                    case 3: {
                        this.levelData.NewGame(this, this.ImageData);
                        this.GP.Animation2Active = false;
                        this.setSoftKeyLabel(this.Text.Pause, "");
                    }
                }
            } else {
                this.loadTick = (byte)(this.loadTick + 1);
            }
        }
        this.repaint();
        if (this.bPlayTheMusic) {
            this.MusicPlay();
            this.bPlayTheMusic = false;
        }
    }

    protected void paint(Graphics g) {
        if (this.GameOver || this.Paused) {
            return;
        }
        switch (this.GameState) {
            case 0: {
                this.ProcessIntro(g);
                break;
            }
            case 1: {
                this.menu.Menu.MenuLoop(g);
                break;
            }
            case 2: {
                this.GP.Draw(this, g);
                break;
            }
            case 3: {
                this.draw.DrawPagesGraphics(this, g, this.Text.MenuText[this.Text.MenuIndTxt[0][2]], this.Text.Instructions);
                break;
            }
            case 4: {
                this.draw.Credits(this, g);
                break;
            }
            case 5: {
                this.draw.DrawPagesGraphics(this, g, this.Text.EndGameTitle, this.Text.EndGame);
                break;
            }
            case 6: {
                this.draw.DrawPagesGraphics(this, g, this.Text.EndGameTitle, this.Text.SemiEndGame);
                break;
            }
            case 7: {
                this.draw.DrawPagesGraphics(this, g, this.Text.EndGameTitle, this.Text.SemiEndGameBonus);
                break;
            }
            case 8: 
            case 9: {
                this.draw.DrawConfirm(this, g);
                if (this.GameState != 9) break;
                this.draw.DrawATextBox(g, this.menu.BOLD_CENTERED, 0xFFFFFF, this.Text.NewGameConfirmInfo, (short)0, (short)this.menu.BOLD_CENTERED.GetHeight(), GamePositions.CurrentWidth, GamePositions.CurrentHeight, (short)0);
                break;
            }
            case 10: {
                int loadBoxH = this.menu.BOLD_CENTERED.GetHeight() * 2;
                g.setColor(0);
                g.fillRect(0, this.getHeight() - loadBoxH, this.getWidth(), loadBoxH);
                this.draw.DrawATextString(g, this.menu.BOLD_CENTERED, 0xFFFFFF, this.Text.LevelComplete[5], (short)(this.getWidth() >> 1), (short)(this.getHeight() - loadBoxH + (loadBoxH >> 1)));
            }
        }
        if (this.GameState > 0 && this.GameState != 10) {
            this.drawSoftKeyLabels(g);
        }
    }

    void ProcessIntro(Graphics g) {
        if (!this.ImageData.PreLoading()) {
            this.draw.Trademark(this, g);
        } else if (!this.ImageData.LoadMenuImages(this)) {
            this.draw.Trademark(this, g);
        } else if (!this.ImageData.LoadGameImages(this)) {
            this.draw.Loading(g, this.ImageData.LoadingPercent, this);
        } else if (!this.ImageData.GameLogoFinished) {
            this.draw.GameLogo(this, g);
        } else {
            this.GameState = 1;
            this.setSoftKeyLabel(this.Text.Select, "");
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.GameOver || this.Paused) {
            return;
        }
        switch (this.GameState) {
            case 2: {
                this.GP.ProcessInput(this, keyCode);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.bKeyPressed) {
            this.bKeyPressed = false;
            return;
        }
        if (this.GameOver || this.Paused) {
            return;
        }
        switch (this.GameState) {
            case 0: {
                if (this.draw.IntroTimer <= 0) break;
                this.ImageData.GameLogoFinished = true;
                break;
            }
            case 1: {
                this.menu.Menu.ProcessImput(keyCode, true);
                break;
            }
            case 2: {
                this.GP.ProcessRelease(this, keyCode);
                break;
            }
            case 3: {
                this.menu.PagesInput(this, keyCode, this.Text.Instructions.length, 1, 1);
                break;
            }
            case 4: {
                if (keyCode != -7) break;
                this.GameState = 1;
                this.setSoftKeyLabel(this.Text.Select, "");
                break;
            }
            case 5: {
                this.menu.PagesInput(this, keyCode, this.Text.EndGame.length, -1, 1);
                break;
            }
            case 6: {
                this.menu.PagesInput(this, keyCode, this.Text.SemiEndGame.length, -1, 1);
                break;
            }
            case 7: {
                this.menu.PagesInput(this, keyCode, this.Text.SemiEndGameBonus.length, -1, 2);
                break;
            }
            case 8: {
                if (keyCode == -7) {
                    this.GameOver = true;
                    break;
                }
                if (keyCode != -6) break;
                this.setSoftKeyLabel(this.Text.Select, "");
                this.GameState = 1;
                break;
            }
            case 9: {
                if (keyCode == -7) {
                    this.timeToLoadSomething((byte)2, (byte)3);
                    break;
                }
                if (keyCode != -6) break;
                this.setSoftKeyLabel(this.Text.Select, this.Text.Back);
                this.GameState = 1;
            }
        }
    }

    public void MusicPlay() {
        if (!this.MusicIsPlaying()) {
            this.BK_music.StartMusic();
            this.levelData.bSongPlaying = true;
        }
    }

    public void MusicStop() {
        if (this.MusicIsPlaying() && this.BK_music != null) {
            this.BK_music.StopMusic();
            this.levelData.bSongPlaying = false;
        }
    }

    public final boolean MusicIsPlaying() {
        return this.levelData.bSongPlaying;
    }

    public void MusicSetVolume(int i) {
        if (this.BK_music != null) {
            this.BK_music.SetVolume(i);
        }
    }

    public void showNotify() {
        this.resume();
        this.CanvasThread = new Thread(this);
        this.CanvasThread.start();
    }

    public void hideNotify() {
        this.pause();
    }

    void pause() {
        this.Paused = true;
        if (this.MusicIsPlaying()) {
            this.bPlayTheMusic = true;
        }
        this.MusicStop();
    }

    void resume() {
        this.Paused = false;
    }
}

