/*
 * Decompiled with CFR 0.152.
 */
package wb.games;

import javax.microedition.lcdui.Graphics;
import wb.games.CannonBall;
import wb.games.FSCanvas;
import wb.games.GamePositions;
import wb.games.as.ASFont;
import wb.games.as.ASMovieClip;

public class Draw {
    public byte CannonPos = (byte)3;
    boolean dots = false;
    byte CycleTimer = 0;
    final byte TimerMax = (byte)6;
    byte XGrid = (byte)15;
    byte YGrid = (byte)15;
    byte SamTimer = 0;
    final byte BoBDelay = (byte)4;
    final byte MaxBob = (byte)4;
    byte SamOffset = 0;
    boolean SamDown = true;
    short[] MarksX = new short[5];
    short[] MarksY = new short[5];
    boolean LevelCompleted = false;
    byte IntroTimer = 0;
    byte IntroTimerMax = (byte)100;
    boolean loadingDrawn = false;
    boolean TradeDrawn = false;
    byte PointsTimer = (byte)99;
    byte PointsValue = 0;
    short PointsX = 0;
    short PointsY = 0;
    byte TutInd = (byte)-1;
    byte TutScrollAmt = 0;
    byte[] PowerAni;
    byte PowerAniFrame;
    short BlockPosition;
    byte BlockMax;
    short CreditPos;
    short CreditInd;
    short[] RainDropsX;
    short[] RainDropsY;
    private byte pagesHeightFactor;

    public Draw() {
        byte[] byArray = new byte[8];
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 2;
        byArray[6] = 3;
        byArray[7] = 3;
        this.PowerAni = byArray;
        this.PowerAniFrame = 0;
        this.BlockPosition = 0;
        this.BlockMax = (byte)16;
        this.CreditPos = 0;
        this.CreditInd = 0;
        short[] sArray = new short[10];
        sArray[1] = 50;
        sArray[2] = 100;
        sArray[3] = 150;
        sArray[4] = 200;
        sArray[5] = 25;
        sArray[6] = 75;
        sArray[7] = 125;
        sArray[8] = 175;
        this.RainDropsX = sArray;
        short[] sArray2 = new short[10];
        sArray2[0] = 30;
        sArray2[1] = 20;
        sArray2[2] = 10;
        sArray2[3] = 15;
        sArray2[5] = 45;
        sArray2[6] = 75;
        sArray2[7] = 50;
        sArray2[8] = 60;
        sArray2[9] = 90;
        this.RainDropsY = sArray2;
        this.pagesHeightFactor = (byte)4;
    }

    public void DrawHiddenCoin(FSCanvas FC, Graphics g, int X, int Y, int ID, boolean Force) {
        if (FC.levelData.GetLevel().Flags[ID] == 0 || Force) {
            this.DrawAGraphic(g, FC.ImageData.HiddenCoin.MC, X, Y, FC.Positions.HiddenCoinW, FC.Positions.HiddenCoinH, 0, 0);
        }
    }

    public void Loading(Graphics g, int Percent, FSCanvas FC) {
        this.WBLogo(FC, g);
        this.loadingDrawn = true;
    }

    public void Trademark(FSCanvas FC, Graphics g) {
        if (!this.TradeDrawn) {
            this.TradeDrawn = true;
        }
    }

    public void WBLogo(FSCanvas FC, Graphics g) {
    }

    public void GameLogo(FSCanvas FC, Graphics g) {
        if (this.IntroTimer < this.IntroTimerMax - 10) {
            this.IntroTimer = (byte)(this.IntroTimer + 1);
        } else {
            FC.ImageData.GameLogoFinished = true;
            this.IntroTimer = 0;
            FC.ImageData.RandomImages[0] = null;
            System.gc();
        }
        this.MainMenu(g, FC);
        if (FC.ImageData.RandomImages[0] != null) {
            this.DrawAGraphic(g, FC.ImageData.RandomImages[0].MC, GamePositions.CurrentWidth / 2 - FC.Positions.GameLOGOWidth / 2, GamePositions.CurrentHeight / 3 - FC.Positions.GameLOGOHeight / 2, FC.Positions.GameLOGOWidth, FC.Positions.GameLOGOHeight, 0, 0);
        }
        g.setClip(0, 0, FC.getWidth(), FC.getHeight());
        short legalY = (short)(FC.getHeight() - FC.menu.PLAIN_CENTERED.GetHeight() * 3 + 1);
        this.DrawATextBox(g, FC.menu.PLAIN_CENTERED, 0, FC.Text.Legal, (short)1, legalY, (short)FC.getWidth(), (short)(FC.menu.PLAIN_CENTERED.GetHeight() * 3), (short)0);
        legalY = (short)(legalY - 1);
        this.DrawATextBox(g, FC.menu.PLAIN_CENTERED, 0xFFFFFF, FC.Text.Legal, (short)0, legalY, (short)FC.getWidth(), (short)(FC.menu.PLAIN_CENTERED.GetHeight() * 3), (short)0);
    }

    public void MainMenu(Graphics g, FSCanvas FC) {
        if (FC.GameOver) {
            return;
        }
        this.DrawBackground(FC, g);
        this.DrawSam(FC, g);
        g.setClip(0, 0, FC.getWidth(), FC.getHeight());
        this.DrawCannon(FC, g);
        if (FC.GameState == 1) {
            g.setClip(0, 0, FC.getWidth(), FC.getHeight());
            String hiStr = String.valueOf(FC.Text.HIScore) + FC.levelData.HiScore;
            this.DrawATextBox(g, FC.menu.PLAIN_CENTERED, 0xFFFFFF, hiStr, (short)0, (short)(GamePositions.CurrentHeight - FC.menu.PLAIN_CENTERED.GetHeight()), GamePositions.CurrentWidth, (short)FC.menu.PLAIN_CENTERED.GetHeight(), (short)0);
        }
    }

    public void DrawTut(FSCanvas FC, Graphics g, int ind) {
        g.setColor(0);
        short h = (short)(FC.menu.PLAIN_CENTERED.GetHeight() * 4);
        g.fillRect(0, 0, (int)GamePositions.CurrentWidth, h + FC.menu.PLAIN_CENTERED.GetHeight() + FC.menu.PLAIN_CENTERED.GetHeight());
        byte by = this.TutScrollAmt = this.DrawATextBox(g, FC.menu.PLAIN_CENTERED, -1, FC.Text.Tut, (short)0, (short)5, GamePositions.CurrentWidth, h, (short)ind) ? (byte)0 : (byte)FC.menu.PLAIN_CENTERED.getLastNumLines();
        if (this.TutScrollAmt > 0) {
            g.setColor(0xCCCCFF);
            this.DrawUberTriangleVert(g, (GamePositions.CurrentWidth >> 1) - 5, h + FC.menu.PLAIN_CENTERED.GetHeight(), (byte)10, false);
        }
    }

    public void BlockyBackground(FSCanvas FC, Graphics g) {
        int i = 0;
        while (i < this.BlockPosition) {
            this.DrawBrick(FC, g, (FC.getWidth() >> 1) + FC.Positions.BrickTopStart - FC.Positions.BrickWidth / 2 * i, (FC.getHeight() >> 1) + FC.Positions.BrickTopHeight, 0, 2, true);
            ++i;
        }
        i = this.BlockPosition - 1;
        while (i >= 0) {
            this.DrawBrick(FC, g, (FC.getWidth() >> 1) + FC.Positions.BrickBottomStart + FC.Positions.BrickWidth / 2 * i, (FC.getHeight() >> 1) + FC.Positions.BrickBottomHeight, 0, 2, true);
            --i;
        }
        if (this.BlockPosition < this.BlockMax) {
            this.BlockPosition = (short)(this.BlockPosition + 2);
        }
    }

    public void Game(Graphics g, FSCanvas FC) {
        this.DrawBackground(FC, g);
        if (this.LevelCompleted) {
            g.setClip(0, -FSCanvas.OffsetY, FC.getWidth() * 7, FC.getHeight());
            this.DrawLevelCompleteGraphics(FC, g);
        } else {
            this.DrawBKTargets(FC, g);
            this.BallLogic(FC, g);
            g.setClip(0, -FSCanvas.OffsetY, FC.getWidth() * 7, FC.getHeight());
            this.DrawSam(FC, g);
            this.DrawCannon(FC, g);
            g.setClip(0, -FSCanvas.OffsetY, FC.getWidth() * 7, FC.getHeight());
            if (!FC.GP.Ball.isStop()) {
                this.DrawBall(FC, g);
            }
            this.DrawFGTargets(FC, g);
            this.DrawSplash(FC, g);
            this.DrawSmoke(FC, g);
            this.DrawPoints(FC, g);
            this.DrawInterface(FC, g);
            this.DrawPowerBar(FC, g, FC.GP.Velocity - 7);
            g.setClip(0, -FSCanvas.OffsetY, FC.getWidth() * 7, FC.getHeight());
            if (this.TutInd >= 0 && FSCanvas.OffsetX == 0) {
                this.DrawTut(FC, g, this.TutInd);
            }
            if (FC.GP.LevelDrawn) {
                this.DrawATextString(g, FC.menu.BOLD_CENTERED, 0xFFFF00, String.valueOf(FC.Text.LevelComplete[0]) + (FC.levelData.LevelNum + 1), (short)(GamePositions.CurrentWidth / 2 - FSCanvas.OffsetX), (short)(GamePositions.CurrentHeight / 2 - 15));
            }
            this.PowerUpAnimate();
        }
    }

    public void AdjustOffset(FSCanvas FC) {
        if (!FC.GP.Ball.isStop() && !FC.GP.HeadBack) {
            short BallLocation = FC.GP.Ball.CurX;
            int ScreenPosition = FSCanvas.OffsetX;
            int PosBallScrollsRight = FC.Positions.OffsetMaxX[0] - (FC.Positions.BasisWidth - GamePositions.CurrentWidth);
            byte PosBallScrollsLeft = FC.Positions.OffsetMaxX[1];
            int NewPosition = ScreenPosition;
            int MaxScroll = -FC.Positions.MaxX + FC.getWidth();
            byte MinScroll = FC.Positions.OffsetMaxX[2];
            short BallLocY = FC.GP.Ball.CurY;
            int ScreenPositionY = FSCanvas.OffsetY;
            if (BallLocation + ScreenPosition > PosBallScrollsRight && ScreenPosition > MaxScroll) {
                FSCanvas.OffsetX = PosBallScrollsRight - BallLocation;
            } else if (BallLocation + ScreenPosition < PosBallScrollsLeft && ScreenPosition < MinScroll) {
                FSCanvas.OffsetX = PosBallScrollsLeft - BallLocation;
            }
            if (20 - BallLocY > 0) {
                FSCanvas.OffsetY = 20 - BallLocY;
            } else if (FSCanvas.OffsetY > 0) {
                --FSCanvas.OffsetY;
            }
            if (FSCanvas.OffsetX > 0) {
                FSCanvas.OffsetX = 0;
            }
        }
    }

    public void DrawLevelCompleteGraphics(FSCanvas FC, Graphics g) {
        this.BlockyBackground(FC, g);
        if (this.BlockPosition == this.BlockMax) {
            g.setClip(0, 0, FC.getWidth(), FC.getHeight());
            this.DrawATextString(g, FC.menu.BOLD_CENTERED_MED, 0xFFFFFF, String.valueOf(FC.Text.LevelComplete[0]) + (FC.levelData.LevelNum + 1), (short)(FC.getWidth() >> 1), FC.Positions.LevelCompletePosY[0]);
            short y = FC.Positions.LevelCompletePosY[1];
            this.DrawATextString(g, FC.menu.BOLD, 0x6666FF, FC.Text.LevelComplete[1], (short)((FC.getWidth() >> 1) - FC.Positions.LevelCompleteDistance), y);
            this.DrawATextString(g, FC.menu.BOLD_RIGHT, 0xFFFFFF, "" + FC.levelData.Score, (short)((FC.getWidth() >> 1) + FC.Positions.LevelCompleteDistance), y);
            y = (short)(y + FC.menu.BOLD.GetHeight());
            this.DrawATextString(g, FC.menu.BOLD, 0x6666FF, FC.Text.LevelComplete[2], (short)((FC.getWidth() >> 1) - FC.Positions.LevelCompleteDistance), y);
            int Quality = FC.levelData.Shots / FC.levelData.Par;
            int color = 0xFFFFFF;
            color = Quality == 0 ? 65280 : (FC.levelData.Shots == FC.levelData.Par ? 0xFFFF00 : 0xFF0000);
            this.DrawATextString(g, FC.menu.BOLD_RIGHT, color, String.valueOf(FC.levelData.Shots) + FC.Text.LevelComplete[3] + FC.levelData.Par, (short)((FC.getWidth() >> 1) + FC.Positions.LevelCompleteDistance), y);
            y = (short)(y + FC.menu.BOLD.GetHeight());
            this.DrawATextString(g, FC.menu.BOLD, 0x9999FF, FC.Text.Coins, (short)((FC.getWidth() >> 1) - FC.Positions.LevelCompleteDistance), y);
            this.DrawATextString(g, FC.menu.BOLD_RIGHT, 0xFFFFFF, "" + FC.levelData.CoinsFound, (short)((FC.getWidth() >> 1) + FC.Positions.LevelCompleteDistance), y);
            this.PowerUpDraw(FC, g, (FC.getWidth() >> 1) + FC.Positions.LevelCompleteGFXPosX, y);
            this.PowerUpAnimate();
            g.setClip(0, 0, FC.getWidth(), FC.getHeight());
            y = (short)(y + (FC.Positions.HiddenCoinH > FC.menu.BOLD.GetHeight() ? FC.Positions.HiddenCoinH : FC.menu.BOLD.GetHeight()));
            this.DrawATextString(g, FC.menu.BOLD, 0x9999FF, FC.Text.Gems, (short)((FC.getWidth() >> 1) - FC.Positions.LevelCompleteDistance), y);
            this.DrawATextString(g, FC.menu.BOLD_RIGHT, 0xFFFFFF, "" + FC.levelData.SpecialFound, (short)((FC.getWidth() >> 1) + FC.Positions.LevelCompleteDistance), y);
            this.DrawAGraphic(g, FC.ImageData.HiddenCoin.MC, (FC.getWidth() >> 1) + FC.Positions.LevelCompleteGFXPosX, y, FC.Positions.HiddenCoinW, FC.Positions.HiddenCoinH, 0, 0);
            g.setClip(0, 0, FC.getWidth(), FC.getHeight());
        }
    }

    public void DrawUberTriangleVert(Graphics g, int x, int y, byte len, boolean isUp) {
        if (isUp) {
            x += len >> 1;
            byte i = 0;
            while (i <= len) {
                g.drawLine(x, y, x + i, y);
                --x;
                ++y;
                i = (byte)(i + 2);
            }
        } else {
            byte i = len;
            while (i > 0) {
                g.drawLine(x, y, x + i, y);
                ++x;
                ++y;
                i = (byte)(i - 2);
            }
        }
    }

    public void DrawPagesGraphics(FSCanvas FC, Graphics g, String title, String[] pages) {
        this.DrawBackground(FC, g);
        this.BlockyBackground(FC, g);
        if (this.BlockPosition == this.BlockMax) {
            g.setClip(0, 0, FC.getWidth(), FC.getHeight());
            this.DrawATextString(g, FC.menu.BOLD_CENTERED_MED, 0xFFFFFF, title, (short)(FC.getWidth() >> 1), FC.Positions.LevelCompletePosY[0]);
            FC.PgLinEnd = this.DrawATextBox(g, FC.menu.PLAIN_CENTERED, 0xAAAAFF, pages[FC.PgCur], (short)5, FC.Positions.LevelCompletePosY[1], (short)(FC.getWidth() - 10), (short)(FC.menu.PLAIN_CENTERED.GetHeight() * this.pagesHeightFactor), FC.PgLinCur);
            if (FC.PgLinCur > 0) {
                g.setColor(0xCCCCFF);
            } else {
                g.setColor(7237260);
            }
            this.DrawUberTriangleVert(g, (FC.getWidth() >> 1) - 9, GamePositions.CurrentHeight - FC.menu.BOLD_CENTERED.GetHeight() - 9, (byte)9, true);
            if (!FC.PgLinEnd) {
                g.setColor(0xCCCCFF);
            } else {
                g.setColor(7237260);
            }
            this.DrawUberTriangleVert(g, FC.getWidth() >> 1, GamePositions.CurrentHeight - FC.menu.BOLD_CENTERED.GetHeight() - 9, (byte)9, false);
            this.DrawATextString(g, FC.menu.BOLD_CENTERED, 0xFFFFFF, "(" + (FC.PgCur + 1) + "/" + pages.length + ")", (short)(FC.getWidth() >> 1), (short)(GamePositions.CurrentHeight - FC.menu.BOLD_CENTERED.GetHeight()));
        }
    }

    public void DrawConfirm(FSCanvas FC, Graphics g) {
        this.DrawBackground(FC, g);
        this.DrawATextString(g, FC.menu.BOLD_CENTERED, 0xFFFFFF, FC.Text.ExitConfirm, (short)(FC.getWidth() >> 1), (short)(FC.getHeight() >> 1));
    }

    public void DrawScrolingText(Graphics g, FSCanvas FC) {
        this.DrawATextBox(g, FC.menu.BOLD_CENTERED, 0xFFFFFF, FC.Text.Credits, (short)0, (short)(FC.getHeight() - this.CreditPos), (short)FC.getWidth(), (short)FC.getHeight(), this.CreditInd);
        if (FC.menu.BOLD_CENTERED.getLastNumLines() <= 1) {
            this.CreditPos = 0;
            this.CreditInd = 0;
        } else {
            this.CreditPos = (short)(this.CreditPos + 2);
            if (this.CreditPos > FC.getHeight() && this.CreditPos - FC.getHeight() >= FC.menu.BOLD_CENTERED.GetHeight()) {
                this.CreditPos = (short)FC.getHeight();
                this.CreditInd = (short)(this.CreditInd + 1);
            }
        }
    }

    public void Credits(FSCanvas FC, Graphics g) {
        this.DrawBackground(FC, g);
        g.setClip(0, 0, (int)GamePositions.CurrentWidth, (int)GamePositions.CurrentHeight);
        this.DrawScrolingText(g, FC);
        g.setColor(0);
        g.fillRect(0, 0, (int)GamePositions.CurrentWidth, GamePositions.CurrentHeight / 8);
    }

    public void ItsFullOfStars(FSCanvas FC, Graphics g) {
        if (FC.Positions.StarX == null) {
            return;
        }
        int i = 0;
        while (i < FC.Positions.StarX.length) {
            if (FC.Positions.StarY[i] < 100) {
                g.setColor(FC.ISRaining ? 0xAAAAAA : 0xFFFFFF);
            } else if (FC.Positions.StarY[i] > 99) {
                g.setColor(FC.ISRaining ? 0x101010 : 0xAAAAAA);
            } else {
                g.setColor(FC.ISRaining ? 0x101010 : 0xAAAAAA);
            }
            g.drawRect(FC.Positions.StarX[i] - FSCanvas.OffsetX * 9 / 10, FC.Positions.StarY[i] - FSCanvas.OffsetY * 9 / 10, 0, 0);
            ++i;
        }
        i = 0;
        while (i < FC.Positions.StarX.length) {
            if (FC.Positions.StarY[i] < 100) {
                g.setColor(FC.ISRaining ? 0xAAAAAA : 0xFFFFFF);
            } else if (FC.Positions.StarY[i] > 99) {
                g.setColor(FC.ISRaining ? 0x101010 : 0xAAAAAA);
            } else {
                g.setColor(FC.ISRaining ? 0x101010 : 0xAAAAAA);
            }
            short s = FC.Positions.StarX[i];
            FC.getClass();
            g.drawRect(s + GamePositions.CurrentWidth - FSCanvas.OffsetX * 9 / 10, FC.Positions.StarY[i] - FSCanvas.OffsetY * 9 / 10, 0, 0);
            ++i;
        }
        i = 0;
        while (i < FC.Positions.StarX.length) {
            g.setColor(FC.ISRaining ? 0xAAAAAA : 0xFFFFFF);
            g.drawRect(FC.Positions.StarX[i] - FSCanvas.OffsetX * 9 / 10, FC.Positions.StarY[i] - FSCanvas.OffsetY * 9 / 10 - FC.getHeight() / 2, 0, 0);
            ++i;
        }
    }

    public void DrawBackground(FSCanvas FC, Graphics g) {
        g.setClip(-FSCanvas.OffsetX, -FSCanvas.OffsetY, FC.getWidth(), FC.getHeight());
        g.setColor(789795);
        g.fillRect(-FSCanvas.OffsetX, -FSCanvas.OffsetY, FC.getWidth(), FC.getHeight());
        this.ItsFullOfStars(FC, g);
        int[] ShadeColors = new int[]{0x111144, 85, 0x111166, 6338752, 5083800, 4028027, 3169633};
        int i = 0;
        while (i < ShadeColors.length) {
            if (i == 3) {
                FC.ImageData.MenuImages[0].MC.y = FC.Positions.MoonY - FSCanvas.OffsetY * 3 / 4;
                FC.ImageData.MenuImages[0].MC.x = FC.Positions.MoonScrollX[0] - FSCanvas.OffsetX * FC.Positions.MoonScrollX[1] / FC.Positions.MoonScrollX[2];
                if (!FC.ISRaining && this.IsVisible(FC.ImageData.MenuImages[0].MC.x, FC.ImageData.MenuImages[0].MC.y, FC.ImageData.MenuImages[0].MC.GetWidth(), FC.ImageData.MenuImages[0].MC.GetHeight())) {
                    FC.ImageData.MenuImages[0].MC.setGraphics(g);
                    FC.ImageData.MenuImages[0].MC.enterFrame();
                }
                g.setColor(2574668);
                g.fillRect(-FSCanvas.OffsetX, (int)FC.Positions.WaterY, FC.getWidth(), (int)FC.Positions.WaterX);
            }
            g.setColor(ShadeColors[i]);
            g.fillRect(-FSCanvas.OffsetX, FC.Positions.WaterY + FC.Positions.ShadeY[i], FC.getWidth(), 2);
            ++i;
        }
        if (FC.ImageData.Land != null) {
            i = 0;
            while (i < FC.Positions.MountainPositionsX.length) {
                FC.ImageData.Land.MC.y = FC.Positions.MountainPositionY;
                FC.ImageData.Land.MC.x = FC.Positions.MountainPositionsX[i] - FSCanvas.OffsetX * FC.Positions.CloudScroll2X[0] / FC.Positions.CloudScroll2X[1];
                if (this.IsVisible(FC.ImageData.Land.MC.x, FC.ImageData.Land.MC.y, 34, FC.ImageData.Land.MC.GetHeight())) {
                    FC.ImageData.Land.MC.setGraphics(g);
                    FC.ImageData.Land.MC.enterFrame();
                }
                ++i;
            }
        }
        if (FC.ISRaining) {
            FC.draw.RainShower(g, FC, CannonBall.wndSpd);
        }
    }

    public void RainShower(Graphics g, FSCanvas FC, int WindSpeed) {
        int XScale = WindSpeed << 1;
        int Width = XScale < 0 ? -XScale : XScale;
        int DropX = XScale / 3;
        g.setClip(-FSCanvas.OffsetX, -FSCanvas.OffsetY, (int)GamePositions.CurrentWidth, (int)GamePositions.CurrentHeight);
        g.setColor(0xAAAAFF);
        int i = 0;
        while (i < this.RainDropsX.length) {
            int Y;
            if (WindSpeed > 0) {
                int n = i;
                this.RainDropsX[n] = (short)(this.RainDropsX[n] + (DropX + 1));
            } else if (WindSpeed < 0) {
                int n = i;
                this.RainDropsX[n] = (short)(this.RainDropsX[n] + (DropX - 1));
            }
            int n = i;
            this.RainDropsY[n] = (short)(this.RainDropsY[n] + 6);
            if (this.RainDropsX[i] < -10) {
                this.RainDropsX[i] = (short)(GamePositions.CurrentWidth + 10);
            }
            if (this.RainDropsX[i] > GamePositions.CurrentWidth + 10) {
                this.RainDropsX[i] = -10;
            }
            if (this.RainDropsY[i] > GamePositions.CurrentHeight) {
                this.RainDropsY[i] = -10;
            }
            int X = this.RainDropsX[i] - FSCanvas.OffsetX;
            if (this.IsVisible(XScale < 0 ? X + XScale : X, Y = this.RainDropsY[i] - FSCanvas.OffsetY, Width, 15)) {
                g.drawLine(X, Y, X + XScale, Y + 15);
            }
            ++i;
        }
    }

    public void DrawSmoke(FSCanvas FC, Graphics g) {
        int i = 0;
        while (i < 5) {
            if (FC.GP.SmokeTime[i] > 0) {
                int n = i;
                FC.GP.SmokeTime[n] = (byte)(FC.GP.SmokeTime[n] - 1);
                if (FC.GP.SmokeTime[i] == 0 && FC.GP.SmokeCurFrame[i] < 3) {
                    int n2 = i;
                    FC.GP.SmokeCurFrame[n2] = (byte)(FC.GP.SmokeCurFrame[n2] + 1);
                    FC.GP.SmokeTime[i] = FC.GP.SmokeFrames;
                }
                FC.ImageData.Smoke.MC.x = FC.GP.SmokeX[i];
                FC.ImageData.Smoke.MC.y = FC.GP.SmokeY[i] - FC.GP.SmokeCurFrame[i] * FC.Positions.SmokeHeight;
                g.setClip((int)FC.GP.SmokeX[i], (int)FC.GP.SmokeY[i], (int)FC.Positions.SmokeWidth, (int)FC.Positions.SmokeHeight);
                FC.ImageData.Smoke.MC.setGraphics(g);
                FC.ImageData.Smoke.MC.enterFrame();
            }
            ++i;
        }
    }

    public void DrawBucket(FSCanvas FC, Graphics g, int X, int Y, int TYPE, int ID, boolean Overide) {
        byte Flag = FC.levelData.GetLevel().Flags[ID];
        if (Flag != 0 && !Overide) {
            return;
        }
        switch (TYPE) {
            case 1: {
                break;
            }
            case 31: {
                this.DrawAGraphic(g, FC.ImageData.GameImages[2].MC, X, Y + FC.Positions.CannonAdjY, FC.Positions.FlatTargetWidth, FC.Positions.FlatTargetHeight, 0, FC.Positions.FlatTargetHeight * 2);
                break;
            }
            case 32: {
                this.DrawAGraphic(g, FC.ImageData.GameImages[2].MC, X, Y + FC.Positions.CannonAdjY, FC.Positions.FlatTargetWidth, FC.Positions.FlatTargetHeight, 0, FC.Positions.FlatTargetHeight);
            }
        }
        g.setClip(X, Y, (int)FC.Positions.RealBucketWidth, (int)FC.Positions.RealBucketHeight);
        if (this.IsVisible(X, Y, FC.ImageData.GameImages[0].MC.GetWidth(), FC.ImageData.GameImages[0].MC.GetHeight())) {
            FC.ImageData.GameImages[0].MC.x = X;
            FC.ImageData.GameImages[0].MC.y = Y;
            FC.ImageData.GameImages[0].MC.setGraphics(g);
            FC.ImageData.GameImages[0].MC.enterFrame();
        }
        if (FC.SHOWBOUNDINGBOXES) {
            int i = 0;
            while (i < FC.Positions.BucketX.length) {
                g.drawRect(X + FC.Positions.BucketX[i], Y + FC.Positions.BucketY[i], (int)FC.Positions.BucketW[i], (int)FC.Positions.BucketH[i]);
                ++i;
            }
        }
    }

    public void DrawFlatRedTarget(FSCanvas FC, Graphics g, int X, int Y, int ID) {
        if (this.IsVisible(X, Y, FC.Positions.FlatTargetWidth, FC.Positions.FlatTargetHeight)) {
            FC.ImageData.GameImages[2].MC.setGraphics(g);
            FC.ImageData.GameImages[2].MC.x = X;
            FC.ImageData.GameImages[2].MC.y = Y;
            g.setClip(X, FC.ImageData.GameImages[2].MC.y, (int)FC.Positions.FlatTargetWidth, (int)FC.Positions.FlatTargetHeight);
            FC.ImageData.GameImages[2].MC.enterFrame();
        }
    }

    public void DrawYBSwitch(FSCanvas FC, Graphics g, int X, int Y, int ID) {
        if (this.IsVisible(X, Y, FC.Positions.FlatTargetWidth, FC.Positions.FlatTargetHeight)) {
            switch (FC.levelData.GetLevel().Flags[ID]) {
                case 0: {
                    FC.ImageData.GameImages[2].MC.setGraphics(g);
                    FC.ImageData.GameImages[2].MC.x = X;
                    int tempY = FC.ImageData.GameImages[2].MC.y = Y;
                    g.setClip(X, tempY, (int)FC.Positions.FlatTargetWidth, (int)FC.Positions.FlatTargetHeight);
                    FC.ImageData.GameImages[2].MC.y -= FC.Positions.FlatTargetHeight * 2;
                    FC.ImageData.GameImages[2].MC.enterFrame();
                    g.setClip(X + FC.Positions.FlatTargetWidth / 2, tempY, FC.Positions.FlatTargetWidth / 2, (int)FC.Positions.FlatTargetHeight);
                    FC.ImageData.GameImages[2].MC.y += FC.Positions.FlatTargetHeight;
                    FC.ImageData.GameImages[2].MC.enterFrame();
                    break;
                }
                case 1: {
                    FC.ImageData.GameImages[2].MC.setGraphics(g);
                    FC.ImageData.GameImages[2].MC.x = X;
                    FC.ImageData.GameImages[2].MC.y = Y;
                    g.setClip(X, Y, (int)FC.Positions.FlatTargetWidth, (int)FC.Positions.FlatTargetHeight);
                    FC.ImageData.GameImages[2].MC.enterFrame();
                }
            }
        }
    }

    public void DrawColorChangeTarget(FSCanvas FC, Graphics g, int X, int Y, int ID, int ColorID) {
        if (this.IsVisible(X, Y, FC.Positions.FlatTargetWidth, FC.Positions.FlatTargetHeight)) {
            switch (FC.levelData.GetLevel().Flags[ID]) {
                case 0: {
                    FC.ImageData.GameImages[2].MC.setGraphics(g);
                    FC.ImageData.GameImages[2].MC.x = X;
                    FC.ImageData.GameImages[2].MC.y = Y;
                    g.setClip(X, FC.ImageData.GameImages[2].MC.y, (int)FC.Positions.FlatTargetWidth, (int)FC.Positions.FlatTargetHeight);
                    FC.ImageData.GameImages[2].MC.y -= FC.Positions.FlatTargetHeight * ColorID;
                    FC.ImageData.GameImages[2].MC.enterFrame();
                    break;
                }
                case 1: {
                    FC.ImageData.GameImages[2].MC.setGraphics(g);
                    FC.ImageData.GameImages[2].MC.x = X;
                    FC.ImageData.GameImages[2].MC.y = Y;
                    g.setClip(X, FC.ImageData.GameImages[2].MC.y, (int)FC.Positions.FlatTargetWidth, (int)FC.Positions.FlatTargetHeight);
                    FC.ImageData.GameImages[2].MC.enterFrame();
                }
            }
        }
    }

    public void Draw45Target(FSCanvas FC, Graphics g, int X, int Y, int ID) {
        if (this.IsVisible(X, Y, FC.Positions.AngleTargetWidth, FC.Positions.AngleTargetHeight)) {
            FC.ImageData.GameImages[1].MC.setGraphics(g);
            FC.ImageData.GameImages[1].MC.x = X;
            FC.ImageData.GameImages[1].MC.y = Y;
            g.setClip(FC.ImageData.GameImages[1].MC.x, FC.ImageData.GameImages[1].MC.y, (int)FC.Positions.AngleTargetWidth, (int)FC.Positions.AngleTargetHeight);
            FC.ImageData.GameImages[1].MC.enterFrame();
            if (FC.SHOWBOUNDINGBOXES) {
                g.setColor(0xFF0000);
                int i = 0;
                while (i < FC.Positions.BoxDimAT11_X.length) {
                    g.drawRect(X + FC.Positions.BoxDimAT11_X[i], Y + FC.Positions.BoxDimAT11_Y[i], (int)FC.Positions.BoxDimAT11_W[i], (int)FC.Positions.BoxDimAT11_H[i]);
                    ++i;
                }
            }
        }
    }

    public void DrawPoints(FSCanvas FC, Graphics g) {
        if (this.PointsTimer < 15) {
            g.setClip(0, -FSCanvas.OffsetY, FC.getWidth() * 7, FC.getHeight());
            FC.menu.BOLD.Color = 42211;
            FC.menu.BOLD.PosX = this.PointsX;
            FC.menu.BOLD.PosY = (short)(this.PointsY - this.PointsTimer);
            FC.menu.BOLD.Txt = "+" + this.PointsValue;
            FC.menu.BOLD.Draw(g);
            this.PointsTimer = (byte)(this.PointsTimer + 1);
        }
    }

    public void DrawBrick(FSCanvas FC, Graphics g, int X, int Y, int ID, int BrickID, boolean Override) {
        if ((FC.levelData.GetLevel() != null && FC.levelData.GetLevel().Flags[ID] == 0 || Override) && this.IsVisible(X, Y, FC.Positions.BrickWidth, FC.Positions.BrickHeight)) {
            FC.ImageData.MenuImages[2].MC.setGraphics(g);
            g.setClip(X, Y, (int)FC.Positions.BrickWidth, (int)FC.Positions.BrickHeight);
            FC.ImageData.MenuImages[2].MC.x = X;
            FC.ImageData.MenuImages[2].MC.y = Y - BrickID * FC.Positions.BrickHeight;
            FC.ImageData.MenuImages[2].MC.enterFrame();
            if (FC.SHOWBOUNDINGBOXES) {
                g.setColor(0xFF0000);
                int i = 0;
                while (i < FC.Positions.BrickRegionX.length) {
                    g.drawRect(FC.Positions.BrickRegionX[i] + X, FC.Positions.BrickRegionY[i] + Y, (int)FC.Positions.BrickRegionW[i], (int)FC.Positions.BrickRegionH[i]);
                    ++i;
                }
            }
        }
    }

    public void DrawWideBrick(FSCanvas FC, Graphics g, int X, int Y, int ID, int BrickID) {
        if (FC.levelData.GetLevel().Flags[ID] == 0 && this.IsVisible(X, Y, FC.Positions.BrickWidth * 3, FC.Positions.BrickHeight)) {
            FC.ImageData.MenuImages[2].MC.setGraphics(g);
            int i = 3;
            while (i > -1) {
                g.setClip(X + i * FC.Positions.BrickWidth / 2, Y, (int)FC.Positions.BrickWidth, (int)FC.Positions.BrickHeight);
                FC.ImageData.MenuImages[2].MC.x = X + i * FC.Positions.BrickWidth / 2;
                FC.ImageData.MenuImages[2].MC.y = Y - BrickID * FC.Positions.BrickHeight;
                FC.ImageData.MenuImages[2].MC.enterFrame();
                --i;
            }
            if (FC.SHOWBOUNDINGBOXES) {
                g.setColor(0xFF0000);
                g.setClip(X, Y, (int)FC.Positions.BrickWideWidth, (int)FC.Positions.BrickWideHeight);
                i = 0;
                while (i < FC.Positions.BrickWideRegionX.length) {
                    g.drawRect(FC.Positions.BrickWideRegionX[i] + X, FC.Positions.BrickWideRegionY[i] + Y, (int)FC.Positions.BrickWideRegionW[i], (int)FC.Positions.BrickWideRegionH[i]);
                    ++i;
                }
            }
        }
    }

    public void DrawTallBrick(FSCanvas FC, Graphics g, int X, int Y, int ID, int BrickID) {
        if (FC.levelData.GetLevel().Flags[ID] == 0 && this.IsVisible(X, Y, FC.Positions.BrickWidth, FC.Positions.BrickHeight * 3)) {
            FC.ImageData.MenuImages[2].MC.setGraphics(g);
            int i = 3;
            while (i > -1) {
                g.setClip(X, Y + i * FC.Positions.BrickHeight / 2, (int)FC.Positions.BrickWidth, (int)FC.Positions.BrickHeight);
                FC.ImageData.MenuImages[2].MC.x = X;
                FC.ImageData.MenuImages[2].MC.y = Y - BrickID * FC.Positions.BrickHeight + i * FC.Positions.BrickHeight / 2;
                FC.ImageData.MenuImages[2].MC.enterFrame();
                --i;
            }
            if (FC.SHOWBOUNDINGBOXES) {
                g.setColor(0xFF0000);
                g.setClip(X, Y, (int)FC.Positions.BrickTallWidth, (int)FC.Positions.BrickTallHeight);
                i = 0;
                while (i < FC.Positions.BrickTallRegionX.length) {
                    g.drawRect(FC.Positions.BrickTallRegionX[i] + X, FC.Positions.BrickTallRegionY[i] + Y, (int)FC.Positions.BrickTallRegionW[i], (int)FC.Positions.BrickTallRegionH[i]);
                    ++i;
                }
            }
        }
    }

    public void DrawBKTargets(FSCanvas FC, Graphics g) {
        int i = 0;
        while (i < FC.levelData.GetLevel().ObjectIDList.length) {
            switch (FC.levelData.GetLevel().ObjectIDList[i]) {
                case 1: {
                    this.DrawBucket(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], FC.levelData.GetLevel().ObjectIDList[i], i, false);
                    break;
                }
                case 2: {
                    this.DrawFlatRedTarget(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i);
                    break;
                }
                case 3: {
                    this.Draw45Target(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i);
                    break;
                }
                case 11: {
                    this.DrawColorChangeTarget(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 2);
                    break;
                }
                case 12: {
                    this.DrawColorChangeTarget(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 1);
                    break;
                }
                case 14: {
                    this.DrawBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 3, false);
                    break;
                }
                case 15: {
                    this.DrawBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 1, false);
                    break;
                }
                case 16: {
                    this.DrawBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 0, false);
                    break;
                }
                case 17: {
                    this.DrawBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 2, false);
                    break;
                }
                case 18: {
                    this.DrawYBSwitch(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i);
                    break;
                }
                case 20: {
                    this.DrawWideBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 1);
                    break;
                }
                case 21: {
                    this.DrawWideBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 0);
                    break;
                }
                case 22: {
                    this.DrawWideBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 2);
                    break;
                }
                case 23: {
                    this.DrawTallBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 1);
                    break;
                }
                case 24: {
                    this.DrawTallBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 0);
                    break;
                }
                case 25: {
                    this.DrawTallBrick(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, 2);
                    break;
                }
                case 31: {
                    this.DrawBucket(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], FC.levelData.GetLevel().ObjectIDList[i], i, false);
                    break;
                }
                case 32: {
                    this.DrawBucket(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], FC.levelData.GetLevel().ObjectIDList[i], i, false);
                }
            }
            ++i;
        }
    }

    public void PowerUpDraw(FSCanvas FC, Graphics g, int x, int y) {
        if (this.IsVisible(x, y, FC.Positions.PowerupWidth, FC.Positions.PowerUpHeight)) {
            g.setClip(x, y, (int)FC.Positions.PowerupWidth, (int)FC.Positions.PowerUpHeight);
            FC.ImageData.GameImages[3].MC.setGraphics(g);
            FC.ImageData.GameImages[3].MC.x = x;
            FC.ImageData.GameImages[3].MC.y = y - this.PowerAni[this.PowerAniFrame] * FC.Positions.PowerUpHeight;
            FC.ImageData.GameImages[3].MC.enterFrame();
        }
    }

    public void PowerUpAnimate() {
        this.PowerAniFrame = this.PowerAniFrame < this.PowerAni.length - 1 ? (byte)(this.PowerAniFrame + 1) : (byte)0;
    }

    public void DrawFGTargets(FSCanvas FC, Graphics g) {
        int i = 0;
        while (i < FC.levelData.GetLevel().ObjectIDList.length) {
            switch (FC.levelData.GetLevel().ObjectIDList[i]) {
                case 98: 
                case 99: {
                    if (FC.levelData.GetLevel().Flags[i] != 0) break;
                    this.PowerUpDraw(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i]);
                    break;
                }
                case 100: {
                    this.DrawHiddenCoin(FC, g, FC.levelData.GetLevel().ObjX[i], FC.levelData.GetLevel().ObjY[i], i, false);
                }
            }
            ++i;
        }
    }

    public void BallLogic(FSCanvas FC, Graphics g) {
        if (FC.GP.HeadBack) {
            FC.GP.MoveScreenLeft = false;
            FC.GP.MoveScreenRight = false;
        }
        if (!FC.GP.Ball.isStop() && !FC.GP.HeadBack) {
            FC.GP.Logic(this, FC, g);
            if (!FC.GP.Ball.Draw(g, FC)) {
                FC.GP.AnimationActive = true;
            }
            if (FC.GP.Ball.Time < 8) {
                this.DrawBall(FC, g);
            }
        }
        if (this.CycleTimer < 6) {
            this.CycleTimer = (byte)(this.CycleTimer + 1);
        } else {
            if (FC.levelData.GetLevel().CycleArray.length > 1) {
                FC.GP.CycleBrick(FC);
            }
            this.CycleTimer = 0;
        }
    }

    public void DrawBall(FSCanvas FC, Graphics g) {
        g.setClip(FC.ImageData.MenuImages[3].MC.x, FC.ImageData.MenuImages[3].MC.y, (int)FC.Positions.BallWidth, (int)FC.Positions.BallHeight);
        if (FC.ImageData.MenuImages[3].MC.y < GamePositions.CurrentHeight - 8) {
            FC.ImageData.MenuImages[3].MC.setGraphics(g);
            FC.ImageData.MenuImages[3].MC.enterFrame();
        }
    }

    public void DrawCannon(FSCanvas FC, Graphics g) {
        if (this.IsVisible(FC.Positions.CannonStartX, FC.Positions.CannonStartY + this.SamOffset, FC.Positions.CannonWidth, FC.Positions.CannonHeight)) {
            g.setClip((int)FC.Positions.CannonStartX, FC.Positions.CannonStartY + this.SamOffset, (int)FC.Positions.CannonWidth, (int)FC.Positions.CannonHeight);
            FC.ImageData.MenuImages[4].MC.x = FC.Positions.CannonStartX;
            FC.ImageData.MenuImages[4].MC.y = FC.Positions.CannonStartY + this.SamOffset;
            FC.ImageData.MenuImages[4].MC.y -= this.CannonPos * FC.Positions.CannonHeight;
            FC.ImageData.MenuImages[4].MC.setGraphics(g);
            FC.ImageData.MenuImages[4].MC.enterFrame();
        }
    }

    public void DrawSam(FSCanvas FC, Graphics g) {
        if (this.SamTimer < 4) {
            this.SamTimer = (byte)(this.SamTimer + 1);
        } else {
            this.SamTimer = 0;
            if (this.SamDown) {
                if (this.SamOffset < 4) {
                    this.SamOffset = (byte)(this.SamOffset + 1);
                } else {
                    this.SamDown = false;
                }
            } else if (this.SamOffset > 0) {
                this.SamOffset = (byte)(this.SamOffset - 1);
            } else {
                this.SamDown = true;
            }
        }
        this.DrawAGraphic(g, FC.ImageData.MenuImages[1].MC, FC.Positions.SamX, FC.Positions.SamY + this.SamOffset, GamePositions.CurrentWidth, GamePositions.CurrentHeight, 0, 0);
    }

    public void DrawInterface(FSCanvas FC, Graphics g) {
        g.setClip(-FSCanvas.OffsetX, -FSCanvas.OffsetY, FC.getWidth(), FC.getHeight());
        int XOffset = FC.Positions.BasisWidth - GamePositions.CurrentWidth;
        FC.menu.BOLD.PosX = (short)(FC.Positions.GHUDX[0] - FSCanvas.OffsetX);
        FC.menu.BOLD.PosY = (short)(FC.Positions.GHUDY[0] - FSCanvas.OffsetY);
        FC.menu.BOLD_RIGHT.PosX = (short)(FC.Positions.GHUDX[1] - FSCanvas.OffsetX - XOffset);
        FC.menu.BOLD_RIGHT.PosY = (short)(FC.Positions.GHUDY[1] - FSCanvas.OffsetY);
        FC.menu.BOLD.Color = 0xFFFFFF;
        FC.menu.BOLD_RIGHT.Color = 0xFFFFFF;
        FC.menu.BOLD.Txt = "" + FC.levelData.Score;
        FC.menu.BOLD.Draw(g);
        FC.menu.BOLD_RIGHT.Txt = String.valueOf(FC.levelData.Shots) + "/" + FC.levelData.Par;
        FC.menu.BOLD_RIGHT.Draw(g);
        if (FC.GP.bGemCollected || FC.levelData.CheckLevelGemFlag()) {
            FC.ImageData.GemCheck.MC.x = (FC.getWidth() >> 1) - (FC.ImageData.GemCheck.MC.GetWidth() >> 1) - FSCanvas.OffsetX;
            FC.ImageData.GemCheck.MC.y = FC.menu.BOLD.PosY;
            FC.ImageData.GemCheck.MC.setGraphics(g);
            FC.ImageData.GemCheck.MC.enterFrame();
        }
    }

    public void Ball(FSCanvas FC, Graphics g, int x, int y, int ID) {
        int OldX = FC.ImageData.MenuImages[3].MC.x;
        int OldY = FC.ImageData.MenuImages[3].MC.y;
        this.DrawAGraphic(g, FC.ImageData.MenuImages[3].MC, x, y, FC.Positions.BallWidth, FC.Positions.BallHeight, 0, ID * FC.Positions.BallHeight);
        FC.ImageData.MenuImages[3].MC.x = OldX;
        FC.ImageData.MenuImages[3].MC.y = OldY;
    }

    public void DrawPowerBar(FSCanvas FC, Graphics g, int CurPower) {
        this.DrawAGraphic(g, FC.ImageData.PowerBar[0].MC, this.XGrid * FC.Positions.GridSizeX + FC.Positions.PowerBarX, -this.YGrid * FC.Positions.GridSizeY + FC.Positions.GridB - FC.Positions.GridSizeY, GamePositions.CurrentWidth, GamePositions.CurrentHeight, 0, 0);
        int i = 0;
        while (i < FC.levelData.numMarks) {
            this.DrawAGraphic(g, FC.ImageData.PowerBar[1].MC, this.MarksX[i] * FC.Positions.GridSizeX + FC.Positions.PowerBarX, -this.MarksY[i] * FC.Positions.GridSizeY + FC.Positions.GridB - FC.Positions.GridSizeY, GamePositions.CurrentWidth, GamePositions.CurrentHeight, 0, 0);
            ++i;
        }
        if (this.XGrid > 1) {
            this.DrawAGraphic(g, FC.ImageData.PowerBar[2].MC, FC.Positions.PowerBarHX, FC.Positions.PowerBarHY, this.XGrid / 2 * 2 + 1, FC.Positions.PowerBarHeight, 0, 0);
        }
        if (this.YGrid > 1) {
            g.setClip((int)FC.Positions.PowerBarWX, FC.Positions.PowerBarWY + FC.Positions.PowerBarLength - this.YGrid / 2 * 2 - 1, (int)FC.Positions.PowerBarHeight, (int)FC.Positions.PowerBarLength);
            FC.ImageData.PowerBar[3].MC.x = FC.Positions.PowerBarWX;
            FC.ImageData.PowerBar[3].MC.y = FC.Positions.PowerBarWY;
            FC.ImageData.PowerBar[3].MC.setGraphics(g);
            FC.ImageData.PowerBar[3].MC.enterFrame();
        }
    }

    public void DrawSplash(FSCanvas FC, Graphics g) {
        if (!FC.GP.Ball.isStop()) {
            if (FC.GP.AnimationActive && FC.GP.Ball.AniNum < 4) {
                if (FC.GP.Ball.AniNum == 0) {
                    FC.GP.Ball.SplashLoc = (short)(FC.GP.Ball.CurX - FC.Positions.SplashOffsetX);
                }
                FC.ImageData.Splash.MC.x = FC.GP.Ball.SplashLoc;
                g.setClip(FC.ImageData.Splash.MC.x, (int)FC.Positions.SplashY, (int)FC.Positions.SplashWidth, (int)FC.Positions.SplashHeight);
                FC.ImageData.Splash.MC.y = FC.Positions.SplashY - FC.GP.Ball.AniNum * FC.Positions.SplashHeight;
                FC.ImageData.Splash.MC.setGraphics(g);
                FC.ImageData.Splash.MC.enterFrame();
                FC.GP.Ball.AniNum = (byte)(FC.GP.Ball.AniNum + 1);
            } else if (FC.GP.AnimationActive && FC.GP.Ball.AniNum >= 4) {
                FC.GP.Ball.AniNum = 0;
                FC.GP.AnimationActive = false;
                FC.GP.Ball.stop();
                FC.GP.HeadBack = true;
            }
        }
    }

    public boolean IsVisible(int X, int Y, int ClipW, int ClipH) {
        return X + ClipW + FSCanvas.OffsetX >= 0 && X + FSCanvas.OffsetX <= GamePositions.CurrentWidth && Y + ClipH + FSCanvas.OffsetY >= 0 && Y + FSCanvas.OffsetY <= GamePositions.CurrentHeight;
    }

    public void DrawAGraphic(Graphics g, ASMovieClip MC, int X, int Y, int ClipW, int ClipH, int OffsetX, int OffsetY) {
        if (this.IsVisible(X, Y, ClipW, ClipH)) {
            g.setClip(X, Y, ClipW, ClipH);
            MC.x = X - OffsetX;
            MC.y = Y - OffsetY;
            MC.setGraphics(g);
            MC.enterFrame();
        }
    }

    public void DrawATextString(Graphics g, ASFont font, int color, String Text, short X, short Y) {
        font.Color = color;
        font.Txt = Text;
        font.PosX = X;
        font.PosY = Y;
        font.Draw(g);
    }

    public boolean DrawATextBox(Graphics g, ASFont font, int color, String Text, short X, short Y, short w, short h, short lineInd) {
        font.Color = color;
        font.Txt = Text;
        font.PosX = X;
        font.PosY = Y;
        return font.printBox(g, w, h, lineInd);
    }
}

