/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.util.Random;
import net.handyx.casinopack.videopoker.Card;
import net.handyx.casinopack.videopoker.Common;

public class Deck {
    private Random r = null;
    private Card[] deck = new Card[52];
    private int deckIndex = 0;

    public Deck() {
        int idx = 0;
        for (int suit = 0; suit < 4; ++suit) {
            for (int rank = 0; rank < 13; ++rank) {
                this.deck[idx++] = new Card(rank + 1, suit);
            }
        }
    }

    public void shuffle() {
        Card[] newDeck = new Card[52];
        int idx = 0;
        for (int i = 0; i < 52; ++i) {
            idx = this._random(52);
            while (this.deck[idx] == null) {
                idx = this._random(52);
            }
            newDeck[i] = new Card(this.deck[idx].getRank(), this.deck[idx].getSuit());
            this.deck[idx] = null;
        }
        this.deckIndex = 0;
        this.deck = newDeck;
        Common.log("Shuffling deck ...");
    }

    public Card deal() {
        if (this.deckIndex == 52) {
            this.shuffle();
        }
        return this.deck[this.deckIndex++];
    }

    public Card nextCard() {
        return this.deck[this.deckIndex];
    }

    public int _random(int max) {
        if (max == 0) {
            System.out.println("Sanity check " + max);
            return 0;
        }
        if (this.r == null) {
            this.r = new Random();
        }
        return Math.abs(this.r.nextInt() % max);
    }
}

