/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.CasinoPack;
import net.handyx.casinopack.common.LoadingScreen;
import net.handyx.casinopack.slots.Common;
import net.handyx.casinopack.slots.FruityFrenzyMachine;
import net.handyx.casinopack.slots.JuicyFruityMachine;
import net.handyx.casinopack.slots.MachineCanvas;
import net.handyx.casinopack.slots.MenuCanvas;
import net.handyx.casinopack.slots.RedWhiteBlueMachine;
import net.handyx.casinopack.slots.TwentyOneMachine;

public final class Slots
implements Runnable {
    public static final int INIT = 0;
    public static final int MAIN_MENU = 1;
    public static final int RESUME_GAME = 3;
    public static final int MACHINE_SELECTOR = 4;
    public static final int LOAD_MACHINE = 5;
    public int loadingStage = 0;
    public Display display;
    public MenuCanvas menuCanvas;
    public LoadingScreen loadingScreen;
    public FruityFrenzyMachine fruityFrenzyMachine;
    public RedWhiteBlueMachine redWhiteBlueMachine;
    public TwentyOneMachine twentyOneMachine;
    public JuicyFruityMachine juicyFruityMachine;
    public MachineCanvas slotMachineCanvas;
    public CasinoPack parent = null;

    public Slots(CasinoPack p) {
        this.parent = p;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.loadingScreen = new LoadingScreen();
        this.doLoadingStage(0);
    }

    public void purgeResources() {
        Common.purgeResources();
        this.slotMachineCanvas.purgeResources();
        this.slotMachineCanvas = null;
        this.menuCanvas.purgeResources();
        this.menuCanvas = null;
        this.fruityFrenzyMachine = null;
        this.redWhiteBlueMachine = null;
        this.twentyOneMachine = null;
        this.juicyFruityMachine = null;
        this.loadingScreen = null;
        System.gc();
    }

    public void doLoadingStage(int stage) {
        if (stage != 5) {
            this.display.setCurrent((Displayable)this.loadingScreen);
        }
        this.loadingStage = stage;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            while (this.loadingStage != 5 && this.display.getCurrent() != this.loadingScreen) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {}
            }
            if (this.loadingStage == 0) {
                Common.loadResources();
                this.menuCanvas = new MenuCanvas(this);
                this.menuCanvas.loadSettings();
                this.fruityFrenzyMachine = new FruityFrenzyMachine();
                this.fruityFrenzyMachine.loadHighestScore();
                this.fruityFrenzyMachine.calculateStats();
                this.redWhiteBlueMachine = new RedWhiteBlueMachine();
                this.redWhiteBlueMachine.loadHighestScore();
                this.redWhiteBlueMachine.calculateStats();
                this.twentyOneMachine = new TwentyOneMachine();
                this.twentyOneMachine.loadHighestScore();
                this.twentyOneMachine.calculateStats();
                this.juicyFruityMachine = new JuicyFruityMachine();
                this.juicyFruityMachine.loadHighestScore();
                this.juicyFruityMachine.calculateStats();
                this.slotMachineCanvas = new MachineCanvas(this);
                this.slotMachineCanvas.addMachine(this.juicyFruityMachine);
                this.slotMachineCanvas.addMachine(this.redWhiteBlueMachine);
                this.slotMachineCanvas.addMachine(this.twentyOneMachine);
                this.slotMachineCanvas.addMachine(this.fruityFrenzyMachine);
                this.slotMachineCanvas.loadGameState();
                this.menuCanvas.loadResources();
                this.display.setCurrent((Displayable)this.menuCanvas);
            } else if (this.loadingStage == 1) {
                Common.resetFontCache();
                this.slotMachineCanvas.purgeResources();
                System.gc();
                this.menuCanvas.loadResources();
                this.display.setCurrent((Displayable)this.menuCanvas);
            } else if (this.loadingStage == 4) {
                Common.resetFontCache();
                this.menuCanvas.purgeResources();
                System.gc();
                this.slotMachineCanvas.reset();
                this.slotMachineCanvas.setDisplay(0);
                this.slotMachineCanvas.loadResources();
                this.display.setCurrent((Displayable)this.slotMachineCanvas);
            } else if (this.loadingStage == 3) {
                Common.resetFontCache();
                this.menuCanvas.purgeResources();
                System.gc();
                this.slotMachineCanvas.loadResources();
                this.slotMachineCanvas.loadInGameResources();
                this.display.setCurrent((Displayable)this.slotMachineCanvas);
            } else if (this.loadingStage == 5) {
                Common.resetFontCache();
                this.slotMachineCanvas.loadInGameResources();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startNewGame() {
        this.doLoadingStage(4);
    }

    public void loadMachine() {
        this.doLoadingStage(5);
    }

    public void resumeGame() {
        this.doLoadingStage(3);
    }

    public void displayMainMenu() {
        this.doLoadingStage(1);
    }

    public void exitApplication() {
        this.menuCanvas.saveSettings();
        this.parent.displaySelector();
    }

    public void startApp() {
    }

    public void pauseApp() {
    }
}

