/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.slots.Machine;
import net.handyx.casinopack.slots.Strings;

public final class RedWhiteBlueMachine
extends Machine {
    public static final int BLANK = 0;
    public static final int BAR_1_RED = 1;
    public static final int BAR_2_WHITE = 2;
    public static final int BAR_3_BLUE = 3;
    public static final int SEVEN_RED = 4;
    public static final int SEVEN_WHITE = 5;
    public static final int SEVEN_BLUE = 6;
    public static final String[] ITEM_NAMES = new String[]{"Blank", "Bar Red", "Bar White", "Bar Blue", "Seven Red", "Seven White", "Seven Blue"};
    private static final int REEL_ITEM = 0;
    private final int[][] REEL = new int[][]{{2, 4, 2, 3}, {0, 2, 2, 3}, {3, 2, 2, 1}, {0, 3, 3, 4}, {5, 6, 1, 6}, {0, 1, 1, 3}, {1, 3, 4, 5}, {0, 5, 3, 4}, {6, 6, 7, 1}, {0, 3, 5, 1}, {2, 2, 2, 4}, {0, 2, 2, 3}, {3, 2, 2, 2}, {0, 4, 4, 4}, {4, 1, 3, 1}, {0, 1, 4, 1}, {3, 3, 3, 3}, {0, 2, 2, 2}, {2, 2, 2, 4}, {0, 5, 3, 2}, {1, 3, 4, 4}, {0, 2, 3, 3}};
    private int[] BW = new int[]{1, 2, 4, 8, 16, 32, 64};
    private final int[][] PAYOUTS = new int[][]{{this.BW[4], this.BW[5], this.BW[6], 2400, 4800, 8000}, {this.BW[4], this.BW[4], this.BW[4], 1200, 2400, 4000}, {this.BW[5], this.BW[5], this.BW[5], 200, 400, 600}, {this.BW[6], this.BW[6], this.BW[6], 150, 300, 450}, {this.BW[4] | this.BW[6] | this.BW[5], this.BW[4] | this.BW[6] | this.BW[5], this.BW[4] | this.BW[6] | this.BW[5], 80, 160, 240}, {this.BW[1], this.BW[2], this.BW[3], 50, 100, 150}, {this.BW[3], this.BW[3], this.BW[3], 40, 80, 120}, {this.BW[2], this.BW[2], this.BW[2], 25, 50, 75}, {this.BW[4] | this.BW[1], this.BW[5] | this.BW[2], this.BW[6] | this.BW[3], 20, 40, 60}, {this.BW[1], this.BW[1], this.BW[1], 10, 20, 30}, {this.BW[1] | this.BW[2] | this.BW[3], this.BW[1] | this.BW[2] | this.BW[3], this.BW[1] | this.BW[2] | this.BW[3], 5, 10, 15}, {this.BW[1] | this.BW[4], this.BW[1] | this.BW[4], this.BW[1] | this.BW[4], 2, 4, 6}, {this.BW[2] | this.BW[5], this.BW[2] | this.BW[5], this.BW[2] | this.BW[5], 2, 4, 6}, {this.BW[3] | this.BW[6], this.BW[3] | this.BW[6], this.BW[3] | this.BW[6], 2, 4, 6}, {this.BW[0], this.BW[0], this.BW[0], 1, 2, 3}};
    private int[][] REEL_LOOKUP;
    private int[] reelLookupPosition;
    private int[] result;
    private int[] prevResult = null;
    private int[] prevReelLookupPosition = null;
    private static final int[] INITIAL_REEL_POSITION = new int[]{45, 9, 29};
    private boolean casinoPlayStyle = true;
    private int nudgesAvailable = 0;
    private int holdsAvailable = 0;
    private boolean[] holdReels = new boolean[3];
    public int highestScore = 0;
    public int highestScoreCasino = 0;

    public RedWhiteBlueMachine() {
        this.result = new int[3];
        this.reelLookupPosition = new int[3];
        this.prevReelLookupPosition = new int[3];
        this.prevResult = new int[3];
        int count = 0;
        this.REEL_LOOKUP = new int[64][3];
        for (int reel = 0; reel < 3; ++reel) {
            count = 0;
            for (int reelStop = 0; reelStop < this.REEL.length; ++reelStop) {
                for (int i = 0; i < this.REEL[reelStop][reel + 1]; ++i) {
                    this.REEL_LOOKUP[count++][reel] = reelStop;
                }
            }
        }
        this.reset();
    }

    public void reset() {
        this.holdsAvailable = 0;
        this.nudgesAvailable = 0;
        for (int i = 0; i < 3; ++i) {
            this.reelLookupPosition[i] = INITIAL_REEL_POSITION[i];
            this.prevReelLookupPosition[i] = this.reelLookupPosition[i];
            this.result[i] = this.REEL[this.REEL_LOOKUP[this.reelLookupPosition[i]][i]][0];
            this.prevResult[i] = this.result[i];
            this.holdReels[i] = false;
        }
    }

    public void calculateStats() {
        long[] probability = new long[this.PAYOUTS.length];
        int winningCombinations = 0;
        int totalCombinations = 262144;
        System.out.println("--- " + this.getName() + " stats ------------------------");
        System.out.println("\tTotal Combinations=" + totalCombinations);
        long totalPayout = 0L;
        for (int i = 0; i < this.PAYOUTS.length; ++i) {
            long prob = 1L;
            for (int r = 0; r < 3; ++r) {
                long count = 0L;
                for (int rpos = 0; rpos < this.REEL.length; ++rpos) {
                    int symbol = this.BW[this.REEL[rpos][0]];
                    if ((this.PAYOUTS[i][r] & symbol) != symbol) continue;
                    count += (long)this.REEL[rpos][r + 1];
                }
                prob *= count;
            }
            winningCombinations = (int)((long)winningCombinations + prob);
            probability[i] = prob * (long)this.PAYOUTS[i][3];
            totalPayout += probability[i];
            System.out.println("\tPayout " + i + " = " + probability[i] + "/" + totalCombinations);
        }
        long totalPay = totalPayout * 10000L / (long)totalCombinations;
        if (totalPay > 10000L) {
            System.out.println("\tTotal Payout=" + totalPay);
        } else {
            System.out.println("\tTotal Payout=0." + totalPay);
        }
        System.out.println("\tWinning spins: " + winningCombinations * 100 / totalCombinations + "%");
    }

    public void spin() {
        this.seedRandom();
        if (!this.holdReels[0]) {
            this.reelLookupPosition[0] = this.random(this.REEL_LOOKUP.length);
        }
        if (!this.holdReels[1]) {
            this.reelLookupPosition[1] = this.random(this.REEL_LOOKUP.length);
        }
        if (!this.holdReels[2]) {
            this.reelLookupPosition[2] = this.random(this.REEL_LOOKUP.length);
        }
        this.result[0] = this.REEL[this.REEL_LOOKUP[this.reelLookupPosition[0]][0]][0];
        this.result[1] = this.REEL[this.REEL_LOOKUP[this.reelLookupPosition[1]][1]][0];
        this.result[2] = this.REEL[this.REEL_LOOKUP[this.reelLookupPosition[2]][2]][0];
    }

    public void finishSpin() {
        if (!(this.getPayout(1) != 0 || this.holdReels[0] || this.holdReels[1] || this.holdReels[2])) {
            int matches = 0;
            int chances = 100;
            for (int i = 0; i < this.PAYOUTS.length; ++i) {
                matches = 0;
                if ((this.PAYOUTS[i][0] & this.BW[this.result[0]]) == this.BW[this.result[0]]) {
                    ++matches;
                }
                if ((this.PAYOUTS[i][1] & this.BW[this.result[1]]) == this.BW[this.result[1]]) {
                    ++matches;
                }
                if ((this.PAYOUTS[i][2] & this.BW[this.result[2]]) == this.BW[this.result[2]]) {
                    ++matches;
                }
                if (matches != 2) continue;
                chances = 150;
            }
            int n = this.random(chances);
            if (n < 60) {
                this.holdsAvailable = 1;
            }
            if (n < 25) {
                this.holdsAvailable = 2;
            }
            if ((n = this.random(chances)) < 40) {
                this.nudgesAvailable = 1;
            }
            if (n < 20) {
                this.nudgesAvailable = 2;
            }
            if (n < 10) {
                this.nudgesAvailable = 3;
            }
        } else {
            this.holdsAvailable = 0;
            this.nudgesAvailable = 0;
        }
        for (int i = 0; i < 3; ++i) {
            this.prevReelLookupPosition[i] = this.reelLookupPosition[i];
            this.prevResult[i] = this.result[i];
            this.holdReels[i] = false;
        }
    }

    public int getReelSymbol(int reelNum, int offset) {
        int reelPosition = this.REEL_LOOKUP[this.reelLookupPosition[reelNum]][reelNum];
        if (offset == 0) {
            return this.REEL[reelPosition][0];
        }
        if ((reelPosition += offset) >= this.REEL.length) {
            reelPosition -= this.REEL.length;
        } else if (reelPosition < 0) {
            reelPosition += this.REEL.length;
        }
        return this.REEL[reelPosition][0];
    }

    public int getPreviousReelSymbol(int reelNum, int offset) {
        int reelPosition = this.REEL_LOOKUP[this.prevReelLookupPosition[reelNum]][reelNum];
        if (offset == 0) {
            return this.REEL[reelPosition][0];
        }
        if ((reelPosition += offset) >= this.REEL.length) {
            reelPosition -= this.REEL.length;
        } else if (reelPosition < 0) {
            reelPosition += this.REEL.length;
        }
        return this.REEL[reelPosition][0];
    }

    public int getPayout(int numCoins) {
        for (int i = 0; i < this.PAYOUTS.length; ++i) {
            if ((this.PAYOUTS[i][0] & this.BW[this.result[0]]) != this.BW[this.result[0]] || (this.PAYOUTS[i][1] & this.BW[this.result[1]]) != this.BW[this.result[1]] || (this.PAYOUTS[i][2] & this.BW[this.result[2]]) != this.BW[this.result[2]]) continue;
            return this.PAYOUTS[i][3 + (numCoins - 1)];
        }
        return 0;
    }

    public String getResourceFolder() {
        return "/symbols/rwb";
    }

    public int getNumSymbols() {
        return ITEM_NAMES.length;
    }

    public String getName() {
        return "Red, White & Blue";
    }

    public String getDescription() {
        return "A complex machine with an extensive payout table";
    }

    public String getHint() {
        String s = Strings.fill("Total Payout: 95.94%\nWinning Spins: 17%\nYour Highest Winnings: $$0\n\nThis machine features a more complex pay table that offers an increased chance of getting a winning line at the expense of lower payouts.\n\n", Integer.toString(this.getHighestScore()));
        if (!this.casinoPlayStyle) {
            s = s + "The ability and nudge and hold reels gives you a real advantage, if used wisely. It is best to only hold high paying symbols, to hold a low paying one will only reduce your chances of getting anything higher.\n\nThe way the machines are programmed means that the highest paying symbols are less likely to appear on the third reel than the first two, for this reason it is best to hold the highest symbols when they appear in the third reel.\n\nDon't hold reels for the sake of it, as when a reel is held and the reels spun, you will not recieve any more holds for that spin!\n\nNudges are a huge advantage but be careful not to nudge the reels to a lower payout when a higher one can also be made.";
        }
        s = s + "Many machines will payout slightly more if the maximum number of coins is played, so, if your budget allows, it is best to play the maximum number of coins each spin.\n\nContrary to popular belief, casino slot machines are infact totally random. So just because the machine hasn't paid out for a time doesn't mean that a jackpot is 'due'!\n\nEach paying line has a particular probability of coming up and the machines are programmed to payout at a rate of anything from 80% to 95%.\n";
        return s;
    }

    public boolean supportsHolds() {
        return !this.casinoPlayStyle;
    }

    public boolean supportsNudges() {
        return !this.casinoPlayStyle;
    }

    public int numHoldsAvailable() {
        return this.casinoPlayStyle ? 0 : this.holdsAvailable;
    }

    public int numNudgesAvailable() {
        return this.casinoPlayStyle ? 0 : this.nudgesAvailable;
    }

    public void toggleHold(int reelNum) {
        if (this.holdReels[reelNum]) {
            this.holdReels[reelNum] = false;
            ++this.holdsAvailable;
        } else if (this.holdsAvailable > 0) {
            this.holdReels[reelNum] = true;
            --this.holdsAvailable;
        }
    }

    public boolean reelHeld(int reelNum) {
        return this.holdReels[reelNum];
    }

    public boolean nudge(int reelNum) {
        if (this.nudgesAvailable > 0) {
            --this.nudgesAvailable;
            boolean nudgedReel = false;
            int pos = this.reelLookupPosition[reelNum];
            while (!nudgedReel) {
                pos = pos == 0 ? this.REEL_LOOKUP.length - 1 : --pos;
                if (this.REEL[this.REEL_LOOKUP[pos][reelNum]][0] == this.result[reelNum]) continue;
                nudgedReel = true;
                this.reelLookupPosition[reelNum] = pos;
                this.prevReelLookupPosition[reelNum] = pos;
                this.result[reelNum] = this.REEL[this.REEL_LOOKUP[pos][reelNum]][0];
            }
            return true;
        }
        return false;
    }

    public void setMachineCasinoStyle(boolean casinoStyle) {
        this.casinoPlayStyle = casinoStyle;
    }

    public void loadHighestScore() {
        try {
            if (RecordManager.exists("hs_rwb")) {
                this.highestScore = RecordManager.byteArrayToInt(RecordManager.load("hs_rwb"));
                this.highestScoreCasino = RecordManager.byteArrayToInt(RecordManager.load("hs_rwb_casino"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveHighestScore() {
        try {
            RecordManager.save(this.highestScore, "hs_rwb");
            RecordManager.save(this.highestScoreCasino, "hs_rwb_casino");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHighestScore() {
        if (this.casinoPlayStyle) {
            return this.highestScoreCasino;
        }
        return this.highestScore;
    }

    public void setHighestScore(int s) {
        if (this.casinoPlayStyle) {
            this.highestScoreCasino = s;
        } else {
            this.highestScore = s;
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            for (int i = 0; i < 3; ++i) {
                os.writeInt(this.reelLookupPosition[i]);
                os.writeInt(this.prevReelLookupPosition[i]);
                os.writeBoolean(this.holdReels[i]);
            }
            os.writeInt(this.nudgesAvailable);
            os.writeInt(this.holdsAvailable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            for (int i = 0; i < 3; ++i) {
                this.reelLookupPosition[i] = is.readInt();
                this.prevReelLookupPosition[i] = is.readInt();
                this.holdReels[i] = is.readBoolean();
            }
            this.nudgesAvailable = is.readInt();
            this.holdsAvailable = is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

