/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.CasinoPack;
import net.handyx.casinopack.common.LoadingScreen;
import net.handyx.casinopack.videopoker.Common;
import net.handyx.casinopack.videopoker.Deck;
import net.handyx.casinopack.videopoker.Hand;
import net.handyx.casinopack.videopoker.HandEvaluator;
import net.handyx.casinopack.videopoker.MenuCanvas;
import net.handyx.casinopack.videopoker.PokerCanvas;

public final class VideoPoker
implements Runnable {
    public static final int _SW = 240;
    public static final int _SH = 320;
    public Display display;
    private static final int INIT = 0;
    private static final int NEW_GAME = 1;
    private static final int RESUME_GAME = 2;
    private static final int MAIN_MENU = 3;
    private int loadingStage = 0;
    private int[][] payout = new int[][]{{1, 2, 3, 4, 6, 9, 25, 50, 250}, {2, 4, 6, 8, 12, 18, 50, 100, 500}, {3, 6, 9, 12, 18, 27, 75, 150, 750}, {4, 8, 12, 16, 24, 36, 100, 200, 1000}, {5, 10, 15, 20, 30, 45, 125, 250, 4000}};
    public PokerCanvas vpCanvas;
    private Deck deck;
    private Deck doubleUpDeck;
    private Hand hand;
    private Hand doubleUpHand;
    private HandEvaluator evaluator;
    private MenuCanvas menuCanvas;
    private LoadingScreen loadingScreen;
    public CasinoPack parent = null;

    public VideoPoker(CasinoPack p) {
        this.parent = p;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.init();
    }

    public void init() {
        this.loadingScreen = new LoadingScreen();
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.loadingStage = 0;
        Thread t = new Thread(this);
        t.start();
    }

    public void purgeResources() {
        Common.purgeResources();
        this.vpCanvas.purgeResources();
        this.vpCanvas = null;
        this.menuCanvas.purgeResources();
        this.menuCanvas = null;
        this.evaluator = null;
        this.deck = null;
        this.doubleUpDeck = null;
        this.hand = null;
        this.doubleUpHand = null;
        this.loadingScreen = null;
        System.gc();
    }

    public void run() {
        while (this.display.getCurrent() != this.loadingScreen) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        if (this.loadingStage == 0) {
            Common.loadResources();
            this.deck = new Deck();
            this.doubleUpDeck = new Deck();
            this.evaluator = new HandEvaluator();
            this.menuCanvas = new MenuCanvas(this);
            this.menuCanvas.loadSettings();
            this.vpCanvas = new PokerCanvas(this);
            this.vpCanvas.loadPokerCanvasGameState();
            this.vpCanvas.setHand(this.hand);
            this.menuCanvas.loadResources();
            this.display.setCurrent((Displayable)this.menuCanvas);
        } else if (this.loadingStage == 1 || this.loadingStage == 2) {
            this.menuCanvas.purgeResources();
            System.gc();
            if (this.loadingStage == 1) {
                this.vpCanvas.newGame();
            }
            this.vpCanvas.loadResources();
            this.menuCanvas.selectedIndex = 1;
            this.display.setCurrent((Displayable)this.vpCanvas);
        } else if (this.loadingStage == 3) {
            this.vpCanvas.purgeResources();
            System.gc();
            this.menuCanvas.loadResources();
            this.display.setCurrent((Displayable)this.menuCanvas);
        }
    }

    public void dealHand() {
        this.deck.shuffle();
        this.doubleUpDeck.shuffle();
        this.hand = new Hand();
        this.doubleUpHand = new Hand();
        for (int i = 0; i < 5; ++i) {
            this.hand.addCard(this.deck.deal());
            this.doubleUpHand.addCard(this.doubleUpDeck.deal());
        }
        Common.log("\n" + this.hand.toString());
        int bestHand = this.evaluator.eval(this.hand);
        this.vpCanvas.setDoubleUpHand(this.doubleUpHand);
        this.vpCanvas.setHand(this.hand);
        this.vpCanvas.setHandType(bestHand);
        this.vpCanvas.setStrategy(this.evaluator.getLastStrategy());
        this.vpCanvas.setStrategyDescription(this.evaluator.getLastStrategyDescription());
        this.vpCanvas.setStrategyExample(this.evaluator.getLastStrategyExample());
        if (this.evaluator.hasHoldCards()) {
            this.vpCanvas.setHoldCards(this.evaluator.getHoldCardsArray(this.hand));
        }
    }

    public void doLoadingStage(int stage) {
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.loadingStage = stage;
        Thread t = new Thread(this);
        t.start();
    }

    public void redealHand() {
        for (int i = 0; i < 5; ++i) {
            if (this.vpCanvas.isHeld(i)) continue;
            this.hand.replaceUnsortedCard(i, this.deck.deal());
        }
        Common.log("\n" + this.hand.toString());
        int bestHand = this.evaluator.eval(this.hand);
        this.vpCanvas.setHandType(bestHand);
    }

    public void redealDoubleUpHand() {
        Common.log("Redealing double up");
        this.doubleUpDeck.shuffle();
        this.doubleUpHand = new Hand();
        for (int i = 0; i < 5; ++i) {
            this.doubleUpHand.addCard(this.doubleUpDeck.deal());
        }
        Common.log("Double Up=" + this.doubleUpHand.toString());
        this.vpCanvas.setDoubleUpHand(this.doubleUpHand);
    }

    public int getPayout(int bet, int winningHand) {
        try {
            if (winningHand == -1) {
                return 0;
            }
            return this.payout[bet - 1][winningHand];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void startNewGame() {
        this.doLoadingStage(1);
    }

    public void resumeGame() {
        this.doLoadingStage(2);
    }

    public void displayMainMenu() {
        this.doLoadingStage(3);
    }

    public void splashScreenCleared() {
        this.doLoadingStage(3);
    }

    public void exitApplication() {
        if (this.vpCanvas != null) {
            this.vpCanvas.savePokerCanvasGameState();
        }
        this.parent.displaySelector();
    }

    public void startApp() {
    }

    public void pauseApp() {
    }
}

