/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.videopoker.Card;
import net.handyx.casinopack.videopoker.Common;
import net.handyx.casinopack.videopoker.Hand;
import net.handyx.casinopack.videopoker.HandEvaluator;
import net.handyx.casinopack.videopoker.VideoPoker;

public class PokerCanvas
extends RunnableCanvas {
    private VideoPoker parent = null;
    public static final int MAX_BET = 5;
    public int bet = 1;
    public int winnings = 0;
    public int cash = 1000;
    public int _winnings = 0;
    public int _cash = 1000;
    public int coinValue = 0;
    public static final int SET_BET = 0;
    public static final int DEAL = 1;
    public static final int DEALT = 2;
    public static final int REDEAL = 3;
    public static final int REDEALT = 4;
    public static final int DOUBLE_UP_PROMPT = 5;
    public static final int DOUBLE_UP_PICK_CARD = 6;
    public static final int DOUBLE_UP_WON = 7;
    public static final int DOUBLE_UP_LOST = 8;
    public static final int HAND_WON = 9;
    public static final int HAND_LOST = 10;
    public int gameState = 0;
    private static final int BUTTON_BET_ONE = 0;
    private static final int BUTTON_BET_MAX = 2;
    private static final int BUTTONS_X_OFFSET = 5;
    private static final int BUTTONS_Y_OFFSET = 246;
    private static final int[][] BUTTONS_CLIP_AREAS = new int[][]{{0, 0, 76, 43}, {77, 0, 76, 43}, {152, 0, 81, 43}};
    private Image buttonsOnImage;
    private Image buttonsOffImage;
    private Image payTableImage;
    private Image topPanelImage;
    private Image payTableOnImage;
    private Image payTableFlashImage;
    private int selectedButton = 0;
    private Hand hand = null;
    private Hand doubleUpHand = null;
    private String strategyString = "";
    private String strategyDescriptionString = "";
    private String strategyExampleString = "";
    private int currentHandType = -1;
    private int _currentHandType = -1;
    private static final int CARD_HEIGHT = 59;
    private static final int CARD_WIDTH = 42;
    private static final int CARD_X_OFFSET = 7;
    private static final int CARD_Y_OFFSET = 180;
    private static final int SMALL_CARD_WIDTH = 20;
    private static final int SMALL_CARD_HEIGHT = 30;
    private Image cardBaseImage;
    private Image cardBackImage;
    private Image cardHoldImage;
    private Image cardBaseHighlightImage;
    private Image cardBackSelectedImage;
    private Image holdCardStarImage;
    private Image cardNumsImage;
    private Image cardSuitsImage;
    private Image cardHeadsImage;
    private Image cardNumsSmallImage;
    private Image cardSuitsSmallImage;
    private boolean[] holdCards = new boolean[5];
    private boolean[] holdCardSuggestions = new boolean[5];
    private int selectedCard = 0;
    private int cardsRevealed = 0;
    private long cardsRevealedTime = 0L;
    private int cardRevealDelay = 125;
    private Image popupImage;
    private String doubleUpPopupString = "";
    private String doubleUpPopupString2 = "";
    private String doubleUpPopupString3 = "";
    private int doubleUpRoundsCleared = 0;
    private int doubleUpSelectedIndex = 0;
    private int doubleUpWinnings = 0;
    private int POPUP_REVEAL = 1;
    private int POPUP_HIDE = 2;
    private int showHint = 0;
    private int POPUP_HINT = 1;
    private int POPUP_STATS = 2;
    private int POPUP_WARNING = 3;
    private int POPUP_NO_CASH = 4;
    private int showHintType = this.POPUP_HINT;
    private int boxW = 0;
    private int boxH = 0;
    private int boxNumFrames = 0;
    private int boxFrame = 0;
    public boolean gameInProgress = false;
    private boolean showPopupMenu = false;
    private int popupMenuSelectedIndex = 0;
    private String[][] popupMenuItems = new String[][]{{"Show Hint", "Game Stats", "Main Menu"}, {"Game Stats", "Main Menu"}};
    private int popupMenuNum = 0;
    private String perfectPlayDescriptionString = "The cards you have chosen to hold are not the best play for this hand.\n\nAre you sure you want to continue and play these cards?";
    private boolean dealCardsAfterWarning = false;
    private String noCashDescriptionString = "Sorry, you don't have enough cash to place that bet.\n\nYou will need to bet a smaller amount or start a new game.";
    private long gameStartDate = 0L;
    private long gameStartTime = 0L;
    private int gameHandsPlayed = 0;
    private int gameHandsWon = 0;
    private int gameBestHand = -1;
    private int gameTotalWinnings = 0;
    private int gameTotalBet = 0;
    private int gameHandsDoubled = 0;
    private int gameHandsDoubledWon = 0;

    public PokerCanvas(VideoPoker p) {
        this.parent = p;
    }

    public void loadResources() {
        this.buttonsOnImage = Common.loadImage("/buttons_on.png");
        this.buttonsOffImage = Common.loadImage("/buttons_off.png");
        this.cardHoldImage = Common.loadImage("/hold.png");
        this.cardNumsSmallImage = Common.loadImage("/cards/small/nums.png");
        this.cardSuitsSmallImage = Common.loadImage("/cards/small/suits.png");
        this.cardBaseImage = Common.loadImage("/cards/card_base.png");
        this.cardBaseHighlightImage = Common.loadImage("/cards/card_base_selected.png");
        this.cardBackImage = Common.loadImage("/cards/card_back.png");
        this.cardBackSelectedImage = Common.loadImage("/cards/card_back_selected.png");
        this.cardNumsImage = Common.loadImage("/cards/nums.png");
        this.cardSuitsImage = Common.loadImage("/cards/suits.png");
        this.cardHeadsImage = Common.loadImage("/cards/heads.png");
        this.holdCardStarImage = Common.loadImage("/star.png");
        this.payTableImage = Common.loadImage("/paytable.png");
        this.payTableOnImage = Common.loadImage("/paytable_highlight.png");
        this.payTableFlashImage = Common.loadImage("/paytable_highlight2.png");
        this.topPanelImage = Common.loadImage("/toppanel.png");
        this.popupImage = Common.loadImage("/popup.png");
    }

    public void purgeResources() {
        this.buttonsOnImage = null;
        this.buttonsOffImage = null;
        this.cardHoldImage = null;
        this.cardNumsSmallImage = null;
        this.cardSuitsSmallImage = null;
        this.cardBaseImage = null;
        this.cardBaseHighlightImage = null;
        this.cardBackImage = null;
        this.cardBackSelectedImage = null;
        this.cardNumsImage = null;
        this.cardSuitsImage = null;
        this.cardHeadsImage = null;
        this.holdCardStarImage = null;
        this.payTableImage = null;
        this.payTableOnImage = null;
        this.payTableFlashImage = null;
        this.topPanelImage = null;
        this.popupImage = null;
        System.gc();
    }

    public void newGame() {
        this.gameStartTime = this.gameStartDate = System.currentTimeMillis();
        this.gameHandsPlayed = 0;
        this.gameHandsWon = 0;
        this.gameBestHand = -1;
        this.gameTotalWinnings = 0;
        this.gameTotalBet = 0;
        this.gameHandsDoubled = 0;
        this.gameHandsDoubledWon = 0;
        this.reset();
        this.winnings = 0;
        this.cash = Common.startingBalance;
        this.coinValue = Common.coinValue;
        this._winnings = 0;
        this._cash = this.cash;
        this.bet = 1;
    }

    public void reset() {
        this.gameInProgress = true;
        this.gameState = 0;
        this.strategyString = "";
        for (int i = 0; i < 5; ++i) {
            this.holdCards[i] = false;
            this.holdCardSuggestions[i] = false;
        }
        this.currentHandType = -1;
        this.doubleUpRoundsCleared = 0;
        this.doubleUpWinnings = 0;
        this.winnings = 0;
        this._winnings = 0;
        this._cash = this.cash;
        this.coinValue = Common.coinValue;
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        g.drawImage(Common.bgImage, 0, 0, 20);
        g.drawImage(this.topPanelImage, 2, 2, 20);
        Common.digitFont.drawString(gfx, Integer.toString(this._cash), g.scale(21), g.scale(13));
        Common.digitFont.drawString(gfx, Integer.toString(this._winnings), g.scale(107), g.scale(13));
        Common.digitFont.drawString(gfx, Integer.toString(this.coinValue), g.scale(199), g.scale(13));
        int tableX = (sw - g.unscale(this.payTableImage.getWidth())) / 2;
        g.drawImage(this.payTableImage, tableX, 42, 20);
        g.setClip(tableX + 79 + 24 * (this.bet - 1), 42, 24, this.payTableImage.getHeight());
        g.drawImage(this.payTableOnImage, tableX, 42, 20);
        if (this.currentHandType > -1) {
            g.setClip(0, 55 + (8 - this.currentHandType) * 12, sw, 12);
            g.drawImage(this.payTableOnImage, tableX, 42, 20);
            g.setClip(tableX + 79 + 24 * (this.bet - 1), 55 + (8 - this.currentHandType) * 12, 25, 12);
            g.drawImage(this.payTableFlashImage, tableX, 42, 20);
        }
        g.setClip(0, 0, sw, sh);
        for (int i = 0; i < 5; ++i) {
            int cardX = 7 + i * 46;
            if (this.gameState == 0) {
                g.drawImage(this.cardBackImage, cardX, 180, 20);
                continue;
            }
            if (this.gameState == 6) {
                if (i == 0) {
                    this.renderCard(g, this.doubleUpHand.getUnsortedCard(0), cardX, 180, false);
                    continue;
                }
                if (i - 1 == this.doubleUpSelectedIndex) {
                    g.drawImage(this.cardBackSelectedImage, cardX - 3, 177, 20);
                    continue;
                }
                g.drawImage(this.cardBackImage, cardX, 180, 20);
                continue;
            }
            if (this.gameState == 7 || this.gameState == 8) {
                if (i - 1 == this.doubleUpSelectedIndex) {
                    this.renderCard(g, this.doubleUpHand.getUnsortedCard(i), cardX, 180, true);
                    continue;
                }
                this.renderCard(g, this.doubleUpHand.getUnsortedCard(i), cardX, 180, false);
                continue;
            }
            Card c1 = this.hand.getUnsortedCard(i);
            if (this.gameState == 1) {
                if (i < this.cardsRevealed) {
                    this.renderCard(g, c1, cardX, 180, false);
                    continue;
                }
                g.drawImage(this.cardBackImage, cardX, 180, 20);
                continue;
            }
            if (this.gameState == 3) {
                if (i < this.cardsRevealed || this.holdCards[i]) {
                    this.renderCard(g, c1, cardX, 180, false);
                    continue;
                }
                g.drawImage(this.cardBackImage, cardX, 180, 20);
                continue;
            }
            if (this.gameState == 2) {
                this.renderCard(g, c1, cardX, 180, i == this.selectedCard);
                if (this.holdCardSuggestions[i] && Common.hintsEnabled) {
                    g.drawImage(this.holdCardStarImage, cardX + 30, 173, 20);
                }
                if (!this.holdCards[i]) continue;
                g.drawImage(this.cardHoldImage, cardX + 7, 239 - g.unscale(this.cardHoldImage.getHeight()) / 2, 20);
                continue;
            }
            if (this.gameState != 4 && this.gameState != 5 && this.gameState != 9 && this.gameState != 10) continue;
            this.renderCard(g, c1, cardX, 180, false);
        }
        if (this.gameState == 5 || this.gameState == 6 || this.gameState == 7 || this.gameState == 8) {
            int popupX = (sw - g.unscale(this.popupImage.getWidth())) / 2;
            int popupY = 25;
            g.drawImage(this.popupImage, popupX, popupY, 20);
            Common.largeFont.drawCenteredString(g, this.doubleUpPopupString, popupY + 70);
            Common.largeFont.drawCenteredString(g, this.doubleUpPopupString2, popupY + 70 + 20);
            Common.largeFont.drawCenteredString(g, this.doubleUpPopupString3, popupY + 70 + 40);
        } else if (this.gameState == 0) {
            g.drawImage(this.buttonsOffImage, 5, 246, 20);
            g.setClip(5 + BUTTONS_CLIP_AREAS[this.selectedButton][0], 246 + BUTTONS_CLIP_AREAS[this.selectedButton][1], BUTTONS_CLIP_AREAS[this.selectedButton][2], BUTTONS_CLIP_AREAS[this.selectedButton][3]);
            g.drawImage(this.buttonsOnImage, 5, 246, 20);
            g.setClip(0, 0, sw, sh);
        } else if (this.gameState == 9) {
            FrameRenderer.renderFrame(g, (sw - 200) / 2, 245, 200, 30, 20);
            Common.normalFont.drawCenteredString(g, this.doubleUpPopupString, 254);
        }
        if (this.showHint > 0) {
            this.renderHint(g);
        }
        if (this.showPopupMenu) {
            PokerCanvas.drawLeftCommand(g, "Select", Common.largeFont);
            PokerCanvas.drawRightCommand(g, "Cancel", Common.largeFont);
            int menuW = 140;
            int menuItemH = Common.largeFont.getHeight() + 6;
            int menuX = sw - menuW;
            int menuY = sh - menuItemH * (this.popupMenuItems[this.popupMenuNum].length + 1);
            g.setColor(3042334);
            g.fillRect(menuX, menuY, menuW, menuItemH * this.popupMenuItems[this.popupMenuNum].length);
            g.setColor(5158195);
            g.fillRect(menuX, menuY + this.popupMenuSelectedIndex * menuItemH, menuW, menuItemH);
            g.setColor(0xFFFFFF);
            g.drawRect(menuX, menuY, menuW - 1, menuItemH * this.popupMenuItems[this.popupMenuNum].length);
            for (int i = 0; i < this.popupMenuItems[this.popupMenuNum].length; ++i) {
                if (i == this.popupMenuSelectedIndex) {
                    Common.largeFont.drawString(g, this.popupMenuItems[this.popupMenuNum][i], menuX + 5, menuY + 4 + i * menuItemH);
                    continue;
                }
                Common.largeFontDisabled.drawString(g, this.popupMenuItems[this.popupMenuNum][i], menuX + 5, menuY + 4 + i * menuItemH);
            }
        } else if (this.showHint == this.POPUP_REVEAL) {
            if (this.showHintType == this.POPUP_WARNING) {
                PokerCanvas.drawLeftCommand(g, "Yes", Common.largeFont);
                PokerCanvas.drawRightCommand(g, "No", Common.largeFont);
            } else {
                PokerCanvas.drawRightCommand(g, "OK", Common.largeFont);
            }
        } else if (this.gameState == 5 || this.gameState == 6 || this.gameState == 7 || this.gameState == 8) {
            if (this.gameState == 5 || this.gameState == 7) {
                PokerCanvas.drawLeftCommand(g, "Yes", Common.largeFont);
                PokerCanvas.drawRightCommand(g, "No", Common.largeFont);
            } else if (this.gameState == 6) {
                PokerCanvas.drawLeftCommand(g, "Select", Common.largeFont);
                PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
            } else if (this.gameState == 8) {
                PokerCanvas.drawLeftCommand(g, "Next Round", Common.largeFont);
                PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
            }
        } else if (this.gameState == 0) {
            PokerCanvas.drawLeftCommand(g, "Select", Common.largeFont);
            PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
        } else if (this.gameState == 2) {
            PokerCanvas.drawLeftCommand(g, "Draw", Common.largeFont);
            PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
        } else if (this.gameState == 4) {
            PokerCanvas.drawLeftCommand(g, "Next Round", Common.largeFont);
            PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
        } else if (this.gameState == 9 || this.gameState == 10) {
            PokerCanvas.drawLeftCommand(g, "Next Round", Common.largeFont);
            PokerCanvas.drawRightCommand(g, "Options", Common.largeFont);
        }
    }

    public void renderHint(GraphicsScaler g) {
        block18: {
            block16: {
                int tmpH;
                int tmpW;
                block17: {
                    for (int meshX = 0; meshX < g.getWidth(); meshX += 48) {
                        for (int meshY = 0; meshY < g.getHeight(); meshY += 64) {
                            g.drawImage(Common.meshImage, meshX, meshY, 20);
                        }
                    }
                    if (this.boxFrame >= this.boxNumFrames) break block16;
                    if (this.showHint != this.POPUP_REVEAL) break block17;
                    tmpW = this.boxFrame * (this.boxW / this.boxNumFrames);
                    tmpH = this.boxFrame * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, g.getWidth() / 2, g.getHeight() / 2, tmpW, tmpH, 3, null);
                    break block18;
                }
                if (this.showHint != this.POPUP_HIDE) break block18;
                tmpW = (this.boxNumFrames - this.boxFrame) * (this.boxW / this.boxNumFrames);
                tmpH = (this.boxNumFrames - this.boxFrame) * (this.boxH / this.boxNumFrames);
                FrameRenderer.renderFrame(g, g.getWidth() / 2, g.getHeight() / 2, tmpW, tmpH, 3, null);
                break block18;
            }
            FrameRenderer.renderFrame(g, g.getWidth() / 2, g.getHeight() / 2, this.boxW, this.boxH, 3, null);
            int hintX = (g.getWidth() - this.boxW) / 2;
            int hintY = (g.getHeight() - this.boxH) / 2;
            hintY += 10;
            if (this.showHintType == this.POPUP_HINT) {
                int i;
                String[] titleLines = Common.largeFont.wrap(this.strategyString, g.getWidth() - 40);
                for (int i2 = 0; i2 < titleLines.length; ++i2) {
                    Common.largeFont.drawCenteredString(g, titleLines[i2], hintY);
                    hintY += Common.largeFont.getHeight();
                }
                hintY += 10;
                if (this.strategyExampleString.length() > 0) {
                    int cardX = (g.getWidth() - 110) / 2;
                    for (i = 0; i < 5; ++i) {
                        String s = this.strategyExampleString.substring(i * 3, i * 3 + 2);
                        this.renderSmallCard(g, new Card(s), cardX + 22 * i, hintY);
                    }
                    hintY += 45;
                }
                String[] lines = Common.normalFont.wrap(this.strategyDescriptionString, this.boxW - 30);
                for (i = 0; i < lines.length; ++i) {
                    Common.normalFont.drawString(g, lines[i], hintX + 15, hintY);
                    hintY += Common.normalFont.getHeight();
                }
            } else if (this.showHintType == this.POPUP_STATS) {
                String[] stats = new String[]{"Started: " + this.formatDateString(this.gameStartDate), "Play Time: " + this.formatTimeString(System.currentTimeMillis() - this.gameStartTime), "", "Hands Played: " + this.gameHandsPlayed, "Winnings Hands: " + this.gameHandsWon, "Best Hand: " + (this.gameBestHand == -1 ? "n/a" : HandEvaluator.HAND_NAMES[this.gameBestHand]), "", "Total Bet: " + this.gameTotalBet, "Total Winnings: " + this.gameTotalWinnings, "", "Double or Nothing", "Success Rate: " + (this.gameHandsDoubled == 0 ? 0 : this.gameHandsDoubledWon * 100 / this.gameHandsDoubled) + "%"};
                int totalHeight = Common.largeFont.getHeight() + 8 + stats.length * Common.normalFont.getHeight();
                hintY = (g.getHeight() - totalHeight) / 2;
                Common.largeFont.drawCenteredString(g, "Game Stats", hintY);
                hintY += Common.largeFont.getHeight() + 8;
                for (int i = 0; i < stats.length; ++i) {
                    Common.normalFont.drawCenteredString(g, stats[i], hintY);
                    hintY += Common.normalFont.getHeight();
                }
            } else if (this.showHintType == this.POPUP_WARNING) {
                String[] lines = Common.normalFont.wrap(this.perfectPlayDescriptionString, this.boxW - 30);
                int totalHeight = Common.largeFont.getHeight() + 8 + lines.length * Common.normalFont.getHeight();
                hintY = (g.getHeight() - totalHeight) / 2;
                Common.largeFont.drawCenteredString(g, "Perfect Play", hintY);
                hintY += Common.largeFont.getHeight() + 8;
                for (int i = 0; i < lines.length; ++i) {
                    Common.normalFont.drawCenteredString(g, lines[i], hintY);
                    hintY += Common.normalFont.getHeight();
                }
            } else if (this.showHintType == this.POPUP_NO_CASH) {
                String[] lines = Common.normalFont.wrap(this.noCashDescriptionString, this.boxW - 30);
                int totalHeight = Common.largeFont.getHeight() + 8 + lines.length * Common.normalFont.getHeight();
                hintY = (g.getHeight() - totalHeight) / 2;
                Common.largeFont.drawCenteredString(g, "Insufficient Cash", hintY);
                hintY += Common.largeFont.getHeight() + 8;
                for (int i = 0; i < lines.length; ++i) {
                    Common.normalFont.drawCenteredString(g, lines[i], hintY);
                    hintY += Common.normalFont.getHeight();
                }
            }
        }
    }

    public void renderCard(GraphicsScaler g, Card c, int x, int y, boolean highlight) {
        int numXo = 4;
        int numYo = 5;
        int suitXo = 7;
        int suitYo = 25;
        int headXo = 24;
        int headYo = 4;
        if (highlight) {
            g.drawImage(this.cardBaseHighlightImage, x - 3, y - 3, 20);
        } else {
            g.drawImage(this.cardBaseImage, x, y, 20);
        }
        switch (c.getSuit()) {
            case 0: {
                g.setClip(x + numXo, y + numYo, 14, 16);
                g.drawImage(this.cardNumsImage, x + numXo - 14 * (c.getRank() - 1), y + numYo - 17, 20);
                break;
            }
            case 3: {
                g.setClip(x + numXo, y + numYo, 14, 16);
                g.drawImage(this.cardNumsImage, x + numXo - 14 * (c.getRank() - 1), y + numYo - 17, 20);
                break;
            }
            case 2: {
                g.setClip(x + numXo, y + numYo, 14, 16);
                g.drawImage(this.cardNumsImage, x + numXo - 14 * (c.getRank() - 1), y + numYo, 20);
                break;
            }
            case 1: {
                g.setClip(x + numXo, y + numYo, 14, 16);
                g.drawImage(this.cardNumsImage, x + numXo - 14 * (c.getRank() - 1), y + numYo, 20);
            }
        }
        g.setClip(x + suitXo, y + suitYo, 27, 27);
        g.drawImage(this.cardSuitsImage, x + suitXo - 27 * c.getSuit(), y + suitYo, 20);
        if (c.getRank() >= 11) {
            g.setClip(x + headXo, y + headYo, 16, 19);
            if (c.getSuit() == 0 || c.getSuit() == 3) {
                g.drawImage(this.cardHeadsImage, x + headXo, y + headYo - (c.getRank() - 11) * 19, 20);
            } else {
                g.drawImage(this.cardHeadsImage, x + headXo - 16, y + headYo - (c.getRank() - 11) * 19, 20);
            }
        }
        g.setClip(0, 0, g.getWidth(), g.getHeight());
    }

    private void renderSmallCard(GraphicsScaler g, Card c, int x, int y) {
        int numXOffset = 3;
        int numYOffset = 3;
        int suitXOffset = 4;
        int suitYOffset = 13;
        int s = c.getSuit();
        int v = c.getRank() - 1;
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, 20, 30);
        g.setColor(0);
        g.drawLine(x, y + 30, x + 20, y + 30);
        g.drawLine(x + 20, y, x + 20, y + 30);
        g.setColor(0xC0C0C0);
        g.drawLine(x, y, x + 20, y);
        g.drawLine(x, y, x, y + 30);
        g.setClip(x + suitXOffset, y + suitYOffset, 14, 14);
        switch (s) {
            case 0: {
                g.drawImage(this.cardSuitsSmallImage, x + suitXOffset, y + suitYOffset, 20);
                g.setClip(x + numXOffset, y + numYOffset, 10, 9);
                g.drawImage(this.cardNumsSmallImage, x + numXOffset - v * 10, y + numYOffset, 20);
                break;
            }
            case 3: {
                g.drawImage(this.cardSuitsSmallImage, x + suitXOffset - 42, y + suitYOffset, 20);
                g.setClip(x + numXOffset, y + numYOffset, 10, 9);
                g.drawImage(this.cardNumsSmallImage, x + numXOffset - v * 10, y + numYOffset, 20);
                break;
            }
            case 2: {
                g.drawImage(this.cardSuitsSmallImage, x + suitXOffset - 28, y + suitYOffset, 20);
                g.setClip(x + numXOffset, y + numYOffset, 10, 9);
                g.drawImage(this.cardNumsSmallImage, x + numXOffset - v * 10, y + numYOffset - 9, 20);
                break;
            }
            case 1: {
                g.drawImage(this.cardSuitsSmallImage, x + suitXOffset - 14, y + suitYOffset, 20);
                g.setClip(x + numXOffset, y + numYOffset, 10, 9);
                g.drawImage(this.cardNumsSmallImage, x + numXOffset - v * 10, y + numYOffset - 9, 20);
            }
        }
        g.setClip(0, 0, g.getWidth(), g.getHeight());
    }

    public void processFrame(int fn) {
        if (this.boxFrame < this.boxNumFrames) {
            ++this.boxFrame;
            if (this.boxFrame == this.boxNumFrames && this.showHint == this.POPUP_HIDE) {
                if (this.showHintType == this.POPUP_WARNING && this.dealCardsAfterWarning) {
                    this.deal(true);
                }
                this.showHint = 0;
            }
        }
        if (this._cash < this.cash) {
            this._cash = this.cash - this._cash > 200 ? (this._cash += 100) : (this.cash - this._cash > 20 ? (this._cash += 10) : ++this._cash);
        } else if (this._cash > this.cash) {
            this._cash = this._cash - this.cash > 200 ? (this._cash -= 100) : (this._cash - this.cash > 20 ? (this._cash -= 10) : --this._cash);
        }
        if (this._winnings < this.winnings) {
            this._winnings = this.winnings - this._winnings > 200 ? (this._winnings += 100) : (this.winnings - this._winnings > 20 ? (this._winnings += 10) : ++this._winnings);
        } else if (this._winnings > this.winnings) {
            this._winnings = this._winnings - this.winnings > 200 ? (this._winnings -= 100) : (this._winnings - this.winnings > 20 ? (this._winnings -= 10) : --this._winnings);
        }
        if (this.gameState == 1) {
            if (this.cardsRevealed < 5 && System.currentTimeMillis() > this.cardsRevealedTime) {
                ++this.cardsRevealed;
                if (this.cardsRevealed == 5) {
                    this.currentHandType = this._currentHandType;
                    this.gameState = 2;
                } else {
                    this.cardsRevealedTime = System.currentTimeMillis() + (long)this.cardRevealDelay;
                }
            }
        } else if (this.gameState == 3 && this.cardsRevealed < 5 && System.currentTimeMillis() > this.cardsRevealedTime) {
            ++this.cardsRevealed;
            while (this.holdCards[this.cardsRevealed - 1]) {
                ++this.cardsRevealed;
                if (this.cardsRevealed < 5) continue;
            }
            if (this.cardsRevealed >= 5) {
                this.gameState = 4;
                this.finishedGame();
            } else {
                this.cardsRevealedTime = System.currentTimeMillis() + (long)this.cardRevealDelay;
            }
        }
    }

    public void startNotify() {
    }

    public void stopNotify() {
    }

    public void keyPressedEvent(int keyCode, int ga, int sk) {
        if (this.showPopupMenu) {
            if (sk == 2 || sk == 3) {
                this.showPopupMenu = false;
            } else if (sk == 1) {
                this.activatePopupMenu();
            }
            if (ga == 1) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex > 0 ? --this.popupMenuSelectedIndex : this.popupMenuItems[this.popupMenuNum].length - 1;
            } else if (ga == 6) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex < this.popupMenuItems[this.popupMenuNum].length - 1 ? ++this.popupMenuSelectedIndex : 0;
            } else if (ga == 8) {
                this.activatePopupMenu();
            }
            return;
        }
        if (this.showHint == this.POPUP_REVEAL) {
            if (sk == 2) {
                this.dealCardsAfterWarning = false;
                this.showHint = this.POPUP_HIDE;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
            } else if (sk == 1 && this.showHintType == this.POPUP_WARNING) {
                this.dealCardsAfterWarning = true;
                this.showHint = this.POPUP_HIDE;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
            }
            return;
        }
        if (this.gameState == 2) {
            if (sk == 1) {
                this.deal(false);
                return;
            }
            if (sk == 2) {
                this.popupMenuSelectedIndex = 0;
                this.showPopupMenu = true;
                this.popupMenuNum = 0;
                return;
            }
        } else if (this.gameState == 4 || this.gameState == 8 || this.gameState == 9 || this.gameState == 10) {
            if (sk == 1) {
                this.reset();
                return;
            }
            if (sk == 2) {
                this.popupMenuSelectedIndex = 0;
                this.showPopupMenu = true;
                this.popupMenuNum = 1;
                return;
            }
        } else if (this.gameState == 0) {
            if (sk == 1) {
                if (this.selectedButton == 0) {
                    this.bet = this.bet == 5 ? 1 : this.bet + 1;
                    Common.doSound("coin");
                } else if (this.selectedButton == 2) {
                    this.bet = 5;
                    this.deal(false);
                } else {
                    this.deal(false);
                }
                return;
            }
            if (sk == 2) {
                this.popupMenuSelectedIndex = 0;
                this.showPopupMenu = true;
                this.popupMenuNum = 1;
                return;
            }
        } else if (this.gameState == 7 || this.gameState == 5) {
            if (sk == 1) {
                if (this.gameState == 5) {
                    ++this.gameHandsDoubled;
                }
                this.parent.redealDoubleUpHand();
                if (this.gameState == 7) {
                    this.doubleUpWinnings *= 2;
                }
                this.gameState = 6;
                this.doubleUpPopupString = "Playing for $" + this.doubleUpWinnings;
                this.doubleUpPopupString2 = "Pick a higher card!";
                this.doubleUpPopupString3 = "";
                this.doubleUpSelectedIndex = 0;
            } else if (sk == 2) {
                this.gameState = 4;
                if (this.doubleUpRoundsCleared == 0) {
                    this.cash += this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                    this.winnings = this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                } else {
                    ++this.gameHandsDoubledWon;
                    this.cash += this.doubleUpWinnings;
                    this.winnings = this.doubleUpWinnings;
                }
                this.gameTotalWinnings += this.winnings;
            }
        } else if (this.gameState == 6) {
            if (sk == 1) {
                int r1 = this.doubleUpHand.getUnsortedCard(0).getRank();
                int r2 = this.doubleUpHand.getUnsortedCard(this.doubleUpSelectedIndex + 1).getRank();
                ++this.doubleUpRoundsCleared;
                if (r1 == 1) {
                    r1 = 14;
                }
                if (r2 == 1) {
                    r2 = 14;
                }
                if (r2 > r1) {
                    Common.doSound("win_double");
                    this.gameState = 7;
                    this.doubleUpPopupString = "You've won $" + this.doubleUpWinnings;
                    this.doubleUpPopupString2 = "Double to $" + 2 * this.doubleUpWinnings + "?";
                    this.doubleUpPopupString3 = "";
                } else if (r2 == r1) {
                    this.gameState = 7;
                    this.doubleUpWinnings /= 2;
                    this.doubleUpPopupString = "Tie wins $" + this.doubleUpWinnings;
                    this.doubleUpPopupString2 = "Double to $" + 2 * this.doubleUpWinnings + "?";
                    this.doubleUpPopupString3 = "";
                } else {
                    Common.doSound("lose_double");
                    this.gameState = 8;
                    this.doubleUpPopupString = "Better luck next time";
                    this.doubleUpPopupString2 = "";
                    this.doubleUpPopupString3 = "";
                    this.doubleUpWinnings = 0;
                }
                return;
            }
            if (sk == 2) {
                this.popupMenuSelectedIndex = 0;
                this.showPopupMenu = true;
                this.popupMenuNum = 1;
                return;
            }
        }
        if (this.gameState == 0) {
            if (ga == 2) {
                this.selectedButton = this.selectedButton == 0 ? 2 : this.selectedButton - 1;
            } else if (ga == 5) {
                this.selectedButton = this.selectedButton == 2 ? 0 : this.selectedButton + 1;
            } else if (ga == 8) {
                if (this.selectedButton == 0) {
                    this.bet = this.bet == 5 ? 1 : this.bet + 1;
                    Common.doSound("coin");
                } else if (this.selectedButton == 2) {
                    this.bet = 5;
                    this.deal(false);
                } else {
                    this.deal(false);
                }
            }
        } else if (this.gameState == 2) {
            if (ga == 2) {
                this.selectedCard = this.selectedCard == 0 ? 4 : this.selectedCard - 1;
            } else if (ga == 5) {
                this.selectedCard = this.selectedCard == 4 ? 0 : this.selectedCard + 1;
            } else if (ga == 8) {
                if (this.holdCards[this.selectedCard]) {
                    Common.doSound("woodblock_low.mid", "audio/midi");
                } else {
                    Common.doSound("woodblock_high.mid", "audio/midi");
                }
                this.holdCards[this.selectedCard] = !this.holdCards[this.selectedCard];
            }
        } else if (this.gameState == 6) {
            if (ga == 2) {
                this.doubleUpSelectedIndex = this.doubleUpSelectedIndex == 0 ? 3 : this.doubleUpSelectedIndex - 1;
            } else if (ga == 5) {
                this.doubleUpSelectedIndex = this.doubleUpSelectedIndex == 3 ? 0 : this.doubleUpSelectedIndex + 1;
            } else if (ga == 8) {
                int r1 = this.doubleUpHand.getUnsortedCard(0).getRank();
                int r2 = this.doubleUpHand.getUnsortedCard(this.doubleUpSelectedIndex + 1).getRank();
                ++this.doubleUpRoundsCleared;
                if (r1 == 1) {
                    r1 = 14;
                }
                if (r2 == 1) {
                    r2 = 14;
                }
                if (r2 > r1) {
                    Common.doSound("win_double");
                    this.gameState = 7;
                    this.doubleUpPopupString = "You've won $" + this.doubleUpWinnings;
                    this.doubleUpPopupString2 = "Double to $" + 2 * this.doubleUpWinnings + "?";
                    this.doubleUpPopupString3 = "";
                } else if (r2 == r1) {
                    this.gameState = 7;
                    this.doubleUpWinnings /= 2;
                    this.doubleUpPopupString = "Tie wins $" + this.doubleUpWinnings;
                    this.doubleUpPopupString2 = "Double to $" + 2 * this.doubleUpWinnings + "?";
                    this.doubleUpPopupString3 = "";
                } else {
                    Common.doSound("lose_double");
                    this.gameState = 8;
                    this.doubleUpPopupString = "Better luck next time";
                    this.doubleUpPopupString2 = "";
                    this.doubleUpPopupString3 = "";
                    this.doubleUpWinnings = 0;
                }
            }
        }
    }

    public void activatePopupMenu() {
        if (this.popupMenuNum == 0) {
            if (this.popupMenuSelectedIndex == 0) {
                this.showHint = this.POPUP_REVEAL;
                this.showHintType = this.POPUP_HINT;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
                this.boxW = 220;
                this.boxH = 280;
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.boxFrame = this.boxNumFrames;
                }
            } else if (this.popupMenuSelectedIndex == 1) {
                this.showHint = this.POPUP_REVEAL;
                this.showHintType = this.POPUP_STATS;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
                this.boxW = 220;
                this.boxH = 280;
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.boxFrame = this.boxNumFrames;
                }
            } else if (this.popupMenuSelectedIndex == 2) {
                this.parent.displayMainMenu();
            }
        } else if (this.popupMenuNum == 1) {
            if (this.popupMenuSelectedIndex == 0) {
                this.showHint = this.POPUP_REVEAL;
                this.showHintType = this.POPUP_STATS;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
                this.boxW = 220;
                this.boxH = 280;
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.boxFrame = this.boxNumFrames;
                }
            } else if (this.popupMenuSelectedIndex == 1) {
                this.parent.displayMainMenu();
            }
        }
        this.showPopupMenu = false;
    }

    public void setHand(Hand h) {
        this.hand = h;
    }

    public void setDoubleUpHand(Hand h) {
        this.doubleUpHand = h;
    }

    public void deal(boolean warningCleared) {
        if (this.gameState == 0) {
            if (this.cash < this.bet * this.coinValue) {
                this.showHint = this.POPUP_REVEAL;
                this.showHintType = this.POPUP_NO_CASH;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
                this.boxW = 200;
                this.boxH = 150;
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.boxFrame = this.boxNumFrames;
                }
                return;
            }
            this.cash -= this.bet * this.coinValue;
            this.gameTotalBet += this.bet * this.coinValue;
            ++this.gameHandsPlayed;
            this.parent.dealHand();
            this.cardsRevealed = 0;
            this.cardsRevealedTime = System.currentTimeMillis() + (long)this.cardRevealDelay;
            Common.stopSounds();
            Common.doSound("start");
            this.gameState = 1;
        } else if (this.gameState == 2) {
            if (!warningCleared && Common.perfectPlayWarningEnabled) {
                for (int i = 0; i < 5; ++i) {
                    if (this.holdCards[i] == this.holdCardSuggestions[i]) continue;
                    this.showHint = this.POPUP_REVEAL;
                    this.showHintType = this.POPUP_WARNING;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 150;
                    if (Settings.DISABLE_ANIMATING_PANELS) {
                        this.boxFrame = this.boxNumFrames;
                    }
                    return;
                }
            }
            this.parent.redealHand();
            this.cardsRevealed = 0;
            this.cardsRevealedTime = System.currentTimeMillis() + (long)this.cardRevealDelay;
            while (this.holdCards[this.cardsRevealed]) {
                ++this.cardsRevealed;
                if (this.cardsRevealed != 5) continue;
            }
            if (this.cardsRevealed >= 5) {
                this.gameState = 4;
                this.finishedGame();
            } else {
                this.gameState = 3;
            }
        }
    }

    public void finishedGame() {
        Common.log("Finished @ " + System.currentTimeMillis());
        this.currentHandType = this._currentHandType;
        if (this.currentHandType < 0) {
            Common.doSound("lose");
        } else {
            if (this.currentHandType >= 3) {
                Common.doSound("win_big");
            } else {
                Common.doSound("win_small");
            }
            ++this.gameHandsWon;
            if (this.gameBestHand < this.currentHandType) {
                this.gameBestHand = this.currentHandType;
            }
            if (Common.doubleOrNothingEnabled) {
                this.gameState = 5;
                this.doubleUpWinnings = 2 * (this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue);
                this.doubleUpPopupString = HandEvaluator.HAND_NAMES[this.currentHandType];
                this.doubleUpPopupString2 = "Wins $" + this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                this.doubleUpPopupString3 = "Double up to $" + this.doubleUpWinnings + "?";
            } else {
                this.doubleUpPopupString = HandEvaluator.HAND_NAMES[this.currentHandType] + " wins $" + this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                this.cash += this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                this.winnings = this.parent.getPayout(this.bet, this.currentHandType) * this.coinValue;
                this.gameTotalWinnings += this.winnings;
                this.gameState = 9;
            }
        }
    }

    public boolean isHeld(int cardNum) {
        return this.holdCards[cardNum];
    }

    public void setHandType(int t) {
        this._currentHandType = t;
    }

    public void setStrategy(String s) {
        this.strategyString = s;
    }

    public void setStrategyDescription(String s) {
        this.strategyDescriptionString = s;
    }

    public void setStrategyExample(String s) {
        this.strategyExampleString = s;
    }

    public void setHoldCards(int[] cards) {
        for (int i = 0; i < cards.length; ++i) {
            this.holdCardSuggestions[cards[i]] = true;
        }
    }

    public String formatTimeString(long t) {
        long hours = t / 3600000L;
        long mins = (t -= hours * 3600000L) / 60000L;
        long secs = (t -= mins * 60000L) / 1000L;
        return hours + "h " + mins + "m " + secs + "s";
    }

    public String formatDateString(long t) {
        Date d = new Date(t);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        String am_pm = "";
        if (c.get(9) == 0) {
            am_pm = "am";
        } else if (c.get(9) == 1) {
            am_pm = "pm";
        }
        return c.get(5) + " " + Common.MONTHS[c.get(2)] + " " + c.get(1) + " " + c.get(10) + ":" + this.pad(c.get(12)) + am_pm;
    }

    public String pad(int i) {
        if (i < 10) {
            return "0" + Integer.toString(i);
        }
        return Integer.toString(i);
    }

    public void savePokerCanvasGameState() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            os.writeInt(this.cash);
            os.writeInt(this.bet);
            os.writeLong(this.gameStartDate);
            os.writeLong(this.gameStartTime);
            os.writeLong(System.currentTimeMillis());
            os.writeInt(this.gameHandsPlayed);
            os.writeInt(this.gameHandsWon);
            os.writeInt(this.gameBestHand);
            os.writeInt(this.gameTotalWinnings);
            os.writeInt(this.gameTotalBet);
            os.writeInt(this.gameHandsDoubled);
            os.writeInt(this.gameHandsDoubledWon);
            RecordManager.save(baos.toByteArray(), "game_state");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadPokerCanvasGameState() {
        try {
            if (RecordManager.exists("game_state")) {
                DataInputStream is = new DataInputStream(new ByteArrayInputStream(RecordManager.load("game_state")));
                this.cash = is.readInt();
                this.bet = is.readInt();
                this.gameStartDate = is.readLong();
                this.gameStartTime = is.readLong();
                long tmp = is.readLong();
                long diff = System.currentTimeMillis() - tmp;
                this.gameStartTime += diff;
                this.gameHandsPlayed = is.readInt();
                this.gameHandsWon = is.readInt();
                this.gameBestHand = is.readInt();
                this.gameTotalWinnings = is.readInt();
                this.gameTotalBet = is.readInt();
                this.gameHandsDoubled = is.readInt();
                this.gameHandsDoubledWon = is.readInt();
                this.reset();
                this._cash = this.cash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean roundInPlay() {
        return this.gameState != 0 && this.gameState != 9 && this.gameState != 10 && this.gameState != 8;
    }
}

